/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.filters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.jigsaw.filters.Cache;
import org.w3c.jigsaw.filters.CacheException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.util.LRUNode;
import org.w3c.www.http.HttpEntityTag;

class CacheEntry
extends LRUNode {
    private String url;
    byte[] content;
    Reply reply;
    private int maxage;

    CacheEntry(Request request, Reply reply, int n) throws CacheException {
        this.url = Cache.getNormalizedURL(request);
        try {
            this.readContent(reply);
        }
        catch (IOException iOException) {
            throw new CacheException("cannot read reply content");
        }
        this.reply = (Reply)reply.getClone();
        this.reply.setStream((InputStream)null);
        long l = this.reply.getDate();
        if (l == -1L) {
            l = System.currentTimeMillis();
            l -= l % 1000L;
            this.reply.setDate(l);
        }
        this.setMaxAge(reply, n);
    }

    int getAge() {
        int n = this.reply.getAge();
        long l = -1L;
        long l2 = this.reply.getDate();
        if (l2 != -1L) {
            l = System.currentTimeMillis();
            l -= l2;
            l /= 1000L;
        }
        return (long)n >= l ? n : (int)l;
    }

    Reply getReply(Request request) {
        Reply reply = (Reply)this.reply.getClone();
        int n = this.getAge();
        if (n != -1) {
            reply.setAge(n);
        }
        boolean bl = false;
        HttpEntityTag[] httpEntityTagArray = request.getIfNoneMatch();
        HttpEntityTag httpEntityTag = this.reply.getETag();
        if (httpEntityTagArray != null && httpEntityTag != null) {
            boolean bl2 = true;
            String string = httpEntityTag.getTag();
            int n2 = 0;
            while (n2 < httpEntityTagArray.length) {
                if (string.equals(httpEntityTagArray[n2].getTag())) {
                    bl2 = false;
                    break;
                }
                ++n2;
            }
            bl = bl2 ^ true;
        } else {
            long l = request.getIfModifiedSince();
            long l2 = this.reply.getLastModified();
            if (l != -1L && l2 != -1L) {
                boolean bl3 = bl = l2 > l;
            }
        }
        if (bl) {
            System.out.println("**** replying NOT_MODIFIED");
            reply.setStatus(304);
        } else if (!request.getMethod().equals("HEAD")) {
            reply.setStream(new ByteArrayInputStream(this.content));
        } else {
            reply.setStream((InputStream)null);
        }
        return reply;
    }

    final Reply getReply(Request request, Reply reply) {
        System.out.println("**** Validated entry");
        this.setMaxAge(reply);
        long l = reply.getDate();
        if (l == -1L) {
            l = System.currentTimeMillis();
            l -= l % 1000L;
        }
        this.reply.setDate(l);
        return this.getReply(request);
    }

    public final int getSize() {
        return this.content.length;
    }

    public final String getURL() {
        return this.url;
    }

    boolean isFresh(Request request) {
        int n = this.getAge();
        System.out.println("**** age: " + n + " maxage: " + this.maxage);
        return n != -1 ? this.maxage > n : this.maxage > 0;
    }

    void makeConditional(Request request) {
        long l;
        System.out.println("**** Making conditional request for validation");
        HttpEntityTag[] httpEntityTagArray = new HttpEntityTag[]{this.reply.getETag()};
        if (httpEntityTagArray[0] != null) {
            request.setIfNoneMatch(httpEntityTagArray);
        }
        if ((l = this.reply.getLastModified()) != -1L) {
            request.setIfModifiedSince(l);
        }
    }

    private void readContent(Reply reply) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        InputStream inputStream = reply.openStream();
        byteArrayOutputStream = reply.hasContentLength() ? new ByteArrayOutputStream(reply.getContentLength()) : new ByteArrayOutputStream(8192);
        byte[] byArray = new byte[4096];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        byteArrayOutputStream.close();
        this.content = byteArrayOutputStream.toByteArray();
        reply.setStream(new ByteArrayInputStream(this.content));
    }

    private void setMaxAge(Reply reply) {
        this.setMaxAge(reply, this.maxage);
    }

    private void setMaxAge(Reply reply, int n) {
        this.maxage = reply.getMaxAge();
        if (this.maxage == -1) {
            long l = reply.getExpires();
            long l2 = reply.getDate();
            if (l != -1L && l2 != -1L) {
                this.maxage = (int)(reply.getExpires() - reply.getDate());
                if (this.maxage < 0) {
                    this.maxage = 0;
                }
            } else {
                this.maxage = n;
            }
        }
    }

    public String toString() {
        return "[\"" + this.url + "\" " + this.maxage + "]";
    }
}

