#define INITIAL 0
#define CDATA 1
#define TAG 2
#define ATTR 3
#define ATTRVAL 4
#define MD 5
#define COM 6
#define DS 7
case 1:
YY_USER_ACTION
# line 149 "sgml.l"
{
                                  enum { MAX_DIGITS = 20,
				       MAX_CNUM = 255 /*@@*/ };
                                  if(yyleng - 2 < MAX_DIGITS){
				    int cnum;
				    char d[MAX_DIGITS+1];
				    memcpy(d, yytext + 2, yyleng - 2);
				    d[yyleng - 2] = 0;
				    cnum = atoi(d);

				    if(cnum > MAX_CNUM){
				      ERROR(SGML_ERROR,
					    "character reference out of range",
					    yytext, yyleng);
				    }else{
				      const char c = cnum;
				      TOK(tokF, tokObj, SGML_DATA,
					  &c, 1);
				    }
				  }else{
				    ERROR(SGML_ERROR,
					  "character reference out of range",
					  yytext, yyleng);
				  }
				}
	YY_BREAK
  /* &#60xyz. -- syntax error */
case 2:
YY_USER_ACTION
# line 177 "sgml.l"
{
                                 ERROR(SGML_ERROR,
				       "bad character in character reference",
				       yytext, yyleng);
			       }
	YY_BREAK
  /* &#SPACE; -- named character reference. Not supported. */
case 3:
YY_USER_ACTION
# line 185 "sgml.l"
{
                         ERROR(SGML_LIMITATION,
			       "named character references are not supported",
			       yytext, yyleng);
		       }
	YY_BREAK
  /* &amp; -- general entity reference */
case 4:
YY_USER_ACTION
# line 193 "sgml.l"
{

                   /* normalize the name by
		    * striking any trailing REFC (";")
		    */
                   if(yytext[yyleng-1] == ';'
		      || yytext[yyleng-1] == '\n'){
		     yyleng--;
		   }
		   
		   TOK(auxF, auxObj, SGML_GEREF, yytext, yyleng);
		 }
	YY_BREAK
  /* </title> -- end tag */
case 5:
YY_USER_ACTION
# line 207 "sgml.l"
{
                                  ADD(SGML_END, yytext, yyleng);
				  BEGIN(TAG);
				}
	YY_BREAK
  /* </> -- empty end tag */
case 6:
YY_USER_ACTION
# line 213 "sgml.l"
{
                         ERROR(SGML_LIMITATION,
			       "empty end tag not supported",
			       yytext, yyleng);
		       }
	YY_BREAK
  /* <!DOCTYPE -- markup declaration */
case 7:
YY_USER_ACTION
# line 220 "sgml.l"
{
                                  ADD(SGML_MARKUP_DECL, yytext, yyleng);
				  BEGIN(MD);
				}
	YY_BREAK
  /* <!> -- empty comment */
case 8:
YY_USER_ACTION
# line 226 "sgml.l"
{ }
	YY_BREAK
  /* <!--  -- comment declaration */
case 9:
yy_c_buf_p = yy_cp = yy_bp + 2;
YY_DO_BEFORE_ACTION; /* set up yytext again */
YY_USER_ACTION
# line 229 "sgml.l"
{
				 BEGIN(COM);
				}
	YY_BREAK
  /* <![ -- marked section */
case 10:
YY_USER_ACTION
# line 234 "sgml.l"
{
                        ERROR(SGML_LIMITATION,
			      "marked sections not supported",
			       yytext, yyleng);
		      }
	YY_BREAK
  /* ]]> -- marked section end */
case 11:
YY_USER_ACTION
# line 241 "sgml.l"
{
                        ERROR(SGML_ERROR,
			      "unmatched marked sections end",
			       yytext, yyleng);
		      }
	YY_BREAK
  /* <? ...> -- processing instruction */
case 12:
YY_USER_ACTION
# line 248 "sgml.l"
{
                                  TOK(auxF, auxObj, SGML_PI, yytext, yyleng);
				}
	YY_BREAK
  /* <name -- start tag */
case 13:
YY_USER_ACTION
# line 252 "sgml.l"
{
                                  ADD(SGML_START, yytext, yyleng);
				  BEGIN(ATTR);
				}
	YY_BREAK
  /* <> -- empty start tag */
case 14:
YY_USER_ACTION
# line 259 "sgml.l"
{
                         ERROR(SGML_LIMITATION,
			       "empty start tag not supported",
			       yytext, yyleng);
		       }
	YY_BREAK
  /* abcd -- data characters */
case 15:
YY_USER_ACTION
# line 266 "sgml.l"
{
                                  TOK(tokF, tokObj, SGML_DATA, yytext, yyleng);
				}
	YY_BREAK
  /* abcd -- data characters */
case 16:
YY_USER_ACTION
# line 271 "sgml.l"
{
                                  TOK(tokF, tokObj, SGML_DATA, yytext, yyleng);
				}
	YY_BREAK
 /* 7.4 Start Tag */
 /* Actually, the generic identifier specification is consumed
  * along with the STAGO delimiter ("<"). So we're only looking
  * for tokens that appear in an attribute specification list,
  * plus TAGC (">"). NET ("/") and STAGO ("<") signal application
  * convention errors.
  */
 /* 7.5 End Tag */
 /* Just looking for TAGC. NET, STAGO as above */
  /* <a^ > -- space */
case 17:
YY_USER_ACTION
# line 287 "sgml.l"
{ }
	YY_BREAK
  /* <a ^href = "xxx"> -- attribute name */
case 18:
YY_USER_ACTION
# line 290 "sgml.l"
{
                                  /* strip trailing space and = */
                                  while(yytext[yyleng-1] == '='
					|| isspace(yytext[yyleng-1])){
				    --yyleng;
				  }

                                  ADD(SGML_ATTRNAME, yytext, yyleng);
				  BEGIN(ATTRVAL);
				}
	YY_BREAK
  /* <img src="xxx" ^ismap> -- name */
case 19:
YY_USER_ACTION
# line 302 "sgml.l"
{
                                  ADD(SGML_ATTRNAME, NULL, 0);
                                  ADD(SGML_NAME, yytext, yyleng);
				}
	YY_BREAK
  /* <a name = ^xyz> -- name token */
case 20:
YY_USER_ACTION
# line 308 "sgml.l"
{
                                  ADD(SGML_NMTOKEN, yytext, yyleng);
				  BEGIN(ATTR);
				}
	YY_BREAK
  /* <a href = ^"a b c"> -- literal */
case 21:
YY_USER_ACTION
# line 314 "sgml.l"
{
                                  ADD(SGML_LITERAL, yytext, yyleng);
				  BEGIN(ATTR);
				}
	YY_BREAK
  /* <a name= ^> -- illegal tag close */
case 22:
YY_USER_ACTION
# line 320 "sgml.l"
{
                                  ERROR(SGML_ERROR,
		       "Tag close found where attribute value expected",
			       yytext, yyleng);

                                  CALLBACK(tokF,tokObj);
				  BEGIN(INITIAL);
				}
	YY_BREAK
  /* <a name=foo ^>,</foo^> -- tag close */
case 23:
YY_USER_ACTION
# line 330 "sgml.l"
{
                                  CALLBACK(tokF,tokObj);
				  BEGIN(INITIAL);
				}
	YY_BREAK
  /* <em^/ -- NET tag */
case 24:
YY_USER_ACTION
# line 336 "sgml.l"
{
                         ERROR(SGML_LIMITATION,
			       "NET tags not supported",
			       yytext, yyleng);

			 CALLBACK(tokF, tokObj);
			 BEGIN(INITIAL);
		       }
	YY_BREAK
  /* <foo^<bar> -- unclosed start tag */
case 25:
YY_USER_ACTION
# line 346 "sgml.l"
{
                         ERROR(SGML_LIMITATION,
			       "Unclosed tags not supported",
			       yytext, yyleng);

                         /* report pending tag */
			 CALLBACK(tokF, tokObj);
			 BEGIN(INITIAL);
		       }
	YY_BREAK
case 26:
YY_USER_ACTION
# line 356 "sgml.l"
{
                         ERROR(SGML_ERROR,
			       "bad character in tag",
			       yytext, yyleng);
		       }
	YY_BREAK
 /* 10 Markup Declarations: General */
 /* 10.1.1 Parameter Separator */
case 27:
YY_USER_ACTION
# line 365 "sgml.l"
{ }
	YY_BREAK
 /* <!^--...-->   -- comment */
case 28:
YY_USER_ACTION
# line 367 "sgml.l"
{
                                  TOK(auxF, auxObj, SGML_COMMENT, yytext, yyleng);
				}
	YY_BREAK
case 29:
YY_USER_ACTION
# line 371 "sgml.l"
{
				  BEGIN(INITIAL);
			        }
	YY_BREAK
 /* <!doctype ^%foo;> -- parameter entity reference */
case 30:
YY_USER_ACTION
# line 376 "sgml.l"
{
                         ERROR(SGML_LIMITATION,
			       "parameter entity reference not supported",
			       yytext, yyleng);
		       }
	YY_BREAK
 /* The limited set of markup delcarations we're interested in
  * use only numbers, names, and literals.
  */
case 31:
YY_USER_ACTION
# line 385 "sgml.l"
{
                                  ADD(SGML_NUMBER, yytext, yyleng);
				}
	YY_BREAK
case 32:
YY_USER_ACTION
# line 389 "sgml.l"
{
                                  ADD(SGML_NAME, yytext, yyleng);
				}
	YY_BREAK
case 33:
YY_USER_ACTION
# line 393 "sgml.l"
{
                                  ADD(SGML_LITERAL, yytext, yyleng);
				}
	YY_BREAK
case 34:
YY_USER_ACTION
# line 397 "sgml.l"
{
                                  CALLBACK(auxF, auxObj);
				  BEGIN(INITIAL);
			        }
	YY_BREAK
 /* other constructs are errors. */
   /* <!doctype foo ^[  -- declaration subset */
case 35:
YY_USER_ACTION
# line 404 "sgml.l"
{
                         ERROR(SGML_LIMITATION,
			       "declaration subset not supported",
			       yytext, yyleng);
			 BEGIN(DS);
		       }
	YY_BREAK
case 36:
YY_USER_ACTION
# line 411 "sgml.l"
{
                         ERROR(SGML_ERROR,
			       "illegal character in markup declaration",
			       yytext, yyleng);
		       }
	YY_BREAK
 /* 10.4 Marked Section Declaration */
 /* 11.1 Document Type Declaration Subset */
 /* Our parsing of declaration subsets is just an error recovery technique:
  * we attempt to skip them, but we may be fooled by "]"s
  * inside comments, etc.
  */
  /* ]]> -- marked section end */
case 37:
YY_USER_ACTION
# line 427 "sgml.l"
{
				 BEGIN(INITIAL);
				}
	YY_BREAK
  /* ] -- declaration subset close */
case 38:
YY_USER_ACTION
# line 431 "sgml.l"
{ BEGIN(COM); }
	YY_BREAK
case 39:
YY_USER_ACTION
# line 433 "sgml.l"
{
                         ERROR(SGML_LIMITATION,
			       "declaration subset: skipping",
			       yytext, yyleng);
		       }
	YY_BREAK
case 40:
YY_USER_ACTION
# line 439 "sgml.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
