/* $Id: sgml_lex.h,v 1.3 1995/10/11 03:23:43 connolly Exp $ */

#ifndef __sgml_lex_h
#define __sgml_lex_h

/*
 * Interface to Basic SGML lexer.
 * For theory of operation, see W3C tech report:
 *
 *   "A Lexical Analyzer for HTML and Basic SGML"
 *   http://www.w3.org/team/WWW/MarkUp/SGML/sgml-lex/sgml-lex.html
 */

#include <stdlib.h>

typedef struct _SGML_Lexer SGML_Lexer;

typedef enum {
  SGML_EOF,
  SGML_DATA, SGML_START, SGML_END,
  SGML_ATTRNAME, SGML_NAME, SGML_NUMBER, SGML_NMTOKEN, SGML_LITERAL,
  SGML_GEREF,
  SGML_PI,
  SGML_MARKUP_DECL, SGML_COMMENT,
  SGML_LIMITATION, SGML_ERROR,
  SGML_MAXTOK
}SGML_TokType;

typedef const char* SGML_String; /* anybody know another
				    way to declare a pointer
				    to a const char*? */

/* Callback function */
typedef void (*SGML_LexFunc)(void *rock, int qty, 
			     SGML_TokType types[],
			     SGML_String strings[],
			     size_t lengths[]);


/* Create an SGML_Lexer */
SGML_Lexer *SGML_newLexer(void);

/* Destroy an SGML_Lexer */
void SGML_delLexer(SGML_Lexer *l);

/* Main lexer function */
/* On the last call to SGML_lex, pass len=0.
 * @# any unclosed markup isn't reported (e.g. <xxx)
 */
void SGML_lex(SGML_Lexer *lexer,
	      const char *encoded_chars, size_t len,
	      /* @# character encoding args? */
	      SGML_LexFunc elementF, void *eltObj,
	      SGML_LexFunc auxF, void *auxObj,
	      SGML_LexFunc errF, void *errObj);


/* Sample callback function */
void SGML_dumpEvent(void *rock, int qty,
		    SGML_TokType types[],
		    SGML_String strings[],
		    size_t lengths[]);


#endif /* __sgml_lex_h */
