/* $Id: sgml_dumpevent.c,v 1.1 1995/10/11 03:23:41 connolly Exp $ */

/* exports... */
#include "sgml_lex.h"

/* imports... */
#include <stdio.h>
#include <assert.h>

/*
 * This is an example of an SGML_LexFunc.
 * rock should be a null-terminated string
 */

void
SGML_dumpEvent(void *rock, int qty,
	       SGML_TokType *types, SGML_String *strings, size_t *lengths)
{
  int i,j;
  const char *indent = "";
  const char *token_names[] = {
    NULL,
    "Data", "Start Tag", "End Tag",
    "Attr Name", "Name", "Number", "Name Token", "Literal",
    "Entity",
    "Processing Instruction",
    "Markup Decl", "Comment",
    "!!Limitation!!", "!!Error!!"
  };

#define ARRAY_SIZE(x) (sizeof(x)/sizeof(x[0]))

  assert(ARRAY_SIZE(token_names) == SGML_MAXTOK);

  for(i = 0; i < qty; i++){

    if(i == 0){
      printf("\n[%s]\n", (const char*)rock);
    }

    /* @@ hmmm... this .* may require __GNUC__ */
    printf("%s%s: `", indent, token_names[types[i]]);

    for(j=0; j < lengths[i]; j++){
      putchar(strings[i][j]);
    }

    printf("'\n");
    indent = "  ";
  }
}


