/*****************************************************************************/
/* td_mod_tree_equal.c : Objet Gtk+
 * td_mod_tree_equal.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "td_mod_tree.h"
#include "td_mod_tree_equal.h"


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_mod_tree_equal_init (TdModTreeEqual *mod_tree_equal)
{
  mod_tree_equal->column = NULL;
  mod_tree_equal->value = NULL;
}

static void td_mod_tree_equal_class_init (TdModTreeEqualClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  klass->add = td_mod_tree_equal_add;
}

GtkType td_mod_tree_equal_get_type (void)
{
  static GtkType mod_tree_equal_type = 0;
  if (!mod_tree_equal_type)
    {
      static const GtkTypeInfo mod_tree_equal_info =
      {
  	"TdModTreeEqual", sizeof (TdModTreeEqual), sizeof (TdModTreeEqualClass),
  	(GtkClassInitFunc) td_mod_tree_equal_class_init,
	(GtkObjectInitFunc) td_mod_tree_equal_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      mod_tree_equal_type = gtk_type_unique (GTK_TYPE_OBJECT, &mod_tree_equal_info);
    }
  return mod_tree_equal_type;
}

GtkObject *td_mod_tree_equal_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_mod_tree_equal_get_type ()));
}


/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_mod_tree_equal_add (TdModTreeEqual *mod_tree_equal, int column, gchar *value)
{
  g_return_if_fail (mod_tree_equal != NULL);
  g_return_if_fail (TD_IS_MOD_TREE_EQUAL (mod_tree_equal));
  mod_tree_equal->column = g_list_append (mod_tree_equal->column, GINT_TO_POINTER (column));
  mod_tree_equal->value = g_list_append (mod_tree_equal->value, value);
}

/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
gboolean td_mod_tree_equal_test_node (TdModTreeEqual *mod_tree_equal, GtkObject *mod_tree)
{
  gboolean ret;
  gchar *value_tmp;
  GdkPixmap *pixmap_tampon;
  GdkBitmap *mask_tampon;
  guint8 spacing_tampon;
  int j;

  /* Test des galites */
  if (!TD_MOD_TREE (mod_tree)->selected)
    return FALSE;
  ret = TRUE;
  for (j=0; j<g_list_length (mod_tree_equal->value); j++)
    {
      if (g_list_nth_data (mod_tree_equal->column, j) == 0)
	gtk_ctree_node_get_pixtext (GTK_CTREE (GTK_BIN (TD_MOD_TREE (mod_tree)->widget)->child), TD_MOD_TREE (mod_tree)->selected, 0, &value_tmp, &spacing_tampon, &pixmap_tampon, &mask_tampon);
      else
	gtk_ctree_node_get_text (GTK_CTREE (GTK_BIN (TD_MOD_TREE (mod_tree)->widget)->child), TD_MOD_TREE (mod_tree)->selected, GPOINTER_TO_INT (g_list_nth_data (mod_tree_equal->column, j)), &value_tmp);
      if (strcmp (value_tmp, g_list_nth_data (mod_tree_equal->value, j)))
	{
	  ret = FALSE;
	  break;
	}
    }
  return ret;
}

gboolean td_mod_tree_equal_test_list (TdModTreeEqual *mod_tree_equal, GList *data)
{
  gboolean ret;
  gchar *value_tmp;
  GdkPixmap *pixmap_tampon;
  GdkBitmap *mask_tampon;
  guint8 spacing_tampon;
  int j;

  /* Test des galites */
  ret = TRUE;
  for (j=0; j<g_list_length (mod_tree_equal->value); j++)
    if (strcmp (g_list_nth_data (data, GPOINTER_TO_INT (g_list_nth_data (mod_tree_equal->column, j))), g_list_nth_data (mod_tree_equal->value, j)))
      {
	ret = FALSE;
	break;
      }
  return ret;
}











