/*****************************************************************************/
/* td_mod.h : Objet Gtk+
 * td_mod.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>


/*****************************************************************************/
/* Macros */
/*****************************************************************************/
#define TD_TYPE_MOD (td_mod_get_type ())
#define TD_MOD(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_MOD, TdMod))
#define TD_MOD_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_MOD, TdModClass))
#define TD_IS_MOD(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_MOD))
#define TD_IS_MOD_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_MOD))

/*****************************************************************************/
/* Structure */
/*****************************************************************************/
typedef struct _TdMod TdMod;
typedef struct _TdModClass TdModClass;

struct _TdMod
{
  GtkObject object;
  gchar *name;
  gchar *name_intl;
  int id;
  gboolean modified;
  GtkWidget *window;
  GtkWidget *toolbar;
  GtkWidget *statusbar;
  GtkWidget *notebook;
  GtkWidget *editprop;
  GList *child;
  GtkObject *about;
  GList *custom;
  GtkObject *custom_browser;
  GtkWidget *custom_notebook;
  GtkWidget *custom_tree;
};

struct _TdModClass
{
  GtkObjectClass parent_class;
  void (*add_child) (TdMod *mod, GtkObject *child);
  void (*set_toolbar) (TdMod *mod, GtkWidget *toolbar);
  void (*set_statusbar) (TdMod *mod, GtkWidget *statusbar);
  void (*set_about) (TdMod *mod, GtkObject *about);
  void (*add_custom) (TdMod *mod, GtkObject *custom);
  void (*show) (TdMod *mod);
};

/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
void td_mod_set_name (TdMod *mod, gchar *name);
void td_mod_set_name_intl (TdMod *mod, gchar *name_intl);
void td_mod_set_id (TdMod *mod, int id);
static void td_mod_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_mod_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_mod_init (TdMod *mod);
static void td_mod_class_init (TdModClass *klass);
GtkType td_mod_get_type (void);
GtkObject *td_mod_new (void);
void td_mod_destroy (TdMod *mod);

/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_mod_add_child (TdMod *mod, GtkObject *child);
void td_mod_set_toolbar (TdMod *mod, GtkWidget *toolbar);
void td_mod_set_statusbar (TdMod *mod, GtkWidget *statusbar);
void td_mod_set_about (TdMod *mod, GtkObject *about);
void td_mod_add_custom (TdMod *mod, GtkObject *custom);

/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
gboolean td_mod_create (TdMod *mod, int id);
gboolean td_mod_hide (TdMod *mod);
void td_mod_show (TdMod *mod);
void td_mod_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, gint page_num, TdMod *mod);
GtkObject *td_mod_get (gchar *file);
void td_mod_custom_show (GtkObject *mod);

