/*****************************************************************************/
/* td_flower.h : Objet Gtk+
 * td_flower.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <parser.h>
#include <tree.h>


/*****************************************************************************/
/* Macros */
/*****************************************************************************/
#define TD_TYPE_FLOWER (td_flower_get_type ())
#define TD_FLOWER(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_FLOWER, TdFlower))
#define TD_FLOWER_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_FLOWER, TdFlowerClass))
#define TD_IS_FLOWER(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_FLOWER))
#define TD_IS_FLOWER_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_FLOWER))

/*****************************************************************************/
/* Structure */
/*****************************************************************************/
typedef struct _TdFlower TdFlower;
typedef struct _TdFlowerClass TdFlowerClass;

struct _TdFlower
{
  GtkObject object;
  gchar *space;
  gchar *root;
  gchar *branch;
  GList *branch_attribut;
  gchar *petal;
  GList *petal_attribut;
  gchar *foliole;
  GList *foliole_attribut;
  GList *items_value;
  GList *items_level;
  gboolean mode_level;
  gboolean mode_type;
  gboolean mode_one_column;
};

struct _TdFlowerClass
{
  GtkObjectClass parent_class;
  void (*add_branch_attribut) (TdFlower *flower, gchar *branch_attribut);
  void (*add_petal_attribut) (TdFlower *flower, gchar *petal_attribut);
  void (*add_foliole_attribut) (TdFlower *flower, gchar *foliole_attribut);
};

/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
void td_flower_set_space (TdFlower *flower, gchar *space);
void td_flower_set_root (TdFlower *flower, gchar *root);
void td_flower_set_branch (TdFlower *flower, gchar *branch);
void td_flower_set_petal (TdFlower *flower, gchar *petat);
void td_flower_set_foliole (TdFlower *flower, gchar *foliole);
void td_flower_set_mode_level (TdFlower *flower, gboolean mode_level);
void td_flower_set_mode_type (TdFlower *flower, gboolean mode_type);
void td_flower_set_mode_one_column (TdFlower *flower, gboolean mode_one_column);
static void td_flower_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_flower_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_flower_init (TdFlower *flower);
static void td_flower_class_init (TdFlowerClass *klass);
GtkType td_flower_get_type (void);
GtkObject *td_flower_new (void);
void td_flower_destroy (TdFlower *flower);

/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_flower_add_branch_attribut (TdFlower *flower, gchar *branch_attribut);
void td_flower_add_petal_attribut (TdFlower *flower, gchar *petal_attribut);
void td_flower_add_foliole_attribut (TdFlower *flower, gchar *foliole_attribut);
void td_flower_add_item (TdFlower *flower, GList *item, int level);

/*****************************************************************************/
/* Fichier */
/*****************************************************************************/
gboolean td_flower_load_file (TdFlower *flower, char *file);
gboolean td_flower_save_file (TdFlower *flower, char *file);
