/*****************************************************************************/
/* td_field_dico.c : Objet Gtk+
 * td_field_dico.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dirent.h>
#include <sys/stat.h>

#include "commons.h"
#include "gtdk.h"

#include "td_field_dico.h"


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_field_dico_init (TdFieldDico *dico)
{
  dico->word = NULL;
  dico->word_intl = NULL;
  dico->word_lang = NULL;
}

static void td_field_dico_class_init (TdFieldDicoClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  klass->add_word_intl = td_field_dico_add_word_intl;
  klass->add_word_lang = td_field_dico_add_word_lang;
}

GtkType td_field_dico_get_type (void)
{
  static GtkType field_dico_type = 0;
  if (!field_dico_type)
    {
      static const GtkTypeInfo field_dico_info =
      {
  	"TdFieldDico", sizeof (TdFieldDico), sizeof (TdFieldDicoClass),
  	(GtkClassInitFunc) td_field_dico_class_init,
	(GtkObjectInitFunc) td_field_dico_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      field_dico_type = gtk_type_unique (GTK_TYPE_OBJECT, &field_dico_info);
    }
  return field_dico_type;
}

GtkObject *td_field_dico_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_field_dico_get_type ()));
}


/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_field_dico_add_word_intl (TdFieldDico *dico, gchar *word, gchar *word_intl)
{
  g_return_if_fail (dico != NULL);
  g_return_if_fail (TD_IS_FIELD_DICO (dico));
  dico->word = g_list_append (dico->word, word);
  dico->word_intl = g_list_append (dico->word_intl, word_intl);
}

void td_field_dico_add_word_lang (TdFieldDico *dico, gchar *word)
{
  g_return_if_fail (dico != NULL);
  g_return_if_fail (TD_IS_FIELD_DICO (dico));
  dico->word = g_list_append (dico->word, word);
}


/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
gchar *td_field_dico_2intl (TdFieldDico *dico, gchar *word)
{
  int i;
  for (i=0; i<g_list_length (dico->word); i++)
    if (!strcmp (word, g_list_nth_data (dico->word, i)))
      return (g_list_nth_data (dico->word_intl, i));
  return word;
}

gchar *td_field_dico_intl2 (TdFieldDico *dico, gchar *word)
{
  int i;
  for (i=0; i<g_list_length (dico->word); i++)
    if (!strcmp (word, g_list_nth_data (dico->word_intl, i)))
      return (g_list_nth_data (dico->word, i));
  return word;
}

/*  GList *td_field_dico_fix2intl (TdFieldDico *dico, GList *data_fix) */
/*  { */
/*    int i; */
/*    gchar *ret; */
/*    GList *data_intl = NULL; */
/*    for (i=0; i<g_list_length (data_fix); i++) */
/*      { */
/*        if (!strcmp (g_list_nth_data (data_fix, i), g_list_nth_data (dico->word, i))) */
/*  	data_intl = g_list_append (data_intl, g_list_nth_data (dico->word_intl, i)); */
/*        else */
/*  	data_intl = g_list_append (data_intl, g_list_nth_data (dico->word, i)); */
/*      } */
/*    return data_intl; */
/*  } */

/*  GList *td_field_dico_intl2fix (TdFieldDico *dico, GList *data_intl) */
/*  { */
/*    int i; */
/*    GList *data_fix = NULL; */
/*    for (i=0; i<g_list_length (data_intl); i++) */
/*      { */
/*        if (!strcmp (g_list_nth_data (data_intl, i), g_list_nth_data (dico->word, i))) */
/*  	data_fix = g_list_append (data_fix, g_list_nth_data (dico->word, i)); */
/*        else */
/*  	data_fix = g_list_append (data_fix, g_list_nth_data (dico->word_intl, i)); */
/*      } */
/*    return data_fix; */
/*  } */


