/*****************************************************************************/
/* td_db_mod_field.h : Objet Gtk+
 * td_db_mod_field.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "td_db_mod_field.h"


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_TABLE_FIELD,
};

void td_db_mod_field_set_name (TdDbModField *db_mod_field, gchar *name)
{
  g_return_if_fail (db_mod_field != NULL);
  g_return_if_fail (TD_IS_DB_MOD_FIELD (db_mod_field));
  if (db_mod_field->name != name)
    db_mod_field->name = name;
}

void td_db_mod_field_set_table_field (TdDbModField *db_mod_field, gchar *table_field)
{
  g_return_if_fail (db_mod_field != NULL);
  g_return_if_fail (TD_IS_DB_MOD_FIELD (db_mod_field));
  if (db_mod_field->table_field != table_field)
    db_mod_field->table_field = table_field;
}

static void td_db_mod_field_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbModField *db_mod_field;
  db_mod_field = TD_DB_MOD_FIELD (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_db_mod_field_set_name (db_mod_field, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TABLE_FIELD:
      td_db_mod_field_set_table_field (db_mod_field, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_db_mod_field_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbModField *db_mod_field;
  db_mod_field = TD_DB_MOD_FIELD (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = db_mod_field->name;
      break;
    case ARG_TABLE_FIELD:
      GTK_VALUE_STRING (*arg) = db_mod_field->table_field;
      break;
    }
}


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_db_mod_field_init (TdDbModField *db_mod_field)
{
  db_mod_field->name = NULL;
  db_mod_field->table_field = NULL;
  db_mod_field->property_name = NULL;
  db_mod_field->property_value = NULL;
}

static void td_db_mod_field_class_init (TdDbModFieldClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdDbModField::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdDbModField::table_field", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TABLE_FIELD);
  object_class->set_arg = td_db_mod_field_set_arg;
  object_class->get_arg = td_db_mod_field_get_arg;
  klass->add_property = td_db_mod_field_add_property;
}

GtkType td_db_mod_field_get_type (void)
{
  static GtkType db_mod_field_type = 0;
  if (!db_mod_field_type)
    {
      static const GtkTypeInfo db_mod_field_info =
      {
  	"TdDbModField", sizeof (TdDbModField), sizeof (TdDbModFieldClass),
  	(GtkClassInitFunc) td_db_mod_field_class_init,
	(GtkObjectInitFunc) td_db_mod_field_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      db_mod_field_type = gtk_type_unique (GTK_TYPE_OBJECT, &db_mod_field_info);
    }
  return db_mod_field_type;
}

GtkObject *td_db_mod_field_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_db_mod_field_get_type ()));
}


/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_db_mod_field_add_property (TdDbModField *db_mod_field, gchar *property_name, gchar *property_value)
{
  g_return_if_fail (db_mod_field != NULL);
  g_return_if_fail (TD_IS_DB_MOD_FIELD (db_mod_field));
  db_mod_field->property_name = g_list_append (db_mod_field->property_name, property_name);
  db_mod_field->property_value = g_list_append (db_mod_field->property_value, property_value);
}


/*****************************************************************************/
/* Commandes */
/*****************************************************************************/


/*****************************************************************************/
/* Fichier */
/*****************************************************************************/
GtkObject *td_db_mod_field_load_hopla (xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur)
{
  GtkObject *ret;

  /* Champs */
  ret = td_db_mod_field_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", xmlGetProp (cur, "name"), 
		  "table_field", xmlGetProp (cur, "table_field"), NULL);

  /* Proprits */
  cur = cur->childs->childs;
  while (cur)
    {
      if (!strcmp (cur->name, "property"))
	td_db_mod_field_add_property (TD_DB_MOD_FIELD (ret), xmlGetProp (cur, "name"), xmlGetProp (cur, "value"));
      cur = cur->next;
    }
  return (ret);
}
