/*****************************************************************************/
/* td_db_mod.h : Objet Gtk+
 * td_db_mod.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <parser.h>
#include <tree.h>


/*****************************************************************************/
/* Macros */
/*****************************************************************************/
#define TD_TYPE_DB_MOD (td_db_mod_get_type ())
#define TD_DB_MOD(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_DB_MOD, TdDbMod))
#define TD_DB_MOD_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_DB_MOD, TdDbModClass))
#define TD_IS_DB_MOD(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_DB_MOD))
#define TD_IS_DB_MOD_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_DB_MOD))

/*****************************************************************************/
/* Structure */
/*****************************************************************************/
typedef struct _TdDbMod TdDbMod;
typedef struct _TdDbModClass TdDbModClass;

struct _TdDbMod
{
  GtkObject object;
  gchar *name;
  gchar *table;
  GList *field;
};

struct _TdDbModClass
{
  GtkObjectClass parent_class;
  void (*add_field) (TdDbMod *db_mod, GtkObject *field);
};

/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
void td_db_mod_set_name (TdDbMod *db_mod, gchar *name);
void td_db_mod_set_table (TdDbMod *db_mod, gchar *table);
static void td_db_mod_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_db_mod_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_db_mod_init (TdDbMod *db_mod);
static void td_db_mod_class_init (TdDbModClass *klass);
GtkType td_db_mod_get_type (void);
GtkObject *td_db_mod_new (void);

/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_db_mod_add_field (TdDbMod *db_mod, GtkObject *field);

/*****************************************************************************/
/* Commandes */
/*****************************************************************************/

/*****************************************************************************/
/* Fichier */
/*****************************************************************************/
GtkObject *td_db_mod_load_hopla (xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur);
