/*****************************************************************************/
/* td_db_connect.c : Objet Gtk+
 * td_db_connect.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dlfcn.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/stat.h>

#include "commons.h"
#include "icons.h"

#include "td_app.h"
#include "td_app_palette.h"
#include "td_app_editprop.h"

#include "td_db_base.h"
#include "td_db_mod.h"
#include "td_db_datatable.h"
#include "td_db_connect.h"


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_TYPE,
  ARG_INTERFACE,
  ARG_HOST,
  ARG_PORT,
  ARG_BASE,
  ARG_USER,
  ARG_PASSWORD,
  ARG_FILE,
  ARG_TEMPLATE,
};


void td_db_connect_set_name (TdDbConnect *connect, gchar *name)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->name != name)
    connect->name = name;
}

void td_db_connect_set_type (TdDbConnect *connect, gchar *type)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->type != type)
    connect->type = type;
}

void td_db_connect_set_interface (TdDbConnect *connect, gchar *interface)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->interface != interface)
    connect->interface = interface;
}

void td_db_connect_set_host (TdDbConnect *connect, gchar *host)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->host != host)
    connect->host = host;
}

void td_db_connect_set_port (TdDbConnect *connect, gchar *port)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->port != port)
    connect->port = port;
}

void td_db_connect_set_base (TdDbConnect *connect, gchar *base)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->base != base)
    connect->base = base;
}

void td_db_connect_set_user (TdDbConnect *connect, gchar *user)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->user != user)
    connect->user = user;
}

void td_db_connect_set_password (TdDbConnect *connect, gchar *password)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->password != password)
    connect->password = password;
}

void td_db_connect_set_file (TdDbConnect *connect, gchar *file)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->file != file)
    connect->file = file;
}

void td_db_connect_set_template (TdDbConnect *connect, gchar *template)
{
  g_return_if_fail (connect != NULL);
  g_return_if_fail (TD_IS_DB_CONNECT (connect));
  if (connect->template != template)
    connect->template = template;
}

static void td_db_connect_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbConnect *connect;
  connect = TD_DB_CONNECT (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_db_connect_set_name (connect, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TYPE:
      td_db_connect_set_type (connect, GTK_VALUE_STRING (*arg));
      break;
    case ARG_INTERFACE:
      td_db_connect_set_interface (connect, GTK_VALUE_STRING (*arg));
      break;
    case ARG_HOST:
      td_db_connect_set_host (connect, GTK_VALUE_STRING (*arg));
      break;
    case ARG_PORT:
      td_db_connect_set_port (connect, GTK_VALUE_STRING (*arg));
      break;
    case ARG_BASE:
      td_db_connect_set_base (connect, GTK_VALUE_STRING (*arg));
      break;
    case ARG_USER:
      td_db_connect_set_user (connect, GTK_VALUE_STRING (*arg));
      break;
    case ARG_PASSWORD:
      td_db_connect_set_password (connect, GTK_VALUE_STRING (*arg));
      break;
    case ARG_FILE:
      td_db_connect_set_file (connect, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TEMPLATE:
      td_db_connect_set_template (connect, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_db_connect_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdDbConnect *connect;
  connect = TD_DB_CONNECT (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = connect->name;
      break;
    case ARG_TYPE:
      GTK_VALUE_STRING (*arg) = connect->type;
      break;
    case ARG_INTERFACE:
      GTK_VALUE_STRING (*arg) = connect->interface;
      break;
    case ARG_HOST:
      GTK_VALUE_STRING (*arg) = connect->host;
      break;
    case ARG_PORT:
      GTK_VALUE_STRING (*arg) = connect->port;
      break;
    case ARG_BASE:
      GTK_VALUE_STRING (*arg) = connect->base;
      break;
    case ARG_USER:
      GTK_VALUE_STRING (*arg) = connect->user;
      break;
    case ARG_PASSWORD:
      GTK_VALUE_STRING (*arg) = connect->password;
      break;
    case ARG_FILE:
      GTK_VALUE_STRING (*arg) = connect->file;
      break;
    case ARG_TEMPLATE:
      GTK_VALUE_STRING (*arg) = connect->template;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_db_connect_init (TdDbConnect *connect)
{
  connect->name = NULL;
  connect->type = NULL;
  connect->interface = NULL;
  connect->host = NULL;
  connect->port = NULL;
  connect->base = NULL;
  connect->user = NULL;
  connect->password = NULL;
  connect->file = NULL;
  connect->template = NULL;
}

static void td_db_connect_class_init (TdDbConnectClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdDbConnect::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdDbConnect::type", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TYPE);
  gtk_object_add_arg_type ("TdDbConnect::interface", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_INTERFACE);
  gtk_object_add_arg_type ("TdDbConnect::host", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_HOST);
  gtk_object_add_arg_type ("TdDbConnect::port", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_PORT);
  gtk_object_add_arg_type ("TdDbConnect::base", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_BASE);
  gtk_object_add_arg_type ("TdDbConnect::user", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_USER);
  gtk_object_add_arg_type ("TdDbConnect::password", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_PASSWORD);
  gtk_object_add_arg_type ("TdDbConnect::file", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_FILE);
  gtk_object_add_arg_type ("TdDbConnect::template", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TEMPLATE);
  object_class->set_arg = td_db_connect_set_arg;
  object_class->get_arg = td_db_connect_get_arg;
}

GtkType td_db_connect_get_type (void)
{
  static GtkType db_connect_type = 0;
  if (!db_connect_type)
    {
      static const GtkTypeInfo db_connect_info =
      {
  	"TdDbConnect", sizeof (TdDbConnect), sizeof (TdDbConnectClass),
  	(GtkClassInitFunc) td_db_connect_class_init,
	(GtkObjectInitFunc) td_db_connect_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      db_connect_type = gtk_type_unique (GTK_TYPE_OBJECT, &db_connect_info);
    }
  return db_connect_type;
}

GtkObject *td_db_connect_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_db_connect_get_type ()));
}


/*****************************************************************************/
/* Commands */
/*****************************************************************************/
void td_db_connect_add_menu (void)
{
  GnomeUIInfo *menu;
  gchar *txt_tmp;
  gchar *path;

  /* Open template... */
  menu = g_malloc0 (2 * sizeof (GnomeUIInfo));
  path = g_strdup_printf ("%s/%s/", _("File"), _("New"));
  menu->type = GNOME_APP_UI_SEPARATOR;
  gnome_app_insert_menus (GNOME_APP (TD_APP_PALETTE (TD_APP (APP)->palette)->window), path, menu);
  menu = g_malloc0 (2 * sizeof (GnomeUIInfo));
  menu->label = g_strdup_printf (_("Open template..."));
  menu->type = GNOME_APP_UI_ITEM;
  menu->hint = NULL;
  menu->moreinfo = td_db_connect_load;
  menu->user_data = NULL;
  menu->unused_data = NULL;
  menu->pixmap_type = GNOME_APP_PIXMAP_STOCK;
  menu->pixmap_info = GNOME_STOCK_MENU_NEW;
  menu->accelerator_key = 0;
  gnome_app_insert_menus (GNOME_APP (TD_APP_PALETTE (TD_APP (APP)->palette)->window), path, menu);

  /* Crer gabarit */
  menu = g_malloc0 (2 * sizeof (GnomeUIInfo));
  path = g_strdup_printf ("%s/%s/", _("File"), _("New"));
  menu->label = g_strdup_printf (_("Create template"));
  menu->type = GNOME_APP_UI_ITEM;
  menu->hint = NULL;
  menu->moreinfo = td_db_connect_close;
  menu->user_data = NULL;
  menu->unused_data = NULL;
  menu->pixmap_type = GNOME_APP_PIXMAP_DATA;
  menu->pixmap_info = TD_STOCK_LIST_BUILD;
  menu->accelerator_key = 'n';
  menu->ac_mods = GDK_CONTROL_MASK;
  (menu + 1)->type = GNOME_APP_UI_ENDOFINFO;
  gnome_app_insert_menus (GNOME_APP (TD_APP_PALETTE (TD_APP (APP)->palette)->window), path, menu);

  /* Ouvrir fichier */
  menu = g_malloc0 (2 * sizeof (GnomeUIInfo));
  path = g_strdup_printf ("%s/%s/", _("File"), _("Open"));
  menu->type = GNOME_APP_UI_SEPARATOR;
  gnome_app_insert_menus (GNOME_APP (TD_APP_PALETTE (TD_APP (APP)->palette)->window), path, menu);
  menu = g_malloc0 (2 * sizeof (GnomeUIInfo));
  menu->label = g_strdup_printf (_("Open URL..."));
  menu->type = GNOME_APP_UI_ITEM;
  menu->hint = NULL;
  menu->moreinfo = td_db_connect_load;
  menu->user_data = NULL;
  menu->unused_data = NULL;
  menu->pixmap_type = GNOME_APP_PIXMAP_DATA;
  menu->pixmap_info = TD_STOCK_LIST_URL;
  menu->accelerator_key = 0;
  gnome_app_insert_menus (GNOME_APP (TD_APP_PALETTE (TD_APP (APP)->palette)->window), path, menu);

  /* Ouvrir url */
  menu = g_malloc0 (2 * sizeof (GnomeUIInfo));
  path = g_strdup_printf ("%s/%s/", _("File"), _("Open"));
  menu->label = g_strdup_printf (_("Open file..."));
  menu->type = GNOME_APP_UI_ITEM;
  menu->hint = NULL;
  menu->moreinfo = td_db_connect_load;
  menu->user_data = NULL;
  menu->unused_data = NULL;
  menu->pixmap_type = GNOME_APP_PIXMAP_STOCK;
  menu->pixmap_info = GNOME_STOCK_MENU_NEW;
  menu->accelerator_key = 0xFFC0;
  (menu + 1)->type = GNOME_APP_UI_ENDOFINFO;
  gnome_app_insert_menus (GNOME_APP (TD_APP_PALETTE (TD_APP (APP)->palette)->window), path, menu);
  g_free (menu);
}

void td_db_connect_add_menu_recents (void)
{
  GnomeUIInfo *menu;
  gchar *txt_tmp;
  gchar *path;

  /* Ouvrir URL */
  menu = g_malloc0 (2 * sizeof (GnomeUIInfo));
  path = g_strdup_printf ("%s/%s/", _("File"), _("Open"));
  menu->type = GNOME_APP_UI_SEPARATOR;
  gnome_app_insert_menus (GNOME_APP (TD_APP_PALETTE (TD_APP (APP)->palette)->window), path, menu);
  menu = g_malloc0 (2 * sizeof (GnomeUIInfo));
  menu->label = g_strdup_printf (_("Open URL..."));
  menu->type = GNOME_APP_UI_ITEM;
  menu->hint = NULL;
  menu->moreinfo = td_db_connect_load;
  menu->user_data = NULL;
  menu->unused_data = NULL;
  menu->pixmap_type = GNOME_APP_PIXMAP_DATA;
  menu->pixmap_info = TD_STOCK_LIST_URL;
  menu->accelerator_key = 0;
  gnome_app_insert_menus (GNOME_APP (TD_APP_PALETTE (TD_APP (APP)->palette)->window), path, menu);

  /* Ouvrir fichier */
  menu = g_malloc0 (2 * sizeof (GnomeUIInfo));
  path = g_strdup_printf ("%s/%s/", _("File"), _("Open"));
  menu->label = g_strdup_printf (_("Open file..."));
  menu->type = GNOME_APP_UI_ITEM;
  menu->hint = NULL;
  menu->moreinfo = td_db_connect_load;
  menu->user_data = NULL;
  menu->unused_data = NULL;
  menu->pixmap_type = GNOME_APP_PIXMAP_STOCK;
  menu->pixmap_info = GNOME_STOCK_MENU_NEW;
  menu->accelerator_key = 0xFFC0;
  (menu + 1)->type = GNOME_APP_UI_ENDOFINFO;
  gnome_app_insert_menus (GNOME_APP (TD_APP_PALETTE (TD_APP (APP)->palette)->window), path, menu);
  g_free (menu);
}


/*****************************************************************************/
/* Fichier */
/*****************************************************************************/
gboolean td_db_connect_load (GtkMenuItem *menuitem, GtkObject *connect_bookmark)
{
  void (*symbol)();
  gchar *(*symbol2)();
  gboolean (*symbol3)();
  int fp;
  gchar *txt_tmp;
  GtkObject *parse_test;
  GtkObject *connect = NULL;
  gboolean bool_tmp;
  int i, j;
  struct stat stat_tmp;

  /* Choisir fichier */
  if (menuitem)
    if ((!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf ("%s%s/%s/%s", PREFIX_WIDGET_CORE, _("File"), _("Open"), _("Open file...")))) || 
	(!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf ("%s%s/%s", PREFIX_WIDGET_CORE, _("File"), _("Open file...")))) ||
	(!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf ("%s%s/%s", PREFIX_WIDGET_PLUGINS, _("File"), _("Open file...")))))
      {
	txt_tmp = g_strdup_printf ("%s", td_fileselector_create_window (_("Load file"), NULL, TRUE));
	if ((!txt_tmp) || (!strcmp (txt_tmp, "(null)")))
	  return TRUE;
	connect = td_db_connect_new();
	gtk_object_set (GTK_OBJECT (connect), 
			"name", txt_tmp, 
			"type", "file", 
			"file", txt_tmp, NULL);
      }

  /* Choisir gabarit */
  if (menuitem)
    if ((!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf ("%s%s/%s/%s", PREFIX_WIDGET_CORE, _("File"), _("New"), _("Open template...")))) ||
	(!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf ("%s%s/%s", PREFIX_WIDGET_CORE, _("Template"), _("Open template...")))) ||
	(!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf ("%s%s/%s", PREFIX_WIDGET_PLUGINS, _("Template"), _("Open template...")))))
      {
	txt_tmp = g_strdup_printf ("%s", td_fileselector_create_window (_("Load template"), NULL, TRUE));
	if ((!txt_tmp) || (!strcmp (txt_tmp, "(null)")))
	  return TRUE;
	else
	  {
	    connect = td_db_connect_new();
	    gtk_object_set (GTK_OBJECT (connect),
			    "name", _("New"),
			    "type", "template", 
			    "file", txt_tmp, NULL);
	  }
      }

  /* Choisir URL */
  if (menuitem)
    if ((!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf ("%s%s/%s/%s", PREFIX_WIDGET_CORE, _("File"), _("Open"), _("Open URL...")))) || 
	(!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf ("%s%s/%s", PREFIX_WIDGET_CORE, _("File"), _("Open URL...")))) ||
	(!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf ("%s%s/%s", PREFIX_WIDGET_PLUGINS, _("File"), _("Open URL...")))))
      {
	(gpointer*) symbol2 = td_dlsym (PLUGINS_CORE[3], NULL, "libcommunication_url.so", "plugins_show");
	txt_tmp = symbol2 ();
	if ((!txt_tmp) || (!strcmp (txt_tmp, "(null)")))
	  return TRUE;
	else
	  {
	    (gpointer*) symbol3 = td_dlsym (PLUGINS_CORE[3], NULL, "libcommunication_url.so", "plugins_load_url");
	    if (!symbol3 (txt_tmp))
	      return TRUE;
	    connect = td_db_connect_new();
	    gtk_object_set (GTK_OBJECT (connect),
			    "name", txt_tmp,
			    "type", "url", 
			    "file", g_strdup_printf ("%s/url.toutdoux", TD_APP (APP)->dir_tmp), NULL);
	  }
      }

  /* Signets */
  td_palette_message (NULL, _("Loading file"), "begin");
  td_palette_message (_("Checking file..."), NULL, "message");
  if (connect_bookmark)
    connect = connect_bookmark;

  /* Vrif de l'existence du fichier */
  fp = open (TD_DB_CONNECT (connect)->file, O_RDONLY);
  if (fp == -1)
    {
      td_palette_message (_("Loading file"), g_strdup_printf (_("Loading file : '%s'"), TD_DB_CONNECT (connect)->file), "failed");
      td_palette_message (NULL, _("Loading file"), "end");
      return FALSE;
    }
  fstat (fp, &stat_tmp);
  close (fp);
  if (S_ISDIR(stat_tmp.st_mode))
    {
      td_palette_message (_("Loading file"), g_strdup_printf(_("Loading file '%s' : It's not a file"), TD_DB_CONNECT (connect)->file), "failed");
      td_palette_message (NULL, _("Loading file"), "end");
      return FALSE;
    }

  /* Verif du contenu du fichier et conversion ancien format */
  parse_test = td_db_base_load_hopla (TD_DB_CONNECT (connect)->file);
  if (!parse_test)
    {
      if (!td_db_open_oldfile (TD_DB_CONNECT (connect)->file))
	{
	  td_palette_message (_("Loading file"), g_strdup_printf(_("Loading file '%s' : file unreadable"), TD_DB_CONNECT (connect)->file), "failed");
	  td_palette_message (NULL, _("Creating file"), "end");
	  return FALSE;
	}
      parse_test = td_db_base_load_hopla (TD_DB_CONNECT (connect)->file);
      if (!parse_test)
	{
	  td_palette_message (_("Loading file"), g_strdup_printf(_("Loading file '%s' : file unreadable"), TD_DB_CONNECT (connect)->file), "failed");
	  td_palette_message (NULL, _("Loading file"), "end");
	  return FALSE;
	}
    }

  /* Fermeture du fichier en cours */
  if (!td_db_connect_close (NULL, NULL))
    {
      td_palette_message (NULL, _("Loading file"), "end");
      return FALSE;
    }

  /* Connexion */
  td_palette_message (g_strdup_printf ("%s...", _("Loading file")), NULL, "message");
  td_app_set_current (TD_APP (APP), connect, parse_test);

  /* Palette */
  if (!td_app_palette_load (TD_APP_PALETTE (TD_APP (APP)->palette)))
    {
      td_app_set_current (TD_APP (APP), NULL, NULL);
      td_palette_message (NULL, _("Loading file"), "end");
      return FALSE;
    }

  /* Cogitation */
  (gpointer*) symbol = td_dlsym (PLUGINS_CORE[0], NULL, "libcogitation.so", "plugins_load");
  symbol (TD_DB_BASE (TD_APP (APP)->base));

  /* Donnes */
  if (!strcmp (TD_DB_CONNECT (TD_APP(APP)->connect)->type, "template"))
    {
      TD_APP(APP)->modified = FALSE;
      td_palette_message (NULL, g_strdup_printf (_("Loading file '%s'"), TD_DB_CONNECT (TD_APP(APP)->connect)->file), "done");
      td_palette_message (NULL, _("Loading file"), "end");
      return TRUE;
    }
  for (i=0; i < g_list_length (TD_DB_BASE (TD_APP (APP)->base)->mod); i++)
    {

      /* Recherche de la table des donnes */
      bool_tmp = FALSE;
      for (j=0; j < g_list_length (TD_DB_BASE (TD_APP (APP)->base)->datatable); j++)
	if (!strcmp (TD_DB_DATATABLE (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->datatable, j))->table, 
		     TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i))->table))
	  {
	    bool_tmp = TRUE;
	    break;
	  }

      /* Go ! */
      if (!bool_tmp)
	td_palette_message (_("Loading file"), g_strdup_printf (_("Loading file : datatable '%s' for module '%s' not find"), TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i))->table, TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i))->name), "failed");
      else
	{
	  (gpointer*) symbol = td_dlsym (PLUGINS_DATA[i], _("for "), TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i))->name, "plugins_load");
	  symbol (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->datatable, j));
	}
    }
  TD_APP(APP)->modified = FALSE;

  /* Historique */
  (gpointer*) symbol = td_dlsym (PLUGINS_CORE[1], NULL, "libbookmarks.so", "plugins_add_recents");
  symbol (connect);
  td_palette_message (NULL, g_strdup_printf (_("Loading file '%s'"), TD_DB_CONNECT (TD_APP(APP)->connect)->file), "done");
  td_palette_message (NULL, _("Loading file"), "end");
  return TRUE;
}

gboolean td_db_connect_save (GtkMenuItem *menuitem, gpointer user_data)
{
  TdDbBase *(*symbol1)();
  TdDbDatatable *(*symbol2)();
  gboolean (*symbol3)();
  void (*symbol4)();
  TdDbBase *base;
  GtkObject *connect = NULL;
  gchar *file = NULL;
  int i;

  /* save as */
  if (menuitem)
    if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf ("%s%s/%s", PREFIX_WIDGET_PLUGINS, _("File"), _("Save as..."))))
      {
	file = g_strdup_printf ("%s", td_fileselector_create_window (_("Save file"), NULL, TRUE));
	if ((!file) || (!strcmp (file, "(null)")))
	  return TRUE;
	else
	  {
	    TD_APP(APP)->modified = TRUE;
	    connect = td_db_connect_new();
	    gtk_object_set (GTK_OBJECT (connect), 
			    "name", file, 
			    "type", "file", 
			    "file", file, NULL);
	    TD_APP(APP)->connect = connect;
	  }
      }

  /* save sans nom */
  if ((!(TD_APP(APP)->base) && (!file)) || 
      (!strcmp (TD_DB_CONNECT (TD_APP(APP)->connect)->name , _("New"))) ||
      (!strcmp (TD_DB_CONNECT (TD_APP(APP)->connect)->type , "url")))
    {
      file = g_strdup_printf ("%s", td_fileselector_create_window (_("Save file"), NULL, TRUE));
      if ((!file) || (!strcmp (file, "(null)")))
	return TRUE;
      else
	{
	  TD_APP(APP)->modified = TRUE;
	  connect = td_db_connect_new();
	  gtk_object_set (GTK_OBJECT (connect), 
			  "name", file, 
			  "type", "file", 
			  "file", file, NULL);
	  TD_APP(APP)->connect = connect;
	}
    }

  /* Pas de modifications */
  if (!TD_APP(APP)->modified)
    {
      td_palette_message (_("No unsaved change"), NULL, "message");
      return TRUE;
    }

  /* save */
  td_palette_message (NULL, _("Saving"), "begin");
  td_palette_message (g_strdup_printf ("%s...", _("Saving")), NULL, "message");
  if (!file)
    file = TD_DB_CONNECT (TD_APP(APP)->connect)->file;

  /* Cogitation */
  (gpointer*) symbol1 = td_dlsym (PLUGINS_CORE[0], NULL, "libcogitation.so", "plugins_save");
  base = symbol1();

  /* Donnes *//* FIXME: la notion de base de donnes arrive !!! */
  for (i=0; i < g_list_length (base->mod); i++)
    if (PLUGINS_DATA[i])
      {
	(gpointer*) symbol2 = td_dlsym (PLUGINS_DATA[i], _("for "), TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i))->name, "plugins_save");
	td_db_base_add_datatable (base, GTK_OBJECT (symbol2 ()));
      }

  /* Fichier */
  if (!td_db_base_save_hopla (base, file))
    {
      td_palette_message (_("Saving"), g_strdup_printf (_("Saving : file '%s' unreadable"), file) , "failed");
      td_palette_message (NULL, _("Saving"), "end");
      return FALSE;
    }
  td_palette_message (_("Wrote file"), g_strdup_printf (_("Wrote file '%s'"), file), "message");
  TD_APP(APP)->modified = FALSE;

  /* Base de donnes */
  if (!strcmp (TD_DB_CONNECT (TD_APP(APP)->connect)->type , "database"))
    {
      (gpointer*) symbol3 = td_dlsym (PLUGINS_CORE[4], NULL, "libcommunication_db.so", "plugins_save_database");
      if (!symbol3 (TD_APP(APP)->connect))
	{
	  (gpointer*) symbol4 = td_dlsym (PLUGINS_CORE[2], NULL, "libmessages.so", "plugins_load");
	  symbol4 (g_strdup_printf ("%s/log.xml", TD_APP(APP)->dir_tmp));
	  td_palette_message (_("Saving"), _("Saving : database unreadable"), "failed");
	  td_palette_message (NULL, _("Saving"), "end");
	  return FALSE;
	}
      td_palette_message (_("Wrote database"), g_strdup_printf (_("Wrote database '%s'"), TD_DB_CONNECT (TD_APP(APP)->connect)->base), "message");
      (gpointer*) symbol4 = td_dlsym (PLUGINS_CORE[2], NULL, "libmessages.so", "plugins_load");
      symbol4 (g_strdup_printf ("%s/log.xml", TD_APP(APP)->dir_tmp));

      /* Relecture du fichier */
      if (!td_db_connect_load (NULL, TD_APP(APP)->connect))
	{
	  td_palette_message (_("Saving"), _("Saving : database unreadable"), "failed");
	  td_palette_message (NULL, _("Saving"), "end");
	  return FALSE;
	}
    }
  /* Historique */
  (gpointer*) symbol4 = td_dlsym (PLUGINS_CORE[1], NULL, "libbookmarks.so", "plugins_add_recents");
  symbol4 (TD_APP(APP)->connect);
  td_palette_message (NULL, _("Saving"), "done");
  td_palette_message (NULL, _("Saving"), "end");
  return TRUE;
}

gboolean td_db_connect_close (GtkMenuItem *menuitem, gpointer user_data)
{
  void (*symbol)();
  gchar *txt_tmp;
  GtkObject *connect = NULL;
  int i;
  int retour_bouton = 0;

  /* Enregistrement du fichier en cours */
  if (TD_APP(APP)->modified)
    {
      retour_bouton = td_question_create_window (_("The file has unsaved changes, save them ?"), _("ToutDoux : Question"));
      if (retour_bouton == 0)
	td_db_connect_save (NULL, NULL);
      if (retour_bouton == 2)
	return FALSE;
    }

  /* Destruction des modules et base */
  td_palette_message (NULL, _("Closing file"), "begin");
  td_palette_message (g_strdup_printf ("%s...", _("Closing file")), NULL, "message");
  if (TD_APP (APP)->base)
    {
      for (i=0; i < g_list_length (TD_DB_BASE (TD_APP (APP)->base)->mod); i++)
	{
	  (gpointer*) symbol = td_dlsym (PLUGINS_DATA[i], _("for "), TD_DB_MOD (g_list_nth_data (TD_DB_BASE (TD_APP (APP)->base)->mod, i))->name, "plugins_destroy");
	  symbol ();
	}
      td_db_base_destroy (TD_DB_BASE (TD_APP(APP)->base));
    }

  /* Connexion  */
  connect = td_db_connect_new();
  gtk_object_set (GTK_OBJECT (connect),
		  "name", _("New"),
		  "type", "empty", NULL);
  td_app_set_current (TD_APP (APP), connect, NULL);

  /* Razage des fentres communes *//* FIXME: destruction 1/2 dbile : +tards (pas capt) */
  td_app_palette_clear (TD_APP_PALETTE (TD_APP(APP)->palette));
  TD_APP_PALETTE (TD_APP(APP)->palette)->button = NULL;

  /* Cogitation */
  (gpointer*) symbol = td_dlsym (PLUGINS_CORE[0], NULL, "libcogitation.so", "plugins_clear");
  symbol ();
  if (menuitem)
    if ((!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf ("%s%s/%s/%s", PREFIX_WIDGET_CORE, _("File"), _("New"), _("Create template")))) || 
	(!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf ("%s%s/%s", PREFIX_WIDGET_CORE, _("Template"), _("Create template")))) ||
	(!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf ("%s%s/%s", PREFIX_WIDGET_PLUGINS, _("Template"), _("Create template")))))
      {
	(gpointer*) symbol = td_dlsym (PLUGINS_CORE[0], NULL, "libcogitation.so", "plugins_show");
	symbol ();
      }
  TD_APP(APP)->modified = FALSE;
  td_palette_message (NULL, _("Closing file"), "done");
  td_palette_message (NULL, _("Closing file"), "end");
  return TRUE;
}

gboolean td_db_connect_bookmarks (GtkMenuItem *menuitem, gchar *number)
{
  GtkObject *(*symbol)();
  gboolean (*symbol3)();
  gboolean (*symbol2)();
  gchar *txt_tmp;
  GtkObject *connect;

  /* Recherche du signet */
  td_palette_message (NULL, _("Loading"), "begin");
  (gpointer*) symbol = td_dlsym (PLUGINS_CORE[1], NULL, "libbookmarks.so", "plugins_menu_activate");
  connect = symbol (number);

  /* Url */
  if (!strcmp (TD_DB_CONNECT (connect)->type, "url"))
    {
      td_palette_message (g_strdup_printf ("%s...", _("Loading URL")), NULL, "message");
      (gpointer*) symbol3 = td_dlsym (PLUGINS_CORE[3], NULL, "libcommunication_url.so", "plugins_load_url");
      if (!symbol3 (TD_DB_CONNECT (connect)->base))
	return TRUE;
    }

  /* Base de donnes */
  if (!strcmp (TD_DB_CONNECT (connect)->type, "database"))
    {
      td_palette_message (g_strdup_printf ("%s...", _("Loading database")), NULL, "message");
      (gpointer*) symbol3 = td_dlsym (PLUGINS_CORE[4], NULL, "libcommunication_db.so", "plugins_load_database");
      if (!symbol3 (connect))
	{
	  (gpointer*) symbol2 = td_dlsym (PLUGINS_CORE[2], NULL, "libmessages.so", "plugins_load");
	  symbol2 (g_strdup_printf ("%s/log.xml", TD_APP(APP)->dir_tmp));
	  td_palette_message (NULL, _("Loading"), "end");
	  return FALSE;
	}
      (gpointer*) symbol2 = td_dlsym (PLUGINS_CORE[2], NULL, "libmessages.so", "plugins_load");
      symbol2 (g_strdup_printf ("%s/log.xml", TD_APP(APP)->dir_tmp));
    }

  /* Rpertoire */
  if (!strcmp (TD_DB_CONNECT (connect)->type, "directory"))
    {
      txt_tmp = g_strdup_printf ("%s", td_fileselector_create_window (_("Load file"), TD_DB_CONNECT (connect)->base, TRUE));
      if ((!txt_tmp) || (!strcmp (txt_tmp, "(null)")))
	return TRUE;
      gtk_object_set (GTK_OBJECT (connect), 
		      "name", txt_tmp,
		      "type", "file", 
		      "file", txt_tmp, NULL);
    }
    
  /* Ouverture */
  td_db_connect_load (NULL, connect);
  td_palette_message (NULL, _("Loading"), "end");
  return TRUE;
}

gboolean td_db_open_oldfile (gchar *file)
{
  gboolean (*symbol)() = NULL;
  gboolean bool_tmp;
  int i;
  gchar *txt_tmp;

  /* Module dj charg ? */
  txt_tmp = g_strdup_printf (("%s%s"), TD_APP (APP)->dir_plugins, "liboldfile_103.so");
  bool_tmp = FALSE;
  for (i=0; i<g_list_length (TD_APP (APP)->mod_core); i++)
    if (!strcmp (g_list_nth_data (TD_APP (APP)->mod_core, i), txt_tmp))
      {
	bool_tmp = TRUE;
	break;
      }

  /* Oui */
  if (bool_tmp)
    {
      (gpointer*) symbol = td_dlsym (PLUGINS_CORE[i], "", txt_tmp, "plugins_translate");
      return (symbol (file));
    }

  /* Non */
  td_app_add_mod_core (TD_APP (APP), txt_tmp, NULL, -1);
  (gpointer*) symbol = td_dlsym (PLUGINS_CORE[g_list_length (TD_APP (APP)->mod_core)-1], "", txt_tmp, "plugins_translate");
  return (symbol (file));
}
