/*****************************************************************************/
/* td_db_base.h : Objet Gtk+
 * td_db_base.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <parser.h>
#include <tree.h>


/*****************************************************************************/
/* Macros */
/*****************************************************************************/
#define TD_TYPE_DB_BASE (td_db_base_get_type ())
#define TD_DB_BASE(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_DB_BASE, TdDbBase))
#define TD_DB_BASE_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_DB_BASE, TdDbBaseClass))
#define TD_IS_DB_BASE(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_DB_BASE))
#define TD_IS_DB_BASE_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_DB_BASE))

/*****************************************************************************/
/* Structure */
/*****************************************************************************/
typedef struct _TdDbBase TdDbBase;
typedef struct _TdDbBaseClass TdDbBaseClass;

struct _TdDbBase
{
  GtkObject object;
  gchar *name;
  gchar *comment;
  GList *table;
  GList *mod;
  GList *datatable;
  GtkObject *connexion;
};

struct _TdDbBaseClass
{
  GtkObjectClass parent_class;
  void (*add_table) (TdDbBase *db_base, GtkObject *table);
  void (*add_mod) (TdDbBase *db_base, GtkObject *mod);
  void (*add_datatable) (TdDbBase *db_base, GtkObject *datatable);
  void (*set_connexion) (TdDbBase *db_base, GtkObject *connexion);
};

/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
void td_db_base_set_name (TdDbBase *db_base, gchar *name);
void td_db_base_set_comment (TdDbBase *db_base, gchar *comment);
static void td_db_base_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_db_base_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_db_base_init (TdDbBase *db_base);
static void td_db_base_class_init (TdDbBaseClass *klass);
GtkType td_db_base_get_type (void);
GtkObject *td_db_base_new (void);
void td_db_base_destroy (TdDbBase *db_base);

/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_db_base_add_table (TdDbBase *db_base, GtkObject *table);
void td_db_base_add_mod (TdDbBase *db_base, GtkObject *mod);
void td_db_base_add_datatable (TdDbBase *db_base, GtkObject *datatable);
void td_db_base_set_connexion (TdDbBase *db_base, GtkObject *connexion);

/*****************************************************************************/
/* Commandes */
/*****************************************************************************/

/*****************************************************************************/
/* Fichier */
/*****************************************************************************/
GtkObject *td_db_base_load_hopla (gchar *file);
gboolean td_db_base_save_hopla (TdDbBase *base, gchar *file);
