/*****************************************************************************/
/* td_custom_option.h : Objet Gtk+
 * td_custom_option.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>


/*****************************************************************************/
/* Macros */
/*****************************************************************************/
#define TD_TYPE_CUSTOM_OPTION (td_custom_option_get_type ())
#define TD_CUSTOM_OPTION(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_CUSTOM_OPTION, TdCustomOption))
#define TD_CUSTOM_OPTION_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_CUSTOM_OPTION, TdCustomOptionClass))
#define TD_IS_CUSTOM_OPTION(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_CUSTOM_OPTION))
#define TD_IS_CUSTOM_OPTION_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_CUSTOM_OPTION))

/*****************************************************************************/
/* Structure */
/*****************************************************************************/
typedef struct _TdCustomOption TdCustomOption;
typedef struct _TdCustomOptionClass TdCustomOptionClass;

struct _TdCustomOption
{
  GtkObject object;
  gchar *name;
  gchar *group;
  gboolean newline;
  GtkWidget *widget;
  GtkWidget *widget_parent;
};

struct _TdCustomOptionClass
{
  GtkObjectClass parent_class;
  void (*set_widget) (TdCustomOption *option, GtkWidget *widget);
};

/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
void td_custom_option_set_name (TdCustomOption *option, gchar *name);
void td_custom_option_set_group (TdCustomOption *option, gchar *group);
void td_custom_option_set_new_line (TdCustomOption *option, gboolean new_line);
static void td_custom_option_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_custom_option_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_custom_option_init (TdCustomOption *option);
static void td_custom_option_class_init (TdCustomOptionClass *klass);
GtkType td_custom_option_get_type (void);
GtkObject *td_custom_option_new (void);

/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_custom_option_set_widget (TdCustomOption *option, GtkWidget *widget);










