/*****************************************************************************/
/* td_custom_option.c : Objet Gtk+
 * td_custom_option.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "gtdk.h"

#include "td_custom_option.h"


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_NAME,
  ARG_GROUP,
  ARG_NEWLINE,
};

void td_custom_option_set_name (TdCustomOption *option, gchar *name)
{
  g_return_if_fail (option != NULL);
  g_return_if_fail (TD_IS_CUSTOM_OPTION (option));
  if (option->name != name)
    option->name = name;
}

void td_custom_option_set_group (TdCustomOption *option, gchar *group)
{
  g_return_if_fail (option != NULL);
  g_return_if_fail (TD_IS_CUSTOM_OPTION (option));
  if (option->group != group)
    option->group = group;
}

void td_custom_option_set_newline (TdCustomOption *option, gboolean newline)
{
  g_return_if_fail (option != NULL);
  g_return_if_fail (TD_IS_CUSTOM_OPTION (option));
  if (option->newline != newline)
    option->newline = newline;
}

static void td_custom_option_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdCustomOption *custom_option;
  custom_option = TD_CUSTOM_OPTION (object);
  switch (arg_id)
    {
    case ARG_NAME:
      td_custom_option_set_name (custom_option, GTK_VALUE_STRING (*arg));
      break;
    case ARG_GROUP:
      td_custom_option_set_group (custom_option, GTK_VALUE_STRING (*arg));
      break;
    case ARG_NEWLINE:
      td_custom_option_set_newline (custom_option, GTK_VALUE_BOOL (*arg));
      break;
    default:
      break;
    }
}

static void td_custom_option_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdCustomOption *custom_option;
  custom_option = TD_CUSTOM_OPTION (object);
   switch (arg_id)
    {
    case ARG_NAME:
      GTK_VALUE_STRING (*arg) = custom_option->name;
      break;
    case ARG_GROUP:
      GTK_VALUE_STRING (*arg) = custom_option->group;
      break;
    case ARG_NEWLINE:
      GTK_VALUE_BOOL (*arg) = custom_option->newline;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_custom_option_init (TdCustomOption *option)
{
  option->name = NULL;
  option->group = NULL;
  option->newline = FALSE;
  option->widget = NULL;
  option->widget_parent = NULL;
}

static void td_custom_option_class_init (TdCustomOptionClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type());
  gtk_object_add_arg_type ("TdCustomOption::name", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_NAME);
  gtk_object_add_arg_type ("TdCustomOption::group", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_GROUP);
  gtk_object_add_arg_type ("TdCustomOption::newline", GTK_TYPE_BOOL, GTK_ARG_READWRITE, ARG_NEWLINE);
  object_class->set_arg = td_custom_option_set_arg;
  object_class->get_arg = td_custom_option_get_arg;
  klass->set_widget = td_custom_option_set_widget;
}

GtkType td_custom_option_get_type (void)
{
  static GtkType option_type = 0;
  if (!option_type)
    {
      static const GtkTypeInfo option_info =
      {
  	"TdCustomOption", sizeof (TdCustomOption), sizeof (TdCustomOptionClass),
  	(GtkClassInitFunc) td_custom_option_class_init,
	(GtkObjectInitFunc) td_custom_option_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      option_type = gtk_type_unique (GTK_TYPE_OBJECT, &option_info);
    }
  return option_type;
}

GtkObject *td_custom_option_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_custom_option_get_type ()));
}

/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_custom_option_set_widget (TdCustomOption *option, GtkWidget *widget)
{
  g_return_if_fail (option != NULL);
  g_return_if_fail (TD_IS_CUSTOM_OPTION (option));
  if (option->widget != widget)
    option->widget = widget;
}

