/*****************************************************************************/
/* td_app_menu.c : Objet Gtk+
 * td_app_menu.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dlfcn.h>

#include "commons.h"
#include "gtdk.h"
#include "icons.h"

#include "td_app.h"
#include "td_app_menu.h"

#include "td_mod.h"


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;

enum {
  ARG_0,
  ARG_LABEL,
  ARG_TYPE,
  ARG_PATH,
  ARG_PATH_PARENT,
  ARG_FILE,
  ARG_SYMBOL,
};

void td_app_menu_set_label (TdAppMenu *menu, gchar *label)
{
  g_return_if_fail (menu != NULL);
  g_return_if_fail (TD_IS_APP_MENU (menu));
  if (menu->label != label)
    menu->label = label;
}

void td_app_menu_set_type (TdAppMenu *menu, gchar *type)
{
  g_return_if_fail (menu != NULL);
  g_return_if_fail (TD_IS_APP_MENU (menu));
  if (menu->type != type)
    menu->type = type;
}

void td_app_menu_set_path (TdAppMenu *menu, gchar *path)
{
  g_return_if_fail (menu != NULL);
  g_return_if_fail (TD_IS_APP_MENU (menu));
  if (menu->path != path)
    menu->path = path;
}

void td_app_menu_set_path_parent (TdAppMenu *menu, gchar *path_parent)
{
  g_return_if_fail (menu != NULL);
  g_return_if_fail (TD_IS_APP_MENU (menu));
  if (menu->path_parent != path_parent)
    menu->path_parent = path_parent;
}

void td_app_menu_set_file (TdAppMenu *menu, gchar *file)
{
  g_return_if_fail (menu != NULL);
  g_return_if_fail (TD_IS_APP_MENU (menu));
  if (menu->file != file)
    menu->file = file;
}

void td_app_menu_set_symbol (TdAppMenu *menu, gchar *symbol)
{
  g_return_if_fail (menu != NULL);
  g_return_if_fail (TD_IS_APP_MENU (menu));
  if (menu->symbol != symbol)
    menu->symbol = symbol;
}

static void td_app_menu_set_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdAppMenu *menu;
  menu = TD_APP_MENU (object);
  switch (arg_id)
    {
    case ARG_LABEL:
      td_app_menu_set_label (menu, GTK_VALUE_STRING (*arg));
      break;
    case ARG_TYPE:
      td_app_menu_set_type (menu, GTK_VALUE_STRING (*arg));
      break;
    case ARG_PATH:
      td_app_menu_set_path (menu, GTK_VALUE_STRING (*arg));
      break;
    case ARG_PATH_PARENT:
      td_app_menu_set_path_parent (menu, GTK_VALUE_STRING (*arg));
      break;
    case ARG_FILE:
      td_app_menu_set_file (menu, GTK_VALUE_STRING (*arg));
      break;
    case ARG_SYMBOL:
      td_app_menu_set_symbol (menu, GTK_VALUE_STRING (*arg));
      break;
    default:
      break;
    }
}

static void td_app_menu_get_arg (GtkObject *object, GtkArg *arg, guint arg_id)
{
  TdAppMenu *menu;
  menu = TD_APP_MENU (object);
   switch (arg_id)
    {
    case ARG_LABEL:
      GTK_VALUE_STRING (*arg) = menu->label;
      break;
    case ARG_TYPE:
      GTK_VALUE_STRING (*arg) = menu->type;
      break;
    case ARG_PATH:
      GTK_VALUE_STRING (*arg) = menu->path;
      break;
    case ARG_PATH_PARENT:
      GTK_VALUE_STRING (*arg) = menu->path_parent;
      break;
    case ARG_FILE:
      GTK_VALUE_STRING (*arg) = menu->file;
      break;
    case ARG_SYMBOL:
      GTK_VALUE_STRING (*arg) = menu->symbol;
      break;
    default:
      arg->type = GTK_TYPE_INVALID;
      break;
    }
}


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_app_menu_init (TdAppMenu *menu)
{
  menu->label = NULL;
  menu->type = NULL;
  menu->path = NULL;
  menu->path_parent = NULL;
  menu->file = NULL;
  menu->symbol = NULL;
}

static void td_app_menu_class_init (TdAppMenuClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type ());
  gtk_object_add_arg_type ("TdAppMenu::label", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_LABEL);
  gtk_object_add_arg_type ("TdAppMenu::type", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_TYPE);
  gtk_object_add_arg_type ("TdAppMenu::path", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_PATH);
  gtk_object_add_arg_type ("TdAppMenu::path_parent", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_PATH_PARENT);
  gtk_object_add_arg_type ("TdAppMenu::file", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_FILE);
  gtk_object_add_arg_type ("TdAppMenu::symbol", GTK_TYPE_STRING, GTK_ARG_READWRITE, ARG_SYMBOL);
  object_class->set_arg = td_app_menu_set_arg;
  object_class->get_arg = td_app_menu_get_arg;
}

GtkType td_app_menu_get_type (void)
{
  static GtkType app_menu_type = 0;
  if (!app_menu_type)
    {
      static const GtkTypeInfo app_menu_info =
      {
  	"TdAppMenu", sizeof (TdAppMenu), sizeof (TdAppMenuClass),
  	(GtkClassInitFunc) td_app_menu_class_init,
	(GtkObjectInitFunc) td_app_menu_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      app_menu_type = gtk_type_unique (GTK_TYPE_OBJECT, &app_menu_info);
    }
  return app_menu_type;
}

GtkObject *td_app_menu_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_app_menu_get_type ()));
}


/*****************************************************************************/
/* Affectations */
/*****************************************************************************/


/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
gboolean td_app_menu_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  void (*symbol)() = NULL;
  TdAppMenu *menu_tmp = NULL;
  gboolean bool_tmp;
  int i;
  gchar *txt_tmp;

  /* Localisation du menu */
  bool_tmp = FALSE;
  for (i=0; i<g_list_length (TD_APP (APP)->menu_mod); i++)
    {
      menu_tmp = g_list_nth_data (TD_APP (APP)->menu_mod, i);
      txt_tmp = g_strdup_printf ("%s%s", PREFIX_WIDGET_CORE, TD_APP_MENU (menu_tmp)->path); 
      if (!strcmp (GTK_WIDGET (menuitem)->name, txt_tmp))
	{
	  bool_tmp = TRUE;
	  break;
	}
      txt_tmp = g_strdup_printf ("%s%s", PREFIX_WIDGET_PLUGINS, TD_APP_MENU (menu_tmp)->path); 
      if (!strcmp (GTK_WIDGET (menuitem)->name, txt_tmp))
	{
	  bool_tmp = TRUE;
	  break;
	}
    }
  if (!bool_tmp)
    {
      td_palette_message (_("Execution plug-in"), g_strdup_printf (_("%s : plug-in for '%s' not loaded"), _("Execution plug-in"), GTK_WIDGET (menuitem)->name), "failed");
      return FALSE;
    }

  /* Manuel */
  if (!strcmp (TD_APP_MENU (menu_tmp)->type, "manual"))
    {
      txt_tmp = g_strdup_printf (("%s/%s"), TD_APP(APP)->dir_doc, TD_APP_MENU (menu_tmp)->file);
      gnome_help_goto (NULL, txt_tmp);
      return TRUE;
    }

  /* Module */
  if (!strcmp (TD_APP_MENU (menu_tmp)->type, "module"))
    {

      /* Module dj charg ? */
      txt_tmp = g_strdup_printf (("%s%s"), TD_APP (APP)->dir_plugins, TD_APP_MENU (menu_tmp)->file);
      bool_tmp = FALSE;
      for (i=0; i<g_list_length (TD_APP (APP)->mod_core); i++)
	if (!strcmp (g_list_nth_data (TD_APP (APP)->mod_core, i), txt_tmp))
	  {
	    bool_tmp = TRUE;
	    break;
	  }

      /* Oui */
      if (bool_tmp)
	{
	  (gpointer*) symbol = td_dlsym (PLUGINS_CORE[i], "", txt_tmp, TD_APP_MENU (menu_tmp)->symbol);
	  symbol (TRUE);
	  return TRUE;
	}

      /* Non */
      td_app_add_mod_core (TD_APP (APP), txt_tmp, NULL, -1);
      (gpointer*) symbol = td_dlsym (PLUGINS_CORE[g_list_length (TD_APP (APP)->mod_core)-1], "", txt_tmp, TD_APP_MENU (menu_tmp)->symbol);
      symbol (FALSE);
    }
  return TRUE;
}
