/*****************************************************************************/
/* td_app_editprop.c : Objet Gtk+
 * td_app_editprop.c : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "commons.h"
#include "gtdk.h"
#include "icons.h"

#include "td_app.h"
#include "td_app_editprop.h"

#include "td_mod.h"
#include "td_mod_box.h"


/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
static GtkObjectClass *parent_class = NULL;


/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_app_editprop_init (TdAppEditprop *editprop)
{
  editprop->window = NULL;
  editprop->notebook = NULL;
  editprop->notebook_vbox = NULL;
}

static void td_app_editprop_class_init (TdAppEditpropClass *klass)
{
  GtkObjectClass *object_class;
  object_class = (GtkObjectClass*) klass;
  parent_class = gtk_type_class (gtk_object_get_type ());
  klass->create = td_app_editprop_create;
}

GtkType td_app_editprop_get_type (void)
{
  static GtkType app_editprop_type = 0;
  if (!app_editprop_type)
    {
      static const GtkTypeInfo app_editprop_info =
      {
  	"TdAppEditprop", sizeof (TdAppEditprop), sizeof (TdAppEditpropClass),
  	(GtkClassInitFunc) td_app_editprop_class_init,
	(GtkObjectInitFunc) td_app_editprop_init,
	NULL, NULL, (GtkClassInitFunc) NULL,
      };
      app_editprop_type = gtk_type_unique (GTK_TYPE_OBJECT, &app_editprop_info);
    }
  return app_editprop_type;
}

GtkObject *td_app_editprop_new (void)
{
  return GTK_OBJECT (gtk_type_new (td_app_editprop_get_type ()));
}

void td_app_editprop_destroy (TdAppEditprop *editprop)
{
  g_return_if_fail (editprop != NULL);
  g_return_if_fail (TD_IS_APP_EDITPROP (editprop));
  gtdk_window_save_conf ("properties", editprop->window);
  gtk_widget_destroy (editprop->window);
  gtk_object_destroy (GTK_OBJECT (editprop));
}


/*****************************************************************************/
/* Affectations */
/*****************************************************************************/

/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
void td_app_editprop_create (TdAppEditprop *editprop)
{
  GtkWidget *dock;
  GtkWidget *viewport;
  GtkWidget *vbox;
  gchar* txt_tmp;
  g_return_if_fail (editprop != NULL);
  g_return_if_fail (TD_IS_APP_EDITPROP (editprop));

  /* Fentre */
  editprop->window = gnome_app_new ("properties", NULL);
  gnome_app_enable_layout_config (GNOME_APP (editprop->window), FALSE);
  gtk_window_set_policy (GTK_WINDOW (editprop->window),TRUE, TRUE, FALSE);
  gtk_window_set_title (GTK_WINDOW (editprop->window), g_strdup_printf ("ToutDoux : %s", _("Properties")));
  gnome_app_create_menus (GNOME_APP (editprop->window), TD_APP (APP)->menu_gnomeui);
  gtdk_window_save_defaultconf ("properties", 300, 150);
  gtdk_window_load_conf ("properties", editprop->window);
  dock = GNOME_APP (editprop->window)->dock;

  /* Multi-pages */
  viewport = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport);
  gnome_app_set_contents (GNOME_APP (editprop->window), viewport);
  editprop->notebook_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (editprop->notebook_vbox);
  gtk_container_add (GTK_CONTAINER (viewport), editprop->notebook_vbox);
  editprop->notebook = gtk_notebook_new ();
  gtk_widget_show (editprop->notebook);
  gtk_box_pack_start (GTK_BOX (editprop->notebook_vbox), editprop->notebook, TRUE, TRUE, 0);
  if (!TD_APP (APP)->mode_debug)
    gtk_notebook_set_show_tabs (GTK_NOTEBOOK (editprop->notebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (editprop->notebook), FALSE);
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (editprop->notebook), vbox);
  gtdk_vbox_title ("No view selected", vbox);

  /* Appels */
  gtk_signal_connect_object (GTK_OBJECT (editprop->window), "delete_event", GTK_SIGNAL_FUNC (td_app_editprop_hide), GTK_OBJECT (editprop));
  
  /* Affichage */
  txt_tmp = g_strdup_printf ("%s", gnome_config_get_string ("geometry-open/properties"));
  if (!strcmp (txt_tmp, "1"))
    {
      gtk_widget_show (GTK_WIDGET (editprop->window));
      gtk_widget_hide_all (GNOME_APP (editprop->window)->menubar->parent->parent);
    }
  else
    gtk_widget_hide (editprop->window);
}

void td_app_editprop_hide (TdAppEditprop *editprop)
{
  g_return_if_fail (editprop != NULL);
  g_return_if_fail (TD_IS_APP_EDITPROP (editprop));
  gtdk_window_save_conf ("properties", editprop->window);
  gtk_widget_hide (GTK_WIDGET (editprop->window));
  gnome_config_set_string ("geometry-open/properties", "0");
  gnome_config_sync ();
}

void td_app_editprop_show (TdAppEditprop *editprop)
{
  g_return_if_fail (editprop != NULL);
  g_return_if_fail (TD_IS_APP_EDITPROP (editprop));
  gtk_widget_show (GTK_WIDGET (editprop->window));
  gtk_widget_hide_all (GNOME_APP (editprop->window)->menubar->parent->parent);
  gnome_config_set_string ("geometry-open/properties", "1");
  gnome_config_sync ();
}






