/*****************************************************************************/
/* td_app.h : Objet Gtk+
 * td_app.h : Gtk+ object
 *
 *
 * ToutDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>


/*****************************************************************************/
/* Macros */
/*****************************************************************************/
#define TD_TYPE_APP (td_app_get_type ())
#define TD_APP(obj) (GTK_CHECK_CAST ((obj), TD_TYPE_APP, TdApp))
#define TD_APP_CLASS(klass) (GTK_CHECK_CLASS_CASTS ((klass), TD_TYPE_APP, TdAppClass))
#define TD_IS_APP(obj) (GTK_CHECK_TYPE ((obj), TD_TYPE_APP))
#define TD_IS_APP_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TD_TYPE_APP))

/*****************************************************************************/
/* Structure */
/*****************************************************************************/
typedef struct _TdApp TdApp;
typedef struct _TdAppClass TdAppClass;

struct _TdApp
{
  GtkObject object;
  GtkObject *palette;
  GtkObject *editprop;
  gchar *dir_var;
  gchar *dir_tmp;
  gchar *dir_plugins;
  gchar *dir_template;
  gchar *dir_doc;
  GList *admin_field;
  GtkWidget *menu_main;
  GnomeUIInfo *menu_gnomeui;
  GtkObject *connect;
  GtkObject *base;
  gboolean modified;
  GtkObject *about;
  GList *custom;
  gboolean mode_debug;
  gboolean mode_nocolor;
  GList *menu_mod;
  GList *mod_core;
  GList *mod_data;
};

struct _TdAppClass
{
  GtkObjectClass parent_class;
  void (*set_palette) (TdApp *app, GtkObject *palette);
  void (*set_editprop) (TdApp *app, GtkObject *editprop);
  void (*add_admin_field) (TdApp *app, GtkObject *field);
  void (*set_menu_main) (TdApp *app, GnomeUIInfo *menu_gnomeui);
  void (*set_current) (TdApp *app, GtkObject *connect, GtkObject *base);
  void (*set_modified) (TdApp *app, gboolean modified);
  void (*set_about) (TdApp *app, GtkObject *about);
  void (*add_custom) (TdApp *app, GtkObject *custom);
  void (*add_mod_data) (TdApp *app, gchar *mod_data);
  void (*add_menu_mod) (TdApp *app, GtkObject *menu_mod);
  void (*create) (TdApp *app);
  void (*quit) (TdApp *app);
};

/*****************************************************************************/
/* Arguments */
/*****************************************************************************/
void td_app_set_dir_var (TdApp *app, gchar *dir_var);
void td_app_set_dir_tmp (TdApp *app, gchar *dir_tmp);
void td_app_set_dir_plugins (TdApp *app, gchar *dir_plugins);
void td_app_set_dir_template (TdApp *app, gchar *dir_template);
void td_app_set_dir_doc (TdApp *app, gchar *dir_doc);
void td_app_set_modified (TdApp *app, gboolean modified);
void td_app_set_mode_debug (TdApp *app, gboolean mode_debug);
void td_app_set_mode_nocolor (TdApp *app, gboolean mode_nocolor);
static void td_app_set_arg (GtkObject *object, GtkArg *arg, guint arg_id);
static void td_app_get_arg (GtkObject *object, GtkArg *arg, guint arg_id);

/*****************************************************************************/
/* Initialisation */
/*****************************************************************************/
static void td_app_init (TdApp *app);
static void td_app_class_init (TdAppClass *klass);
GtkType td_app_get_type (void);
GtkObject *td_app_new (void);
void td_app_quit (TdApp *app);

/*****************************************************************************/
/* Affectations */
/*****************************************************************************/
void td_app_set_palette (TdApp *app, GtkObject *palette);
void td_app_set_editprop (TdApp *app, GtkObject *editprop);
void td_app_add_admin_field (TdApp *app, GtkObject *field);
void td_app_set_menu_main (TdApp *app, GnomeUIInfo *menu_gnomeui);
void td_app_set_current (TdApp *app, GtkObject *connect, GtkObject *base);
void td_app_set_about (TdApp *app, GtkObject *about);
void td_app_add_custom (TdApp *app, GtkObject *custom);
gboolean td_app_add_mod_core (TdApp *app, gchar *mod_core, gchar *symbol, int id);
void td_app_add_mod_data (TdApp *app, gchar *mod_data);
void td_app_add_menu_mod (TdApp *app, GtkObject *menu_mod);

/*****************************************************************************/
/* Commandes */
/*****************************************************************************/
void td_app_create (TdApp *app);
gboolean td_palette_message (gchar *chtit_message, gchar *message, gchar *type);
gboolean td_app_mod_core_activate (TdApp *app, gchar *file, gchar *symbol);
