/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : traduction des anciens fichier (format 1.0.2)
 * ToutDoux's plug-in : old file's (format 1.0.2) translation 
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <toutdoux.h>

#include "main.h"


/*****************************************************************************/
/* Variables globales */
/*****************************************************************************/

/*****************************************************************************/
/* Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("Old file hopla/1.0.3"),
		  "type", _("old file"),
		  "version", "1.0.2",
		  "blurb", _("Old file translation (format hopla/1.0.3)"),
		  "authors", "Philippe Roy <ph_roy@yahoo.com>",
		  "help", "(null)",
		  "category1", _("core"),
		  "category2", _("file"),
		  "category3", _("oldformat hopla/1.0.3"),
		  "copyright", "Copyright (c) 2000 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "web", "(null)", NULL);
  return ret;
}

void plugins_init (void)
{
}

void plugins_destroy (void)
{
}

gboolean plugins_translate (gchar *file)
{
  td_palette_message (NULL, _("Translating old file : format hopla/1.0.3"), "begin");
  if (!sed_translate (file))
    {
      td_palette_message (NULL, _("Translating old file : format hopla/1.0.3"), "end");
      return FALSE;
    }
  td_palette_message (NULL, _("Translating old file : format hopla/1.0.3"), "end");
  return TRUE;
}

gboolean sed_translate (gchar *file)
{
  GtkObject *flower;
  gchar *beforeword;
  gchar *afterword;
  int i, j;
  gchar *txt_tmp;
  int system_verif;
  td_palette_message (NULL, _("Sed modification"), "begin");

  /* Fichier support (flower) */
  flower = td_flower_new ();
  gtk_object_set (GTK_OBJECT (flower),
		  "space", "toutdoux-oldfile/1.0.1",
		  "root", "oldfile", 
		  "branch", "change", NULL);
  td_flower_add_branch_attribut (TD_FLOWER (flower), "beforeword");
  td_flower_add_branch_attribut (TD_FLOWER (flower), "afterword");
  td_flower_load_file (TD_FLOWER (flower), g_strdup_printf ("%s/share/toutdoux/oldfile.xml", PACKAGE_DATA_DIR));

  /* Cration d'une sauvegarde */
  txt_tmp = g_strdup_printf ("cp %s %s.bak", file, file);
  system_verif = system (txt_tmp);
  txt_tmp = g_strdup_printf ("Creating backup file : command 'cp %s %s.bak'", file, file);
  if (system_verif)
    {
      td_palette_message (_("Creating backup file"), txt_tmp, "failed");
      td_palette_message (NULL, _("Sed modification"), "end");
      return FALSE;
    }
  td_palette_message (_("Creating backup file"), txt_tmp, "done");
  
  /* Modifications */
  printf("debug : g_list_length (TD_FLOWER (flower)->items_value) : %d \n", g_list_length (TD_FLOWER (flower)->items_value));
  for (i=0; i<g_list_length (TD_FLOWER (flower)->items_value); i++)
    {

      /* Copie du fichier */
      txt_tmp = g_strdup_printf ("cp %s %s.tmp", file, file);
      system_verif = system (txt_tmp);
      txt_tmp = g_strdup_printf (_("Creating tempory file : command 'cp %s %s.tmp'"), file, file);
      if (system_verif != 0)
	{
	  td_palette_message (_("Creating tempory file"), txt_tmp, "failed");
	  td_palette_message (NULL, _("Sed modification"), "end");
	  return FALSE;
	}
      td_palette_message (_("Creating tempory file"), txt_tmp, "done");
	      
      /* Remplacement du texte */
      beforeword = g_strdup_printf ("%s", (gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 0));
      afterword = g_strdup_printf ("%s", (gchar*) g_list_nth_data (g_list_nth_data (TD_FLOWER (flower)->items_value, i), 1));

      printf("debug : beforeword : %s \n", beforeword);
      printf("debug : afterword : %s \n", afterword);

      txt_tmp = g_strdup_printf ("sed -e '1,$s^%s^%s^g' %s.tmp > %s", beforeword, afterword, file, file);
      system_verif = system(txt_tmp);
      txt_tmp = g_strdup_printf (_("Remplacing : command 'sed -e '1,$s^%s^%s^g' %s.tmp > %s'"), beforeword, afterword, file, file);
      if (system_verif != 0)
	{
	  td_palette_message (NULL, txt_tmp, "failed");
	  td_palette_message (NULL, _("Sed modification"), "end");
	  return FALSE;
	}
      td_palette_message (NULL, txt_tmp, "done");
    }

  td_palette_message (NULL, _("Sed modification"), "end");
  return TRUE;
}
