/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : Cogitation : Construction de base de donnes et de gabarit
 * ToutDoux's plug-in : Cogitation : Data base builder and template builder
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dlfcn.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/stat.h>

#include "main.h"
#include "icons.h"


/*****************************************************************************/
/* Variables globales */
/*****************************************************************************/
GtkObject *mod; /* Module */
GList *plugins_filelist;
GList *list_plugins;
GList *list_plugins_mod;
GList *list_plugin_fields;
GtkWidget *prop_widget_plugins;
GtkWidget *prop_widget_plugin_fields;
GList *list_table;
GList *list_table_list;
GList *list_table_fields;
GtkWidget *prop_widget_module_table;
GtkWidget *prop_widget_module_table_fields;
gboolean flag_entry_option;

/*****************************************************************************/
/* Dfinition des menus */
/*****************************************************************************/

/* Gnrale */
static GnomeUIInfo menu_help_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Customize"), NULL,
   plugins_custom, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_CUSTOM, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("About..."), NULL,
   mod_about, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_file_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Save database"), NULL,
   menu_save_db, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_LIST_DATABASE, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Import file..."), NULL,
   menu_import_file, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_IMPORT, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_nada_uiinfo[] =
{
  {GNOME_APP_UI_SUBTREE, N_("File"), NULL,
   menu_file_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};

/* Table */
static GnomeUIInfo menu_table_default_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Create table"), NULL,
   menu_table_new, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , table_xpm, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("File"), NULL,
   menu_file_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_table_table_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Create field"), NULL,
   menu_table_new, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , champs_xpm, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Create predifined administration's fields"), NULL,
   menu_table_new_admin, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , fieldadmin_xpm, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Remove"), NULL,
   menu_table_remove, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("File"), NULL,
   menu_file_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_table_champs_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Create type"), NULL,
   menu_table_new, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_PROPERTY, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Remove"), NULL,
   menu_table_remove, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("File"), NULL,
   menu_file_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_table_type_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Remove"), NULL,
   menu_table_remove, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("File"), NULL,
   menu_file_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_module_default_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Create module"), NULL,
   menu_module_new, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, list_module_xpm, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("File"), NULL,
   menu_file_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_module_module_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Create field"), NULL,
   menu_module_new, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , champs_xpm, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Create predefined module's fields"), NULL,
   menu_module_new_predef, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , fieldadmin_xpm, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Create table and module predefined"), NULL,
   menu_module_new_predef2, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , table_xpm, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Remove"), NULL,
   menu_module_remove, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("File"), NULL,
   menu_file_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_module_champs_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Remove"), NULL,
   menu_module_remove, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("File"), NULL,
   menu_file_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA , TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Close"), NULL,
   plugins_hide, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 0, 0, NULL},
  GNOMEUIINFO_END
};


/*****************************************************************************/
/* Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "Cogitation",
		  "type", _("build"),
		  "version", "1.0.1",
		  "blurb", _("Data base editor and template editor"),
		  "authors", "Philippe Roy <ph_roy@yahoo.com>",
		  "help", "(null)",
		  "category1", _("build"),
		  "category2", "Cogitation",
		  "category3", "(null)",
		  "copyright", "Copyright (c) 2000 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "web", _("http://toutdoux.sourceforge.net/en/"), NULL);
  return ret;
}

void mod_about (void)
{
  td_about_show TD_ABOUT (TD_MOD (mod)->about);
}

GtkObject *plugins_mod_def (void)
{
  GtkObject *ret;
  GtkObject *tree[2];
  GtkObject *field[6];
  GtkObject *dico[2];
  GtkObject *icon[6];
  GtkObject *menu[6];
  GtkObject *icon_equal[6];
  GtkObject *menu_equal[7];
  GtkObject *prop[6];
  GtkWidget *prop_widget[4];
  GtkObject *prop_visible_equal[6];

  GtkWidget *toolbar;
  GtkWidget *toolbar_icon;
  GtkWidget *radiobutton1;
  GtkWidget *radiobutton2;
  GtkWidget *button1;

  int i;

  /* Greffons disponibles */
  td_palette_message (NULL, _("Cogitation : Reading plug-ins"), "begin");
  plugins_filelist = td_about_filelist (TD_APP(APP)->dir_plugins, _("view"));
  for (i=0; i<g_list_length (plugins_filelist); i++)
    {
      list_plugins = g_list_append (list_plugins, (td_about_get (g_list_nth_data (plugins_filelist, i)))->name);
      list_plugins_mod = g_list_append (list_plugins_mod, td_mod_get (g_list_nth_data (plugins_filelist, i)));
    }
  td_palette_message (NULL, _("Cogitation : Reading plug-ins"), "end");
  list_plugins = g_list_append (list_plugins, "(bud)");
  list_plugin_fields = g_list_append (list_plugin_fields, "(bud)");
  flag_entry_option = FALSE;

  /* Module */
  ret = td_mod_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "Cogitation",
		  "name_intl", "Cogitation", NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def ());

  /* Barre d'outils */
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (toolbar);
  td_mod_set_toolbar (TD_MOD (ret), toolbar);

  toolbar_icon = gnome_pixmap_new_from_file (g_strdup_printf ("%s/share/pixmaps/toutdoux/button_table.xpm", PACKAGE_DATA_DIR));
  radiobutton1 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_RADIOBUTTON, NULL, _("Table"), _("Table"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (radiobutton1);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (radiobutton1), FALSE);
  gtk_signal_connect (GTK_OBJECT (radiobutton1), "clicked", GTK_SIGNAL_FUNC (radiobutton1_clicked), NULL);

  toolbar_icon = gnome_pixmap_new_from_file (g_strdup_printf ("%s/share/pixmaps/toutdoux/button_module.xpm", PACKAGE_DATA_DIR));
  radiobutton2 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_RADIOBUTTON, radiobutton1, _("Module"), _("Module"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (radiobutton2);
  gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (radiobutton2), FALSE);
  gtk_signal_connect (GTK_OBJECT (radiobutton2), "clicked", GTK_SIGNAL_FUNC (radiobutton2_clicked), NULL);
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

  toolbar_icon = gnome_stock_pixmap_widget (TD_MOD (ret)->window, GNOME_STOCK_PIXMAP_CLOSE);
  button1 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Close"), _("Close"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (button1);
  gtk_signal_connect (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC (plugins_hide), NULL);

  /* Table : arbre */
  tree[0] = td_mod_tree_new ();
  gtk_object_set (GTK_OBJECT (tree[0]), 
		  "name", _("Table"), 
		  "reorderable", TRUE, 
		  "column_auto_resize", TRUE,
		  "customize", TRUE, NULL);
  td_mod_add_child (TD_MOD (ret), tree[0]);

  /* Table : champs */
  field[0] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[0]), 
		  "name", "table", 
		  "name_intl", _("Table"), NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[0]);

  field[1] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[1]), 
		  "name", "comment", 
		  "name_intl", _("Comment"), NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[1]);

  field[2] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[2]), 
		  "name", "type", 
		  "name_intl", _("Type"), NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[2]);

  dico[0] = td_field_dico_new ();
  td_field_dico_add_word_intl (TD_FIELD_DICO (dico[0]), "table" , _("table"));
  td_field_dico_add_word_intl (TD_FIELD_DICO (dico[0]), "field" , _("field"));
  td_field_dico_add_word_intl (TD_FIELD_DICO (dico[0]), "key field" , _("key field"));
  td_field_dico_add_word_intl (TD_FIELD_DICO (dico[0]), "type" , _("type"));
  td_field_set_dico (TD_FIELD (field[2]), dico[0]);

  /* Table : proprits */
  prop[0] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[0]), 
		  "name", _("Name"), 
		  "tab", 0, 
		  "column", 0, NULL);

  prop_widget[0] = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (prop_widget[0]), "changed", GTK_SIGNAL_FUNC (prop_table_name), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[0]), prop_widget[0], NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[0]);

  prop_visible_equal[0] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_visible_equal[0]), 2, _("table"));
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[0]), prop_visible_equal[0]);

  prop_visible_equal[1] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_visible_equal[1]), 2, _("field"));
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[0]), prop_visible_equal[1]);

  prop_visible_equal[5] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_visible_equal[5]), 2, _("key field"));
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[0]), prop_visible_equal[5]);

  prop[1] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[1]), 
		  "name", _("Comment"), 
		  "tab", 0, 
		  "column", 1, NULL);

  prop_widget[1] = gtk_entry_new ();
  gtk_signal_connect (GTK_OBJECT (prop_widget[1]), "changed", GTK_SIGNAL_FUNC (prop_table_comment), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[1]), prop_widget[1], NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[1]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[1]), prop_visible_equal[0]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[1]), prop_visible_equal[1]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[1]), prop_visible_equal[5]);

  prop[2] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[2]), 
		  "name", _("Primary key"), 
		  "defaultv", _("field"), 
		  "tab", 0, 
		  "column", 2, NULL);

  prop_widget[2] = gtk_toggle_button_new_with_label (_("field"));
  gtk_signal_connect (GTK_OBJECT (prop_widget[2]), "clicked", GTK_SIGNAL_FUNC (prop_table_key), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[2]), prop_widget[2], NULL);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[2]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[2]), prop_visible_equal[1]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[2]), prop_visible_equal[5]);

  prop[3] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[3]), 
		  "name", _("Type"), 
		  "tab", 0, 
		  "column", 0, NULL);

  prop_widget[3] = gtdk_entry_option_menu ();
  gtdk_entry_option_menu_set_popdown_strings (prop_widget[3], DATA_LIST_TYPE);
  gtk_signal_connect (GTK_OBJECT (g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget[3])), 0)), "changed", GTK_SIGNAL_FUNC (prop_table_type), GTK_OBJECT (tree[0]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[3]), g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget[3])), 0), prop_widget[3]);
  td_mod_tree_add_property (TD_MOD_TREE (tree[0]), prop[3]);

  prop_visible_equal[3] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_visible_equal[3]), 2, _("type"));
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[3]), prop_visible_equal[3]);

  /* Table : icones */
  icon[0] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[0]), (gchar*) table_xpm, (gchar*) table_xpm);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[0]);

  icon_equal[0] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[0]), 2, _("table"));
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[0]), icon_equal[0]);

  icon[1] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[1]), (gchar*) champs_xpm, (gchar*) champs_xpm);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[1]);

  icon_equal[1] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[1]), 2, _("field"));
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[1]), icon_equal[1]);

  icon[2] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[2]), (gchar*) cle_xpm, (gchar*) cle_xpm);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[2]);

  icon_equal[2] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[2]), 2, _("key field"));
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[2]), icon_equal[2]);

  icon[3] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[3]), (gchar*) type_xpm, (gchar*) type_xpm);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[0]), icon[3]);

  icon_equal[3] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[3]), 2, _("type"));
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[3]), icon_equal[3]);

  /* Table : menu */
  td_mod_tree_set_default_menu (TD_MOD_TREE (tree[0]), gnome_popup_menu_new (menu_table_default_uiinfo));

  menu[0] = td_mod_tree_menu_new ();
  td_mod_tree_menu_set (TD_MOD_TREE_MENU (menu[0]), gnome_popup_menu_new (menu_table_table_uiinfo));
  td_mod_tree_add_menu (TD_MOD_TREE (tree[0]), menu[0]);

  menu_equal[0] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (menu_equal[0]), 2, _("table"));
  td_mod_tree_menu_add_equal (TD_MOD_TREE_MENU (menu[0]), menu_equal[0]);

  menu[1] = td_mod_tree_menu_new ();
  td_mod_tree_menu_set (TD_MOD_TREE_MENU (menu[1]), gnome_popup_menu_new (menu_table_champs_uiinfo));
  td_mod_tree_add_menu (TD_MOD_TREE (tree[0]), menu[1]);

  menu_equal[1] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (menu_equal[1]), 2, _("field"));
  td_mod_tree_menu_add_equal (TD_MOD_TREE_MENU (menu[1]), menu_equal[1]);

  menu[2] = td_mod_tree_menu_new ();
  td_mod_tree_menu_set (TD_MOD_TREE_MENU (menu[2]), gnome_popup_menu_new (menu_table_champs_uiinfo));
  td_mod_tree_add_menu (TD_MOD_TREE (tree[0]), menu[2]);

  menu_equal[2] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (menu_equal[2]), 2, _("key field"));
  td_mod_tree_menu_add_equal (TD_MOD_TREE_MENU (menu[2]), menu_equal[2]);

  menu[3] = td_mod_tree_menu_new ();
  td_mod_tree_menu_set (TD_MOD_TREE_MENU (menu[3]), gnome_popup_menu_new (menu_table_type_uiinfo));
  td_mod_tree_add_menu (TD_MOD_TREE (tree[0]), menu[3]);

  menu_equal[3] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (menu_equal[3]), 2, _("type"));
  td_mod_tree_menu_add_equal (TD_MOD_TREE_MENU (menu[3]), menu_equal[3]);

  /* Module : arbre */
  tree[1] = td_mod_tree_new ();
  gtk_object_set (GTK_OBJECT (tree[1]), 
		  "name", _("Module"), 
		  "reorderable", TRUE, 
		  "column_auto_resize", TRUE,
		  "customize", TRUE, NULL);
  td_mod_add_child (TD_MOD (ret), tree[1]);

  /* Module : champs */
  field[3] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[3]), 
		  "name", "Module", 
		  "name_intl", _("Module"), NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[1]), field[3]);

  field[4] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[4]), 
		  "name", "Table", 
		  "name_intl", _("Table"), NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[1]), field[4]);

  field[5] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[5]), 
		  "name", "type", 
		  "name_intl", _("Type"), NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[1]), field[5]);

  dico[1] = td_field_dico_new ();
  td_field_dico_add_word_intl (TD_FIELD_DICO (dico[1]), "table" , _("table"));
  td_field_dico_add_word_intl (TD_FIELD_DICO (dico[1]), "field" , _("field"));
  td_field_set_dico (TD_FIELD (field[5]), dico[1]);

  /* Module : proprits */
  prop[4] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[4]), 
		  "name", _("Name"), 
		  "tab", 1, 
		  "column", 0, NULL);

  prop_widget_plugins = gtdk_entry_option_menu ();
  gtdk_entry_option_menu_set_popdown_strings (prop_widget_plugins, list_plugins);
  gtk_signal_connect (GTK_OBJECT (g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget_plugins)), 0)), "changed", GTK_SIGNAL_FUNC (prop_module_module), GTK_OBJECT (tree[1]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[4]), g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget_plugins)), 0), prop_widget_plugins);
  td_mod_tree_add_property (TD_MOD_TREE (tree[1]), prop[4]);

  prop_visible_equal[6] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (prop_visible_equal[6]), 2, _("module"));
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[4]), prop_visible_equal[6]);

  prop[5] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[5]), 
		  "name", _("Name"), 
		  "tab", 1, 
		  "column", 0, NULL);

  prop_widget_plugin_fields = gtdk_entry_option_menu ();
  gtdk_entry_option_menu_set_popdown_strings (prop_widget_plugin_fields, list_plugin_fields);
  gtk_signal_connect (GTK_OBJECT (g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget_plugin_fields)), 0)), "changed", GTK_SIGNAL_FUNC (prop_module_fields), GTK_OBJECT (tree[1]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[5]), g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget_plugin_fields)), 0), prop_widget_plugin_fields);
  td_mod_tree_add_property (TD_MOD_TREE (tree[1]), prop[5]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[5]), prop_visible_equal[1]);

  prop[6] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[6]), 
		  "name", _("Table"), 
		  "tab", 1, 
		  "column", 1, NULL);

  prop_widget_module_table = gtdk_entry_option_menu ();
  gtk_signal_connect (GTK_OBJECT (g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget_module_table)), 0)), "changed", GTK_SIGNAL_FUNC (prop_module_table), GTK_OBJECT (tree[1]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[6]), g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget_module_table)), 0), prop_widget_module_table);
  td_mod_tree_add_property (TD_MOD_TREE (tree[1]), prop[6]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[6]), prop_visible_equal[6]);

  prop[7] = td_mod_tree_prop_new ();
  gtk_object_set (GTK_OBJECT (prop[7]), 
		  "name", _("Table"), 
		  "tab", 1, 
		  "column", 1, NULL);

  prop_widget_module_table_fields = gtdk_entry_option_menu ();
  gtk_signal_connect (GTK_OBJECT (g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget_module_table_fields)), 0)), "changed", GTK_SIGNAL_FUNC (prop_module_table_fields), GTK_OBJECT (tree[1]));
  td_mod_tree_prop_set_widget (TD_MOD_TREE_PROP (prop[7]), g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget_module_table_fields)), 0), prop_widget_module_table_fields);
  td_mod_tree_add_property (TD_MOD_TREE (tree[1]), prop[7]);
  td_mod_tree_prop_add_visible (TD_MOD_TREE_PROP (prop[7]), prop_visible_equal[1]);

  /* Module : icones */
  icon[4] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[4]), (gchar*) list_module_xpm, (gchar*) list_module_xpm);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[1]), icon[4]);

  icon_equal[4] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[4]), 2, _("module"));
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[4]), icon_equal[4]);

  icon[5] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[5]), (gchar*) champs_xpm, (gchar*) champs_xpm);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[1]), icon[5]);

  icon_equal[5] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[5]), 2, _("field"));
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[5]), icon_equal[5]);

  icon[6] = td_mod_tree_icon_new ();
  td_mod_tree_icon_set (TD_MOD_TREE_ICON (icon[6]), (gchar*) proprietes_xpm, (gchar*) proprietes_xpm);
  td_mod_tree_add_icon (TD_MOD_TREE (tree[1]), icon[6]);

  icon_equal[6] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (icon_equal[6]), 2, _("property"));
  td_mod_tree_icon_add_equal (TD_MOD_TREE_ICON (icon[6]), icon_equal[6]);

  /* Module : menu */
  td_mod_tree_set_default_menu (TD_MOD_TREE (tree[1]), gnome_popup_menu_new (menu_module_default_uiinfo));

  menu[4] = td_mod_tree_menu_new ();
  td_mod_tree_menu_set (TD_MOD_TREE_MENU (menu[4]), gnome_popup_menu_new (menu_module_module_uiinfo));
  td_mod_tree_add_menu (TD_MOD_TREE (tree[1]), menu[4]);

  menu_equal[4] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (menu_equal[4]), 2, _("module"));
  td_mod_tree_menu_add_equal (TD_MOD_TREE_MENU (menu[4]), menu_equal[4]);

  menu[5] = td_mod_tree_menu_new ();
  td_mod_tree_menu_set (TD_MOD_TREE_MENU (menu[5]), gnome_popup_menu_new (menu_module_champs_uiinfo));
  td_mod_tree_add_menu (TD_MOD_TREE (tree[1]), menu[5]);

  menu_equal[5] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (menu_equal[5]), 2, _("field"));
  td_mod_tree_menu_add_equal (TD_MOD_TREE_MENU (menu[5]), menu_equal[5]);

  menu_equal[6] = td_mod_tree_equal_new ();
  td_mod_tree_equal_add (TD_MOD_TREE_EQUAL (menu_equal[6]), 2, _("property"));
  td_mod_tree_menu_add_equal (TD_MOD_TREE_MENU (menu[5]), menu_equal[6]);

  return ret;
}

void plugins_init (int mod_id)
{
  mod = plugins_mod_def ();
  td_mod_create (TD_MOD (mod), mod_id);
  gtk_signal_connect (GTK_OBJECT (TD_MOD(mod)->notebook), "switch_page", GTK_SIGNAL_FUNC (switch_page), NULL);
}

void plugins_show (void)
{
  td_mod_show (TD_MOD (mod));
}

void plugins_hide (void)
{
  td_mod_hide (TD_MOD (mod));
}

void plugins_destroy (void)
{
  td_mod_destroy (TD_MOD (mod));
}

void plugins_custom (void)
{
  td_mod_custom_show (mod);
}


/*****************************************************************************/
/* Proprits */
/*****************************************************************************/
void prop_table_name (GtkWidget *widget, GtkObject *mod_tree)
{
  td_mod_tree_refresh_node (widget, mod_tree, 0, FALSE, FALSE);
}

void prop_table_type (GtkWidget *widget, GtkObject *mod_tree)
{
  td_mod_tree_refresh_node (widget, mod_tree, 0, FALSE, FALSE);
}

void prop_table_key (GtkWidget *widget, GtkObject *mod_tree)
{
  GtkWidget *label_tampon;
  label_tampon = GTK_BUTTON (widget)->child;
  if (GTK_TOGGLE_BUTTON (widget)->active)
    gtk_label_set_text (GTK_LABEL (label_tampon), _("key field"));
  else
    gtk_label_set_text (GTK_LABEL (label_tampon), _("field"));
  td_mod_tree_refresh_node (widget, mod_tree, 2, FALSE, TRUE);
}

void prop_table_comment (GtkWidget *widget, GtkObject *mod_tree)
{
  td_mod_tree_refresh_node (widget, mod_tree, 1, FALSE, FALSE);
}

gboolean prop_module_module (GtkWidget *widget, GtkObject *mod_tree)
{
  int i;
  GtkObject *mod_tmp;
  GtkObject *mod_tree_tmp;
  gboolean bool_tmp;

  /* Sans greffon */
  td_mod_tree_refresh_node (widget, mod_tree, 0, FALSE, FALSE);
  if (!strcmp ("(bud)", gtk_entry_get_text (GTK_ENTRY (widget))))
    {
      list_plugin_fields = NULL;
      list_plugin_fields = g_list_append (list_plugin_fields, "(bud)");
      flag_entry_option = TRUE;
      gtdk_entry_option_menu_set_popdown_strings (prop_widget_plugin_fields, list_plugin_fields);
      flag_entry_option = FALSE;
      return TRUE;
    }

  /* Recherhe du greffon */
  bool_tmp = FALSE;
  for (i=0; i< g_list_length (list_plugins); i++)
    if (!strcmp ((gchar*) g_list_nth_data (list_plugins, i), gtk_entry_get_text (GTK_ENTRY (widget))))
      {
	bool_tmp = TRUE;
	break;
      }
  if (!bool_tmp)
    {
      list_plugin_fields = NULL;
      list_plugin_fields = g_list_append (list_plugin_fields, "(bud)");
      flag_entry_option = TRUE;
      gtdk_entry_option_menu_set_popdown_strings (prop_widget_plugin_fields, list_plugin_fields);
      flag_entry_option = FALSE;
      return TRUE;
    }

  /* Champs du greffon */
  mod_tmp = g_list_nth_data (list_plugins_mod, i);
  mod_tree_tmp = g_list_nth_data (TD_MOD (mod_tmp)->child, 0);
  list_plugin_fields = NULL;
  for (i=0; i<g_list_length (TD_MOD_TREE (mod_tree_tmp)->field); i++)
    list_plugin_fields = g_list_append (list_plugin_fields, TD_FIELD (g_list_nth_data (TD_MOD_TREE (mod_tree_tmp)->field, i))->name);
  flag_entry_option = TRUE;
  gtdk_entry_option_menu_set_popdown_strings (prop_widget_plugin_fields, list_plugin_fields);
  flag_entry_option = FALSE;
  return TRUE;
}

void prop_module_fields (GtkWidget *widget, GtkObject *mod_tree)
{
  if (!flag_entry_option)
    td_mod_tree_refresh_node (widget, mod_tree, 0, FALSE, FALSE);
}

void prop_module_table (GtkWidget *widget, GtkObject *mod_tree)
{
  gboolean bool_tmp;
  GList *data;
  int i;

  /* Sans table */
  td_mod_tree_refresh_node (widget, mod_tree, 1, FALSE, FALSE);
  if (!strcmp ("(bud)", gtk_entry_get_text (GTK_ENTRY (widget))))
    {
      list_table_fields = NULL;
      list_table_fields = g_list_append (list_table_fields, "(bud)");
      flag_entry_option = TRUE;
      gtdk_entry_option_menu_set_popdown_strings (prop_widget_module_table_fields, list_table_fields);
      flag_entry_option = FALSE;
    }

  /* Recherhe de la table */
  bool_tmp = FALSE;
  for (i=0; i< g_list_length (list_table); i++)
    if (!strcmp ((gchar*) g_list_nth_data (list_table, i), gtk_entry_get_text (GTK_ENTRY (widget))))
      {
	bool_tmp = TRUE;
	break;
      }
  if (!bool_tmp)
    {
      list_table_fields = NULL;
      list_table_fields = g_list_append (list_table_fields, "(bud)");
      flag_entry_option = TRUE;
      gtdk_entry_option_menu_set_popdown_strings (prop_widget_module_table_fields, list_table_fields);
      flag_entry_option = FALSE;
    }

  /* Champs de la table */
  data = g_list_nth_data (list_table_list, i);
  list_table_fields = NULL;
  for (i=0; i<g_list_length (data); i++)
    list_table_fields = g_list_append (list_table_fields, g_list_nth_data (data, i));
  flag_entry_option = TRUE;
  gtdk_entry_option_menu_set_popdown_strings (prop_widget_module_table_fields, list_table_fields);
  flag_entry_option = FALSE;
}

void prop_module_table_fields (GtkWidget *widget, GtkObject *mod_tree)
{
  if (!flag_entry_option)
    td_mod_tree_refresh_node (widget, mod_tree, 1, FALSE, FALSE);
}


/*****************************************************************************/
/* Menus */
/*****************************************************************************/
void menu_table_new (GtkMenuItem *menuitem, gpointer user_data)
{
  GList *data = NULL;
  GtkCTreeNode *node;

  /* Valeurs */
  data = g_list_append (data, "(bud)");
  data = g_list_append (data, "(bud)");
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Create table"))))
    data = g_list_append (data, _("table"));
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Create field"))))
    data = g_list_append (data, _("field"));
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Create type"))))
    data = g_list_append (data, _("type"));

  /* Node */
  if (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected)
    td_mod_tree_expand (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), NULL);
  node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected , NULL, data, TRUE);
  g_list_free (data);
}

void menu_table_new_admin (GtkMenuItem *menuitem, gpointer user_data)
{
  GList *data = NULL;
  GtkCTreeNode *node_field;
  GtkCTreeNode *node;
  int i;

  /* Node */
  for (i=0; i<g_list_length (TD_APP (APP)->admin_field); i++)
    {
      /* Champs */
      data = g_list_append (data, TD_FIELD (g_list_nth_data (TD_APP (APP)->admin_field, i))->name);
      data = g_list_append (data, "(bud)");
      if (!i)
	data = g_list_append (data, _("key field"));
      else
	data = g_list_append (data, _("field"));
      node_field = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->selected , NULL, data, TRUE);
      data = NULL;

      /* Type */
      data = g_list_append (data, TD_FIELD (g_list_nth_data (TD_APP (APP)->admin_field, i))->type);
      data = g_list_append (data, "(bud)");
      data = g_list_append (data, _("type"));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), node_field , NULL, data, TRUE);
      data = NULL;
    }
  g_list_free (data);
  td_mod_tree_expand (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), NULL);
}

void menu_table_remove (GtkMenuItem *menuitem, gpointer user_data)
{
  td_mod_tree_remove_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
}

void menu_module_new (GtkMenuItem *menuitem, gpointer user_data)
{
  GList *data = NULL;
  GtkCTreeNode *node;

  /* Valeurs */
  data = g_list_append (data, "(bud)");
  data = g_list_append (data, "(bud)");
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Create module"))))
    data = g_list_append (data, _("module"));
  if (!strcmp (GTK_WIDGET (menuitem)->name, g_strdup_printf("%s%s", PREFIX_WIDGET_PLUGINS, _("Create field"))))
    data = g_list_append (data, _("field"));

  /* Node */
  if (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected)
    td_mod_tree_expand (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), NULL);
  node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected , NULL, data, TRUE);
  g_list_free (data);
}

gboolean menu_module_new_predef (GtkMenuItem *menuitem, gpointer user_data)
{
  GList *data = NULL;
  GtkCTreeNode *node;
  int i;
  GtkObject *mod_tmp;
  GtkObject *mod_tree_tmp;

  /* Sans greffon */
  if (!strcmp ("(bud)", gtk_entry_get_text (GTK_ENTRY (g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget_plugins)), 0)))))
    return TRUE;

  /* Donnes utilisateur */
  for (i=0; i< g_list_length (list_plugins); i++)
    if (!strcmp ((gchar*) g_list_nth_data (list_plugins, i), gtk_entry_get_text (GTK_ENTRY (g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget_plugins)), 0)))))
      break;
  mod_tmp = g_list_nth_data (list_plugins_mod, i);
  mod_tree_tmp = g_list_nth_data (TD_MOD (mod_tmp)->child, 0);
  for (i=0; i<g_list_length (TD_MOD_TREE (mod_tree_tmp)->field); i++)
    {
      data = g_list_append (data, TD_FIELD (g_list_nth_data (TD_MOD_TREE (mod_tree_tmp)->field, i))->name);
      data = g_list_append (data, "(bud)");
      data = g_list_append (data, _("field"));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected , NULL, data, TRUE);
      data = NULL;
    }

  /* Donnes administrateur */
  for (i=0; i<g_list_length (TD_APP (APP)->admin_field); i++)
    {
      data = g_list_append (data, TD_FIELD (g_list_nth_data (TD_APP (APP)->admin_field, i))->name);
      data = g_list_append (data, "(bud)");
      data = g_list_append (data, _("field"));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected , NULL, data, TRUE);
      data = NULL;
    }
  g_list_free (data);
  td_mod_tree_expand (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), NULL);
  return TRUE;
}

gboolean menu_module_new_predef2 (GtkMenuItem *menuitem, gpointer user_data)
{
  GList *data = NULL;
  GtkCTreeNode *node;
  GtkCTreeNode *node_table;
  GtkCTreeNode *node_field;
  int i;
  GtkObject *mod_tmp;
  GtkObject *mod_tree_tmp;
  gchar *txt_tmp;

  /* Sans greffon */
  if (!strcmp ("(bud)", gtk_entry_get_text (GTK_ENTRY (g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget_plugins)), 0)))))
    return TRUE;

  /* Donnes utilisateur */
  for (i=0; i< g_list_length (list_plugins); i++)
    if (!strcmp ((gchar*) g_list_nth_data (list_plugins, i), gtk_entry_get_text (GTK_ENTRY (g_list_nth_data (gtk_container_children (GTK_CONTAINER (prop_widget_plugins)), 0)))))
      break;
  mod_tmp = g_list_nth_data (list_plugins_mod, i);
  mod_tree_tmp = g_list_nth_data (TD_MOD (mod_tmp)->child, 0);
  gtk_ctree_node_get_text (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget)->child), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected, 1, &txt_tmp);
  data = g_list_append (data, txt_tmp);
  data = g_list_append (data, "(bud)");
  data = g_list_append (data, _("table"));
  node_table = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), NULL, NULL, data, TRUE);
  data = NULL;
  for (i=0; i<g_list_length (TD_MOD_TREE (mod_tree_tmp)->field); i++)
    {
      /* Champs : table */
      data = g_list_append (data, TD_FIELD (g_list_nth_data (TD_MOD_TREE (mod_tree_tmp)->field, i))->name);
      data = g_list_append (data, "(bud)");
      data = g_list_append (data, _("field"));
      node_field = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), node_table, NULL, data, TRUE);
      data = NULL;

      /* Type : table */
      data = g_list_append (data, TD_FIELD (g_list_nth_data (TD_MOD_TREE (mod_tree_tmp)->field, i))->type);
      data = g_list_append (data, "(bud)");
      data = g_list_append (data, _("type"));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), node_field , NULL, data, TRUE);
      data = NULL;

      /* Champs : module */
      data = g_list_append (data, TD_FIELD (g_list_nth_data (TD_MOD_TREE (mod_tree_tmp)->field, i))->name);
      data = g_list_append (data, TD_FIELD (g_list_nth_data (TD_MOD_TREE (mod_tree_tmp)->field, i))->name);
      data = g_list_append (data, _("field"));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected , NULL, data, TRUE);
      data = NULL;
    }

  /* Donnes administrateur */
  for (i=0; i<g_list_length (TD_APP (APP)->admin_field); i++)
    {

      /* Champs : table */
      data = g_list_append (data, TD_FIELD (g_list_nth_data (TD_APP (APP)->admin_field, i))->name);
      data = g_list_append (data, "(bud)");
      if (!i)
	data = g_list_append (data, _("key field"));
      else
	data = g_list_append (data, _("field"));
      node_field = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), node_table, NULL, data, TRUE);
      data = NULL;

      /* Type : table */
      data = g_list_append (data, TD_FIELD (g_list_nth_data (TD_APP (APP)->admin_field, i))->type);
      data = g_list_append (data, "(bud)");
      data = g_list_append (data, _("type"));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), node_field , NULL, data, TRUE);
      data = NULL;

      /* Champs : module */
      data = g_list_append (data, TD_FIELD (g_list_nth_data (TD_APP (APP)->admin_field, i))->name);
      data = g_list_append (data, TD_FIELD (g_list_nth_data (TD_APP (APP)->admin_field, i))->name);
      data = g_list_append (data, _("field"));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->selected , NULL, data, TRUE);
      data = NULL;
    }
  g_list_free (data);
  td_mod_tree_expand (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), NULL);
  return TRUE;
}

void menu_module_remove (GtkMenuItem *menuitem, gpointer user_data)
{
  td_mod_tree_remove_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)));
}

gboolean menu_import_file (GtkMenuItem *menuitem, gpointer user_data)
{
  GtkObject *base;
  gchar *txt_tmp;
  gchar *file;
  int fp;
  struct stat stat_tmp;

  /* Choix du fichier */
  file = g_strdup_printf ("%s", td_fileselector_create_window (_("Import file"), NULL, TRUE));
  if ((!file) || (!strcmp (file, "(null)")))
    return TRUE;

  /* Vrif de l'existence du fichier */
  fp = open (file, O_RDONLY);
  if (fp == -1)
    {
      td_palette_message (_("Loading file"), g_strdup_printf (_("Loading file : '%s'"), file), "failed");
      td_palette_message (NULL, _("Loading file"), "end");
      return FALSE;
    }
  fstat (fp, &stat_tmp);
  close (fp);
  if (S_ISDIR(stat_tmp.st_mode))
    {
      td_palette_message (_("Loading file"), g_strdup_printf(_("Loading file '%s' : It's not a file"), file), "failed");
      td_palette_message (NULL, _("Loading file"), "end");
      return FALSE;
    }

  /* Verif du contenu du fichier et conversion ancien format */
  base = td_db_base_load_hopla (file);
  if (!base)
    {
      td_palette_message (_("Loading file"), g_strdup_printf(_("Loading file '%s' : file unreadable"), file), "failed");
      td_palette_message (NULL, _("Loading file"), "end");
      return FALSE;
    }

  /* Go ! */
  plugins_load (TD_DB_BASE (base));
  return TRUE;
}

gboolean menu_save_db (GtkMenuItem *menuitem, gpointer user_data)
{
  GtkObject *base;
  void (*symbol)();
  gboolean (*symbol2)();
  gchar *file;

  /* Base de donnes ouverte ? */
  td_palette_message (NULL, _("Saving database"), "begin");
  if (strcmp (TD_DB_CONNECT (TD_APP(APP)->connect)->type , "database"))
    {
      td_palette_message (_("Saving database"), _("Saving database : not database opened"), "failed");
      td_palette_message (NULL, _("Saving database"), "end");
    }

  /* Ecriture fichier */
  file = g_strdup_printf ("%s/database.toutdoux", TD_APP(APP)->dir_tmp);
  base = plugins_save ();
  if (!td_db_base_save_hopla (TD_DB_BASE(base), file))
    {
      td_palette_message (_("Saving"), g_strdup_printf (_("Saving : file '%s' unreadable"), file) , "failed");
      td_palette_message (NULL, _("Saving"), "end");
      return FALSE;
    }
  td_palette_message (_("Wrote file"), g_strdup_printf (_("Wrote file '%s'"), file), "message");

  /* Ecriture base de donnes */
  (gpointer*) symbol2 = td_dlsym (PLUGINS_CORE[4], NULL, "libcommunication_db.so", "plugins_save_structure");
  if (!symbol2 (TD_APP(APP)->connect))
    {
      (gpointer*) symbol = td_dlsym (PLUGINS_CORE[2], NULL, "libmessages.so", "plugins_load");
      symbol (g_strdup_printf ("%s/log.xml", TD_APP(APP)->dir_tmp));
      td_palette_message (_("Saving"), _("Saving : database unreadable"), "failed");
      td_palette_message (NULL, _("Saving"), "end");
      return FALSE;
    }
  td_palette_message (_("Wrote database"), g_strdup_printf (_("Wrote database '%s'"), TD_DB_CONNECT (TD_APP(APP)->connect)->base), "message");
  (gpointer*) symbol = td_dlsym (PLUGINS_CORE[2], NULL, "libmessages.so", "plugins_load");
  symbol (g_strdup_printf ("%s/log.xml", TD_APP(APP)->dir_tmp));
  td_palette_message (NULL, _("Saving database"), "end");
  return TRUE;
}

/*****************************************************************************/
/* Fichier */
/*****************************************************************************/
void plugins_clear (void)
{
  /* Razage */
  td_mod_tree_clear (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)));
  td_mod_tree_clear (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)));
  gtk_window_set_title (GTK_WINDOW (TD_MOD (mod)->window), g_strdup_printf ("ToutDoux : %s : %s", TD_MOD (mod)->name_intl, TD_DB_CONNECT (TD_APP(APP)->connect)->name));
}

gboolean plugins_load (TdDbBase *base)
{
  GList *data = NULL;
  TdDbTable *table;
  TdDbTableField *table_field;
  TdDbMod *base_mod;
  TdDbModField *mod_field;
  GtkCTreeNode *node;
  GtkCTreeNode *node1;
  GtkCTreeNode *node2;
  int i, j, k;

  /* Table */
  for (i=0; i<g_list_length (base->table); i++)
    {
      table = g_list_nth_data (base->table, i);
      data = g_list_append (data, table->name);
      data = g_list_append (data, table->comment);
      data = g_list_append (data, _("table"));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), NULL, NULL, data, TRUE);
      data = NULL;

      /* Champs */
      for (j=0; j<g_list_length (table->field); j++)
	{
	  table_field = g_list_nth_data (table->field, j);
	  data = g_list_append (data, table_field->name);
	  data = g_list_append (data, table_field->comment);
	  if (table_field->key)
	    data = g_list_append (data, _("key field"));
	  else
	    data = g_list_append (data, _("field"));
	  node1 = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), node, NULL, data, TRUE);
	  data = NULL;

	  /* Type */
	  data = g_list_append (data, table_field->type);
	  data = g_list_append (data, table_field->typecomment);
	  data = g_list_append (data, _("type"));
	  node2 = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), node1, NULL, data, TRUE);
	  data = NULL;
	}
    }

  /* Vues */
  for (i=0; i<g_list_length (base->mod); i++)
    {
      base_mod = g_list_nth_data (base->mod, i);
      data = g_list_append (data, base_mod->name);
      data = g_list_append (data, base_mod->table);
      data = g_list_append (data, _("module"));
      node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), NULL, NULL, data, TRUE);
      data = NULL;

      /* Champs */
      for (j=0; j<g_list_length (base_mod->field); j++)
	{
	  mod_field = g_list_nth_data (base_mod->field, j);
	  data = g_list_append (data, mod_field->name);
	  data = g_list_append (data, mod_field->table_field);
	  data = g_list_append (data, _("field"));
	  node1 = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), node, NULL, data, TRUE);
	  data = NULL;

  	  /* Proprietes */
	  for (k=0; k<g_list_length (mod_field->property_name); k++)
	    {
	      data = g_list_append (data, g_list_nth_data (mod_field->property_name, k));
	      data = g_list_append (data, g_list_nth_data (mod_field->property_value, k));
	      data = g_list_append (data, _("property"));
	      node2 = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), node1, NULL, data, TRUE);
	      data = NULL;
	    }
	}
    }
  gtk_window_set_title (GTK_WINDOW (TD_MOD (mod)->window), g_strdup_printf ("ToutDoux : %s : %s", TD_MOD (mod)->name_intl, TD_DB_CONNECT (TD_APP(APP)->connect)->name));
  g_list_free (data);
  return TRUE;
}

GtkObject *plugins_save (void)
{
  GtkObject *ret;
  GList *data = NULL;
  GtkObject *table = NULL;
  GtkObject *table_field = NULL;
  GtkObject *mod2 = NULL;
  GtkObject *mod_field = NULL;
  GtkCTreeNode *node;
  int i,j;

  /* Base */
  ret = td_db_base_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "(null)", 
		  "comment", "(null)", NULL);

  /* Tables */
  node = gtk_ctree_node_nth (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child), 0);
  while (node)
    {
      data = td_mod_tree_read_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), node, FALSE);

      /* Table */
      if (!strcmp (g_list_nth_data (data, 2), _("table")))
	{
	  table = td_db_table_new ();
	  gtk_object_set (table, 
			  "name", g_list_nth_data (data, 0), 
			  "comment", g_list_nth_data (data, 1), NULL);
	  td_db_base_add_table (TD_DB_BASE (ret), table);
	}

      /* Champs */			
      if (!strcmp (g_list_nth_data (data, 2), _("field")))
	{
	  table_field = td_db_table_field_new ();
	  gtk_object_set (table_field,
			  "name", g_list_nth_data (data, 0), 
			  "comment", g_list_nth_data (data, 1), 
			  "key", 0, NULL);
	  td_db_table_add_field (TD_DB_TABLE (table), table_field);
	}
      if (!strcmp (g_list_nth_data (data, 2), _("key field")))
	{
	  table_field = td_db_table_field_new ();
	  gtk_object_set (table_field,
			  "name", g_list_nth_data (data, 0), 
			  "comment", g_list_nth_data (data, 1), 
			  "key", 1, NULL);
	  td_db_table_add_field (TD_DB_TABLE (table), table_field);
	}

      /* Type */
      if (!strcmp (g_list_nth_data (data, 2), _("type")))
	gtk_object_set (table_field,
			"type", g_list_nth_data (data, 0), 
			"typecomment", g_list_nth_data (data, 1), NULL);
      node = gtdk_ctree_next (node);
      data = NULL;
    }

  /* Modules */
  node = gtk_ctree_node_nth (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1))->widget)->child), 0);
  while (node)
    {
      data = td_mod_tree_read_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 1)), node, FALSE);

        /* Module */ 
      if (!strcmp (g_list_nth_data (data, 2), _("module")))
	{
	  mod2 = td_db_mod_new ();
	  gtk_object_set (mod2, 
			  "name", g_list_nth_data (data, 0),
			  "table", g_list_nth_data (data, 1), NULL); 
	  td_db_base_add_mod (TD_DB_BASE (ret), mod2);
	}

      /* Champs */ 
      if (!strcmp (g_list_nth_data (data, 2), _("field")))
	{
	  mod_field = td_db_mod_field_new ();
	  gtk_object_set (GTK_OBJECT (mod_field),
			  "name", g_list_nth_data (data, 0),
			  "table_field", g_list_nth_data (data, 1), NULL);
	  td_db_mod_add_field (TD_DB_MOD (mod2), mod_field);
	}

      /* Proprietes */ 
      if (!strcmp (g_list_nth_data (data, 2), _("property")))
	td_db_mod_field_add_property (TD_DB_MOD_FIELD (mod_field), g_list_nth_data (data, 0), g_list_nth_data (data, 1));
      node = gtdk_ctree_next (node);
      data = NULL;
    }
  gtk_window_set_title (GTK_WINDOW (TD_MOD (mod)->window), g_strdup_printf ("ToutDoux : %s : %s", TD_MOD (mod)->name_intl, TD_DB_CONNECT (TD_APP(APP)->connect)->name));
  g_list_free (data);
  return ret;
}

/*****************************************************************************/
/* Barre d'outils */
/*****************************************************************************/
void radiobutton1_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->notebook), 0);
}
void radiobutton2_clicked (GtkRadioButton *radiobutton, gpointer *user_data)
{
  gtk_notebook_set_page (GTK_NOTEBOOK (TD_MOD (mod)->notebook), 1);
}

/*****************************************************************************/
/* Evnement */
/*****************************************************************************/
void switch_page (GtkNotebook *notebook, GtkNotebookPage *page, gint page_num)
{
  int i;
  GtkCTreeNode *node;
  GtkObject *mod_tmp;
  GtkObject *mod_tree_tmp;
  GList *data;
  GList *data2 = NULL;
  gboolean bool_tmp;

  /* Tables */
  node = gtk_ctree_node_nth (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0))->widget)->child), 0);
  list_table = NULL;
  list_table_list = NULL;
  bool_tmp = FALSE;
  while (node)
    {
      data = td_mod_tree_read_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, 0)), node, FALSE);

      /* Table */
      if (!strcmp (g_list_nth_data (data, 2), _("table")))
	{
	  list_table = g_list_append (list_table, g_list_nth_data (data, 0));
	  if (bool_tmp)
	    {
	      if (!data2)
		data2 = g_list_append (data2, "(bud)");
	      list_table_list = g_list_append (list_table_list, data2);
	      data2 = NULL;
	    }
	  bool_tmp = TRUE;
	}

      /* Champs */			
      if (!strcmp (g_list_nth_data (data, 2), _("field")))
	data2 = g_list_append (data2, g_list_nth_data (data, 0));
      if (!strcmp (g_list_nth_data (data, 2), _("key field")))
	data2 = g_list_append (data2, g_list_nth_data (data, 0));
      node = gtdk_ctree_next (node);
    }
  if (bool_tmp)
    list_table_list = g_list_append (list_table_list, data2);
  list_table = g_list_append (list_table, "(bud)");
  gtdk_entry_option_menu_set_popdown_strings (prop_widget_module_table, list_table);
}
