/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : prfrences de dmarrage
 * ToutDoux's plug-in : start preferences
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <toutdoux.h>

#include "main.h"

/*****************************************************************************/
/* Variables globales */
/*****************************************************************************/
GtkWidget *radiobutton1;
GtkWidget *radiobutton2;
GtkWidget *radiobutton3;
GtkWidget *frame3;
GtkWidget *radiobutton4;
GtkWidget *radiobutton5;
GtkWidget *radiobutton6;
GtkWidget *radiobutton7;
GtkWidget *frame4;
GtkWidget *checkbutton1;
GtkWidget *checkbutton2;
GtkWidget *frame5;
GtkWidget *hbox1;
GtkWidget *entry1;
GtkWidget *combo1;

/*****************************************************************************/
/* Module *//* FIXME: refaire en conception objets - recast with object design : +tards - this night */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("Start's default open"),
		  "type", _("preferences"),
		  "version", "1.0.1",
		  "blurb", _("Start's default open"),
		  "authors", "Philippe Roy <ph_roy@yahoo.com>",
		  "help", "(null)",
		  "category1", _("core"),
		  "category2", _("customize"),
		  "category3", _("starting"),
		  "copyright", "Copyright (c) 2000 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "web", "(null)", NULL);
  return ret;
}

GtkObject *plugins_custom_def (void)
{
  GtkObject *ret;
  GtkWidget *vbox1;
  GtkWidget *viewport1;
  GtkWidget *label0;
  GtkWidget *frame1;
  GtkWidget *vbox2;
  GtkWidget *frame2;
  GtkWidget *hbox4;
  GSList *hbox4_group = NULL;
  GtkWidget *hbox2;
  GSList *hbox2_group = NULL;
  GtkWidget *hbox5;
  GtkWidget *table1;
  GtkWidget *label1;
  GtkWidget *label2;
  gchar *chemin_options[11];
  gchar *txt_tampon;
  GtkWidget *hbox1;

  ret = td_custom_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("Start's default open"),
		  "category1", _("core"),
		  "category2", _("starting"),
		  "category3", "(null)", NULL);

  /* Titre */
  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  td_custom_set_frame (TD_CUSTOM (ret), vbox1);
  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport1);
  gtk_box_pack_start (GTK_BOX (vbox1), viewport1, FALSE, FALSE, 0);
  gtk_viewport_set_shadow_type (GTK_VIEWPORT (viewport1), GTK_SHADOW_OUT);
  label0 = gtk_label_new (_("Start's default open"));
  gtk_widget_show (label0);
  gtk_container_add (GTK_CONTAINER (viewport1), label0);

  /* Boutons */
  frame1 = gtk_frame_new (_("Default open"));
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox1), frame1, FALSE, FALSE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame1), GTK_SHADOW_OUT);
  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (frame1), vbox2);

  /* Type */
  frame2 = gtk_frame_new (_("Type"));
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (vbox2), frame2, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame2), 3);
  hbox4 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox4);
  gtk_container_add (GTK_CONTAINER (frame2), hbox4);
  radiobutton1 = gtk_radio_button_new_with_label (hbox4_group, _("None"));
  hbox4_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton1));
  gtk_widget_show (radiobutton1);
  gtk_box_pack_start (GTK_BOX (hbox4), radiobutton1, FALSE, FALSE, 0);
  radiobutton2 = gtk_radio_button_new_with_label (hbox4_group, _("Last"));
  hbox4_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton2));
  gtk_widget_show (radiobutton2);
  gtk_box_pack_start (GTK_BOX (hbox4), radiobutton2, FALSE, FALSE, 0);
  radiobutton3 = gtk_radio_button_new_with_label (hbox4_group, _("Fixed"));
  hbox4_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton3));
  gtk_widget_show (radiobutton3);
  gtk_box_pack_start (GTK_BOX (hbox4), radiobutton3, FALSE, FALSE, 0);

  /* Document */
  frame3 = gtk_frame_new (_("Document"));
  gtk_widget_show (frame3);
  gtk_box_pack_start (GTK_BOX (vbox2), frame3, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame3), 3);
  hbox2 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox2);
  gtk_container_add (GTK_CONTAINER (frame3), hbox2);
  radiobutton4 = gtk_radio_button_new_with_label (hbox2_group, _("All"));
  hbox2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton4));
  gtk_widget_show (radiobutton4);
  gtk_box_pack_start (GTK_BOX (hbox2), radiobutton4, FALSE, FALSE, 0);
  radiobutton5 = gtk_radio_button_new_with_label (hbox2_group, _("Template"));
  hbox2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton5));
  gtk_widget_show (radiobutton5);
  gtk_box_pack_start (GTK_BOX (hbox2), radiobutton5, FALSE, FALSE, 0);
  radiobutton6 = gtk_radio_button_new_with_label (hbox2_group, _("File"));
  hbox2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton6));
  gtk_widget_show (radiobutton6);
  gtk_box_pack_start (GTK_BOX (hbox2), radiobutton6, FALSE, FALSE, 0);
  radiobutton7 = gtk_radio_button_new_with_label (hbox2_group, _("Data Base"));
  hbox2_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton7));
  gtk_widget_show (radiobutton7);
  gtk_box_pack_start (GTK_BOX (hbox2), radiobutton7, FALSE, FALSE, 0);

  /* Option */
  frame4 = gtk_frame_new (_("Option"));
  gtk_widget_show (frame4);
  gtk_box_pack_start (GTK_BOX (vbox2), frame4, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame4), 3);
  hbox5 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox5);
  gtk_container_add (GTK_CONTAINER (frame4), hbox5);
  checkbutton1 = gtk_check_button_new_with_label (_("Template's file"));
  gtk_widget_show (checkbutton1);
  gtk_box_pack_start (GTK_BOX (hbox5), checkbutton1, FALSE, FALSE, 0);
  checkbutton2 = gtk_check_button_new_with_label (_("Template's data base"));
  gtk_widget_show (checkbutton2);
  gtk_box_pack_start (GTK_BOX (hbox5), checkbutton2, FALSE, FALSE, 0);

  /* Source tiquettes */
  frame5 = gtk_frame_new (_("Source"));
  gtk_widget_show (frame5);
  gtk_box_pack_start (GTK_BOX (vbox2), frame5, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame5), 3);
  table1 = gtk_table_new (2, 2, FALSE);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (frame5), table1);
  label1 = gtk_label_new (_("File"));
  gtk_widget_show (label1);
  gtk_table_attach (GTK_TABLE (table1), label1, 0, 1, 0, 1, (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label1), 5, 0);
  label2 = gtk_label_new (_("Data base"));
  gtk_widget_show (label2);
  gtk_table_attach (GTK_TABLE (table1), label2, 0, 1, 1, 2, (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_padding (GTK_MISC (label2), 5, 0);

  /* Source entres */
  hbox1 = gtdk_entry_file_selector (_("Select file"), NULL);
  gtk_widget_show (hbox1);
  gtk_table_attach (GTK_TABLE (table1), hbox1, 1, 2, 0, 1, (GtkAttachOptions) (GTK_FILL), (GtkAttachOptions) (GTK_FILL), 0, 0);
  entry1 = GTK_WIDGET (g_list_nth_data (gtk_container_children (GTK_CONTAINER (hbox1)), 0));
  combo1 = gtk_combo_new ();
  gtk_widget_show (combo1);
  gtk_table_attach (GTK_TABLE (table1), combo1, 1, 2, 1, 2, (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), (GtkAttachOptions) (0), 0, 0);

  /* Lecture config : Dfinition des options */
  chemin_options[0] = g_strdup_printf ("start/defaultopen_type_none");
  chemin_options[1] = g_strdup_printf ("start/defaultopen_type_last");
  chemin_options[2] = g_strdup_printf ("start/defaultopen_type_fixed");
  chemin_options[3] = g_strdup_printf ("start/defaultopen_document_all");
  chemin_options[4] = g_strdup_printf ("start/defaultopen_document_template");
  chemin_options[5] = g_strdup_printf ("start/defaultopen_document_file");
  chemin_options[6] = g_strdup_printf ("start/defaultopen_document_database");
  chemin_options[7] = g_strdup_printf ("start/defaultopen_option_templatefile");
  chemin_options[8] = g_strdup_printf ("start/defaultopen_option_templatedatabase");
  chemin_options[9] = g_strdup_printf ("start/defaultopen_source_file");
  chemin_options[10] = g_strdup_printf ("start/defaultopen_source_database");

  /* Lecture config : Boutons de choix */
  txt_tampon = g_strdup_printf("%s", gnome_config_get_string (chemin_options[0]));
  if ((!strcmp (txt_tampon, "1"))|| (!strcmp (txt_tampon, "(null)")))
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton1), TRUE);
      gtk_widget_set_sensitive (frame3, FALSE);
      gtk_widget_set_sensitive (frame4, FALSE);
      gtk_widget_set_sensitive (frame5, FALSE);
    }
  txt_tampon = g_strdup_printf("%s", gnome_config_get_string (chemin_options[1]));
  if (!strcmp (txt_tampon, "1"))
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(radiobutton2), TRUE);
      gtk_widget_set_sensitive (frame5, FALSE);
      /* FIXME : en attendant une ouverture des bases de donnes : +tards */
      /* gtk_widget_set_sensitive (frame3, TRUE); */
      /* gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(radiobutton4), TRUE); */
      /* gtk_widget_set_sensitive (radiobutton4, TRUE); */
      gtk_widget_set_sensitive (frame3, FALSE);
      gtk_widget_set_sensitive (radiobutton4, FALSE);
      gtk_widget_set_sensitive (radiobutton5, FALSE);
      gtk_widget_set_sensitive (radiobutton6, FALSE);
      gtk_widget_set_sensitive (radiobutton7, FALSE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton6), TRUE);
    }
  txt_tampon = g_strdup_printf("%s", gnome_config_get_string (chemin_options[2]));
  if (!strcmp (txt_tampon, "1"))
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton3), TRUE);
      gtk_widget_set_sensitive (frame3, TRUE);
      gtk_widget_set_sensitive (frame4, FALSE);
      gtk_widget_set_sensitive (frame5, TRUE);
      gtk_widget_set_sensitive (radiobutton4, FALSE);
      gtk_widget_set_sensitive (radiobutton5, TRUE);
      gtk_widget_set_sensitive (radiobutton6, TRUE);
      /* FIXME : en attendant une ouverture des bases de donnes : +tards */
      /* gtk_widget_set_sensitive (radiobutton7, TRUE); */
      gtk_widget_set_sensitive (radiobutton7, FALSE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton5), TRUE);
    }
  txt_tampon = g_strdup_printf("%s", gnome_config_get_string (chemin_options[3]));
  if (!strcmp (txt_tampon, "1"))
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton4), TRUE);
      gtk_widget_set_sensitive (frame4, FALSE);
    }
  txt_tampon = g_strdup_printf("%s", gnome_config_get_string (chemin_options[4]));
  if (!strcmp (txt_tampon, "1"))
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton5), TRUE);
      if (GTK_TOGGLE_BUTTON (radiobutton2)->active)
	gtk_widget_set_sensitive (frame4, TRUE);
      if (GTK_TOGGLE_BUTTON (radiobutton3)->active)
	{
	  gtk_widget_set_sensitive (entry1, TRUE);
	  gtk_widget_set_sensitive (combo1, FALSE);
	}
    }
  txt_tampon = g_strdup_printf("%s", gnome_config_get_string(chemin_options[5]));
  if (!strcmp (txt_tampon, "1"))
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton6), TRUE);
      gtk_widget_set_sensitive (frame4, FALSE);
      if (GTK_TOGGLE_BUTTON (radiobutton3)->active)
	{
	  gtk_widget_set_sensitive (entry1, TRUE);
	  gtk_widget_set_sensitive (combo1, FALSE);
	}
    }
  txt_tampon = g_strdup_printf("%s", gnome_config_get_string(chemin_options[6]));
  if (!strcmp (txt_tampon, "1"))
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton7), TRUE);
      gtk_widget_set_sensitive (frame4, FALSE);
      if (GTK_TOGGLE_BUTTON (radiobutton3)->active)
	{
	  gtk_widget_set_sensitive (entry1, FALSE);
	  gtk_widget_set_sensitive (combo1, TRUE);
	}
    }

  /* Lecture config : Boutons d'option */
  txt_tampon = g_strdup_printf("%s", gnome_config_get_string(chemin_options[7]));
  if (!strcmp (txt_tampon, "1"))
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(checkbutton1), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(checkbutton1), FALSE);
  txt_tampon = g_strdup_printf("%s", gnome_config_get_string(chemin_options[8]));
  if (!strcmp (txt_tampon, "1"))
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(checkbutton2), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(checkbutton2), FALSE);

  /* Lecture config : Texte */
  txt_tampon = g_strdup_printf("%s", gnome_config_get_string(chemin_options[9]));
 
  if (!strcmp (txt_tampon, "(null)"))
    gtk_entry_set_text (GTK_ENTRY(entry1), "(null)");
  else
    gtk_entry_set_text (GTK_ENTRY(entry1), gnome_config_get_string(chemin_options[9]));
  txt_tampon = g_strdup_printf("%s", gnome_config_get_string(chemin_options[10]));
  if (!strcmp (txt_tampon, "(null)"))
    gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(combo1)->entry), "(null)");
  else
    gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(combo1)->entry), gnome_config_get_string(chemin_options[10]));

  /* Appels */
  gtk_signal_connect (GTK_OBJECT (radiobutton1), "clicked", GTK_SIGNAL_FUNC (on_radiobutton1_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (radiobutton2), "clicked", GTK_SIGNAL_FUNC (on_radiobutton2_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (radiobutton3), "clicked", GTK_SIGNAL_FUNC (on_radiobutton3_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (radiobutton4), "clicked", GTK_SIGNAL_FUNC (on_radiobutton4_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (radiobutton5), "clicked", GTK_SIGNAL_FUNC (on_radiobutton5_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (radiobutton6), "clicked", GTK_SIGNAL_FUNC (on_radiobutton6_clicked), NULL);
  gtk_signal_connect (GTK_OBJECT (radiobutton7), "clicked", GTK_SIGNAL_FUNC (on_radiobutton7_clicked), NULL);
/*    gtk_signal_connect (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC (on_button1_clicked), NULL); */
  return (ret);
}


/*****************************************************************************/
/* Evnement */
/*****************************************************************************/
void on_radiobutton1_clicked (GtkButton *button, gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON(radiobutton1)->active)
    {
      gtk_widget_set_sensitive (frame3, FALSE);
      gtk_widget_set_sensitive (frame4, FALSE);
      gtk_widget_set_sensitive (frame5, FALSE);
    }
}

void on_radiobutton2_clicked (GtkButton *button, gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (radiobutton2)->active)
    {
      gtk_widget_set_sensitive (frame5, FALSE);
      /* FIXME : en attendant une ouverture des bases de donnes : +tards */
      /* gtk_widget_set_sensitive (frame3, TRUE); */
      /* gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(radiobutton4), TRUE); */
      /* gtk_widget_set_sensitive (radiobutton4, TRUE); */
      gtk_widget_set_sensitive (frame3, FALSE);
      gtk_widget_set_sensitive (radiobutton4, FALSE);
      gtk_widget_set_sensitive (radiobutton5, FALSE);
      gtk_widget_set_sensitive (radiobutton6, FALSE);
      gtk_widget_set_sensitive (radiobutton7, FALSE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(radiobutton6), TRUE);
    }
}

void on_radiobutton3_clicked (GtkButton *button, gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (radiobutton3)->active)
    {
      gtk_widget_set_sensitive (frame3, TRUE);
      gtk_widget_set_sensitive (frame4, FALSE);
      gtk_widget_set_sensitive (frame5, TRUE);
      gtk_widget_set_sensitive (radiobutton4, FALSE);
      gtk_widget_set_sensitive (radiobutton5, TRUE);
      gtk_widget_set_sensitive (radiobutton6, TRUE);
      /* FIXME : en attendant une ouverture des bases de donnes : +tards */
      /* gtk_widget_set_sensitive (radiobutton7, TRUE); */
      gtk_widget_set_sensitive (radiobutton7, FALSE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(radiobutton5), TRUE);
    }
}

void on_radiobutton4_clicked (GtkButton *button, gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (radiobutton4)->active)
      gtk_widget_set_sensitive (frame4, FALSE);
}

void on_radiobutton5_clicked (GtkButton *button, gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (radiobutton5)->active)
    {
      if (GTK_TOGGLE_BUTTON (radiobutton2)->active)
	gtk_widget_set_sensitive (frame4, TRUE);

      if (GTK_TOGGLE_BUTTON(radiobutton3)->active)
	{
	  gtk_widget_set_sensitive (entry1, TRUE);
	  gtk_widget_set_sensitive (combo1, FALSE);
	}
    }
}

void on_radiobutton6_clicked (GtkButton *button, gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (radiobutton6)->active)
    {
      gtk_widget_set_sensitive (frame4, FALSE);
    
      if (GTK_TOGGLE_BUTTON (radiobutton3)->active)
	{
	  gtk_widget_set_sensitive (entry1, TRUE);
	  gtk_widget_set_sensitive (combo1, FALSE);
	}
    }
}

void on_radiobutton7_clicked (GtkButton *button, gpointer user_data)
{
  if (GTK_TOGGLE_BUTTON (radiobutton7)->active)
    {
      gtk_widget_set_sensitive (frame4, FALSE);

      if (GTK_TOGGLE_BUTTON (radiobutton3)->active)
	{
	  gtk_widget_set_sensitive (entry1, FALSE);
	  gtk_widget_set_sensitive (combo1, TRUE);
	}
    }
}

/*****************************************************************************/
/* Sauvegarde  */
/*****************************************************************************/
void plugins_custom_save (void)
{
  int i;
  gchar *txt_tampon;
  gchar *chemin_options[11];

  /* Dfinition des options */
  chemin_options[0] = g_strdup_printf ("start/defaultopen_type_none");
  chemin_options[1] = g_strdup_printf ("start/defaultopen_type_last");
  chemin_options[2] = g_strdup_printf ("start/defaultopen_type_fixed");
  chemin_options[3] = g_strdup_printf ("start/defaultopen_document_all");
  chemin_options[4] = g_strdup_printf ("start/defaultopen_document_template");
  chemin_options[5] = g_strdup_printf ("start/defaultopen_document_file");
  chemin_options[6] = g_strdup_printf ("start/defaultopen_document_database");
  chemin_options[7] = g_strdup_printf ("start/defaultopen_option_templatefile");
  chemin_options[8] = g_strdup_printf ("start/defaultopen_option_templatedatabase");
  chemin_options[9] = g_strdup_printf ("start/defaultopen_source_file");
  chemin_options[10] = g_strdup_printf ("start/defaultopen_source_database");

  /* Boutons de choix */
  if (GTK_TOGGLE_BUTTON (radiobutton1)->active)
    gnome_config_set_string (chemin_options[0], "1");
  else
    gnome_config_set_string (chemin_options[0], "0");

  if (GTK_TOGGLE_BUTTON (radiobutton2)->active)
    gnome_config_set_string (chemin_options[1], "1");
  else
    gnome_config_set_string (chemin_options[1], "0");

  if (GTK_TOGGLE_BUTTON (radiobutton3)->active)
    gnome_config_set_string (chemin_options[2], "1");
  else
    gnome_config_set_string(chemin_options[2], "0");

  if (GTK_TOGGLE_BUTTON (radiobutton4)->active)
    gnome_config_set_string (chemin_options[3], "1");
  else
    gnome_config_set_string (chemin_options[3], "0");

  if (GTK_TOGGLE_BUTTON (radiobutton5)->active)
    gnome_config_set_string (chemin_options[4], "1");
  else
    gnome_config_set_string (chemin_options[4], "0");

  if (GTK_TOGGLE_BUTTON (radiobutton6)->active)
    gnome_config_set_string (chemin_options[5], "1");
  else
    gnome_config_set_string (chemin_options[5], "0");

  if (GTK_TOGGLE_BUTTON (radiobutton7)->active)
    gnome_config_set_string (chemin_options[6], "1");
  else
    gnome_config_set_string (chemin_options[6], "0");

  /* Boutons d'option */
  if (GTK_TOGGLE_BUTTON (checkbutton1)->active)
    gnome_config_set_string (chemin_options[7], "1");
  else
    gnome_config_set_string (chemin_options[7], "0");

  if (GTK_TOGGLE_BUTTON (checkbutton2)->active)
    gnome_config_set_string (chemin_options[8], "1");
  else
    gnome_config_set_string (chemin_options[8], "0");

  /* Texte */
  txt_tampon = gtk_entry_get_text (GTK_ENTRY (entry1)); 
  if (strlen (txt_tampon) == 0)
    gtk_entry_set_text (GTK_ENTRY (entry1), "(null)");
  txt_tampon = gtk_entry_get_text (GTK_ENTRY (entry1)); 
  gnome_config_set_string (chemin_options[9], txt_tampon);

  txt_tampon = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo1)->entry));
  if (strlen (txt_tampon) == 0)
    gtk_entry_set_text (GTK_ENTRY(GTK_COMBO(combo1)->entry), "(null)");
  txt_tampon = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo1)->entry));
  gnome_config_set_string (chemin_options[10], txt_tampon);
  gnome_config_sync ();
}
