/*****************************************************************************/
/* main.c : Donnes globales et fentre principale
 * main.c : Global data and main window
 *
 *
 * Greffon ToutDoux : personnalisation
 * ToutDoux's plug-in : customize
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <dlfcn.h>
#include <toutdoux.h>

#include "main.h"


/*****************************************************************************/
/* Variables globales */
/*****************************************************************************/

/*****************************************************************************/
/* Module */
/*****************************************************************************/
GtkObject *plugins_about_def (void)
{
  GtkObject *ret;
  ret = td_about_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", _("Customize"),
		  "type", _("miscellaneous"),
		  "version", "1.0.1",
		  "blurb", _("Customize"),
		  "authors", "Philippe Roy <ph_roy@yahoo.com>",
		  "help", "(null)",
		  "category1", _("core"),
		  "category2", _("customize"),
		  "category3", "(null)",
		  "copyright", "Copyright (c) 2000 Philippe Roy",
		  "license", _("Covered by the GNU General Public License"),
		  "web", "(null)", NULL);
  return ret;
}

void mod_about (void)
{
  /* td_about_show TD_ABOUT (TD_MOD (mod)->about); */
}

GtkObject *mod_def (GtkObject *mod)
{
  GtkObject *ret;
  GtkObject *box[1];
  GtkWidget *hbox1;
  GtkWidget *label_tree;
  GtkWidget *scrolledwindow1;
  GtkWidget *vseparator1;
  GtkWidget *viewport;
  GtkObject *custom_tmp;
  GtkObject *option_tmp;
  GtkWidget *box_custom0;
  GtkObject *tree[1];
  GtkObject *field[4];

  GtkWidget *toolbar;
  GtkWidget *toolbar_icon;
  GtkWidget *button1;
  GtkWidget *button2;
  GtkWidget *button3;
  gchar *txt_tmp;
  gboolean bool_tmp;
  int i, j, k, m;

  /* Module */
  ret = td_mod_new ();
  gtk_object_set (GTK_OBJECT (ret), 
		  "name", "customize",
		  "name_intl", _("Customize"), NULL);
  td_mod_set_about (TD_MOD (ret), plugins_about_def ());

  /* Barre d'outils */
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
  gtk_widget_show (toolbar);
  td_mod_set_toolbar (TD_MOD (ret), toolbar);

  toolbar_icon = gnome_stock_pixmap_widget (TD_MOD (ret)->window, GNOME_STOCK_PIXMAP_REVERT);
  button1 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Re-read file"), _("Re-read file"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (button1);
  gtk_signal_connect_object (GTK_OBJECT (button1), "clicked", GTK_SIGNAL_FUNC (plugins_load), GTK_OBJECT (mod));

  toolbar_icon = gnome_stock_pixmap_widget (TD_MOD (ret)->window, GNOME_STOCK_PIXMAP_SAVE);
  button2 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Write file"), _("Write file"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (button2);
  gtk_signal_connect_object (GTK_OBJECT (button2), "clicked", GTK_SIGNAL_FUNC (plugins_save), GTK_OBJECT (mod));
  gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

  toolbar_icon = gnome_stock_pixmap_widget (TD_MOD (ret)->window, GNOME_STOCK_PIXMAP_CLOSE);
  button3 = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_CHILD_BUTTON, NULL, _("Close"), _("Close"), NULL, toolbar_icon, NULL, NULL);
  gtk_widget_show (button3);
  gtk_signal_connect_object (GTK_OBJECT (button3), "clicked", GTK_SIGNAL_FUNC (td_mod_hide), GTK_OBJECT (ret));

  /* Navigateur : box */
  box[0] = td_mod_box_new ();
  gtk_object_set (GTK_OBJECT (box[0]), 
		  "name", _("Browser"), NULL);
  td_mod_add_child (TD_MOD (ret), box[0]);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox1);
  td_mod_box_set_widget (TD_MOD_BOX (box[0]), hbox1);
  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (hbox1), scrolledwindow1, FALSE, FALSE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
  TD_MOD (mod)->custom_tree = gtk_ctree_new (2, 0);
  gtk_widget_show (TD_MOD (mod)->custom_tree);
  gtdk_clist_adjustheight (TD_MOD (mod)->custom_tree);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), TD_MOD (mod)->custom_tree);
  if (!TD_APP (APP)->mode_debug)
    gtk_clist_set_column_visibility (GTK_CLIST (TD_MOD (mod)->custom_tree), 1, FALSE);
  gtk_clist_column_titles_show (GTK_CLIST (TD_MOD (mod)->custom_tree));
  label_tree = gtk_label_new (_("Category"));
  gtk_widget_show (label_tree);
  gtk_clist_set_column_widget (GTK_CLIST (TD_MOD (mod)->custom_tree), 0, label_tree);
  vseparator1 = gtk_vseparator_new ();
  gtk_widget_ref (vseparator1);
  gtk_widget_show (vseparator1);
  gtk_box_pack_start (GTK_BOX (hbox1), vseparator1, FALSE, TRUE, 0);

  /* Navigateur : tableaux */
  viewport = gtk_viewport_new (NULL, NULL);
  gtk_widget_show (viewport);
  gtk_box_pack_start (GTK_BOX (hbox1), viewport, TRUE, TRUE, 0);
  TD_MOD (mod)->custom_notebook = gtk_notebook_new ();
  gtk_widget_show (TD_MOD (mod)->custom_notebook);
  if (!TD_APP (APP)->mode_debug)
    gtk_notebook_set_show_tabs (GTK_NOTEBOOK (TD_MOD (mod)->custom_notebook), FALSE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (TD_MOD (mod)->custom_notebook), FALSE);
  gtk_container_add (GTK_CONTAINER (viewport), TD_MOD (mod)->custom_notebook);
  box_custom0 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (GTK_WIDGET (box_custom0));
  gtk_container_add (GTK_CONTAINER (TD_MOD (mod)->custom_notebook), GTK_WIDGET (box_custom0));
  for (i=0; i<g_list_length (TD_MOD (mod)->custom); i++)
    {
      /* Titre */
      custom_tmp = g_list_nth_data (TD_MOD (mod)->custom, i);
      TD_CUSTOM (custom_tmp)->box2 = gtk_vbox_new (FALSE, 0);
      gtk_widget_show (TD_CUSTOM (custom_tmp)->box2);
      gtk_container_add (GTK_CONTAINER (TD_MOD (mod)->custom_notebook), TD_CUSTOM (custom_tmp)->box2);
      gtdk_vbox_title (TD_CUSTOM (custom_tmp)->name, TD_CUSTOM (custom_tmp)->box2);
      TD_CUSTOM (custom_tmp)->scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
      gtk_widget_show (TD_CUSTOM (custom_tmp)->scrolledwindow);
      gtk_box_pack_start (GTK_BOX (TD_CUSTOM (custom_tmp)->box2), TD_CUSTOM (custom_tmp)->scrolledwindow, TRUE, TRUE, 0);
      gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (TD_CUSTOM (custom_tmp)->scrolledwindow), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
      TD_CUSTOM (custom_tmp)->viewport = gtk_viewport_new (NULL, NULL);
      gtk_viewport_set_shadow_type (GTK_VIEWPORT (TD_CUSTOM (custom_tmp)->viewport), GTK_SHADOW_NONE);
      gtk_widget_show (TD_CUSTOM (custom_tmp)->viewport);
      gtk_container_add (GTK_CONTAINER (TD_CUSTOM (custom_tmp)->scrolledwindow), TD_CUSTOM (custom_tmp)->viewport);
      TD_CUSTOM (custom_tmp)->box = gtk_vbox_new (FALSE, 0);
      gtk_widget_show (TD_CUSTOM (custom_tmp)->box);
      gtk_container_add (GTK_CONTAINER (TD_CUSTOM (custom_tmp)->viewport), TD_CUSTOM (custom_tmp)->box);

      /* Groupe */
      k=-1;
      m=-1;
      for (j=0; j<g_list_length (TD_CUSTOM (custom_tmp)->option); j++)
	{
	  bool_tmp = FALSE;
	  option_tmp = g_list_nth_data (TD_CUSTOM (custom_tmp)->option, j);
	  if (j==0)
	    bool_tmp = TRUE;
	  else
	    if (strcmp (TD_CUSTOM_OPTION (option_tmp)->group, 
			TD_CUSTOM_OPTION (g_list_nth_data (TD_CUSTOM (custom_tmp)->option, j-1))->group))
	      bool_tmp = TRUE;
	  if (bool_tmp)
	    {
	      k++;
	      TD_CUSTOM (custom_tmp)->group_frame = g_list_append (TD_CUSTOM (custom_tmp)->group_frame, gtk_frame_new (TD_CUSTOM_OPTION (option_tmp)->group));
	      gtk_widget_show (GTK_WIDGET (g_list_nth_data (TD_CUSTOM (custom_tmp)->group_frame, k)));
	      gtk_box_pack_start (GTK_BOX (TD_CUSTOM (custom_tmp)->box), GTK_WIDGET (g_list_nth_data (TD_CUSTOM (custom_tmp)->group_frame, k)), FALSE, TRUE, 0);
	      gtk_container_set_border_width (GTK_CONTAINER (g_list_nth_data (TD_CUSTOM (custom_tmp)->group_frame, k)), 3);
	      TD_CUSTOM (custom_tmp)->group_vbox = g_list_append (TD_CUSTOM (custom_tmp)->group_vbox, gtk_vbox_new (FALSE, 0));
	      gtk_widget_show (GTK_WIDGET (g_list_nth_data (TD_CUSTOM (custom_tmp)->group_vbox, k)));
	      gtk_container_add (GTK_CONTAINER (g_list_nth_data (TD_CUSTOM (custom_tmp)->group_frame, k)), GTK_WIDGET (g_list_nth_data (TD_CUSTOM (custom_tmp)->group_vbox, k)));
	    }

	  /* Option */
	  bool_tmp = FALSE;
	  if (TD_CUSTOM_OPTION (option_tmp)->newline)
	    {
	      m++;
	      TD_CUSTOM (custom_tmp)->group_hbox = g_list_append (TD_CUSTOM (custom_tmp)->group_hbox, gtk_hbox_new (FALSE, 0));
	      gtk_widget_show (GTK_WIDGET (g_list_nth_data (TD_CUSTOM (custom_tmp)->group_hbox, m)));
	      gtk_box_pack_start (GTK_BOX (g_list_nth_data (TD_CUSTOM (custom_tmp)->group_vbox, k)), g_list_nth_data (TD_CUSTOM (custom_tmp)->group_hbox, m), FALSE, TRUE, 0);
	    }
	  gtk_widget_show (TD_CUSTOM_OPTION (option_tmp)->widget);
	  gtk_box_pack_start (GTK_BOX (g_list_nth_data (TD_CUSTOM (custom_tmp)->group_hbox, m)), TD_CUSTOM_OPTION (option_tmp)->widget, TRUE, TRUE, 0);
	}
    }

  /* Navigateur : arbre */
  browser_create (mod, TD_MOD (mod)->custom_tree);
  gtk_clist_set_column_width (GTK_CLIST (TD_MOD (mod)->custom_tree), 0, gtdk_ctree_optimal_column_width (TD_MOD (mod)->custom_tree, 0));
  if (TD_APP (APP)->mode_debug)
    gtk_clist_set_column_width (GTK_CLIST (TD_MOD (mod)->custom_tree), 1, gtdk_ctree_optimal_column_width (TD_MOD (mod)->custom_tree, 1));
  gtk_signal_connect (GTK_OBJECT (TD_MOD (mod)->custom_tree), "button_press_event", GTK_SIGNAL_FUNC (browser_press), GTK_OBJECT (TD_MOD (mod)->custom_notebook));
  gtk_signal_connect (GTK_OBJECT (TD_MOD (mod)->custom_tree), "tree_expand", GTK_SIGNAL_FUNC (gtdk_ctree_expand), scrolledwindow1);

  /* Debug : arbre */
  tree[0] = td_mod_tree_new ();
  gtk_object_set (GTK_OBJECT (tree[0]), 
		  "name", _("List"), 
		  "column_auto_resize", TRUE, NULL); 
  td_mod_add_child (TD_MOD (ret), tree[0]);

  /* Debug : champs */
  field[0] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[0]), 
		  "name", "name", 
		  "name_intl", _("Name"), NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[0]);

  field[1] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[1]), 
		  "name", "value", 
		  "name_intl", _("Value"), NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[1]);


  field[2] = td_field_new ();
  gtk_object_set (GTK_OBJECT (field[2]), 
		  "name", "type", 
		  "name_intl", _("Type"), NULL);
  td_mod_tree_add_field (TD_MOD_TREE (tree[0]), field[2]);
  return ret;
}

void plugins_init (void)
{
}

void plugins_destroy (void)
{
  /* td_mod_destroy (TD_MOD (mod)); */
}

void plugins_create (GtkObject *mod)
{
  int i;
  gboolean bool_tmp;

  /* Personnalisation */
  bool_tmp = FALSE;
  for (i=0; i<g_list_length (TD_MOD (mod)->child); i++)
    {
      /* mod_tree */
      if (TD_IS_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, i)))
	if (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, i))->customize)
	  {
	    td_mod_add_custom (TD_MOD (mod), td_mod_tree_custom_def (TD_MOD_TREE (g_list_nth_data (TD_MOD (mod)->child, i))));
	    bool_tmp = TRUE;
	  }
    }
  if (bool_tmp)
    {
      TD_MOD (mod)->custom_browser = mod_def (GTK_OBJECT (TD_MOD (mod)));
      td_mod_create (TD_MOD (TD_MOD (mod)->custom_browser), -1);
      plugins_load (mod);
    }
}



/*****************************************************************************/
/* Navigateur */
/*****************************************************************************/
gboolean browser_press (GtkWidget *widget, GdkEvent *event, GtkWidget *notebook)
{
  GtkCTreeNode *node;
  GdkEventButton *bevent;
  gint row, column;
  gchar *txt_tmp;
  int i;

  /* Capture du greffons */
  bevent = (GdkEventButton *) event;
  gtk_clist_get_selection_info (GTK_CLIST (widget), bevent->x, bevent->y, &row, &column);
  row = gtdk_clist_correction (widget, row, bevent->y);
  if (row < 0)
    {
      gtk_notebook_set_page (GTK_NOTEBOOK (notebook), 0);
      return TRUE;
    }
  node = gtk_ctree_node_nth (GTK_CTREE (widget), row);
  gtk_ctree_node_get_text (GTK_CTREE (widget), node, 1, &txt_tmp);
  if (!strcmp (txt_tmp, "(null)"))
    {
      gtk_notebook_set_page (GTK_NOTEBOOK (notebook), 0);
      return TRUE;
    }
  gtk_notebook_set_page (GTK_NOTEBOOK (notebook), atoi (txt_tmp));
  return TRUE;
}

void browser_create (GtkObject *mod, GtkWidget *ctree)
{
  gchar *txt[2];
  int i, j, k, n;
  GtkCTreeNode *node1 = NULL;
  GtkCTreeNode *node2 = NULL;
  GtkCTreeNode *node3 = NULL;
  gboolean existe;
  gchar *txt_tampon;
  GdkPixmap *pixmap_tampon;
  GdkBitmap *mask_tampon;
  guint8 spacing_tampon;
  int nb_categorie_greffon;

  /* Recherche d'une branche similaire */
  for (i=0; i<g_list_length (TD_MOD (mod)->custom); i++)
    {
      if (!strcmp (TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->category1, "(null)"))
	continue;

      /* Scan niveau 1 */
      existe = FALSE;
      node1 = gtk_ctree_node_nth (GTK_CTREE (ctree), 0);
      while ((node1) && (!existe))
	{
	  gtk_ctree_node_get_pixtext (GTK_CTREE (ctree), node1, 0, &txt_tampon, &spacing_tampon, &pixmap_tampon, &mask_tampon);
	  if (strcmp (TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->category1, txt_tampon))
	    {
	      if (GTK_CTREE_ROW (node1)->sibling)
		node1 = GTK_CTREE_ROW (node1)->sibling;
	      else
		node1 = NULL;
	    }
	  else
	      existe = TRUE;
	}

      /* Cration niveau 1 */
      if (!existe)
	{
	  txt[0] = TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->category1;
	  txt[1] = "(null)";
	  node1 = gtk_ctree_insert_node (GTK_CTREE (ctree), NULL, NULL, txt, 3, NULL, NULL, NULL, NULL, FALSE, FALSE);
	  if (!strcmp (TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->category2, "(null)"))
	    {
	      txt[1] = g_strdup_printf ("%d", i+1);
	      gtk_ctree_node_set_text (GTK_CTREE (ctree), node1, 1, txt[1]);
	    }
	  else
	    {
	      txt[0] = TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->category2;
	      txt[1] = "(null)";
	      node2 = gtk_ctree_insert_node (GTK_CTREE (ctree), node1, NULL, txt, 3, NULL, NULL, NULL, NULL, FALSE, FALSE);
	      if (!strcmp (TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->category3, "(null)"))
		{
		  txt[1] = g_strdup_printf ("%d", i+1);
		  gtk_ctree_node_set_text (GTK_CTREE (ctree), node2, 1, txt[1]);
		}
	      else
		{
		  txt[0] = TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->category3;
		  txt[1] = g_strdup_printf ("%d", i+1);
		  node3 = gtk_ctree_insert_node (GTK_CTREE (ctree), node2, NULL, txt, 3, NULL, NULL, NULL, NULL, FALSE, FALSE);
		}
	    }
	  continue;
	}

      /* Scan niveau 2 */
      existe = FALSE;
      gtk_ctree_collapse (GTK_CTREE (ctree), node1);
      if (GTK_CTREE_ROW (node1)->children)
	node2 = GTK_CTREE_ROW (node1)->children;
      else
	node2 = NULL;
      while ((node2)&& (!existe))
	{
	  gtk_ctree_node_get_pixtext (GTK_CTREE (ctree), node2, 0, &txt_tampon, &spacing_tampon, &pixmap_tampon, &mask_tampon);
	  if (strcmp (TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->category2, txt_tampon))
	    {
	      if (GTK_CTREE_ROW (node2)->sibling)
		node2 = GTK_CTREE_ROW (node2)->sibling;
	      else
		node2 = NULL;
	    }
	  else
	    existe = TRUE;
	}

      /* Cration niveau 2 */
      if (!existe)
	{
	  txt[0] = TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->category2;
	  txt[1] = "(null)";
	  node2 = gtk_ctree_insert_node (GTK_CTREE (ctree), node1, NULL, txt, 3, NULL, NULL, NULL, NULL, FALSE, FALSE);
	  if (!strcmp (TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->category3, "(null)"))
	    {
	      txt[1] = g_strdup_printf ("%d", i+1);
	      gtk_ctree_node_set_text (GTK_CTREE (ctree), node2, 1, txt[1]);
	    }
	  else
	    {
	      txt[0] = TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->category3;
	      txt[1] = g_strdup_printf ("%d", i+1);
	      node3 = gtk_ctree_insert_node (GTK_CTREE (ctree), node2, NULL, txt, 3, NULL, NULL, NULL, NULL, FALSE, FALSE);
	    }
	  continue;
	}

      /* Scan niveau 3 */
      existe = FALSE;
      gtk_ctree_collapse (GTK_CTREE (ctree), node1);
      if (GTK_CTREE_ROW (node2)->children)
	node3 = GTK_CTREE_ROW (node2)->children;
      else
	node3 = NULL;
      while ((node3) && (!existe))
	{
	  gtk_ctree_node_get_pixtext (GTK_CTREE (ctree), node3, 0, &txt_tampon, &spacing_tampon, &pixmap_tampon, &mask_tampon);
	  if (strcmp (TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->category3, txt_tampon))
	    {
	      if (GTK_CTREE_ROW (node3)->sibling)
		node3 = GTK_CTREE_ROW (node3)->sibling;
	      else
		node3 = NULL;
	    }
	  else
	    existe = TRUE;
	}

      /* Cration niveau 3 */
     if (!existe)
	{
	  txt[0] = TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->category3;
	  txt[1] = g_strdup_printf ("%d", i+1);
	  node3 = gtk_ctree_insert_node (GTK_CTREE (ctree), node2, NULL, txt, 3, NULL, NULL, NULL, NULL, FALSE, FALSE);
	}
    }
}

/*****************************************************************************/
/* Fichier */
/*****************************************************************************/
gboolean plugins_load (GtkObject *mod)
{
  GtkObject *flower;
  GList *data = NULL;
  GList *data_custom = NULL;
  GList *data_group = NULL;
  GtkCTreeNode *node;
  GtkCTreeNode *node_custom;
  GtkCTreeNode *node_group;
  GtkObject *option_tmp = NULL;
  gboolean bool_tmp;
  int i, j;

  /* Definition fichier support */
  flower = td_flower_new ();
  gtk_object_set (GTK_OBJECT (flower),
		  "space", "toutdoux-customize/1.0.1",
		  "root", "customize", 
		  "branch", "custom",
		  "petal", "group",
		  "foliole", "option",
		  "mode_type", TRUE, NULL);
  td_flower_add_branch_attribut (TD_FLOWER (flower), "name");
  td_flower_add_branch_attribut (TD_FLOWER (flower), "value");
  td_flower_add_petal_attribut (TD_FLOWER (flower), "name");
  td_flower_add_petal_attribut (TD_FLOWER (flower), "value");
  td_flower_add_foliole_attribut (TD_FLOWER (flower), "name");
  td_flower_add_foliole_attribut (TD_FLOWER (flower), "value");

  /* Lecture fichier support */
  td_flower_load_file (TD_FLOWER (flower), g_strdup_printf ("%s/customize/%s.xml", TD_APP(APP)->dir_var, TD_MOD(mod)->name));
  td_mod_tree_load_flower (TD_MOD_TREE (g_list_nth_data (TD_MOD (TD_MOD (mod)->custom_browser)->child, 1)), flower);

  /* Affichage des valeurs */
  node = gtk_ctree_node_nth (GTK_CTREE (GTK_BIN (TD_MOD_TREE (g_list_nth_data (TD_MOD (TD_MOD (mod)->custom_browser)->child, 1))->widget)->child), 0);
  while (node)
    {
      if (GTK_CTREE_ROW (node)->level == 3)
	{
	  node_group = GTK_CTREE_ROW (node)->parent;
	  node_custom = GTK_CTREE_ROW (node_group)->parent;
	  data_group = td_mod_tree_read_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (TD_MOD (mod)->custom_browser)->child, 1)), node_group, FALSE);
	  data_custom = td_mod_tree_read_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (TD_MOD (mod)->custom_browser)->child, 1)), node_custom, FALSE);
	  data = td_mod_tree_read_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (TD_MOD (mod)->custom_browser)->child, 1)), node, FALSE);

	  /* Recherche du custom */
	  bool_tmp = FALSE;
	  for (i=0; i<g_list_length (TD_MOD (mod)->custom); i++)
	    if (!strcmp (TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->name, g_list_nth_data (data_custom, 0)))
	      {
		bool_tmp = TRUE;
		break;
	      }
	  if (!bool_tmp)
	    {
	      td_palette_message (_("Customizing : category's option not find"), NULL, "failed");
	      return FALSE;
	    }

	  /* Recherche de l'option */
	  bool_tmp = FALSE;
	  for (j=0; j<g_list_length (TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->option); j++)
	    if (!strcmp (TD_CUSTOM_OPTION (g_list_nth_data (TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->option, j))->group, g_list_nth_data (data_group, 0)))
	      if (!strcmp (TD_CUSTOM_OPTION (g_list_nth_data (TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->option, j))->name, g_list_nth_data (data, 0)))
		{
		  bool_tmp = TRUE;
		  break;
		}
	  if (!bool_tmp)
	    {
	      td_palette_message (_("Customizing : option not find"), NULL, "failed");
	      return FALSE;
	    }
	  option_tmp = g_list_nth_data (TD_CUSTOM (g_list_nth_data (TD_MOD (mod)->custom, i))->option, j);

	  /* gtk_entry */
	  if (GTK_IS_ENTRY (TD_CUSTOM_OPTION (option_tmp)->widget))
	    gtk_entry_set_text (GTK_ENTRY (TD_CUSTOM_OPTION (option_tmp)->widget), (gchar*) g_list_nth_data (data, 1));

	  /* gtk_check_button */
 	  if (GTK_IS_CHECK_BUTTON (TD_CUSTOM_OPTION (option_tmp)->widget))
	    {
	      if (((GTK_TOGGLE_BUTTON (TD_CUSTOM_OPTION (option_tmp)->widget)->active)) && (!strcmp ((gchar*) g_list_nth_data (data, 1), "f")))
		gtk_button_clicked (GTK_BUTTON (TD_CUSTOM_OPTION (option_tmp)->widget));
	      if ((!GTK_TOGGLE_BUTTON (TD_CUSTOM_OPTION (option_tmp)->widget)->active) && (!strcmp ((gchar*) g_list_nth_data (data, 1), "t")))
		gtk_button_clicked (GTK_BUTTON (TD_CUSTOM_OPTION (option_tmp)->widget));
	    }

	  /* gtk_spin_button */
	  if (GTK_IS_SPIN_BUTTON (TD_CUSTOM_OPTION (option_tmp)->widget))
	    gtk_spin_button_set_value (GTK_SPIN_BUTTON (TD_CUSTOM_OPTION (option_tmp)->widget), atoi (g_list_nth_data (data, 1)));

	  /* FIXME: la suite arrive : +tards */
	}
      node = gtdk_ctree_next (node);
    }
  g_list_free (data);
  g_list_free (data_custom);
  g_list_free (data_group);
  return TRUE;
}


void plugins_save (GtkObject *mod)
{
  GList *data = NULL;
  gchar *value;
  GtkCTreeNode *node_custom = NULL;
  GtkCTreeNode *node_group = NULL;
  GtkCTreeNode *node;
  int i, j, k;
  GtkObject *flower;
  GtkObject *custom_tmp;
  GtkObject *option_tmp;
  gboolean bool_tmp;

  /* Definition fichier support */
  flower = td_flower_new ();
  gtk_object_set (GTK_OBJECT (flower),
		  "space", "toutdoux-customize/1.0.1",
		  "root", "customize", 
		  "branch", "custom",
		  "petal", "group",
		  "foliole", "option", 
		  "mode_type", TRUE, NULL);
  td_flower_add_branch_attribut (TD_FLOWER (flower), "name");
  td_flower_add_branch_attribut (TD_FLOWER (flower), "value");
  td_flower_add_petal_attribut (TD_FLOWER (flower), "name");
  td_flower_add_petal_attribut (TD_FLOWER (flower), "value");
  td_flower_add_foliole_attribut (TD_FLOWER (flower), "name");
  td_flower_add_foliole_attribut (TD_FLOWER (flower), "value");

  /* Lecture des valeurs des tableaux */
  td_mod_tree_clear (TD_MOD_TREE (g_list_nth_data (TD_MOD (TD_MOD (mod)->custom_browser)->child, 1)));
  for (i=0; i<g_list_length (TD_MOD (mod)->custom); i++)
    {
      /* Catgorie */
      custom_tmp = g_list_nth_data (TD_MOD (mod)->custom, i);
      data = g_list_append (data, g_strdup_printf ("%s", TD_CUSTOM (custom_tmp)->name));
      data = g_list_append (data, "");
      data = g_list_append (data, "custom");
      node_custom = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (TD_MOD (mod)->custom_browser)->child, 1)), NULL, NULL, data, TRUE);
      data = NULL;
      for (j=0; j<g_list_length (TD_CUSTOM (custom_tmp)->option); j++)
	{
	  option_tmp = g_list_nth_data (TD_CUSTOM (custom_tmp)->option, j);

	  /* Groupe */
	  bool_tmp = FALSE;
	  if (j==0)
	    bool_tmp = TRUE;
	  else
	    if (strcmp (TD_CUSTOM_OPTION (option_tmp)->group, 
			TD_CUSTOM_OPTION (g_list_nth_data (TD_CUSTOM (custom_tmp)->option, j-1))->group))
	      bool_tmp = TRUE;
	  if (bool_tmp)
	    {
	      data = g_list_append (data, g_strdup_printf ("%s", TD_CUSTOM_OPTION (option_tmp)->group));
	      data = g_list_append (data, "");
	      data = g_list_append (data, "group");
	      node_group = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (TD_MOD (mod)->custom_browser)->child, 1)), node_custom, NULL, data, TRUE);
	      data = NULL;
	    }

	  /* Valeur */
	  data = g_list_append (data, g_strdup_printf ("%s", TD_CUSTOM_OPTION (option_tmp)->name));
	  value = NULL;

	  /* gtk_entry */
	  if (GTK_IS_ENTRY (TD_CUSTOM_OPTION (option_tmp)->widget))
	    value = g_strdup_printf ("%s", gtk_entry_get_text (GTK_ENTRY (TD_CUSTOM_OPTION (option_tmp)->widget)));
	  
	  /* gtk_check_button */
	  if (GTK_IS_CHECK_BUTTON (TD_CUSTOM_OPTION (option_tmp)->widget))
	    {
	      if (GTK_TOGGLE_BUTTON (TD_CUSTOM_OPTION (option_tmp)->widget)->active)
		value = "t";
	      else
		value = "f";
	    }
	  
	  /* gtk_spin_button */
	  if (GTK_IS_SPIN_BUTTON (TD_CUSTOM_OPTION (option_tmp)->widget))
	    value = g_strdup_printf ("%d", gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (TD_CUSTOM_OPTION (option_tmp)->widget)));

	  /* FIXME: la suite arrive : +tards */
	  if (!value)
	    value = "(null)";
	  data = g_list_append (data, g_strdup_printf ("%s", value));
	  data = g_list_append (data, "option");
    	  node = td_mod_tree_add_node (TD_MOD_TREE (g_list_nth_data (TD_MOD (TD_MOD (mod)->custom_browser)->child, 1)), node_group, NULL, data, TRUE);
	  data = NULL;
	}
    }

  /* Enregistrement fichier de config */
  td_mod_tree_save_flower (TD_MOD_TREE (g_list_nth_data (TD_MOD (TD_MOD (mod)->custom_browser)->child, 1)), flower, g_strdup_printf ("%s/customize/%s.xml", TD_APP(APP)->dir_var, TD_MOD(mod)->name));
  g_list_free (data);
}
