/*****************************************************************************/
/* main.c : module principal et ligne de commande
 * main.c : main module and command line
 *
 *
 * TouxDoux : Chtit gestionnaire de projet - A littl' project manager
 * Copyright (c) 2000 Philippe Roy
 * Auteur - Author : Philippe Roy <ph_roy@yahoo.com>
 *
 *
 * Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier
 * sous les termes de la licence publique gnrale GNU telle qu'elle est publie par
 * la Free Software Foundation ; soit la version 2 de la licence, ou
 * (comme vous voulez) toute version ultrieure.
 *
 * Ce programme est distribu dans l'espoir qu'il sera utile,
 * mais SANS AUCUNE GARANTIE ; mme sans la garantie de
 * COMMERCIALIT ou d'ADQUATION A UN BUT PARTICULIER. Voir la
 * licence publique gnrale GNU pour plus de dtails.
 *
 * Vous devriez avoir reu une copie de la licence publique gnrale GNU
 * avec ce programme ; si ce n'est pas le cas, crivez  la Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
/*****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <locale.h>
#include <dlfcn.h>
#include <toutdoux.h>

#include "main.h"
#include "icons.h"
#include "configuration.h"


/*****************************************************************************/
/* Menu Palette */
/*****************************************************************************/
static GnomeUIInfo menu_palette_template_uiinfo[] =
{
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_palette_recent_uiinfo[] =
{
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_palette_favorite_uiinfo[] =
{
  GNOMEUIINFO_END
};            	

static GnomeUIInfo menu_palette_file_uiinfo[] =
{
  {GNOME_APP_UI_SUBTREE, N_("New"), NULL,
   menu_palette_template_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Open"), NULL,
   menu_palette_recent_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 0, 0, NULL},
  {GNOME_APP_UI_SUBTREE, N_("Favorites"), NULL,
   menu_palette_favorite_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, menu_favorites_xpm, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Quit"), NULL,
   quit_toutdoux, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT, 'q', GDK_CONTROL_MASK, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_palette_tools_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Edit template"), NULL,
   cogitation_show, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_BUILD, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Manage database"), NULL,
   td_app_menu_activate, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_DATABASE, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Properties"), NULL,
   editprop_show, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP, 'w', GDK_MOD1_MASK, NULL},
  {GNOME_APP_UI_ITEM, N_("Messages"), NULL,
   messages_show, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, menu_console_xpm, 'x', GDK_MOD1_MASK, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_palette_help_uiinfo[] =
{
/*    {GNOME_APP_UI_ITEM, N_("Customize"), NULL, */
/*     td_app_menu_activate, NULL, NULL, */
/*     GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_CUSTOM, 0, 0, NULL}, */
  {GNOME_APP_UI_ITEM, N_("Bookmarks"), NULL,
   bookmarks_show, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, menu_favorites_xpm, 'b', GDK_MOD1_MASK, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Presto"), NULL,
   td_app_menu_activate, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, menu_presto_xpm, 0xFFBE, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("User's manual"), NULL,
   td_app_menu_activate, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_GREEN, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Plug-ins browser"), NULL,
   td_app_menu_activate, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_PLUGINS, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("About"), NULL,
   td_app_menu_activate, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_palette_uiinfo[] =
{
  {GNOME_APP_UI_SUBTREE, N_("File"), NULL,
   menu_palette_file_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
  {GNOME_APP_UI_SUBTREE, N_("Tools"), NULL,
   menu_palette_tools_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_palette_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
  GNOMEUIINFO_END
};

/*****************************************************************************/
/* Menu Principal */
/*****************************************************************************/
static GnomeUIInfo menu_main_template_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Create template"), NULL,
   td_db_connect_close, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_BUILD, 'n', GDK_CONTROL_MASK, NULL},
  {GNOME_APP_UI_ITEM, N_("Open template..."), NULL,
   td_db_connect_load, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, 0, 0, NULL},
  GNOMEUIINFO_END
};            	

static GnomeUIInfo menu_main_file_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Open file..."), NULL,
   td_db_connect_load, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, 0xFFC0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Open URL..."), NULL,
   td_db_connect_load, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_URL, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_ITEM, N_("Save"), NULL,
   td_db_connect_save, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE, 's', GDK_CONTROL_MASK, NULL},
  {GNOME_APP_UI_ITEM, N_("Save as..."), NULL,
   td_db_connect_save, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE_AS, 0, 0, NULL},
  GNOMEUIINFO_END
};            	

static GnomeUIInfo menu_main_dialog_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Properties"), NULL,
   editprop_show, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP, 'w', GDK_MOD1_MASK, NULL},
  {GNOME_APP_UI_ITEM, N_("Messages"), NULL,
   messages_show, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, menu_console_xpm, 'x', GDK_MOD1_MASK, NULL},
  GNOMEUIINFO_END
};            	

static GnomeUIInfo menu_main_tools_uiinfo[] =
{
  {GNOME_APP_UI_ITEM, N_("Edit template"), NULL,
   cogitation_show, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_BUILD, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Manage database"), NULL,
   td_app_menu_activate, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_LIST_DATABASE, 0, 0, NULL},
  GNOMEUIINFO_END
};

static GnomeUIInfo menu_main_uiinfo[] =
{
  {GNOME_APP_UI_SUBTREE, N_("Template"), NULL,
   menu_main_template_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW, 0, 0, NULL},
  {GNOME_APP_UI_SUBTREE, N_("File"), NULL,
   menu_main_file_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN, 0, 0, NULL},
  GNOMEUIINFO_SEPARATOR,
  {GNOME_APP_UI_SUBTREE, N_("Dialogs"), NULL,
   menu_main_dialog_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
  {GNOME_APP_UI_SUBTREE, N_("Tools"), NULL,
   menu_main_tools_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL},
  {GNOME_APP_UI_SUBTREE, N_("Help"), NULL,
   menu_palette_help_uiinfo, NULL, NULL,
   GNOME_APP_PIXMAP_DATA, TD_STOCK_MENU_HELP, 0, 0, NULL},
  {GNOME_APP_UI_ITEM, N_("Quit"), NULL,
   quit_toutdoux, NULL, NULL,
   GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT, 'q', GDK_CONTROL_MASK, NULL},
  GNOMEUIINFO_END
};


/*****************************************************************************/
/* Definition */
/*****************************************************************************/
GtkObject *app_def (void)
{
  GtkObject *ret;
  GtkObject *about;
  GtkObject *admin_field[4];
  GtkObject *palette;
  GtkObject *editprop;
  GtkObject *message;
  GtkObject *message_mod;
  GtkObject *message_mod_tree;
  GtkObject *field[2];
  GtkObject *menu[6];
  GtkObject *icon[10];
  GtkObject *icon_equal[10];

  /* Application */
  ret = td_app_new ();
  gtk_object_set (GTK_OBJECT (ret),
		  "dir_var", g_strdup_printf("%s/.toutdoux", g_get_home_dir()),
		  "dir_tmp", g_strdup_printf("%s/.toutdoux/tmp", g_get_home_dir()),
		  "dir_plugins", g_strdup_printf ("%s/lib/toutdoux/plugins/", PACKAGE_DATA_DIR),
		  "dir_doc", g_strdup_printf(("%s%s"), PACKAGE_DATA_DIR, _("/doc/toutdoux/en")),
		  "mode_debug", mode_debug_popt,
		  "mode_nocolor", mode_nocolor_popt, NULL);

  /* About */
  about = td_about_new ();
  gtk_object_set (GTK_OBJECT (about), 
		  "name", PACKAGE,
		  "version", g_strdup_printf("%s (%s)", VERSION, DATEVERSION),
		  "copyright", "Copyright (c) 2000 Philippe Roy",
		  "license", _("ToutDoux is a free software, covered by the GNU General Public License."),
		  "logo", g_strdup_printf("%s/share/pixmaps/toutdoux/logo.png", PACKAGE_DATA_DIR),
		  "web", _("http://toutdoux.sourceforge.net/en/"), NULL);
  td_app_set_about (TD_APP (ret), about);

  /* Champs d'administration */
  admin_field[0] = td_field_new ();
  gtk_object_set (GTK_OBJECT (admin_field[0]),
		  "name", "hopla_id",
		  "name_intl", "hopla_id",
		  "type", "int8", NULL);
  td_app_add_admin_field (TD_APP (ret), admin_field[0]);

  admin_field[1] = td_field_new ();
  gtk_object_set (GTK_OBJECT (admin_field[1]),
		  "name", "hopla_id_parent",
		  "name_intl", "hopla_id_parent",
		  "type", "int8", NULL);
  td_app_add_admin_field (TD_APP (ret), admin_field[1]);

  admin_field[2] = td_field_new ();
  gtk_object_set (GTK_OBJECT (admin_field[2]),
		  "name", "hopla_id_sibling",
		  "name_intl", "hopla_id_sibling",
		  "type", "int8", NULL);
  td_app_add_admin_field (TD_APP (ret), admin_field[2]);

  admin_field[3] = td_field_new ();
  gtk_object_set (GTK_OBJECT (admin_field[3]),
		  "name", "hopla_obso",
		  "name_intl", "hopla_obso",
		  "type", "bool", NULL);
  td_app_add_admin_field (TD_APP (ret), admin_field[3]);

  /* Menu module */
  td_app_set_menu_main (TD_APP (ret), menu_main_uiinfo);

  menu[0] = td_app_menu_new ();
  gtk_object_set (GTK_OBJECT (menu[0]),
		  "type", "module",
		  "path", g_strdup_printf("%s/%s", _("Help"), _("Presto")),
		  "file", "libhelp_doc.so",
		  "symbol", "plugins_show", NULL);
  td_app_add_menu_mod (TD_APP (ret), menu[0]);

  menu[1] = td_app_menu_new ();
  gtk_object_set (GTK_OBJECT (menu[1]),
		  "type", "module",
		  "path", g_strdup_printf("%s/%s", _("Help"), _("About")),
		  "file", "libhelp_about.so",
		  "symbol", "plugins_show", NULL);
  td_app_add_menu_mod (TD_APP (ret), menu[1]);

/*    menu[2] = td_app_menu_new (); */
/*    gtk_object_set (GTK_OBJECT (menu[2]), */
/*  		  "type", "module", */
/*  		  "path", g_strdup_printf("%s/%s", _("Help"), _("Customize")), */
/*  		  "file", "libhelp_customize.so", */
/*  		  "symbol", "plugins_show", NULL); */
/*    td_app_add_menu_mod (TD_APP (ret), menu[2]); */

  menu[2] = td_app_menu_new ();
  gtk_object_set (GTK_OBJECT (menu[2]),
		  "type", "module",
		  "path", g_strdup_printf("%s/%s", _("Help"), _("Plug-ins browser")),
		  "file", "libhelp_xts.so",
		  "symbol", "plugins_show", NULL);
  td_app_add_menu_mod (TD_APP (ret), menu[2]);

  menu[3] = td_app_menu_new ();
  gtk_object_set (GTK_OBJECT (menu[3]),
		  "type", "module",
		  "path", g_strdup_printf("%s/%s", _("Tools"), _("Manage database")),
		  "file", "libcommunication_db.so",
		  "symbol", "plugins_show", NULL);
  td_app_add_menu_mod (TD_APP (ret), menu[3]);

  menu[4] = td_app_menu_new ();
  gtk_object_set (GTK_OBJECT (menu[4]),
		  "type", "manual",
		  "path", g_strdup_printf("%s/%s", _("Help"), _("User's manual")),
		  "file", "index.html", NULL);
  td_app_add_menu_mod (TD_APP (ret), menu[4]);

  /* Palette */
  palette = td_app_palette_new ();
  td_app_palette_set_menu_main (TD_APP_PALETTE (palette), menu_palette_uiinfo);
  td_app_set_palette (TD_APP (ret), palette);

  /* Editeur de proprits */
  editprop = td_app_editprop_new ();
  td_app_set_editprop (TD_APP (ret), editprop);
  return ret;
}


/*****************************************************************************/
/* Popt */
/*****************************************************************************/
gchar *file_popt;
gboolean mode_debug_popt;
gboolean mode_nocolor_popt;
const char **arguments = NULL;
poptContext pctx;
const struct poptOption parametres[] ={
  {
    "file", 'f', POPT_ARG_STRING, &file_popt, 0, N_("Specify the file (optional)"), N_("FILE"),
  },
  {
    "debug", 'd', POPT_ARG_NONE, &mode_debug_popt, 0, N_("debug mode"), NULL
  },
  {
    "nocolor", 0, POPT_ARG_NONE, &mode_nocolor_popt, 0, N_("no colors mode"), NULL
  },
  {
    NULL, '\0', 0, NULL, 0, NULL, NULL
  }
};


/*****************************************************************************/
/* Main */
/*****************************************************************************/
int main (int argc, char *argv[])
{
  /* Internationalisation */
  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);

  /* Initialisation */
  gnome_init_with_popt_table (PACKAGE, VERSION, argc, argv, parametres, 0, &pctx);
  arguments = poptGetArgs (pctx);
  gnome_config_push_prefix ("ToutDoux/");
  td_init ();
  APP = app_def ();
  td_app_create (TD_APP (APP));

  /* Go ! */
  td_palette_message (NULL, _("Starting"), "begin");
  installation ();
  td_palette_message (g_strdup_printf ("%s...", _("Starting")), NULL, "message");
  app_mod_core_def ();
  td_palette_message (NULL, _("Starting"), "done");
  td_palette_message (NULL, _("Starting"), "end");
  gtk_main ();
  return 0;
}

/*****************************************************************************/
/* Menu */
/*****************************************************************************/
void editprop_show (void)
{
  td_app_editprop_show (TD_APP_EDITPROP (TD_APP (APP)->editprop));
}

void quit_toutdoux (void)
{
  td_app_quit (TD_APP (APP));
}

void cogitation_show (void)
{
  td_app_mod_core_activate (TD_APP (APP), g_strdup_printf ("%slibcogitation.so", TD_APP(APP)->dir_plugins), "plugins_show");
}

void bookmarks_show (void)
{
  td_app_mod_core_activate (TD_APP (APP), g_strdup_printf ("%slibbookmarks.so", TD_APP(APP)->dir_plugins), "plugins_show");
}

void messages_show (void)
{
  td_app_mod_core_activate (TD_APP (APP), g_strdup_printf ("%slibmessages.so", TD_APP(APP)->dir_plugins), "plugins_show");
}

void communication_db_show (void)
{
  td_app_mod_core_activate (TD_APP (APP), g_strdup_printf ("%slibcommunication_db.so", TD_APP(APP)->dir_plugins), "plugins_show");
}


/*****************************************************************************/
/* Module noyaux */
/*****************************************************************************/
void app_mod_core_def (void)
{
  gchar *file;
  gchar *symbol;
  int id;

  /* Cogitation : PLUGINS_CORE[0] */
  file = g_strdup_printf ("%slibcogitation.so", TD_APP(APP)->dir_plugins);
  symbol = "plugins_init";
  id = 1;
  td_app_add_mod_core (TD_APP (APP), file, symbol, id);

  /* Bookmarks : PLUGINS_CORE[1] */
  file = g_strdup_printf ("%slibbookmarks.so", TD_APP(APP)->dir_plugins);
  id = 2;
  td_app_add_mod_core (TD_APP (APP), file, symbol, id);

  /* Messages : PLUGINS_CORE[2] */
  file = g_strdup_printf ("%slibmessages.so", TD_APP(APP)->dir_plugins);
  id = -1;
  td_app_add_mod_core (TD_APP (APP), file, symbol, id);

  /* Commnunication : URL : PLUGINS_CORE[3] */
  file = g_strdup_printf ("%slibcommunication_url.so", TD_APP(APP)->dir_plugins);
  id = -1;
  td_app_add_mod_core (TD_APP (APP), file, symbol, id);

  /* Commnunication : Base de donnes : PLUGINS_CORE[4] */
  file = g_strdup_printf ("%slibcommunication_db.so", TD_APP(APP)->dir_plugins);
  id = -1;
  td_app_add_mod_core (TD_APP (APP), file, symbol, id);

  /* Personnalisation : PLUGINS_CORE[5] */
  file = g_strdup_printf ("%slibhelp_customize.so", TD_APP(APP)->dir_plugins);
  id = -1;
  td_app_add_mod_core (TD_APP (APP), file, symbol, id);
}

