/* string.c generated by valac 0.34.2, the Vala compiler
 * generated from string.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define TYPE_PREPARE_INPUT_TEXT_OPTIONS (prepare_input_text_options_get_type ())

typedef enum  {
	PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL = 1 << 0,
	PREPARE_INPUT_TEXT_OPTIONS_VALIDATE = 1 << 1,
	PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL = 1 << 2,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP = 1 << 3,
	PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF = 1 << 4,
	PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE = 1 << 5,
	PREPARE_INPUT_TEXT_OPTIONS_DEFAULT = ((((PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL | PREPARE_INPUT_TEXT_OPTIONS_VALIDATE) | PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL) | PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF) | PREPARE_INPUT_TEXT_OPTIONS_STRIP) | PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE
} PrepareInputTextOptions;



gint64 g_ascii_strtoll (const gchar* str, gchar** endptr, guint num_base);
#define DEFAULT_USER_TEXT_INPUT_LENGTH 1024
gboolean is_string_empty (const gchar* s);
gint utf8_cs_compare (void* a, void* b);
gint utf8_ci_compare (void* a, void* b);
gchar* uchar_array_to_string (guchar* data, int data_length1, gint length);
guchar* string_to_uchar_array (const gchar* str, int* result_length1);
static void _vala_array_add1 (guchar** array, int* length, int* size, guchar value);
gchar* guarded_markup_escape_text (const gchar* plain);
glong find_last_offset (const gchar* str, gchar c);
gboolean is_in_ci_array (const gchar* str, gchar** strings, int strings_length1);
GType prepare_input_text_options_get_type (void) G_GNUC_CONST;
gchar* prepare_input_text (const gchar* text, PrepareInputTextOptions options, gint dest_length);
gint64 parse_int64 (const gchar* str, gint num_base);
gboolean string_contains_char (const gchar* haystack, gunichar needle);
gboolean string_contains_str (const gchar* haystack, const gchar* needle);
gchar* string_sliced_at (const gchar* str, gint index);
gchar* string_sliced_at_first_str (const gchar* haystack, const gchar* needle, gint start_index);
gchar* string_sliced_at_last_str (const gchar* haystack, const gchar* needle, gint start_index);
gchar* string_sliced_at_first_char (const gchar* haystack, gunichar ch, gint start_index);
gchar* string_sliced_at_last_char (const gchar* haystack, gunichar ch, gint start_index);
gchar* string_strip_leading_zeroes (const gchar* str);
gchar* string_remove_diacritics (const gchar* istring);
gchar* string_to_hex_string (const gchar* str);
guint string_collated_hash (void* ptr);
guint string_precollated_hash (void* ptr);
gint string_collated_compare (void* a, void* b);
gint string_precollated_compare (const gchar* astr, const gchar* akey, const gchar* bstr, const gchar* bkey);
gboolean string_collated_equals (void* a, void* b);
gboolean string_precollated_equals (const gchar* astr, const gchar* akey, const gchar* bstr, const gchar* bkey);


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 1086 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 79 "string.c"
}


inline gboolean is_string_empty (const gchar* s) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
#line 12 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = s;
#line 12 "/home/jens/Source/shotwell/src/util/string.vala"
	if (_tmp1_ == NULL) {
#line 12 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp0_ = TRUE;
#line 93 "string.c"
	} else {
		const gchar* _tmp2_ = NULL;
		gchar _tmp3_ = '\0';
#line 12 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp2_ = s;
#line 12 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp3_ = string_get (_tmp2_, (glong) 0);
#line 12 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp0_ = _tmp3_ == '\0';
#line 103 "string.c"
	}
#line 12 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp0_;
#line 12 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 109 "string.c"
}


gint utf8_cs_compare (void* a, void* b) {
	gint result = 0;
	void* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 17 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = a;
#line 17 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = b;
#line 17 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = g_utf8_collate ((const gchar*) _tmp0_, (const gchar*) _tmp1_);
#line 17 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp2_;
#line 17 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 128 "string.c"
}


gint utf8_ci_compare (void* a, void* b) {
	gint result = 0;
	void* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	void* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = a;
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = g_utf8_strdown ((const gchar*) _tmp0_, (gssize) -1);
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = _tmp1_;
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp3_ = b;
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp4_ = g_utf8_strdown ((const gchar*) _tmp3_, (gssize) -1);
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp5_ = _tmp4_;
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp6_ = g_utf8_collate (_tmp2_, _tmp5_);
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp7_ = _tmp6_;
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_free0 (_tmp5_);
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_free0 (_tmp2_);
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp7_;
#line 22 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 166 "string.c"
}


gchar* uchar_array_to_string (guchar* data, int data_length1, gint length) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	GString* builder = NULL;
	GString* _tmp2_ = NULL;
	GString* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
#line 27 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = length;
#line 27 "/home/jens/Source/shotwell/src/util/string.vala"
	if (_tmp0_ < 0) {
#line 182 "string.c"
		guchar* _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
#line 28 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp1_ = data;
#line 28 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp1__length1 = data_length1;
#line 28 "/home/jens/Source/shotwell/src/util/string.vala"
		length = _tmp1__length1;
#line 191 "string.c"
	}
#line 30 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = g_string_new ("");
#line 30 "/home/jens/Source/shotwell/src/util/string.vala"
	builder = _tmp2_;
#line 197 "string.c"
	{
		gint ctr = 0;
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
		ctr = 0;
#line 202 "string.c"
		{
			gboolean _tmp3_ = FALSE;
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
			_tmp3_ = TRUE;
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
			while (TRUE) {
#line 209 "string.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				guchar* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint _tmp8_ = 0;
				guchar _tmp9_ = '\0';
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
				if (!_tmp3_) {
#line 218 "string.c"
					gint _tmp4_ = 0;
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp4_ = ctr;
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
					ctr = _tmp4_ + 1;
#line 224 "string.c"
				}
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp3_ = FALSE;
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp5_ = ctr;
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp6_ = length;
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
				if (!(_tmp5_ < _tmp6_)) {
#line 31 "/home/jens/Source/shotwell/src/util/string.vala"
					break;
#line 236 "string.c"
				}
#line 32 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp7_ = data;
#line 32 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp7__length1 = data_length1;
#line 32 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp8_ = ctr;
#line 32 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp9_ = _tmp7_[_tmp8_];
#line 32 "/home/jens/Source/shotwell/src/util/string.vala"
				if (_tmp9_ != ((guchar) '\0')) {
#line 248 "string.c"
					GString* _tmp10_ = NULL;
					guchar* _tmp11_ = NULL;
					gint _tmp11__length1 = 0;
					gint _tmp12_ = 0;
					guchar _tmp13_ = '\0';
#line 33 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp10_ = builder;
#line 33 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp11_ = data;
#line 33 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp11__length1 = data_length1;
#line 33 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp12_ = ctr;
#line 33 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp13_ = _tmp11_[_tmp12_];
#line 33 "/home/jens/Source/shotwell/src/util/string.vala"
					g_string_append_c (_tmp10_, (gchar) _tmp13_);
#line 266 "string.c"
				} else {
#line 35 "/home/jens/Source/shotwell/src/util/string.vala"
					break;
#line 270 "string.c"
				}
			}
		}
	}
#line 38 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp14_ = builder;
#line 38 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp15_ = _tmp14_->str;
#line 38 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 38 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp16_;
#line 38 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_string_free0 (builder);
#line 38 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 287 "string.c"
}


static void _vala_array_add1 (guchar** array, int* length, int* size, guchar value) {
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
	if ((*length) == (*size)) {
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
		*array = g_renew (guchar, *array, *size);
#line 298 "string.c"
	}
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
	(*array)[(*length)++] = value;
#line 302 "string.c"
}


guchar* string_to_uchar_array (const gchar* str, int* result_length1) {
	guchar* result = NULL;
	guchar* data = NULL;
	guchar* _tmp0_ = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	guchar* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
#line 42 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 43 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_new0 (guchar, 0);
#line 43 "/home/jens/Source/shotwell/src/util/string.vala"
	data = _tmp0_;
#line 43 "/home/jens/Source/shotwell/src/util/string.vala"
	data_length1 = 0;
#line 43 "/home/jens/Source/shotwell/src/util/string.vala"
	_data_size_ = data_length1;
#line 324 "string.c"
	{
		gint ctr = 0;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
		ctr = 0;
#line 329 "string.c"
		{
			gboolean _tmp1_ = FALSE;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
			_tmp1_ = TRUE;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
			while (TRUE) {
#line 336 "string.c"
				gint _tmp3_ = 0;
				const gchar* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				guchar* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				const gchar* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gchar _tmp10_ = '\0';
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
				if (!_tmp1_) {
#line 348 "string.c"
					gint _tmp2_ = 0;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp2_ = ctr;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
					ctr = _tmp2_ + 1;
#line 354 "string.c"
				}
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp1_ = FALSE;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp3_ = ctr;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp4_ = str;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp5_ = strlen (_tmp4_);
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp6_ = _tmp5_;
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
				if (!(_tmp3_ < _tmp6_)) {
#line 44 "/home/jens/Source/shotwell/src/util/string.vala"
					break;
#line 370 "string.c"
				}
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp7_ = data;
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp7__length1 = data_length1;
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp8_ = str;
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp9_ = ctr;
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp10_ = string_get (_tmp8_, (glong) _tmp9_);
#line 45 "/home/jens/Source/shotwell/src/util/string.vala"
				_vala_array_add1 (&data, &data_length1, &_data_size_, (guchar) _tmp10_);
#line 384 "string.c"
			}
		}
	}
#line 47 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp11_ = data;
#line 47 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp11__length1 = data_length1;
#line 47 "/home/jens/Source/shotwell/src/util/string.vala"
	if (result_length1) {
#line 47 "/home/jens/Source/shotwell/src/util/string.vala"
		*result_length1 = _tmp11__length1;
#line 396 "string.c"
	}
#line 47 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp11_;
#line 47 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 402 "string.c"
}


inline gchar* guarded_markup_escape_text (const gchar* plain) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = plain;
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp3_ = is_string_empty (_tmp2_);
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
	if (!_tmp3_) {
#line 418 "string.c"
		const gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp4_ = plain;
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp5_ = g_utf8_validate (_tmp4_, (gssize) -1, NULL);
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp1_ = _tmp5_;
#line 427 "string.c"
	} else {
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp1_ = FALSE;
#line 431 "string.c"
	}
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
	if (_tmp1_) {
#line 435 "string.c"
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp6_ = plain;
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp7_ = g_markup_escape_text (_tmp6_, (gssize) -1);
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (_tmp0_);
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp0_ = _tmp7_;
#line 446 "string.c"
	} else {
		gchar* _tmp8_ = NULL;
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp8_ = g_strdup ("");
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (_tmp0_);
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp0_ = _tmp8_;
#line 455 "string.c"
	}
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp0_;
#line 58 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 461 "string.c"
}


glong find_last_offset (const gchar* str, gchar c) {
	glong result = 0L;
	glong offset = 0L;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 61 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (str != NULL, 0L);
#line 62 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = str;
#line 62 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = strlen (_tmp0_);
#line 62 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = _tmp1_;
#line 62 "/home/jens/Source/shotwell/src/util/string.vala"
	offset = (glong) _tmp2_;
#line 63 "/home/jens/Source/shotwell/src/util/string.vala"
	while (TRUE) {
#line 483 "string.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		const gchar* _tmp5_ = NULL;
		glong _tmp6_ = 0L;
		gchar _tmp7_ = '\0';
		gchar _tmp8_ = '\0';
#line 63 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp3_ = offset;
#line 63 "/home/jens/Source/shotwell/src/util/string.vala"
		offset = _tmp3_ - 1;
#line 63 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp4_ = offset;
#line 63 "/home/jens/Source/shotwell/src/util/string.vala"
		if (!(_tmp4_ >= ((glong) 0))) {
#line 63 "/home/jens/Source/shotwell/src/util/string.vala"
			break;
#line 500 "string.c"
		}
#line 64 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp5_ = str;
#line 64 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp6_ = offset;
#line 64 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp7_ = string_get (_tmp5_, _tmp6_);
#line 64 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp8_ = c;
#line 64 "/home/jens/Source/shotwell/src/util/string.vala"
		if (_tmp7_ == _tmp8_) {
#line 65 "/home/jens/Source/shotwell/src/util/string.vala"
			result = offset;
#line 65 "/home/jens/Source/shotwell/src/util/string.vala"
			return result;
#line 516 "string.c"
		}
	}
#line 68 "/home/jens/Source/shotwell/src/util/string.vala"
	result = (glong) -1;
#line 68 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 523 "string.c"
}


gboolean is_in_ci_array (const gchar* str, gchar** strings, int strings_length1) {
	gboolean result = FALSE;
	gchar* strdown = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
#line 73 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (str != NULL, FALSE);
#line 74 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = str;
#line 74 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) -1);
#line 74 "/home/jens/Source/shotwell/src/util/string.vala"
	strdown = _tmp1_;
#line 75 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = strings;
#line 75 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2__length1 = strings_length1;
#line 546 "string.c"
	{
		gchar** str_element_collection = NULL;
		gint str_element_collection_length1 = 0;
		gint _str_element_collection_size_ = 0;
		gint str_element_it = 0;
#line 75 "/home/jens/Source/shotwell/src/util/string.vala"
		str_element_collection = _tmp2_;
#line 75 "/home/jens/Source/shotwell/src/util/string.vala"
		str_element_collection_length1 = _tmp2__length1;
#line 75 "/home/jens/Source/shotwell/src/util/string.vala"
		for (str_element_it = 0; str_element_it < _tmp2__length1; str_element_it = str_element_it + 1) {
#line 558 "string.c"
			gchar* _tmp3_ = NULL;
			gchar* str_element = NULL;
#line 75 "/home/jens/Source/shotwell/src/util/string.vala"
			_tmp3_ = g_strdup (str_element_collection[str_element_it]);
#line 75 "/home/jens/Source/shotwell/src/util/string.vala"
			str_element = _tmp3_;
#line 565 "string.c"
			{
				const gchar* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
#line 76 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp4_ = strdown;
#line 76 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp5_ = str_element;
#line 76 "/home/jens/Source/shotwell/src/util/string.vala"
				if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
#line 77 "/home/jens/Source/shotwell/src/util/string.vala"
					result = TRUE;
#line 77 "/home/jens/Source/shotwell/src/util/string.vala"
					_g_free0 (str_element);
#line 77 "/home/jens/Source/shotwell/src/util/string.vala"
					_g_free0 (strdown);
#line 77 "/home/jens/Source/shotwell/src/util/string.vala"
					return result;
#line 583 "string.c"
				}
#line 75 "/home/jens/Source/shotwell/src/util/string.vala"
				_g_free0 (str_element);
#line 587 "string.c"
			}
		}
	}
#line 80 "/home/jens/Source/shotwell/src/util/string.vala"
	result = FALSE;
#line 80 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_free0 (strdown);
#line 80 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 597 "string.c"
}


GType prepare_input_text_options_get_type (void) {
	static volatile gsize prepare_input_text_options_type_id__volatile = 0;
	if (g_once_init_enter (&prepare_input_text_options_type_id__volatile)) {
		static const GFlagsValue values[] = {{PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL, "PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL", "empty-is-null"}, {PREPARE_INPUT_TEXT_OPTIONS_VALIDATE, "PREPARE_INPUT_TEXT_OPTIONS_VALIDATE", "validate"}, {PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL, "PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL", "invalid-is-null"}, {PREPARE_INPUT_TEXT_OPTIONS_STRIP, "PREPARE_INPUT_TEXT_OPTIONS_STRIP", "strip"}, {PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF, "PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF", "strip-crlf"}, {PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE, "PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE", "normalize"}, {PREPARE_INPUT_TEXT_OPTIONS_DEFAULT, "PREPARE_INPUT_TEXT_OPTIONS_DEFAULT", "default"}, {0, NULL, NULL}};
		GType prepare_input_text_options_type_id;
		prepare_input_text_options_type_id = g_flags_register_static ("PrepareInputTextOptions", values);
		g_once_init_leave (&prepare_input_text_options_type_id__volatile, prepare_input_text_options_type_id);
	}
	return prepare_input_text_options_type_id__volatile;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 1207 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1208 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1208 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1209 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1209 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_strstrip (_tmp1_);
#line 1210 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _result_;
#line 1210 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 632 "string.c"
}


static gchar* string_delimit (const gchar* self, const gchar* delimiters, gchar new_delimiter) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar _tmp3_ = '\0';
#line 1215 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1215 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (delimiters != NULL, NULL);
#line 1216 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1216 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1217 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1217 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = delimiters;
#line 1217 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = new_delimiter;
#line 1217 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_strdelimit (_tmp1_, _tmp2_, _tmp3_);
#line 1218 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _result_;
#line 1218 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 663 "string.c"
}


gchar* prepare_input_text (const gchar* text, PrepareInputTextOptions options, gint dest_length) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	PrepareInputTextOptions _tmp2_ = 0;
	gchar* prepped = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	PrepareInputTextOptions _tmp10_ = 0;
	PrepareInputTextOptions _tmp13_ = 0;
	PrepareInputTextOptions _tmp16_ = 0;
	gboolean _tmp19_ = FALSE;
	PrepareInputTextOptions _tmp20_ = 0;
	gint _tmp23_ = 0;
#line 95 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = text;
#line 95 "/home/jens/Source/shotwell/src/util/string.vala"
	if (_tmp0_ == NULL) {
#line 96 "/home/jens/Source/shotwell/src/util/string.vala"
		result = NULL;
#line 96 "/home/jens/Source/shotwell/src/util/string.vala"
		return result;
#line 689 "string.c"
	}
#line 98 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = options;
#line 98 "/home/jens/Source/shotwell/src/util/string.vala"
	if ((_tmp2_ & PREPARE_INPUT_TEXT_OPTIONS_VALIDATE) != 0) {
#line 695 "string.c"
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 98 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp3_ = text;
#line 98 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp4_ = g_utf8_validate (_tmp3_, (gssize) -1, NULL);
#line 98 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp1_ = !_tmp4_;
#line 704 "string.c"
	} else {
#line 98 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp1_ = FALSE;
#line 708 "string.c"
	}
#line 98 "/home/jens/Source/shotwell/src/util/string.vala"
	if (_tmp1_) {
#line 712 "string.c"
		const gchar* _tmp5_ = NULL;
		PrepareInputTextOptions _tmp6_ = 0;
		gchar* _tmp7_ = NULL;
#line 99 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp6_ = options;
#line 99 "/home/jens/Source/shotwell/src/util/string.vala"
		if ((_tmp6_ & PREPARE_INPUT_TEXT_OPTIONS_INVALID_IS_NULL) != 0) {
#line 99 "/home/jens/Source/shotwell/src/util/string.vala"
			_tmp5_ = NULL;
#line 722 "string.c"
		} else {
#line 99 "/home/jens/Source/shotwell/src/util/string.vala"
			_tmp5_ = "";
#line 726 "string.c"
		}
#line 99 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp7_ = g_strdup (_tmp5_);
#line 99 "/home/jens/Source/shotwell/src/util/string.vala"
		result = _tmp7_;
#line 99 "/home/jens/Source/shotwell/src/util/string.vala"
		return result;
#line 734 "string.c"
	}
#line 101 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp8_ = text;
#line 101 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 101 "/home/jens/Source/shotwell/src/util/string.vala"
	prepped = _tmp9_;
#line 107 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp10_ = options;
#line 107 "/home/jens/Source/shotwell/src/util/string.vala"
	if ((_tmp10_ & PREPARE_INPUT_TEXT_OPTIONS_NORMALIZE) != 0) {
#line 746 "string.c"
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 108 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp11_ = prepped;
#line 108 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp12_ = g_utf8_normalize (_tmp11_, (gssize) -1, G_NORMALIZE_NFC);
#line 108 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (prepped);
#line 108 "/home/jens/Source/shotwell/src/util/string.vala"
		prepped = _tmp12_;
#line 757 "string.c"
	}
#line 110 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp13_ = options;
#line 110 "/home/jens/Source/shotwell/src/util/string.vala"
	if ((_tmp13_ & PREPARE_INPUT_TEXT_OPTIONS_STRIP) != 0) {
#line 763 "string.c"
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
#line 111 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp14_ = prepped;
#line 111 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp15_ = string_strip (_tmp14_);
#line 111 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (prepped);
#line 111 "/home/jens/Source/shotwell/src/util/string.vala"
		prepped = _tmp15_;
#line 774 "string.c"
	}
#line 115 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp16_ = options;
#line 115 "/home/jens/Source/shotwell/src/util/string.vala"
	if ((_tmp16_ & PREPARE_INPUT_TEXT_OPTIONS_STRIP_CRLF) != 0) {
#line 780 "string.c"
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
#line 116 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp17_ = prepped;
#line 116 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp18_ = string_delimit (_tmp17_, "\n\r", ' ');
#line 116 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (prepped);
#line 116 "/home/jens/Source/shotwell/src/util/string.vala"
		prepped = _tmp18_;
#line 791 "string.c"
	}
#line 118 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp20_ = options;
#line 118 "/home/jens/Source/shotwell/src/util/string.vala"
	if ((_tmp20_ & PREPARE_INPUT_TEXT_OPTIONS_EMPTY_IS_NULL) != 0) {
#line 797 "string.c"
		const gchar* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
#line 118 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp21_ = prepped;
#line 118 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp22_ = is_string_empty (_tmp21_);
#line 118 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp19_ = _tmp22_;
#line 806 "string.c"
	} else {
#line 118 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp19_ = FALSE;
#line 810 "string.c"
	}
#line 118 "/home/jens/Source/shotwell/src/util/string.vala"
	if (_tmp19_) {
#line 119 "/home/jens/Source/shotwell/src/util/string.vala"
		result = NULL;
#line 119 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (prepped);
#line 119 "/home/jens/Source/shotwell/src/util/string.vala"
		return result;
#line 820 "string.c"
	}
#line 124 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp23_ = dest_length;
#line 124 "/home/jens/Source/shotwell/src/util/string.vala"
	if (_tmp23_ >= 0) {
#line 826 "string.c"
		GString* sb = NULL;
		const gchar* _tmp24_ = NULL;
		GString* _tmp25_ = NULL;
		GString* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		GString* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
#line 125 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp24_ = prepped;
#line 125 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp25_ = g_string_new (_tmp24_);
#line 125 "/home/jens/Source/shotwell/src/util/string.vala"
		sb = _tmp25_;
#line 126 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp26_ = sb;
#line 126 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp27_ = dest_length;
#line 126 "/home/jens/Source/shotwell/src/util/string.vala"
		g_string_truncate (_tmp26_, (gsize) _tmp27_);
#line 127 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp28_ = sb;
#line 127 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp29_ = _tmp28_->str;
#line 127 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp30_ = g_strdup (_tmp29_);
#line 127 "/home/jens/Source/shotwell/src/util/string.vala"
		result = _tmp30_;
#line 127 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_string_free0 (sb);
#line 127 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (prepped);
#line 127 "/home/jens/Source/shotwell/src/util/string.vala"
		return result;
#line 861 "string.c"
	}
#line 131 "/home/jens/Source/shotwell/src/util/string.vala"
	result = prepped;
#line 131 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 867 "string.c"
}


gint64 parse_int64 (const gchar* str, gint num_base) {
	gint64 result = 0LL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint64 _tmp2_ = 0LL;
#line 134 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (str != NULL, 0LL);
#line 135 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = str;
#line 135 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = num_base;
#line 135 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = g_ascii_strtoll (_tmp0_, NULL, (guint) _tmp1_);
#line 135 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp2_;
#line 135 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 888 "string.c"
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1007 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1008 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 1008 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 1008 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
#line 1008 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1010 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 1010 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 913 "string.c"
		gchar* _tmp4_ = NULL;
#line 1011 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 1011 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 1011 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 921 "string.c"
	} else {
#line 1013 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = -1;
#line 1013 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 927 "string.c"
	}
}


inline gboolean string_contains_char (const gchar* haystack, gunichar needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gunichar _tmp1_ = 0U;
	gint _tmp2_ = 0;
#line 140 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (haystack != NULL, FALSE);
#line 141 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = haystack;
#line 141 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = needle;
#line 141 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = string_index_of_char (_tmp0_, _tmp1_, 0);
#line 141 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp2_ >= 0;
#line 141 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 949 "string.c"
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 987 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 987 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 988 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 988 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 988 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 988 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 990 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 990 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 976 "string.c"
		gchar* _tmp4_ = NULL;
#line 991 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 991 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 991 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 984 "string.c"
	} else {
#line 993 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = -1;
#line 993 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 990 "string.c"
	}
}


inline gboolean string_contains_str (const gchar* haystack, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 144 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (haystack != NULL, FALSE);
#line 144 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 145 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = haystack;
#line 145 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = needle;
#line 145 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = string_index_of (_tmp0_, _tmp1_, 0);
#line 145 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp2_ >= 0;
#line 145 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1014 "string.c"
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
#line 1328 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1329 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1329 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1329 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1330 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = start;
#line 1330 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp2_ < ((glong) 0)) {
#line 1047 "string.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
#line 1331 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1331 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = start;
#line 1331 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		start = _tmp3_ + _tmp4_;
#line 1056 "string.c"
	}
#line 1333 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp5_ = end;
#line 1333 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp5_ < ((glong) 0)) {
#line 1062 "string.c"
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
#line 1334 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = string_length;
#line 1334 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = end;
#line 1334 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		end = _tmp6_ + _tmp7_;
#line 1071 "string.c"
	}
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp9_ = start;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp9_ >= ((glong) 0)) {
#line 1077 "string.c"
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp10_ = start;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp11_ = string_length;
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp10_ <= _tmp11_;
#line 1086 "string.c"
	} else {
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = FALSE;
#line 1090 "string.c"
	}
#line 1336 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp8_, NULL);
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp13_ = end;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp13_ >= ((glong) 0)) {
#line 1098 "string.c"
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp14_ = end;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = _tmp14_ <= _tmp15_;
#line 1107 "string.c"
	} else {
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp12_ = FALSE;
#line 1111 "string.c"
	}
#line 1337 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp12_, NULL);
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp16_ = start;
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp17_ = end;
#line 1338 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp18_ = start;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp19_ = end;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp20_ = start;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp21_;
#line 1339 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 1133 "string.c"
}


inline gchar* string_sliced_at (const gchar* str, gint index) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
#line 148 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 149 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = index;
#line 149 "/home/jens/Source/shotwell/src/util/string.vala"
	if (_tmp1_ >= 0) {
#line 1147 "string.c"
		const gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gchar* _tmp7_ = NULL;
#line 149 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp2_ = str;
#line 149 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp3_ = index;
#line 149 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp4_ = str;
#line 149 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp5_ = strlen (_tmp4_);
#line 149 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp6_ = _tmp5_;
#line 149 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp7_ = string_slice (_tmp2_, (glong) _tmp3_, (glong) _tmp6_);
#line 149 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (_tmp0_);
#line 149 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp0_ = _tmp7_;
#line 1170 "string.c"
	} else {
#line 149 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (_tmp0_);
#line 149 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp0_ = NULL;
#line 1176 "string.c"
	}
#line 149 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp0_;
#line 149 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1182 "string.c"
}


inline gchar* string_sliced_at_first_str (const gchar* haystack, const gchar* needle, gint start_index) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
#line 152 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (haystack != NULL, NULL);
#line 152 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (needle != NULL, NULL);
#line 153 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = haystack;
#line 153 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = haystack;
#line 153 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = needle;
#line 153 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp3_ = start_index;
#line 153 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp4_ = string_index_of (_tmp1_, _tmp2_, _tmp3_);
#line 153 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp5_ = string_sliced_at (_tmp0_, _tmp4_);
#line 153 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp5_;
#line 153 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1214 "string.c"
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 997 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 997 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 998 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 998 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 998 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 998 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1000 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 1000 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1241 "string.c"
		gchar* _tmp4_ = NULL;
#line 1001 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 1001 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 1001 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 1249 "string.c"
	} else {
#line 1003 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = -1;
#line 1003 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 1255 "string.c"
	}
}


inline gchar* string_sliced_at_last_str (const gchar* haystack, const gchar* needle, gint start_index) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
#line 156 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (haystack != NULL, NULL);
#line 156 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (needle != NULL, NULL);
#line 157 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = haystack;
#line 157 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = haystack;
#line 157 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = needle;
#line 157 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp3_ = start_index;
#line 157 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp4_ = string_last_index_of (_tmp1_, _tmp2_, _tmp3_);
#line 157 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp5_ = string_sliced_at (_tmp0_, _tmp4_);
#line 157 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp5_;
#line 157 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1288 "string.c"
}


inline gchar* string_sliced_at_first_char (const gchar* haystack, gunichar ch, gint start_index) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gunichar _tmp2_ = 0U;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
#line 160 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (haystack != NULL, NULL);
#line 161 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = haystack;
#line 161 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = haystack;
#line 161 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = ch;
#line 161 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp3_ = start_index;
#line 161 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp4_ = string_index_of_char (_tmp1_, _tmp2_, _tmp3_);
#line 161 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp5_ = string_sliced_at (_tmp0_, _tmp4_);
#line 161 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp5_;
#line 161 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1318 "string.c"
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1017 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1018 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 1018 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = c;
#line 1018 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
#line 1018 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1020 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 1020 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 1343 "string.c"
		gchar* _tmp4_ = NULL;
#line 1021 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 1021 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 1021 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 1351 "string.c"
	} else {
#line 1023 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = -1;
#line 1023 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 1357 "string.c"
	}
}


inline gchar* string_sliced_at_last_char (const gchar* haystack, gunichar ch, gint start_index) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gunichar _tmp2_ = 0U;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
#line 164 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (haystack != NULL, NULL);
#line 165 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = haystack;
#line 165 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = haystack;
#line 165 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = ch;
#line 165 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp3_ = start_index;
#line 165 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp4_ = string_last_index_of_char (_tmp1_, _tmp2_, _tmp3_);
#line 165 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp5_ = string_sliced_at (_tmp0_, _tmp4_);
#line 165 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp5_;
#line 165 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1388 "string.c"
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
#line 1116 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1117 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1117 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1117 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1117 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 1406 "string.c"
}


gchar* string_strip_leading_zeroes (const gchar* str) {
	gchar* result = NULL;
	GString* stripped = NULL;
	GString* _tmp0_ = NULL;
	gboolean prev_is_space = FALSE;
	GString* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
#line 169 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 170 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_string_new ("");
#line 170 "/home/jens/Source/shotwell/src/util/string.vala"
	stripped = _tmp0_;
#line 171 "/home/jens/Source/shotwell/src/util/string.vala"
	prev_is_space = TRUE;
#line 1426 "string.c"
	{
		const gchar* iter = NULL;
		const gchar* _tmp1_ = NULL;
#line 172 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp1_ = str;
#line 172 "/home/jens/Source/shotwell/src/util/string.vala"
		iter = _tmp1_;
#line 1434 "string.c"
		{
			gboolean _tmp2_ = FALSE;
#line 172 "/home/jens/Source/shotwell/src/util/string.vala"
			_tmp2_ = TRUE;
#line 172 "/home/jens/Source/shotwell/src/util/string.vala"
			while (TRUE) {
#line 1441 "string.c"
				const gchar* _tmp5_ = NULL;
				gunichar _tmp6_ = 0U;
				gunichar ch = 0U;
				const gchar* _tmp7_ = NULL;
				gunichar _tmp8_ = 0U;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
#line 172 "/home/jens/Source/shotwell/src/util/string.vala"
				if (!_tmp2_) {
#line 1451 "string.c"
					const gchar* _tmp3_ = NULL;
					const gchar* _tmp4_ = NULL;
#line 172 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp3_ = iter;
#line 172 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp4_ = g_utf8_next_char (_tmp3_);
#line 172 "/home/jens/Source/shotwell/src/util/string.vala"
					iter = _tmp4_;
#line 1460 "string.c"
				}
#line 172 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp2_ = FALSE;
#line 172 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp5_ = iter;
#line 172 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp6_ = string_get_char (_tmp5_, (glong) 0);
#line 172 "/home/jens/Source/shotwell/src/util/string.vala"
				if (!(_tmp6_ != ((gunichar) 0))) {
#line 172 "/home/jens/Source/shotwell/src/util/string.vala"
					break;
#line 1472 "string.c"
				}
#line 173 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp7_ = iter;
#line 173 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp8_ = string_get_char (_tmp7_, (glong) 0);
#line 173 "/home/jens/Source/shotwell/src/util/string.vala"
				ch = _tmp8_;
#line 175 "/home/jens/Source/shotwell/src/util/string.vala"
				_tmp10_ = prev_is_space;
#line 175 "/home/jens/Source/shotwell/src/util/string.vala"
				if (!_tmp10_) {
#line 175 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp9_ = TRUE;
#line 1486 "string.c"
				} else {
					gunichar _tmp11_ = 0U;
#line 175 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp11_ = ch;
#line 175 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp9_ = _tmp11_ != ((gunichar) '0');
#line 1493 "string.c"
				}
#line 175 "/home/jens/Source/shotwell/src/util/string.vala"
				if (_tmp9_) {
#line 1497 "string.c"
					GString* _tmp12_ = NULL;
					gunichar _tmp13_ = 0U;
					gunichar _tmp14_ = 0U;
					gboolean _tmp15_ = FALSE;
#line 176 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp12_ = stripped;
#line 176 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp13_ = ch;
#line 176 "/home/jens/Source/shotwell/src/util/string.vala"
					g_string_append_unichar (_tmp12_, _tmp13_);
#line 177 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp14_ = ch;
#line 177 "/home/jens/Source/shotwell/src/util/string.vala"
					_tmp15_ = g_unichar_isspace (_tmp14_);
#line 177 "/home/jens/Source/shotwell/src/util/string.vala"
					prev_is_space = _tmp15_;
#line 1514 "string.c"
				}
			}
		}
	}
#line 181 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp16_ = stripped;
#line 181 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp17_ = _tmp16_->str;
#line 181 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp18_ = g_strdup (_tmp17_);
#line 181 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp18_;
#line 181 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_string_free0 (stripped);
#line 181 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1531 "string.c"
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gunichar _tmp2_ = 0U;
#line 1105 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1106 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = *index;
#line 1106 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
#line 1106 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_vala_c = _tmp1_;
#line 1107 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = _vala_c;
#line 1107 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (_tmp2_ != ((gunichar) 0)) {
#line 1553 "string.c"
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
#line 1108 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = *index;
#line 1108 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
#line 1108 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		*index = (gint) (_tmp4_ - ((gchar*) self));
#line 1109 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = TRUE;
#line 1109 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (c) {
#line 1109 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 1568 "string.c"
		}
#line 1109 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 1572 "string.c"
	} else {
#line 1111 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = FALSE;
#line 1111 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (c) {
#line 1111 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			*c = _vala_c;
#line 1580 "string.c"
		}
#line 1111 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 1584 "string.c"
	}
#line 1105 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (c) {
#line 1105 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		*c = _vala_c;
#line 1590 "string.c"
	}
}


gchar* string_remove_diacritics (const gchar* istring) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	gunichar ch = 0U;
	gint i = 0;
	GString* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
#line 184 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (istring != NULL, NULL);
#line 185 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_string_new ("");
#line 185 "/home/jens/Source/shotwell/src/util/string.vala"
	builder = _tmp0_;
#line 187 "/home/jens/Source/shotwell/src/util/string.vala"
	i = 0;
#line 188 "/home/jens/Source/shotwell/src/util/string.vala"
	while (TRUE) {
#line 1614 "string.c"
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gunichar _tmp4_ = 0U;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gunichar _tmp7_ = 0U;
		GUnicodeType _tmp8_ = 0;
		GString* _tmp9_ = NULL;
		gunichar _tmp10_ = 0U;
#line 188 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp1_ = istring;
#line 188 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp2_ = g_utf8_normalize (_tmp1_, (gssize) -1, G_NORMALIZE_DEFAULT);
#line 188 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp3_ = _tmp2_;
#line 188 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp5_ = string_get_next_char (_tmp3_, &i, &_tmp4_);
#line 188 "/home/jens/Source/shotwell/src/util/string.vala"
		ch = _tmp4_;
#line 188 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp6_ = !_tmp5_;
#line 188 "/home/jens/Source/shotwell/src/util/string.vala"
		_g_free0 (_tmp3_);
#line 188 "/home/jens/Source/shotwell/src/util/string.vala"
		if (_tmp6_) {
#line 188 "/home/jens/Source/shotwell/src/util/string.vala"
			break;
#line 1643 "string.c"
		}
#line 189 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp7_ = ch;
#line 189 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp8_ = g_unichar_type (_tmp7_);
#line 189 "/home/jens/Source/shotwell/src/util/string.vala"
		switch (_tmp8_) {
#line 189 "/home/jens/Source/shotwell/src/util/string.vala"
			case G_UNICODE_CONTROL:
#line 189 "/home/jens/Source/shotwell/src/util/string.vala"
			case G_UNICODE_FORMAT:
#line 189 "/home/jens/Source/shotwell/src/util/string.vala"
			case G_UNICODE_UNASSIGNED:
#line 189 "/home/jens/Source/shotwell/src/util/string.vala"
			case G_UNICODE_NON_SPACING_MARK:
#line 189 "/home/jens/Source/shotwell/src/util/string.vala"
			case G_UNICODE_COMBINING_MARK:
#line 189 "/home/jens/Source/shotwell/src/util/string.vala"
			case G_UNICODE_ENCLOSING_MARK:
#line 1663 "string.c"
			{
#line 197 "/home/jens/Source/shotwell/src/util/string.vala"
				continue;
#line 1667 "string.c"
			}
			default:
#line 189 "/home/jens/Source/shotwell/src/util/string.vala"
			break;
#line 1672 "string.c"
		}
#line 199 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp9_ = builder;
#line 199 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp10_ = ch;
#line 199 "/home/jens/Source/shotwell/src/util/string.vala"
		g_string_append_unichar (_tmp9_, _tmp10_);
#line 1680 "string.c"
	}
#line 201 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp11_ = builder;
#line 201 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp12_ = _tmp11_->str;
#line 201 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp13_ = g_strdup (_tmp12_);
#line 201 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp13_;
#line 201 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_string_free0 (builder);
#line 201 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1694 "string.c"
}


gchar* string_to_hex_string (const gchar* str) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	guint8* data = NULL;
	const gchar* _tmp1_ = NULL;
	GString* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
#line 204 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (str != NULL, NULL);
#line 205 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_string_new ("");
#line 205 "/home/jens/Source/shotwell/src/util/string.vala"
	builder = _tmp0_;
#line 207 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = str;
#line 207 "/home/jens/Source/shotwell/src/util/string.vala"
	data = (guint8*) _tmp1_;
#line 208 "/home/jens/Source/shotwell/src/util/string.vala"
	while (TRUE) {
#line 1719 "string.c"
		guint8* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		guint8* _tmp4_ = NULL;
		GString* _tmp5_ = NULL;
		guint8* _tmp6_ = NULL;
#line 208 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp2_ = data;
#line 208 "/home/jens/Source/shotwell/src/util/string.vala"
		if (!(((gint) (*_tmp2_)) != 0)) {
#line 208 "/home/jens/Source/shotwell/src/util/string.vala"
			break;
#line 1731 "string.c"
		}
#line 209 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp4_ = data;
#line 209 "/home/jens/Source/shotwell/src/util/string.vala"
		if (((gint) (*_tmp4_)) != 0) {
#line 209 "/home/jens/Source/shotwell/src/util/string.vala"
			_tmp3_ = " ";
#line 1739 "string.c"
		} else {
#line 209 "/home/jens/Source/shotwell/src/util/string.vala"
			_tmp3_ = "";
#line 1743 "string.c"
		}
#line 209 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp5_ = builder;
#line 209 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp6_ = data;
#line 209 "/home/jens/Source/shotwell/src/util/string.vala"
		data = _tmp6_ + 1;
#line 209 "/home/jens/Source/shotwell/src/util/string.vala"
		g_string_append_printf (_tmp5_, "%02Xh%s", (guint) (*_tmp6_), _tmp3_);
#line 1753 "string.c"
	}
#line 211 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp7_ = builder;
#line 211 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp8_ = _tmp7_->str;
#line 211 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp9_ = g_strdup (_tmp8_);
#line 211 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp9_;
#line 211 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_string_free0 (builder);
#line 211 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1767 "string.c"
}


guint string_collated_hash (void* ptr) {
	guint result = 0U;
	gchar* str = NULL;
	void* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GHashFunc _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
#line 231 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = ptr;
#line 231 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
#line 231 "/home/jens/Source/shotwell/src/util/string.vala"
	str = _tmp1_;
#line 233 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = g_str_hash;
#line 233 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp3_ = g_utf8_collate_key (str, (gssize) -1);
#line 233 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp4_ = _tmp3_;
#line 233 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp5_ = _tmp2_ (_tmp4_);
#line 233 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp6_ = _tmp5_;
#line 233 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_free0 (_tmp4_);
#line 233 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp6_;
#line 233 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_free0 (str);
#line 233 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1805 "string.c"
}


guint string_precollated_hash (void* ptr) {
	guint result = 0U;
	GHashFunc _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
#line 238 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_str_hash;
#line 238 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = ptr;
#line 238 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = _tmp0_ ((const gchar*) _tmp1_);
#line 238 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp2_;
#line 238 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1824 "string.c"
}


gint string_collated_compare (void* a, void* b) {
	gint result = 0;
	gchar* astr = NULL;
	void* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* bstr = NULL;
	void* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint _result_ = 0;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 243 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = a;
#line 243 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = g_strdup ((const gchar*) _tmp0_);
#line 243 "/home/jens/Source/shotwell/src/util/string.vala"
	astr = _tmp1_;
#line 244 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = b;
#line 244 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp3_ = g_strdup ((const gchar*) _tmp2_);
#line 244 "/home/jens/Source/shotwell/src/util/string.vala"
	bstr = _tmp3_;
#line 246 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp4_ = astr;
#line 246 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp5_ = bstr;
#line 246 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp6_ = g_utf8_collate (_tmp4_, _tmp5_);
#line 246 "/home/jens/Source/shotwell/src/util/string.vala"
	_result_ = _tmp6_;
#line 248 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp8_ = _result_;
#line 248 "/home/jens/Source/shotwell/src/util/string.vala"
	if (_tmp8_ != 0) {
#line 1866 "string.c"
		gint _tmp9_ = 0;
#line 248 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp9_ = _result_;
#line 248 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp7_ = _tmp9_;
#line 1872 "string.c"
	} else {
		GCompareFunc _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gint _tmp13_ = 0;
#line 248 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp10_ = g_strcmp0;
#line 248 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp11_ = astr;
#line 248 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp12_ = bstr;
#line 248 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp13_ = _tmp10_ (_tmp11_, _tmp12_);
#line 248 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp7_ = _tmp13_;
#line 1888 "string.c"
	}
#line 248 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp7_;
#line 248 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_free0 (bstr);
#line 248 "/home/jens/Source/shotwell/src/util/string.vala"
	_g_free0 (astr);
#line 248 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1898 "string.c"
}


gint string_precollated_compare (const gchar* astr, const gchar* akey, const gchar* bstr, const gchar* bkey) {
	gint result = 0;
	gint _result_ = 0;
	GCompareFunc _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 252 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (astr != NULL, 0);
#line 252 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (akey != NULL, 0);
#line 252 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (bstr != NULL, 0);
#line 252 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (bkey != NULL, 0);
#line 253 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = g_strcmp0;
#line 253 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = akey;
#line 253 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = bkey;
#line 253 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp3_ = _tmp0_ (_tmp1_, _tmp2_);
#line 253 "/home/jens/Source/shotwell/src/util/string.vala"
	_result_ = _tmp3_;
#line 255 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp5_ = _result_;
#line 255 "/home/jens/Source/shotwell/src/util/string.vala"
	if (_tmp5_ != 0) {
#line 1933 "string.c"
		gint _tmp6_ = 0;
#line 255 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp6_ = _result_;
#line 255 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp4_ = _tmp6_;
#line 1939 "string.c"
	} else {
		GCompareFunc _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
#line 255 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp7_ = g_strcmp0;
#line 255 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp8_ = astr;
#line 255 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp9_ = bstr;
#line 255 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp10_ = _tmp7_ (_tmp8_, _tmp9_);
#line 255 "/home/jens/Source/shotwell/src/util/string.vala"
		_tmp4_ = _tmp10_;
#line 1955 "string.c"
	}
#line 255 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp4_;
#line 255 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1961 "string.c"
}


gboolean string_collated_equals (void* a, void* b) {
	gboolean result = FALSE;
	void* _tmp0_ = NULL;
	void* _tmp1_ = NULL;
	gint _tmp2_ = 0;
#line 260 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = a;
#line 260 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = b;
#line 260 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = string_collated_compare (_tmp0_, _tmp1_);
#line 260 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp2_ == 0;
#line 260 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 1980 "string.c"
}


gboolean string_precollated_equals (const gchar* astr, const gchar* akey, const gchar* bstr, const gchar* bkey) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
#line 264 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (astr != NULL, FALSE);
#line 264 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (akey != NULL, FALSE);
#line 264 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (bstr != NULL, FALSE);
#line 264 "/home/jens/Source/shotwell/src/util/string.vala"
	g_return_val_if_fail (bkey != NULL, FALSE);
#line 265 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp0_ = astr;
#line 265 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp1_ = akey;
#line 265 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp2_ = bstr;
#line 265 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp3_ = bkey;
#line 265 "/home/jens/Source/shotwell/src/util/string.vala"
	_tmp4_ = string_precollated_compare (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
#line 265 "/home/jens/Source/shotwell/src/util/string.vala"
	result = _tmp4_ == 0;
#line 265 "/home/jens/Source/shotwell/src/util/string.vala"
	return result;
#line 2013 "string.c"
}



