/* Upgrades.c generated by valac 0.34.2, the Vala compiler
 * generated from Upgrades.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* Class for aggregating one-off "upgrade" tasks that occur at startup, such as*/
/* moving or deleting files. This occurs after the UI is shown, so it's not appropriate*/
/* for database updates and such.*/

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gobject/gvaluecollector.h>


#define TYPE_UPGRADES (upgrades_get_type ())
#define UPGRADES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UPGRADES, Upgrades))
#define UPGRADES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UPGRADES, UpgradesClass))
#define IS_UPGRADES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UPGRADES))
#define IS_UPGRADES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UPGRADES))
#define UPGRADES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UPGRADES, UpgradesClass))

typedef struct _Upgrades Upgrades;
typedef struct _UpgradesClass UpgradesClass;
typedef struct _UpgradesPrivate UpgradesPrivate;

#define TYPE_UPGRADE_TASK (upgrade_task_get_type ())
#define UPGRADE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UPGRADE_TASK, UpgradeTask))
#define IS_UPGRADE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UPGRADE_TASK))
#define UPGRADE_TASK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_UPGRADE_TASK, UpgradeTaskIface))

typedef struct _UpgradeTask UpgradeTask;
typedef struct _UpgradeTaskIface UpgradeTaskIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MIMICS_REMOVAL_TASK (mimics_removal_task_get_type ())
#define MIMICS_REMOVAL_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MIMICS_REMOVAL_TASK, MimicsRemovalTask))
#define MIMICS_REMOVAL_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MIMICS_REMOVAL_TASK, MimicsRemovalTaskClass))
#define IS_MIMICS_REMOVAL_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MIMICS_REMOVAL_TASK))
#define IS_MIMICS_REMOVAL_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MIMICS_REMOVAL_TASK))
#define MIMICS_REMOVAL_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MIMICS_REMOVAL_TASK, MimicsRemovalTaskClass))

typedef struct _MimicsRemovalTask MimicsRemovalTask;
typedef struct _MimicsRemovalTaskClass MimicsRemovalTaskClass;

#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
#define _application_unref0(var) ((var == NULL) ? NULL : (var = (application_unref (var), NULL)))

#define TYPE_FIXUP_RAW_THUMBNAILS_TASK (fixup_raw_thumbnails_task_get_type ())
#define FIXUP_RAW_THUMBNAILS_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FIXUP_RAW_THUMBNAILS_TASK, FixupRawThumbnailsTask))
#define FIXUP_RAW_THUMBNAILS_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FIXUP_RAW_THUMBNAILS_TASK, FixupRawThumbnailsTaskClass))
#define IS_FIXUP_RAW_THUMBNAILS_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FIXUP_RAW_THUMBNAILS_TASK))
#define IS_FIXUP_RAW_THUMBNAILS_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FIXUP_RAW_THUMBNAILS_TASK))
#define FIXUP_RAW_THUMBNAILS_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FIXUP_RAW_THUMBNAILS_TASK, FixupRawThumbnailsTaskClass))

typedef struct _FixupRawThumbnailsTask FixupRawThumbnailsTask;
typedef struct _FixupRawThumbnailsTaskClass FixupRawThumbnailsTaskClass;
#define _upgrades_unref0(var) ((var == NULL) ? NULL : (var = (upgrades_unref (var), NULL)))
typedef struct _ParamSpecUpgrades ParamSpecUpgrades;
typedef struct _MimicsRemovalTaskPrivate MimicsRemovalTaskPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FixupRawThumbnailsTaskPrivate FixupRawThumbnailsTaskPrivate;

#define TYPE_PHOTO_ROW (photo_row_get_type ())
#define PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_ROW, PhotoRow))
#define PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_ROW, PhotoRowClass))
#define IS_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_ROW))
#define IS_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_ROW))
#define PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_ROW, PhotoRowClass))

typedef struct _PhotoRow PhotoRow;
typedef struct _PhotoRowClass PhotoRowClass;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_PHOTO_TABLE (photo_table_get_type ())
#define PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_TABLE, PhotoTable))
#define PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_TABLE, PhotoTableClass))
#define IS_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_TABLE))
#define IS_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_TABLE))
#define PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_TABLE, PhotoTableClass))

typedef struct _PhotoTable PhotoTable;
typedef struct _PhotoTableClass PhotoTableClass;
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
typedef struct _PhotoRowPrivate PhotoRowPrivate;

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_ORIENTATION (orientation_get_type ())

#define TYPE_KEY_VALUE_MAP (key_value_map_get_type ())
#define KEY_VALUE_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_VALUE_MAP, KeyValueMap))
#define KEY_VALUE_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_VALUE_MAP, KeyValueMapClass))
#define IS_KEY_VALUE_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_VALUE_MAP))
#define IS_KEY_VALUE_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_VALUE_MAP))
#define KEY_VALUE_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_VALUE_MAP, KeyValueMapClass))

typedef struct _KeyValueMap KeyValueMap;
typedef struct _KeyValueMapClass KeyValueMapClass;

#define TYPE_RATING (rating_get_type ())

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _photo_row_unref0(var) ((var == NULL) ? NULL : (var = (photo_row_unref (var), NULL)))

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;

#define TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION (library_photo_source_collection_get_type ())
#define LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))

typedef struct _LibraryPhotoSourceCollection LibraryPhotoSourceCollection;
typedef struct _LibraryPhotoSourceCollectionClass LibraryPhotoSourceCollectionClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Upgrades {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UpgradesPrivate * priv;
};

struct _UpgradesClass {
	GTypeClass parent_class;
	void (*finalize) (Upgrades *self);
};

typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, void* user_data);
struct _UpgradeTaskIface {
	GTypeInterface parent_iface;
	guint64 (*get_step_count) (UpgradeTask* self);
	void (*execute) (UpgradeTask* self, ProgressMonitor monitor, void* monitor_target);
};

struct _UpgradesPrivate {
	guint64 total_steps;
	GeeLinkedList* task_list;
};

struct _ParamSpecUpgrades {
	GParamSpec parent_instance;
};

struct _MimicsRemovalTask {
	GObject parent_instance;
	MimicsRemovalTaskPrivate * priv;
};

struct _MimicsRemovalTaskClass {
	GObjectClass parent_class;
};

struct _MimicsRemovalTaskPrivate {
	GFile* mimic_dir;
	guint64 num_mimics;
};

struct _FixupRawThumbnailsTask {
	GObject parent_instance;
	FixupRawThumbnailsTaskPrivate * priv;
};

struct _FixupRawThumbnailsTaskClass {
	GObjectClass parent_class;
};

struct _PhotoID {
	gint64 id;
};

struct _ImportID {
	gint64 id;
};

struct _EventID {
	gint64 id;
};

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

struct _BackingPhotoID {
	gint64 id;
};

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _PhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoRowPrivate * priv;
	PhotoID photo_id;
	BackingPhotoRow* master;
	time_t exposure_time;
	ImportID import_id;
	EventID event_id;
	Orientation orientation;
	GeeHashMap* transformations;
	gchar* md5;
	gchar* thumbnail_md5;
	gchar* exif_md5;
	time_t time_created;
	guint64 flags;
	Rating rating;
	gchar* title;
	gchar* comment;
	gchar* backlinks;
	time_t time_reimported;
	BackingPhotoID editable_id;
	gboolean metadata_dirty;
	RawDeveloper developer;
	BackingPhotoID* development_ids;
	gint development_ids_length1;
};

struct _PhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoRow *self);
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _Dimensions {
	gint width;
	gint height;
};

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	time_t time_created;
	gchar* filepath;
	gint64 filesize;
	time_t timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};


static gpointer upgrades_parent_class = NULL;
static Upgrades* upgrades_instance;
static Upgrades* upgrades_instance = NULL;
static gpointer mimics_removal_task_parent_class = NULL;
static UpgradeTaskIface* mimics_removal_task_upgrade_task_parent_iface = NULL;
static gpointer fixup_raw_thumbnails_task_parent_class = NULL;
extern LibraryPhotoSourceCollection* library_photo_global;
static UpgradeTaskIface* fixup_raw_thumbnails_task_upgrade_task_parent_iface = NULL;

gpointer upgrades_ref (gpointer instance);
void upgrades_unref (gpointer instance);
GParamSpec* param_spec_upgrades (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_upgrades (GValue* value, gpointer v_object);
void value_take_upgrades (GValue* value, gpointer v_object);
gpointer value_get_upgrades (const GValue* value);
GType upgrades_get_type (void) G_GNUC_CONST;
GType upgrade_task_get_type (void) G_GNUC_CONST;
#define UPGRADES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_UPGRADES, UpgradesPrivate))
enum  {
	UPGRADES_DUMMY_PROPERTY
};
static Upgrades* upgrades_new (void);
static Upgrades* upgrades_construct (GType object_type);
static void upgrades_add (Upgrades* self, UpgradeTask* task);
MimicsRemovalTask* mimics_removal_task_new (void);
MimicsRemovalTask* mimics_removal_task_construct (GType object_type);
GType mimics_removal_task_get_type (void) G_GNUC_CONST;
gpointer application_ref (gpointer instance);
void application_unref (gpointer instance);
GParamSpec* param_spec_application (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_application (GValue* value, gpointer v_object);
void value_take_application (GValue* value, gpointer v_object);
gpointer value_get_application (const GValue* value);
GType application_get_type (void) G_GNUC_CONST;
Application* application_get_instance (void);
gboolean application_get_raw_thumbs_fix_required (Application* self);
FixupRawThumbnailsTask* fixup_raw_thumbnails_task_new (void);
FixupRawThumbnailsTask* fixup_raw_thumbnails_task_construct (GType object_type);
GType fixup_raw_thumbnails_task_get_type (void) G_GNUC_CONST;
void upgrades_init (void);
Upgrades* upgrades_get_instance (void);
guint64 upgrades_get_step_count (Upgrades* self);
void upgrades_execute (Upgrades* self, ProgressMonitor monitor, void* monitor_target);
void upgrade_task_execute (UpgradeTask* self, ProgressMonitor monitor, void* monitor_target);
guint64 upgrade_task_get_step_count (UpgradeTask* self);
static void upgrades_finalize (Upgrades* obj);
#define MIMICS_REMOVAL_TASK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MIMICS_REMOVAL_TASK, MimicsRemovalTaskPrivate))
enum  {
	MIMICS_REMOVAL_TASK_DUMMY_PROPERTY
};
GFile* app_dirs_get_data_dir (void);
static guint64 mimics_removal_task_real_get_step_count (UpgradeTask* base);
guint64 count_files_in_directory (GFile* dir, GError** error);
static void mimics_removal_task_real_execute (UpgradeTask* base, ProgressMonitor monitor, void* monitor_target);
void delete_all_files (GFile* dir, GeeSet* exceptions, ProgressMonitor monitor, void* monitor_target, guint64 file_count, GCancellable* cancellable, GError** error);
static void mimics_removal_task_finalize (GObject* obj);
enum  {
	FIXUP_RAW_THUMBNAILS_TASK_DUMMY_PROPERTY
};
static guint64 fixup_raw_thumbnails_task_real_get_step_count (UpgradeTask* base);
gpointer photo_row_ref (gpointer instance);
void photo_row_unref (gpointer instance);
GParamSpec* param_spec_photo_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_row (GValue* value, gpointer v_object);
void value_take_photo_row (GValue* value, gpointer v_object);
gpointer value_get_photo_row (const GValue* value);
GType photo_row_get_type (void) G_GNUC_CONST;
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_database_table (GValue* value, gpointer v_object);
void value_take_database_table (GValue* value, gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType photo_table_get_type (void) G_GNUC_CONST;
PhotoTable* photo_table_get_instance (void);
GeeArrayList* photo_table_get_all (PhotoTable* self);
GType photo_id_get_type (void) G_GNUC_CONST;
PhotoID* photo_id_dup (const PhotoID* self);
void photo_id_free (PhotoID* self);
gpointer backing_photo_row_ref (gpointer instance);
void backing_photo_row_unref (gpointer instance);
GParamSpec* param_spec_backing_photo_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_backing_photo_row (GValue* value, gpointer v_object);
void value_take_backing_photo_row (GValue* value, gpointer v_object);
gpointer value_get_backing_photo_row (const GValue* value);
GType backing_photo_row_get_type (void) G_GNUC_CONST;
GType import_id_get_type (void) G_GNUC_CONST;
ImportID* import_id_dup (const ImportID* self);
void import_id_free (ImportID* self);
GType event_id_get_type (void) G_GNUC_CONST;
EventID* event_id_dup (const EventID* self);
void event_id_free (EventID* self);
GType orientation_get_type (void) G_GNUC_CONST;
gpointer key_value_map_ref (gpointer instance);
void key_value_map_unref (gpointer instance);
GParamSpec* param_spec_key_value_map (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_key_value_map (GValue* value, gpointer v_object);
void value_take_key_value_map (GValue* value, gpointer v_object);
gpointer value_get_key_value_map (const GValue* value);
GType key_value_map_get_type (void) G_GNUC_CONST;
GType rating_get_type (void) G_GNUC_CONST;
GType backing_photo_id_get_type (void) G_GNUC_CONST;
BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
void backing_photo_id_free (BackingPhotoID* self);
GType raw_developer_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
static void fixup_raw_thumbnails_task_real_execute (UpgradeTask* base, ProgressMonitor monitor, void* monitor_target);
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
void thumbnail_cache_remove (ThumbnailSource* source);
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_data_collection (GValue* value, gpointer v_object);
void value_take_data_collection (GValue* value, gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType media_source_collection_get_type (void) G_GNUC_CONST;
GType library_photo_source_collection_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType library_photo_get_type (void) G_GNUC_CONST;
LibraryPhoto* library_photo_source_collection_fetch (LibraryPhotoSourceCollection* self, PhotoID* photo_id);


static Upgrades* upgrades_construct (GType object_type) {
	Upgrades* self = NULL;
	MimicsRemovalTask* _tmp0_ = NULL;
	MimicsRemovalTask* _tmp1_ = NULL;
	Application* _tmp2_ = NULL;
	Application* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
#line 15 "/home/jens/Source/shotwell/src/Upgrades.vala"
	self = (Upgrades*) g_type_create_instance (object_type);
#line 17 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp0_ = mimics_removal_task_new ();
#line 17 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp1_ = _tmp0_;
#line 17 "/home/jens/Source/shotwell/src/Upgrades.vala"
	upgrades_add (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_UPGRADE_TASK, UpgradeTask));
#line 17 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_g_object_unref0 (_tmp1_);
#line 19 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp2_ = application_get_instance ();
#line 19 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp3_ = _tmp2_;
#line 19 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp4_ = application_get_raw_thumbs_fix_required (_tmp3_);
#line 19 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp5_ = _tmp4_;
#line 19 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_application_unref0 (_tmp3_);
#line 19 "/home/jens/Source/shotwell/src/Upgrades.vala"
	if (_tmp5_) {
#line 606 "Upgrades.c"
		FixupRawThumbnailsTask* _tmp6_ = NULL;
		FixupRawThumbnailsTask* _tmp7_ = NULL;
#line 20 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp6_ = fixup_raw_thumbnails_task_new ();
#line 20 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp7_ = _tmp6_;
#line 20 "/home/jens/Source/shotwell/src/Upgrades.vala"
		upgrades_add (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_UPGRADE_TASK, UpgradeTask));
#line 20 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_g_object_unref0 (_tmp7_);
#line 617 "Upgrades.c"
	}
#line 15 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return self;
#line 621 "Upgrades.c"
}


static Upgrades* upgrades_new (void) {
#line 15 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return upgrades_construct (TYPE_UPGRADES);
#line 628 "Upgrades.c"
}


void upgrades_init (void) {
	Upgrades* _tmp0_ = NULL;
	Upgrades* _tmp1_ = NULL;
#line 25 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp0_ = upgrades_instance;
#line 25 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_vala_assert (_tmp0_ == NULL, "instance == null");
#line 26 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp1_ = upgrades_new ();
#line 26 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_upgrades_unref0 (upgrades_instance);
#line 26 "/home/jens/Source/shotwell/src/Upgrades.vala"
	upgrades_instance = _tmp1_;
#line 645 "Upgrades.c"
}


static gpointer _upgrades_ref0 (gpointer self) {
#line 30 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return self ? upgrades_ref (self) : NULL;
#line 652 "Upgrades.c"
}


Upgrades* upgrades_get_instance (void) {
	Upgrades* result = NULL;
	Upgrades* _tmp0_ = NULL;
	Upgrades* _tmp1_ = NULL;
#line 30 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp0_ = upgrades_instance;
#line 30 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp1_ = _upgrades_ref0 (_tmp0_);
#line 30 "/home/jens/Source/shotwell/src/Upgrades.vala"
	result = _tmp1_;
#line 30 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return result;
#line 668 "Upgrades.c"
}


guint64 upgrades_get_step_count (Upgrades* self) {
	guint64 result = 0ULL;
	guint64 _tmp0_ = 0ULL;
#line 34 "/home/jens/Source/shotwell/src/Upgrades.vala"
	g_return_val_if_fail (IS_UPGRADES (self), 0ULL);
#line 35 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp0_ = self->priv->total_steps;
#line 35 "/home/jens/Source/shotwell/src/Upgrades.vala"
	result = _tmp0_;
#line 35 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return result;
#line 683 "Upgrades.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return self ? g_object_ref (self) : NULL;
#line 690 "Upgrades.c"
}


void upgrades_execute (Upgrades* self, ProgressMonitor monitor, void* monitor_target) {
#line 39 "/home/jens/Source/shotwell/src/Upgrades.vala"
	g_return_if_fail (IS_UPGRADES (self));
#line 697 "Upgrades.c"
	{
		GeeLinkedList* _task_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _task_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _task_index = 0;
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp0_ = self->priv->task_list;
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_task_list = _tmp1_;
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp2_ = _task_list;
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp4_ = _tmp3_;
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_task_size = _tmp4_;
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_task_index = -1;
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
		while (TRUE) {
#line 725 "Upgrades.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			UpgradeTask* task = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			UpgradeTask* _tmp11_ = NULL;
			ProgressMonitor _tmp12_ = NULL;
			void* _tmp12__target = NULL;
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp5_ = _task_index;
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_task_index = _tmp5_ + 1;
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp6_ = _task_index;
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp7_ = _task_size;
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
				break;
#line 748 "Upgrades.c"
			}
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp8_ = _task_list;
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp9_ = _task_index;
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp10_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp9_);
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
			task = (UpgradeTask*) _tmp10_;
#line 41 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp11_ = task;
#line 41 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp12_ = monitor;
#line 41 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp12__target = monitor_target;
#line 41 "/home/jens/Source/shotwell/src/Upgrades.vala"
			upgrade_task_execute (_tmp11_, _tmp12_, _tmp12__target);
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_g_object_unref0 (task);
#line 768 "Upgrades.c"
		}
#line 40 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_g_object_unref0 (_task_list);
#line 772 "Upgrades.c"
	}
}


static void upgrades_add (Upgrades* self, UpgradeTask* task) {
	guint64 _tmp0_ = 0ULL;
	UpgradeTask* _tmp1_ = NULL;
	guint64 _tmp2_ = 0ULL;
	GeeLinkedList* _tmp3_ = NULL;
	UpgradeTask* _tmp4_ = NULL;
#line 44 "/home/jens/Source/shotwell/src/Upgrades.vala"
	g_return_if_fail (IS_UPGRADES (self));
#line 44 "/home/jens/Source/shotwell/src/Upgrades.vala"
	g_return_if_fail (IS_UPGRADE_TASK (task));
#line 45 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp0_ = self->priv->total_steps;
#line 45 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp1_ = task;
#line 45 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp2_ = upgrade_task_get_step_count (_tmp1_);
#line 45 "/home/jens/Source/shotwell/src/Upgrades.vala"
	self->priv->total_steps = _tmp0_ + _tmp2_;
#line 46 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp3_ = self->priv->task_list;
#line 46 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp4_ = task;
#line 46 "/home/jens/Source/shotwell/src/Upgrades.vala"
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp4_);
#line 801 "Upgrades.c"
}


static void value_upgrades_init (GValue* value) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	value->data[0].v_pointer = NULL;
#line 808 "Upgrades.c"
}


static void value_upgrades_free_value (GValue* value) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	if (value->data[0].v_pointer) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		upgrades_unref (value->data[0].v_pointer);
#line 817 "Upgrades.c"
	}
}


static void value_upgrades_copy_value (const GValue* src_value, GValue* dest_value) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	if (src_value->data[0].v_pointer) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		dest_value->data[0].v_pointer = upgrades_ref (src_value->data[0].v_pointer);
#line 827 "Upgrades.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		dest_value->data[0].v_pointer = NULL;
#line 831 "Upgrades.c"
	}
}


static gpointer value_upgrades_peek_pointer (const GValue* value) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return value->data[0].v_pointer;
#line 839 "Upgrades.c"
}


static gchar* value_upgrades_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	if (collect_values[0].v_pointer) {
#line 846 "Upgrades.c"
		Upgrades* object;
		object = collect_values[0].v_pointer;
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		if (object->parent_instance.g_class == NULL) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 853 "Upgrades.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 857 "Upgrades.c"
		}
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		value->data[0].v_pointer = upgrades_ref (object);
#line 861 "Upgrades.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		value->data[0].v_pointer = NULL;
#line 865 "Upgrades.c"
	}
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return NULL;
#line 869 "Upgrades.c"
}


static gchar* value_upgrades_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Upgrades** object_p;
	object_p = collect_values[0].v_pointer;
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	if (!object_p) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 880 "Upgrades.c"
	}
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	if (!value->data[0].v_pointer) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		*object_p = NULL;
#line 886 "Upgrades.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		*object_p = value->data[0].v_pointer;
#line 890 "Upgrades.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		*object_p = upgrades_ref (value->data[0].v_pointer);
#line 894 "Upgrades.c"
	}
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return NULL;
#line 898 "Upgrades.c"
}


GParamSpec* param_spec_upgrades (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecUpgrades* spec;
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_UPGRADES), NULL);
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return G_PARAM_SPEC (spec);
#line 912 "Upgrades.c"
}


gpointer value_get_upgrades (const GValue* value) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UPGRADES), NULL);
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return value->data[0].v_pointer;
#line 921 "Upgrades.c"
}


void value_set_upgrades (GValue* value, gpointer v_object) {
	Upgrades* old;
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UPGRADES));
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	old = value->data[0].v_pointer;
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	if (v_object) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UPGRADES));
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		value->data[0].v_pointer = v_object;
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		upgrades_ref (value->data[0].v_pointer);
#line 941 "Upgrades.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		value->data[0].v_pointer = NULL;
#line 945 "Upgrades.c"
	}
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	if (old) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		upgrades_unref (old);
#line 951 "Upgrades.c"
	}
}


void value_take_upgrades (GValue* value, gpointer v_object) {
	Upgrades* old;
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_UPGRADES));
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	old = value->data[0].v_pointer;
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	if (v_object) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_UPGRADES));
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		value->data[0].v_pointer = v_object;
#line 970 "Upgrades.c"
	} else {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		value->data[0].v_pointer = NULL;
#line 974 "Upgrades.c"
	}
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	if (old) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		upgrades_unref (old);
#line 980 "Upgrades.c"
	}
}


static void upgrades_class_init (UpgradesClass * klass) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	upgrades_parent_class = g_type_class_peek_parent (klass);
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	((UpgradesClass *) klass)->finalize = upgrades_finalize;
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	g_type_class_add_private (klass, sizeof (UpgradesPrivate));
#line 992 "Upgrades.c"
}


static void upgrades_instance_init (Upgrades * self) {
	GeeLinkedList* _tmp0_ = NULL;
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	self->priv = UPGRADES_GET_PRIVATE (self);
#line 12 "/home/jens/Source/shotwell/src/Upgrades.vala"
	self->priv->total_steps = (guint64) 0;
#line 13 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp0_ = gee_linked_list_new (TYPE_UPGRADE_TASK, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 13 "/home/jens/Source/shotwell/src/Upgrades.vala"
	self->priv->task_list = _tmp0_;
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	self->ref_count = 1;
#line 1008 "Upgrades.c"
}


static void upgrades_finalize (Upgrades* obj) {
	Upgrades * self;
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UPGRADES, Upgrades);
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	g_signal_handlers_destroy (self);
#line 13 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_g_object_unref0 (self->priv->task_list);
#line 1020 "Upgrades.c"
}


GType upgrades_get_type (void) {
	static volatile gsize upgrades_type_id__volatile = 0;
	if (g_once_init_enter (&upgrades_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_upgrades_init, value_upgrades_free_value, value_upgrades_copy_value, value_upgrades_peek_pointer, "p", value_upgrades_collect_value, "p", value_upgrades_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (UpgradesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) upgrades_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Upgrades), 0, (GInstanceInitFunc) upgrades_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType upgrades_type_id;
		upgrades_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Upgrades", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&upgrades_type_id__volatile, upgrades_type_id);
	}
	return upgrades_type_id__volatile;
}


gpointer upgrades_ref (gpointer instance) {
	Upgrades* self;
	self = instance;
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	g_atomic_int_inc (&self->ref_count);
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return instance;
#line 1045 "Upgrades.c"
}


void upgrades_unref (gpointer instance) {
	Upgrades* self;
	self = instance;
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		UPGRADES_GET_CLASS (self)->finalize (self);
#line 10 "/home/jens/Source/shotwell/src/Upgrades.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1058 "Upgrades.c"
	}
}


guint64 upgrade_task_get_step_count (UpgradeTask* self) {
#line 55 "/home/jens/Source/shotwell/src/Upgrades.vala"
	g_return_val_if_fail (IS_UPGRADE_TASK (self), 0ULL);
#line 55 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return UPGRADE_TASK_GET_INTERFACE (self)->get_step_count (self);
#line 1068 "Upgrades.c"
}


void upgrade_task_execute (UpgradeTask* self, ProgressMonitor monitor, void* monitor_target) {
#line 60 "/home/jens/Source/shotwell/src/Upgrades.vala"
	g_return_if_fail (IS_UPGRADE_TASK (self));
#line 60 "/home/jens/Source/shotwell/src/Upgrades.vala"
	UPGRADE_TASK_GET_INTERFACE (self)->execute (self, monitor, monitor_target);
#line 1077 "Upgrades.c"
}


static void upgrade_task_base_init (UpgradeTaskIface * iface) {
#line 53 "/home/jens/Source/shotwell/src/Upgrades.vala"
	static gboolean initialized = FALSE;
#line 53 "/home/jens/Source/shotwell/src/Upgrades.vala"
	if (!initialized) {
#line 53 "/home/jens/Source/shotwell/src/Upgrades.vala"
		initialized = TRUE;
#line 1088 "Upgrades.c"
	}
}


GType upgrade_task_get_type (void) {
	static volatile gsize upgrade_task_type_id__volatile = 0;
	if (g_once_init_enter (&upgrade_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UpgradeTaskIface), (GBaseInitFunc) upgrade_task_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType upgrade_task_type_id;
		upgrade_task_type_id = g_type_register_static (G_TYPE_INTERFACE, "UpgradeTask", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (upgrade_task_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&upgrade_task_type_id__volatile, upgrade_task_type_id);
	}
	return upgrade_task_type_id__volatile;
}


static guint64 mimics_removal_task_real_get_step_count (UpgradeTask* base) {
	MimicsRemovalTask * self;
	guint64 result = 0ULL;
	guint64 _tmp5_ = 0ULL;
	GError * _inner_error_ = NULL;
#line 71 "/home/jens/Source/shotwell/src/Upgrades.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MIMICS_REMOVAL_TASK, MimicsRemovalTask);
#line 1113 "Upgrades.c"
	{
		guint64 _tmp0_ = 0ULL;
		GFile* _tmp1_ = NULL;
		guint64 _tmp2_ = 0ULL;
#line 73 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp1_ = self->priv->mimic_dir;
#line 73 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp2_ = count_files_in_directory (_tmp1_, &_inner_error_);
#line 73 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp0_ = _tmp2_;
#line 73 "/home/jens/Source/shotwell/src/Upgrades.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1126 "Upgrades.c"
			goto __catch591_g_error;
		}
#line 73 "/home/jens/Source/shotwell/src/Upgrades.vala"
		self->priv->num_mimics = _tmp0_;
#line 1131 "Upgrades.c"
	}
	goto __finally591;
	__catch591_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 72 "/home/jens/Source/shotwell/src/Upgrades.vala"
		e = _inner_error_;
#line 72 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_inner_error_ = NULL;
#line 75 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp3_ = e;
#line 75 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp4_ = _tmp3_->message;
#line 75 "/home/jens/Source/shotwell/src/Upgrades.vala"
		g_debug ("Upgrades.vala:75: Error on deleting mimics: %s", _tmp4_);
#line 72 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_g_error_free0 (e);
#line 1151 "Upgrades.c"
	}
	__finally591:
#line 72 "/home/jens/Source/shotwell/src/Upgrades.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 72 "/home/jens/Source/shotwell/src/Upgrades.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 72 "/home/jens/Source/shotwell/src/Upgrades.vala"
		g_clear_error (&_inner_error_);
#line 72 "/home/jens/Source/shotwell/src/Upgrades.vala"
		return 0ULL;
#line 1162 "Upgrades.c"
	}
#line 77 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp5_ = self->priv->num_mimics;
#line 77 "/home/jens/Source/shotwell/src/Upgrades.vala"
	result = _tmp5_;
#line 77 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return result;
#line 1170 "Upgrades.c"
}


static void mimics_removal_task_real_execute (UpgradeTask* base, ProgressMonitor monitor, void* monitor_target) {
	MimicsRemovalTask * self;
	GError * _inner_error_ = NULL;
#line 80 "/home/jens/Source/shotwell/src/Upgrades.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_MIMICS_REMOVAL_TASK, MimicsRemovalTask);
#line 1179 "Upgrades.c"
	{
		GFile* _tmp0_ = NULL;
		ProgressMonitor _tmp1_ = NULL;
		void* _tmp1__target = NULL;
		guint64 _tmp2_ = 0ULL;
		GFile* _tmp3_ = NULL;
#line 82 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp0_ = self->priv->mimic_dir;
#line 82 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp1_ = monitor;
#line 82 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp1__target = monitor_target;
#line 82 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp2_ = self->priv->num_mimics;
#line 82 "/home/jens/Source/shotwell/src/Upgrades.vala"
		delete_all_files (_tmp0_, NULL, _tmp1_, _tmp1__target, _tmp2_, NULL, &_inner_error_);
#line 82 "/home/jens/Source/shotwell/src/Upgrades.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1198 "Upgrades.c"
			goto __catch592_g_error;
		}
#line 83 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp3_ = self->priv->mimic_dir;
#line 83 "/home/jens/Source/shotwell/src/Upgrades.vala"
		g_file_delete (_tmp3_, NULL, &_inner_error_);
#line 83 "/home/jens/Source/shotwell/src/Upgrades.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1207 "Upgrades.c"
			goto __catch592_g_error;
		}
	}
	goto __finally592;
	__catch592_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 81 "/home/jens/Source/shotwell/src/Upgrades.vala"
		e = _inner_error_;
#line 81 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_inner_error_ = NULL;
#line 85 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp4_ = e;
#line 85 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp5_ = _tmp4_->message;
#line 85 "/home/jens/Source/shotwell/src/Upgrades.vala"
		g_debug ("Upgrades.vala:85: Could not delete mimics: %s", _tmp5_);
#line 81 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_g_error_free0 (e);
#line 1229 "Upgrades.c"
	}
	__finally592:
#line 81 "/home/jens/Source/shotwell/src/Upgrades.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 81 "/home/jens/Source/shotwell/src/Upgrades.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 81 "/home/jens/Source/shotwell/src/Upgrades.vala"
		g_clear_error (&_inner_error_);
#line 81 "/home/jens/Source/shotwell/src/Upgrades.vala"
		return;
#line 1240 "Upgrades.c"
	}
}


MimicsRemovalTask* mimics_removal_task_construct (GType object_type) {
	MimicsRemovalTask * self = NULL;
#line 66 "/home/jens/Source/shotwell/src/Upgrades.vala"
	self = (MimicsRemovalTask*) g_object_new (object_type, NULL);
#line 66 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return self;
#line 1251 "Upgrades.c"
}


MimicsRemovalTask* mimics_removal_task_new (void) {
#line 66 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return mimics_removal_task_construct (TYPE_MIMICS_REMOVAL_TASK);
#line 1258 "Upgrades.c"
}


static void mimics_removal_task_class_init (MimicsRemovalTaskClass * klass) {
#line 66 "/home/jens/Source/shotwell/src/Upgrades.vala"
	mimics_removal_task_parent_class = g_type_class_peek_parent (klass);
#line 66 "/home/jens/Source/shotwell/src/Upgrades.vala"
	g_type_class_add_private (klass, sizeof (MimicsRemovalTaskPrivate));
#line 66 "/home/jens/Source/shotwell/src/Upgrades.vala"
	G_OBJECT_CLASS (klass)->finalize = mimics_removal_task_finalize;
#line 1269 "Upgrades.c"
}


static void mimics_removal_task_upgrade_task_interface_init (UpgradeTaskIface * iface) {
#line 66 "/home/jens/Source/shotwell/src/Upgrades.vala"
	mimics_removal_task_upgrade_task_parent_iface = g_type_interface_peek_parent (iface);
#line 66 "/home/jens/Source/shotwell/src/Upgrades.vala"
	iface->get_step_count = (guint64 (*)(UpgradeTask*)) mimics_removal_task_real_get_step_count;
#line 66 "/home/jens/Source/shotwell/src/Upgrades.vala"
	iface->execute = (void (*)(UpgradeTask*, ProgressMonitor, void*)) mimics_removal_task_real_execute;
#line 1280 "Upgrades.c"
}


static void mimics_removal_task_instance_init (MimicsRemovalTask * self) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
#line 66 "/home/jens/Source/shotwell/src/Upgrades.vala"
	self->priv = MIMICS_REMOVAL_TASK_GET_PRIVATE (self);
#line 68 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp0_ = app_dirs_get_data_dir ();
#line 68 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp1_ = _tmp0_;
#line 68 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_tmp2_ = g_file_get_child (_tmp1_, "mimics");
#line 68 "/home/jens/Source/shotwell/src/Upgrades.vala"
	self->priv->mimic_dir = _tmp2_;
#line 68 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_g_object_unref0 (_tmp1_);
#line 69 "/home/jens/Source/shotwell/src/Upgrades.vala"
	self->priv->num_mimics = (guint64) 0;
#line 1302 "Upgrades.c"
}


static void mimics_removal_task_finalize (GObject* obj) {
	MimicsRemovalTask * self;
#line 66 "/home/jens/Source/shotwell/src/Upgrades.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MIMICS_REMOVAL_TASK, MimicsRemovalTask);
#line 68 "/home/jens/Source/shotwell/src/Upgrades.vala"
	_g_object_unref0 (self->priv->mimic_dir);
#line 66 "/home/jens/Source/shotwell/src/Upgrades.vala"
	G_OBJECT_CLASS (mimics_removal_task_parent_class)->finalize (obj);
#line 1314 "Upgrades.c"
}


GType mimics_removal_task_get_type (void) {
	static volatile gsize mimics_removal_task_type_id__volatile = 0;
	if (g_once_init_enter (&mimics_removal_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MimicsRemovalTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mimics_removal_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MimicsRemovalTask), 0, (GInstanceInitFunc) mimics_removal_task_instance_init, NULL };
		static const GInterfaceInfo upgrade_task_info = { (GInterfaceInitFunc) mimics_removal_task_upgrade_task_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType mimics_removal_task_type_id;
		mimics_removal_task_type_id = g_type_register_static (G_TYPE_OBJECT, "MimicsRemovalTask", &g_define_type_info, 0);
		g_type_add_interface_static (mimics_removal_task_type_id, TYPE_UPGRADE_TASK, &upgrade_task_info);
		g_once_init_leave (&mimics_removal_task_type_id__volatile, mimics_removal_task_type_id);
	}
	return mimics_removal_task_type_id__volatile;
}


static guint64 fixup_raw_thumbnails_task_real_get_step_count (UpgradeTask* base) {
	FixupRawThumbnailsTask * self;
	guint64 result = 0ULL;
	gint num_raw_files = 0;
#line 94 "/home/jens/Source/shotwell/src/Upgrades.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FIXUP_RAW_THUMBNAILS_TASK, FixupRawThumbnailsTask);
#line 95 "/home/jens/Source/shotwell/src/Upgrades.vala"
	num_raw_files = 0;
#line 1340 "Upgrades.c"
	{
		GeeArrayList* _phr_list = NULL;
		PhotoTable* _tmp0_ = NULL;
		PhotoTable* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		GeeArrayList* _tmp3_ = NULL;
		gint _phr_size = 0;
		GeeArrayList* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _phr_index = 0;
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp0_ = photo_table_get_instance ();
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp1_ = _tmp0_;
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp2_ = photo_table_get_all (_tmp1_);
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp3_ = _tmp2_;
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_database_table_unref0 (_tmp1_);
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_phr_list = _tmp3_;
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp4_ = _phr_list;
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp5_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp6_ = _tmp5_;
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_phr_size = _tmp6_;
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_phr_index = -1;
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
		while (TRUE) {
#line 1376 "Upgrades.c"
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			PhotoRow* phr = NULL;
			GeeArrayList* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gpointer _tmp12_ = NULL;
			PhotoRow* _tmp13_ = NULL;
			BackingPhotoRow* _tmp14_ = NULL;
			PhotoFileFormat _tmp15_ = 0;
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp7_ = _phr_index;
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_phr_index = _tmp7_ + 1;
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp8_ = _phr_index;
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp9_ = _phr_size;
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
				break;
#line 1399 "Upgrades.c"
			}
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp10_ = _phr_list;
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp11_ = _phr_index;
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp12_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp11_);
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
			phr = (PhotoRow*) _tmp12_;
#line 98 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp13_ = phr;
#line 98 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp14_ = _tmp13_->master;
#line 98 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp15_ = _tmp14_->file_format;
#line 98 "/home/jens/Source/shotwell/src/Upgrades.vala"
			if (_tmp15_ == PHOTO_FILE_FORMAT_RAW) {
#line 1417 "Upgrades.c"
				gint _tmp16_ = 0;
#line 99 "/home/jens/Source/shotwell/src/Upgrades.vala"
				_tmp16_ = num_raw_files;
#line 99 "/home/jens/Source/shotwell/src/Upgrades.vala"
				num_raw_files = _tmp16_ + 1;
#line 1423 "Upgrades.c"
			}
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_photo_row_unref0 (phr);
#line 1427 "Upgrades.c"
		}
#line 97 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_g_object_unref0 (_phr_list);
#line 1431 "Upgrades.c"
	}
#line 101 "/home/jens/Source/shotwell/src/Upgrades.vala"
	result = (guint64) num_raw_files;
#line 101 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return result;
#line 1437 "Upgrades.c"
}


static void fixup_raw_thumbnails_task_real_execute (UpgradeTask* base, ProgressMonitor monitor, void* monitor_target) {
	FixupRawThumbnailsTask * self;
#line 104 "/home/jens/Source/shotwell/src/Upgrades.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FIXUP_RAW_THUMBNAILS_TASK, FixupRawThumbnailsTask);
#line 105 "/home/jens/Source/shotwell/src/Upgrades.vala"
	g_debug ("Upgrades.vala:105: Executing thumbnail deletion and fixup");
#line 1447 "Upgrades.c"
	{
		GeeArrayList* _phr_list = NULL;
		PhotoTable* _tmp0_ = NULL;
		PhotoTable* _tmp1_ = NULL;
		GeeArrayList* _tmp2_ = NULL;
		GeeArrayList* _tmp3_ = NULL;
		gint _phr_size = 0;
		GeeArrayList* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _phr_index = 0;
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp0_ = photo_table_get_instance ();
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp1_ = _tmp0_;
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp2_ = photo_table_get_all (_tmp1_);
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp3_ = _tmp2_;
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_database_table_unref0 (_tmp1_);
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_phr_list = _tmp3_;
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp4_ = _phr_list;
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp5_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_COLLECTION, GeeCollection));
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_tmp6_ = _tmp5_;
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_phr_size = _tmp6_;
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_phr_index = -1;
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
		while (TRUE) {
#line 1483 "Upgrades.c"
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			PhotoRow* phr = NULL;
			GeeArrayList* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			gpointer _tmp12_ = NULL;
			gboolean _tmp13_ = FALSE;
			PhotoRow* _tmp14_ = NULL;
			BackingPhotoRow* _tmp15_ = NULL;
			PhotoFileFormat _tmp16_ = 0;
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp7_ = _phr_index;
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_phr_index = _tmp7_ + 1;
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp8_ = _phr_index;
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp9_ = _phr_size;
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
			if (!(_tmp8_ < _tmp9_)) {
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
				break;
#line 1507 "Upgrades.c"
			}
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp10_ = _phr_list;
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp11_ = _phr_index;
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp12_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp11_);
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
			phr = (PhotoRow*) _tmp12_;
#line 108 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp14_ = phr;
#line 108 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp15_ = _tmp14_->master;
#line 108 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_tmp16_ = _tmp15_->file_format;
#line 108 "/home/jens/Source/shotwell/src/Upgrades.vala"
			if (_tmp16_ == PHOTO_FILE_FORMAT_RAW) {
#line 1525 "Upgrades.c"
				PhotoRow* _tmp17_ = NULL;
				RawDeveloper _tmp18_ = 0;
#line 109 "/home/jens/Source/shotwell/src/Upgrades.vala"
				_tmp17_ = phr;
#line 109 "/home/jens/Source/shotwell/src/Upgrades.vala"
				_tmp18_ = _tmp17_->developer;
#line 109 "/home/jens/Source/shotwell/src/Upgrades.vala"
				_tmp13_ = _tmp18_ == RAW_DEVELOPER_CAMERA;
#line 1534 "Upgrades.c"
			} else {
#line 108 "/home/jens/Source/shotwell/src/Upgrades.vala"
				_tmp13_ = FALSE;
#line 1538 "Upgrades.c"
			}
#line 108 "/home/jens/Source/shotwell/src/Upgrades.vala"
			if (_tmp13_) {
#line 1542 "Upgrades.c"
				LibraryPhotoSourceCollection* _tmp19_ = NULL;
				PhotoRow* _tmp20_ = NULL;
				PhotoID _tmp21_ = {0};
				LibraryPhoto* _tmp22_ = NULL;
				LibraryPhoto* _tmp23_ = NULL;
#line 110 "/home/jens/Source/shotwell/src/Upgrades.vala"
				_tmp19_ = library_photo_global;
#line 110 "/home/jens/Source/shotwell/src/Upgrades.vala"
				_tmp20_ = phr;
#line 110 "/home/jens/Source/shotwell/src/Upgrades.vala"
				_tmp21_ = _tmp20_->photo_id;
#line 110 "/home/jens/Source/shotwell/src/Upgrades.vala"
				_tmp22_ = library_photo_source_collection_fetch (_tmp19_, &_tmp21_);
#line 110 "/home/jens/Source/shotwell/src/Upgrades.vala"
				_tmp23_ = _tmp22_;
#line 110 "/home/jens/Source/shotwell/src/Upgrades.vala"
				thumbnail_cache_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
#line 110 "/home/jens/Source/shotwell/src/Upgrades.vala"
				_g_object_unref0 (_tmp23_);
#line 1562 "Upgrades.c"
			}
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
			_photo_row_unref0 (phr);
#line 1566 "Upgrades.c"
		}
#line 107 "/home/jens/Source/shotwell/src/Upgrades.vala"
		_g_object_unref0 (_phr_list);
#line 1570 "Upgrades.c"
	}
}


FixupRawThumbnailsTask* fixup_raw_thumbnails_task_construct (GType object_type) {
	FixupRawThumbnailsTask * self = NULL;
#line 93 "/home/jens/Source/shotwell/src/Upgrades.vala"
	self = (FixupRawThumbnailsTask*) g_object_new (object_type, NULL);
#line 93 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return self;
#line 1581 "Upgrades.c"
}


FixupRawThumbnailsTask* fixup_raw_thumbnails_task_new (void) {
#line 93 "/home/jens/Source/shotwell/src/Upgrades.vala"
	return fixup_raw_thumbnails_task_construct (TYPE_FIXUP_RAW_THUMBNAILS_TASK);
#line 1588 "Upgrades.c"
}


static void fixup_raw_thumbnails_task_class_init (FixupRawThumbnailsTaskClass * klass) {
#line 93 "/home/jens/Source/shotwell/src/Upgrades.vala"
	fixup_raw_thumbnails_task_parent_class = g_type_class_peek_parent (klass);
#line 1595 "Upgrades.c"
}


static void fixup_raw_thumbnails_task_upgrade_task_interface_init (UpgradeTaskIface * iface) {
#line 93 "/home/jens/Source/shotwell/src/Upgrades.vala"
	fixup_raw_thumbnails_task_upgrade_task_parent_iface = g_type_interface_peek_parent (iface);
#line 93 "/home/jens/Source/shotwell/src/Upgrades.vala"
	iface->get_step_count = (guint64 (*)(UpgradeTask*)) fixup_raw_thumbnails_task_real_get_step_count;
#line 93 "/home/jens/Source/shotwell/src/Upgrades.vala"
	iface->execute = (void (*)(UpgradeTask*, ProgressMonitor, void*)) fixup_raw_thumbnails_task_real_execute;
#line 1606 "Upgrades.c"
}


static void fixup_raw_thumbnails_task_instance_init (FixupRawThumbnailsTask * self) {
}


GType fixup_raw_thumbnails_task_get_type (void) {
	static volatile gsize fixup_raw_thumbnails_task_type_id__volatile = 0;
	if (g_once_init_enter (&fixup_raw_thumbnails_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FixupRawThumbnailsTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fixup_raw_thumbnails_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FixupRawThumbnailsTask), 0, (GInstanceInitFunc) fixup_raw_thumbnails_task_instance_init, NULL };
		static const GInterfaceInfo upgrade_task_info = { (GInterfaceInitFunc) fixup_raw_thumbnails_task_upgrade_task_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType fixup_raw_thumbnails_task_type_id;
		fixup_raw_thumbnails_task_type_id = g_type_register_static (G_TYPE_OBJECT, "FixupRawThumbnailsTask", &g_define_type_info, 0);
		g_type_add_interface_static (fixup_raw_thumbnails_task_type_id, TYPE_UPGRADE_TASK, &upgrade_task_info);
		g_once_init_leave (&fixup_raw_thumbnails_task_type_id__volatile, fixup_raw_thumbnails_task_type_id);
	}
	return fixup_raw_thumbnails_task_type_id__volatile;
}



