/* PhotoFileSniffer.c generated by valac 0.34.1, the Vala compiler
 * generated from PhotoFileSniffer.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_DETECTED_PHOTO_INFORMATION (detected_photo_information_get_type ())
#define DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation))
#define DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))
#define IS_DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DETECTED_PHOTO_INFORMATION))
#define IS_DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DETECTED_PHOTO_INFORMATION))
#define DETECTED_PHOTO_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))

typedef struct _DetectedPhotoInformation DetectedPhotoInformation;
typedef struct _DetectedPhotoInformationClass DetectedPhotoInformationClass;
typedef struct _DetectedPhotoInformationPrivate DetectedPhotoInformationPrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecDetectedPhotoInformation ParamSpecDetectedPhotoInformation;

#define TYPE_PHOTO_FILE_SNIFFER (photo_file_sniffer_get_type ())
#define PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer))
#define PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))
#define IS_PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_SNIFFER))
#define IS_PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_SNIFFER))
#define PHOTO_FILE_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))

typedef struct _PhotoFileSniffer PhotoFileSniffer;
typedef struct _PhotoFileSnifferClass PhotoFileSnifferClass;
typedef struct _PhotoFileSnifferPrivate PhotoFileSnifferPrivate;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecPhotoFileSniffer ParamSpecPhotoFileSniffer;

#define TYPE_PHOTO_FILE_INTERROGATOR (photo_file_interrogator_get_type ())
#define PHOTO_FILE_INTERROGATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogator))
#define PHOTO_FILE_INTERROGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogatorClass))
#define IS_PHOTO_FILE_INTERROGATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_INTERROGATOR))
#define IS_PHOTO_FILE_INTERROGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_INTERROGATOR))
#define PHOTO_FILE_INTERROGATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogatorClass))

typedef struct _PhotoFileInterrogator PhotoFileInterrogator;
typedef struct _PhotoFileInterrogatorClass PhotoFileInterrogatorClass;
typedef struct _PhotoFileInterrogatorPrivate PhotoFileInterrogatorPrivate;
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
#define _photo_file_sniffer_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_sniffer_unref (var), NULL)))
typedef struct _ParamSpecPhotoFileInterrogator ParamSpecPhotoFileInterrogator;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _Dimensions {
	gint width;
	gint height;
};

struct _DetectedPhotoInformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DetectedPhotoInformationPrivate * priv;
	PhotoFileFormat file_format;
	PhotoMetadata* metadata;
	gchar* md5;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* format_name;
	Dimensions image_dim;
	GdkColorspace colorspace;
	gint channels;
	gint bits_per_channel;
};

struct _DetectedPhotoInformationClass {
	GTypeClass parent_class;
	void (*finalize) (DetectedPhotoInformation *self);
};

struct _ParamSpecDetectedPhotoInformation {
	GParamSpec parent_instance;
};

typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

struct _PhotoFileSniffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileSnifferPrivate * priv;
	GFile* file;
	PhotoFileSnifferOptions options;
	gboolean calc_md5;
};

struct _PhotoFileSnifferClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileSniffer *self);
	DetectedPhotoInformation* (*sniff) (PhotoFileSniffer* self, gboolean* is_corrupted, GError** error);
};

struct _ParamSpecPhotoFileSniffer {
	GParamSpec parent_instance;
};

struct _PhotoFileInterrogator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileInterrogatorPrivate * priv;
};

struct _PhotoFileInterrogatorClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileInterrogator *self);
};

struct _PhotoFileInterrogatorPrivate {
	GFile* file;
	PhotoFileSnifferOptions options;
	DetectedPhotoInformation* detected;
	gboolean is_photo_corrupted;
};

struct _ParamSpecPhotoFileInterrogator {
	GParamSpec parent_instance;
};


static gpointer detected_photo_information_parent_class = NULL;
static gpointer photo_file_sniffer_parent_class = NULL;
static gpointer photo_file_interrogator_parent_class = NULL;

gpointer detected_photo_information_ref (gpointer instance);
void detected_photo_information_unref (gpointer instance);
GParamSpec* param_spec_detected_photo_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_detected_photo_information (GValue* value, gpointer v_object);
void value_take_detected_photo_information (GValue* value, gpointer v_object);
gpointer value_get_detected_photo_information (const GValue* value);
GType detected_photo_information_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
enum  {
	DETECTED_PHOTO_INFORMATION_DUMMY_PROPERTY
};
void dimensions_init (Dimensions *self, gint width, gint height);
DetectedPhotoInformation* detected_photo_information_new (void);
DetectedPhotoInformation* detected_photo_information_construct (GType object_type);
static void detected_photo_information_finalize (DetectedPhotoInformation* obj);
gpointer photo_file_sniffer_ref (gpointer instance);
void photo_file_sniffer_unref (gpointer instance);
GParamSpec* param_spec_photo_file_sniffer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_sniffer (GValue* value, gpointer v_object);
void value_take_photo_file_sniffer (GValue* value, gpointer v_object);
gpointer value_get_photo_file_sniffer (const GValue* value);
GType photo_file_sniffer_get_type (void) G_GNUC_CONST;
GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST;
enum  {
	PHOTO_FILE_SNIFFER_DUMMY_PROPERTY
};
PhotoFileSniffer* photo_file_sniffer_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options);
DetectedPhotoInformation* photo_file_sniffer_sniff (PhotoFileSniffer* self, gboolean* is_corrupted, GError** error);
static DetectedPhotoInformation* photo_file_sniffer_real_sniff (PhotoFileSniffer* self, gboolean* is_corrupted, GError** error);
static void photo_file_sniffer_finalize (PhotoFileSniffer* obj);
gpointer photo_file_interrogator_ref (gpointer instance);
void photo_file_interrogator_unref (gpointer instance);
GParamSpec* param_spec_photo_file_interrogator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_interrogator (GValue* value, gpointer v_object);
void value_take_photo_file_interrogator (GValue* value, gpointer v_object);
gpointer value_get_photo_file_interrogator (const GValue* value);
GType photo_file_interrogator_get_type (void) G_GNUC_CONST;
#define PHOTO_FILE_INTERROGATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogatorPrivate))
enum  {
	PHOTO_FILE_INTERROGATOR_DUMMY_PROPERTY
};
PhotoFileInterrogator* photo_file_interrogator_new (GFile* file, PhotoFileSnifferOptions options);
PhotoFileInterrogator* photo_file_interrogator_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options);
DetectedPhotoInformation* photo_file_interrogator_get_detected_photo_information (PhotoFileInterrogator* self);
gboolean photo_file_interrogator_get_is_photo_corrupted (PhotoFileInterrogator* self);
void photo_file_interrogator_interrogate (PhotoFileInterrogator* self, GError** error);
PhotoFileFormat* photo_file_format_get_supported (int* result_length1);
PhotoFileSniffer* photo_file_format_create_sniffer (PhotoFileFormat self, GFile* file, PhotoFileSnifferOptions options);
static void photo_file_interrogator_finalize (PhotoFileInterrogator* obj);


DetectedPhotoInformation* detected_photo_information_construct (GType object_type) {
	DetectedPhotoInformation* self = NULL;
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self = (DetectedPhotoInformation*) g_type_create_instance (object_type);
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return self;
#line 250 "PhotoFileSniffer.c"
}


DetectedPhotoInformation* detected_photo_information_new (void) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return detected_photo_information_construct (TYPE_DETECTED_PHOTO_INFORMATION);
#line 257 "PhotoFileSniffer.c"
}


static void value_detected_photo_information_init (GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	value->data[0].v_pointer = NULL;
#line 264 "PhotoFileSniffer.c"
}


static void value_detected_photo_information_free_value (GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		detected_photo_information_unref (value->data[0].v_pointer);
#line 273 "PhotoFileSniffer.c"
	}
}


static void value_detected_photo_information_copy_value (const GValue* src_value, GValue* dest_value) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (src_value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		dest_value->data[0].v_pointer = detected_photo_information_ref (src_value->data[0].v_pointer);
#line 283 "PhotoFileSniffer.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		dest_value->data[0].v_pointer = NULL;
#line 287 "PhotoFileSniffer.c"
	}
}


static gpointer value_detected_photo_information_peek_pointer (const GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return value->data[0].v_pointer;
#line 295 "PhotoFileSniffer.c"
}


static gchar* value_detected_photo_information_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (collect_values[0].v_pointer) {
#line 302 "PhotoFileSniffer.c"
		DetectedPhotoInformation* object;
		object = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		if (object->parent_instance.g_class == NULL) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 309 "PhotoFileSniffer.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 313 "PhotoFileSniffer.c"
		}
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = detected_photo_information_ref (object);
#line 317 "PhotoFileSniffer.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = NULL;
#line 321 "PhotoFileSniffer.c"
	}
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return NULL;
#line 325 "PhotoFileSniffer.c"
}


static gchar* value_detected_photo_information_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DetectedPhotoInformation** object_p;
	object_p = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (!object_p) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 336 "PhotoFileSniffer.c"
	}
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (!value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		*object_p = NULL;
#line 342 "PhotoFileSniffer.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		*object_p = value->data[0].v_pointer;
#line 346 "PhotoFileSniffer.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		*object_p = detected_photo_information_ref (value->data[0].v_pointer);
#line 350 "PhotoFileSniffer.c"
	}
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return NULL;
#line 354 "PhotoFileSniffer.c"
}


GParamSpec* param_spec_detected_photo_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecDetectedPhotoInformation* spec;
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DETECTED_PHOTO_INFORMATION), NULL);
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return G_PARAM_SPEC (spec);
#line 368 "PhotoFileSniffer.c"
}


gpointer value_get_detected_photo_information (const GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DETECTED_PHOTO_INFORMATION), NULL);
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return value->data[0].v_pointer;
#line 377 "PhotoFileSniffer.c"
}


void value_set_detected_photo_information (GValue* value, gpointer v_object) {
	DetectedPhotoInformation* old;
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DETECTED_PHOTO_INFORMATION));
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DETECTED_PHOTO_INFORMATION));
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = v_object;
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		detected_photo_information_ref (value->data[0].v_pointer);
#line 397 "PhotoFileSniffer.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = NULL;
#line 401 "PhotoFileSniffer.c"
	}
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		detected_photo_information_unref (old);
#line 407 "PhotoFileSniffer.c"
	}
}


void value_take_detected_photo_information (GValue* value, gpointer v_object) {
	DetectedPhotoInformation* old;
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DETECTED_PHOTO_INFORMATION));
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DETECTED_PHOTO_INFORMATION));
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = v_object;
#line 426 "PhotoFileSniffer.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = NULL;
#line 430 "PhotoFileSniffer.c"
	}
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		detected_photo_information_unref (old);
#line 436 "PhotoFileSniffer.c"
	}
}


static void detected_photo_information_class_init (DetectedPhotoInformationClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	detected_photo_information_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	((DetectedPhotoInformationClass *) klass)->finalize = detected_photo_information_finalize;
#line 446 "PhotoFileSniffer.c"
}


static void detected_photo_information_instance_init (DetectedPhotoInformation * self) {
#line 8 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->file_format = PHOTO_FILE_FORMAT_UNKNOWN;
#line 9 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->metadata = NULL;
#line 10 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->md5 = NULL;
#line 11 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->exif_md5 = NULL;
#line 12 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->thumbnail_md5 = NULL;
#line 13 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->format_name = NULL;
#line 14 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	dimensions_init (&self->image_dim, 0, 0);
#line 15 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->colorspace = GDK_COLORSPACE_RGB;
#line 16 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->channels = 0;
#line 17 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->bits_per_channel = 0;
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->ref_count = 1;
#line 473 "PhotoFileSniffer.c"
}


static void detected_photo_information_finalize (DetectedPhotoInformation* obj) {
	DetectedPhotoInformation * self;
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation);
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_signal_handlers_destroy (self);
#line 9 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_media_metadata_unref0 (self->metadata);
#line 10 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_g_free0 (self->md5);
#line 11 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_g_free0 (self->exif_md5);
#line 12 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_g_free0 (self->thumbnail_md5);
#line 13 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_g_free0 (self->format_name);
#line 493 "PhotoFileSniffer.c"
}


GType detected_photo_information_get_type (void) {
	static volatile gsize detected_photo_information_type_id__volatile = 0;
	if (g_once_init_enter (&detected_photo_information_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_detected_photo_information_init, value_detected_photo_information_free_value, value_detected_photo_information_copy_value, value_detected_photo_information_peek_pointer, "p", value_detected_photo_information_collect_value, "p", value_detected_photo_information_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DetectedPhotoInformationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) detected_photo_information_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DetectedPhotoInformation), 0, (GInstanceInitFunc) detected_photo_information_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType detected_photo_information_type_id;
		detected_photo_information_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DetectedPhotoInformation", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&detected_photo_information_type_id__volatile, detected_photo_information_type_id);
	}
	return detected_photo_information_type_id__volatile;
}


gpointer detected_photo_information_ref (gpointer instance) {
	DetectedPhotoInformation* self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_atomic_int_inc (&self->ref_count);
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return instance;
#line 518 "PhotoFileSniffer.c"
}


void detected_photo_information_unref (gpointer instance) {
	DetectedPhotoInformation* self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		DETECTED_PHOTO_INFORMATION_GET_CLASS (self)->finalize (self);
#line 7 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 531 "PhotoFileSniffer.c"
	}
}


GType photo_file_sniffer_options_get_type (void) {
	static volatile gsize photo_file_sniffer_options_type_id__volatile = 0;
	if (g_once_init_enter (&photo_file_sniffer_options_type_id__volatile)) {
		static const GEnumValue values[] = {{PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL, "PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL", "get-all"}, {PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5, "PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5", "no-md5"}, {0, NULL, NULL}};
		GType photo_file_sniffer_options_type_id;
		photo_file_sniffer_options_type_id = g_enum_register_static ("PhotoFileSnifferOptions", values);
		g_once_init_leave (&photo_file_sniffer_options_type_id__volatile, photo_file_sniffer_options_type_id);
	}
	return photo_file_sniffer_options_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 43 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return self ? g_object_ref (self) : NULL;
#line 551 "PhotoFileSniffer.c"
}


PhotoFileSniffer* photo_file_sniffer_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options) {
	PhotoFileSniffer* self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	PhotoFileSnifferOptions _tmp2_ = 0;
	PhotoFileSnifferOptions _tmp3_ = 0;
#line 42 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 42 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self = (PhotoFileSniffer*) g_type_create_instance (object_type);
#line 43 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_tmp0_ = file;
#line 43 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 43 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_g_object_unref0 (self->file);
#line 43 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->file = _tmp1_;
#line 44 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_tmp2_ = options;
#line 44 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->options = _tmp2_;
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_tmp3_ = options;
#line 46 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->calc_md5 = (_tmp3_ & PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5) == 0;
#line 42 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return self;
#line 583 "PhotoFileSniffer.c"
}


static DetectedPhotoInformation* photo_file_sniffer_real_sniff (PhotoFileSniffer* self, gboolean* is_corrupted, GError** error) {
#line 49 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_critical ("Type `%s' does not implement abstract method `photo_file_sniffer_sniff'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
#line 49 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return NULL;
#line 592 "PhotoFileSniffer.c"
}


DetectedPhotoInformation* photo_file_sniffer_sniff (PhotoFileSniffer* self, gboolean* is_corrupted, GError** error) {
#line 49 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_SNIFFER (self), NULL);
#line 49 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return PHOTO_FILE_SNIFFER_GET_CLASS (self)->sniff (self, is_corrupted, error);
#line 601 "PhotoFileSniffer.c"
}


static void value_photo_file_sniffer_init (GValue* value) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	value->data[0].v_pointer = NULL;
#line 608 "PhotoFileSniffer.c"
}


static void value_photo_file_sniffer_free_value (GValue* value) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (value->data[0].v_pointer) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		photo_file_sniffer_unref (value->data[0].v_pointer);
#line 617 "PhotoFileSniffer.c"
	}
}


static void value_photo_file_sniffer_copy_value (const GValue* src_value, GValue* dest_value) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (src_value->data[0].v_pointer) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		dest_value->data[0].v_pointer = photo_file_sniffer_ref (src_value->data[0].v_pointer);
#line 627 "PhotoFileSniffer.c"
	} else {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		dest_value->data[0].v_pointer = NULL;
#line 631 "PhotoFileSniffer.c"
	}
}


static gpointer value_photo_file_sniffer_peek_pointer (const GValue* value) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return value->data[0].v_pointer;
#line 639 "PhotoFileSniffer.c"
}


static gchar* value_photo_file_sniffer_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (collect_values[0].v_pointer) {
#line 646 "PhotoFileSniffer.c"
		PhotoFileSniffer* object;
		object = collect_values[0].v_pointer;
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		if (object->parent_instance.g_class == NULL) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 653 "PhotoFileSniffer.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 657 "PhotoFileSniffer.c"
		}
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = photo_file_sniffer_ref (object);
#line 661 "PhotoFileSniffer.c"
	} else {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = NULL;
#line 665 "PhotoFileSniffer.c"
	}
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return NULL;
#line 669 "PhotoFileSniffer.c"
}


static gchar* value_photo_file_sniffer_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PhotoFileSniffer** object_p;
	object_p = collect_values[0].v_pointer;
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (!object_p) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 680 "PhotoFileSniffer.c"
	}
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (!value->data[0].v_pointer) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		*object_p = NULL;
#line 686 "PhotoFileSniffer.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		*object_p = value->data[0].v_pointer;
#line 690 "PhotoFileSniffer.c"
	} else {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		*object_p = photo_file_sniffer_ref (value->data[0].v_pointer);
#line 694 "PhotoFileSniffer.c"
	}
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return NULL;
#line 698 "PhotoFileSniffer.c"
}


GParamSpec* param_spec_photo_file_sniffer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPhotoFileSniffer* spec;
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_FILE_SNIFFER), NULL);
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return G_PARAM_SPEC (spec);
#line 712 "PhotoFileSniffer.c"
}


gpointer value_get_photo_file_sniffer (const GValue* value) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_SNIFFER), NULL);
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return value->data[0].v_pointer;
#line 721 "PhotoFileSniffer.c"
}


void value_set_photo_file_sniffer (GValue* value, gpointer v_object) {
	PhotoFileSniffer* old;
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_SNIFFER));
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	old = value->data[0].v_pointer;
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (v_object) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_SNIFFER));
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = v_object;
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		photo_file_sniffer_ref (value->data[0].v_pointer);
#line 741 "PhotoFileSniffer.c"
	} else {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = NULL;
#line 745 "PhotoFileSniffer.c"
	}
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (old) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		photo_file_sniffer_unref (old);
#line 751 "PhotoFileSniffer.c"
	}
}


void value_take_photo_file_sniffer (GValue* value, gpointer v_object) {
	PhotoFileSniffer* old;
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_SNIFFER));
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	old = value->data[0].v_pointer;
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (v_object) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_SNIFFER));
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = v_object;
#line 770 "PhotoFileSniffer.c"
	} else {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = NULL;
#line 774 "PhotoFileSniffer.c"
	}
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (old) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		photo_file_sniffer_unref (old);
#line 780 "PhotoFileSniffer.c"
	}
}


static void photo_file_sniffer_class_init (PhotoFileSnifferClass * klass) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	photo_file_sniffer_parent_class = g_type_class_peek_parent (klass);
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	((PhotoFileSnifferClass *) klass)->finalize = photo_file_sniffer_finalize;
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	((PhotoFileSnifferClass *) klass)->sniff = photo_file_sniffer_real_sniff;
#line 792 "PhotoFileSniffer.c"
}


static void photo_file_sniffer_instance_init (PhotoFileSniffer * self) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->ref_count = 1;
#line 799 "PhotoFileSniffer.c"
}


static void photo_file_sniffer_finalize (PhotoFileSniffer* obj) {
	PhotoFileSniffer * self;
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer);
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_signal_handlers_destroy (self);
#line 38 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_g_object_unref0 (self->file);
#line 811 "PhotoFileSniffer.c"
}


GType photo_file_sniffer_get_type (void) {
	static volatile gsize photo_file_sniffer_type_id__volatile = 0;
	if (g_once_init_enter (&photo_file_sniffer_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_photo_file_sniffer_init, value_photo_file_sniffer_free_value, value_photo_file_sniffer_copy_value, value_photo_file_sniffer_peek_pointer, "p", value_photo_file_sniffer_collect_value, "p", value_photo_file_sniffer_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PhotoFileSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileSniffer), 0, (GInstanceInitFunc) photo_file_sniffer_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType photo_file_sniffer_type_id;
		photo_file_sniffer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoFileSniffer", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&photo_file_sniffer_type_id__volatile, photo_file_sniffer_type_id);
	}
	return photo_file_sniffer_type_id__volatile;
}


gpointer photo_file_sniffer_ref (gpointer instance) {
	PhotoFileSniffer* self;
	self = instance;
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_atomic_int_inc (&self->ref_count);
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return instance;
#line 836 "PhotoFileSniffer.c"
}


void photo_file_sniffer_unref (gpointer instance) {
	PhotoFileSniffer* self;
	self = instance;
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		PHOTO_FILE_SNIFFER_GET_CLASS (self)->finalize (self);
#line 32 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 849 "PhotoFileSniffer.c"
	}
}


PhotoFileInterrogator* photo_file_interrogator_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options) {
	PhotoFileInterrogator* self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	PhotoFileSnifferOptions _tmp2_ = 0;
#line 67 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 67 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self = (PhotoFileInterrogator*) g_type_create_instance (object_type);
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_tmp0_ = file;
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_g_object_unref0 (self->priv->file);
#line 69 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->priv->file = _tmp1_;
#line 70 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_tmp2_ = options;
#line 70 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->priv->options = _tmp2_;
#line 67 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return self;
#line 877 "PhotoFileSniffer.c"
}


PhotoFileInterrogator* photo_file_interrogator_new (GFile* file, PhotoFileSnifferOptions options) {
#line 67 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return photo_file_interrogator_construct (TYPE_PHOTO_FILE_INTERROGATOR, file, options);
#line 884 "PhotoFileSniffer.c"
}


static gpointer _detected_photo_information_ref0 (gpointer self) {
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return self ? detected_photo_information_ref (self) : NULL;
#line 891 "PhotoFileSniffer.c"
}


DetectedPhotoInformation* photo_file_interrogator_get_detected_photo_information (PhotoFileInterrogator* self) {
	DetectedPhotoInformation* result = NULL;
	DetectedPhotoInformation* _tmp0_ = NULL;
	DetectedPhotoInformation* _tmp1_ = NULL;
#line 75 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_INTERROGATOR (self), NULL);
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_tmp0_ = self->priv->detected;
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_tmp1_ = _detected_photo_information_ref0 (_tmp0_);
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	result = _tmp1_;
#line 76 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return result;
#line 909 "PhotoFileSniffer.c"
}


gboolean photo_file_interrogator_get_is_photo_corrupted (PhotoFileInterrogator* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 80 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_val_if_fail (IS_PHOTO_FILE_INTERROGATOR (self), FALSE);
#line 81 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_tmp0_ = self->priv->is_photo_corrupted;
#line 81 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	result = _tmp0_;
#line 81 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return result;
#line 924 "PhotoFileSniffer.c"
}


void photo_file_interrogator_interrogate (PhotoFileInterrogator* self, GError** error) {
	gint _tmp0_ = 0;
	PhotoFileFormat* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
#line 84 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_if_fail (IS_PHOTO_FILE_INTERROGATOR (self));
#line 85 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_tmp1_ = photo_file_format_get_supported (&_tmp0_);
#line 936 "PhotoFileSniffer.c"
	{
		PhotoFileFormat* file_format_collection = NULL;
		gint file_format_collection_length1 = 0;
		gint _file_format_collection_size_ = 0;
		gint file_format_it = 0;
#line 85 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		file_format_collection = _tmp1_;
#line 85 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		file_format_collection_length1 = _tmp0_;
#line 85 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		for (file_format_it = 0; file_format_it < _tmp0_; file_format_it = file_format_it + 1) {
#line 948 "PhotoFileSniffer.c"
			PhotoFileFormat file_format = 0;
#line 85 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
			file_format = file_format_collection[file_format_it];
#line 952 "PhotoFileSniffer.c"
			{
				PhotoFileSniffer* sniffer = NULL;
				PhotoFileFormat _tmp2_ = 0;
				GFile* _tmp3_ = NULL;
				PhotoFileSnifferOptions _tmp4_ = 0;
				PhotoFileSniffer* _tmp5_ = NULL;
				gboolean is_corrupted = FALSE;
				DetectedPhotoInformation* _tmp6_ = NULL;
				PhotoFileSniffer* _tmp7_ = NULL;
				gboolean _tmp8_ = FALSE;
				DetectedPhotoInformation* _tmp9_ = NULL;
				DetectedPhotoInformation* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				DetectedPhotoInformation* _tmp12_ = NULL;
#line 86 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				_tmp2_ = file_format;
#line 86 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				_tmp3_ = self->priv->file;
#line 86 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				_tmp4_ = self->priv->options;
#line 86 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				_tmp5_ = photo_file_format_create_sniffer (_tmp2_, _tmp3_, _tmp4_);
#line 86 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				sniffer = _tmp5_;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				_tmp7_ = sniffer;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				_tmp9_ = photo_file_sniffer_sniff (_tmp7_, &_tmp8_, &_inner_error_);
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				is_corrupted = _tmp8_;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				_tmp6_ = _tmp9_;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
					g_propagate_error (error, _inner_error_);
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
					_photo_file_sniffer_unref0 (sniffer);
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
					file_format_collection = (g_free (file_format_collection), NULL);
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
					return;
#line 995 "PhotoFileSniffer.c"
				}
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				_tmp10_ = _tmp6_;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				_tmp6_ = NULL;
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				_detected_photo_information_unref0 (self->priv->detected);
#line 89 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				self->priv->detected = _tmp10_;
#line 90 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				_tmp12_ = self->priv->detected;
#line 90 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				if (_tmp12_ != NULL) {
#line 1009 "PhotoFileSniffer.c"
					gboolean _tmp13_ = FALSE;
#line 90 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
					_tmp13_ = is_corrupted;
#line 90 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
					_tmp11_ = !_tmp13_;
#line 1015 "PhotoFileSniffer.c"
				} else {
#line 90 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
					_tmp11_ = FALSE;
#line 1019 "PhotoFileSniffer.c"
				}
#line 90 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				if (_tmp11_) {
#line 1023 "PhotoFileSniffer.c"
					DetectedPhotoInformation* _tmp14_ = NULL;
					PhotoFileFormat _tmp15_ = 0;
					PhotoFileFormat _tmp16_ = 0;
#line 91 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
					_tmp14_ = self->priv->detected;
#line 91 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
					_tmp15_ = _tmp14_->file_format;
#line 91 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
					_tmp16_ = file_format;
#line 91 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
					_vala_assert (_tmp15_ == _tmp16_, "detected.file_format == file_format");
#line 93 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
					_detected_photo_information_unref0 (_tmp6_);
#line 93 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
					_photo_file_sniffer_unref0 (sniffer);
#line 93 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
					break;
#line 1041 "PhotoFileSniffer.c"
				} else {
					gboolean _tmp17_ = FALSE;
#line 94 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
					_tmp17_ = is_corrupted;
#line 94 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
					if (_tmp17_) {
#line 1048 "PhotoFileSniffer.c"
						GFile* _tmp18_ = NULL;
						gchar* _tmp19_ = NULL;
						gchar* _tmp20_ = NULL;
#line 95 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
						_tmp18_ = self->priv->file;
#line 95 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
						_tmp19_ = g_file_get_path (_tmp18_);
#line 95 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
						_tmp20_ = _tmp19_;
#line 95 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
						g_message ("PhotoFileSniffer.vala:95: Sniffing halted for %s: potentially corrupte" \
"d image file", _tmp20_);
#line 95 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
						_g_free0 (_tmp20_);
#line 96 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
						self->priv->is_photo_corrupted = TRUE;
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
						_detected_photo_information_unref0 (self->priv->detected);
#line 97 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
						self->priv->detected = NULL;
#line 99 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
						_detected_photo_information_unref0 (_tmp6_);
#line 99 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
						_photo_file_sniffer_unref0 (sniffer);
#line 99 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
						break;
#line 1074 "PhotoFileSniffer.c"
					}
				}
#line 85 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				_detected_photo_information_unref0 (_tmp6_);
#line 85 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
				_photo_file_sniffer_unref0 (sniffer);
#line 1081 "PhotoFileSniffer.c"
			}
		}
#line 85 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		file_format_collection = (g_free (file_format_collection), NULL);
#line 1086 "PhotoFileSniffer.c"
	}
}


static void value_photo_file_interrogator_init (GValue* value) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	value->data[0].v_pointer = NULL;
#line 1094 "PhotoFileSniffer.c"
}


static void value_photo_file_interrogator_free_value (GValue* value) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (value->data[0].v_pointer) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		photo_file_interrogator_unref (value->data[0].v_pointer);
#line 1103 "PhotoFileSniffer.c"
	}
}


static void value_photo_file_interrogator_copy_value (const GValue* src_value, GValue* dest_value) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (src_value->data[0].v_pointer) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		dest_value->data[0].v_pointer = photo_file_interrogator_ref (src_value->data[0].v_pointer);
#line 1113 "PhotoFileSniffer.c"
	} else {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1117 "PhotoFileSniffer.c"
	}
}


static gpointer value_photo_file_interrogator_peek_pointer (const GValue* value) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return value->data[0].v_pointer;
#line 1125 "PhotoFileSniffer.c"
}


static gchar* value_photo_file_interrogator_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (collect_values[0].v_pointer) {
#line 1132 "PhotoFileSniffer.c"
		PhotoFileInterrogator* object;
		object = collect_values[0].v_pointer;
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		if (object->parent_instance.g_class == NULL) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1139 "PhotoFileSniffer.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1143 "PhotoFileSniffer.c"
		}
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = photo_file_interrogator_ref (object);
#line 1147 "PhotoFileSniffer.c"
	} else {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = NULL;
#line 1151 "PhotoFileSniffer.c"
	}
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return NULL;
#line 1155 "PhotoFileSniffer.c"
}


static gchar* value_photo_file_interrogator_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PhotoFileInterrogator** object_p;
	object_p = collect_values[0].v_pointer;
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (!object_p) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1166 "PhotoFileSniffer.c"
	}
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (!value->data[0].v_pointer) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		*object_p = NULL;
#line 1172 "PhotoFileSniffer.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		*object_p = value->data[0].v_pointer;
#line 1176 "PhotoFileSniffer.c"
	} else {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		*object_p = photo_file_interrogator_ref (value->data[0].v_pointer);
#line 1180 "PhotoFileSniffer.c"
	}
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return NULL;
#line 1184 "PhotoFileSniffer.c"
}


GParamSpec* param_spec_photo_file_interrogator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPhotoFileInterrogator* spec;
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_FILE_INTERROGATOR), NULL);
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return G_PARAM_SPEC (spec);
#line 1198 "PhotoFileSniffer.c"
}


gpointer value_get_photo_file_interrogator (const GValue* value) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_INTERROGATOR), NULL);
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return value->data[0].v_pointer;
#line 1207 "PhotoFileSniffer.c"
}


void value_set_photo_file_interrogator (GValue* value, gpointer v_object) {
	PhotoFileInterrogator* old;
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_INTERROGATOR));
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	old = value->data[0].v_pointer;
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (v_object) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_INTERROGATOR));
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = v_object;
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		photo_file_interrogator_ref (value->data[0].v_pointer);
#line 1227 "PhotoFileSniffer.c"
	} else {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = NULL;
#line 1231 "PhotoFileSniffer.c"
	}
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (old) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		photo_file_interrogator_unref (old);
#line 1237 "PhotoFileSniffer.c"
	}
}


void value_take_photo_file_interrogator (GValue* value, gpointer v_object) {
	PhotoFileInterrogator* old;
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_FILE_INTERROGATOR));
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	old = value->data[0].v_pointer;
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (v_object) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_FILE_INTERROGATOR));
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = v_object;
#line 1256 "PhotoFileSniffer.c"
	} else {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		value->data[0].v_pointer = NULL;
#line 1260 "PhotoFileSniffer.c"
	}
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (old) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		photo_file_interrogator_unref (old);
#line 1266 "PhotoFileSniffer.c"
	}
}


static void photo_file_interrogator_class_init (PhotoFileInterrogatorClass * klass) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	photo_file_interrogator_parent_class = g_type_class_peek_parent (klass);
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	((PhotoFileInterrogatorClass *) klass)->finalize = photo_file_interrogator_finalize;
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_type_class_add_private (klass, sizeof (PhotoFileInterrogatorPrivate));
#line 1278 "PhotoFileSniffer.c"
}


static void photo_file_interrogator_instance_init (PhotoFileInterrogator * self) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->priv = PHOTO_FILE_INTERROGATOR_GET_PRIVATE (self);
#line 64 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->priv->detected = NULL;
#line 65 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->priv->is_photo_corrupted = FALSE;
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self->ref_count = 1;
#line 1291 "PhotoFileSniffer.c"
}


static void photo_file_interrogator_finalize (PhotoFileInterrogator* obj) {
	PhotoFileInterrogator * self;
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogator);
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_signal_handlers_destroy (self);
#line 62 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_g_object_unref0 (self->priv->file);
#line 64 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	_detected_photo_information_unref0 (self->priv->detected);
#line 1305 "PhotoFileSniffer.c"
}


GType photo_file_interrogator_get_type (void) {
	static volatile gsize photo_file_interrogator_type_id__volatile = 0;
	if (g_once_init_enter (&photo_file_interrogator_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_photo_file_interrogator_init, value_photo_file_interrogator_free_value, value_photo_file_interrogator_copy_value, value_photo_file_interrogator_peek_pointer, "p", value_photo_file_interrogator_collect_value, "p", value_photo_file_interrogator_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PhotoFileInterrogatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_file_interrogator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoFileInterrogator), 0, (GInstanceInitFunc) photo_file_interrogator_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType photo_file_interrogator_type_id;
		photo_file_interrogator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoFileInterrogator", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&photo_file_interrogator_type_id__volatile, photo_file_interrogator_type_id);
	}
	return photo_file_interrogator_type_id__volatile;
}


gpointer photo_file_interrogator_ref (gpointer instance) {
	PhotoFileInterrogator* self;
	self = instance;
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	g_atomic_int_inc (&self->ref_count);
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	return instance;
#line 1330 "PhotoFileSniffer.c"
}


void photo_file_interrogator_unref (gpointer instance) {
	PhotoFileInterrogator* self;
	self = instance;
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		PHOTO_FILE_INTERROGATOR_GET_CLASS (self)->finalize (self);
#line 61 "/home/jens/Source/shotwell/src/photos/PhotoFileSniffer.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1343 "PhotoFileSniffer.c"
	}
}



