/* GdkSupport.c generated by valac 0.34.1, the Vala compiler
 * generated from GdkSupport.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;
typedef struct _PhotoFileAdapterPrivate PhotoFileAdapterPrivate;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;
typedef struct _PhotoFileReaderPrivate PhotoFileReaderPrivate;

#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_GDK_READER (gdk_reader_get_type ())
#define GDK_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GDK_READER, GdkReader))
#define GDK_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GDK_READER, GdkReaderClass))
#define IS_GDK_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GDK_READER))
#define IS_GDK_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GDK_READER))
#define GDK_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GDK_READER, GdkReaderClass))

typedef struct _GdkReader GdkReader;
typedef struct _GdkReaderClass GdkReaderClass;
typedef struct _GdkReaderPrivate GdkReaderPrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PHOTO_FILE_SNIFFER (photo_file_sniffer_get_type ())
#define PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer))
#define PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))
#define IS_PHOTO_FILE_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_SNIFFER))
#define IS_PHOTO_FILE_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_SNIFFER))
#define PHOTO_FILE_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_SNIFFER, PhotoFileSnifferClass))

typedef struct _PhotoFileSniffer PhotoFileSniffer;
typedef struct _PhotoFileSnifferClass PhotoFileSnifferClass;
typedef struct _PhotoFileSnifferPrivate PhotoFileSnifferPrivate;

#define TYPE_DETECTED_PHOTO_INFORMATION (detected_photo_information_get_type ())
#define DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation))
#define DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))
#define IS_DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DETECTED_PHOTO_INFORMATION))
#define IS_DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DETECTED_PHOTO_INFORMATION))
#define DETECTED_PHOTO_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))

typedef struct _DetectedPhotoInformation DetectedPhotoInformation;
typedef struct _DetectedPhotoInformationClass DetectedPhotoInformationClass;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())

#define TYPE_GDK_SNIFFER (gdk_sniffer_get_type ())
#define GDK_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GDK_SNIFFER, GdkSniffer))
#define GDK_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GDK_SNIFFER, GdkSnifferClass))
#define IS_GDK_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GDK_SNIFFER))
#define IS_GDK_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GDK_SNIFFER))
#define GDK_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GDK_SNIFFER, GdkSnifferClass))

typedef struct _GdkSniffer GdkSniffer;
typedef struct _GdkSnifferClass GdkSnifferClass;
typedef struct _GdkSnifferPrivate GdkSnifferPrivate;
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
typedef struct _DetectedPhotoInformationPrivate DetectedPhotoInformationPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PhotoFileAdapter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileAdapterPrivate * priv;
};

struct _PhotoFileAdapterClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileAdapter *self);
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _PhotoFileReader {
	PhotoFileAdapter parent_instance;
	PhotoFileReaderPrivate * priv;
};

struct _PhotoFileReaderClass {
	PhotoFileAdapterClass parent_class;
	PhotoMetadata* (*read_metadata) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*unscaled_read) (PhotoFileReader* self, GError** error);
	GdkPixbuf* (*scaled_read) (PhotoFileReader* self, Dimensions* full, Dimensions* scaled, GError** error);
};

struct _GdkReader {
	PhotoFileReader parent_instance;
	GdkReaderPrivate * priv;
};

struct _GdkReaderClass {
	PhotoFileReaderClass parent_class;
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

struct _PhotoFileSniffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoFileSnifferPrivate * priv;
	GFile* file;
	PhotoFileSnifferOptions options;
	gboolean calc_md5;
};

struct _PhotoFileSnifferClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoFileSniffer *self);
	DetectedPhotoInformation* (*sniff) (PhotoFileSniffer* self, gboolean* is_corrupted, GError** error);
};

struct _GdkSniffer {
	PhotoFileSniffer parent_instance;
	GdkSnifferPrivate * priv;
};

struct _GdkSnifferClass {
	PhotoFileSnifferClass parent_class;
};

struct _GdkSnifferPrivate {
	DetectedPhotoInformation* detected;
	gboolean size_ready;
	gboolean area_prepared;
};

struct _DetectedPhotoInformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DetectedPhotoInformationPrivate * priv;
	PhotoFileFormat file_format;
	PhotoMetadata* metadata;
	gchar* md5;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* format_name;
	Dimensions image_dim;
	GdkColorspace colorspace;
	gint channels;
	gint bits_per_channel;
};

struct _DetectedPhotoInformationClass {
	GTypeClass parent_class;
	void (*finalize) (DetectedPhotoInformation *self);
};


static gpointer gdk_reader_parent_class = NULL;
static gpointer gdk_sniffer_parent_class = NULL;

gpointer photo_file_adapter_ref (gpointer instance);
void photo_file_adapter_unref (gpointer instance);
GParamSpec* param_spec_photo_file_adapter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_adapter (GValue* value, gpointer v_object);
void value_take_photo_file_adapter (GValue* value, gpointer v_object);
gpointer value_get_photo_file_adapter (const GValue* value);
GType photo_file_adapter_get_type (void) G_GNUC_CONST;
GType photo_file_reader_get_type (void) G_GNUC_CONST;
gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GType photo_metadata_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType gdk_reader_get_type (void) G_GNUC_CONST;
enum  {
	GDK_READER_DUMMY_PROPERTY
};
GType photo_file_format_get_type (void) G_GNUC_CONST;
GdkReader* gdk_reader_construct (GType object_type, const gchar* filepath, PhotoFileFormat file_format);
PhotoFileReader* photo_file_reader_construct (GType object_type, const gchar* filepath, PhotoFileFormat file_format);
static PhotoMetadata* gdk_reader_real_read_metadata (PhotoFileReader* base, GError** error);
PhotoMetadata* photo_metadata_new (void);
PhotoMetadata* photo_metadata_construct (GType object_type);
void media_metadata_read_from_file (MediaMetadata* self, GFile* file, GError** error);
GFile* photo_file_adapter_get_file (PhotoFileAdapter* self);
static GdkPixbuf* gdk_reader_real_unscaled_read (PhotoFileReader* base, GError** error);
gchar* photo_file_adapter_get_filepath (PhotoFileAdapter* self);
static GdkPixbuf* gdk_reader_real_scaled_read (PhotoFileReader* base, Dimensions* full, Dimensions* scaled, GError** error);
gpointer photo_file_sniffer_ref (gpointer instance);
void photo_file_sniffer_unref (gpointer instance);
GParamSpec* param_spec_photo_file_sniffer (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_sniffer (GValue* value, gpointer v_object);
void value_take_photo_file_sniffer (GValue* value, gpointer v_object);
gpointer value_get_photo_file_sniffer (const GValue* value);
GType photo_file_sniffer_get_type (void) G_GNUC_CONST;
gpointer detected_photo_information_ref (gpointer instance);
void detected_photo_information_unref (gpointer instance);
GParamSpec* param_spec_detected_photo_information (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_detected_photo_information (GValue* value, gpointer v_object);
void value_take_detected_photo_information (GValue* value, gpointer v_object);
gpointer value_get_detected_photo_information (const GValue* value);
GType detected_photo_information_get_type (void) G_GNUC_CONST;
GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST;
GType gdk_sniffer_get_type (void) G_GNUC_CONST;
#define GDK_SNIFFER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GDK_SNIFFER, GdkSnifferPrivate))
enum  {
	GDK_SNIFFER_DUMMY_PROPERTY
};
GdkSniffer* gdk_sniffer_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options);
PhotoFileSniffer* photo_file_sniffer_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options);
static DetectedPhotoInformation* gdk_sniffer_real_sniff (PhotoFileSniffer* base, gboolean* is_corrupted, GError** error);
DetectedPhotoInformation* detected_photo_information_new (void);
DetectedPhotoInformation* detected_photo_information_construct (GType object_type);
static void gdk_sniffer_on_size_prepared (GdkSniffer* self, GdkPixbufLoader* loader, gint width, gint height);
static void _gdk_sniffer_on_size_prepared_gdk_pixbuf_loader_size_prepared (GdkPixbufLoader* _sender, gint width, gint height, gpointer self);
static void gdk_sniffer_on_area_prepared (GdkSniffer* self, GdkPixbufLoader* pixbuf_loader);
static void _gdk_sniffer_on_area_prepared_gdk_pixbuf_loader_area_prepared (GdkPixbufLoader* _sender, gpointer self);
guint8* photo_metadata_flatten_exif (PhotoMetadata* self, gboolean include_preview, int* result_length1);
gchar* md5_binary (guint8* buffer, gsize length);
guint8* photo_metadata_flatten_exif_preview (PhotoMetadata* self, int* result_length1);
static guint8* _vala_array_dup7 (guint8* self, int length);
void dimensions_init (Dimensions *self, gint width, gint height);
PhotoFileFormat photo_file_format_from_pixbuf_name (const gchar* name);
static void gdk_sniffer_finalize (PhotoFileSniffer* obj);


GdkReader* gdk_reader_construct (GType object_type, const gchar* filepath, PhotoFileFormat file_format) {
	GdkReader* self = NULL;
	const gchar* _tmp0_ = NULL;
	PhotoFileFormat _tmp1_ = 0;
#line 8 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_return_val_if_fail (filepath != NULL, NULL);
#line 9 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = filepath;
#line 9 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp1_ = file_format;
#line 9 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self = (GdkReader*) photo_file_reader_construct (object_type, _tmp0_, _tmp1_);
#line 8 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return self;
#line 310 "GdkSupport.c"
}


static PhotoMetadata* gdk_reader_real_read_metadata (PhotoFileReader* base, GError** error) {
	GdkReader * self;
	PhotoMetadata* result = NULL;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
#line 12 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_GDK_READER, GdkReader);
#line 13 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = photo_metadata_new ();
#line 13 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	metadata = _tmp0_;
#line 14 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp1_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 14 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp2_ = _tmp1_;
#line 14 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (metadata, TYPE_MEDIA_METADATA, MediaMetadata), _tmp2_, &_inner_error_);
#line 14 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_object_unref0 (_tmp2_);
#line 14 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 14 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 14 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_media_metadata_unref0 (metadata);
#line 14 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		return NULL;
#line 344 "GdkSupport.c"
	}
#line 16 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	result = metadata;
#line 16 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return result;
#line 350 "GdkSupport.c"
}


static GdkPixbuf* gdk_reader_real_unscaled_read (PhotoFileReader* base, GError** error) {
	GdkReader * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 19 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_GDK_READER, GdkReader);
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp1_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp2_ = _tmp1_;
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp3_ = gdk_pixbuf_new_from_file (_tmp2_, &_inner_error_);
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp4_ = _tmp3_;
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_free0 (_tmp2_);
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = _tmp4_;
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		return NULL;
#line 384 "GdkSupport.c"
	}
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp5_ = _tmp0_;
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = NULL;
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	result = _tmp5_;
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_object_unref0 (_tmp0_);
#line 20 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return result;
#line 396 "GdkSupport.c"
}


static GdkPixbuf* gdk_reader_real_scaled_read (PhotoFileReader* base, Dimensions* full, Dimensions* scaled, GError** error) {
	GdkReader * self;
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	Dimensions _tmp3_ = {0};
	gint _tmp4_ = 0;
	Dimensions _tmp5_ = {0};
	gint _tmp6_ = 0;
	GdkPixbuf* _tmp7_ = NULL;
	GdkPixbuf* _tmp8_ = NULL;
	GdkPixbuf* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
#line 23 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_GDK_READER, GdkReader);
#line 23 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_return_val_if_fail (full != NULL, NULL);
#line 23 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_return_val_if_fail (scaled != NULL, NULL);
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp1_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp2_ = _tmp1_;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp3_ = *scaled;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp4_ = _tmp3_.width;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp5_ = *scaled;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp6_ = _tmp5_.height;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp7_ = gdk_pixbuf_new_from_file_at_scale (_tmp2_, _tmp4_, _tmp6_, FALSE, &_inner_error_);
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp8_ = _tmp7_;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_free0 (_tmp2_);
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = _tmp8_;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		return NULL;
#line 446 "GdkSupport.c"
	}
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp9_ = _tmp0_;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = NULL;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	result = _tmp9_;
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_object_unref0 (_tmp0_);
#line 24 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return result;
#line 458 "GdkSupport.c"
}


static void gdk_reader_class_init (GdkReaderClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	gdk_reader_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	((PhotoFileReaderClass *) klass)->read_metadata = gdk_reader_real_read_metadata;
#line 7 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	((PhotoFileReaderClass *) klass)->unscaled_read = gdk_reader_real_unscaled_read;
#line 7 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	((PhotoFileReaderClass *) klass)->scaled_read = gdk_reader_real_scaled_read;
#line 471 "GdkSupport.c"
}


static void gdk_reader_instance_init (GdkReader * self) {
}


GType gdk_reader_get_type (void) {
	static volatile gsize gdk_reader_type_id__volatile = 0;
	if (g_once_init_enter (&gdk_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GdkReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gdk_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GdkReader), 0, (GInstanceInitFunc) gdk_reader_instance_init, NULL };
		GType gdk_reader_type_id;
		gdk_reader_type_id = g_type_register_static (TYPE_PHOTO_FILE_READER, "GdkReader", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&gdk_reader_type_id__volatile, gdk_reader_type_id);
	}
	return gdk_reader_type_id__volatile;
}


GdkSniffer* gdk_sniffer_construct (GType object_type, GFile* file, PhotoFileSnifferOptions options) {
	GdkSniffer* self = NULL;
	GFile* _tmp0_ = NULL;
	PhotoFileSnifferOptions _tmp1_ = 0;
#line 33 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_return_val_if_fail (G_IS_FILE (file), NULL);
#line 34 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = file;
#line 34 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp1_ = options;
#line 34 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self = (GdkSniffer*) photo_file_sniffer_construct (object_type, _tmp0_, _tmp1_);
#line 33 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return self;
#line 505 "GdkSupport.c"
}


static void _gdk_sniffer_on_size_prepared_gdk_pixbuf_loader_size_prepared (GdkPixbufLoader* _sender, gint width, gint height, gpointer self) {
#line 41 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	gdk_sniffer_on_size_prepared ((GdkSniffer*) self, _sender, width, height);
#line 512 "GdkSupport.c"
}


static void _gdk_sniffer_on_area_prepared_gdk_pixbuf_loader_area_prepared (GdkPixbufLoader* _sender, gpointer self) {
#line 42 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	gdk_sniffer_on_area_prepared ((GdkSniffer*) self, _sender);
#line 519 "GdkSupport.c"
}


static guint8* _vala_array_dup7 (guint8* self, int length) {
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 526 "GdkSupport.c"
}


static gpointer _detected_photo_information_ref0 (gpointer self) {
#line 108 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return self ? detected_photo_information_ref (self) : NULL;
#line 533 "GdkSupport.c"
}


static DetectedPhotoInformation* gdk_sniffer_real_sniff (PhotoFileSniffer* base, gboolean* is_corrupted, GError** error) {
	GdkSniffer * self;
	gboolean _vala_is_corrupted = FALSE;
	DetectedPhotoInformation* result = NULL;
	DetectedPhotoInformation* _tmp0_ = NULL;
	GdkPixbufLoader* pixbuf_loader = NULL;
	GdkPixbufLoader* _tmp1_ = NULL;
	GdkPixbufLoader* _tmp2_ = NULL;
	GdkPixbufLoader* _tmp3_ = NULL;
	GChecksum* md5_checksum = NULL;
	gboolean _tmp4_ = FALSE;
	DetectedPhotoInformation* _tmp6_ = NULL;
	PhotoMetadata* _tmp7_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	guint8* _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	gint __tmp38__size_ = 0;
	gboolean _tmp39_ = FALSE;
	guint8* buffer = NULL;
	guint8* _tmp42_ = NULL;
	gint _tmp42__length1 = 0;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	gsize count = 0UL;
	GFileInputStream* fins = NULL;
	GFile* _tmp43_ = NULL;
	GFileInputStream* _tmp44_ = NULL;
	GFileInputStream* _tmp68_ = NULL;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp75_ = FALSE;
	gboolean _tmp76_ = FALSE;
	DetectedPhotoInformation* _tmp78_ = NULL;
	DetectedPhotoInformation* _tmp79_ = NULL;
	GError * _inner_error_ = NULL;
#line 37 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_GDK_SNIFFER, GdkSniffer);
#line 38 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = detected_photo_information_new ();
#line 38 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_detected_photo_information_unref0 (self->priv->detected);
#line 38 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self->priv->detected = _tmp0_;
#line 40 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp1_ = gdk_pixbuf_loader_new ();
#line 40 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	pixbuf_loader = _tmp1_;
#line 41 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp2_ = pixbuf_loader;
#line 41 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_signal_connect (_tmp2_, "size-prepared", (GCallback) _gdk_sniffer_on_size_prepared_gdk_pixbuf_loader_size_prepared, self);
#line 42 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp3_ = pixbuf_loader;
#line 42 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_signal_connect (_tmp3_, "area-prepared", (GCallback) _gdk_sniffer_on_area_prepared_gdk_pixbuf_loader_area_prepared, self);
#line 45 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	md5_checksum = NULL;
#line 46 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5;
#line 46 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (_tmp4_) {
#line 598 "GdkSupport.c"
		GChecksum* _tmp5_ = NULL;
#line 47 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp5_ = g_checksum_new (G_CHECKSUM_MD5);
#line 47 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_checksum_free0 (md5_checksum);
#line 47 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		md5_checksum = _tmp5_;
#line 606 "GdkSupport.c"
	}
#line 49 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp6_ = self->priv->detected;
#line 49 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp7_ = photo_metadata_new ();
#line 49 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_media_metadata_unref0 (_tmp6_->metadata);
#line 49 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp6_->metadata = _tmp7_;
#line 616 "GdkSupport.c"
	{
		DetectedPhotoInformation* _tmp8_ = NULL;
		PhotoMetadata* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
#line 51 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp8_ = self->priv->detected;
#line 51 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp9_ = _tmp8_->metadata;
#line 51 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
#line 51 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		media_metadata_read_from_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_MEDIA_METADATA, MediaMetadata), _tmp10_, &_inner_error_);
#line 51 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 631 "GdkSupport.c"
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* err = NULL;
		DetectedPhotoInformation* _tmp11_ = NULL;
#line 50 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		err = _inner_error_;
#line 50 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_inner_error_ = NULL;
#line 54 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp11_ = self->priv->detected;
#line 54 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_media_metadata_unref0 (_tmp11_->metadata);
#line 54 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp11_->metadata = NULL;
#line 50 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_error_free0 (err);
#line 652 "GdkSupport.c"
	}
	__finally28:
#line 50 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 50 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 50 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_checksum_free0 (md5_checksum);
#line 50 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_object_unref0 (pixbuf_loader);
#line 50 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		return NULL;
#line 665 "GdkSupport.c"
	}
#line 57 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp13_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5;
#line 57 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (_tmp13_) {
#line 671 "GdkSupport.c"
		DetectedPhotoInformation* _tmp14_ = NULL;
		PhotoMetadata* _tmp15_ = NULL;
#line 57 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp14_ = self->priv->detected;
#line 57 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp15_ = _tmp14_->metadata;
#line 57 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp12_ = _tmp15_ != NULL;
#line 680 "GdkSupport.c"
	} else {
#line 57 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp12_ = FALSE;
#line 684 "GdkSupport.c"
	}
#line 57 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (_tmp12_) {
#line 688 "GdkSupport.c"
		guint8* flattened_sans_thumbnail = NULL;
		DetectedPhotoInformation* _tmp16_ = NULL;
		PhotoMetadata* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		guint8* _tmp19_ = NULL;
		gint flattened_sans_thumbnail_length1 = 0;
		gint _flattened_sans_thumbnail_size_ = 0;
		gboolean _tmp20_ = FALSE;
		guint8* _tmp21_ = NULL;
		gint _tmp21__length1 = 0;
		guint8* flattened_thumbnail = NULL;
		DetectedPhotoInformation* _tmp27_ = NULL;
		PhotoMetadata* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		guint8* _tmp30_ = NULL;
		gint flattened_thumbnail_length1 = 0;
		gint _flattened_thumbnail_size_ = 0;
		gboolean _tmp31_ = FALSE;
		guint8* _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
#line 58 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp16_ = self->priv->detected;
#line 58 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp17_ = _tmp16_->metadata;
#line 58 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp19_ = photo_metadata_flatten_exif (_tmp17_, FALSE, &_tmp18_);
#line 58 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		flattened_sans_thumbnail = _tmp19_;
#line 58 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		flattened_sans_thumbnail_length1 = _tmp18_;
#line 58 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_flattened_sans_thumbnail_size_ = flattened_sans_thumbnail_length1;
#line 59 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp21_ = flattened_sans_thumbnail;
#line 59 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp21__length1 = flattened_sans_thumbnail_length1;
#line 59 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		if (_tmp21_ != NULL) {
#line 727 "GdkSupport.c"
			guint8* _tmp22_ = NULL;
			gint _tmp22__length1 = 0;
#line 59 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp22_ = flattened_sans_thumbnail;
#line 59 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp22__length1 = flattened_sans_thumbnail_length1;
#line 59 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp20_ = _tmp22__length1 > 0;
#line 736 "GdkSupport.c"
		} else {
#line 59 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp20_ = FALSE;
#line 740 "GdkSupport.c"
		}
#line 59 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		if (_tmp20_) {
#line 744 "GdkSupport.c"
			DetectedPhotoInformation* _tmp23_ = NULL;
			guint8* _tmp24_ = NULL;
			gint _tmp24__length1 = 0;
			guint8* _tmp25_ = NULL;
			gint _tmp25__length1 = 0;
			gchar* _tmp26_ = NULL;
#line 60 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp23_ = self->priv->detected;
#line 60 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp24_ = flattened_sans_thumbnail;
#line 60 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp24__length1 = flattened_sans_thumbnail_length1;
#line 60 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp25_ = flattened_sans_thumbnail;
#line 60 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp25__length1 = flattened_sans_thumbnail_length1;
#line 60 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp26_ = md5_binary (_tmp24_, (gsize) _tmp25__length1);
#line 60 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_g_free0 (_tmp23_->exif_md5);
#line 60 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp23_->exif_md5 = _tmp26_;
#line 767 "GdkSupport.c"
		}
#line 62 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp27_ = self->priv->detected;
#line 62 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp28_ = _tmp27_->metadata;
#line 62 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp30_ = photo_metadata_flatten_exif_preview (_tmp28_, &_tmp29_);
#line 62 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		flattened_thumbnail = _tmp30_;
#line 62 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		flattened_thumbnail_length1 = _tmp29_;
#line 62 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_flattened_thumbnail_size_ = flattened_thumbnail_length1;
#line 63 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp32_ = flattened_thumbnail;
#line 63 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp32__length1 = flattened_thumbnail_length1;
#line 63 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		if (_tmp32_ != NULL) {
#line 787 "GdkSupport.c"
			guint8* _tmp33_ = NULL;
			gint _tmp33__length1 = 0;
#line 63 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp33_ = flattened_thumbnail;
#line 63 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp33__length1 = flattened_thumbnail_length1;
#line 63 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp31_ = _tmp33__length1 > 0;
#line 796 "GdkSupport.c"
		} else {
#line 63 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp31_ = FALSE;
#line 800 "GdkSupport.c"
		}
#line 63 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		if (_tmp31_) {
#line 804 "GdkSupport.c"
			DetectedPhotoInformation* _tmp34_ = NULL;
			guint8* _tmp35_ = NULL;
			gint _tmp35__length1 = 0;
			guint8* _tmp36_ = NULL;
			gint _tmp36__length1 = 0;
			gchar* _tmp37_ = NULL;
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp34_ = self->priv->detected;
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp35_ = flattened_thumbnail;
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp35__length1 = flattened_thumbnail_length1;
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp36_ = flattened_thumbnail;
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp36__length1 = flattened_thumbnail_length1;
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp37_ = md5_binary (_tmp35_, (gsize) _tmp36__length1);
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_g_free0 (_tmp34_->thumbnail_md5);
#line 64 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp34_->thumbnail_md5 = _tmp37_;
#line 827 "GdkSupport.c"
		}
#line 57 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		flattened_thumbnail = (g_free (flattened_thumbnail), NULL);
#line 57 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		flattened_sans_thumbnail = (g_free (flattened_sans_thumbnail), NULL);
#line 833 "GdkSupport.c"
	}
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp39_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5;
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (_tmp39_) {
#line 839 "GdkSupport.c"
		guint8* _tmp40_ = NULL;
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp40_ = g_new0 (guint8, 64 * 1024);
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp38_ = (g_free (_tmp38_), NULL);
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp38_ = _tmp40_;
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp38__length1 = 64 * 1024;
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		__tmp38__size_ = _tmp38__length1;
#line 851 "GdkSupport.c"
	} else {
		guint8* _tmp41_ = NULL;
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp41_ = g_new0 (guint8, 8 * 1024);
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp38_ = (g_free (_tmp38_), NULL);
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp38_ = _tmp41_;
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp38__length1 = 8 * 1024;
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		__tmp38__size_ = _tmp38__length1;
#line 864 "GdkSupport.c"
	}
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp42_ = (_tmp38_ != NULL) ? _vala_array_dup7 (_tmp38_, _tmp38__length1) : ((gpointer) _tmp38_);
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp42__length1 = _tmp38__length1;
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	buffer = _tmp42_;
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	buffer_length1 = _tmp42__length1;
#line 69 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_buffer_size_ = buffer_length1;
#line 70 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	count = (gsize) 0;
#line 73 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp43_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->file;
#line 73 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp44_ = g_file_read (_tmp43_, NULL, &_inner_error_);
#line 73 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	fins = _tmp44_;
#line 73 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 73 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 73 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		buffer = (g_free (buffer), NULL);
#line 73 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp38_ = (g_free (_tmp38_), NULL);
#line 73 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_checksum_free0 (md5_checksum);
#line 73 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_object_unref0 (pixbuf_loader);
#line 73 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		return NULL;
#line 898 "GdkSupport.c"
	}
	{
		gboolean _tmp45_ = FALSE;
#line 74 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp45_ = TRUE;
#line 74 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		while (TRUE) {
#line 906 "GdkSupport.c"
			gsize bytes_read = 0UL;
			GFileInputStream* _tmp46_ = NULL;
			guint8* _tmp47_ = NULL;
			gint _tmp47__length1 = 0;
			gssize _tmp48_ = 0L;
			gsize _tmp49_ = 0UL;
			gsize _tmp50_ = 0UL;
			gsize _tmp51_ = 0UL;
			gboolean _tmp52_ = FALSE;
			gboolean _tmp56_ = FALSE;
			gboolean _tmp57_ = FALSE;
			gboolean _tmp62_ = FALSE;
			gboolean _tmp63_ = FALSE;
			gboolean _tmp64_ = FALSE;
#line 74 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (!_tmp45_) {
#line 923 "GdkSupport.c"
			}
#line 74 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp45_ = FALSE;
#line 75 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp46_ = fins;
#line 75 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp47_ = buffer;
#line 75 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp47__length1 = buffer_length1;
#line 75 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp48_ = g_input_stream_read (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, g_input_stream_get_type (), GInputStream), _tmp47_, (gsize) _tmp47__length1, NULL, &_inner_error_);
#line 75 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			bytes_read = (gsize) _tmp48_;
#line 75 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 75 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				g_propagate_error (error, _inner_error_);
#line 75 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_g_object_unref0 (fins);
#line 75 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				buffer = (g_free (buffer), NULL);
#line 75 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp38_ = (g_free (_tmp38_), NULL);
#line 75 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_g_checksum_free0 (md5_checksum);
#line 75 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_g_object_unref0 (pixbuf_loader);
#line 75 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				return NULL;
#line 953 "GdkSupport.c"
			}
#line 76 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp49_ = bytes_read;
#line 76 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (_tmp49_ <= ((gsize) 0)) {
#line 77 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				break;
#line 961 "GdkSupport.c"
			}
#line 79 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp50_ = count;
#line 79 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp51_ = bytes_read;
#line 79 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			count = _tmp50_ + _tmp51_;
#line 81 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp52_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5;
#line 81 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (_tmp52_) {
#line 973 "GdkSupport.c"
				GChecksum* _tmp53_ = NULL;
				guint8* _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gsize _tmp55_ = 0UL;
#line 82 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp53_ = md5_checksum;
#line 82 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp54_ = buffer;
#line 82 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp54__length1 = buffer_length1;
#line 82 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp55_ = bytes_read;
#line 82 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				g_checksum_update (_tmp53_, _tmp54_, _tmp55_);
#line 988 "GdkSupport.c"
			}
#line 85 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp57_ = self->priv->size_ready;
#line 85 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (!_tmp57_) {
#line 85 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp56_ = TRUE;
#line 996 "GdkSupport.c"
			} else {
				gboolean _tmp58_ = FALSE;
#line 85 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp58_ = self->priv->area_prepared;
#line 85 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp56_ = !_tmp58_;
#line 1003 "GdkSupport.c"
			}
#line 85 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (_tmp56_) {
#line 1007 "GdkSupport.c"
				GdkPixbufLoader* _tmp59_ = NULL;
				guint8* _tmp60_ = NULL;
				gint _tmp60__length1 = 0;
				gsize _tmp61_ = 0UL;
#line 86 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp59_ = pixbuf_loader;
#line 86 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp60_ = buffer;
#line 86 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp60__length1 = buffer_length1;
#line 86 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp61_ = bytes_read;
#line 86 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				gdk_pixbuf_loader_write (_tmp59_, _tmp60_ + 0, (gsize) (((gint) _tmp61_) - 0), &_inner_error_);
#line 86 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 86 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
					g_propagate_error (error, _inner_error_);
#line 86 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
					_g_object_unref0 (fins);
#line 86 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
					buffer = (g_free (buffer), NULL);
#line 86 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
					_tmp38_ = (g_free (_tmp38_), NULL);
#line 86 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
					_g_checksum_free0 (md5_checksum);
#line 86 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
					_g_object_unref0 (pixbuf_loader);
#line 86 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
					return NULL;
#line 1038 "GdkSupport.c"
				}
			}
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp64_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5;
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (!_tmp64_) {
#line 1045 "GdkSupport.c"
				gboolean _tmp65_ = FALSE;
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp65_ = self->priv->size_ready;
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp63_ = _tmp65_;
#line 1051 "GdkSupport.c"
			} else {
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp63_ = FALSE;
#line 1055 "GdkSupport.c"
			}
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (_tmp63_) {
#line 1059 "GdkSupport.c"
				gboolean _tmp66_ = FALSE;
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp66_ = self->priv->area_prepared;
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp62_ = _tmp66_;
#line 1065 "GdkSupport.c"
			} else {
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				_tmp62_ = FALSE;
#line 1069 "GdkSupport.c"
			}
#line 89 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			if (_tmp62_) {
#line 90 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
				break;
#line 1075 "GdkSupport.c"
			}
		}
	}
	{
		GdkPixbufLoader* _tmp67_ = NULL;
#line 95 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp67_ = pixbuf_loader;
#line 95 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		gdk_pixbuf_loader_close (_tmp67_, &_inner_error_);
#line 95 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1087 "GdkSupport.c"
			goto __catch29_g_error;
		}
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* err = NULL;
#line 94 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		err = _inner_error_;
#line 94 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_inner_error_ = NULL;
#line 94 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_error_free0 (err);
#line 1101 "GdkSupport.c"
	}
	__finally29:
#line 94 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 94 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		g_propagate_error (error, _inner_error_);
#line 94 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_object_unref0 (fins);
#line 94 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		buffer = (g_free (buffer), NULL);
#line 94 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp38_ = (g_free (_tmp38_), NULL);
#line 94 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_checksum_free0 (md5_checksum);
#line 94 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_object_unref0 (pixbuf_loader);
#line 94 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		return NULL;
#line 1120 "GdkSupport.c"
	}
#line 99 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp68_ = fins;
#line 99 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (_tmp68_ != NULL) {
#line 1126 "GdkSupport.c"
		GFileInputStream* _tmp69_ = NULL;
#line 100 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp69_ = fins;
#line 100 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		g_input_stream_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, g_input_stream_get_type (), GInputStream), NULL, &_inner_error_);
#line 100 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 100 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			g_propagate_error (error, _inner_error_);
#line 100 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_g_object_unref0 (fins);
#line 100 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			buffer = (g_free (buffer), NULL);
#line 100 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_tmp38_ = (g_free (_tmp38_), NULL);
#line 100 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_g_checksum_free0 (md5_checksum);
#line 100 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			_g_object_unref0 (pixbuf_loader);
#line 100 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
			return NULL;
#line 1148 "GdkSupport.c"
		}
	}
#line 102 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp70_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_FILE_SNIFFER, PhotoFileSniffer)->calc_md5;
#line 102 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (_tmp70_) {
#line 1155 "GdkSupport.c"
		DetectedPhotoInformation* _tmp71_ = NULL;
		GChecksum* _tmp72_ = NULL;
		const gchar* _tmp73_ = NULL;
		gchar* _tmp74_ = NULL;
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp71_ = self->priv->detected;
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp72_ = md5_checksum;
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp73_ = g_checksum_get_string (_tmp72_);
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp74_ = g_strdup (_tmp73_);
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_free0 (_tmp71_->md5);
#line 103 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp71_->md5 = _tmp74_;
#line 1172 "GdkSupport.c"
	}
#line 106 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp76_ = self->priv->size_ready;
#line 106 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (!_tmp76_) {
#line 106 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp75_ = TRUE;
#line 1180 "GdkSupport.c"
	} else {
		gboolean _tmp77_ = FALSE;
#line 106 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp77_ = self->priv->area_prepared;
#line 106 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_tmp75_ = !_tmp77_;
#line 1187 "GdkSupport.c"
	}
#line 106 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_vala_is_corrupted = _tmp75_;
#line 108 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp78_ = self->priv->detected;
#line 108 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp79_ = _detected_photo_information_ref0 (_tmp78_);
#line 108 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	result = _tmp79_;
#line 108 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_object_unref0 (fins);
#line 108 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	buffer = (g_free (buffer), NULL);
#line 108 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp38_ = (g_free (_tmp38_), NULL);
#line 108 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_checksum_free0 (md5_checksum);
#line 108 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_object_unref0 (pixbuf_loader);
#line 108 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (is_corrupted) {
#line 108 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		*is_corrupted = _vala_is_corrupted;
#line 1211 "GdkSupport.c"
	}
#line 108 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return result;
#line 1215 "GdkSupport.c"
}


static void gdk_sniffer_on_size_prepared (GdkSniffer* self, GdkPixbufLoader* loader, gint width, gint height) {
	DetectedPhotoInformation* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 111 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_return_if_fail (IS_GDK_SNIFFER (self));
#line 111 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_return_if_fail (GDK_IS_PIXBUF_LOADER (loader));
#line 112 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = self->priv->detected;
#line 112 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp1_ = width;
#line 112 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp2_ = height;
#line 112 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	dimensions_init (&_tmp0_->image_dim, _tmp1_, _tmp2_);
#line 113 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self->priv->size_ready = TRUE;
#line 1237 "GdkSupport.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 117 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	return self ? g_object_ref (self) : NULL;
#line 1244 "GdkSupport.c"
}


static void gdk_sniffer_on_area_prepared (GdkSniffer* self, GdkPixbufLoader* pixbuf_loader) {
	GdkPixbuf* pixbuf = NULL;
	GdkPixbufLoader* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	DetectedPhotoInformation* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	GdkColorspace _tmp6_ = 0;
	DetectedPhotoInformation* _tmp7_ = NULL;
	GdkPixbuf* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	DetectedPhotoInformation* _tmp10_ = NULL;
	GdkPixbuf* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GdkPixbufFormat* format = NULL;
	GdkPixbufLoader* _tmp13_ = NULL;
	GdkPixbufFormat* _tmp14_ = NULL;
	DetectedPhotoInformation* _tmp15_ = NULL;
	GdkPixbufFormat* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	DetectedPhotoInformation* _tmp18_ = NULL;
	DetectedPhotoInformation* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	PhotoFileFormat _tmp21_ = 0;
#line 116 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_return_if_fail (IS_GDK_SNIFFER (self));
#line 116 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_return_if_fail (GDK_IS_PIXBUF_LOADER (pixbuf_loader));
#line 117 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp0_ = pixbuf_loader;
#line 117 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp1_ = gdk_pixbuf_loader_get_pixbuf (_tmp0_);
#line 117 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 117 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	pixbuf = _tmp2_;
#line 118 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp3_ = pixbuf;
#line 118 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	if (_tmp3_ == NULL) {
#line 119 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		_g_object_unref0 (pixbuf);
#line 119 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
		return;
#line 1293 "GdkSupport.c"
	}
#line 121 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp4_ = self->priv->detected;
#line 121 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp5_ = pixbuf;
#line 121 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp6_ = gdk_pixbuf_get_colorspace (_tmp5_);
#line 121 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp4_->colorspace = _tmp6_;
#line 122 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp7_ = self->priv->detected;
#line 122 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp8_ = pixbuf;
#line 122 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp9_ = gdk_pixbuf_get_n_channels (_tmp8_);
#line 122 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp7_->channels = _tmp9_;
#line 123 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp10_ = self->priv->detected;
#line 123 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp11_ = pixbuf;
#line 123 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp12_ = gdk_pixbuf_get_bits_per_sample (_tmp11_);
#line 123 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp10_->bits_per_channel = _tmp12_;
#line 125 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp13_ = pixbuf_loader;
#line 125 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp14_ = gdk_pixbuf_loader_get_format (_tmp13_);
#line 125 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	format = _tmp14_;
#line 126 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp15_ = self->priv->detected;
#line 126 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp16_ = format;
#line 126 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp17_ = gdk_pixbuf_format_get_name (_tmp16_);
#line 126 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_free0 (_tmp15_->format_name);
#line 126 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp15_->format_name = _tmp17_;
#line 127 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp18_ = self->priv->detected;
#line 127 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp19_ = self->priv->detected;
#line 127 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp20_ = _tmp19_->format_name;
#line 127 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp21_ = photo_file_format_from_pixbuf_name (_tmp20_);
#line 127 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_tmp18_->file_format = _tmp21_;
#line 129 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self->priv->area_prepared = TRUE;
#line 116 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_g_object_unref0 (pixbuf);
#line 1349 "GdkSupport.c"
}


static void gdk_sniffer_class_init (GdkSnifferClass * klass) {
#line 28 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	gdk_sniffer_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	((PhotoFileSnifferClass *) klass)->finalize = gdk_sniffer_finalize;
#line 28 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	g_type_class_add_private (klass, sizeof (GdkSnifferPrivate));
#line 28 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	((PhotoFileSnifferClass *) klass)->sniff = gdk_sniffer_real_sniff;
#line 1362 "GdkSupport.c"
}


static void gdk_sniffer_instance_init (GdkSniffer * self) {
#line 28 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self->priv = GDK_SNIFFER_GET_PRIVATE (self);
#line 29 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self->priv->detected = NULL;
#line 30 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self->priv->size_ready = FALSE;
#line 31 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self->priv->area_prepared = FALSE;
#line 1375 "GdkSupport.c"
}


static void gdk_sniffer_finalize (PhotoFileSniffer* obj) {
	GdkSniffer * self;
#line 28 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GDK_SNIFFER, GdkSniffer);
#line 29 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	_detected_photo_information_unref0 (self->priv->detected);
#line 28 "/home/jens/Source/shotwell/src/photos/GdkSupport.vala"
	PHOTO_FILE_SNIFFER_CLASS (gdk_sniffer_parent_class)->finalize (obj);
#line 1387 "GdkSupport.c"
}


GType gdk_sniffer_get_type (void) {
	static volatile gsize gdk_sniffer_type_id__volatile = 0;
	if (g_once_init_enter (&gdk_sniffer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GdkSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gdk_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GdkSniffer), 0, (GInstanceInitFunc) gdk_sniffer_instance_init, NULL };
		GType gdk_sniffer_type_id;
		gdk_sniffer_type_id = g_type_register_static (TYPE_PHOTO_FILE_SNIFFER, "GdkSniffer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&gdk_sniffer_type_id__volatile, gdk_sniffer_type_id);
	}
	return gdk_sniffer_type_id__volatile;
}



