/* DatabaseTable.c generated by valac 0.34.1, the Vala compiler
 * generated from DatabaseTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
typedef struct _ParamSpecDatabaseTable ParamSpecDatabaseTable;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _ParamSpecDatabaseTable {
	GParamSpec parent_instance;
};


static gpointer database_table_parent_class = NULL;
extern sqlite3* database_table_db;
sqlite3* database_table_db = NULL;
static gint database_table_in_transaction;
static gint database_table_in_transaction = 0;

GQuark database_error_quark (void);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_database_table (GValue* value, gpointer v_object);
void value_take_database_table (GValue* value, gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
enum  {
	DATABASE_TABLE_DUMMY_PROPERTY
};
#define DATABASE_TABLE_SCHEMA_VERSION 20
static void database_table_prepare_db (const gchar* filename);
void app_window_panic (const gchar* msg);
#define DB_IN_MEMORY_NAME ":memory:"
void database_table_on_trace (const gchar* message);
static void _database_table_on_trace_sqlite_trace_callback (gpointer self, const gchar* message);
void database_table_init (const gchar* filename);
void database_table_warning (const gchar* op, gint res);
void database_table_terminate (void);
void database_table_fatal (const gchar* op, gint res);
void database_table_set_table_name (DatabaseTable* self, const gchar* table_name);
void database_table_throw_error (const gchar* method, gint res, GError** error);
gboolean database_table_exists_by_id (DatabaseTable* self, gint64 id);
gboolean database_table_select_by_id (DatabaseTable* self, gint64 id, const gchar* columns, sqlite3_stmt** stmt);
static void database_table_prepare_update_by_id (DatabaseTable* self, gint64 id, const gchar* column, sqlite3_stmt** stmt);
static gboolean database_table_execute_update_by_id (DatabaseTable* self, sqlite3_stmt* stmt);
gboolean database_table_update_text_by_id (DatabaseTable* self, gint64 id, const gchar* column, const gchar* text);
void database_table_update_text_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, const gchar* text, GError** error);
gboolean database_table_update_int_by_id (DatabaseTable* self, gint64 id, const gchar* column, gint value);
void database_table_update_int_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, gint value, GError** error);
gboolean database_table_update_int64_by_id (DatabaseTable* self, gint64 id, const gchar* column, gint64 value);
void database_table_update_int64_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, gint64 value, GError** error);
void database_table_delete_by_id (DatabaseTable* self, gint64 id, GError** error);
gboolean database_table_has_column (const gchar* table_name, const gchar* column_name);
gboolean database_table_has_table (const gchar* table_name);
gboolean database_table_add_column (const gchar* table_name, const gchar* column_name, const gchar* column_constraints);
gboolean database_table_ensure_column (const gchar* table_name, const gchar* column_name, const gchar* column_constraints, const gchar* upgrade_msg);
gint database_table_get_row_count (DatabaseTable* self);
void database_table_begin_transaction (void);
void database_table_commit_transaction (GError** error);
DatabaseTable* database_table_construct (GType object_type);
static void database_table_finalize (DatabaseTable* obj);


GQuark database_error_quark (void) {
	return g_quark_from_static_string ("database_error-quark");
}


static void _database_table_on_trace_sqlite_trace_callback (gpointer self, const gchar* message) {
#line 57 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_on_trace (message);
#line 127 "DatabaseTable.c"
}


static void database_table_prepare_db (const gchar* filename) {
	gint res = 0;
	const gchar* _tmp0_ = NULL;
	sqlite3* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	const gchar* _tmp9_ = NULL;
	const gchar* sql_debug = NULL;
	const gchar* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp28_ = NULL;
	GError * _inner_error_ = NULL;
#line 32 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (filename != NULL);
#line 34 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = filename;
#line 34 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = sqlite3_open_v2 (_tmp0_, &_tmp1_, SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE, NULL);
#line 34 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_close0 (database_table_db);
#line 34 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_db = _tmp1_;
#line 34 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp2_;
#line 36 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = res;
#line 36 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp3_ != SQLITE_OK) {
#line 159 "DatabaseTable.c"
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
#line 37 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp4_ = _ ("Unable to open/create photo database %s: error code %d");
#line 37 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp5_ = filename;
#line 37 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp6_ = res;
#line 37 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp7_ = g_strdup_printf (_tmp4_, _tmp5_, _tmp6_);
#line 37 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp8_ = _tmp7_;
#line 37 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		app_window_panic (_tmp8_);
#line 37 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp8_);
#line 179 "DatabaseTable.c"
	}
#line 41 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = filename;
#line 41 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (g_strcmp0 (_tmp9_, DB_IN_MEMORY_NAME) != 0) {
#line 185 "DatabaseTable.c"
		{
			GFile* file_db = NULL;
			const gchar* _tmp10_ = NULL;
			GFile* _tmp11_ = NULL;
			GFileInfo* info = NULL;
			GFile* _tmp12_ = NULL;
			GFileInfo* _tmp13_ = NULL;
			GFileInfo* _tmp14_ = NULL;
			gboolean _tmp15_ = FALSE;
#line 43 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp10_ = filename;
#line 43 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp11_ = g_file_new_for_path (_tmp10_);
#line 43 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			file_db = _tmp11_;
#line 44 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp12_ = file_db;
#line 44 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp13_ = g_file_query_info (_tmp12_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 44 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			info = _tmp13_;
#line 44 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 44 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_object_unref0 (file_db);
#line 211 "DatabaseTable.c"
				goto __catch13_g_error;
			}
#line 45 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp14_ = info;
#line 45 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp15_ = g_file_info_get_attribute_boolean (_tmp14_, G_FILE_ATTRIBUTE_ACCESS_CAN_WRITE);
#line 45 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (!_tmp15_) {
#line 220 "DatabaseTable.c"
				const gchar* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
#line 46 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_tmp16_ = _ ("Unable to write to photo database file:\n %s");
#line 46 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_tmp17_ = filename;
#line 46 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_tmp18_ = g_strdup_printf (_tmp16_, _tmp17_);
#line 46 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_tmp19_ = _tmp18_;
#line 46 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				app_window_panic (_tmp19_);
#line 46 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (_tmp19_);
#line 237 "DatabaseTable.c"
			}
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_object_unref0 (info);
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_object_unref0 (file_db);
#line 243 "DatabaseTable.c"
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			GError* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			e = _inner_error_;
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_inner_error_ = NULL;
#line 48 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp20_ = _ ("Error accessing database file:\n %s\n\nError was: \n%s");
#line 48 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp21_ = filename;
#line 48 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp22_ = e;
#line 48 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp23_ = _tmp22_->message;
#line 48 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp24_ = g_strdup_printf (_tmp20_, _tmp21_, _tmp23_);
#line 48 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp25_ = _tmp24_;
#line 48 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			app_window_panic (_tmp25_);
#line 48 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_free0 (_tmp25_);
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_error_free0 (e);
#line 277 "DatabaseTable.c"
		}
		__finally13:
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			g_clear_error (&_inner_error_);
#line 42 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			return;
#line 288 "DatabaseTable.c"
		}
	}
#line 53 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp26_ = g_getenv ("SHOTWELL_SQL_DEBUG");
#line 53 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	sql_debug = _tmp26_;
#line 56 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp28_ = sql_debug;
#line 56 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp28_ != NULL) {
#line 299 "DatabaseTable.c"
		const gchar* _tmp29_ = NULL;
#line 56 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp29_ = sql_debug;
#line 56 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp27_ = g_strcmp0 (_tmp29_, "") != 0;
#line 305 "DatabaseTable.c"
	} else {
#line 56 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp27_ = FALSE;
#line 309 "DatabaseTable.c"
	}
#line 56 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp27_) {
#line 313 "DatabaseTable.c"
		sqlite3* _tmp30_ = NULL;
#line 57 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp30_ = database_table_db;
#line 57 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		sqlite3_trace (_tmp30_, _database_table_on_trace_sqlite_trace_callback, NULL);
#line 319 "DatabaseTable.c"
	}
}


void database_table_on_trace (const gchar* message) {
	const gchar* _tmp0_ = NULL;
#line 61 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (message != NULL);
#line 62 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = message;
#line 62 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_debug ("DatabaseTable.vala:62: SQLITE: %s", _tmp0_);
#line 332 "DatabaseTable.c"
}


static gint _sqlite3_exec (sqlite3* self, const gchar* sql, sqlite3_callback callback, void* callback_target, gchar** errmsg) {
	gchar* _vala_errmsg = NULL;
	gint result = 0;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	sqlite3_callback _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	const gchar* _tmp6_ = NULL;
#line 34 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 34 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
	g_return_val_if_fail (sql != NULL, 0);
#line 36 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
	_tmp0_ = sql;
#line 36 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
	_tmp1_ = callback;
#line 36 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
	_tmp1__target = callback_target;
#line 36 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
	_tmp3_ = sqlite3_exec (self, _tmp0_, _tmp1_, _tmp1__target, (char**) (&_tmp2_));
#line 36 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
	sqlite_errmsg = _tmp2_;
#line 36 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
	ec = _tmp3_;
#line 37 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
	if ((&_vala_errmsg) != NULL) {
#line 365 "DatabaseTable.c"
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 38 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
		_tmp4_ = sqlite_errmsg;
#line 38 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
		_tmp5_ = g_strdup (_tmp4_);
#line 38 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 38 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
		_vala_errmsg = _tmp5_;
#line 376 "DatabaseTable.c"
	}
#line 40 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
	_tmp6_ = sqlite_errmsg;
#line 40 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
	sqlite3_free ((void*) _tmp6_);
#line 41 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
	result = ec;
#line 41 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
	if (errmsg) {
#line 41 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
		*errmsg = _vala_errmsg;
#line 388 "DatabaseTable.c"
	} else {
#line 41 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
		_g_free0 (_vala_errmsg);
#line 392 "DatabaseTable.c"
	}
#line 41 "/usr/share/vala-0.34/vapi/sqlite3.vapi"
	return result;
#line 396 "DatabaseTable.c"
}


void database_table_init (const gchar* filename) {
	const gchar* _tmp0_ = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	sqlite3* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	GError * _inner_error_ = NULL;
#line 65 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (filename != NULL);
#line 67 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = filename;
#line 67 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_prepare_db (_tmp0_);
#line 71 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = database_table_db;
#line 71 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = sqlite3_prepare_v2 (_tmp1_, "CREATE TABLE IF NOT EXISTS VersionTable (" "id INTEGER PRIMARY KEY, " "schema_version INTEGER, " "app_version TEXT, " "user_data TEXT NULL" ")", -1, &_tmp2_, NULL);
#line 71 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 71 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp2_;
#line 71 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp3_;
#line 79 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = res;
#line 79 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp4_ != SQLITE_OK) {
#line 432 "DatabaseTable.c"
		gchar* backup_path = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 80 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_sqlite3_close0 (database_table_db);
#line 80 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_db = NULL;
#line 82 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp5_ = filename;
#line 82 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp6_ = g_strconcat (_tmp5_, ".bak", NULL);
#line 82 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		backup_path = _tmp6_;
#line 446 "DatabaseTable.c"
		{
			GFile* src = NULL;
			const gchar* _tmp7_ = NULL;
			GFile* _tmp8_ = NULL;
			GFile* dest = NULL;
			const gchar* _tmp9_ = NULL;
			GFile* _tmp10_ = NULL;
			GFile* _tmp11_ = NULL;
			GFile* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
#line 85 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp7_ = backup_path;
#line 85 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp8_ = g_file_new_for_commandline_arg (_tmp7_);
#line 85 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			src = _tmp8_;
#line 86 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp9_ = filename;
#line 86 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp10_ = g_file_new_for_commandline_arg (_tmp9_);
#line 86 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			dest = _tmp10_;
#line 87 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp11_ = src;
#line 87 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp12_ = dest;
#line 87 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			g_file_copy (_tmp11_, _tmp12_, G_FILE_COPY_OVERWRITE | G_FILE_COPY_ALL_METADATA, NULL, NULL, NULL, &_inner_error_);
#line 87 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 87 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_object_unref0 (dest);
#line 87 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_object_unref0 (src);
#line 481 "DatabaseTable.c"
				goto __catch14_g_error;
			}
#line 90 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp13_ = filename;
#line 90 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			database_table_prepare_db (_tmp13_);
#line 84 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_object_unref0 (dest);
#line 84 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_object_unref0 (src);
#line 492 "DatabaseTable.c"
		}
		goto __finally14;
		__catch14_g_error:
		{
			GError* _error_ = NULL;
			const gchar* _tmp14_ = NULL;
			GError* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
#line 84 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_error_ = _inner_error_;
#line 84 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_inner_error_ = NULL;
#line 92 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp14_ = _ ("Unable to restore photo database %s");
#line 92 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp15_ = _error_;
#line 92 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp16_ = _tmp15_->message;
#line 92 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp17_ = g_strdup_printf (_tmp14_, _tmp16_);
#line 92 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp18_ = _tmp17_;
#line 92 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			app_window_panic (_tmp18_);
#line 92 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_free0 (_tmp18_);
#line 84 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_error_free0 (_error_);
#line 523 "DatabaseTable.c"
		}
		__finally14:
#line 84 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 84 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_free0 (backup_path);
#line 84 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_sqlite3_finalize0 (stmt);
#line 84 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 84 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			g_clear_error (&_inner_error_);
#line 84 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			return;
#line 538 "DatabaseTable.c"
		}
#line 79 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (backup_path);
#line 542 "DatabaseTable.c"
	}
#line 98 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp19_ = database_table_db;
#line 98 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp20_ = _sqlite3_exec (_tmp19_, "PRAGMA synchronous=OFF", NULL, NULL, NULL);
#line 98 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp20_;
#line 99 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp21_ = res;
#line 99 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp21_ != SQLITE_OK) {
#line 554 "DatabaseTable.c"
		gint _tmp22_ = 0;
#line 100 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp22_ = res;
#line 100 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_warning ("Unable to disable synchronous mode", _tmp22_);
#line 560 "DatabaseTable.c"
	}
#line 65 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 564 "DatabaseTable.c"
}


void database_table_terminate (void) {
#line 105 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_close0 (database_table_db);
#line 105 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_db = NULL;
#line 573 "DatabaseTable.c"
}


void database_table_fatal (const gchar* op, gint res) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	sqlite3* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 109 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (op != NULL);
#line 110 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = op;
#line 110 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = res;
#line 110 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = database_table_db;
#line 110 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = sqlite3_errmsg (_tmp2_);
#line 110 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_error ("DatabaseTable.vala:110: %s: [%d] %s", _tmp0_, _tmp1_, _tmp3_);
#line 594 "DatabaseTable.c"
}


void database_table_warning (const gchar* op, gint res) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	sqlite3* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 114 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (op != NULL);
#line 115 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = op;
#line 115 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = res;
#line 115 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = database_table_db;
#line 115 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = sqlite3_errmsg (_tmp2_);
#line 115 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_warning ("DatabaseTable.vala:115: %s: [%d] %s", _tmp0_, _tmp1_, _tmp3_);
#line 615 "DatabaseTable.c"
}


void database_table_set_table_name (DatabaseTable* self, const gchar* table_name) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 118 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (IS_DATABASE_TABLE (self));
#line 118 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (table_name != NULL);
#line 119 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = table_name;
#line 119 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 119 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (self->table_name);
#line 119 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	self->table_name = _tmp1_;
#line 634 "DatabaseTable.c"
}


void database_table_throw_error (const gchar* method, gint res, GError** error) {
	gchar* msg = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	sqlite3* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	GError * _inner_error_ = NULL;
#line 124 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (method != NULL);
#line 125 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = method;
#line 125 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = res;
#line 125 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = database_table_db;
#line 125 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = sqlite3_errmsg (_tmp2_);
#line 125 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = g_strdup_printf ("(%s) [%d] - %s", _tmp0_, _tmp1_, _tmp3_);
#line 125 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	msg = _tmp4_;
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = res;
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	switch (_tmp5_) {
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_OK:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_DONE:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_ROW:
#line 671 "DatabaseTable.c"
		{
#line 131 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_g_free0 (msg);
#line 131 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			return;
#line 677 "DatabaseTable.c"
		}
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_PERM:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_BUSY:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_READONLY:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_IOERR:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_CORRUPT:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_CANTOPEN:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_NOLFS:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_AUTH:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_FORMAT:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_NOTADB:
#line 699 "DatabaseTable.c"
		{
			const gchar* _tmp6_ = NULL;
			GError* _tmp7_ = NULL;
#line 143 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp6_ = msg;
#line 143 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp7_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_BACKING, _tmp6_);
#line 143 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_inner_error_ = _tmp7_;
#line 143 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 143 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 143 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 143 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 717 "DatabaseTable.c"
			} else {
#line 143 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 143 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 143 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 143 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 727 "DatabaseTable.c"
			}
		}
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_NOMEM:
#line 732 "DatabaseTable.c"
		{
			const gchar* _tmp8_ = NULL;
			GError* _tmp9_ = NULL;
#line 146 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp8_ = msg;
#line 146 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp9_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_MEMORY, _tmp8_);
#line 146 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_inner_error_ = _tmp9_;
#line 146 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 146 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 146 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 146 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 750 "DatabaseTable.c"
			} else {
#line 146 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 146 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 146 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 146 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 760 "DatabaseTable.c"
			}
		}
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_ABORT:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_LOCKED:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_INTERRUPT:
#line 769 "DatabaseTable.c"
		{
			const gchar* _tmp10_ = NULL;
			GError* _tmp11_ = NULL;
#line 151 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp10_ = msg;
#line 151 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp11_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_ABORT, _tmp10_);
#line 151 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_inner_error_ = _tmp11_;
#line 151 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 151 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 151 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 151 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 787 "DatabaseTable.c"
			} else {
#line 151 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 151 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 151 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 151 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 797 "DatabaseTable.c"
			}
		}
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_FULL:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_EMPTY:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_TOOBIG:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_CONSTRAINT:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_RANGE:
#line 810 "DatabaseTable.c"
		{
			const gchar* _tmp12_ = NULL;
			GError* _tmp13_ = NULL;
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp12_ = msg;
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp13_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_LIMITS, _tmp12_);
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_inner_error_ = _tmp13_;
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 828 "DatabaseTable.c"
			} else {
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 158 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 838 "DatabaseTable.c"
			}
		}
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_SCHEMA:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_MISMATCH:
#line 845 "DatabaseTable.c"
		{
			const gchar* _tmp14_ = NULL;
			GError* _tmp15_ = NULL;
#line 162 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp14_ = msg;
#line 162 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp15_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_TYPESPEC, _tmp14_);
#line 162 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_inner_error_ = _tmp15_;
#line 162 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 162 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 162 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 162 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 863 "DatabaseTable.c"
			} else {
#line 162 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 162 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 162 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 162 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 873 "DatabaseTable.c"
			}
		}
		default:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_ERROR:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_INTERNAL:
#line 127 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		case SQLITE_MISUSE:
#line 883 "DatabaseTable.c"
		{
			const gchar* _tmp16_ = NULL;
			GError* _tmp17_ = NULL;
#line 168 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp16_ = msg;
#line 168 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp17_ = g_error_new_literal (DATABASE_ERROR, DATABASE_ERROR_ERROR, _tmp16_);
#line 168 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_inner_error_ = _tmp17_;
#line 168 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 168 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 168 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 168 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 901 "DatabaseTable.c"
			} else {
#line 168 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_g_free0 (msg);
#line 168 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 168 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 168 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 911 "DatabaseTable.c"
			}
		}
	}
#line 124 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (msg);
#line 917 "DatabaseTable.c"
}


gboolean database_table_exists_by_id (DatabaseTable* self, gint64 id) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	sqlite3_stmt* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_ = 0;
	gint _tmp24_ = 0;
#line 172 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
#line 174 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 174 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = self->table_name;
#line 174 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = g_strdup_printf ("SELECT id FROM %s WHERE id=?", _tmp1_);
#line 174 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = _tmp2_;
#line 174 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = sqlite3_prepare_v2 (_tmp0_, _tmp3_, -1, &_tmp4_, NULL);
#line 174 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 174 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp4_;
#line 174 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = _tmp5_;
#line 174 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (_tmp3_);
#line 174 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp6_;
#line 175 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = res;
#line 175 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 177 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = stmt;
#line 177 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = id;
#line 177 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp10_ = sqlite3_bind_int64 (_tmp8_, 1, _tmp9_);
#line 177 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp10_;
#line 178 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp11_ = res;
#line 178 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 180 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp12_ = stmt;
#line 180 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp13_ = sqlite3_step (_tmp12_);
#line 180 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp13_;
#line 181 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp15_ = res;
#line 181 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp15_ != SQLITE_ROW) {
#line 990 "DatabaseTable.c"
		gint _tmp16_ = 0;
#line 181 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp16_ = res;
#line 181 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = _tmp16_ != SQLITE_DONE;
#line 996 "DatabaseTable.c"
	} else {
#line 181 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = FALSE;
#line 1000 "DatabaseTable.c"
	}
#line 181 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp14_) {
#line 1004 "DatabaseTable.c"
		gint64 _tmp17_ = 0LL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gint _tmp23_ = 0;
#line 182 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp17_ = id;
#line 182 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp18_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp17_);
#line 182 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp19_ = _tmp18_;
#line 182 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp20_ = self->table_name;
#line 182 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp21_ = g_strdup_printf ("exists_by_id [%s] %s", _tmp19_, _tmp20_);
#line 182 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp22_ = _tmp21_;
#line 182 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp23_ = res;
#line 182 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_fatal (_tmp22_, _tmp23_);
#line 182 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp22_);
#line 182 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp19_);
#line 1032 "DatabaseTable.c"
	}
#line 184 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp24_ = res;
#line 184 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = _tmp24_ == SQLITE_ROW;
#line 184 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 184 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 1042 "DatabaseTable.c"
}


gboolean database_table_select_by_id (DatabaseTable* self, gint64 id, const gchar* columns, sqlite3_stmt** stmt) {
	sqlite3_stmt* _vala_stmt = NULL;
	gboolean result = FALSE;
	gchar* sql = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint res = 0;
	sqlite3* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	sqlite3_stmt* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	sqlite3_stmt* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_ = 0;
	gint _tmp25_ = 0;
#line 187 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
#line 187 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (columns != NULL, FALSE);
#line 188 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = columns;
#line 188 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = self->table_name;
#line 188 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = g_strdup_printf ("SELECT %s FROM %s WHERE id=?", _tmp0_, _tmp1_);
#line 188 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	sql = _tmp2_;
#line 190 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = database_table_db;
#line 190 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = sql;
#line 190 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = sqlite3_prepare_v2 (_tmp3_, _tmp4_, -1, &_tmp5_, NULL);
#line 190 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (_vala_stmt);
#line 190 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_stmt = _tmp5_;
#line 190 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp6_;
#line 191 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = res;
#line 191 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 193 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = _vala_stmt;
#line 193 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = id;
#line 193 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp10_ = sqlite3_bind_int64 (_tmp8_, 1, _tmp9_);
#line 193 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp10_;
#line 194 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp11_ = res;
#line 194 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 196 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp12_ = _vala_stmt;
#line 196 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp13_ = sqlite3_step (_tmp12_);
#line 196 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp13_;
#line 197 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp15_ = res;
#line 197 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp15_ != SQLITE_ROW) {
#line 1118 "DatabaseTable.c"
		gint _tmp16_ = 0;
#line 197 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp16_ = res;
#line 197 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = _tmp16_ != SQLITE_DONE;
#line 1124 "DatabaseTable.c"
	} else {
#line 197 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = FALSE;
#line 1128 "DatabaseTable.c"
	}
#line 197 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp14_) {
#line 1132 "DatabaseTable.c"
		gint64 _tmp17_ = 0LL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gint _tmp24_ = 0;
#line 198 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp17_ = id;
#line 198 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp18_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp17_);
#line 198 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp19_ = _tmp18_;
#line 198 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp20_ = self->table_name;
#line 198 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp21_ = columns;
#line 198 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp22_ = g_strdup_printf ("select_by_id [%s] %s %s", _tmp19_, _tmp20_, _tmp21_);
#line 198 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp23_ = _tmp22_;
#line 198 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp24_ = res;
#line 198 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_fatal (_tmp23_, _tmp24_);
#line 198 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp23_);
#line 198 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp19_);
#line 1163 "DatabaseTable.c"
	}
#line 200 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp25_ = res;
#line 200 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = _tmp25_ == SQLITE_ROW;
#line 200 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (sql);
#line 200 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (stmt) {
#line 200 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		*stmt = _vala_stmt;
#line 1175 "DatabaseTable.c"
	} else {
#line 200 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_sqlite3_finalize0 (_vala_stmt);
#line 1179 "DatabaseTable.c"
	}
#line 200 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 1183 "DatabaseTable.c"
}


static void database_table_prepare_update_by_id (DatabaseTable* self, gint64 id, const gchar* column, sqlite3_stmt** stmt) {
	sqlite3_stmt* _vala_stmt = NULL;
	gchar* sql = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint res = 0;
	sqlite3* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint64 _tmp7_ = 0LL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
#line 204 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (IS_DATABASE_TABLE (self));
#line 204 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (column != NULL);
#line 205 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = self->table_name;
#line 205 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = column;
#line 205 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = g_strdup_printf ("UPDATE %s SET %s=? WHERE id=?", _tmp0_, _tmp1_);
#line 205 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	sql = _tmp2_;
#line 207 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = database_table_db;
#line 207 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = sqlite3_prepare_v2 (_tmp3_, sql, -1, &_tmp4_, NULL);
#line 207 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (_vala_stmt);
#line 207 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_stmt = _tmp4_;
#line 207 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp5_;
#line 208 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = res;
#line 208 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp6_ == SQLITE_OK, "res == Sqlite.OK");
#line 210 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = id;
#line 210 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = sqlite3_bind_int64 (_vala_stmt, 2, _tmp7_);
#line 210 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp8_;
#line 211 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = res;
#line 211 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp9_ == SQLITE_OK, "res == Sqlite.OK");
#line 204 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (sql);
#line 204 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (stmt) {
#line 204 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		*stmt = _vala_stmt;
#line 1243 "DatabaseTable.c"
	} else {
#line 204 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_sqlite3_finalize0 (_vala_stmt);
#line 1247 "DatabaseTable.c"
	}
}


static gboolean database_table_execute_update_by_id (DatabaseTable* self, sqlite3_stmt* stmt) {
	gboolean result = FALSE;
	gint res = 0;
	sqlite3_stmt* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 214 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
#line 214 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (stmt != NULL, FALSE);
#line 215 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = stmt;
#line 215 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = sqlite3_step (_tmp0_);
#line 215 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp1_;
#line 216 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = res;
#line 216 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp2_ != SQLITE_DONE) {
#line 1272 "DatabaseTable.c"
		gint _tmp3_ = 0;
#line 217 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp3_ = res;
#line 217 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_fatal ("execute_update_by_id", _tmp3_);
#line 219 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		result = FALSE;
#line 219 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		return result;
#line 1282 "DatabaseTable.c"
	}
#line 222 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = TRUE;
#line 222 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 1288 "DatabaseTable.c"
}


gboolean database_table_update_text_by_id (DatabaseTable* self, gint64 id, const gchar* column, const gchar* text) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint res = 0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GDestroyNotify _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
#line 225 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
#line 225 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (column != NULL, FALSE);
#line 225 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (text != NULL, FALSE);
#line 227 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = id;
#line 227 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = column;
#line 227 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, _tmp0_, _tmp1_, &_tmp2_);
#line 227 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 227 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp2_;
#line 229 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = text;
#line 229 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 229 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = g_free;
#line 229 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = sqlite3_bind_text (stmt, 1, _tmp4_, -1, _tmp5_);
#line 229 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp6_;
#line 230 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 232 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = database_table_execute_update_by_id (self, stmt);
#line 232 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = _tmp7_;
#line 232 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 232 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 1340 "DatabaseTable.c"
}


void database_table_update_text_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, const gchar* text, GError** error) {
	sqlite3_stmt* stmt = NULL;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint res = 0;
	sqlite3_stmt* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GDestroyNotify _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GError * _inner_error_ = NULL;
#line 235 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (IS_DATABASE_TABLE (self));
#line 235 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (column != NULL);
#line 235 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (text != NULL);
#line 237 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = id;
#line 237 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = column;
#line 237 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, _tmp0_, _tmp1_, &_tmp2_);
#line 237 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 237 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp2_;
#line 239 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = stmt;
#line 239 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = text;
#line 239 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 239 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = g_free;
#line 239 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = sqlite3_bind_text (_tmp3_, 1, _tmp5_, -1, _tmp6_);
#line 239 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp7_;
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = res;
#line 240 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 242 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = stmt;
#line 242 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp10_ = sqlite3_step (_tmp9_);
#line 242 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp10_;
#line 243 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp11_ = res;
#line 243 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp11_ != SQLITE_DONE) {
#line 1402 "DatabaseTable.c"
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gint _tmp16_ = 0;
#line 244 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp12_ = self->table_name;
#line 244 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp13_ = column;
#line 244 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = g_strdup_printf ("DatabaseTable.update_text_by_id_2 %s.%s", _tmp12_, _tmp13_);
#line 244 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp15_ = _tmp14_;
#line 244 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp16_ = res;
#line 244 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_throw_error (_tmp15_, _tmp16_, &_inner_error_);
#line 244 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp15_);
#line 244 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 244 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 244 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 244 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 244 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 1432 "DatabaseTable.c"
			} else {
#line 244 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 244 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 244 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 244 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 1442 "DatabaseTable.c"
			}
		}
	}
#line 235 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1448 "DatabaseTable.c"
}


gboolean database_table_update_int_by_id (DatabaseTable* self, gint64 id, const gchar* column, gint value) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint res = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
#line 247 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
#line 247 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (column != NULL, FALSE);
#line 249 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = id;
#line 249 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = column;
#line 249 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, _tmp0_, _tmp1_, &_tmp2_);
#line 249 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 249 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp2_;
#line 251 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = value;
#line 251 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = sqlite3_bind_int (stmt, 1, _tmp3_);
#line 251 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp4_;
#line 252 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 254 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = database_table_execute_update_by_id (self, stmt);
#line 254 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = _tmp5_;
#line 254 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 254 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 1492 "DatabaseTable.c"
}


void database_table_update_int_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, gint value, GError** error) {
	sqlite3_stmt* stmt = NULL;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint res = 0;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	sqlite3_stmt* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GError * _inner_error_ = NULL;
#line 257 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (IS_DATABASE_TABLE (self));
#line 257 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (column != NULL);
#line 259 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = id;
#line 259 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = column;
#line 259 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, _tmp0_, _tmp1_, &_tmp2_);
#line 259 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 259 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp2_;
#line 261 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = stmt;
#line 261 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = value;
#line 261 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = sqlite3_bind_int (_tmp3_, 1, _tmp4_);
#line 261 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp5_;
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = res;
#line 262 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp6_ == SQLITE_OK, "res == Sqlite.OK");
#line 264 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = stmt;
#line 264 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = sqlite3_step (_tmp7_);
#line 264 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp8_;
#line 265 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = res;
#line 265 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp9_ != SQLITE_DONE) {
#line 1546 "DatabaseTable.c"
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
#line 266 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp10_ = self->table_name;
#line 266 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp11_ = column;
#line 266 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp12_ = g_strdup_printf ("DatabaseTable.update_int_by_id_2 %s.%s", _tmp10_, _tmp11_);
#line 266 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp13_ = _tmp12_;
#line 266 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = res;
#line 266 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_throw_error (_tmp13_, _tmp14_, &_inner_error_);
#line 266 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp13_);
#line 266 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 266 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 266 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 266 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 266 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 1576 "DatabaseTable.c"
			} else {
#line 266 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 266 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 266 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 266 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 1586 "DatabaseTable.c"
			}
		}
	}
#line 257 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1592 "DatabaseTable.c"
}


gboolean database_table_update_int64_by_id (DatabaseTable* self, gint64 id, const gchar* column, gint64 value) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint res = 0;
	gint64 _tmp3_ = 0LL;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
#line 269 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (IS_DATABASE_TABLE (self), FALSE);
#line 269 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (column != NULL, FALSE);
#line 271 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = id;
#line 271 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = column;
#line 271 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, _tmp0_, _tmp1_, &_tmp2_);
#line 271 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 271 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp2_;
#line 273 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = value;
#line 273 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = sqlite3_bind_int64 (stmt, 1, _tmp3_);
#line 273 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp4_;
#line 274 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
#line 276 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = database_table_execute_update_by_id (self, stmt);
#line 276 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = _tmp5_;
#line 276 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 276 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 1636 "DatabaseTable.c"
}


void database_table_update_int64_by_id_2 (DatabaseTable* self, gint64 id, const gchar* column, gint64 value, GError** error) {
	sqlite3_stmt* stmt = NULL;
	gint64 _tmp0_ = 0LL;
	const gchar* _tmp1_ = NULL;
	sqlite3_stmt* _tmp2_ = NULL;
	gint res = 0;
	sqlite3_stmt* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	sqlite3_stmt* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	GError * _inner_error_ = NULL;
#line 279 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (IS_DATABASE_TABLE (self));
#line 279 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (column != NULL);
#line 281 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = id;
#line 281 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = column;
#line 281 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_prepare_update_by_id (self, _tmp0_, _tmp1_, &_tmp2_);
#line 281 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 281 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp2_;
#line 283 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = stmt;
#line 283 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = value;
#line 283 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = sqlite3_bind_int64 (_tmp3_, 1, _tmp4_);
#line 283 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp5_;
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = res;
#line 284 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp6_ == SQLITE_OK, "res == Sqlite.OK");
#line 286 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = stmt;
#line 286 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = sqlite3_step (_tmp7_);
#line 286 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp8_;
#line 287 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = res;
#line 287 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp9_ != SQLITE_DONE) {
#line 1690 "DatabaseTable.c"
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
#line 288 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp10_ = self->table_name;
#line 288 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp11_ = column;
#line 288 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp12_ = g_strdup_printf ("DatabaseTable.update_int64_by_id_2 %s.%s", _tmp10_, _tmp11_);
#line 288 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp13_ = _tmp12_;
#line 288 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = res;
#line 288 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_throw_error (_tmp13_, _tmp14_, &_inner_error_);
#line 288 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp13_);
#line 288 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 288 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 288 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 288 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 288 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 1720 "DatabaseTable.c"
			} else {
#line 288 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 288 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 288 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 288 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 1730 "DatabaseTable.c"
			}
		}
	}
#line 279 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1736 "DatabaseTable.c"
}


void database_table_delete_by_id (DatabaseTable* self, gint64 id, GError** error) {
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	sqlite3_stmt* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	sqlite3_stmt* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	GError * _inner_error_ = NULL;
#line 291 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (IS_DATABASE_TABLE (self));
#line 293 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 293 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = self->table_name;
#line 293 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = g_strdup_printf ("DELETE FROM %s WHERE id=?", _tmp1_);
#line 293 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = _tmp2_;
#line 293 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = sqlite3_prepare_v2 (_tmp0_, _tmp3_, -1, &_tmp4_, NULL);
#line 293 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 293 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp4_;
#line 293 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = _tmp5_;
#line 293 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (_tmp3_);
#line 293 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp6_;
#line 294 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = res;
#line 294 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 296 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = stmt;
#line 296 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = id;
#line 296 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp10_ = sqlite3_bind_int64 (_tmp8_, 1, _tmp9_);
#line 296 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp10_;
#line 297 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp11_ = res;
#line 297 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 299 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp12_ = stmt;
#line 299 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp13_ = sqlite3_step (_tmp12_);
#line 299 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp13_;
#line 300 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp14_ = res;
#line 300 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp14_ != SQLITE_DONE) {
#line 1807 "DatabaseTable.c"
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gint _tmp18_ = 0;
#line 301 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp15_ = self->table_name;
#line 301 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp16_ = g_strdup_printf ("%s.remove", _tmp15_);
#line 301 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp17_ = _tmp16_;
#line 301 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp18_ = res;
#line 301 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_throw_error (_tmp17_, _tmp18_, &_inner_error_);
#line 301 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_g_free0 (_tmp17_);
#line 301 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 301 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 301 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 301 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 301 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 1834 "DatabaseTable.c"
			} else {
#line 301 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_sqlite3_finalize0 (stmt);
#line 301 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 301 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 301 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 1844 "DatabaseTable.c"
			}
		}
	}
#line 291 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1850 "DatabaseTable.c"
}


gboolean database_table_has_column (const gchar* table_name, const gchar* column_name) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 304 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (table_name != NULL, FALSE);
#line 304 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (column_name != NULL, FALSE);
#line 306 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 306 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = table_name;
#line 306 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = g_strdup_printf ("PRAGMA table_info(%s)", _tmp1_);
#line 306 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = _tmp2_;
#line 306 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = sqlite3_prepare_v2 (_tmp0_, _tmp3_, -1, &_tmp4_, NULL);
#line 306 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 306 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp4_;
#line 306 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = _tmp5_;
#line 306 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (_tmp3_);
#line 306 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp6_;
#line 307 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = res;
#line 307 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 1894 "DatabaseTable.c"
	{
		gboolean _tmp8_ = FALSE;
#line 309 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp8_ = TRUE;
#line 309 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		while (TRUE) {
#line 1901 "DatabaseTable.c"
			sqlite3_stmt* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
#line 309 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (!_tmp8_) {
#line 1907 "DatabaseTable.c"
			}
#line 309 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp8_ = FALSE;
#line 310 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp9_ = stmt;
#line 310 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp10_ = sqlite3_step (_tmp9_);
#line 310 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			res = _tmp10_;
#line 311 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			_tmp11_ = res;
#line 311 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_tmp11_ == SQLITE_DONE) {
#line 312 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				break;
#line 1923 "DatabaseTable.c"
			} else {
				gint _tmp12_ = 0;
#line 313 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				_tmp12_ = res;
#line 313 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				if (_tmp12_ != SQLITE_ROW) {
#line 1930 "DatabaseTable.c"
					const gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					gint _tmp16_ = 0;
#line 314 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_tmp13_ = table_name;
#line 314 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_tmp14_ = g_strdup_printf ("has_column %s", _tmp13_);
#line 314 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_tmp15_ = _tmp14_;
#line 314 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_tmp16_ = res;
#line 314 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					database_table_fatal (_tmp15_, _tmp16_);
#line 314 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_g_free0 (_tmp15_);
#line 316 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					break;
#line 1949 "DatabaseTable.c"
				} else {
					gchar* column = NULL;
					sqlite3_stmt* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					gboolean _tmp20_ = FALSE;
					const gchar* _tmp21_ = NULL;
#line 318 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_tmp17_ = stmt;
#line 318 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_tmp18_ = sqlite3_column_text (_tmp17_, 1);
#line 318 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_tmp19_ = g_strdup (_tmp18_);
#line 318 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					column = _tmp19_;
#line 319 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_tmp21_ = column;
#line 319 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					if (_tmp21_ != NULL) {
#line 1969 "DatabaseTable.c"
						const gchar* _tmp22_ = NULL;
						const gchar* _tmp23_ = NULL;
#line 319 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
						_tmp22_ = column;
#line 319 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
						_tmp23_ = column_name;
#line 319 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
						_tmp20_ = g_strcmp0 (_tmp22_, _tmp23_) == 0;
#line 1978 "DatabaseTable.c"
					} else {
#line 319 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
						_tmp20_ = FALSE;
#line 1982 "DatabaseTable.c"
					}
#line 319 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					if (_tmp20_) {
#line 320 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
						result = TRUE;
#line 320 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
						_g_free0 (column);
#line 320 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
						_sqlite3_finalize0 (stmt);
#line 320 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
						return result;
#line 1994 "DatabaseTable.c"
					}
#line 313 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
					_g_free0 (column);
#line 1998 "DatabaseTable.c"
				}
			}
		}
	}
#line 324 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = FALSE;
#line 324 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 324 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 2009 "DatabaseTable.c"
}


gboolean database_table_has_table (const gchar* table_name) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
#line 327 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (table_name != NULL, FALSE);
#line 329 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 329 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = table_name;
#line 329 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = g_strdup_printf ("PRAGMA table_info(%s)", _tmp1_);
#line 329 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = _tmp2_;
#line 329 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = sqlite3_prepare_v2 (_tmp0_, _tmp3_, -1, &_tmp4_, NULL);
#line 329 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 329 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp4_;
#line 329 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = _tmp5_;
#line 329 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (_tmp3_);
#line 329 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp6_;
#line 330 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = res;
#line 330 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 332 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = sqlite3_step (stmt);
#line 332 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp8_;
#line 334 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = res;
#line 334 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = _tmp9_ != SQLITE_DONE;
#line 334 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 334 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 2065 "DatabaseTable.c"
}


gboolean database_table_add_column (const gchar* table_name, const gchar* column_name, const gchar* column_constraints) {
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	sqlite3_stmt* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	sqlite3_stmt* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
#line 337 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (table_name != NULL, FALSE);
#line 337 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (column_name != NULL, FALSE);
#line 337 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (column_constraints != NULL, FALSE);
#line 339 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 339 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = table_name;
#line 339 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = column_name;
#line 339 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = column_constraints;
#line 339 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = g_strdup_printf ("ALTER TABLE %s ADD COLUMN %s %s", _tmp1_, _tmp2_, _tmp3_);
#line 339 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = _tmp4_;
#line 339 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = sqlite3_prepare_v2 (_tmp0_, _tmp5_, -1, &_tmp6_, NULL);
#line 339 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 339 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp6_;
#line 339 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = _tmp7_;
#line 339 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (_tmp5_);
#line 339 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp8_;
#line 341 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = res;
#line 341 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp9_ == SQLITE_OK, "res == Sqlite.OK");
#line 343 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp10_ = stmt;
#line 343 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp11_ = sqlite3_step (_tmp10_);
#line 343 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp11_;
#line 344 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp12_ = res;
#line 344 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp12_ != SQLITE_DONE) {
#line 2130 "DatabaseTable.c"
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		sqlite3* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
#line 345 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp13_ = table_name;
#line 345 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = column_name;
#line 345 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp15_ = column_constraints;
#line 345 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp16_ = res;
#line 345 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp17_ = database_table_db;
#line 345 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp18_ = sqlite3_errmsg (_tmp17_);
#line 345 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		g_critical ("DatabaseTable.vala:345: Unable to add column %s %s %s: (%d) %s", _tmp13_, _tmp14_, _tmp15_, _tmp16_, _tmp18_);
#line 348 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		result = FALSE;
#line 348 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_sqlite3_finalize0 (stmt);
#line 348 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		return result;
#line 2157 "DatabaseTable.c"
	}
#line 351 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = TRUE;
#line 351 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 351 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 2165 "DatabaseTable.c"
}


gboolean database_table_ensure_column (const gchar* table_name, const gchar* column_name, const gchar* column_constraints, const gchar* upgrade_msg) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
#line 357 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (table_name != NULL, FALSE);
#line 357 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (column_name != NULL, FALSE);
#line 357 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (column_constraints != NULL, FALSE);
#line 357 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (upgrade_msg != NULL, FALSE);
#line 359 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = table_name;
#line 359 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = database_table_has_table (_tmp1_);
#line 359 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (!_tmp2_) {
#line 359 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp0_ = TRUE;
#line 2195 "DatabaseTable.c"
	} else {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 359 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp3_ = table_name;
#line 359 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp4_ = column_name;
#line 359 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp5_ = database_table_has_column (_tmp3_, _tmp4_);
#line 359 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp0_ = _tmp5_;
#line 2208 "DatabaseTable.c"
	}
#line 359 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp0_) {
#line 360 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		result = TRUE;
#line 360 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		return result;
#line 2216 "DatabaseTable.c"
	}
#line 362 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = upgrade_msg;
#line 362 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_message ("DatabaseTable.vala:362: %s", _tmp6_);
#line 364 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = table_name;
#line 364 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = column_name;
#line 364 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = column_constraints;
#line 364 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp10_ = database_table_add_column (_tmp7_, _tmp8_, _tmp9_);
#line 364 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = _tmp10_;
#line 364 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 2234 "DatabaseTable.c"
}


gint database_table_get_row_count (DatabaseTable* self) {
	gint result = 0;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	sqlite3_stmt* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	sqlite3_stmt* _tmp15_ = NULL;
	gint _tmp16_ = 0;
#line 367 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (IS_DATABASE_TABLE (self), 0);
#line 369 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = database_table_db;
#line 369 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = self->table_name;
#line 369 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = g_strdup_printf ("SELECT COUNT(id) AS RowCount FROM %s", _tmp1_);
#line 369 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = _tmp2_;
#line 369 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = sqlite3_prepare_v2 (_tmp0_, _tmp3_, -1, &_tmp4_, NULL);
#line 369 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 369 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	stmt = _tmp4_;
#line 369 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp6_ = _tmp5_;
#line 369 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (_tmp3_);
#line 369 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp6_;
#line 370 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp7_ = res;
#line 370 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 372 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp8_ = stmt;
#line 372 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp9_ = sqlite3_step (_tmp8_);
#line 372 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp9_;
#line 373 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp10_ = res;
#line 373 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp10_ != SQLITE_ROW) {
#line 2291 "DatabaseTable.c"
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		sqlite3* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 374 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp11_ = self->table_name;
#line 374 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp12_ = res;
#line 374 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp13_ = database_table_db;
#line 374 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp14_ = sqlite3_errmsg (_tmp13_);
#line 374 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		g_critical ("DatabaseTable.vala:374: Unable to retrieve row count on %s: (%d) %s", _tmp11_, _tmp12_, _tmp14_);
#line 376 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		result = 0;
#line 376 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_sqlite3_finalize0 (stmt);
#line 376 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		return result;
#line 2312 "DatabaseTable.c"
	}
#line 379 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp15_ = stmt;
#line 379 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp16_ = sqlite3_column_int (_tmp15_, 0);
#line 379 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	result = _tmp16_;
#line 379 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_sqlite3_finalize0 (stmt);
#line 379 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return result;
#line 2324 "DatabaseTable.c"
}


void database_table_begin_transaction (void) {
	gint _tmp0_ = 0;
	gint res = 0;
	sqlite3* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 384 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = database_table_in_transaction;
#line 384 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_in_transaction = _tmp0_ + 1;
#line 384 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp0_ != 0) {
#line 385 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		return;
#line 2342 "DatabaseTable.c"
	}
#line 387 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = database_table_db;
#line 387 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = _sqlite3_exec (_tmp1_, "BEGIN TRANSACTION", NULL, NULL, NULL);
#line 387 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp2_;
#line 388 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = res;
#line 388 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 2354 "DatabaseTable.c"
}


void database_table_commit_transaction (GError** error) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint res = 0;
	sqlite3* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GError * _inner_error_ = NULL;
#line 393 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp0_ = database_table_in_transaction;
#line 393 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_vala_assert (_tmp0_ > 0, "in_transaction > 0");
#line 394 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp1_ = database_table_in_transaction;
#line 394 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_in_transaction = _tmp1_ - 1;
#line 394 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp2_ = database_table_in_transaction;
#line 394 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp2_ != 0) {
#line 395 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		return;
#line 2381 "DatabaseTable.c"
	}
#line 397 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp3_ = database_table_db;
#line 397 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp4_ = _sqlite3_exec (_tmp3_, "COMMIT TRANSACTION", NULL, NULL, NULL);
#line 397 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	res = _tmp4_;
#line 398 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_tmp5_ = res;
#line 398 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (_tmp5_ != SQLITE_DONE) {
#line 2393 "DatabaseTable.c"
		gint _tmp6_ = 0;
#line 399 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		_tmp6_ = res;
#line 399 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_throw_error ("commit_transaction", _tmp6_, &_inner_error_);
#line 399 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 399 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 399 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_propagate_error (error, _inner_error_);
#line 399 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 2407 "DatabaseTable.c"
			} else {
#line 399 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 399 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				g_clear_error (&_inner_error_);
#line 399 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
				return;
#line 2415 "DatabaseTable.c"
			}
		}
	}
}


DatabaseTable* database_table_construct (GType object_type) {
	DatabaseTable* self = NULL;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	self = (DatabaseTable*) g_type_create_instance (object_type);
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return self;
#line 2428 "DatabaseTable.c"
}


static void value_database_table_init (GValue* value) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	value->data[0].v_pointer = NULL;
#line 2435 "DatabaseTable.c"
}


static void value_database_table_free_value (GValue* value) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (value->data[0].v_pointer) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_unref (value->data[0].v_pointer);
#line 2444 "DatabaseTable.c"
	}
}


static void value_database_table_copy_value (const GValue* src_value, GValue* dest_value) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (src_value->data[0].v_pointer) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		dest_value->data[0].v_pointer = database_table_ref (src_value->data[0].v_pointer);
#line 2454 "DatabaseTable.c"
	} else {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2458 "DatabaseTable.c"
	}
}


static gpointer value_database_table_peek_pointer (const GValue* value) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return value->data[0].v_pointer;
#line 2466 "DatabaseTable.c"
}


static gchar* value_database_table_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (collect_values[0].v_pointer) {
#line 2473 "DatabaseTable.c"
		DatabaseTable* object;
		object = collect_values[0].v_pointer;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		if (object->parent_instance.g_class == NULL) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2480 "DatabaseTable.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2484 "DatabaseTable.c"
		}
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		value->data[0].v_pointer = database_table_ref (object);
#line 2488 "DatabaseTable.c"
	} else {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		value->data[0].v_pointer = NULL;
#line 2492 "DatabaseTable.c"
	}
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return NULL;
#line 2496 "DatabaseTable.c"
}


static gchar* value_database_table_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DatabaseTable** object_p;
	object_p = collect_values[0].v_pointer;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (!object_p) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2507 "DatabaseTable.c"
	}
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (!value->data[0].v_pointer) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		*object_p = NULL;
#line 2513 "DatabaseTable.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		*object_p = value->data[0].v_pointer;
#line 2517 "DatabaseTable.c"
	} else {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		*object_p = database_table_ref (value->data[0].v_pointer);
#line 2521 "DatabaseTable.c"
	}
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return NULL;
#line 2525 "DatabaseTable.c"
}


GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecDatabaseTable* spec;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DATABASE_TABLE), NULL);
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return G_PARAM_SPEC (spec);
#line 2539 "DatabaseTable.c"
}


gpointer value_get_database_table (const GValue* value) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATABASE_TABLE), NULL);
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return value->data[0].v_pointer;
#line 2548 "DatabaseTable.c"
}


void value_set_database_table (GValue* value, gpointer v_object) {
	DatabaseTable* old;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATABASE_TABLE));
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	old = value->data[0].v_pointer;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (v_object) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATABASE_TABLE));
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		value->data[0].v_pointer = v_object;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_ref (value->data[0].v_pointer);
#line 2568 "DatabaseTable.c"
	} else {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		value->data[0].v_pointer = NULL;
#line 2572 "DatabaseTable.c"
	}
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (old) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_unref (old);
#line 2578 "DatabaseTable.c"
	}
}


void value_take_database_table (GValue* value, gpointer v_object) {
	DatabaseTable* old;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DATABASE_TABLE));
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	old = value->data[0].v_pointer;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (v_object) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DATABASE_TABLE));
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		value->data[0].v_pointer = v_object;
#line 2597 "DatabaseTable.c"
	} else {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		value->data[0].v_pointer = NULL;
#line 2601 "DatabaseTable.c"
	}
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (old) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		database_table_unref (old);
#line 2607 "DatabaseTable.c"
	}
}


static void database_table_class_init (DatabaseTableClass * klass) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	database_table_parent_class = g_type_class_peek_parent (klass);
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	((DatabaseTableClass *) klass)->finalize = database_table_finalize;
#line 2617 "DatabaseTable.c"
}


static void database_table_instance_init (DatabaseTable * self) {
#line 30 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	self->table_name = NULL;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	self->ref_count = 1;
#line 2626 "DatabaseTable.c"
}


static void database_table_finalize (DatabaseTable* obj) {
	DatabaseTable * self;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DATABASE_TABLE, DatabaseTable);
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_signal_handlers_destroy (self);
#line 30 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	_g_free0 (self->table_name);
#line 2638 "DatabaseTable.c"
}


GType database_table_get_type (void) {
	static volatile gsize database_table_type_id__volatile = 0;
	if (g_once_init_enter (&database_table_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_database_table_init, value_database_table_free_value, value_database_table_copy_value, value_database_table_peek_pointer, "p", value_database_table_collect_value, "p", value_database_table_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DatabaseTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) database_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DatabaseTable), 0, (GInstanceInitFunc) database_table_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType database_table_type_id;
		database_table_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DatabaseTable", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&database_table_type_id__volatile, database_table_type_id);
	}
	return database_table_type_id__volatile;
}


gpointer database_table_ref (gpointer instance) {
	DatabaseTable* self;
	self = instance;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	g_atomic_int_inc (&self->ref_count);
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	return instance;
#line 2663 "DatabaseTable.c"
}


void database_table_unref (gpointer instance) {
	DatabaseTable* self;
	self = instance;
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		DATABASE_TABLE_GET_CLASS (self)->finalize (self);
#line 16 "/home/jens/Source/shotwell/src/db/DatabaseTable.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2676 "DatabaseTable.c"
	}
}



