/* Config.c generated by valac 0.34.1, the Vala compiler
 * generated from Config.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* This file is the master unit file for the Config unit.  It should be edited to include
 * whatever code is deemed necessary.
 *
 * The init() and terminate() methods are mandatory.
 *
 * If the unit needs to be configured prior to initialization, add the proper parameters to
 * the preconfigure() method, implement it, and ensure in init() that it's been called.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;
typedef struct _ConfigurationFacadePrivate ConfigurationFacadePrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())

#define TYPE_FUZZY_PROPERTY_STATE (fuzzy_property_state_get_type ())

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
typedef struct _ConfigFacadePrivate ConfigFacadePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_GSETTINGS_CONFIGURATION_ENGINE (gsettings_configuration_engine_get_type ())
#define GSETTINGS_CONFIGURATION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GSETTINGS_CONFIGURATION_ENGINE, GSettingsConfigurationEngine))
#define GSETTINGS_CONFIGURATION_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GSETTINGS_CONFIGURATION_ENGINE, GSettingsConfigurationEngineClass))
#define IS_GSETTINGS_CONFIGURATION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GSETTINGS_CONFIGURATION_ENGINE))
#define IS_GSETTINGS_CONFIGURATION_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GSETTINGS_CONFIGURATION_ENGINE))
#define GSETTINGS_CONFIGURATION_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GSETTINGS_CONFIGURATION_ENGINE, GSettingsConfigurationEngineClass))

typedef struct _GSettingsConfigurationEngine GSettingsConfigurationEngine;
typedef struct _GSettingsConfigurationEngineClass GSettingsConfigurationEngineClass;

#define TYPE_CONFIGURATION_ENGINE (configuration_engine_get_type ())
#define CONFIGURATION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_ENGINE, ConfigurationEngine))
#define IS_CONFIGURATION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_ENGINE))
#define CONFIGURATION_ENGINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONFIGURATION_ENGINE, ConfigurationEngineIface))

typedef struct _ConfigurationEngine ConfigurationEngine;
typedef struct _ConfigurationEngineIface ConfigurationEngineIface;

#define TYPE_CONFIGURABLE_PROPERTY (configurable_property_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _Dimensions {
	gint width;
	gint height;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

typedef enum  {
	FUZZY_PROPERTY_STATE_ENABLED,
	FUZZY_PROPERTY_STATE_DISABLED,
	FUZZY_PROPERTY_STATE_UNKNOWN
} FuzzyPropertyState;

struct _ConfigurationFacade {
	GObject parent_instance;
	ConfigurationFacadePrivate * priv;
};

struct _ConfigurationFacadeClass {
	GObjectClass parent_class;
	gboolean (*get_auto_import_from_library) (ConfigurationFacade* self);
	void (*set_auto_import_from_library) (ConfigurationFacade* self, gboolean auto_import);
	gchar* (*get_bg_color_name) (ConfigurationFacade* self);
	void (*set_bg_color_name) (ConfigurationFacade* self, const gchar* color_name);
	gboolean (*get_commit_metadata_to_masters) (ConfigurationFacade* self);
	void (*set_commit_metadata_to_masters) (ConfigurationFacade* self, gboolean commit_metadata);
	gchar* (*get_desktop_background) (ConfigurationFacade* self);
	void (*set_desktop_background) (ConfigurationFacade* self, const gchar* filename);
	gchar* (*get_screensaver) (ConfigurationFacade* self);
	void (*set_screensaver) (ConfigurationFacade* self, const gchar* filename);
	gchar* (*get_directory_pattern) (ConfigurationFacade* self);
	void (*set_directory_pattern) (ConfigurationFacade* self, const gchar* s);
	gchar* (*get_directory_pattern_custom) (ConfigurationFacade* self);
	void (*set_directory_pattern_custom) (ConfigurationFacade* self, const gchar* s);
	void (*get_direct_window_state) (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
	void (*set_direct_window_state) (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
	gboolean (*get_display_basic_properties) (ConfigurationFacade* self);
	void (*set_display_basic_properties) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_extended_properties) (ConfigurationFacade* self);
	void (*set_display_extended_properties) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_sidebar) (ConfigurationFacade* self);
	void (*set_display_sidebar) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_toolbar) (ConfigurationFacade* self);
	void (*set_display_toolbar) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_search_bar) (ConfigurationFacade* self);
	void (*set_display_search_bar) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_ratings) (ConfigurationFacade* self);
	void (*set_display_photo_ratings) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_tags) (ConfigurationFacade* self);
	void (*set_display_photo_tags) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_titles) (ConfigurationFacade* self);
	void (*set_display_photo_titles) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_comments) (ConfigurationFacade* self);
	void (*set_display_photo_comments) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_event_comments) (ConfigurationFacade* self);
	void (*set_display_event_comments) (ConfigurationFacade* self, gboolean display);
	void (*get_event_photos_sort) (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
	void (*set_event_photos_sort) (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
	gboolean (*get_events_sort_ascending) (ConfigurationFacade* self);
	void (*set_events_sort_ascending) (ConfigurationFacade* self, gboolean sort);
	gchar* (*get_external_photo_app) (ConfigurationFacade* self);
	void (*set_external_photo_app) (ConfigurationFacade* self, const gchar* external_photo_app);
	gchar* (*get_external_raw_app) (ConfigurationFacade* self);
	void (*set_external_raw_app) (ConfigurationFacade* self, const gchar* external_raw_app);
	ScaleConstraint (*get_export_constraint) (ConfigurationFacade* self);
	void (*set_export_constraint) (ConfigurationFacade* self, ScaleConstraint constraint);
	ExportFormatMode (*get_export_export_format_mode) (ConfigurationFacade* self);
	void (*set_export_export_format_mode) (ConfigurationFacade* self, ExportFormatMode export_format_mode);
	gboolean (*get_export_export_metadata) (ConfigurationFacade* self);
	void (*set_export_export_metadata) (ConfigurationFacade* self, gboolean export_metadata);
	PhotoFileFormat (*get_export_photo_file_format) (ConfigurationFacade* self);
	void (*set_export_photo_file_format) (ConfigurationFacade* self, PhotoFileFormat photo_file_format);
	JpegQuality (*get_export_quality) (ConfigurationFacade* self);
	void (*set_export_quality) (ConfigurationFacade* self, JpegQuality quality);
	gint (*get_export_scale) (ConfigurationFacade* self);
	void (*set_export_scale) (ConfigurationFacade* self, gint scale);
	RawDeveloper (*get_default_raw_developer) (ConfigurationFacade* self);
	void (*set_default_raw_developer) (ConfigurationFacade* self, RawDeveloper d);
	gboolean (*get_hide_photos_already_imported) (ConfigurationFacade* self);
	void (*set_hide_photos_already_imported) (ConfigurationFacade* self, gboolean hide_imported);
	gchar* (*get_import_dir) (ConfigurationFacade* self);
	void (*set_import_dir) (ConfigurationFacade* self, const gchar* import_dir);
	gboolean (*get_keep_relativity) (ConfigurationFacade* self);
	void (*set_keep_relativity) (ConfigurationFacade* self, gboolean keep_relativity);
	gboolean (*get_pin_toolbar_state) (ConfigurationFacade* self);
	void (*set_pin_toolbar_state) (ConfigurationFacade* self, gboolean state);
	gint (*get_last_crop_height) (ConfigurationFacade* self);
	void (*set_last_crop_height) (ConfigurationFacade* self, gint choice);
	gint (*get_last_crop_menu_choice) (ConfigurationFacade* self);
	void (*set_last_crop_menu_choice) (ConfigurationFacade* self, gint choice);
	gint (*get_last_crop_width) (ConfigurationFacade* self);
	void (*set_last_crop_width) (ConfigurationFacade* self, gint choice);
	gchar* (*get_last_used_service) (ConfigurationFacade* self);
	void (*set_last_used_service) (ConfigurationFacade* self, const gchar* service_name);
	gchar* (*get_last_used_dataimports_service) (ConfigurationFacade* self);
	void (*set_last_used_dataimports_service) (ConfigurationFacade* self, const gchar* service_name);
	void (*get_library_photos_sort) (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
	void (*set_library_photos_sort) (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
	void (*get_library_window_state) (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
	void (*set_library_window_state) (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
	gboolean (*get_modify_originals) (ConfigurationFacade* self);
	void (*set_modify_originals) (ConfigurationFacade* self, gboolean modify_originals);
	gint (*get_photo_thumbnail_scale) (ConfigurationFacade* self);
	void (*set_photo_thumbnail_scale) (ConfigurationFacade* self, gint scale);
	gdouble (*get_printing_content_height) (ConfigurationFacade* self);
	void (*set_printing_content_height) (ConfigurationFacade* self, gdouble content_height);
	gint (*get_printing_content_layout) (ConfigurationFacade* self);
	void (*set_printing_content_layout) (ConfigurationFacade* self, gint layout_code);
	gint (*get_printing_content_ppi) (ConfigurationFacade* self);
	void (*set_printing_content_ppi) (ConfigurationFacade* self, gint content_ppi);
	gint (*get_printing_content_units) (ConfigurationFacade* self);
	void (*set_printing_content_units) (ConfigurationFacade* self, gint units_code);
	gdouble (*get_printing_content_width) (ConfigurationFacade* self);
	void (*set_printing_content_width) (ConfigurationFacade* self, gdouble content_width);
	gint (*get_printing_images_per_page) (ConfigurationFacade* self);
	void (*set_printing_images_per_page) (ConfigurationFacade* self, gint images_per_page_code);
	gboolean (*get_printing_match_aspect_ratio) (ConfigurationFacade* self);
	void (*set_printing_match_aspect_ratio) (ConfigurationFacade* self, gboolean match_aspect_ratio);
	gboolean (*get_printing_print_titles) (ConfigurationFacade* self);
	void (*set_printing_print_titles) (ConfigurationFacade* self, gboolean print_titles);
	gint (*get_printing_size_selection) (ConfigurationFacade* self);
	void (*set_printing_size_selection) (ConfigurationFacade* self, gint size_code);
	gchar* (*get_printing_titles_font) (ConfigurationFacade* self);
	void (*set_printing_titles_font) (ConfigurationFacade* self, const gchar* font_name);
	gboolean (*get_show_welcome_dialog) (ConfigurationFacade* self);
	void (*set_show_welcome_dialog) (ConfigurationFacade* self, gboolean show);
	gint (*get_sidebar_position) (ConfigurationFacade* self);
	void (*set_sidebar_position) (ConfigurationFacade* self, gint position);
	gdouble (*get_slideshow_delay) (ConfigurationFacade* self);
	void (*set_slideshow_delay) (ConfigurationFacade* self, gdouble delay);
	gdouble (*get_slideshow_transition_delay) (ConfigurationFacade* self);
	void (*set_slideshow_transition_delay) (ConfigurationFacade* self, gdouble delay);
	gchar* (*get_slideshow_transition_effect_id) (ConfigurationFacade* self);
	void (*set_slideshow_transition_effect_id) (ConfigurationFacade* self, const gchar* id);
	gboolean (*get_slideshow_show_title) (ConfigurationFacade* self);
	void (*set_slideshow_show_title) (ConfigurationFacade* self, gboolean show_title);
	gboolean (*get_use_24_hour_time) (ConfigurationFacade* self);
	void (*set_use_24_hour_time) (ConfigurationFacade* self, gboolean use_24_hour_time);
	gboolean (*get_use_lowercase_filenames) (ConfigurationFacade* self);
	void (*set_use_lowercase_filenames) (ConfigurationFacade* self, gboolean b);
	gint (*get_video_interpreter_state_cookie) (ConfigurationFacade* self);
	void (*set_video_interpreter_state_cookie) (ConfigurationFacade* self, gint state_cookie);
	gboolean (*get_plugin_bool) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
	void (*set_plugin_bool) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
	gdouble (*get_plugin_double) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
	void (*set_plugin_double) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
	gint (*get_plugin_int) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
	void (*set_plugin_int) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
	gchar* (*get_plugin_string) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
	void (*set_plugin_string) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
	void (*unset_plugin_key) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key);
	FuzzyPropertyState (*is_plugin_enabled) (ConfigurationFacade* self, const gchar* id);
	void (*set_plugin_enabled) (ConfigurationFacade* self, const gchar* id, gboolean enabled);
};

struct _ConfigFacade {
	ConfigurationFacade parent_instance;
	ConfigFacadePrivate * priv;
};

struct _ConfigFacadeClass {
	ConfigurationFacadeClass parent_class;
};

struct _ConfigFacadePrivate {
	gchar* bg_color;
	gchar* selected_color;
	gchar* unselected_color;
	gchar* unfocused_selected_color;
	gchar* border_color;
};

typedef enum  {
	CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY = 0,
	CONFIGURABLE_PROPERTY_BG_COLOR_NAME,
	CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS,
	CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE,
	CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE,
	CONFIGURABLE_PROPERTY_SCREENSAVER_FILE,
	CONFIGURABLE_PROPERTY_SCREENSAVER_MODE,
	CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN,
	CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH,
	CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES,
	CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS,
	CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES,
	CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR,
	CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR,
	CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS,
	CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY,
	CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_EXPORT_CONSTRAINT,
	CONFIGURABLE_PROPERTY_EXPORT_EXPORT_FORMAT_MODE,
	CONFIGURABLE_PROPERTY_EXPORT_EXPORT_METADATA,
	CONFIGURABLE_PROPERTY_EXPORT_PHOTO_FILE_FORMAT,
	CONFIGURABLE_PROPERTY_EXPORT_QUALITY,
	CONFIGURABLE_PROPERTY_EXPORT_SCALE,
	CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP,
	CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP,
	CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED,
	CONFIGURABLE_PROPERTY_IMPORT_DIR,
	CONFIGURABLE_PROPERTY_KEEP_RELATIVITY,
	CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT,
	CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE,
	CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH,
	CONFIGURABLE_PROPERTY_LAST_USED_SERVICE,
	CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE,
	CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH,
	CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS,
	CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE,
	CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH,
	CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE,
	CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO,
	CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES,
	CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION,
	CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT,
	CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT,
	CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG,
	CONFIGURABLE_PROPERTY_SIDEBAR_POSITION,
	CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY,
	CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY,
	CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID,
	CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE,
	CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME,
	CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES,
	CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE,
	CONFIGURABLE_PROPERTY_NUM_PROPERTIES
} ConfigurableProperty;

typedef enum  {
	CONFIGURATION_ERROR_PROPERTY_HAS_NO_VALUE,
	CONFIGURATION_ERROR_ENGINE_ERROR
} ConfigurationError;
#define CONFIGURATION_ERROR configuration_error_quark ()
struct _ConfigurationEngineIface {
	GTypeInterface parent_iface;
	gchar* (*get_name) (ConfigurationEngine* self);
	gint (*get_int_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_int_property) (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error);
	gint (*get_enum_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_enum_property) (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error);
	gchar* (*get_string_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_string_property) (ConfigurationEngine* self, ConfigurableProperty p, const gchar* val, GError** error);
	gboolean (*get_bool_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_bool_property) (ConfigurationEngine* self, ConfigurableProperty p, gboolean val, GError** error);
	gdouble (*get_double_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_double_property) (ConfigurationEngine* self, ConfigurableProperty p, gdouble val, GError** error);
	gboolean (*get_plugin_bool) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
	void (*set_plugin_bool) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
	gdouble (*get_plugin_double) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
	void (*set_plugin_double) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
	gint (*get_plugin_int) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
	void (*set_plugin_int) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
	gchar* (*get_plugin_string) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
	void (*set_plugin_string) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
	void (*unset_plugin_key) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key);
	FuzzyPropertyState (*is_plugin_enabled) (ConfigurationEngine* self, const gchar* id);
	void (*set_plugin_enabled) (ConfigurationEngine* self, const gchar* id, gboolean enabled);
};


static gpointer config_facade_parent_class = NULL;
static ConfigFacade* config_facade_instance;
static ConfigFacade* config_facade_instance = NULL;

GType configuration_facade_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType scale_constraint_get_type (void) G_GNUC_CONST;
GType export_format_mode_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType jpeg_quality_get_type (void) G_GNUC_CONST;
GType raw_developer_get_type (void) G_GNUC_CONST;
GType fuzzy_property_state_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
#define CONFIG_FACADE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONFIG_TYPE_FACADE, ConfigFacadePrivate))
enum  {
	CONFIG_FACADE_DUMMY_PROPERTY
};
#define CONFIG_FACADE_SLIDESHOW_DELAY_MAX 30.0
#define CONFIG_FACADE_SLIDESHOW_DELAY_MIN 1.0
#define CONFIG_FACADE_SLIDESHOW_DELAY_DEFAULT 3.0
#define CONFIG_FACADE_SLIDESHOW_TRANSITION_DELAY_MAX 1.0
#define CONFIG_FACADE_SLIDESHOW_TRANSITION_DELAY_MIN 0.1
#define CONFIG_FACADE_SLIDESHOW_TRANSITION_DELAY_DEFAULT 0.3
#define CONFIG_FACADE_WIDTH_DEFAULT 1024
#define CONFIG_FACADE_HEIGHT_DEFAULT 768
#define CONFIG_FACADE_SIDEBAR_MIN_POSITION 180
#define CONFIG_FACADE_SIDEBAR_MAX_POSITION 1000
#define CONFIG_FACADE_DEFAULT_BG_COLOR "#444"
#define CONFIG_FACADE_NO_VIDEO_INTERPRETER_STATE -1
#define CONFIG_FACADE_BLACK_THRESHOLD 0.61
#define CONFIG_FACADE_DARK_SELECTED_COLOR "#0AD"
#define CONFIG_FACADE_LIGHT_SELECTED_COLOR "#2DF"
#define CONFIG_FACADE_DARK_UNSELECTED_COLOR "#000"
#define CONFIG_FACADE_LIGHT_UNSELECTED_COLOR "#FFF"
#define CONFIG_FACADE_DARK_BORDER_COLOR "#999"
#define CONFIG_FACADE_LIGHT_BORDER_COLOR "#AAA"
#define CONFIG_FACADE_DARK_UNFOCUSED_SELECTED_COLOR "#6fc4dd"
#define CONFIG_FACADE_LIGHT_UNFOCUSED_SELECTED_COLOR "#99efff"
static ConfigFacade* config_facade_new (void);
static ConfigFacade* config_facade_construct (GType object_type);
GSettingsConfigurationEngine* gsettings_configuration_engine_new (void);
GSettingsConfigurationEngine* gsettings_configuration_engine_construct (GType object_type);
GType gsettings_configuration_engine_get_type (void) G_GNUC_CONST;
GType configurable_property_get_type (void) G_GNUC_CONST;
GQuark configuration_error_quark (void);
GType configuration_engine_get_type (void) G_GNUC_CONST;
ConfigurationFacade* configuration_facade_construct (GType object_type, ConfigurationEngine* engine);
static void config_facade_on_color_name_changed (ConfigFacade* self);
static void _config_facade_on_color_name_changed_configuration_facade_bg_color_name_changed (ConfigurationFacade* _sender, gpointer self);
ConfigFacade* config_facade_get_instance (void);
static void config_facade_set_text_colors (ConfigFacade* self, GdkRGBA* bg_color);
static void config_facade_get_colors (ConfigFacade* self);
gchar* configuration_facade_get_bg_color_name (ConfigurationFacade* self);
gboolean is_color_parsable (const gchar* spec);
void parse_color (const gchar* spec, GdkRGBA* result);
void config_facade_get_bg_color (ConfigFacade* self, GdkRGBA* result);
gboolean is_string_empty (const gchar* s);
void config_facade_get_selected_color (ConfigFacade* self, gboolean in_focus, GdkRGBA* result);
void config_facade_get_unselected_color (ConfigFacade* self, GdkRGBA* result);
void config_facade_get_border_color (ConfigFacade* self, GdkRGBA* result);
void config_facade_set_bg_color (ConfigFacade* self, GdkRGBA* color);
void configuration_facade_set_bg_color_name (ConfigurationFacade* self, const gchar* color_name);
void config_facade_commit_bg_color (ConfigFacade* self);
static void config_facade_finalize (GObject* obj);
void config_preconfigure (void);
void config_init (GError** error);
void config_terminate (void);


static void _config_facade_on_color_name_changed_configuration_facade_bg_color_name_changed (ConfigurationFacade* _sender, gpointer self) {
#line 55 "/home/jens/Source/shotwell/src/config/Config.vala"
	config_facade_on_color_name_changed ((ConfigFacade*) self);
#line 473 "Config.c"
}


static ConfigFacade* config_facade_construct (GType object_type) {
	ConfigFacade * self = NULL;
	GSettingsConfigurationEngine* _tmp0_ = NULL;
	GSettingsConfigurationEngine* _tmp1_ = NULL;
#line 53 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp0_ = gsettings_configuration_engine_new ();
#line 53 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp1_ = _tmp0_;
#line 53 "/home/jens/Source/shotwell/src/config/Config.vala"
	self = (ConfigFacade*) configuration_facade_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_ENGINE, ConfigurationEngine));
#line 53 "/home/jens/Source/shotwell/src/config/Config.vala"
	_g_object_unref0 (_tmp1_);
#line 55 "/home/jens/Source/shotwell/src/config/Config.vala"
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), "bg-color-name-changed", (GCallback) _config_facade_on_color_name_changed_configuration_facade_bg_color_name_changed, self, 0);
#line 52 "/home/jens/Source/shotwell/src/config/Config.vala"
	return self;
#line 493 "Config.c"
}


static ConfigFacade* config_facade_new (void) {
#line 52 "/home/jens/Source/shotwell/src/config/Config.vala"
	return config_facade_construct (CONFIG_TYPE_FACADE);
#line 500 "Config.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 62 "/home/jens/Source/shotwell/src/config/Config.vala"
	return self ? g_object_ref (self) : NULL;
#line 507 "Config.c"
}


ConfigFacade* config_facade_get_instance (void) {
	ConfigFacade* result = NULL;
	ConfigFacade* _tmp0_ = NULL;
	ConfigFacade* _tmp2_ = NULL;
	ConfigFacade* _tmp3_ = NULL;
#line 59 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp0_ = config_facade_instance;
#line 59 "/home/jens/Source/shotwell/src/config/Config.vala"
	if (_tmp0_ == NULL) {
#line 520 "Config.c"
		ConfigFacade* _tmp1_ = NULL;
#line 60 "/home/jens/Source/shotwell/src/config/Config.vala"
		_tmp1_ = config_facade_new ();
#line 60 "/home/jens/Source/shotwell/src/config/Config.vala"
		_g_object_unref0 (config_facade_instance);
#line 60 "/home/jens/Source/shotwell/src/config/Config.vala"
		config_facade_instance = _tmp1_;
#line 528 "Config.c"
	}
#line 62 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp2_ = config_facade_instance;
#line 62 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 62 "/home/jens/Source/shotwell/src/config/Config.vala"
	result = _tmp3_;
#line 62 "/home/jens/Source/shotwell/src/config/Config.vala"
	return result;
#line 538 "Config.c"
}


static void config_facade_on_color_name_changed (ConfigFacade* self) {
#line 65 "/home/jens/Source/shotwell/src/config/Config.vala"
	g_return_if_fail (CONFIG_IS_FACADE (self));
#line 66 "/home/jens/Source/shotwell/src/config/Config.vala"
	g_signal_emit_by_name (self, "colors-changed");
#line 547 "Config.c"
}


static void config_facade_set_text_colors (ConfigFacade* self, GdkRGBA* bg_color) {
	GdkRGBA _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
#line 69 "/home/jens/Source/shotwell/src/config/Config.vala"
	g_return_if_fail (CONFIG_IS_FACADE (self));
#line 69 "/home/jens/Source/shotwell/src/config/Config.vala"
	g_return_if_fail (bg_color != NULL);
#line 73 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp0_ = *bg_color;
#line 73 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp1_ = _tmp0_.red;
#line 73 "/home/jens/Source/shotwell/src/config/Config.vala"
	if (_tmp1_ > CONFIG_FACADE_BLACK_THRESHOLD) {
#line 564 "Config.c"
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 74 "/home/jens/Source/shotwell/src/config/Config.vala"
		_tmp2_ = g_strdup (CONFIG_FACADE_DARK_SELECTED_COLOR);
#line 74 "/home/jens/Source/shotwell/src/config/Config.vala"
		_g_free0 (self->priv->selected_color);
#line 74 "/home/jens/Source/shotwell/src/config/Config.vala"
		self->priv->selected_color = _tmp2_;
#line 75 "/home/jens/Source/shotwell/src/config/Config.vala"
		_tmp3_ = g_strdup (CONFIG_FACADE_DARK_UNSELECTED_COLOR);
#line 75 "/home/jens/Source/shotwell/src/config/Config.vala"
		_g_free0 (self->priv->unselected_color);
#line 75 "/home/jens/Source/shotwell/src/config/Config.vala"
		self->priv->unselected_color = _tmp3_;
#line 76 "/home/jens/Source/shotwell/src/config/Config.vala"
		_tmp4_ = g_strdup (CONFIG_FACADE_DARK_UNFOCUSED_SELECTED_COLOR);
#line 76 "/home/jens/Source/shotwell/src/config/Config.vala"
		_g_free0 (self->priv->unfocused_selected_color);
#line 76 "/home/jens/Source/shotwell/src/config/Config.vala"
		self->priv->unfocused_selected_color = _tmp4_;
#line 77 "/home/jens/Source/shotwell/src/config/Config.vala"
		_tmp5_ = g_strdup (CONFIG_FACADE_DARK_BORDER_COLOR);
#line 77 "/home/jens/Source/shotwell/src/config/Config.vala"
		_g_free0 (self->priv->border_color);
#line 77 "/home/jens/Source/shotwell/src/config/Config.vala"
		self->priv->border_color = _tmp5_;
#line 593 "Config.c"
	} else {
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 79 "/home/jens/Source/shotwell/src/config/Config.vala"
		_tmp6_ = g_strdup (CONFIG_FACADE_LIGHT_SELECTED_COLOR);
#line 79 "/home/jens/Source/shotwell/src/config/Config.vala"
		_g_free0 (self->priv->selected_color);
#line 79 "/home/jens/Source/shotwell/src/config/Config.vala"
		self->priv->selected_color = _tmp6_;
#line 80 "/home/jens/Source/shotwell/src/config/Config.vala"
		_tmp7_ = g_strdup (CONFIG_FACADE_LIGHT_UNSELECTED_COLOR);
#line 80 "/home/jens/Source/shotwell/src/config/Config.vala"
		_g_free0 (self->priv->unselected_color);
#line 80 "/home/jens/Source/shotwell/src/config/Config.vala"
		self->priv->unselected_color = _tmp7_;
#line 81 "/home/jens/Source/shotwell/src/config/Config.vala"
		_tmp8_ = g_strdup (CONFIG_FACADE_LIGHT_UNFOCUSED_SELECTED_COLOR);
#line 81 "/home/jens/Source/shotwell/src/config/Config.vala"
		_g_free0 (self->priv->unfocused_selected_color);
#line 81 "/home/jens/Source/shotwell/src/config/Config.vala"
		self->priv->unfocused_selected_color = _tmp8_;
#line 82 "/home/jens/Source/shotwell/src/config/Config.vala"
		_tmp9_ = g_strdup (CONFIG_FACADE_LIGHT_BORDER_COLOR);
#line 82 "/home/jens/Source/shotwell/src/config/Config.vala"
		_g_free0 (self->priv->border_color);
#line 82 "/home/jens/Source/shotwell/src/config/Config.vala"
		self->priv->border_color = _tmp9_;
#line 623 "Config.c"
	}
}


static void config_facade_get_colors (ConfigFacade* self) {
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp4_ = NULL;
	GdkRGBA _tmp5_ = {0};
#line 86 "/home/jens/Source/shotwell/src/config/Config.vala"
	g_return_if_fail (CONFIG_IS_FACADE (self));
#line 87 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp0_ = CONFIGURATION_FACADE_CLASS (config_facade_parent_class)->get_bg_color_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 87 "/home/jens/Source/shotwell/src/config/Config.vala"
	_g_free0 (self->priv->bg_color);
#line 87 "/home/jens/Source/shotwell/src/config/Config.vala"
	self->priv->bg_color = _tmp0_;
#line 89 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp1_ = self->priv->bg_color;
#line 89 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp2_ = is_color_parsable (_tmp1_);
#line 89 "/home/jens/Source/shotwell/src/config/Config.vala"
	if (!_tmp2_) {
#line 648 "Config.c"
		gchar* _tmp3_ = NULL;
#line 90 "/home/jens/Source/shotwell/src/config/Config.vala"
		_tmp3_ = g_strdup (CONFIG_FACADE_DEFAULT_BG_COLOR);
#line 90 "/home/jens/Source/shotwell/src/config/Config.vala"
		_g_free0 (self->priv->bg_color);
#line 90 "/home/jens/Source/shotwell/src/config/Config.vala"
		self->priv->bg_color = _tmp3_;
#line 656 "Config.c"
	}
#line 92 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp4_ = self->priv->bg_color;
#line 92 "/home/jens/Source/shotwell/src/config/Config.vala"
	parse_color (_tmp4_, &_tmp5_);
#line 92 "/home/jens/Source/shotwell/src/config/Config.vala"
	config_facade_set_text_colors (self, &_tmp5_);
#line 664 "Config.c"
}


void config_facade_get_bg_color (ConfigFacade* self, GdkRGBA* result) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	GdkRGBA _tmp3_ = {0};
#line 95 "/home/jens/Source/shotwell/src/config/Config.vala"
	g_return_if_fail (CONFIG_IS_FACADE (self));
#line 96 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp0_ = self->priv->bg_color;
#line 96 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp1_ = is_string_empty (_tmp0_);
#line 96 "/home/jens/Source/shotwell/src/config/Config.vala"
	if (_tmp1_) {
#line 97 "/home/jens/Source/shotwell/src/config/Config.vala"
		config_facade_get_colors (self);
#line 683 "Config.c"
	}
#line 99 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp2_ = self->priv->bg_color;
#line 99 "/home/jens/Source/shotwell/src/config/Config.vala"
	parse_color (_tmp2_, &_tmp3_);
#line 99 "/home/jens/Source/shotwell/src/config/Config.vala"
	*result = _tmp3_;
#line 99 "/home/jens/Source/shotwell/src/config/Config.vala"
	return;
#line 693 "Config.c"
}


void config_facade_get_selected_color (ConfigFacade* self, gboolean in_focus, GdkRGBA* result) {
	gboolean _tmp0_ = FALSE;
#line 102 "/home/jens/Source/shotwell/src/config/Config.vala"
	g_return_if_fail (CONFIG_IS_FACADE (self));
#line 103 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp0_ = in_focus;
#line 103 "/home/jens/Source/shotwell/src/config/Config.vala"
	if (_tmp0_) {
#line 705 "Config.c"
		const gchar* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_ = NULL;
		GdkRGBA _tmp4_ = {0};
#line 104 "/home/jens/Source/shotwell/src/config/Config.vala"
		_tmp1_ = self->priv->selected_color;
#line 104 "/home/jens/Source/shotwell/src/config/Config.vala"
		_tmp2_ = is_string_empty (_tmp1_);
#line 104 "/home/jens/Source/shotwell/src/config/Config.vala"
		if (_tmp2_) {
#line 105 "/home/jens/Source/shotwell/src/config/Config.vala"
			config_facade_get_colors (self);
#line 718 "Config.c"
		}
#line 107 "/home/jens/Source/shotwell/src/config/Config.vala"
		_tmp3_ = self->priv->selected_color;
#line 107 "/home/jens/Source/shotwell/src/config/Config.vala"
		parse_color (_tmp3_, &_tmp4_);
#line 107 "/home/jens/Source/shotwell/src/config/Config.vala"
		*result = _tmp4_;
#line 107 "/home/jens/Source/shotwell/src/config/Config.vala"
		return;
#line 728 "Config.c"
	} else {
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp7_ = NULL;
		GdkRGBA _tmp8_ = {0};
#line 109 "/home/jens/Source/shotwell/src/config/Config.vala"
		_tmp5_ = self->priv->unfocused_selected_color;
#line 109 "/home/jens/Source/shotwell/src/config/Config.vala"
		_tmp6_ = is_string_empty (_tmp5_);
#line 109 "/home/jens/Source/shotwell/src/config/Config.vala"
		if (_tmp6_) {
#line 110 "/home/jens/Source/shotwell/src/config/Config.vala"
			config_facade_get_colors (self);
#line 742 "Config.c"
		}
#line 112 "/home/jens/Source/shotwell/src/config/Config.vala"
		_tmp7_ = self->priv->unfocused_selected_color;
#line 112 "/home/jens/Source/shotwell/src/config/Config.vala"
		parse_color (_tmp7_, &_tmp8_);
#line 112 "/home/jens/Source/shotwell/src/config/Config.vala"
		*result = _tmp8_;
#line 112 "/home/jens/Source/shotwell/src/config/Config.vala"
		return;
#line 752 "Config.c"
	}
}


void config_facade_get_unselected_color (ConfigFacade* self, GdkRGBA* result) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	GdkRGBA _tmp3_ = {0};
#line 116 "/home/jens/Source/shotwell/src/config/Config.vala"
	g_return_if_fail (CONFIG_IS_FACADE (self));
#line 117 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp0_ = self->priv->unselected_color;
#line 117 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp1_ = is_string_empty (_tmp0_);
#line 117 "/home/jens/Source/shotwell/src/config/Config.vala"
	if (_tmp1_) {
#line 118 "/home/jens/Source/shotwell/src/config/Config.vala"
		config_facade_get_colors (self);
#line 772 "Config.c"
	}
#line 120 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp2_ = self->priv->unselected_color;
#line 120 "/home/jens/Source/shotwell/src/config/Config.vala"
	parse_color (_tmp2_, &_tmp3_);
#line 120 "/home/jens/Source/shotwell/src/config/Config.vala"
	*result = _tmp3_;
#line 120 "/home/jens/Source/shotwell/src/config/Config.vala"
	return;
#line 782 "Config.c"
}


void config_facade_get_border_color (ConfigFacade* self, GdkRGBA* result) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	GdkRGBA _tmp3_ = {0};
#line 123 "/home/jens/Source/shotwell/src/config/Config.vala"
	g_return_if_fail (CONFIG_IS_FACADE (self));
#line 124 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp0_ = self->priv->border_color;
#line 124 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp1_ = is_string_empty (_tmp0_);
#line 124 "/home/jens/Source/shotwell/src/config/Config.vala"
	if (_tmp1_) {
#line 125 "/home/jens/Source/shotwell/src/config/Config.vala"
		config_facade_get_colors (self);
#line 801 "Config.c"
	}
#line 127 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp2_ = self->priv->border_color;
#line 127 "/home/jens/Source/shotwell/src/config/Config.vala"
	parse_color (_tmp2_, &_tmp3_);
#line 127 "/home/jens/Source/shotwell/src/config/Config.vala"
	*result = _tmp3_;
#line 127 "/home/jens/Source/shotwell/src/config/Config.vala"
	return;
#line 811 "Config.c"
}


void config_facade_set_bg_color (ConfigFacade* self, GdkRGBA* color) {
	guint8 col_tmp = 0U;
	GdkRGBA _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GdkRGBA _tmp4_ = {0};
#line 130 "/home/jens/Source/shotwell/src/config/Config.vala"
	g_return_if_fail (CONFIG_IS_FACADE (self));
#line 130 "/home/jens/Source/shotwell/src/config/Config.vala"
	g_return_if_fail (color != NULL);
#line 131 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp0_ = *color;
#line 131 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp1_ = _tmp0_.red;
#line 131 "/home/jens/Source/shotwell/src/config/Config.vala"
	col_tmp = (guint8) (_tmp1_ * 255.0);
#line 133 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp2_ = g_strdup_printf ("#%02X%02X%02X", (guint) col_tmp, (guint) col_tmp, (guint) col_tmp);
#line 133 "/home/jens/Source/shotwell/src/config/Config.vala"
	_g_free0 (self->priv->bg_color);
#line 133 "/home/jens/Source/shotwell/src/config/Config.vala"
	self->priv->bg_color = _tmp2_;
#line 134 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp3_ = self->priv->bg_color;
#line 134 "/home/jens/Source/shotwell/src/config/Config.vala"
	configuration_facade_set_bg_color_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp3_);
#line 136 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp4_ = *color;
#line 136 "/home/jens/Source/shotwell/src/config/Config.vala"
	config_facade_set_text_colors (self, &_tmp4_);
#line 846 "Config.c"
}


void config_facade_commit_bg_color (ConfigFacade* self) {
	const gchar* _tmp0_ = NULL;
#line 139 "/home/jens/Source/shotwell/src/config/Config.vala"
	g_return_if_fail (CONFIG_IS_FACADE (self));
#line 140 "/home/jens/Source/shotwell/src/config/Config.vala"
	_tmp0_ = self->priv->bg_color;
#line 140 "/home/jens/Source/shotwell/src/config/Config.vala"
	CONFIGURATION_FACADE_CLASS (config_facade_parent_class)->set_bg_color_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_CONFIGURATION_FACADE, ConfigurationFacade), _tmp0_);
#line 858 "Config.c"
}


static void config_facade_class_init (ConfigFacadeClass * klass) {
#line 18 "/home/jens/Source/shotwell/src/config/Config.vala"
	config_facade_parent_class = g_type_class_peek_parent (klass);
#line 18 "/home/jens/Source/shotwell/src/config/Config.vala"
	g_type_class_add_private (klass, sizeof (ConfigFacadePrivate));
#line 18 "/home/jens/Source/shotwell/src/config/Config.vala"
	G_OBJECT_CLASS (klass)->finalize = config_facade_finalize;
#line 18 "/home/jens/Source/shotwell/src/config/Config.vala"
	g_signal_new ("colors_changed", CONFIG_TYPE_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 871 "Config.c"
}


static void config_facade_instance_init (ConfigFacade * self) {
#line 18 "/home/jens/Source/shotwell/src/config/Config.vala"
	self->priv = CONFIG_FACADE_GET_PRIVATE (self);
#line 42 "/home/jens/Source/shotwell/src/config/Config.vala"
	self->priv->bg_color = NULL;
#line 43 "/home/jens/Source/shotwell/src/config/Config.vala"
	self->priv->selected_color = NULL;
#line 44 "/home/jens/Source/shotwell/src/config/Config.vala"
	self->priv->unselected_color = NULL;
#line 45 "/home/jens/Source/shotwell/src/config/Config.vala"
	self->priv->unfocused_selected_color = NULL;
#line 46 "/home/jens/Source/shotwell/src/config/Config.vala"
	self->priv->border_color = NULL;
#line 888 "Config.c"
}


static void config_facade_finalize (GObject* obj) {
	ConfigFacade * self;
#line 18 "/home/jens/Source/shotwell/src/config/Config.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONFIG_TYPE_FACADE, ConfigFacade);
#line 42 "/home/jens/Source/shotwell/src/config/Config.vala"
	_g_free0 (self->priv->bg_color);
#line 43 "/home/jens/Source/shotwell/src/config/Config.vala"
	_g_free0 (self->priv->selected_color);
#line 44 "/home/jens/Source/shotwell/src/config/Config.vala"
	_g_free0 (self->priv->unselected_color);
#line 45 "/home/jens/Source/shotwell/src/config/Config.vala"
	_g_free0 (self->priv->unfocused_selected_color);
#line 46 "/home/jens/Source/shotwell/src/config/Config.vala"
	_g_free0 (self->priv->border_color);
#line 18 "/home/jens/Source/shotwell/src/config/Config.vala"
	G_OBJECT_CLASS (config_facade_parent_class)->finalize (obj);
#line 908 "Config.c"
}


GType config_facade_get_type (void) {
	static volatile gsize config_facade_type_id__volatile = 0;
	if (g_once_init_enter (&config_facade_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigFacadeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) config_facade_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigFacade), 0, (GInstanceInitFunc) config_facade_instance_init, NULL };
		GType config_facade_type_id;
		config_facade_type_id = g_type_register_static (TYPE_CONFIGURATION_FACADE, "ConfigFacade", &g_define_type_info, 0);
		g_once_init_leave (&config_facade_type_id__volatile, config_facade_type_id);
	}
	return config_facade_type_id__volatile;
}


void config_preconfigure (void) {
}


void config_init (GError** error) {
}


void config_terminate (void) {
}



