/* ThumbnailCache.c generated by valac 0.34.1, the Vala compiler
 * generated from ThumbnailCache.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_THUMBNAILS (thumbnails_get_type ())
#define THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAILS, Thumbnails))
#define THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAILS, ThumbnailsClass))
#define IS_THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAILS))
#define IS_THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAILS))
#define THUMBNAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAILS, ThumbnailsClass))

typedef struct _Thumbnails Thumbnails;
typedef struct _ThumbnailsClass ThumbnailsClass;
typedef struct _ThumbnailsPrivate ThumbnailsPrivate;

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecThumbnails ParamSpecThumbnails;

#define TYPE_THUMBNAIL_CACHE (thumbnail_cache_get_type ())
#define THUMBNAIL_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_CACHE, ThumbnailCache))
#define THUMBNAIL_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_CACHE, ThumbnailCacheClass))
#define IS_THUMBNAIL_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_CACHE))
#define IS_THUMBNAIL_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_CACHE))
#define THUMBNAIL_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_CACHE, ThumbnailCacheClass))

typedef struct _ThumbnailCache ThumbnailCache;
typedef struct _ThumbnailCacheClass ThumbnailCacheClass;
typedef struct _ThumbnailCachePrivate ThumbnailCachePrivate;

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())

#define THUMBNAIL_CACHE_TYPE_IMAGE_DATA (thumbnail_cache_image_data_get_type ())
#define THUMBNAIL_CACHE_IMAGE_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), THUMBNAIL_CACHE_TYPE_IMAGE_DATA, ThumbnailCacheImageData))
#define THUMBNAIL_CACHE_IMAGE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), THUMBNAIL_CACHE_TYPE_IMAGE_DATA, ThumbnailCacheImageDataClass))
#define THUMBNAIL_CACHE_IS_IMAGE_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), THUMBNAIL_CACHE_TYPE_IMAGE_DATA))
#define THUMBNAIL_CACHE_IS_IMAGE_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), THUMBNAIL_CACHE_TYPE_IMAGE_DATA))
#define THUMBNAIL_CACHE_IMAGE_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), THUMBNAIL_CACHE_TYPE_IMAGE_DATA, ThumbnailCacheImageDataClass))

typedef struct _ThumbnailCacheImageData ThumbnailCacheImageData;
typedef struct _ThumbnailCacheImageDataClass ThumbnailCacheImageDataClass;

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef struct _Scaling Scaling;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_ONE_SHOT_SCHEDULER (one_shot_scheduler_get_type ())
#define ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotScheduler))
#define ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))
#define IS_ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ONE_SHOT_SCHEDULER))
#define IS_ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ONE_SHOT_SCHEDULER))
#define ONE_SHOT_SCHEDULER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))

typedef struct _OneShotScheduler OneShotScheduler;
typedef struct _OneShotSchedulerClass OneShotSchedulerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _one_shot_scheduler_unref0(var) ((var == NULL) ? NULL : (var = (one_shot_scheduler_unref (var), NULL)))
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_ROTATION (rotation_get_type ())

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;

#define TYPE_ORIENTATION (orientation_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;

#define THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB (thumbnail_cache_async_fetch_job_get_type ())
#define THUMBNAIL_CACHE_ASYNC_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob))
#define THUMBNAIL_CACHE_ASYNC_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJobClass))
#define THUMBNAIL_CACHE_IS_ASYNC_FETCH_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB))
#define THUMBNAIL_CACHE_IS_ASYNC_FETCH_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB))
#define THUMBNAIL_CACHE_ASYNC_FETCH_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJobClass))

typedef struct _ThumbnailCacheAsyncFetchJob ThumbnailCacheAsyncFetchJob;
typedef struct _ThumbnailCacheAsyncFetchJobClass ThumbnailCacheAsyncFetchJobClass;
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
typedef struct _BackgroundJobPrivate BackgroundJobPrivate;

#define BACKGROUND_JOB_TYPE_JOB_PRIORITY (background_job_job_priority_get_type ())
typedef struct _ThumbnailCacheAsyncFetchJobPrivate ThumbnailCacheAsyncFetchJobPrivate;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))
typedef struct _ThumbnailCacheImageDataPrivate ThumbnailCacheImageDataPrivate;
#define _thumbnail_cache_image_data_unref0(var) ((var == NULL) ? NULL : (var = (thumbnail_cache_image_data_unref (var), NULL)))

#define TYPE_PHOTO_FILE_WRITER (photo_file_writer_get_type ())
#define PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriter))
#define PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))
#define IS_PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_WRITER))
#define IS_PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_WRITER))
#define PHOTO_FILE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))

typedef struct _PhotoFileWriter PhotoFileWriter;
typedef struct _PhotoFileWriterClass PhotoFileWriterClass;
typedef struct _ThumbnailCacheParamSpecImageData ThumbnailCacheParamSpecImageData;

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Thumbnails {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ThumbnailsPrivate * priv;
};

struct _ThumbnailsClass {
	GTypeClass parent_class;
	void (*finalize) (Thumbnails *self);
};

typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 360,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;

struct _ThumbnailsPrivate {
	GeeHashMap* map;
};

struct _ParamSpecThumbnails {
	GParamSpec parent_instance;
};

struct _ThumbnailCache {
	GObject parent_instance;
	ThumbnailCachePrivate * priv;
};

struct _ThumbnailCacheClass {
	GObjectClass parent_class;
};

typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

struct _ThumbnailCachePrivate {
	GFile* cache_dir;
	ThumbnailCacheSize size;
	gulong max_cached_bytes;
	GdkInterpType interp;
	JpegQuality quality;
	GeeHashMap* cache_map;
	GeeArrayList* cache_lru;
	gulong cached_bytes;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

typedef void (*OneShotCallback) (void* user_data);
typedef void (*ThumbnailCacheAsyncFetchCallback) (GdkPixbuf* pixbuf, GdkPixbuf* unscaled, Dimensions* dim, GdkInterpType interp, GError* err, void* user_data);
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

typedef enum  {
	ROTATION_CLOCKWISE,
	ROTATION_COUNTERCLOCKWISE,
	ROTATION_MIRROR,
	ROTATION_UPSIDE_DOWN
} Rotation;

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

typedef enum  {
	BACKGROUND_JOB_JOB_PRIORITY_HIGHEST = 100,
	BACKGROUND_JOB_JOB_PRIORITY_HIGH = 75,
	BACKGROUND_JOB_JOB_PRIORITY_NORMAL = 50,
	BACKGROUND_JOB_JOB_PRIORITY_LOW = 25,
	BACKGROUND_JOB_JOB_PRIORITY_LOWEST = 0
} BackgroundJobJobPriority;

struct _BackgroundJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobPrivate * priv;
};

struct _BackgroundJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJob *self);
	void (*execute) (BackgroundJob* self);
	BackgroundJobJobPriority (*get_priority) (BackgroundJob* self);
};

struct _ThumbnailCacheAsyncFetchJob {
	BackgroundJob parent_instance;
	ThumbnailCacheAsyncFetchJobPrivate * priv;
	ThumbnailCache* cache;
	gchar* thumbnail_name;
	ThumbnailSource* source;
	PhotoFileFormat source_format;
	Dimensions dim;
	GdkInterpType interp;
	ThumbnailCacheAsyncFetchCallback callback;
	gpointer callback_target;
	GdkPixbuf* unscaled;
	GdkPixbuf* scaled;
	GError* err;
	gboolean fetched;
	gboolean replace;
};

struct _ThumbnailCacheAsyncFetchJobClass {
	BackgroundJobClass parent_class;
};

struct _ThumbnailCacheImageData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ThumbnailCacheImageDataPrivate * priv;
	GdkPixbuf* pixbuf;
	gulong bytes;
};

struct _ThumbnailCacheImageDataClass {
	GTypeClass parent_class;
	void (*finalize) (ThumbnailCacheImageData *self);
};

typedef enum  {
	PHOTO_FORMAT_ERROR_READ_ONLY
} PhotoFormatError;
#define PHOTO_FORMAT_ERROR photo_format_error_quark ()
struct _ThumbnailCacheParamSpecImageData {
	GParamSpec parent_instance;
};

typedef void (*CompletionCallback) (BackgroundJob* job, void* user_data);
typedef void (*CancellationCallback) (BackgroundJob* job, void* user_data);

static gpointer thumbnails_parent_class = NULL;
static gpointer thumbnail_cache_parent_class = NULL;
static ThumbnailCacheSize* thumbnail_cache_ALL_SIZES;
static gint thumbnail_cache_ALL_SIZES_length1;
static ThumbnailCacheSize* thumbnail_cache_ALL_SIZES = NULL;
static gint thumbnail_cache_ALL_SIZES_length1 = 0;
static gint _thumbnail_cache_ALL_SIZES_size_ = 0;
static Workers* thumbnail_cache_fetch_workers;
static Workers* thumbnail_cache_fetch_workers = NULL;
static ThumbnailCache* thumbnail_cache_big;
static ThumbnailCache* thumbnail_cache_big = NULL;
static ThumbnailCache* thumbnail_cache_medium;
static ThumbnailCache* thumbnail_cache_medium = NULL;
static OneShotScheduler* thumbnail_cache_debug_scheduler;
static OneShotScheduler* thumbnail_cache_debug_scheduler = NULL;
static gint thumbnail_cache_cycle_fetched_thumbnails;
static gint thumbnail_cache_cycle_fetched_thumbnails = 0;
static gint thumbnail_cache_cycle_async_fetched_thumbnails;
static gint thumbnail_cache_cycle_async_fetched_thumbnails = 0;
static gint thumbnail_cache_cycle_async_resized_thumbnails;
static gint thumbnail_cache_cycle_async_resized_thumbnails = 0;
static gint thumbnail_cache_cycle_overflow_thumbnails;
static gint thumbnail_cache_cycle_overflow_thumbnails = 0;
static gulong thumbnail_cache_cycle_dropped_bytes;
static gulong thumbnail_cache_cycle_dropped_bytes = (gulong) 0;
static gpointer thumbnail_cache_image_data_parent_class = NULL;
static gpointer thumbnail_cache_async_fetch_job_parent_class = NULL;

gpointer thumbnails_ref (gpointer instance);
void thumbnails_unref (gpointer instance);
GParamSpec* param_spec_thumbnails (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_thumbnails (GValue* value, gpointer v_object);
void value_take_thumbnails (GValue* value, gpointer v_object);
gpointer value_get_thumbnails (const GValue* value);
GType thumbnails_get_type (void) G_GNUC_CONST;
GType thumbnail_cache_size_get_type (void) G_GNUC_CONST;
#define THUMBNAILS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_THUMBNAILS, ThumbnailsPrivate))
enum  {
	THUMBNAILS_DUMMY_PROPERTY
};
Thumbnails* thumbnails_new (void);
Thumbnails* thumbnails_construct (GType object_type);
void thumbnails_set (Thumbnails* self, ThumbnailCacheSize size, GdkPixbuf* pixbuf);
void thumbnails_remove (Thumbnails* self, ThumbnailCacheSize size);
GdkPixbuf* thumbnails_get (Thumbnails* self, ThumbnailCacheSize size);
static void thumbnails_finalize (Thumbnails* obj);
GType thumbnail_cache_get_type (void) G_GNUC_CONST;
GType jpeg_quality_get_type (void) G_GNUC_CONST;
static gpointer thumbnail_cache_image_data_ref (gpointer instance);
static void thumbnail_cache_image_data_unref (gpointer instance);
static GParamSpec* thumbnail_cache_param_spec_image_data (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void thumbnail_cache_value_set_image_data (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void thumbnail_cache_value_take_image_data (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer thumbnail_cache_value_get_image_data (const GValue* value) G_GNUC_UNUSED;
static GType thumbnail_cache_image_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define THUMBNAIL_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_THUMBNAIL_CACHE, ThumbnailCachePrivate))
enum  {
	THUMBNAIL_CACHE_DUMMY_PROPERTY
};
gint thumbnail_cache_size_get_scale (ThumbnailCacheSize self);
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
void thumbnail_cache_size_get_scaling (ThumbnailCacheSize self, Scaling* result);
void scaling_for_best_fit (gint pixels, gboolean scale_up, Scaling* result);
ThumbnailCacheSize thumbnail_cache_size_get_best_size (gint scale);
gpointer workers_ref (gpointer instance);
void workers_unref (gpointer instance);
GParamSpec* param_spec_workers (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_workers (GValue* value, gpointer v_object);
void value_take_workers (GValue* value, gpointer v_object);
gpointer value_get_workers (const GValue* value);
GType workers_get_type (void) G_GNUC_CONST;
gpointer one_shot_scheduler_ref (gpointer instance);
void one_shot_scheduler_unref (gpointer instance);
GParamSpec* param_spec_one_shot_scheduler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_one_shot_scheduler (GValue* value, gpointer v_object);
void value_take_one_shot_scheduler (GValue* value, gpointer v_object);
gpointer value_get_one_shot_scheduler (const GValue* value);
GType one_shot_scheduler_get_type (void) G_GNUC_CONST;
#define THUMBNAIL_CACHE_DEFAULT_INTERP GDK_INTERP_HYPER
#define THUMBNAIL_CACHE_DEFAULT_QUALITY JPEG_QUALITY_HIGH
#define THUMBNAIL_CACHE_MAX_INMEMORY_DATA_SIZE (512 * 1024)
#define THUMBNAIL_CACHE_MAX_BIG_CACHED_BYTES ((gulong) ((40 * 1024) * 1024))
#define THUMBNAIL_CACHE_MAX_MEDIUM_CACHED_BYTES ((gulong) ((30 * 1024) * 1024))
static ThumbnailCache* thumbnail_cache_new (ThumbnailCacheSize size, gulong max_cached_bytes, GdkInterpType interp, JpegQuality quality);
static ThumbnailCache* thumbnail_cache_construct (GType object_type, ThumbnailCacheSize size, gulong max_cached_bytes, GdkInterpType interp, JpegQuality quality);
GFile* app_dirs_get_cache_subdir (const gchar* name, const gchar* subname);
void thumbnail_cache_init (void);
static void thumbnail_cache_report_cycle (void);
static void _thumbnail_cache_report_cycle_one_shot_callback (gpointer self);
OneShotScheduler* one_shot_scheduler_new (const gchar* name, OneShotCallback callback, void* callback_target);
OneShotScheduler* one_shot_scheduler_construct (GType object_type, const gchar* name, OneShotCallback callback, void* callback_target);
guint workers_threads_per_cpu (gint per, gint max);
Workers* workers_new (guint max_threads, gboolean exclusive);
Workers* workers_construct (GType object_type, guint max_threads, gboolean exclusive);
void thumbnail_cache_terminate (void);
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
void thumbnail_cache_import_from_source (ThumbnailSource* source, gboolean force, GError** error);
gchar* data_object_to_string (DataObject* self);
static void _thumbnail_cache_import_from_source (ThumbnailCache* self, ThumbnailSource* source, gboolean force, GError** error);
void thumbnail_cache_import_thumbnails (ThumbnailSource* source, Thumbnails* thumbnails, gboolean force, GError** error);
static void _thumbnail_cache_import_thumbnail (ThumbnailCache* self, ThumbnailSource* source, GdkPixbuf* scaled, gboolean force, GError** error);
void thumbnail_cache_duplicate (ThumbnailSource* src_source, ThumbnailSource* dest_source);
static void _thumbnail_cache_duplicate (ThumbnailCache* self, ThumbnailSource* src_source, ThumbnailSource* dest_source);
void thumbnail_cache_remove (ThumbnailSource* source);
static void _thumbnail_cache_remove (ThumbnailCache* self, ThumbnailSource* source);
static ThumbnailCache* thumbnail_cache_get_best_cache (gint scale);
static ThumbnailCache* thumbnail_cache_get_cache_for (ThumbnailCacheSize size);
GdkPixbuf* thumbnail_cache_fetch (ThumbnailSource* source, gint scale, GError** error);
static GdkPixbuf* _thumbnail_cache_fetch (ThumbnailCache* self, ThumbnailSource* source, GError** error);
void thumbnail_cache_fetch_async (ThumbnailSource* source, gint scale, ThumbnailCacheAsyncFetchCallback callback, void* callback_target, GCancellable* cancellable);
GType photo_file_format_get_type (void) G_GNUC_CONST;
static void _thumbnail_cache_fetch_async (ThumbnailCache* self, ThumbnailSource* source, PhotoFileFormat format, Dimensions* dim, GdkInterpType interp, ThumbnailCacheAsyncFetchCallback callback, void* callback_target, GCancellable* cancellable);
PhotoFileFormat thumbnail_source_get_preferred_thumbnail_format (ThumbnailSource* self);
void dimensions_init (Dimensions *self, gint width, gint height);
void thumbnail_cache_fetch_async_scaled (ThumbnailSource* source, gint scale, Dimensions* dim, GdkInterpType interp, ThumbnailCacheAsyncFetchCallback callback, void* callback_target, GCancellable* cancellable);
void thumbnail_cache_replace (ThumbnailSource* source, ThumbnailCacheSize size, GdkPixbuf* replacement, GError** error);
static void _thumbnail_cache_replace (ThumbnailCache* self, ThumbnailSource* source, GdkPixbuf* original, GError** error);
gboolean thumbnail_cache_exists (ThumbnailSource* source);
static gboolean _thumbnail_cache_exists (ThumbnailCache* self, ThumbnailSource* source);
GType rotation_get_type (void) G_GNUC_CONST;
void thumbnail_cache_rotate (ThumbnailSource* source, Rotation rotation, GError** error);
GdkPixbuf* rotation_perform (Rotation self, GdkPixbuf* pixbuf);
gpointer photo_file_adapter_ref (gpointer instance);
void photo_file_adapter_unref (gpointer instance);
GParamSpec* param_spec_photo_file_adapter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_adapter (GValue* value, gpointer v_object);
void value_take_photo_file_adapter (GValue* value, gpointer v_object);
gpointer value_get_photo_file_adapter (const GValue* value);
GType photo_file_adapter_get_type (void) G_GNUC_CONST;
GType photo_file_reader_get_type (void) G_GNUC_CONST;
GType orientation_get_type (void) G_GNUC_CONST;
void thumbnail_cache_generate_for_photo (Thumbnails* thumbnails, PhotoFileReader* reader, Orientation orientation, Dimensions* original_dim, GError** error);
void scaling_get_scaled_dimensions (Scaling *self, Dimensions* original, Dimensions* result);
GdkPixbuf* photo_file_reader_scaled_read (PhotoFileReader* self, Dimensions* full, Dimensions* scaled, GError** error);
GdkPixbuf* photo_file_reader_unscaled_read (PhotoFileReader* self, GError** error);
GdkPixbuf* orientation_rotate_pixbuf (Orientation self, GdkPixbuf* pixbuf);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf, Dimensions* result);
void thumbnail_cache_generate_for_video_frame (Thumbnails* thumbnails, GdkPixbuf* preview_frame);
GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self, GdkPixbuf* pixbuf, GdkInterpType interp, gboolean scale_up);
static void thumbnail_cache_schedule_debug (void);
static GdkPixbuf* thumbnail_cache_fetch_from_memory (ThumbnailCache* self, const gchar* thumbnail_name);
gchar* data_source_get_source_id (DataSource* self);
static GdkPixbuf* thumbnail_cache_read_pixbuf (ThumbnailCache* self, const gchar* thumbnail_name, PhotoFileFormat format, GError** error);
static void thumbnail_cache_store_in_memory (ThumbnailCache* self, const gchar* thumbnail_name, GdkPixbuf* thumbnail);
gboolean dimensions_has_area (Dimensions *self);
gboolean dimensions_equals (Dimensions *self, Dimensions* dim);
gpointer background_job_ref (gpointer instance);
void background_job_unref (gpointer instance);
GParamSpec* param_spec_background_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_background_job (GValue* value, gpointer v_object);
void value_take_background_job (GValue* value, gpointer v_object);
gpointer value_get_background_job (const GValue* value);
GType background_job_get_type (void) G_GNUC_CONST;
void workers_enqueue (Workers* self, BackgroundJob* job);
static ThumbnailCacheAsyncFetchJob* thumbnail_cache_async_fetch_job_new (ThumbnailCache* cache, const gchar* thumbnail_name, ThumbnailSource* source, GdkPixbuf* prefetched, Dimensions* dim, GdkInterpType interp, ThumbnailCacheAsyncFetchCallback callback, void* callback_target, GCancellable* cancellable);
static ThumbnailCacheAsyncFetchJob* thumbnail_cache_async_fetch_job_construct (GType object_type, ThumbnailCache* cache, const gchar* thumbnail_name, ThumbnailSource* source, GdkPixbuf* prefetched, Dimensions* dim, GdkInterpType interp, ThumbnailCacheAsyncFetchCallback callback, void* callback_target, GCancellable* cancellable);
static GType thumbnail_cache_async_fetch_job_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void thumbnail_cache_async_fetch_completion_callback (BackgroundJob* background_job);
GType background_job_job_priority_get_type (void) G_GNUC_CONST;
static GFile* thumbnail_cache_get_source_cached_file (ThumbnailCache* self, ThumbnailSource* source);
GType media_source_get_type (void) G_GNUC_CONST;
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType library_photo_get_type (void) G_GNUC_CONST;
GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self, Scaling* scaling, GError** error);
static void thumbnail_cache_save_thumbnail (ThumbnailCache* self, GFile* file, GdkPixbuf* pixbuf, ThumbnailSource* source, GError** error);
gboolean dimensions_approx_scaled (Dimensions *self, gint scale, gint fudge);
static GFile* thumbnail_cache_get_cached_file (ThumbnailCache* self, const gchar* thumbnail_name, PhotoFileFormat thumbnail_format);
gchar* thumbnail_source_get_representative_id (ThumbnailSource* self);
void app_window_panic (const gchar* msg);
static gboolean thumbnail_cache_remove_from_memory (ThumbnailCache* self, const gchar* thumbnail_name);
GdkPixbuf* scale_pixbuf (GdkPixbuf* pixbuf, gint scale, GdkInterpType interp, gboolean scale_up);
PhotoFileReader* photo_file_format_create_reader (PhotoFileFormat self, const gchar* filepath);
gchar* photo_file_format_get_default_basename (PhotoFileFormat self, const gchar* name);
static ThumbnailCacheImageData* thumbnail_cache_image_data_new (GdkPixbuf* pixbuf);
static ThumbnailCacheImageData* thumbnail_cache_image_data_construct (GType object_type, GdkPixbuf* pixbuf);
GType photo_file_writer_get_type (void) G_GNUC_CONST;
GQuark photo_format_error_quark (void);
PhotoFileWriter* photo_file_format_create_writer (PhotoFileFormat self, const gchar* filepath, GError** error);
void photo_file_writer_write (PhotoFileWriter* self, GdkPixbuf* pixbuf, JpegQuality quality, GError** error);
enum  {
	THUMBNAIL_CACHE_IMAGE_DATA_DUMMY_PROPERTY
};
static void thumbnail_cache_image_data_finalize (ThumbnailCacheImageData* obj);
enum  {
	THUMBNAIL_CACHE_ASYNC_FETCH_JOB_DUMMY_PROPERTY
};
static void _thumbnail_cache_async_fetch_completion_callback_completion_callback (BackgroundJob* job, gpointer self);
gpointer abstract_semaphore_ref (gpointer instance);
void abstract_semaphore_unref (gpointer instance);
GParamSpec* param_spec_abstract_semaphore (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_abstract_semaphore (GValue* value, gpointer v_object);
void value_take_abstract_semaphore (GValue* value, gpointer v_object);
gpointer value_get_abstract_semaphore (const GValue* value);
GType abstract_semaphore_get_type (void) G_GNUC_CONST;
BackgroundJob* background_job_construct (GType object_type, GObject* owner, CompletionCallback callback, void* callback_target, GCancellable* cancellable, CancellationCallback cancellation, void* cancellation_target, AbstractSemaphore* completion_semaphore);
static BackgroundJobJobPriority thumbnail_cache_async_fetch_job_real_get_priority (BackgroundJob* base);
static void thumbnail_cache_async_fetch_job_real_execute (BackgroundJob* base);
gboolean background_job_is_cancelled (BackgroundJob* self);
GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf, Dimensions* resized, GdkInterpType interp);
static void thumbnail_cache_async_fetch_job_generate_thumbnail (ThumbnailCacheAsyncFetchJob* self, GError** error);
GType video_source_get_type (void) G_GNUC_CONST;
GType video_get_type (void) G_GNUC_CONST;
GdkPixbuf* thumbnail_source_create_thumbnail (ThumbnailSource* self, gint scale, GError** error);
static void thumbnail_cache_async_fetch_job_finalize (BackgroundJob* obj);
static void thumbnail_cache_finalize (GObject* obj);


Thumbnails* thumbnails_construct (GType object_type) {
	Thumbnails* self = NULL;
#line 11 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = (Thumbnails*) g_type_create_instance (object_type);
#line 11 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return self;
#line 653 "ThumbnailCache.c"
}


Thumbnails* thumbnails_new (void) {
#line 11 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return thumbnails_construct (TYPE_THUMBNAILS);
#line 660 "ThumbnailCache.c"
}


void thumbnails_set (Thumbnails* self, ThumbnailCacheSize size, GdkPixbuf* pixbuf) {
	GeeHashMap* _tmp0_ = NULL;
	ThumbnailCacheSize _tmp1_ = 0;
	GdkPixbuf* _tmp2_ = NULL;
#line 14 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAILS (self));
#line 14 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 15 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->priv->map;
#line 15 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = size;
#line 15 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = pixbuf;
#line 15 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp1_), _tmp2_);
#line 680 "ThumbnailCache.c"
}


void thumbnails_remove (Thumbnails* self, ThumbnailCacheSize size) {
	GeeHashMap* _tmp0_ = NULL;
	ThumbnailCacheSize _tmp1_ = 0;
#line 18 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAILS (self));
#line 19 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->priv->map;
#line 19 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = size;
#line 19 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp1_), NULL);
#line 695 "ThumbnailCache.c"
}


GdkPixbuf* thumbnails_get (Thumbnails* self, ThumbnailCacheSize size) {
	GdkPixbuf* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	ThumbnailCacheSize _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
#line 22 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAILS (self), NULL);
#line 23 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->priv->map;
#line 23 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = size;
#line 23 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) _tmp1_));
#line 23 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = (GdkPixbuf*) _tmp2_;
#line 23 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 716 "ThumbnailCache.c"
}


static void value_thumbnails_init (GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	value->data[0].v_pointer = NULL;
#line 723 "ThumbnailCache.c"
}


static void value_thumbnails_free_value (GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnails_unref (value->data[0].v_pointer);
#line 732 "ThumbnailCache.c"
	}
}


static void value_thumbnails_copy_value (const GValue* src_value, GValue* dest_value) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (src_value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		dest_value->data[0].v_pointer = thumbnails_ref (src_value->data[0].v_pointer);
#line 742 "ThumbnailCache.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		dest_value->data[0].v_pointer = NULL;
#line 746 "ThumbnailCache.c"
	}
}


static gpointer value_thumbnails_peek_pointer (const GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return value->data[0].v_pointer;
#line 754 "ThumbnailCache.c"
}


static gchar* value_thumbnails_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (collect_values[0].v_pointer) {
#line 761 "ThumbnailCache.c"
		Thumbnails* object;
		object = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (object->parent_instance.g_class == NULL) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 768 "ThumbnailCache.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 772 "ThumbnailCache.c"
		}
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = thumbnails_ref (object);
#line 776 "ThumbnailCache.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = NULL;
#line 780 "ThumbnailCache.c"
	}
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return NULL;
#line 784 "ThumbnailCache.c"
}


static gchar* value_thumbnails_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Thumbnails** object_p;
	object_p = collect_values[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (!object_p) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 795 "ThumbnailCache.c"
	}
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (!value->data[0].v_pointer) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		*object_p = NULL;
#line 801 "ThumbnailCache.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		*object_p = value->data[0].v_pointer;
#line 805 "ThumbnailCache.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		*object_p = thumbnails_ref (value->data[0].v_pointer);
#line 809 "ThumbnailCache.c"
	}
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return NULL;
#line 813 "ThumbnailCache.c"
}


GParamSpec* param_spec_thumbnails (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecThumbnails* spec;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_THUMBNAILS), NULL);
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return G_PARAM_SPEC (spec);
#line 827 "ThumbnailCache.c"
}


gpointer value_get_thumbnails (const GValue* value) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THUMBNAILS), NULL);
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return value->data[0].v_pointer;
#line 836 "ThumbnailCache.c"
}


void value_set_thumbnails (GValue* value, gpointer v_object) {
	Thumbnails* old;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THUMBNAILS));
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THUMBNAILS));
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = v_object;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnails_ref (value->data[0].v_pointer);
#line 856 "ThumbnailCache.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = NULL;
#line 860 "ThumbnailCache.c"
	}
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnails_unref (old);
#line 866 "ThumbnailCache.c"
	}
}


void value_take_thumbnails (GValue* value, gpointer v_object) {
	Thumbnails* old;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THUMBNAILS));
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	old = value->data[0].v_pointer;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (v_object) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THUMBNAILS));
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = v_object;
#line 885 "ThumbnailCache.c"
	} else {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = NULL;
#line 889 "ThumbnailCache.c"
	}
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (old) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnails_unref (old);
#line 895 "ThumbnailCache.c"
	}
}


static void thumbnails_class_init (ThumbnailsClass * klass) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnails_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	((ThumbnailsClass *) klass)->finalize = thumbnails_finalize;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_type_class_add_private (klass, sizeof (ThumbnailsPrivate));
#line 907 "ThumbnailCache.c"
}


static void thumbnails_instance_init (Thumbnails * self) {
	GeeHashMap* _tmp0_ = NULL;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv = THUMBNAILS_GET_PRIVATE (self);
#line 8 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = gee_hash_map_new (THUMBNAIL_CACHE_TYPE_SIZE, NULL, NULL, GDK_TYPE_PIXBUF, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 8 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->map = _tmp0_;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->ref_count = 1;
#line 921 "ThumbnailCache.c"
}


static void thumbnails_finalize (Thumbnails* obj) {
	Thumbnails * self;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THUMBNAILS, Thumbnails);
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_signal_handlers_destroy (self);
#line 8 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->priv->map);
#line 933 "ThumbnailCache.c"
}


GType thumbnails_get_type (void) {
	static volatile gsize thumbnails_type_id__volatile = 0;
	if (g_once_init_enter (&thumbnails_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_thumbnails_init, value_thumbnails_free_value, value_thumbnails_copy_value, value_thumbnails_peek_pointer, "p", value_thumbnails_collect_value, "p", value_thumbnails_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ThumbnailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnails_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Thumbnails), 0, (GInstanceInitFunc) thumbnails_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType thumbnails_type_id;
		thumbnails_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Thumbnails", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&thumbnails_type_id__volatile, thumbnails_type_id);
	}
	return thumbnails_type_id__volatile;
}


gpointer thumbnails_ref (gpointer instance) {
	Thumbnails* self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_atomic_int_inc (&self->ref_count);
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return instance;
#line 958 "ThumbnailCache.c"
}


void thumbnails_unref (gpointer instance) {
	Thumbnails* self;
	self = instance;
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		THUMBNAILS_GET_CLASS (self)->finalize (self);
#line 7 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 971 "ThumbnailCache.c"
	}
}


gint thumbnail_cache_size_get_scale (ThumbnailCacheSize self) {
	gint result = 0;
#line 42 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = (gint) self;
#line 42 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 982 "ThumbnailCache.c"
}


void thumbnail_cache_size_get_scaling (ThumbnailCacheSize self, Scaling* result) {
	gint _tmp0_ = 0;
	Scaling _tmp1_ = {0};
#line 46 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_size_get_scale (self);
#line 46 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	scaling_for_best_fit (_tmp0_, TRUE, &_tmp1_);
#line 46 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	*result = _tmp1_;
#line 46 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return;
#line 997 "ThumbnailCache.c"
}


ThumbnailCacheSize thumbnail_cache_size_get_best_size (gint scale) {
	ThumbnailCacheSize result = 0;
	ThumbnailCacheSize _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 50 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = scale;
#line 50 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = thumbnail_cache_size_get_scale (THUMBNAIL_CACHE_SIZE_MEDIUM);
#line 50 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp1_ <= _tmp2_) {
#line 50 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp0_ = THUMBNAIL_CACHE_SIZE_MEDIUM;
#line 1014 "ThumbnailCache.c"
	} else {
#line 50 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp0_ = THUMBNAIL_CACHE_SIZE_BIG;
#line 1018 "ThumbnailCache.c"
	}
#line 50 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = _tmp0_;
#line 50 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 1024 "ThumbnailCache.c"
}


GType thumbnail_cache_size_get_type (void) {
	static volatile gsize thumbnail_cache_size_type_id__volatile = 0;
	if (g_once_init_enter (&thumbnail_cache_size_type_id__volatile)) {
		static const GEnumValue values[] = {{THUMBNAIL_CACHE_SIZE_LARGEST, "THUMBNAIL_CACHE_SIZE_LARGEST", "largest"}, {THUMBNAIL_CACHE_SIZE_BIG, "THUMBNAIL_CACHE_SIZE_BIG", "big"}, {THUMBNAIL_CACHE_SIZE_MEDIUM, "THUMBNAIL_CACHE_SIZE_MEDIUM", "medium"}, {THUMBNAIL_CACHE_SIZE_SMALLEST, "THUMBNAIL_CACHE_SIZE_SMALLEST", "smallest"}, {0, NULL, NULL}};
		GType thumbnail_cache_size_type_id;
		thumbnail_cache_size_type_id = g_enum_register_static ("ThumbnailCacheSize", values);
		g_once_init_leave (&thumbnail_cache_size_type_id__volatile, thumbnail_cache_size_type_id);
	}
	return thumbnail_cache_size_type_id__volatile;
}


static ThumbnailCache* thumbnail_cache_construct (GType object_type, ThumbnailCacheSize size, gulong max_cached_bytes, GdkInterpType interp, JpegQuality quality) {
	ThumbnailCache * self = NULL;
	ThumbnailCacheSize _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	ThumbnailCacheSize _tmp5_ = 0;
	gulong _tmp6_ = 0UL;
	GdkInterpType _tmp7_ = 0;
	JpegQuality _tmp8_ = 0;
#line 190 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = (ThumbnailCache*) g_object_new (object_type, NULL);
#line 192 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = size;
#line 192 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_cache_size_get_scale (_tmp0_);
#line 192 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = g_strdup_printf ("thumbs%d", _tmp1_);
#line 192 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = _tmp2_;
#line 192 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = app_dirs_get_cache_subdir ("thumbs", _tmp3_);
#line 192 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->priv->cache_dir);
#line 192 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->cache_dir = _tmp4_;
#line 192 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp3_);
#line 193 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = size;
#line 193 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->size = _tmp5_;
#line 194 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = max_cached_bytes;
#line 194 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->max_cached_bytes = _tmp6_;
#line 195 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = interp;
#line 195 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->interp = _tmp7_;
#line 196 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = quality;
#line 196 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->quality = _tmp8_;
#line 190 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return self;
#line 1087 "ThumbnailCache.c"
}


static ThumbnailCache* thumbnail_cache_new (ThumbnailCacheSize size, gulong max_cached_bytes, GdkInterpType interp, JpegQuality quality) {
#line 190 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return thumbnail_cache_construct (TYPE_THUMBNAIL_CACHE, size, max_cached_bytes, interp, quality);
#line 1094 "ThumbnailCache.c"
}


static void _thumbnail_cache_report_cycle_one_shot_callback (gpointer self) {
#line 201 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_report_cycle ();
#line 1101 "ThumbnailCache.c"
}


void thumbnail_cache_init (void) {
	OneShotScheduler* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	Workers* _tmp2_ = NULL;
	ThumbnailCache* _tmp3_ = NULL;
	ThumbnailCache* _tmp4_ = NULL;
#line 201 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = one_shot_scheduler_new ("ThumbnailCache cycle reporter", _thumbnail_cache_report_cycle_one_shot_callback, NULL);
#line 201 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_one_shot_scheduler_unref0 (thumbnail_cache_debug_scheduler);
#line 201 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_debug_scheduler = _tmp0_;
#line 202 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = workers_threads_per_cpu (1, -1);
#line 202 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = workers_new (_tmp1_, TRUE);
#line 202 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_workers_unref0 (thumbnail_cache_fetch_workers);
#line 202 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_fetch_workers = _tmp2_;
#line 204 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = thumbnail_cache_new (THUMBNAIL_CACHE_SIZE_BIG, THUMBNAIL_CACHE_MAX_BIG_CACHED_BYTES, THUMBNAIL_CACHE_DEFAULT_INTERP, THUMBNAIL_CACHE_DEFAULT_QUALITY);
#line 204 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (thumbnail_cache_big);
#line 204 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_big = _tmp3_;
#line 205 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = thumbnail_cache_new (THUMBNAIL_CACHE_SIZE_MEDIUM, THUMBNAIL_CACHE_MAX_MEDIUM_CACHED_BYTES, THUMBNAIL_CACHE_DEFAULT_INTERP, THUMBNAIL_CACHE_DEFAULT_QUALITY);
#line 205 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (thumbnail_cache_medium);
#line 205 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_medium = _tmp4_;
#line 1137 "ThumbnailCache.c"
}


void thumbnail_cache_terminate (void) {
}


void thumbnail_cache_import_from_source (ThumbnailSource* source, gboolean force, GError** error) {
	ThumbnailSource* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	ThumbnailCache* _tmp3_ = NULL;
	ThumbnailSource* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	ThumbnailCache* _tmp6_ = NULL;
	ThumbnailSource* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GError * _inner_error_ = NULL;
#line 211 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 213 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = source;
#line 213 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_OBJECT, DataObject));
#line 213 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = _tmp1_;
#line 213 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_debug ("ThumbnailCache.vala:213: import from source: %s", _tmp2_);
#line 213 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp2_);
#line 214 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = thumbnail_cache_big;
#line 214 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = source;
#line 214 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = force;
#line 214 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_import_from_source (_tmp3_, _tmp4_, _tmp5_, &_inner_error_);
#line 214 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 214 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 214 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 1182 "ThumbnailCache.c"
	}
#line 215 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = thumbnail_cache_medium;
#line 215 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = source;
#line 215 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = force;
#line 215 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_import_from_source (_tmp6_, _tmp7_, _tmp8_, &_inner_error_);
#line 215 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 215 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 215 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 1198 "ThumbnailCache.c"
	}
}


void thumbnail_cache_import_thumbnails (ThumbnailSource* source, Thumbnails* thumbnails, gboolean force, GError** error) {
	ThumbnailCache* _tmp0_ = NULL;
	ThumbnailSource* _tmp1_ = NULL;
	Thumbnails* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	ThumbnailCache* _tmp6_ = NULL;
	ThumbnailSource* _tmp7_ = NULL;
	Thumbnails* _tmp8_ = NULL;
	GdkPixbuf* _tmp9_ = NULL;
	GdkPixbuf* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GError * _inner_error_ = NULL;
#line 218 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 218 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAILS (thumbnails));
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_big;
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = source;
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = thumbnails;
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = thumbnails_get (_tmp2_, THUMBNAIL_CACHE_SIZE_BIG);
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = _tmp3_;
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = force;
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_import_thumbnail (_tmp0_, _tmp1_, _tmp4_, _tmp5_, &_inner_error_);
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp4_);
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 220 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 1243 "ThumbnailCache.c"
	}
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = thumbnail_cache_medium;
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = source;
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = thumbnails;
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp9_ = thumbnails_get (_tmp8_, THUMBNAIL_CACHE_SIZE_MEDIUM);
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp10_ = _tmp9_;
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp11_ = force;
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_import_thumbnail (_tmp6_, _tmp7_, _tmp10_, _tmp11_, &_inner_error_);
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp10_);
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 221 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 1267 "ThumbnailCache.c"
	}
}


void thumbnail_cache_duplicate (ThumbnailSource* src_source, ThumbnailSource* dest_source) {
	ThumbnailCache* _tmp0_ = NULL;
	ThumbnailSource* _tmp1_ = NULL;
	ThumbnailSource* _tmp2_ = NULL;
	ThumbnailCache* _tmp3_ = NULL;
	ThumbnailSource* _tmp4_ = NULL;
	ThumbnailSource* _tmp5_ = NULL;
#line 224 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (src_source));
#line 224 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (dest_source));
#line 225 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_big;
#line 225 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = src_source;
#line 225 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = dest_source;
#line 225 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_duplicate (_tmp0_, _tmp1_, _tmp2_);
#line 226 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = thumbnail_cache_medium;
#line 226 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = src_source;
#line 226 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = dest_source;
#line 226 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_duplicate (_tmp3_, _tmp4_, _tmp5_);
#line 1299 "ThumbnailCache.c"
}


void thumbnail_cache_remove (ThumbnailSource* source) {
	ThumbnailCache* _tmp0_ = NULL;
	ThumbnailSource* _tmp1_ = NULL;
	ThumbnailCache* _tmp2_ = NULL;
	ThumbnailSource* _tmp3_ = NULL;
#line 229 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 230 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_big;
#line 230 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = source;
#line 230 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_remove (_tmp0_, _tmp1_);
#line 231 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = thumbnail_cache_medium;
#line 231 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = source;
#line 231 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_remove (_tmp2_, _tmp3_);
#line 1322 "ThumbnailCache.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 237 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return self ? g_object_ref (self) : NULL;
#line 1329 "ThumbnailCache.c"
}


static ThumbnailCache* thumbnail_cache_get_best_cache (gint scale) {
	ThumbnailCache* result = NULL;
	ThumbnailCacheSize size = 0;
	gint _tmp0_ = 0;
	ThumbnailCacheSize _tmp1_ = 0;
	ThumbnailCacheSize _tmp2_ = 0;
#line 235 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = scale;
#line 235 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_cache_size_get_best_size (_tmp0_);
#line 235 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	size = _tmp1_;
#line 236 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = size;
#line 236 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp2_ == THUMBNAIL_CACHE_SIZE_BIG) {
#line 1349 "ThumbnailCache.c"
		ThumbnailCache* _tmp3_ = NULL;
		ThumbnailCache* _tmp4_ = NULL;
#line 237 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp3_ = thumbnail_cache_big;
#line 237 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 237 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		result = _tmp4_;
#line 237 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return result;
#line 1360 "ThumbnailCache.c"
	} else {
		ThumbnailCacheSize _tmp5_ = 0;
		ThumbnailCache* _tmp6_ = NULL;
		ThumbnailCache* _tmp7_ = NULL;
#line 239 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp5_ = size;
#line 239 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_vala_assert (_tmp5_ == THUMBNAIL_CACHE_SIZE_MEDIUM, "size == Size.MEDIUM");
#line 241 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp6_ = thumbnail_cache_medium;
#line 241 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 241 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		result = _tmp7_;
#line 241 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return result;
#line 1377 "ThumbnailCache.c"
	}
}


static ThumbnailCache* thumbnail_cache_get_cache_for (ThumbnailCacheSize size) {
	ThumbnailCache* result = NULL;
	ThumbnailCacheSize _tmp0_ = 0;
#line 246 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = size;
#line 246 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	switch (_tmp0_) {
#line 246 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		case THUMBNAIL_CACHE_SIZE_BIG:
#line 1391 "ThumbnailCache.c"
		{
			ThumbnailCache* _tmp1_ = NULL;
			ThumbnailCache* _tmp2_ = NULL;
#line 248 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp1_ = thumbnail_cache_big;
#line 248 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp2_ = _g_object_ref0 (_tmp1_);
#line 248 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			result = _tmp2_;
#line 248 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return result;
#line 1403 "ThumbnailCache.c"
		}
#line 246 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		case THUMBNAIL_CACHE_SIZE_MEDIUM:
#line 1407 "ThumbnailCache.c"
		{
			ThumbnailCache* _tmp3_ = NULL;
			ThumbnailCache* _tmp4_ = NULL;
#line 251 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp3_ = thumbnail_cache_medium;
#line 251 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp4_ = _g_object_ref0 (_tmp3_);
#line 251 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			result = _tmp4_;
#line 251 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return result;
#line 1419 "ThumbnailCache.c"
		}
		default:
		{
			ThumbnailCacheSize _tmp5_ = 0;
			gint _tmp6_ = 0;
#line 254 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp5_ = size;
#line 254 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp6_ = thumbnail_cache_size_get_scale (_tmp5_);
#line 254 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			g_error ("ThumbnailCache.vala:254: Unknown thumbnail size %d", _tmp6_);
#line 1431 "ThumbnailCache.c"
		}
	}
}


GdkPixbuf* thumbnail_cache_fetch (ThumbnailSource* source, gint scale, GError** error) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ThumbnailCache* _tmp2_ = NULL;
	ThumbnailCache* _tmp3_ = NULL;
	ThumbnailSource* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_ = NULL;
	GdkPixbuf* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
#line 258 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), NULL);
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = scale;
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = thumbnail_cache_get_best_cache (_tmp1_);
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = _tmp2_;
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = source;
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = _thumbnail_cache_fetch (_tmp3_, _tmp4_, &_inner_error_);
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = _tmp5_;
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp3_);
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = _tmp6_;
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return NULL;
#line 1472 "ThumbnailCache.c"
	}
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = _tmp0_;
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = NULL;
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = _tmp7_;
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp0_);
#line 259 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 1484 "ThumbnailCache.c"
}


void thumbnail_cache_fetch_async (ThumbnailSource* source, gint scale, ThumbnailCacheAsyncFetchCallback callback, void* callback_target, GCancellable* cancellable) {
	gint _tmp0_ = 0;
	ThumbnailCache* _tmp1_ = NULL;
	ThumbnailCache* _tmp2_ = NULL;
	ThumbnailSource* _tmp3_ = NULL;
	ThumbnailSource* _tmp4_ = NULL;
	PhotoFileFormat _tmp5_ = 0;
	Dimensions _tmp6_ = {0};
	ThumbnailCacheAsyncFetchCallback _tmp7_ = NULL;
	void* _tmp7__target = NULL;
	GCancellable* _tmp8_ = NULL;
#line 262 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 262 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable));
#line 264 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = scale;
#line 264 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_cache_get_best_cache (_tmp0_);
#line 264 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = _tmp1_;
#line 264 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = source;
#line 264 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = source;
#line 264 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = thumbnail_source_get_preferred_thumbnail_format (_tmp4_);
#line 264 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	dimensions_init (&_tmp6_, 0, 0);
#line 264 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = callback;
#line 264 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7__target = callback_target;
#line 264 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = cancellable;
#line 264 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_fetch_async (_tmp2_, _tmp3_, _tmp5_, &_tmp6_, THUMBNAIL_CACHE_DEFAULT_INTERP, _tmp7_, _tmp7__target, _tmp8_);
#line 264 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp2_);
#line 1527 "ThumbnailCache.c"
}


void thumbnail_cache_fetch_async_scaled (ThumbnailSource* source, gint scale, Dimensions* dim, GdkInterpType interp, ThumbnailCacheAsyncFetchCallback callback, void* callback_target, GCancellable* cancellable) {
	gint _tmp0_ = 0;
	ThumbnailCache* _tmp1_ = NULL;
	ThumbnailCache* _tmp2_ = NULL;
	ThumbnailSource* _tmp3_ = NULL;
	ThumbnailSource* _tmp4_ = NULL;
	PhotoFileFormat _tmp5_ = 0;
	Dimensions _tmp6_ = {0};
	GdkInterpType _tmp7_ = 0;
	ThumbnailCacheAsyncFetchCallback _tmp8_ = NULL;
	void* _tmp8__target = NULL;
	GCancellable* _tmp9_ = NULL;
#line 268 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 268 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (dim != NULL);
#line 268 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable));
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = scale;
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_cache_get_best_cache (_tmp0_);
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = _tmp1_;
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = source;
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = source;
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = thumbnail_source_get_preferred_thumbnail_format (_tmp4_);
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = *dim;
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = interp;
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = callback;
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8__target = callback_target;
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp9_ = cancellable;
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_fetch_async (_tmp2_, _tmp3_, _tmp5_, &_tmp6_, _tmp7_, _tmp8_, _tmp8__target, _tmp9_);
#line 270 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp2_);
#line 1575 "ThumbnailCache.c"
}


void thumbnail_cache_replace (ThumbnailSource* source, ThumbnailCacheSize size, GdkPixbuf* replacement, GError** error) {
	ThumbnailCacheSize _tmp0_ = 0;
	ThumbnailCache* _tmp1_ = NULL;
	ThumbnailCache* _tmp2_ = NULL;
	ThumbnailSource* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 274 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 274 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (GDK_IS_PIXBUF (replacement));
#line 276 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = size;
#line 276 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_cache_get_cache_for (_tmp0_);
#line 276 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = _tmp1_;
#line 276 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = source;
#line 276 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = replacement;
#line 276 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_replace (_tmp2_, _tmp3_, _tmp4_, &_inner_error_);
#line 276 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp2_);
#line 276 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 276 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 276 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 1610 "ThumbnailCache.c"
	}
}


gboolean thumbnail_cache_exists (ThumbnailSource* source) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ThumbnailCache* _tmp1_ = NULL;
	ThumbnailSource* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 279 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), FALSE);
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_cache_big;
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = source;
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = _thumbnail_cache_exists (_tmp1_, _tmp2_);
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp3_) {
#line 1631 "ThumbnailCache.c"
		ThumbnailCache* _tmp4_ = NULL;
		ThumbnailSource* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp4_ = thumbnail_cache_medium;
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp5_ = source;
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp6_ = _thumbnail_cache_exists (_tmp4_, _tmp5_);
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp0_ = _tmp6_;
#line 1643 "ThumbnailCache.c"
	} else {
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp0_ = FALSE;
#line 1647 "ThumbnailCache.c"
	}
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = _tmp0_;
#line 280 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 1653 "ThumbnailCache.c"
}


void thumbnail_cache_rotate (ThumbnailSource* source, Rotation rotation, GError** error) {
	ThumbnailCacheSize* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GError * _inner_error_ = NULL;
#line 283 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 284 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_ALL_SIZES;
#line 284 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0__length1 = thumbnail_cache_ALL_SIZES_length1;
#line 1667 "ThumbnailCache.c"
	{
		ThumbnailCacheSize* size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
#line 284 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		size_collection = _tmp0_;
#line 284 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		size_collection_length1 = _tmp0__length1;
#line 284 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		for (size_it = 0; size_it < _tmp0__length1; size_it = size_it + 1) {
#line 1679 "ThumbnailCache.c"
			ThumbnailCacheSize size = 0;
#line 284 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			size = size_collection[size_it];
#line 1683 "ThumbnailCache.c"
			{
				GdkPixbuf* thumbnail = NULL;
				ThumbnailSource* _tmp1_ = NULL;
				ThumbnailCacheSize _tmp2_ = 0;
				GdkPixbuf* _tmp3_ = NULL;
				Rotation _tmp4_ = 0;
				GdkPixbuf* _tmp5_ = NULL;
				GdkPixbuf* _tmp6_ = NULL;
				ThumbnailSource* _tmp7_ = NULL;
				ThumbnailCacheSize _tmp8_ = 0;
				GdkPixbuf* _tmp9_ = NULL;
#line 285 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp1_ = source;
#line 285 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp2_ = size;
#line 285 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp3_ = thumbnail_cache_fetch (_tmp1_, (gint) _tmp2_, &_inner_error_);
#line 285 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				thumbnail = _tmp3_;
#line 285 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 285 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
					g_propagate_error (error, _inner_error_);
#line 285 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
					return;
#line 1709 "ThumbnailCache.c"
				}
#line 286 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp4_ = rotation;
#line 286 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp5_ = thumbnail;
#line 286 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp6_ = rotation_perform (_tmp4_, _tmp5_);
#line 286 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_object_unref0 (thumbnail);
#line 286 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				thumbnail = _tmp6_;
#line 287 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp7_ = source;
#line 287 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp8_ = size;
#line 287 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp9_ = thumbnail;
#line 287 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				thumbnail_cache_replace (_tmp7_, _tmp8_, _tmp9_, &_inner_error_);
#line 287 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 287 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
					g_propagate_error (error, _inner_error_);
#line 287 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
					_g_object_unref0 (thumbnail);
#line 287 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
					return;
#line 1737 "ThumbnailCache.c"
				}
#line 284 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_object_unref0 (thumbnail);
#line 1741 "ThumbnailCache.c"
			}
		}
	}
}


void thumbnail_cache_generate_for_photo (Thumbnails* thumbnails, PhotoFileReader* reader, Orientation orientation, Dimensions* original_dim, GError** error) {
	ThumbnailCacheSize max_size = 0;
	Dimensions dim = {0};
	ThumbnailCacheSize _tmp0_ = 0;
	Scaling _tmp1_ = {0};
	Dimensions _tmp2_ = {0};
	Dimensions _tmp3_ = {0};
	GdkPixbuf* largest_thumbnail = NULL;
	Orientation _tmp14_ = 0;
	GdkPixbuf* _tmp15_ = NULL;
	GdkPixbuf* _tmp16_ = NULL;
	Dimensions largest_thumb_dimensions = {0};
	GdkPixbuf* _tmp17_ = NULL;
	Dimensions _tmp18_ = {0};
	ThumbnailCacheSize* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	GError * _inner_error_ = NULL;
#line 293 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAILS (thumbnails));
#line 293 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_PHOTO_FILE_READER (reader));
#line 293 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (original_dim != NULL);
#line 296 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	max_size = THUMBNAIL_CACHE_SIZE_BIG * 2;
#line 297 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = max_size;
#line 297 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_size_get_scaling (_tmp0_, &_tmp1_);
#line 297 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = *original_dim;
#line 297 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	scaling_get_scaled_dimensions (&_tmp1_, &_tmp2_, &_tmp3_);
#line 297 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	dim = _tmp3_;
#line 298 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	largest_thumbnail = NULL;
#line 1785 "ThumbnailCache.c"
	{
		GdkPixbuf* _tmp4_ = NULL;
		PhotoFileReader* _tmp5_ = NULL;
		Dimensions _tmp6_ = {0};
		Dimensions _tmp7_ = {0};
		GdkPixbuf* _tmp8_ = NULL;
		GdkPixbuf* _tmp9_ = NULL;
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp5_ = reader;
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp6_ = *original_dim;
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp7_ = dim;
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp8_ = photo_file_reader_scaled_read (_tmp5_, &_tmp6_, &_tmp7_, &_inner_error_);
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp4_ = _tmp8_;
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1805 "ThumbnailCache.c"
			goto __catch236_g_error;
		}
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp9_ = _tmp4_;
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp4_ = NULL;
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (largest_thumbnail);
#line 300 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		largest_thumbnail = _tmp9_;
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (_tmp4_);
#line 1818 "ThumbnailCache.c"
	}
	goto __finally236;
	__catch236_g_error:
	{
		GError* err = NULL;
		GdkPixbuf* _tmp10_ = NULL;
		PhotoFileReader* _tmp11_ = NULL;
		GdkPixbuf* _tmp12_ = NULL;
		GdkPixbuf* _tmp13_ = NULL;
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		err = _inner_error_;
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_inner_error_ = NULL;
#line 305 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp11_ = reader;
#line 305 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp12_ = photo_file_reader_unscaled_read (_tmp11_, &_inner_error_);
#line 305 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp10_ = _tmp12_;
#line 305 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 305 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_error_free0 (err);
#line 1842 "ThumbnailCache.c"
			goto __finally236;
		}
#line 305 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp13_ = _tmp10_;
#line 305 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp10_ = NULL;
#line 305 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (largest_thumbnail);
#line 305 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		largest_thumbnail = _tmp13_;
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (_tmp10_);
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_error_free0 (err);
#line 1857 "ThumbnailCache.c"
	}
	__finally236:
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (largest_thumbnail);
#line 299 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 1868 "ThumbnailCache.c"
	}
#line 307 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp14_ = orientation;
#line 307 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp15_ = largest_thumbnail;
#line 307 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp16_ = orientation_rotate_pixbuf (_tmp14_, _tmp15_);
#line 307 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (largest_thumbnail);
#line 307 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	largest_thumbnail = _tmp16_;
#line 308 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp17_ = largest_thumbnail;
#line 308 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	dimensions_for_pixbuf (_tmp17_, &_tmp18_);
#line 308 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	largest_thumb_dimensions = _tmp18_;
#line 310 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp19_ = thumbnail_cache_ALL_SIZES;
#line 310 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp19__length1 = thumbnail_cache_ALL_SIZES_length1;
#line 1890 "ThumbnailCache.c"
	{
		ThumbnailCacheSize* size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
#line 310 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		size_collection = _tmp19_;
#line 310 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		size_collection_length1 = _tmp19__length1;
#line 310 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		for (size_it = 0; size_it < _tmp19__length1; size_it = size_it + 1) {
#line 1902 "ThumbnailCache.c"
			ThumbnailCacheSize size = 0;
#line 310 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			size = size_collection[size_it];
#line 1906 "ThumbnailCache.c"
			{
				ThumbnailCacheSize _tmp20_ = 0;
				Scaling _tmp21_ = {0};
				Dimensions _tmp22_ = {0};
				Dimensions _tmp23_ = {0};
				Thumbnails* _tmp24_ = NULL;
				ThumbnailCacheSize _tmp25_ = 0;
				GdkPixbuf* _tmp26_ = NULL;
				Dimensions _tmp27_ = {0};
				gint _tmp28_ = 0;
				Dimensions _tmp29_ = {0};
				gint _tmp30_ = 0;
				GdkPixbuf* _tmp31_ = NULL;
				GdkPixbuf* _tmp32_ = NULL;
#line 311 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp20_ = size;
#line 311 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				thumbnail_cache_size_get_scaling (_tmp20_, &_tmp21_);
#line 311 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp22_ = largest_thumb_dimensions;
#line 311 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				scaling_get_scaled_dimensions (&_tmp21_, &_tmp22_, &_tmp23_);
#line 311 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				dim = _tmp23_;
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp24_ = thumbnails;
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp25_ = size;
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp26_ = largest_thumbnail;
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp27_ = dim;
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp28_ = _tmp27_.width;
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp29_ = dim;
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp30_ = _tmp29_.height;
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp31_ = gdk_pixbuf_scale_simple (_tmp26_, _tmp28_, _tmp30_, GDK_INTERP_HYPER);
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp32_ = _tmp31_;
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				thumbnails_set (_tmp24_, _tmp25_, _tmp32_);
#line 312 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_object_unref0 (_tmp32_);
#line 1953 "ThumbnailCache.c"
			}
		}
	}
#line 293 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (largest_thumbnail);
#line 1959 "ThumbnailCache.c"
}


void thumbnail_cache_generate_for_video_frame (Thumbnails* thumbnails, GdkPixbuf* preview_frame) {
	ThumbnailCacheSize* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
#line 316 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAILS (thumbnails));
#line 316 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (GDK_IS_PIXBUF (preview_frame));
#line 317 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_ALL_SIZES;
#line 317 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0__length1 = thumbnail_cache_ALL_SIZES_length1;
#line 1974 "ThumbnailCache.c"
	{
		ThumbnailCacheSize* size_collection = NULL;
		gint size_collection_length1 = 0;
		gint _size_collection_size_ = 0;
		gint size_it = 0;
#line 317 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		size_collection = _tmp0_;
#line 317 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		size_collection_length1 = _tmp0__length1;
#line 317 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		for (size_it = 0; size_it < _tmp0__length1; size_it = size_it + 1) {
#line 1986 "ThumbnailCache.c"
			ThumbnailCacheSize size = 0;
#line 317 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			size = size_collection[size_it];
#line 1990 "ThumbnailCache.c"
			{
				Scaling current_scaling = {0};
				ThumbnailCacheSize _tmp1_ = 0;
				Scaling _tmp2_ = {0};
				GdkPixbuf* current_thumbnail = NULL;
				GdkPixbuf* _tmp3_ = NULL;
				GdkPixbuf* _tmp4_ = NULL;
				Thumbnails* _tmp5_ = NULL;
				ThumbnailCacheSize _tmp6_ = 0;
				GdkPixbuf* _tmp7_ = NULL;
#line 318 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp1_ = size;
#line 318 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				thumbnail_cache_size_get_scaling (_tmp1_, &_tmp2_);
#line 318 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				current_scaling = _tmp2_;
#line 319 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp3_ = preview_frame;
#line 319 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp4_ = scaling_perform_on_pixbuf (&current_scaling, _tmp3_, GDK_INTERP_HYPER, TRUE);
#line 319 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				current_thumbnail = _tmp4_;
#line 321 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp5_ = thumbnails;
#line 321 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp6_ = size;
#line 321 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp7_ = current_thumbnail;
#line 321 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				thumbnails_set (_tmp5_, _tmp6_, _tmp7_);
#line 317 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_object_unref0 (current_thumbnail);
#line 2023 "ThumbnailCache.c"
			}
		}
	}
}


static void thumbnail_cache_schedule_debug (void) {
}


static void thumbnail_cache_report_cycle (void) {
}


static GdkPixbuf* _thumbnail_cache_fetch (ThumbnailCache* self, ThumbnailSource* source, GError** error) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* pixbuf = NULL;
	ThumbnailSource* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	GdkPixbuf* _tmp4_ = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	GdkPixbuf* _tmp6_ = NULL;
	ThumbnailSource* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	ThumbnailSource* _tmp10_ = NULL;
	PhotoFileFormat _tmp11_ = 0;
	GdkPixbuf* _tmp12_ = NULL;
	GdkPixbuf* _tmp13_ = NULL;
	GdkPixbuf* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	ThumbnailSource* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	GdkPixbuf* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
#line 371 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), NULL);
#line 371 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), NULL);
#line 373 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = source;
#line 373 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_SOURCE, DataSource));
#line 373 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = _tmp1_;
#line 373 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = thumbnail_cache_fetch_from_memory (self, _tmp2_);
#line 373 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = _tmp3_;
#line 373 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp2_);
#line 373 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	pixbuf = _tmp4_;
#line 374 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = pixbuf;
#line 374 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp5_ != NULL) {
#line 375 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		result = pixbuf;
#line 375 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return result;
#line 2088 "ThumbnailCache.c"
	}
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = source;
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DATA_SOURCE, DataSource));
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp9_ = _tmp8_;
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp10_ = source;
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp11_ = thumbnail_source_get_preferred_thumbnail_format (_tmp10_);
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp12_ = thumbnail_cache_read_pixbuf (self, _tmp9_, _tmp11_, &_inner_error_);
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp13_ = _tmp12_;
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp9_);
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = _tmp13_;
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (pixbuf);
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return NULL;
#line 2116 "ThumbnailCache.c"
	}
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp14_ = _tmp6_;
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = NULL;
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (pixbuf);
#line 377 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	pixbuf = _tmp14_;
#line 379 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp15_ = thumbnail_cache_cycle_fetched_thumbnails;
#line 379 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_cycle_fetched_thumbnails = _tmp15_ + 1;
#line 380 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_schedule_debug ();
#line 383 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp16_ = source;
#line 383 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp17_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_DATA_SOURCE, DataSource));
#line 383 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp18_ = _tmp17_;
#line 383 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp19_ = pixbuf;
#line 383 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_store_in_memory (self, _tmp18_, _tmp19_);
#line 383 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp18_);
#line 385 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = pixbuf;
#line 385 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp6_);
#line 385 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 2150 "ThumbnailCache.c"
}


static void _thumbnail_cache_fetch_async (ThumbnailCache* self, ThumbnailSource* source, PhotoFileFormat format, Dimensions* dim, GdkInterpType interp, ThumbnailCacheAsyncFetchCallback callback, void* callback_target, GCancellable* cancellable) {
	gchar* thumbnail_name = NULL;
	ThumbnailSource* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GdkPixbuf* pixbuf = NULL;
	const gchar* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GdkPixbuf* _tmp5_ = NULL;
	Workers* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	ThumbnailSource* _tmp19_ = NULL;
	GdkPixbuf* _tmp20_ = NULL;
	Dimensions _tmp21_ = {0};
	GdkInterpType _tmp22_ = 0;
	ThumbnailCacheAsyncFetchCallback _tmp23_ = NULL;
	void* _tmp23__target = NULL;
	GCancellable* _tmp24_ = NULL;
	ThumbnailCacheAsyncFetchJob* _tmp25_ = NULL;
	ThumbnailCacheAsyncFetchJob* _tmp26_ = NULL;
#line 388 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
#line 388 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 388 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (dim != NULL);
#line 388 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable));
#line 391 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = source;
#line 391 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DATA_SOURCE, DataSource));
#line 391 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_name = _tmp1_;
#line 392 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = thumbnail_name;
#line 392 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = thumbnail_cache_fetch_from_memory (self, _tmp2_);
#line 392 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	pixbuf = _tmp3_;
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = pixbuf;
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp5_ != NULL) {
#line 2198 "ThumbnailCache.c"
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp7_ = dimensions_has_area (dim);
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (!_tmp7_) {
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp6_ = TRUE;
#line 2207 "ThumbnailCache.c"
		} else {
			GdkPixbuf* _tmp8_ = NULL;
			Dimensions _tmp9_ = {0};
			Dimensions _tmp10_ = {0};
			gboolean _tmp11_ = FALSE;
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp8_ = pixbuf;
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			dimensions_for_pixbuf (_tmp8_, &_tmp9_);
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp10_ = *dim;
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp11_ = dimensions_equals (&_tmp9_, &_tmp10_);
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp6_ = _tmp11_;
#line 2223 "ThumbnailCache.c"
		}
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp4_ = _tmp6_;
#line 2227 "ThumbnailCache.c"
	} else {
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp4_ = FALSE;
#line 2231 "ThumbnailCache.c"
	}
#line 393 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp4_) {
#line 2235 "ThumbnailCache.c"
		ThumbnailCacheAsyncFetchCallback _tmp12_ = NULL;
		void* _tmp12__target = NULL;
		GdkPixbuf* _tmp13_ = NULL;
		GdkPixbuf* _tmp14_ = NULL;
		Dimensions _tmp15_ = {0};
		GdkInterpType _tmp16_ = 0;
#line 396 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp12_ = callback;
#line 396 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp12__target = callback_target;
#line 396 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp13_ = pixbuf;
#line 396 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp14_ = pixbuf;
#line 396 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp15_ = *dim;
#line 396 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp16_ = interp;
#line 396 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp12_ (_tmp13_, _tmp14_, &_tmp15_, _tmp16_, NULL, _tmp12__target);
#line 398 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (pixbuf);
#line 398 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_free0 (thumbnail_name);
#line 398 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 2262 "ThumbnailCache.c"
	}
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp17_ = thumbnail_cache_fetch_workers;
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp18_ = thumbnail_name;
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp19_ = source;
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp20_ = pixbuf;
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp21_ = *dim;
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp22_ = interp;
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp23_ = callback;
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp23__target = callback_target;
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp24_ = cancellable;
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp25_ = thumbnail_cache_async_fetch_job_new (self, _tmp18_, _tmp19_, _tmp20_, &_tmp21_, _tmp22_, _tmp23_, _tmp23__target, _tmp24_);
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp26_ = _tmp25_;
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	workers_enqueue (_tmp17_, G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 411 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_background_job_unref0 (_tmp26_);
#line 388 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (pixbuf);
#line 388 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (thumbnail_name);
#line 2294 "ThumbnailCache.c"
}


static gpointer _background_job_ref0 (gpointer self) {
#line 417 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return self ? background_job_ref (self) : NULL;
#line 2301 "ThumbnailCache.c"
}


static gpointer _g_error_copy0 (gpointer self) {
#line 425 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return self ? g_error_copy (self) : NULL;
#line 2308 "ThumbnailCache.c"
}


static void thumbnail_cache_async_fetch_completion_callback (BackgroundJob* background_job) {
	ThumbnailCacheAsyncFetchJob* job = NULL;
	BackgroundJob* _tmp0_ = NULL;
	ThumbnailCacheAsyncFetchJob* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	ThumbnailCacheAsyncFetchJob* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	ThumbnailCacheAsyncFetchJob* _tmp17_ = NULL;
	GdkPixbuf* _tmp18_ = NULL;
	ThumbnailCacheAsyncFetchJob* _tmp29_ = NULL;
	ThumbnailCacheAsyncFetchCallback _tmp30_ = NULL;
	void* _tmp30__target = NULL;
	ThumbnailCacheAsyncFetchJob* _tmp31_ = NULL;
	GdkPixbuf* _tmp32_ = NULL;
	ThumbnailCacheAsyncFetchJob* _tmp33_ = NULL;
	GdkPixbuf* _tmp34_ = NULL;
	ThumbnailCacheAsyncFetchJob* _tmp35_ = NULL;
	Dimensions _tmp36_ = {0};
	ThumbnailCacheAsyncFetchJob* _tmp37_ = NULL;
	GdkInterpType _tmp38_ = 0;
	ThumbnailCacheAsyncFetchJob* _tmp39_ = NULL;
	GError* _tmp40_ = NULL;
	GError * _inner_error_ = NULL;
#line 416 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_BACKGROUND_JOB (background_job));
#line 417 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = background_job;
#line 417 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob));
#line 417 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	job = _tmp1_;
#line 421 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = job;
#line 421 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = _tmp3_->replace;
#line 421 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp4_) {
#line 2349 "ThumbnailCache.c"
		ThumbnailCacheAsyncFetchJob* _tmp5_ = NULL;
		GdkPixbuf* _tmp6_ = NULL;
#line 421 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp5_ = job;
#line 421 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp6_ = _tmp5_->unscaled;
#line 421 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp2_ = _tmp6_ != NULL;
#line 2358 "ThumbnailCache.c"
	} else {
#line 421 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp2_ = FALSE;
#line 2362 "ThumbnailCache.c"
	}
#line 421 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp2_) {
#line 2366 "ThumbnailCache.c"
		{
			ThumbnailCacheAsyncFetchJob* _tmp7_ = NULL;
			ThumbnailSource* _tmp8_ = NULL;
			ThumbnailCacheAsyncFetchJob* _tmp9_ = NULL;
			ThumbnailCache* _tmp10_ = NULL;
			ThumbnailCacheSize _tmp11_ = 0;
			ThumbnailCacheAsyncFetchJob* _tmp12_ = NULL;
			GdkPixbuf* _tmp13_ = NULL;
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp7_ = job;
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp8_ = _tmp7_->source;
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp9_ = job;
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp10_ = _tmp9_->cache;
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp11_ = _tmp10_->priv->size;
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp12_ = job;
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp13_ = _tmp12_->unscaled;
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			thumbnail_cache_replace (_tmp8_, _tmp11_, _tmp13_, &_inner_error_);
#line 423 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2393 "ThumbnailCache.c"
				goto __catch237_g_error;
			}
		}
		goto __finally237;
		__catch237_g_error:
		{
			GError* err = NULL;
			ThumbnailCacheAsyncFetchJob* _tmp14_ = NULL;
			GError* _tmp15_ = NULL;
			GError* _tmp16_ = NULL;
#line 422 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			err = _inner_error_;
#line 422 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_inner_error_ = NULL;
#line 425 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp14_ = job;
#line 425 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp15_ = err;
#line 425 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp16_ = _g_error_copy0 (_tmp15_);
#line 425 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_error_free0 (_tmp14_->err);
#line 425 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp14_->err = _tmp16_;
#line 422 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_error_free0 (err);
#line 2420 "ThumbnailCache.c"
		}
		__finally237:
#line 422 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 422 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_background_job_unref0 (job);
#line 422 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 422 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			g_clear_error (&_inner_error_);
#line 422 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return;
#line 2433 "ThumbnailCache.c"
		}
	}
#line 429 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp17_ = job;
#line 429 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp18_ = _tmp17_->unscaled;
#line 429 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp18_ != NULL) {
#line 2442 "ThumbnailCache.c"
		ThumbnailCacheAsyncFetchJob* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
#line 430 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp19_ = job;
#line 430 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp20_ = _tmp19_->fetched;
#line 430 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (_tmp20_) {
#line 2451 "ThumbnailCache.c"
			ThumbnailCacheAsyncFetchJob* _tmp21_ = NULL;
			ThumbnailCache* _tmp22_ = NULL;
			ThumbnailCacheAsyncFetchJob* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			ThumbnailCacheAsyncFetchJob* _tmp25_ = NULL;
			GdkPixbuf* _tmp26_ = NULL;
			gint _tmp27_ = 0;
#line 432 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp21_ = job;
#line 432 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp22_ = _tmp21_->cache;
#line 432 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp23_ = job;
#line 432 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp24_ = _tmp23_->thumbnail_name;
#line 432 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp25_ = job;
#line 432 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp26_ = _tmp25_->unscaled;
#line 432 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			thumbnail_cache_store_in_memory (_tmp22_, _tmp24_, _tmp26_);
#line 434 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp27_ = thumbnail_cache_cycle_async_fetched_thumbnails;
#line 434 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			thumbnail_cache_cycle_async_fetched_thumbnails = _tmp27_ + 1;
#line 435 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			thumbnail_cache_schedule_debug ();
#line 2479 "ThumbnailCache.c"
		} else {
			gint _tmp28_ = 0;
#line 437 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp28_ = thumbnail_cache_cycle_async_resized_thumbnails;
#line 437 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			thumbnail_cache_cycle_async_resized_thumbnails = _tmp28_ + 1;
#line 438 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			thumbnail_cache_schedule_debug ();
#line 2488 "ThumbnailCache.c"
		}
	}
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp29_ = job;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp30_ = _tmp29_->callback;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp30__target = _tmp29_->callback_target;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp31_ = job;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp32_ = _tmp31_->scaled;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp33_ = job;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp34_ = _tmp33_->unscaled;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp35_ = job;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp36_ = _tmp35_->dim;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp37_ = job;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp38_ = _tmp37_->interp;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp39_ = job;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp40_ = _tmp39_->err;
#line 442 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp30_ (_tmp32_, _tmp34_, &_tmp36_, _tmp38_, _tmp40_, _tmp30__target);
#line 416 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_background_job_unref0 (job);
#line 2521 "ThumbnailCache.c"
}


static void _thumbnail_cache_import_from_source (ThumbnailCache* self, ThumbnailSource* source, gboolean force, GError** error) {
	GFile* file = NULL;
	ThumbnailSource* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	LibraryPhoto* photo = NULL;
	ThumbnailSource* _tmp6_ = NULL;
	LibraryPhoto* _tmp7_ = NULL;
	GdkPixbuf* _tmp8_ = NULL;
	LibraryPhoto* _tmp9_ = NULL;
	ThumbnailCacheSize _tmp10_ = 0;
	gint _tmp11_ = 0;
	Scaling _tmp12_ = {0};
	GdkPixbuf* _tmp13_ = NULL;
	GFile* _tmp14_ = NULL;
	ThumbnailSource* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
#line 445 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
#line 445 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 447 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = source;
#line 447 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_cache_get_source_cached_file (self, _tmp0_);
#line 447 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	file = _tmp1_;
#line 451 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = force;
#line 451 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (!_tmp2_) {
#line 2556 "ThumbnailCache.c"
		ThumbnailSource* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 452 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp3_ = source;
#line 452 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp4_ = _thumbnail_cache_exists (self, _tmp3_);
#line 452 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (_tmp4_) {
#line 453 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_object_unref0 (file);
#line 453 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return;
#line 2569 "ThumbnailCache.c"
		}
	} else {
		ThumbnailSource* _tmp5_ = NULL;
#line 456 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp5_ = source;
#line 456 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_thumbnail_cache_remove (self, _tmp5_);
#line 2577 "ThumbnailCache.c"
	}
#line 459 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = source;
#line 459 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 459 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	photo = _tmp7_;
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp9_ = photo;
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp10_ = self->priv->size;
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp11_ = thumbnail_cache_size_get_scale (_tmp10_);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	scaling_for_best_fit (_tmp11_, TRUE, &_tmp12_);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp13_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp12_, &_inner_error_);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = _tmp13_;
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (photo);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (file);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 2607 "ThumbnailCache.c"
	}
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp14_ = file;
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp15_ = source;
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_save_thumbnail (self, _tmp14_, _tmp8_, _tmp15_, &_inner_error_);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (_tmp8_);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (photo);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (file);
#line 460 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 2627 "ThumbnailCache.c"
	}
#line 445 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp8_);
#line 445 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (photo);
#line 445 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (file);
#line 2635 "ThumbnailCache.c"
}


static void _thumbnail_cache_import_thumbnail (ThumbnailCache* self, ThumbnailSource* source, GdkPixbuf* scaled, gboolean force, GError** error) {
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	Dimensions _tmp2_ = {0};
	ThumbnailCacheSize _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	ThumbnailSource* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	GdkPixbuf* _tmp13_ = NULL;
	ThumbnailSource* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
#line 466 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
#line 466 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 466 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail ((scaled == NULL) || GDK_IS_PIXBUF (scaled));
#line 468 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = scaled;
#line 468 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_vala_assert (_tmp0_ != NULL, "scaled != null");
#line 469 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = scaled;
#line 469 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	dimensions_for_pixbuf (_tmp1_, &_tmp2_);
#line 469 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = self->priv->size;
#line 469 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = thumbnail_cache_size_get_scale (_tmp3_);
#line 469 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = dimensions_approx_scaled (&_tmp2_, _tmp4_, 1);
#line 469 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_vala_assert (_tmp5_, "Dimensions.for_pixbuf(scaled).approx_scaled(size.get_scale())");
#line 473 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = force;
#line 473 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (!_tmp6_) {
#line 2679 "ThumbnailCache.c"
		ThumbnailSource* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 474 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp7_ = source;
#line 474 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp8_ = _thumbnail_cache_exists (self, _tmp7_);
#line 474 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (_tmp8_) {
#line 475 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return;
#line 2690 "ThumbnailCache.c"
		}
	} else {
		ThumbnailSource* _tmp9_ = NULL;
#line 478 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp9_ = source;
#line 478 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_thumbnail_cache_remove (self, _tmp9_);
#line 2698 "ThumbnailCache.c"
	}
#line 481 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp10_ = source;
#line 481 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp11_ = thumbnail_cache_get_source_cached_file (self, _tmp10_);
#line 481 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp12_ = _tmp11_;
#line 481 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp13_ = scaled;
#line 481 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp14_ = source;
#line 481 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_save_thumbnail (self, _tmp12_, _tmp13_, _tmp14_, &_inner_error_);
#line 481 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp12_);
#line 481 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 481 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 481 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 2720 "ThumbnailCache.c"
	}
}


static void _thumbnail_cache_duplicate (ThumbnailCache* self, ThumbnailSource* src_source, ThumbnailSource* dest_source) {
	GFile* src_file = NULL;
	ThumbnailSource* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* dest_file = NULL;
	ThumbnailSource* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	ThumbnailSource* _tmp5_ = NULL;
	PhotoFileFormat _tmp6_ = 0;
	GFile* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
#line 488 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
#line 488 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (src_source));
#line 488 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (dest_source));
#line 489 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = src_source;
#line 489 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_cache_get_source_cached_file (self, _tmp0_);
#line 489 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	src_file = _tmp1_;
#line 490 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = dest_source;
#line 490 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = thumbnail_source_get_representative_id (_tmp2_);
#line 490 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = _tmp3_;
#line 490 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = src_source;
#line 490 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = thumbnail_source_get_preferred_thumbnail_format (_tmp5_);
#line 490 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = thumbnail_cache_get_cached_file (self, _tmp4_, _tmp6_);
#line 490 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = _tmp7_;
#line 490 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp4_);
#line 490 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	dest_file = _tmp8_;
#line 2768 "ThumbnailCache.c"
	{
#line 494 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_file_copy (src_file, dest_file, G_FILE_COPY_ALL_METADATA | G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
#line 494 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2774 "ThumbnailCache.c"
			goto __catch238_g_error;
		}
	}
	goto __finally238;
	__catch238_g_error:
	{
		GError* err = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		err = _inner_error_;
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_inner_error_ = NULL;
#line 496 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp9_ = err;
#line 496 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp10_ = _tmp9_->message;
#line 496 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp11_ = g_strdup_printf ("%s", _tmp10_);
#line 496 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp12_ = _tmp11_;
#line 496 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		app_window_panic (_tmp12_);
#line 496 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_free0 (_tmp12_);
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_error_free0 (err);
#line 2804 "ThumbnailCache.c"
	}
	__finally238:
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (dest_file);
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (src_file);
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_clear_error (&_inner_error_);
#line 493 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 2819 "ThumbnailCache.c"
	}
#line 488 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (dest_file);
#line 488 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (src_file);
#line 2825 "ThumbnailCache.c"
}


static void _thumbnail_cache_replace (ThumbnailCache* self, ThumbnailSource* source, GdkPixbuf* original, GError** error) {
	GFile* file = NULL;
	ThumbnailSource* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	ThumbnailSource* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GdkPixbuf* scaled = NULL;
	GdkPixbuf* _tmp5_ = NULL;
	ThumbnailCacheSize _tmp6_ = 0;
	gint _tmp7_ = 0;
	GdkInterpType _tmp8_ = 0;
	GdkPixbuf* _tmp9_ = NULL;
	ThumbnailSource* _tmp10_ = NULL;
	ThumbnailSource* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 502 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
#line 502 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 502 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (GDK_IS_PIXBUF (original));
#line 503 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = source;
#line 503 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_cache_get_source_cached_file (self, _tmp0_);
#line 503 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	file = _tmp1_;
#line 506 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = source;
#line 506 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_SOURCE, DataSource));
#line 506 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = _tmp3_;
#line 506 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_remove_from_memory (self, _tmp4_);
#line 506 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp4_);
#line 509 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = original;
#line 509 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = self->priv->size;
#line 509 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = thumbnail_cache_size_get_scale (_tmp6_);
#line 509 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = self->priv->interp;
#line 509 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp9_ = scale_pixbuf (_tmp5_, _tmp7_, _tmp8_, TRUE);
#line 509 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	scaled = _tmp9_;
#line 512 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp10_ = source;
#line 512 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_save_thumbnail (self, file, scaled, _tmp10_, &_inner_error_);
#line 512 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 512 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 512 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (scaled);
#line 512 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (file);
#line 512 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 2895 "ThumbnailCache.c"
	}
#line 518 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp11_ = source;
#line 518 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp12_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_SOURCE, DataSource));
#line 518 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp13_ = _tmp12_;
#line 518 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_store_in_memory (self, _tmp13_, scaled);
#line 518 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp13_);
#line 502 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (scaled);
#line 502 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (file);
#line 2911 "ThumbnailCache.c"
}


static void _thumbnail_cache_remove (ThumbnailCache* self, ThumbnailSource* source) {
	GFile* file = NULL;
	ThumbnailSource* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	ThumbnailSource* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
#line 521 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
#line 521 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 522 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = source;
#line 522 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_cache_get_source_cached_file (self, _tmp0_);
#line 522 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	file = _tmp1_;
#line 525 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = source;
#line 525 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_DATA_SOURCE, DataSource));
#line 525 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = _tmp3_;
#line 525 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_remove_from_memory (self, _tmp4_);
#line 525 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp4_);
#line 2943 "ThumbnailCache.c"
	{
#line 529 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_file_delete (file, NULL, &_inner_error_);
#line 529 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2949 "ThumbnailCache.c"
			goto __catch239_g_error;
		}
	}
	goto __finally239;
	__catch239_g_error:
	{
		GError* err = NULL;
#line 528 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		err = _inner_error_;
#line 528 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_inner_error_ = NULL;
#line 528 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_error_free0 (err);
#line 2963 "ThumbnailCache.c"
	}
	__finally239:
#line 528 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 528 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (file);
#line 528 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 528 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_clear_error (&_inner_error_);
#line 528 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 2976 "ThumbnailCache.c"
	}
#line 521 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (file);
#line 2980 "ThumbnailCache.c"
}


static gboolean _thumbnail_cache_exists (ThumbnailCache* self, ThumbnailSource* source) {
	gboolean result = FALSE;
	ThumbnailSource* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
#line 535 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), FALSE);
#line 535 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), FALSE);
#line 536 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = source;
#line 536 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_cache_get_source_cached_file (self, _tmp0_);
#line 536 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = _tmp1_;
#line 536 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = g_file_query_exists (_tmp2_, NULL);
#line 536 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = _tmp3_;
#line 536 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp2_);
#line 536 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = _tmp4_;
#line 536 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 3011 "ThumbnailCache.c"
}


static GdkPixbuf* thumbnail_cache_read_pixbuf (ThumbnailCache* self, const gchar* thumbnail_name, PhotoFileFormat format, GError** error) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	PhotoFileFormat _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	PhotoFileFormat _tmp3_ = 0;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	PhotoFileReader* _tmp8_ = NULL;
	PhotoFileReader* _tmp9_ = NULL;
	GdkPixbuf* _tmp10_ = NULL;
	GdkPixbuf* _tmp11_ = NULL;
	GdkPixbuf* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
#line 540 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), NULL);
#line 540 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (thumbnail_name != NULL, NULL);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = format;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = thumbnail_name;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = format;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = thumbnail_cache_get_cached_file (self, _tmp2_, _tmp3_);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = _tmp4_;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = g_file_get_path (_tmp5_);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = _tmp6_;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = photo_file_format_create_reader (_tmp1_, _tmp7_);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp9_ = _tmp8_;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp10_ = photo_file_reader_unscaled_read (_tmp9_, &_inner_error_);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp11_ = _tmp10_;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_photo_file_adapter_unref0 (_tmp9_);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp7_);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp5_);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = _tmp11_;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return NULL;
#line 3071 "ThumbnailCache.c"
	}
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp12_ = _tmp0_;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = NULL;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = _tmp12_;
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (_tmp0_);
#line 541 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 3083 "ThumbnailCache.c"
}


static GFile* thumbnail_cache_get_source_cached_file (ThumbnailCache* self, ThumbnailSource* source) {
	GFile* result = NULL;
	ThumbnailSource* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	ThumbnailSource* _tmp3_ = NULL;
	PhotoFileFormat _tmp4_ = 0;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
#line 545 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), NULL);
#line 545 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), NULL);
#line 546 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = source;
#line 546 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_source_get_representative_id (_tmp0_);
#line 546 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = _tmp1_;
#line 546 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = source;
#line 546 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = thumbnail_source_get_preferred_thumbnail_format (_tmp3_);
#line 546 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = thumbnail_cache_get_cached_file (self, _tmp2_, _tmp4_);
#line 546 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = _tmp5_;
#line 546 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp2_);
#line 546 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = _tmp6_;
#line 546 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 3120 "ThumbnailCache.c"
}


static GFile* thumbnail_cache_get_cached_file (ThumbnailCache* self, const gchar* thumbnail_name, PhotoFileFormat thumbnail_format) {
	GFile* result = NULL;
	GFile* _tmp0_ = NULL;
	PhotoFileFormat _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
#line 550 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), NULL);
#line 550 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (thumbnail_name != NULL, NULL);
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->priv->cache_dir;
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_format;
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = thumbnail_name;
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = photo_file_format_get_default_basename (_tmp1_, _tmp2_);
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = _tmp3_;
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = g_file_get_child (_tmp0_, _tmp4_);
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = _tmp5_;
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp4_);
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = _tmp6_;
#line 551 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 3157 "ThumbnailCache.c"
}


static GdkPixbuf* thumbnail_cache_fetch_from_memory (ThumbnailCache* self, const gchar* thumbnail_name) {
	GdkPixbuf* result = NULL;
	ThumbnailCacheImageData* data = NULL;
	GeeHashMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	ThumbnailCacheImageData* _tmp4_ = NULL;
	GdkPixbuf* _tmp7_ = NULL;
#line 554 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), NULL);
#line 554 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (thumbnail_name != NULL, NULL);
#line 555 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->priv->cache_map;
#line 555 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_name;
#line 555 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 555 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	data = (ThumbnailCacheImageData*) _tmp2_;
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = data;
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp4_ != NULL) {
#line 3186 "ThumbnailCache.c"
		ThumbnailCacheImageData* _tmp5_ = NULL;
		GdkPixbuf* _tmp6_ = NULL;
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp5_ = data;
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp6_ = _tmp5_->pixbuf;
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp3_ = _tmp6_;
#line 3195 "ThumbnailCache.c"
	} else {
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp3_ = NULL;
#line 3199 "ThumbnailCache.c"
	}
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = _g_object_ref0 (_tmp3_);
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = _tmp7_;
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_image_data_unref0 (data);
#line 557 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 3209 "ThumbnailCache.c"
}


static void thumbnail_cache_store_in_memory (ThumbnailCache* self, const gchar* thumbnail_name, GdkPixbuf* thumbnail) {
	gulong _tmp0_ = 0UL;
	const gchar* _tmp1_ = NULL;
	ThumbnailCacheImageData* data = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	ThumbnailCacheImageData* _tmp3_ = NULL;
	ThumbnailCacheImageData* _tmp4_ = NULL;
	gulong _tmp5_ = 0UL;
	GeeHashMap* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	ThumbnailCacheImageData* _tmp9_ = NULL;
	GeeArrayList* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gulong _tmp12_ = 0UL;
	ThumbnailCacheImageData* _tmp13_ = NULL;
	gulong _tmp14_ = 0UL;
#line 560 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
#line 560 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (thumbnail_name != NULL);
#line 560 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (GDK_IS_PIXBUF (thumbnail));
#line 561 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->priv->max_cached_bytes;
#line 561 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp0_ <= ((gulong) 0)) {
#line 562 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 3241 "ThumbnailCache.c"
	}
#line 564 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_name;
#line 564 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_remove_from_memory (self, _tmp1_);
#line 566 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = thumbnail;
#line 566 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = thumbnail_cache_image_data_new (_tmp2_);
#line 566 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	data = _tmp3_;
#line 569 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = data;
#line 569 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = _tmp4_->bytes;
#line 569 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp5_ > ((gulong) THUMBNAIL_CACHE_MAX_INMEMORY_DATA_SIZE)) {
#line 3259 "ThumbnailCache.c"
		const gchar* _tmp6_ = NULL;
#line 570 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp6_ = thumbnail_name;
#line 570 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_debug ("ThumbnailCache.vala:570: Persistent thumbnail [%s] too large to cache " \
"in memory", _tmp6_);
#line 572 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_thumbnail_cache_image_data_unref0 (data);
#line 572 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 3269 "ThumbnailCache.c"
	}
#line 575 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = self->priv->cache_map;
#line 575 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = thumbnail_name;
#line 575 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp9_ = data;
#line 575 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_, _tmp9_);
#line 576 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp10_ = self->priv->cache_lru;
#line 576 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp11_ = thumbnail_name;
#line 576 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0, _tmp11_);
#line 578 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp12_ = self->priv->cached_bytes;
#line 578 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp13_ = data;
#line 578 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp14_ = _tmp13_->bytes;
#line 578 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->cached_bytes = _tmp12_ + _tmp14_;
#line 581 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	while (TRUE) {
#line 3295 "ThumbnailCache.c"
		gulong _tmp15_ = 0UL;
		gulong _tmp16_ = 0UL;
		GeeArrayList* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint index = 0;
		GeeArrayList* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gchar* victim_name = NULL;
		GeeArrayList* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gpointer _tmp25_ = NULL;
		GeeArrayList* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gpointer _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		GeeHashMap* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		gpointer _tmp32_ = NULL;
		gint _tmp33_ = 0;
		gboolean removed = FALSE;
		GeeHashMap* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		gboolean _tmp36_ = FALSE;
		gboolean _tmp37_ = FALSE;
		ThumbnailCacheImageData* _tmp38_ = NULL;
		gulong _tmp39_ = 0UL;
		gulong _tmp40_ = 0UL;
		gulong _tmp41_ = 0UL;
		ThumbnailCacheImageData* _tmp42_ = NULL;
		gulong _tmp43_ = 0UL;
#line 581 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp15_ = self->priv->cached_bytes;
#line 581 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp16_ = self->priv->max_cached_bytes;
#line 581 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (!(_tmp15_ > _tmp16_)) {
#line 581 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			break;
#line 3336 "ThumbnailCache.c"
		}
#line 582 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp17_ = self->priv->cache_lru;
#line 582 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp18_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection));
#line 582 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp19_ = _tmp18_;
#line 582 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_vala_assert (_tmp19_ > 0, "cache_lru.size > 0");
#line 583 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp20_ = self->priv->cache_lru;
#line 583 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp21_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_COLLECTION, GeeCollection));
#line 583 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp22_ = _tmp21_;
#line 583 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		index = _tmp22_ - 1;
#line 585 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp23_ = self->priv->cache_lru;
#line 585 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp24_ = index;
#line 585 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp25_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp24_);
#line 585 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		victim_name = (gchar*) _tmp25_;
#line 586 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp26_ = self->priv->cache_lru;
#line 586 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp27_ = index;
#line 586 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp28_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _tmp27_);
#line 586 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp29_ = (gchar*) _tmp28_;
#line 586 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_free0 (_tmp29_);
#line 588 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp30_ = self->priv->cache_map;
#line 588 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp31_ = victim_name;
#line 588 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp32_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp31_);
#line 588 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_thumbnail_cache_image_data_unref0 (data);
#line 588 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		data = (ThumbnailCacheImageData*) _tmp32_;
#line 590 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp33_ = thumbnail_cache_cycle_overflow_thumbnails;
#line 590 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnail_cache_cycle_overflow_thumbnails = _tmp33_ + 1;
#line 591 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnail_cache_schedule_debug ();
#line 593 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp34_ = self->priv->cache_map;
#line 593 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp35_ = victim_name;
#line 593 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp36_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp35_, NULL);
#line 593 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		removed = _tmp36_;
#line 594 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp37_ = removed;
#line 594 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_vala_assert (_tmp37_, "removed");
#line 596 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp38_ = data;
#line 596 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp39_ = _tmp38_->bytes;
#line 596 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp40_ = self->priv->cached_bytes;
#line 596 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_vala_assert (_tmp39_ <= _tmp40_, "data.bytes <= cached_bytes");
#line 597 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp41_ = self->priv->cached_bytes;
#line 597 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp42_ = data;
#line 597 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp43_ = _tmp42_->bytes;
#line 597 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		self->priv->cached_bytes = _tmp41_ - _tmp43_;
#line 581 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_free0 (victim_name);
#line 3418 "ThumbnailCache.c"
	}
#line 560 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_image_data_unref0 (data);
#line 3422 "ThumbnailCache.c"
}


static gboolean thumbnail_cache_remove_from_memory (ThumbnailCache* self, const gchar* thumbnail_name) {
	gboolean result = FALSE;
	ThumbnailCacheImageData* data = NULL;
	GeeHashMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	ThumbnailCacheImageData* _tmp3_ = NULL;
	gulong _tmp4_ = 0UL;
	ThumbnailCacheImageData* _tmp5_ = NULL;
	gulong _tmp6_ = 0UL;
	gulong _tmp7_ = 0UL;
	ThumbnailCacheImageData* _tmp8_ = NULL;
	gulong _tmp9_ = 0UL;
	gboolean removed = FALSE;
	GeeHashMap* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	GeeArrayList* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
#line 601 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (self), FALSE);
#line 601 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (thumbnail_name != NULL, FALSE);
#line 602 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->priv->cache_map;
#line 602 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = thumbnail_name;
#line 602 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp1_);
#line 602 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	data = (ThumbnailCacheImageData*) _tmp2_;
#line 603 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = data;
#line 603 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp3_ == NULL) {
#line 604 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		result = FALSE;
#line 604 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_thumbnail_cache_image_data_unref0 (data);
#line 604 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return result;
#line 3470 "ThumbnailCache.c"
	}
#line 606 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = self->priv->cached_bytes;
#line 606 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = data;
#line 606 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = _tmp5_->bytes;
#line 606 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_vala_assert (_tmp4_ >= _tmp6_, "cached_bytes >= data.bytes");
#line 607 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = self->priv->cached_bytes;
#line 607 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = data;
#line 607 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp9_ = _tmp8_->bytes;
#line 607 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->cached_bytes = _tmp7_ - _tmp9_;
#line 610 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp10_ = self->priv->cache_map;
#line 610 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp11_ = thumbnail_name;
#line 610 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp12_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp11_, NULL);
#line 610 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	removed = _tmp12_;
#line 611 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp13_ = removed;
#line 611 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_vala_assert (_tmp13_, "removed");
#line 614 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp14_ = self->priv->cache_lru;
#line 614 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp15_ = thumbnail_name;
#line 614 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp16_ = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp15_);
#line 614 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	removed = _tmp16_;
#line 615 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp17_ = removed;
#line 615 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_vala_assert (_tmp17_, "removed");
#line 617 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	result = TRUE;
#line 617 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_thumbnail_cache_image_data_unref0 (data);
#line 617 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return result;
#line 3518 "ThumbnailCache.c"
}


static void thumbnail_cache_save_thumbnail (ThumbnailCache* self, GFile* file, GdkPixbuf* pixbuf, ThumbnailSource* source, GError** error) {
	PhotoFileWriter* _tmp0_ = NULL;
	ThumbnailSource* _tmp1_ = NULL;
	PhotoFileFormat _tmp2_ = 0;
	GFile* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	PhotoFileWriter* _tmp6_ = NULL;
	PhotoFileWriter* _tmp7_ = NULL;
	PhotoFileWriter* _tmp8_ = NULL;
	PhotoFileWriter* _tmp9_ = NULL;
	GdkPixbuf* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
#line 620 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_CACHE (self));
#line 620 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (G_IS_FILE (file));
#line 620 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 620 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (IS_THUMBNAIL_SOURCE (source));
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = source;
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = thumbnail_source_get_preferred_thumbnail_format (_tmp1_);
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = file;
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = g_file_get_path (_tmp3_);
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = _tmp4_;
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = photo_file_format_create_writer (_tmp2_, _tmp5_, &_inner_error_);
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = _tmp6_;
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (_tmp5_);
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = _tmp7_;
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 3567 "ThumbnailCache.c"
	}
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = _tmp0_;
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = NULL;
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp9_ = _tmp8_;
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp10_ = pixbuf;
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	photo_file_writer_write (_tmp9_, _tmp10_, THUMBNAIL_CACHE_DEFAULT_QUALITY, &_inner_error_);
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_photo_file_adapter_unref0 (_tmp9_);
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_propagate_error (error, _inner_error_);
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_photo_file_adapter_unref0 (_tmp0_);
#line 621 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 3589 "ThumbnailCache.c"
	}
#line 620 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_photo_file_adapter_unref0 (_tmp0_);
#line 3593 "ThumbnailCache.c"
}


static ThumbnailCacheImageData* thumbnail_cache_image_data_construct (GType object_type, GdkPixbuf* pixbuf) {
	ThumbnailCacheImageData* self = NULL;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GdkPixbuf* _tmp4_ = NULL;
	gint _tmp5_ = 0;
#line 63 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (pixbuf), NULL);
#line 63 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = (ThumbnailCacheImageData*) g_type_create_instance (object_type);
#line 64 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = pixbuf;
#line 64 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 64 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->pixbuf);
#line 64 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->pixbuf = _tmp1_;
#line 68 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = pixbuf;
#line 68 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = gdk_pixbuf_get_rowstride (_tmp2_);
#line 68 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = pixbuf;
#line 68 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = gdk_pixbuf_get_height (_tmp4_);
#line 68 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->bytes = ((gulong) _tmp3_) * ((gulong) _tmp5_);
#line 63 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return self;
#line 3629 "ThumbnailCache.c"
}


static ThumbnailCacheImageData* thumbnail_cache_image_data_new (GdkPixbuf* pixbuf) {
#line 63 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return thumbnail_cache_image_data_construct (THUMBNAIL_CACHE_TYPE_IMAGE_DATA, pixbuf);
#line 3636 "ThumbnailCache.c"
}


static void thumbnail_cache_value_image_data_init (GValue* value) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	value->data[0].v_pointer = NULL;
#line 3643 "ThumbnailCache.c"
}


static void thumbnail_cache_value_image_data_free_value (GValue* value) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (value->data[0].v_pointer) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnail_cache_image_data_unref (value->data[0].v_pointer);
#line 3652 "ThumbnailCache.c"
	}
}


static void thumbnail_cache_value_image_data_copy_value (const GValue* src_value, GValue* dest_value) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (src_value->data[0].v_pointer) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		dest_value->data[0].v_pointer = thumbnail_cache_image_data_ref (src_value->data[0].v_pointer);
#line 3662 "ThumbnailCache.c"
	} else {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3666 "ThumbnailCache.c"
	}
}


static gpointer thumbnail_cache_value_image_data_peek_pointer (const GValue* value) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return value->data[0].v_pointer;
#line 3674 "ThumbnailCache.c"
}


static gchar* thumbnail_cache_value_image_data_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (collect_values[0].v_pointer) {
#line 3681 "ThumbnailCache.c"
		ThumbnailCacheImageData* object;
		object = collect_values[0].v_pointer;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (object->parent_instance.g_class == NULL) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3688 "ThumbnailCache.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3692 "ThumbnailCache.c"
		}
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = thumbnail_cache_image_data_ref (object);
#line 3696 "ThumbnailCache.c"
	} else {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = NULL;
#line 3700 "ThumbnailCache.c"
	}
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return NULL;
#line 3704 "ThumbnailCache.c"
}


static gchar* thumbnail_cache_value_image_data_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ThumbnailCacheImageData** object_p;
	object_p = collect_values[0].v_pointer;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (!object_p) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3715 "ThumbnailCache.c"
	}
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (!value->data[0].v_pointer) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		*object_p = NULL;
#line 3721 "ThumbnailCache.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		*object_p = value->data[0].v_pointer;
#line 3725 "ThumbnailCache.c"
	} else {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		*object_p = thumbnail_cache_image_data_ref (value->data[0].v_pointer);
#line 3729 "ThumbnailCache.c"
	}
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return NULL;
#line 3733 "ThumbnailCache.c"
}


static GParamSpec* thumbnail_cache_param_spec_image_data (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ThumbnailCacheParamSpecImageData* spec;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (g_type_is_a (object_type, THUMBNAIL_CACHE_TYPE_IMAGE_DATA), NULL);
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return G_PARAM_SPEC (spec);
#line 3747 "ThumbnailCache.c"
}


static gpointer thumbnail_cache_value_get_image_data (const GValue* value) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, THUMBNAIL_CACHE_TYPE_IMAGE_DATA), NULL);
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return value->data[0].v_pointer;
#line 3756 "ThumbnailCache.c"
}


static void thumbnail_cache_value_set_image_data (GValue* value, gpointer v_object) {
	ThumbnailCacheImageData* old;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, THUMBNAIL_CACHE_TYPE_IMAGE_DATA));
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	old = value->data[0].v_pointer;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (v_object) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, THUMBNAIL_CACHE_TYPE_IMAGE_DATA));
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = v_object;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnail_cache_image_data_ref (value->data[0].v_pointer);
#line 3776 "ThumbnailCache.c"
	} else {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = NULL;
#line 3780 "ThumbnailCache.c"
	}
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (old) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnail_cache_image_data_unref (old);
#line 3786 "ThumbnailCache.c"
	}
}


static void thumbnail_cache_value_take_image_data (GValue* value, gpointer v_object) {
	ThumbnailCacheImageData* old;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, THUMBNAIL_CACHE_TYPE_IMAGE_DATA));
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	old = value->data[0].v_pointer;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (v_object) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, THUMBNAIL_CACHE_TYPE_IMAGE_DATA));
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = v_object;
#line 3805 "ThumbnailCache.c"
	} else {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		value->data[0].v_pointer = NULL;
#line 3809 "ThumbnailCache.c"
	}
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (old) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		thumbnail_cache_image_data_unref (old);
#line 3815 "ThumbnailCache.c"
	}
}


static void thumbnail_cache_image_data_class_init (ThumbnailCacheImageDataClass * klass) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_image_data_parent_class = g_type_class_peek_parent (klass);
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	((ThumbnailCacheImageDataClass *) klass)->finalize = thumbnail_cache_image_data_finalize;
#line 3825 "ThumbnailCache.c"
}


static void thumbnail_cache_image_data_instance_init (ThumbnailCacheImageData * self) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->ref_count = 1;
#line 3832 "ThumbnailCache.c"
}


static void thumbnail_cache_image_data_finalize (ThumbnailCacheImageData* obj) {
	ThumbnailCacheImageData * self;
	gulong _tmp0_ = 0UL;
	gulong _tmp1_ = 0UL;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, THUMBNAIL_CACHE_TYPE_IMAGE_DATA, ThumbnailCacheImageData);
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_signal_handlers_destroy (self);
#line 72 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = thumbnail_cache_cycle_dropped_bytes;
#line 72 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = self->bytes;
#line 72 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_cycle_dropped_bytes = _tmp0_ + _tmp1_;
#line 73 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_schedule_debug ();
#line 60 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->pixbuf);
#line 3854 "ThumbnailCache.c"
}


static GType thumbnail_cache_image_data_get_type (void) {
	static volatile gsize thumbnail_cache_image_data_type_id__volatile = 0;
	if (g_once_init_enter (&thumbnail_cache_image_data_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { thumbnail_cache_value_image_data_init, thumbnail_cache_value_image_data_free_value, thumbnail_cache_value_image_data_copy_value, thumbnail_cache_value_image_data_peek_pointer, "p", thumbnail_cache_value_image_data_collect_value, "p", thumbnail_cache_value_image_data_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ThumbnailCacheImageDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_cache_image_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThumbnailCacheImageData), 0, (GInstanceInitFunc) thumbnail_cache_image_data_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType thumbnail_cache_image_data_type_id;
		thumbnail_cache_image_data_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ThumbnailCacheImageData", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&thumbnail_cache_image_data_type_id__volatile, thumbnail_cache_image_data_type_id);
	}
	return thumbnail_cache_image_data_type_id__volatile;
}


static gpointer thumbnail_cache_image_data_ref (gpointer instance) {
	ThumbnailCacheImageData* self;
	self = instance;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_atomic_int_inc (&self->ref_count);
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return instance;
#line 3879 "ThumbnailCache.c"
}


static void thumbnail_cache_image_data_unref (gpointer instance) {
	ThumbnailCacheImageData* self;
	self = instance;
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		THUMBNAIL_CACHE_IMAGE_DATA_GET_CLASS (self)->finalize (self);
#line 59 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3892 "ThumbnailCache.c"
	}
}


static void _thumbnail_cache_async_fetch_completion_callback_completion_callback (BackgroundJob* job, gpointer self) {
#line 94 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_async_fetch_completion_callback (job);
#line 3900 "ThumbnailCache.c"
}


static ThumbnailCacheAsyncFetchJob* thumbnail_cache_async_fetch_job_construct (GType object_type, ThumbnailCache* cache, const gchar* thumbnail_name, ThumbnailSource* source, GdkPixbuf* prefetched, Dimensions* dim, GdkInterpType interp, ThumbnailCacheAsyncFetchCallback callback, void* callback_target, GCancellable* cancellable) {
	ThumbnailCacheAsyncFetchJob* self = NULL;
	ThumbnailCache* _tmp0_ = NULL;
	GCancellable* _tmp1_ = NULL;
	ThumbnailCache* _tmp2_ = NULL;
	ThumbnailCache* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	ThumbnailSource* _tmp6_ = NULL;
	ThumbnailSource* _tmp7_ = NULL;
	ThumbnailSource* _tmp8_ = NULL;
	PhotoFileFormat _tmp9_ = 0;
	GdkPixbuf* _tmp10_ = NULL;
	GdkPixbuf* _tmp11_ = NULL;
	Dimensions _tmp12_ = {0};
	GdkInterpType _tmp13_ = 0;
	ThumbnailCacheAsyncFetchCallback _tmp14_ = NULL;
	void* _tmp14__target = NULL;
#line 91 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_CACHE (cache), NULL);
#line 91 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (thumbnail_name != NULL, NULL);
#line 91 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (IS_THUMBNAIL_SOURCE (source), NULL);
#line 91 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail ((prefetched == NULL) || GDK_IS_PIXBUF (prefetched), NULL);
#line 91 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail (dim != NULL, NULL);
#line 91 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_val_if_fail ((cancellable == NULL) || G_IS_CANCELLABLE (cancellable), NULL);
#line 94 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = cache;
#line 94 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = cancellable;
#line 94 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = (ThumbnailCacheAsyncFetchJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, G_TYPE_OBJECT, GObject), _thumbnail_cache_async_fetch_completion_callback_completion_callback, NULL, _tmp1_, NULL, NULL, NULL);
#line 96 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = cache;
#line 96 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 96 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->cache);
#line 96 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->cache = _tmp3_;
#line 97 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp4_ = thumbnail_name;
#line 97 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 97 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (self->thumbnail_name);
#line 97 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->thumbnail_name = _tmp5_;
#line 98 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp6_ = source;
#line 98 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 98 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->source);
#line 98 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->source = _tmp7_;
#line 99 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp8_ = source;
#line 99 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp9_ = thumbnail_source_get_preferred_thumbnail_format (_tmp8_);
#line 99 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->source_format = _tmp9_;
#line 100 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp10_ = prefetched;
#line 100 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 100 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->unscaled);
#line 100 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->unscaled = _tmp11_;
#line 101 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp12_ = *dim;
#line 101 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->dim = _tmp12_;
#line 102 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp13_ = interp;
#line 102 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->interp = _tmp13_;
#line 103 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp14_ = callback;
#line 103 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp14__target = callback_target;
#line 103 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->callback = _tmp14_;
#line 103 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->callback_target = _tmp14__target;
#line 91 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return self;
#line 3996 "ThumbnailCache.c"
}


static ThumbnailCacheAsyncFetchJob* thumbnail_cache_async_fetch_job_new (ThumbnailCache* cache, const gchar* thumbnail_name, ThumbnailSource* source, GdkPixbuf* prefetched, Dimensions* dim, GdkInterpType interp, ThumbnailCacheAsyncFetchCallback callback, void* callback_target, GCancellable* cancellable) {
#line 91 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	return thumbnail_cache_async_fetch_job_construct (THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, cache, thumbnail_name, source, prefetched, dim, interp, callback, callback_target, cancellable);
#line 4003 "ThumbnailCache.c"
}


static BackgroundJobJobPriority thumbnail_cache_async_fetch_job_real_get_priority (BackgroundJob* base) {
	ThumbnailCacheAsyncFetchJob * self;
	BackgroundJobJobPriority result = 0;
	GdkInterpType _tmp0_ = 0;
#line 106 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob);
#line 109 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->interp;
#line 109 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	switch (_tmp0_) {
#line 109 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		case GDK_INTERP_NEAREST:
#line 109 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		case GDK_INTERP_TILES:
#line 4021 "ThumbnailCache.c"
		{
#line 112 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			result = BACKGROUND_JOB_JOB_PRIORITY_HIGH;
#line 112 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return result;
#line 4027 "ThumbnailCache.c"
		}
		default:
#line 109 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		case GDK_INTERP_BILINEAR:
#line 109 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		case GDK_INTERP_HYPER:
#line 4034 "ThumbnailCache.c"
		{
#line 117 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			result = BACKGROUND_JOB_JOB_PRIORITY_NORMAL;
#line 117 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return result;
#line 4040 "ThumbnailCache.c"
		}
	}
}


static void thumbnail_cache_async_fetch_job_real_execute (BackgroundJob* base) {
	ThumbnailCacheAsyncFetchJob * self;
	GError * _inner_error_ = NULL;
#line 121 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob);
#line 4051 "ThumbnailCache.c"
	{
		GdkPixbuf* _tmp0_ = NULL;
		gboolean _tmp7_ = FALSE;
		GdkPixbuf* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		GdkPixbuf* _tmp16_ = NULL;
#line 124 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp0_ = self->unscaled;
#line 124 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (_tmp0_ == NULL) {
#line 4062 "ThumbnailCache.c"
			GdkPixbuf* _tmp1_ = NULL;
			ThumbnailCache* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			PhotoFileFormat _tmp4_ = 0;
			GdkPixbuf* _tmp5_ = NULL;
			GdkPixbuf* _tmp6_ = NULL;
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp2_ = self->cache;
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp3_ = self->thumbnail_name;
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp4_ = self->source_format;
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp5_ = thumbnail_cache_read_pixbuf (_tmp2_, _tmp3_, _tmp4_, &_inner_error_);
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp1_ = _tmp5_;
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4081 "ThumbnailCache.c"
				goto __catch240_g_error;
			}
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp6_ = _tmp1_;
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp1_ = NULL;
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_object_unref0 (self->unscaled);
#line 125 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			self->unscaled = _tmp6_;
#line 126 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			self->fetched = TRUE;
#line 124 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_object_unref0 (_tmp1_);
#line 4096 "ThumbnailCache.c"
		}
#line 129 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp7_ = background_job_is_cancelled (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BACKGROUND_JOB, BackgroundJob));
#line 129 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (_tmp7_) {
#line 130 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return;
#line 4104 "ThumbnailCache.c"
		}
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp9_ = dimensions_has_area (&self->dim);
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (_tmp9_) {
#line 4110 "ThumbnailCache.c"
			GdkPixbuf* _tmp10_ = NULL;
			Dimensions _tmp11_ = {0};
			GdkInterpType _tmp12_ = 0;
			GdkPixbuf* _tmp13_ = NULL;
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp10_ = self->unscaled;
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp11_ = self->dim;
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp12_ = self->interp;
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp13_ = resize_pixbuf (_tmp10_, &_tmp11_, _tmp12_);
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_object_unref0 (_tmp8_);
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp8_ = _tmp13_;
#line 4127 "ThumbnailCache.c"
		} else {
			GdkPixbuf* _tmp14_ = NULL;
			GdkPixbuf* _tmp15_ = NULL;
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp14_ = self->unscaled;
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp15_ = _g_object_ref0 (_tmp14_);
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_object_unref0 (_tmp8_);
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp8_ = _tmp15_;
#line 4139 "ThumbnailCache.c"
		}
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp16_ = _g_object_ref0 (_tmp8_);
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (self->scaled);
#line 133 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		self->scaled = _tmp16_;
#line 122 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (_tmp8_);
#line 4149 "ThumbnailCache.c"
	}
	goto __finally240;
	__catch240_g_error:
	{
		GError* err = NULL;
		GError* _tmp17_ = NULL;
#line 122 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		err = _inner_error_;
#line 122 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_inner_error_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp17_ = err;
#line 135 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (_tmp17_->domain == G_FILE_ERROR) {
#line 4164 "ThumbnailCache.c"
			{
#line 137 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				thumbnail_cache_async_fetch_job_generate_thumbnail (self, &_inner_error_);
#line 137 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 4170 "ThumbnailCache.c"
					goto __catch241_g_error;
				}
			}
			goto __finally241;
			__catch241_g_error:
			{
				GError* generr = NULL;
				GError* _tmp18_ = NULL;
				GError* _tmp19_ = NULL;
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				generr = _inner_error_;
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_inner_error_ = NULL;
#line 140 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp18_ = generr;
#line 140 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_tmp19_ = _g_error_copy0 (_tmp18_);
#line 140 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_error_free0 (err);
#line 140 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				err = _tmp19_;
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_error_free0 (generr);
#line 4194 "ThumbnailCache.c"
			}
			__finally241:
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_error_free0 (err);
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_error_free0 (err);
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				g_clear_error (&_inner_error_);
#line 136 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				return;
#line 4209 "ThumbnailCache.c"
			}
		} else {
			GError* _tmp20_ = NULL;
			GError* _tmp21_ = NULL;
#line 144 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp20_ = err;
#line 144 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp21_ = _g_error_copy0 (_tmp20_);
#line 144 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_error_free0 (self->err);
#line 144 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			self->err = _tmp21_;
#line 4222 "ThumbnailCache.c"
		}
#line 122 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_error_free0 (err);
#line 4226 "ThumbnailCache.c"
	}
	__finally240:
#line 122 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 122 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 122 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		g_clear_error (&_inner_error_);
#line 122 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		return;
#line 4237 "ThumbnailCache.c"
	}
}


static void thumbnail_cache_async_fetch_job_generate_thumbnail (ThumbnailCacheAsyncFetchJob* self, GError** error) {
	Photo* photo = NULL;
	ThumbnailSource* _tmp0_ = NULL;
	Photo* _tmp1_ = NULL;
	Photo* _tmp2_ = NULL;
	GdkPixbuf* _tmp19_ = NULL;
	GError * _inner_error_ = NULL;
#line 149 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_return_if_fail (THUMBNAIL_CACHE_IS_ASYNC_FETCH_JOB (self));
#line 150 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = self->source;
#line 150 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_PHOTO) ? ((Photo*) _tmp0_) : NULL);
#line 150 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	photo = _tmp1_;
#line 151 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp2_ = photo;
#line 151 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp2_ != NULL) {
#line 4261 "ThumbnailCache.c"
		GdkPixbuf* _tmp3_ = NULL;
		Photo* _tmp4_ = NULL;
		Dimensions _tmp5_ = {0};
		gint _tmp6_ = 0;
		Scaling _tmp7_ = {0};
		GdkPixbuf* _tmp8_ = NULL;
		GdkPixbuf* _tmp9_ = NULL;
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp4_ = photo;
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp5_ = self->dim;
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp6_ = _tmp5_.width;
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		scaling_for_best_fit (_tmp6_, TRUE, &_tmp7_);
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp8_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp7_, &_inner_error_);
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp3_ = _tmp8_;
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			g_propagate_error (error, _inner_error_);
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_object_unref0 (photo);
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			return;
#line 4289 "ThumbnailCache.c"
		}
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp9_ = _tmp3_;
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp3_ = NULL;
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (self->unscaled);
#line 152 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		self->unscaled = _tmp9_;
#line 151 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (_tmp3_);
#line 4301 "ThumbnailCache.c"
	} else {
		Video* video = NULL;
		ThumbnailSource* _tmp10_ = NULL;
		Video* _tmp11_ = NULL;
		Video* _tmp12_ = NULL;
#line 154 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp10_ = self->source;
#line 154 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, TYPE_VIDEO) ? ((Video*) _tmp10_) : NULL);
#line 154 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		video = _tmp11_;
#line 155 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp12_ = video;
#line 155 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		if (_tmp12_ != NULL) {
#line 4317 "ThumbnailCache.c"
			GdkPixbuf* _tmp13_ = NULL;
			Video* _tmp14_ = NULL;
			Dimensions _tmp15_ = {0};
			gint _tmp16_ = 0;
			GdkPixbuf* _tmp17_ = NULL;
			GdkPixbuf* _tmp18_ = NULL;
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp14_ = video;
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp15_ = self->dim;
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp16_ = _tmp15_.width;
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp17_ = thumbnail_source_create_thumbnail (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), _tmp16_, &_inner_error_);
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp13_ = _tmp17_;
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				g_propagate_error (error, _inner_error_);
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_object_unref0 (video);
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				_g_object_unref0 (photo);
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
				return;
#line 4344 "ThumbnailCache.c"
			}
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp18_ = _tmp13_;
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_tmp13_ = NULL;
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_object_unref0 (self->unscaled);
#line 156 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			self->unscaled = _tmp18_;
#line 155 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
			_g_object_unref0 (_tmp13_);
#line 4356 "ThumbnailCache.c"
		}
#line 151 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (video);
#line 4360 "ThumbnailCache.c"
	}
#line 159 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp19_ = self->unscaled;
#line 159 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	if (_tmp19_ != NULL) {
#line 4366 "ThumbnailCache.c"
		GdkPixbuf* _tmp20_ = NULL;
		Dimensions _tmp21_ = {0};
		GdkInterpType _tmp22_ = 0;
		GdkPixbuf* _tmp23_ = NULL;
#line 160 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp20_ = self->unscaled;
#line 160 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp21_ = self->dim;
#line 160 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp22_ = self->interp;
#line 160 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_tmp23_ = resize_pixbuf (_tmp20_, &_tmp21_, _tmp22_);
#line 160 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		_g_object_unref0 (self->scaled);
#line 160 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		self->scaled = _tmp23_;
#line 161 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
		self->replace = TRUE;
#line 4385 "ThumbnailCache.c"
	}
#line 149 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (photo);
#line 4389 "ThumbnailCache.c"
}


static void thumbnail_cache_async_fetch_job_class_init (ThumbnailCacheAsyncFetchJobClass * klass) {
#line 77 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_async_fetch_job_parent_class = g_type_class_peek_parent (klass);
#line 77 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	((BackgroundJobClass *) klass)->finalize = thumbnail_cache_async_fetch_job_finalize;
#line 77 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	((BackgroundJobClass *) klass)->get_priority = thumbnail_cache_async_fetch_job_real_get_priority;
#line 77 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	((BackgroundJobClass *) klass)->execute = thumbnail_cache_async_fetch_job_real_execute;
#line 4402 "ThumbnailCache.c"
}


static void thumbnail_cache_async_fetch_job_instance_init (ThumbnailCacheAsyncFetchJob * self) {
#line 86 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->scaled = NULL;
#line 87 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->err = NULL;
#line 88 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->fetched = FALSE;
#line 89 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->replace = FALSE;
#line 4415 "ThumbnailCache.c"
}


static void thumbnail_cache_async_fetch_job_finalize (BackgroundJob* obj) {
	ThumbnailCacheAsyncFetchJob * self;
#line 77 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, THUMBNAIL_CACHE_TYPE_ASYNC_FETCH_JOB, ThumbnailCacheAsyncFetchJob);
#line 78 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->cache);
#line 79 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_free0 (self->thumbnail_name);
#line 80 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->source);
#line 85 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->unscaled);
#line 86 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->scaled);
#line 87 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_error_free0 (self->err);
#line 77 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	BACKGROUND_JOB_CLASS (thumbnail_cache_async_fetch_job_parent_class)->finalize (obj);
#line 4437 "ThumbnailCache.c"
}


static GType thumbnail_cache_async_fetch_job_get_type (void) {
	static volatile gsize thumbnail_cache_async_fetch_job_type_id__volatile = 0;
	if (g_once_init_enter (&thumbnail_cache_async_fetch_job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ThumbnailCacheAsyncFetchJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_cache_async_fetch_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThumbnailCacheAsyncFetchJob), 0, (GInstanceInitFunc) thumbnail_cache_async_fetch_job_instance_init, NULL };
		GType thumbnail_cache_async_fetch_job_type_id;
		thumbnail_cache_async_fetch_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "ThumbnailCacheAsyncFetchJob", &g_define_type_info, 0);
		g_once_init_leave (&thumbnail_cache_async_fetch_job_type_id__volatile, thumbnail_cache_async_fetch_job_type_id);
	}
	return thumbnail_cache_async_fetch_job_type_id__volatile;
}


static void thumbnail_cache_class_init (ThumbnailCacheClass * klass) {
	ThumbnailCacheSize* _tmp0_ = NULL;
#line 27 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_parent_class = g_type_class_peek_parent (klass);
#line 27 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	g_type_class_add_private (klass, sizeof (ThumbnailCachePrivate));
#line 27 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	G_OBJECT_CLASS (klass)->finalize = thumbnail_cache_finalize;
#line 54 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = g_new0 (ThumbnailCacheSize, 2);
#line 54 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_[0] = THUMBNAIL_CACHE_SIZE_BIG;
#line 54 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_[1] = THUMBNAIL_CACHE_SIZE_MEDIUM;
#line 54 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_ALL_SIZES = _tmp0_;
#line 54 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	thumbnail_cache_ALL_SIZES_length1 = 2;
#line 4471 "ThumbnailCache.c"
}


static void thumbnail_cache_instance_init (ThumbnailCache * self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeArrayList* _tmp1_ = NULL;
#line 27 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv = THUMBNAIL_CACHE_GET_PRIVATE (self);
#line 186 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, THUMBNAIL_CACHE_TYPE_IMAGE_DATA, (GBoxedCopyFunc) thumbnail_cache_image_data_ref, thumbnail_cache_image_data_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 186 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->cache_map = _tmp0_;
#line 187 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 187 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->cache_lru = _tmp1_;
#line 188 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self->priv->cached_bytes = (gulong) 0;
#line 4490 "ThumbnailCache.c"
}


static void thumbnail_cache_finalize (GObject* obj) {
	ThumbnailCache * self;
#line 27 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THUMBNAIL_CACHE, ThumbnailCache);
#line 181 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->priv->cache_dir);
#line 186 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->priv->cache_map);
#line 187 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	_g_object_unref0 (self->priv->cache_lru);
#line 27 "/home/jens/Source/shotwell/src/ThumbnailCache.vala"
	G_OBJECT_CLASS (thumbnail_cache_parent_class)->finalize (obj);
#line 4506 "ThumbnailCache.c"
}


GType thumbnail_cache_get_type (void) {
	static volatile gsize thumbnail_cache_type_id__volatile = 0;
	if (g_once_init_enter (&thumbnail_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ThumbnailCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThumbnailCache), 0, (GInstanceInitFunc) thumbnail_cache_instance_init, NULL };
		GType thumbnail_cache_type_id;
		thumbnail_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "ThumbnailCache", &g_define_type_info, 0);
		g_once_init_leave (&thumbnail_cache_type_id__volatile, thumbnail_cache_type_id);
	}
	return thumbnail_cache_type_id__volatile;
}



