/* LibraryFiles.c generated by valac 0.34.1, the Vala compiler
 * generated from LibraryFiles.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <gio/gio.h>


#define TYPE_MEDIA_METADATA (media_metadata_get_type ())
#define MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_METADATA, MediaMetadata))
#define MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_METADATA, MediaMetadataClass))
#define IS_MEDIA_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_METADATA))
#define IS_MEDIA_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_METADATA))
#define MEDIA_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_METADATA, MediaMetadataClass))

typedef struct _MediaMetadata MediaMetadata;
typedef struct _MediaMetadataClass MediaMetadataClass;

#define TYPE_METADATA_DATE_TIME (metadata_date_time_get_type ())
#define METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTime))
#define METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))
#define IS_METADATA_DATE_TIME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METADATA_DATE_TIME))
#define IS_METADATA_DATE_TIME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METADATA_DATE_TIME))
#define METADATA_DATE_TIME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METADATA_DATE_TIME, MetadataDateTimeClass))

typedef struct _MetadataDateTime MetadataDateTime;
typedef struct _MetadataDateTimeClass MetadataDateTimeClass;
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_VIDEO_READER (video_reader_get_type ())
#define VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_READER, VideoReader))
#define VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_READER, VideoReaderClass))
#define IS_VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_READER))
#define IS_VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_READER))
#define VIDEO_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_READER, VideoReaderClass))

typedef struct _VideoReader VideoReader;
typedef struct _VideoReaderClass VideoReaderClass;

#define TYPE_VIDEO_METADATA (video_metadata_get_type ())
#define VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_METADATA, VideoMetadata))
#define VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_METADATA, VideoMetadataClass))
#define IS_VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_METADATA))
#define IS_VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_METADATA))
#define VIDEO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_METADATA, VideoMetadataClass))

typedef struct _VideoMetadata VideoMetadata;
typedef struct _VideoMetadataClass VideoMetadataClass;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _video_reader_unref0(var) ((var == NULL) ? NULL : (var = (video_reader_unref (var), NULL)))

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;



gpointer media_metadata_ref (gpointer instance);
void media_metadata_unref (gpointer instance);
GParamSpec* param_spec_media_metadata (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_metadata (GValue* value, gpointer v_object);
void value_take_media_metadata (GValue* value, gpointer v_object);
gpointer value_get_media_metadata (const GValue* value);
GType media_metadata_get_type (void) G_GNUC_CONST;
GFile* library_files_generate_unique_file (const gchar* basename, MediaMetadata* metadata, time_t ts, gboolean* collision, GError** error);
gpointer metadata_date_time_ref (gpointer instance);
void metadata_date_time_unref (gpointer instance);
GParamSpec* param_spec_metadata_date_time (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_metadata_date_time (GValue* value, gpointer v_object);
void value_take_metadata_date_time (GValue* value, gpointer v_object);
gpointer value_get_metadata_date_time (const GValue* value);
GType metadata_date_time_get_type (void) G_GNUC_CONST;
MetadataDateTime* media_metadata_get_creation_date_time (MediaMetadata* self);
time_t metadata_date_time_get_timestamp (MetadataDateTime* self);
GFile* app_dirs_get_baked_import_dir (time_t tm);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType config_facade_get_type (void) G_GNUC_CONST;
ConfigFacade* config_facade_get_instance (void);
gboolean configuration_facade_get_use_lowercase_filenames (ConfigurationFacade* self);
GFile* generate_unique_file (GFile* dir, const gchar* basename, gboolean* collision, GError** error);
GFile* library_files_duplicate (GFile* src, GFileProgressCallback progress_callback, void* progress_callback_target, gboolean blacklist, GError** error);
time_t query_file_modified (GFile* file, GError** error);
gboolean video_reader_is_supported_video_file (GFile* file);
gpointer video_reader_ref (gpointer instance);
void video_reader_unref (gpointer instance);
GParamSpec* param_spec_video_reader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_video_reader (GValue* value, gpointer v_object);
void value_take_video_reader (GValue* value, gpointer v_object);
gpointer value_get_video_reader (const GValue* value);
GType video_reader_get_type (void) G_GNUC_CONST;
VideoReader* video_reader_new (GFile* file);
VideoReader* video_reader_construct (GType object_type, GFile* file);
GType video_metadata_get_type (void) G_GNUC_CONST;
VideoMetadata* video_reader_read_metadata (VideoReader* self, GError** error);
gpointer photo_file_adapter_ref (gpointer instance);
void photo_file_adapter_unref (gpointer instance);
GParamSpec* param_spec_photo_file_adapter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_photo_file_adapter (GValue* value, gpointer v_object);
void value_take_photo_file_adapter (GValue* value, gpointer v_object);
gpointer value_get_photo_file_adapter (const GValue* value);
GType photo_file_adapter_get_type (void) G_GNUC_CONST;
GType photo_file_reader_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
PhotoFileFormat photo_file_format_get_by_file_extension (GFile* file);
PhotoFileReader* photo_file_format_create_reader (PhotoFileFormat self, const gchar* filepath);
GType photo_metadata_get_type (void) G_GNUC_CONST;
PhotoMetadata* photo_file_reader_read_metadata (PhotoFileReader* self, GError** error);
void library_monitor_blacklist_file (GFile* file, const gchar* reason);
void library_monitor_unblacklist_file (GFile* file);
gchar* md5_file (GFile* file, GError** error);


static gpointer _g_error_copy0 (gpointer self) {
#line 33 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	return self ? g_error_copy (self) : NULL;
#line 187 "LibraryFiles.c"
}


GFile* library_files_generate_unique_file (const gchar* basename, MediaMetadata* metadata, time_t ts, gboolean* collision, GError** error) {
	gboolean _vala_collision = FALSE;
	GFile* result = NULL;
	time_t timestamp = 0;
	time_t _tmp0_ = 0;
	MediaMetadata* _tmp1_ = NULL;
	GFile* dir = NULL;
	time_t _tmp9_ = 0;
	GFile* _tmp10_ = NULL;
	gchar* newbasename = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	ConfigFacade* _tmp17_ = NULL;
	ConfigFacade* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	GFile* _tmp23_ = NULL;
	GFile* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	GFile* _tmp27_ = NULL;
	GFile* _tmp28_ = NULL;
	GError * _inner_error_ = NULL;
#line 13 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	g_return_val_if_fail (basename != NULL, NULL);
#line 13 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	g_return_val_if_fail ((metadata == NULL) || IS_MEDIA_METADATA (metadata), NULL);
#line 18 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp0_ = ts;
#line 18 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	timestamp = _tmp0_;
#line 19 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp1_ = metadata;
#line 19 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (_tmp1_ != NULL) {
#line 226 "LibraryFiles.c"
		MetadataDateTime* date_time = NULL;
		MediaMetadata* _tmp2_ = NULL;
		MetadataDateTime* _tmp3_ = NULL;
		MetadataDateTime* _tmp4_ = NULL;
#line 20 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp2_ = metadata;
#line 20 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp3_ = media_metadata_get_creation_date_time (_tmp2_);
#line 20 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		date_time = _tmp3_;
#line 21 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp4_ = date_time;
#line 21 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (_tmp4_ != NULL) {
#line 241 "LibraryFiles.c"
			MetadataDateTime* _tmp5_ = NULL;
			time_t _tmp6_ = 0;
#line 22 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp5_ = date_time;
#line 22 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp6_ = metadata_date_time_get_timestamp (_tmp5_);
#line 22 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			timestamp = _tmp6_;
#line 250 "LibraryFiles.c"
		} else {
			time_t _tmp7_ = 0;
#line 23 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp7_ = timestamp;
#line 23 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (_tmp7_ == ((time_t) 0)) {
#line 257 "LibraryFiles.c"
				time_t _tmp8_ = 0;
#line 24 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_tmp8_ = time (NULL);
#line 24 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				timestamp = _tmp8_;
#line 263 "LibraryFiles.c"
			}
		}
#line 19 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_metadata_date_time_unref0 (date_time);
#line 268 "LibraryFiles.c"
	}
#line 28 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp9_ = timestamp;
#line 28 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp10_ = app_dirs_get_baked_import_dir (_tmp9_);
#line 28 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	dir = _tmp10_;
#line 276 "LibraryFiles.c"
	{
		GFile* _tmp11_ = NULL;
#line 30 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp11_ = dir;
#line 30 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_file_make_directory_with_parents (_tmp11_, NULL, &_inner_error_);
#line 30 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 285 "LibraryFiles.c"
			goto __catch464_g_error;
		}
	}
	goto __finally464;
	__catch464_g_error:
	{
		GError* err = NULL;
		GError* _tmp12_ = NULL;
#line 29 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		err = _inner_error_;
#line 29 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = NULL;
#line 32 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp12_ = err;
#line 32 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (!g_error_matches (_tmp12_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
#line 302 "LibraryFiles.c"
			GError* _tmp13_ = NULL;
			GError* _tmp14_ = NULL;
#line 33 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp13_ = err;
#line 33 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp14_ = _g_error_copy0 (_tmp13_);
#line 33 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_inner_error_ = _tmp14_;
#line 33 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_error_free0 (err);
#line 313 "LibraryFiles.c"
			goto __finally464;
		}
#line 29 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_error_free0 (err);
#line 318 "LibraryFiles.c"
	}
	__finally464:
#line 29 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 29 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 29 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (dir);
#line 29 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 329 "LibraryFiles.c"
	}
#line 39 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp15_ = basename;
#line 39 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 39 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	newbasename = _tmp16_;
#line 40 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp17_ = config_facade_get_instance ();
#line 40 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp18_ = _tmp17_;
#line 40 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp19_ = configuration_facade_get_use_lowercase_filenames (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
#line 40 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp20_ = _tmp19_;
#line 40 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_object_unref0 (_tmp18_);
#line 40 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (_tmp20_) {
#line 349 "LibraryFiles.c"
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
#line 41 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp21_ = newbasename;
#line 41 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp22_ = g_utf8_strdown (_tmp21_, (gssize) -1);
#line 41 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (newbasename);
#line 41 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		newbasename = _tmp22_;
#line 360 "LibraryFiles.c"
	}
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp24_ = dir;
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp25_ = newbasename;
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp27_ = generate_unique_file (_tmp24_, _tmp25_, &_tmp26_, &_inner_error_);
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_vala_collision = _tmp26_;
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp23_ = _tmp27_;
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (newbasename);
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (dir);
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 382 "LibraryFiles.c"
	}
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp28_ = _tmp23_;
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp23_ = NULL;
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	result = _tmp28_;
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_object_unref0 (_tmp23_);
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_free0 (newbasename);
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_object_unref0 (dir);
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (collision) {
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		*collision = _vala_collision;
#line 400 "LibraryFiles.c"
	}
#line 43 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	return result;
#line 404 "LibraryFiles.c"
}


GFile* library_files_duplicate (GFile* src, GFileProgressCallback progress_callback, void* progress_callback_target, gboolean blacklist, GError** error) {
	GFile* result = NULL;
	time_t timestamp = 0;
	MediaMetadata* metadata = NULL;
	GFile* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean collision = FALSE;
	GFile* dest = NULL;
	GFile* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	MediaMetadata* _tmp30_ = NULL;
	time_t _tmp31_ = 0;
	gboolean _tmp32_ = FALSE;
	GFile* _tmp33_ = NULL;
	GFile* _tmp34_ = NULL;
	GFile* _tmp35_ = NULL;
	gboolean _tmp37_ = FALSE;
	GError * _inner_error_ = NULL;
#line 47 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	g_return_val_if_fail (G_IS_FILE (src), NULL);
#line 48 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	timestamp = (time_t) 0;
#line 431 "LibraryFiles.c"
	{
		time_t _tmp0_ = 0;
		GFile* _tmp1_ = NULL;
		time_t _tmp2_ = 0;
#line 50 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp1_ = src;
#line 50 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp2_ = query_file_modified (_tmp1_, &_inner_error_);
#line 50 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp0_ = _tmp2_;
#line 50 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 444 "LibraryFiles.c"
			goto __catch465_g_error;
		}
#line 50 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		timestamp = _tmp0_;
#line 449 "LibraryFiles.c"
	}
	goto __finally465;
	__catch465_g_error:
	{
		GError* err = NULL;
		GFile* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 49 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		err = _inner_error_;
#line 49 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = NULL;
#line 52 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp3_ = src;
#line 52 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp4_ = g_file_get_path (_tmp3_);
#line 52 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp5_ = _tmp4_;
#line 52 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp6_ = err;
#line 52 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp7_ = _tmp6_->message;
#line 52 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_critical ("LibraryFiles.vala:52: Unable to access file modification for %s: %s", _tmp5_, _tmp7_);
#line 52 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp5_);
#line 49 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_error_free0 (err);
#line 480 "LibraryFiles.c"
	}
	__finally465:
#line 49 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 49 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 49 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 489 "LibraryFiles.c"
	}
#line 55 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	metadata = NULL;
#line 56 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp8_ = src;
#line 56 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp9_ = video_reader_is_supported_video_file (_tmp8_);
#line 56 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (_tmp9_) {
#line 499 "LibraryFiles.c"
		VideoReader* reader = NULL;
		GFile* _tmp10_ = NULL;
		VideoReader* _tmp11_ = NULL;
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp10_ = src;
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp11_ = video_reader_new (_tmp10_);
#line 57 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		reader = _tmp11_;
#line 509 "LibraryFiles.c"
		{
			VideoMetadata* _tmp12_ = NULL;
			VideoReader* _tmp13_ = NULL;
			VideoMetadata* _tmp14_ = NULL;
			VideoMetadata* _tmp15_ = NULL;
#line 59 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp13_ = reader;
#line 59 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp14_ = video_reader_read_metadata (_tmp13_, &_inner_error_);
#line 59 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp12_ = _tmp14_;
#line 59 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 523 "LibraryFiles.c"
				goto __catch466_g_error;
			}
#line 59 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp15_ = _tmp12_;
#line 59 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp12_ = NULL;
#line 59 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (metadata);
#line 59 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			metadata = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_MEDIA_METADATA, MediaMetadata);
#line 58 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (_tmp12_);
#line 536 "LibraryFiles.c"
		}
		goto __finally466;
		__catch466_g_error:
		{
			GError* err = NULL;
#line 58 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			err = _inner_error_;
#line 58 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_inner_error_ = NULL;
#line 58 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_error_free0 (err);
#line 548 "LibraryFiles.c"
		}
		__finally466:
#line 58 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 58 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			g_propagate_error (error, _inner_error_);
#line 58 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_video_reader_unref0 (reader);
#line 58 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (metadata);
#line 58 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			return NULL;
#line 561 "LibraryFiles.c"
		}
#line 56 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_video_reader_unref0 (reader);
#line 565 "LibraryFiles.c"
	} else {
		PhotoFileReader* reader = NULL;
		GFile* _tmp16_ = NULL;
		PhotoFileFormat _tmp17_ = 0;
		GFile* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		PhotoFileReader* _tmp21_ = NULL;
		PhotoFileReader* _tmp22_ = NULL;
#line 64 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp16_ = src;
#line 64 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp17_ = photo_file_format_get_by_file_extension (_tmp16_);
#line 64 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp18_ = src;
#line 64 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp19_ = g_file_get_path (_tmp18_);
#line 64 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp20_ = _tmp19_;
#line 64 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp21_ = photo_file_format_create_reader (_tmp17_, _tmp20_);
#line 64 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp22_ = _tmp21_;
#line 64 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp20_);
#line 64 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		reader = _tmp22_;
#line 593 "LibraryFiles.c"
		{
			PhotoMetadata* _tmp23_ = NULL;
			PhotoFileReader* _tmp24_ = NULL;
			PhotoMetadata* _tmp25_ = NULL;
			PhotoMetadata* _tmp26_ = NULL;
#line 67 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp24_ = reader;
#line 67 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp25_ = photo_file_reader_read_metadata (_tmp24_, &_inner_error_);
#line 67 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp23_ = _tmp25_;
#line 67 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 607 "LibraryFiles.c"
				goto __catch467_g_error;
			}
#line 67 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp26_ = _tmp23_;
#line 67 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp23_ = NULL;
#line 67 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (metadata);
#line 67 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			metadata = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_MEDIA_METADATA, MediaMetadata);
#line 66 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (_tmp23_);
#line 620 "LibraryFiles.c"
		}
		goto __finally467;
		__catch467_g_error:
		{
			GError* err = NULL;
#line 66 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			err = _inner_error_;
#line 66 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_inner_error_ = NULL;
#line 66 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_error_free0 (err);
#line 632 "LibraryFiles.c"
		}
		__finally467:
#line 66 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 66 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			g_propagate_error (error, _inner_error_);
#line 66 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_photo_file_adapter_unref0 (reader);
#line 66 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_media_metadata_unref0 (metadata);
#line 66 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			return NULL;
#line 645 "LibraryFiles.c"
		}
#line 56 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_photo_file_adapter_unref0 (reader);
#line 649 "LibraryFiles.c"
	}
#line 74 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp27_ = src;
#line 74 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp28_ = g_file_get_basename (_tmp27_);
#line 74 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp29_ = _tmp28_;
#line 74 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp30_ = metadata;
#line 74 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp31_ = timestamp;
#line 74 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp33_ = library_files_generate_unique_file (_tmp29_, _tmp30_, _tmp31_, &_tmp32_, &_inner_error_);
#line 74 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	collision = _tmp32_;
#line 74 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp34_ = _tmp33_;
#line 74 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_g_free0 (_tmp29_);
#line 74 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	dest = _tmp34_;
#line 74 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 74 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 74 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_media_metadata_unref0 (metadata);
#line 74 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 679 "LibraryFiles.c"
	}
#line 75 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp35_ = dest;
#line 75 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (_tmp35_ == NULL) {
#line 685 "LibraryFiles.c"
		GError* _tmp36_ = NULL;
#line 76 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp36_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Unable to generate unique pathname for destination");
#line 76 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = _tmp36_;
#line 76 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 76 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (dest);
#line 76 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_media_metadata_unref0 (metadata);
#line 76 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 699 "LibraryFiles.c"
	}
#line 78 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_tmp37_ = blacklist;
#line 78 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (_tmp37_) {
#line 705 "LibraryFiles.c"
		GFile* _tmp38_ = NULL;
#line 79 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp38_ = dest;
#line 79 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		library_monitor_blacklist_file (_tmp38_, "LibraryFiles.duplicate");
#line 711 "LibraryFiles.c"
	}
	{
		GFile* _tmp39_ = NULL;
		GFile* _tmp40_ = NULL;
		GFileProgressCallback _tmp41_ = NULL;
		void* _tmp41__target = NULL;
		gboolean _tmp42_ = FALSE;
#line 82 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp39_ = src;
#line 82 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp40_ = dest;
#line 82 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp41_ = progress_callback;
#line 82 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp41__target = progress_callback_target;
#line 82 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_file_copy (_tmp39_, _tmp40_, G_FILE_COPY_ALL_METADATA | G_FILE_COPY_OVERWRITE, NULL, _tmp41_, _tmp41__target, &_inner_error_);
#line 82 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 731 "LibraryFiles.c"
			goto __catch468_g_error;
		}
#line 83 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp42_ = blacklist;
#line 83 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (_tmp42_) {
#line 738 "LibraryFiles.c"
			GFile* _tmp43_ = NULL;
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp43_ = dest;
#line 84 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			library_monitor_unblacklist_file (_tmp43_);
#line 744 "LibraryFiles.c"
		}
	}
	goto __finally468;
	__catch468_g_error:
	{
		GError* err = NULL;
		GFile* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		GError* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		gboolean _tmp49_ = FALSE;
		gboolean _tmp50_ = FALSE;
#line 81 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		err = _inner_error_;
#line 81 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = NULL;
#line 86 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp44_ = src;
#line 86 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp45_ = g_file_get_path (_tmp44_);
#line 86 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp46_ = _tmp45_;
#line 86 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp47_ = err;
#line 86 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp48_ = _tmp47_->message;
#line 86 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_message ("LibraryFiles.vala:86: There was a problem copying %s: %s", _tmp46_, _tmp48_);
#line 86 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_free0 (_tmp46_);
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp50_ = blacklist;
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (_tmp50_) {
#line 780 "LibraryFiles.c"
			gchar* _tmp51_ = NULL;
			GFile* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
			gchar* _tmp54_ = NULL;
			GFile* _tmp55_ = NULL;
			gchar* _tmp56_ = NULL;
			gchar* _tmp57_ = NULL;
			gchar* _tmp58_ = NULL;
			gchar* _tmp59_ = NULL;
			gchar* _tmp60_ = NULL;
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp52_ = src;
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp53_ = md5_file (_tmp52_, &_inner_error_);
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp51_ = _tmp53_;
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_g_error_free0 (err);
#line 801 "LibraryFiles.c"
				goto __finally468;
			}
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp55_ = dest;
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp56_ = md5_file (_tmp55_, &_inner_error_);
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp54_ = _tmp56_;
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_g_free0 (_tmp51_);
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
				_g_error_free0 (err);
#line 816 "LibraryFiles.c"
				goto __finally468;
			}
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp57_ = _tmp51_;
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp51_ = NULL;
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp58_ = _tmp57_;
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp59_ = _tmp54_;
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp54_ = NULL;
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp60_ = _tmp59_;
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp49_ = g_strcmp0 (_tmp58_, _tmp60_) != 0;
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_free0 (_tmp60_);
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_free0 (_tmp58_);
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_free0 (_tmp54_);
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_free0 (_tmp51_);
#line 841 "LibraryFiles.c"
		} else {
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp49_ = FALSE;
#line 845 "LibraryFiles.c"
		}
#line 87 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (_tmp49_) {
#line 849 "LibraryFiles.c"
			GFile* _tmp61_ = NULL;
#line 88 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_tmp61_ = dest;
#line 88 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			library_monitor_unblacklist_file (_tmp61_);
#line 855 "LibraryFiles.c"
		}
#line 81 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_error_free0 (err);
#line 859 "LibraryFiles.c"
	}
	__finally468:
#line 81 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 81 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 81 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (dest);
#line 81 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_media_metadata_unref0 (metadata);
#line 81 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 872 "LibraryFiles.c"
	}
	{
		GFileInfo* info = NULL;
		GFile* _tmp62_ = NULL;
		GFileInfo* _tmp63_ = NULL;
		guint32 mode = 0U;
		GFileInfo* _tmp64_ = NULL;
		guint32 _tmp65_ = 0U;
		gboolean _tmp66_ = FALSE;
		GFile* _tmp67_ = NULL;
		guint32 _tmp68_ = 0U;
		gboolean _tmp69_ = FALSE;
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp62_ = dest;
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp63_ = g_file_query_info (_tmp62_, G_FILE_ATTRIBUTE_UNIX_MODE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		info = _tmp63_;
#line 93 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 893 "LibraryFiles.c"
			goto __catch469_g_error;
		}
#line 94 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp64_ = info;
#line 94 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp65_ = g_file_info_get_attribute_uint32 (_tmp64_, G_FILE_ATTRIBUTE_UNIX_MODE);
#line 94 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		mode = _tmp65_ | 0600;
#line 95 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp67_ = dest;
#line 95 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp68_ = mode;
#line 95 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp69_ = g_file_set_attribute_uint32 (_tmp67_, G_FILE_ATTRIBUTE_UNIX_MODE, _tmp68_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 95 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp66_ = _tmp69_;
#line 95 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 95 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			_g_object_unref0 (info);
#line 914 "LibraryFiles.c"
			goto __catch469_g_error;
		}
#line 95 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		if (!_tmp66_) {
#line 96 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
			g_warning ("LibraryFiles.vala:96: Could not make file writable");
#line 921 "LibraryFiles.c"
		}
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (info);
#line 925 "LibraryFiles.c"
	}
	goto __finally469;
	__catch469_g_error:
	{
		GError* err = NULL;
		GError* _tmp70_ = NULL;
		const gchar* _tmp71_ = NULL;
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		err = _inner_error_;
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_inner_error_ = NULL;
#line 99 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp70_ = err;
#line 99 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_tmp71_ = _tmp70_->message;
#line 99 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_warning ("LibraryFiles.vala:99: Could not make file writable: %s", _tmp71_);
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_error_free0 (err);
#line 945 "LibraryFiles.c"
	}
	__finally469:
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		g_propagate_error (error, _inner_error_);
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_g_object_unref0 (dest);
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		_media_metadata_unref0 (metadata);
#line 92 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
		return NULL;
#line 958 "LibraryFiles.c"
	}
#line 102 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	result = dest;
#line 102 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	_media_metadata_unref0 (metadata);
#line 102 "/home/jens/Source/shotwell/src/LibraryFiles.vala"
	return result;
#line 966 "LibraryFiles.c"
}



