/* Dimensions.c generated by valac 0.34.1, the Vala compiler
 * generated from Dimensions.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>


#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_SCALING (scaling_get_type ())
typedef struct _Scaling Scaling;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_ZOOM_STATE (zoom_state_get_type ())
typedef struct _ZoomState ZoomState;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _ZoomState {
	Dimensions content_dimensions;
	Dimensions viewport_dimensions;
	gdouble zoom_factor;
	gdouble interpolation_factor;
	gdouble min_factor;
	gdouble max_factor;
	GdkPoint viewport_center;
};



GType scale_constraint_get_type (void) G_GNUC_CONST;
gchar* scale_constraint_to_string (ScaleConstraint self);
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
void dimensions_init (Dimensions *self, gint width, gint height);
void dimensions_for_pixbuf (GdkPixbuf* pixbuf, Dimensions* result);
void dimensions_for_allocation (GtkAllocation* allocation, Dimensions* result);
void dimensions_for_widget_allocation (GtkWidget* widget, Dimensions* result);
void dimensions_for_rectangle (GdkRectangle* rect, Dimensions* result);
gboolean dimensions_has_area (Dimensions *self);
void dimensions_floor (Dimensions *self, Dimensions* min, Dimensions* result);
gchar* dimensions_to_string (Dimensions *self);
gboolean dimensions_equals (Dimensions *self, Dimensions* dim);
gboolean dimensions_approx_equals (Dimensions *self, Dimensions* dim, gint fudge);
gboolean dimensions_approx_scaled (Dimensions *self, gint scale, gint fudge);
gint dimensions_major_axis (Dimensions *self);
gint dimensions_minor_axis (Dimensions *self);
void dimensions_with_min (Dimensions *self, gint min_width, gint min_height, Dimensions* result);
void dimensions_with_max (Dimensions *self, gint max_width, gint max_height, Dimensions* result);
void dimensions_get_scaled (Dimensions *self, gint scale, gboolean scale_up, Dimensions* result);
void dimensions_get_scaled_by_width (Dimensions *self, gint scale, Dimensions* result);
void dimensions_get_scaled_by_height (Dimensions *self, gint scale, Dimensions* result);
void dimensions_get_scale_ratios (Dimensions *self, Dimensions* scaled, gdouble* width_ratio, gdouble* height_ratio);
gdouble dimensions_get_aspect_ratio (Dimensions *self);
void dimensions_get_scaled_proportional (Dimensions *self, Dimensions* viewport, Dimensions* result);
void dimensions_get_scaled_to_fill_viewport (Dimensions *self, Dimensions* viewport, Dimensions* result);
void dimensions_get_scaled_rectangle (Dimensions *self, Dimensions* scaled, GdkRectangle* rect, GdkRectangle* result);
void dimensions_get_scaled_similar (Dimensions *self, Dimensions* original, Dimensions* scaled, Dimensions* result);
void dimensions_get_scaled_by_constraint (Dimensions *self, gint scale, ScaleConstraint constraint, Dimensions* result);
GType scaling_get_type (void) G_GNUC_CONST;
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
#define SCALING_NO_SCALE 0
static void scaling_init (Scaling *self, ScaleConstraint constraint, gint scale, Dimensions* viewport, gboolean scale_up);
void scaling_for_original (Scaling* result);
void scaling_for_screen (GtkWindow* window, gboolean scale_up, Scaling* result);
void scaling_for_viewport (Dimensions* viewport, gboolean scale_up, Scaling* result);
static void scaling_get_screen_dimensions (GtkWindow* window, Dimensions* result);
void scaling_for_best_fit (gint pixels, gboolean scale_up, Scaling* result);
void scaling_for_widget (GtkWidget* widget, gboolean scale_up, Scaling* result);
void scaling_to_fill_viewport (Dimensions* viewport, Scaling* result);
void scaling_to_fill_screen (GtkWindow* window, Scaling* result);
void scaling_for_constraint (ScaleConstraint constraint, gint scale, gboolean scale_up, Scaling* result);
static gint scaling_scale_to_pixels (Scaling *self);
gboolean scaling_is_unscaled (Scaling *self);
gboolean scaling_is_best_fit (Scaling *self, Dimensions* original, gint* pixels);
gboolean scaling_is_best_fit_dimensions (Scaling *self, Dimensions* original, Dimensions* scaled);
gboolean scaling_is_for_viewport (Scaling *self, Dimensions* original, Dimensions* scaled);
gboolean scaling_is_fill_viewport (Scaling *self, Dimensions* original, Dimensions* scaled);
void scaling_get_scaled_dimensions (Scaling *self, Dimensions* original, Dimensions* result);
GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self, GdkPixbuf* pixbuf, GdkInterpType interp, gboolean scale_up);
GdkPixbuf* scale_pixbuf (GdkPixbuf* pixbuf, gint scale, GdkInterpType interp, gboolean scale_up);
GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf, Dimensions* resized, GdkInterpType interp);
gchar* scaling_to_string (Scaling *self);
gboolean scaling_equals (Scaling *self, Scaling* scaling);
GType zoom_state_get_type (void) G_GNUC_CONST;
ZoomState* zoom_state_dup (const ZoomState* self);
void zoom_state_free (ZoomState* self);
void zoom_state_init (ZoomState *self, Dimensions* content_dimensions, Dimensions* viewport_dimensions, gdouble slider_val, GdkPoint* viewport_center);
static void zoom_state_compute_zoom_factors (ZoomState *self);
static void zoom_state_center_viewport (ZoomState *self);
static void zoom_state_clamp_viewport_center (ZoomState *self);
void zoom_state_init_rescale (ZoomState *self, ZoomState* existing, gdouble new_slider_val);
void zoom_state_init_rescale_to_isomorphic (ZoomState *self, ZoomState* existing);
void zoom_state_init_pan (ZoomState *self, ZoomState* existing, GdkPoint* new_viewport_center);
gint zoom_state_get_zoomed_width (ZoomState *self);
gint zoom_state_get_zoomed_height (ZoomState *self);
gdouble zoom_state_get_interpolation_factor (ZoomState *self);
void zoom_state_get_viewing_rectangle_wrt_content (ZoomState *self, GdkRectangle* result);
void zoom_state_get_viewing_rectangle_wrt_screen (ZoomState *self, GdkRectangle* result);
void zoom_state_get_viewing_rectangle_projection (ZoomState *self, GdkPixbuf* for_pixbuf, GdkRectangle* result);
gdouble zoom_state_get_zoom_factor (ZoomState *self);
void zoom_state_get_viewport_center (ZoomState *self, GdkPoint* result);
gchar* zoom_state_to_string (ZoomState *self);
gboolean zoom_state_is_min (ZoomState *self);
gboolean zoom_state_is_default (ZoomState *self);
gboolean zoom_state_is_isomorphic (ZoomState *self);
gboolean zoom_state_is_max (ZoomState *self);
gboolean zoom_state_equals (ZoomState *self, ZoomState* other);


gchar* scale_constraint_to_string (ScaleConstraint self) {
	gchar* result = NULL;
#line 15 "/home/jens/Source/shotwell/src/Dimensions.vala"
	switch (self) {
#line 15 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_ORIGINAL:
#line 161 "Dimensions.c"
		{
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_ = NULL;
#line 17 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp0_ = _ ("Original size");
#line 17 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp1_ = g_strdup (_tmp0_);
#line 17 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = _tmp1_;
#line 17 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 173 "Dimensions.c"
		}
#line 15 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_DIMENSIONS:
#line 177 "Dimensions.c"
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
#line 20 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp2_ = _ ("Width or height");
#line 20 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 20 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = _tmp3_;
#line 20 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 189 "Dimensions.c"
		}
#line 15 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_WIDTH:
#line 193 "Dimensions.c"
		{
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
#line 23 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp4_ = _ ("Width");
#line 23 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp5_ = g_strdup (_tmp4_);
#line 23 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = _tmp5_;
#line 23 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 205 "Dimensions.c"
		}
#line 15 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_HEIGHT:
#line 209 "Dimensions.c"
		{
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
#line 26 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp6_ = _ ("Height");
#line 26 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp7_ = g_strdup (_tmp6_);
#line 26 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = _tmp7_;
#line 26 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 221 "Dimensions.c"
		}
#line 15 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_FILL_VIEWPORT:
#line 225 "Dimensions.c"
		{
			gchar* _tmp8_ = NULL;
#line 30 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp8_ = g_strdup ("Fill Viewport");
#line 30 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = _tmp8_;
#line 30 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 234 "Dimensions.c"
		}
		default:
#line 15 "/home/jens/Source/shotwell/src/Dimensions.vala"
		break;
#line 239 "Dimensions.c"
	}
#line 33 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_warn_if_reached ();
#line 35 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = NULL;
#line 35 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 247 "Dimensions.c"
}


GType scale_constraint_get_type (void) {
	static volatile gsize scale_constraint_type_id__volatile = 0;
	if (g_once_init_enter (&scale_constraint_type_id__volatile)) {
		static const GEnumValue values[] = {{SCALE_CONSTRAINT_ORIGINAL, "SCALE_CONSTRAINT_ORIGINAL", "original"}, {SCALE_CONSTRAINT_DIMENSIONS, "SCALE_CONSTRAINT_DIMENSIONS", "dimensions"}, {SCALE_CONSTRAINT_WIDTH, "SCALE_CONSTRAINT_WIDTH", "width"}, {SCALE_CONSTRAINT_HEIGHT, "SCALE_CONSTRAINT_HEIGHT", "height"}, {SCALE_CONSTRAINT_FILL_VIEWPORT, "SCALE_CONSTRAINT_FILL_VIEWPORT", "fill-viewport"}, {0, NULL, NULL}};
		GType scale_constraint_type_id;
		scale_constraint_type_id = g_enum_register_static ("ScaleConstraint", values);
		g_once_init_leave (&scale_constraint_type_id__volatile, scale_constraint_type_id);
	}
	return scale_constraint_type_id__volatile;
}


void dimensions_init (Dimensions *self, gint width, gint height) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 43 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (self, 0, sizeof (Dimensions));
#line 44 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = width;
#line 44 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_ < 0) {
#line 44 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = TRUE;
#line 280 "Dimensions.c"
	} else {
		gint _tmp2_ = 0;
#line 44 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp2_ = height;
#line 44 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp2_ < 0;
#line 287 "Dimensions.c"
	}
#line 44 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp0_) {
#line 45 "/home/jens/Source/shotwell/src/Dimensions.vala"
		g_warning ("Dimensions.vala:45: Tried to construct a Dimensions object with negati" \
"ve width or height - forcing sensible default values.");
#line 293 "Dimensions.c"
	}
#line 47 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = width;
#line 47 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = width;
#line 47 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = CLAMP (_tmp3_, 0, _tmp4_);
#line 47 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).width = _tmp5_;
#line 48 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = height;
#line 48 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = height;
#line 48 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = CLAMP (_tmp6_, 0, _tmp7_);
#line 48 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).height = _tmp8_;
#line 311 "Dimensions.c"
}


void dimensions_for_pixbuf (GdkPixbuf* pixbuf, Dimensions* result) {
	GdkPixbuf* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GdkPixbuf* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Dimensions _tmp4_ = {0};
#line 51 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (GDK_IS_PIXBUF (pixbuf));
#line 52 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = pixbuf;
#line 52 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = gdk_pixbuf_get_width (_tmp0_);
#line 52 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = pixbuf;
#line 52 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = gdk_pixbuf_get_height (_tmp2_);
#line 52 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp4_, _tmp1_, _tmp3_);
#line 52 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp4_;
#line 52 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 337 "Dimensions.c"
}


void dimensions_for_allocation (GtkAllocation* allocation, Dimensions* result) {
	GtkAllocation _tmp0_ = {0};
	gint _tmp1_ = 0;
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	Dimensions _tmp4_ = {0};
#line 55 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (allocation != NULL);
#line 56 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *allocation;
#line 56 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.width;
#line 56 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *allocation;
#line 56 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.height;
#line 56 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp4_, _tmp1_, _tmp3_);
#line 56 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp4_;
#line 56 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 363 "Dimensions.c"
}


void dimensions_for_widget_allocation (GtkWidget* widget, Dimensions* result) {
	GtkAllocation allocation = {0};
	GtkWidget* _tmp0_ = NULL;
	GtkAllocation _tmp1_ = {0};
	GtkAllocation _tmp2_ = {0};
	gint _tmp3_ = 0;
	GtkAllocation _tmp4_ = {0};
	gint _tmp5_ = 0;
	Dimensions _tmp6_ = {0};
#line 59 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (GTK_IS_WIDGET (widget));
#line 61 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = widget;
#line 61 "/home/jens/Source/shotwell/src/Dimensions.vala"
	gtk_widget_get_allocation (_tmp0_, &_tmp1_);
#line 61 "/home/jens/Source/shotwell/src/Dimensions.vala"
	allocation = _tmp1_;
#line 63 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = allocation;
#line 63 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.width;
#line 63 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = allocation;
#line 63 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = _tmp4_.height;
#line 63 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp6_, _tmp3_, _tmp5_);
#line 63 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp6_;
#line 63 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 398 "Dimensions.c"
}


void dimensions_for_rectangle (GdkRectangle* rect, Dimensions* result) {
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	Dimensions _tmp4_ = {0};
#line 66 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (rect != NULL);
#line 67 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *rect;
#line 67 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.width;
#line 67 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *rect;
#line 67 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.height;
#line 67 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp4_, _tmp1_, _tmp3_);
#line 67 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp4_;
#line 67 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 424 "Dimensions.c"
}


gboolean dimensions_has_area (Dimensions *self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
#line 71 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).width;
#line 71 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_ > 0) {
#line 436 "Dimensions.c"
		gint _tmp2_ = 0;
#line 71 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp2_ = (*self).height;
#line 71 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp2_ > 0;
#line 442 "Dimensions.c"
	} else {
#line 71 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = FALSE;
#line 446 "Dimensions.c"
	}
#line 71 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_;
#line 71 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 452 "Dimensions.c"
}


void dimensions_floor (Dimensions *self, Dimensions* min, Dimensions* result) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Dimensions _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	Dimensions _tmp9_ = {0};
	gint _tmp10_ = 0;
	Dimensions _tmp14_ = {0};
#line 74 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (min != NULL);
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).width;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *min;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.width;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_ > _tmp3_) {
#line 476 "Dimensions.c"
		gint _tmp4_ = 0;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp4_ = (*self).width;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp4_;
#line 482 "Dimensions.c"
	} else {
		Dimensions _tmp5_ = {0};
		gint _tmp6_ = 0;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = *min;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = _tmp5_.width;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp6_;
#line 492 "Dimensions.c"
	}
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = (*self).height;
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = *min;
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = _tmp9_.height;
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp8_ > _tmp10_) {
#line 502 "Dimensions.c"
		gint _tmp11_ = 0;
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp11_ = (*self).height;
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = _tmp11_;
#line 508 "Dimensions.c"
	} else {
		Dimensions _tmp12_ = {0};
		gint _tmp13_ = 0;
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp12_ = *min;
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp13_ = _tmp12_.height;
#line 76 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = _tmp13_;
#line 518 "Dimensions.c"
	}
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp14_, _tmp0_, _tmp7_);
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp14_;
#line 75 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 526 "Dimensions.c"
}


gchar* dimensions_to_string (Dimensions *self) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
#line 80 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).width;
#line 80 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).height;
#line 80 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = g_strdup_printf ("%dx%d", _tmp0_, _tmp1_);
#line 80 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp2_;
#line 80 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 545 "Dimensions.c"
}


gboolean dimensions_equals (Dimensions *self, Dimensions* dim) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	Dimensions _tmp2_ = {0};
	gint _tmp3_ = 0;
#line 83 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (dim != NULL, FALSE);
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).width;
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *dim;
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.width;
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_ == _tmp3_) {
#line 565 "Dimensions.c"
		gint _tmp4_ = 0;
		Dimensions _tmp5_ = {0};
		gint _tmp6_ = 0;
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp4_ = (*self).height;
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = *dim;
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = _tmp5_.height;
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp4_ == _tmp6_;
#line 577 "Dimensions.c"
	} else {
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = FALSE;
#line 581 "Dimensions.c"
	}
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_;
#line 84 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 587 "Dimensions.c"
}


gboolean dimensions_approx_equals (Dimensions *self, Dimensions* dim, gint fudge) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	Dimensions _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 88 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (dim != NULL, FALSE);
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).width;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *dim;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.width;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = abs (_tmp1_ - _tmp3_);
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = fudge;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp4_ <= _tmp5_) {
#line 613 "Dimensions.c"
		gint _tmp6_ = 0;
		Dimensions _tmp7_ = {0};
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = (*self).height;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = *dim;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp8_ = _tmp7_.height;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp9_ = abs (_tmp6_ - _tmp8_);
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp10_ = fudge;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp9_ <= _tmp10_;
#line 631 "Dimensions.c"
	} else {
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = FALSE;
#line 635 "Dimensions.c"
	}
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_;
#line 89 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 641 "Dimensions.c"
}


gboolean dimensions_approx_scaled (Dimensions *self, gint scale, gint fudge) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).width;
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = scale;
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = fudge;
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_ <= (_tmp2_ + _tmp3_)) {
#line 659 "Dimensions.c"
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp4_ = (*self).height;
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = scale;
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = fudge;
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp4_ <= (_tmp5_ + _tmp6_);
#line 671 "Dimensions.c"
	} else {
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = FALSE;
#line 675 "Dimensions.c"
	}
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_;
#line 93 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 681 "Dimensions.c"
}


gint dimensions_major_axis (Dimensions *self) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 97 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).width;
#line 97 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).height;
#line 97 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = MAX (_tmp0_, _tmp1_);
#line 97 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp2_;
#line 97 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 700 "Dimensions.c"
}


gint dimensions_minor_axis (Dimensions *self) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 101 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).width;
#line 101 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).height;
#line 101 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = MIN (_tmp0_, _tmp1_);
#line 101 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp2_;
#line 101 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 719 "Dimensions.c"
}


void dimensions_with_min (Dimensions *self, gint min_width, gint min_height, Dimensions* result) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Dimensions _tmp6_ = {0};
#line 105 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).width;
#line 105 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = min_width;
#line 105 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = MAX (_tmp0_, _tmp1_);
#line 105 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = (*self).height;
#line 105 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = min_height;
#line 105 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = MAX (_tmp3_, _tmp4_);
#line 105 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp6_, _tmp2_, _tmp5_);
#line 105 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp6_;
#line 105 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 749 "Dimensions.c"
}


void dimensions_with_max (Dimensions *self, gint max_width, gint max_height, Dimensions* result) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Dimensions _tmp6_ = {0};
#line 109 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).width;
#line 109 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = max_width;
#line 109 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = MIN (_tmp0_, _tmp1_);
#line 109 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = (*self).height;
#line 109 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = max_height;
#line 109 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = MIN (_tmp3_, _tmp4_);
#line 109 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp6_, _tmp2_, _tmp5_);
#line 109 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp6_;
#line 109 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 779 "Dimensions.c"
}


void dimensions_get_scaled (Dimensions *self, gint scale, gboolean scale_up, Dimensions* result) {
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
#line 113 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = scale;
#line 113 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (_tmp0_ > 0, "scale > 0");
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = (*self).width;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = scale;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp3_ == _tmp4_) {
#line 805 "Dimensions.c"
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = (*self).height;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = scale;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp2_ = _tmp5_ < _tmp6_;
#line 814 "Dimensions.c"
	} else {
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp2_ = FALSE;
#line 818 "Dimensions.c"
	}
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp2_) {
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp1_ = TRUE;
#line 824 "Dimensions.c"
	} else {
		gboolean _tmp7_ = FALSE;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp8_ = (*self).height;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp9_ = scale;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (_tmp8_ == _tmp9_) {
#line 835 "Dimensions.c"
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp10_ = (*self).width;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp11_ = scale;
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp7_ = _tmp10_ < _tmp11_;
#line 844 "Dimensions.c"
		} else {
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp7_ = FALSE;
#line 848 "Dimensions.c"
		}
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp1_ = _tmp7_;
#line 852 "Dimensions.c"
	}
#line 116 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_) {
#line 856 "Dimensions.c"
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		Dimensions _tmp14_ = {0};
#line 117 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp12_ = (*self).width;
#line 117 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp13_ = (*self).height;
#line 117 "/home/jens/Source/shotwell/src/Dimensions.vala"
		dimensions_init (&_tmp14_, _tmp12_, _tmp13_);
#line 117 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = _tmp14_;
#line 117 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 870 "Dimensions.c"
	}
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp16_ = scale_up;
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (!_tmp16_) {
#line 876 "Dimensions.c"
		gboolean _tmp17_ = FALSE;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp18_ = (*self).width;
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp19_ = scale;
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (_tmp18_ < _tmp19_) {
#line 886 "Dimensions.c"
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp20_ = (*self).height;
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp21_ = scale;
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp17_ = _tmp20_ < _tmp21_;
#line 895 "Dimensions.c"
		} else {
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp17_ = FALSE;
#line 899 "Dimensions.c"
		}
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp15_ = _tmp17_;
#line 903 "Dimensions.c"
	} else {
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp15_ = FALSE;
#line 907 "Dimensions.c"
	}
#line 120 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp15_) {
#line 911 "Dimensions.c"
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		Dimensions _tmp24_ = {0};
#line 121 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp22_ = (*self).width;
#line 121 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp23_ = (*self).height;
#line 121 "/home/jens/Source/shotwell/src/Dimensions.vala"
		dimensions_init (&_tmp24_, _tmp22_, _tmp23_);
#line 121 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = _tmp24_;
#line 121 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 925 "Dimensions.c"
	}
#line 123 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp25_ = (*self).width;
#line 123 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp26_ = scale;
#line 123 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp27_ = (*self).height;
#line 123 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp28_ = scale;
#line 123 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if ((_tmp25_ - _tmp26_) > (_tmp27_ - _tmp28_)) {
#line 937 "Dimensions.c"
		gint _tmp29_ = 0;
		Dimensions _tmp30_ = {0};
#line 124 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp29_ = scale;
#line 124 "/home/jens/Source/shotwell/src/Dimensions.vala"
		dimensions_get_scaled_by_width (&(*self), _tmp29_, &_tmp30_);
#line 124 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = _tmp30_;
#line 124 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 948 "Dimensions.c"
	} else {
		gint _tmp31_ = 0;
		Dimensions _tmp32_ = {0};
#line 126 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp31_ = scale;
#line 126 "/home/jens/Source/shotwell/src/Dimensions.vala"
		dimensions_get_scaled_by_height (&(*self), _tmp31_, &_tmp32_);
#line 126 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = _tmp32_;
#line 126 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 960 "Dimensions.c"
	}
}


void dimensions_get_scale_ratios (Dimensions *self, Dimensions* scaled, gdouble* width_ratio, gdouble* height_ratio) {
	gdouble _vala_width_ratio = 0.0;
	gdouble _vala_height_ratio = 0.0;
	Dimensions _tmp0_ = {0};
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Dimensions _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 129 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (scaled != NULL);
#line 130 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *scaled;
#line 130 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.width;
#line 130 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = (*self).width;
#line 130 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_width_ratio = ((gdouble) _tmp1_) / ((gdouble) _tmp2_);
#line 131 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = *scaled;
#line 131 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = _tmp3_.height;
#line 131 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = (*self).height;
#line 131 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_height_ratio = ((gdouble) _tmp4_) / ((gdouble) _tmp5_);
#line 129 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (width_ratio) {
#line 129 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*width_ratio = _vala_width_ratio;
#line 996 "Dimensions.c"
	}
#line 129 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (height_ratio) {
#line 129 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*height_ratio = _vala_height_ratio;
#line 1002 "Dimensions.c"
	}
}


gdouble dimensions_get_aspect_ratio (Dimensions *self) {
	gdouble result = 0.0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 135 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).width;
#line 135 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).height;
#line 135 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = ((gdouble) _tmp0_) / _tmp1_;
#line 135 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 1019 "Dimensions.c"
}


void dimensions_get_scaled_proportional (Dimensions *self, Dimensions* viewport, Dimensions* result) {
	gdouble width_ratio = 0.0;
	gdouble height_ratio = 0.0;
	Dimensions _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble scaled_width = 0.0;
	gdouble scaled_height = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	Dimensions scaled = {0};
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	gdouble _tmp16_ = 0.0;
	Dimensions _tmp17_ = {0};
	Dimensions _tmp18_ = {0};
	Dimensions _tmp19_ = {0};
	Dimensions _tmp20_ = {0};
	gint _tmp21_ = 0;
	Dimensions _tmp22_ = {0};
	gint _tmp23_ = 0;
	Dimensions _tmp24_ = {0};
	gint _tmp25_ = 0;
	Dimensions _tmp26_ = {0};
	gint _tmp27_ = 0;
#line 138 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (viewport != NULL);
#line 140 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *viewport;
#line 140 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_get_scale_ratios (&(*self), &_tmp0_, &_tmp1_, &_tmp2_);
#line 140 "/home/jens/Source/shotwell/src/Dimensions.vala"
	width_ratio = _tmp1_;
#line 140 "/home/jens/Source/shotwell/src/Dimensions.vala"
	height_ratio = _tmp2_;
#line 143 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = width_ratio;
#line 143 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = height_ratio;
#line 143 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp3_ < _tmp4_) {
#line 1065 "Dimensions.c"
		Dimensions _tmp5_ = {0};
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gdouble _tmp8_ = 0.0;
#line 144 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = *viewport;
#line 144 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = _tmp5_.width;
#line 144 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaled_width = (gdouble) _tmp6_;
#line 145 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = (*self).height;
#line 145 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp8_ = width_ratio;
#line 145 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaled_height = ((gdouble) _tmp7_) * _tmp8_;
#line 1082 "Dimensions.c"
	} else {
		gint _tmp9_ = 0;
		gdouble _tmp10_ = 0.0;
		Dimensions _tmp11_ = {0};
		gint _tmp12_ = 0;
#line 147 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp9_ = (*self).width;
#line 147 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp10_ = height_ratio;
#line 147 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaled_width = ((gdouble) _tmp9_) * _tmp10_;
#line 148 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp11_ = *viewport;
#line 148 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp12_ = _tmp11_.height;
#line 148 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaled_height = (gdouble) _tmp12_;
#line 1100 "Dimensions.c"
	}
#line 151 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp13_ = scaled_width;
#line 151 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp14_ = round (_tmp13_);
#line 151 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp15_ = scaled_height;
#line 151 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp16_ = round (_tmp15_);
#line 151 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp17_, (gint) _tmp14_, (gint) _tmp16_);
#line 151 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp18_, 1, 1);
#line 151 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_floor (&_tmp17_, &_tmp18_, &_tmp19_);
#line 151 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled = _tmp19_;
#line 153 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp20_ = scaled;
#line 153 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp21_ = _tmp20_.height;
#line 153 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp22_ = *viewport;
#line 153 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp23_ = _tmp22_.height;
#line 153 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (_tmp21_ <= _tmp23_, "scaled.height <= viewport.height");
#line 154 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp24_ = scaled;
#line 154 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp25_ = _tmp24_.width;
#line 154 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp26_ = *viewport;
#line 154 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp27_ = _tmp26_.width;
#line 154 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (_tmp25_ <= _tmp27_, "scaled.width <= viewport.width");
#line 156 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = scaled;
#line 156 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1142 "Dimensions.c"
}


void dimensions_get_scaled_to_fill_viewport (Dimensions *self, Dimensions* viewport, Dimensions* result) {
	gdouble width_ratio = 0.0;
	gdouble height_ratio = 0.0;
	Dimensions _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble scaled_width = 0.0;
	gdouble scaled_height = 0.0;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	Dimensions _tmp5_ = {0};
	gint _tmp6_ = 0;
	gdouble _tmp32_ = 0.0;
	gdouble _tmp33_ = 0.0;
	gdouble _tmp34_ = 0.0;
	gdouble _tmp35_ = 0.0;
	Dimensions _tmp36_ = {0};
	Dimensions _tmp37_ = {0};
	Dimensions _tmp38_ = {0};
#line 159 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (viewport != NULL);
#line 161 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *viewport;
#line 161 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_get_scale_ratios (&(*self), &_tmp0_, &_tmp1_, &_tmp2_);
#line 161 "/home/jens/Source/shotwell/src/Dimensions.vala"
	width_ratio = _tmp1_;
#line 161 "/home/jens/Source/shotwell/src/Dimensions.vala"
	height_ratio = _tmp2_;
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = (*self).width;
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = *viewport;
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = _tmp5_.width;
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp4_ < _tmp6_) {
#line 1183 "Dimensions.c"
		gint _tmp7_ = 0;
		Dimensions _tmp8_ = {0};
		gint _tmp9_ = 0;
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = (*self).height;
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp8_ = *viewport;
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp9_ = _tmp8_.height;
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp3_ = _tmp7_ >= _tmp9_;
#line 1195 "Dimensions.c"
	} else {
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp3_ = FALSE;
#line 1199 "Dimensions.c"
	}
#line 164 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp3_) {
#line 1203 "Dimensions.c"
		Dimensions _tmp10_ = {0};
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gdouble _tmp13_ = 0.0;
#line 166 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp10_ = *viewport;
#line 166 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp11_ = _tmp10_.width;
#line 166 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaled_width = (gdouble) _tmp11_;
#line 167 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp12_ = (*self).height;
#line 167 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp13_ = width_ratio;
#line 167 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaled_height = ((gdouble) _tmp12_) * _tmp13_;
#line 1220 "Dimensions.c"
	} else {
		gboolean _tmp14_ = FALSE;
		gint _tmp15_ = 0;
		Dimensions _tmp16_ = {0};
		gint _tmp17_ = 0;
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp15_ = (*self).width;
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp16_ = *viewport;
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp17_ = _tmp16_.width;
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (_tmp15_ >= _tmp17_) {
#line 1234 "Dimensions.c"
			gint _tmp18_ = 0;
			Dimensions _tmp19_ = {0};
			gint _tmp20_ = 0;
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp18_ = (*self).height;
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp19_ = *viewport;
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp20_ = _tmp19_.height;
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp14_ = _tmp18_ < _tmp20_;
#line 1246 "Dimensions.c"
		} else {
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp14_ = FALSE;
#line 1250 "Dimensions.c"
		}
#line 168 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (_tmp14_) {
#line 1254 "Dimensions.c"
			gint _tmp21_ = 0;
			gdouble _tmp22_ = 0.0;
			Dimensions _tmp23_ = {0};
			gint _tmp24_ = 0;
#line 170 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp21_ = (*self).width;
#line 170 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp22_ = height_ratio;
#line 170 "/home/jens/Source/shotwell/src/Dimensions.vala"
			scaled_width = ((gdouble) _tmp21_) * _tmp22_;
#line 171 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp23_ = *viewport;
#line 171 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp24_ = _tmp23_.height;
#line 171 "/home/jens/Source/shotwell/src/Dimensions.vala"
			scaled_height = (gdouble) _tmp24_;
#line 1271 "Dimensions.c"
		} else {
			gdouble ratio = 0.0;
			gdouble _tmp25_ = 0.0;
			gdouble _tmp26_ = 0.0;
			gdouble _tmp27_ = 0.0;
			gint _tmp28_ = 0;
			gdouble _tmp29_ = 0.0;
			gint _tmp30_ = 0;
			gdouble _tmp31_ = 0.0;
#line 174 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp25_ = width_ratio;
#line 174 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp26_ = height_ratio;
#line 174 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp27_ = MAX (_tmp25_, _tmp26_);
#line 174 "/home/jens/Source/shotwell/src/Dimensions.vala"
			ratio = _tmp27_;
#line 176 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp28_ = (*self).width;
#line 176 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp29_ = ratio;
#line 176 "/home/jens/Source/shotwell/src/Dimensions.vala"
			scaled_width = ((gdouble) _tmp28_) * _tmp29_;
#line 177 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp30_ = (*self).height;
#line 177 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp31_ = ratio;
#line 177 "/home/jens/Source/shotwell/src/Dimensions.vala"
			scaled_height = ((gdouble) _tmp30_) * _tmp31_;
#line 1301 "Dimensions.c"
		}
	}
#line 180 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp32_ = scaled_width;
#line 180 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp33_ = round (_tmp32_);
#line 180 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp34_ = scaled_height;
#line 180 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp35_ = round (_tmp34_);
#line 180 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp36_, (gint) _tmp33_, (gint) _tmp35_);
#line 180 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp37_, 1, 1);
#line 180 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_floor (&_tmp36_, &_tmp37_, &_tmp38_);
#line 180 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp38_;
#line 180 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1322 "Dimensions.c"
}


void dimensions_get_scaled_rectangle (Dimensions *self, Dimensions* scaled, GdkRectangle* rect, GdkRectangle* result) {
	gdouble x_scale = 0.0;
	gdouble y_scale = 0.0;
	Dimensions _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	GdkRectangle scaled_rect = {0};
	GdkRectangle _tmp3_ = {0};
	gint _tmp4_ = 0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	GdkRectangle _tmp7_ = {0};
	gint _tmp8_ = 0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	GdkRectangle _tmp11_ = {0};
	gint _tmp12_ = 0;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	GdkRectangle _tmp15_ = {0};
	gint _tmp16_ = 0;
	gdouble _tmp17_ = 0.0;
	gdouble _tmp18_ = 0.0;
	GdkRectangle _tmp19_ = {0};
	gint _tmp20_ = 0;
	GdkRectangle _tmp21_ = {0};
	gint _tmp22_ = 0;
#line 183 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (scaled != NULL);
#line 183 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (rect != NULL);
#line 185 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *scaled;
#line 185 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_get_scale_ratios (&(*self), &_tmp0_, &_tmp1_, &_tmp2_);
#line 185 "/home/jens/Source/shotwell/src/Dimensions.vala"
	x_scale = _tmp1_;
#line 185 "/home/jens/Source/shotwell/src/Dimensions.vala"
	y_scale = _tmp2_;
#line 187 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (&scaled_rect, 0, sizeof (GdkRectangle));
#line 188 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = *rect;
#line 188 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = _tmp3_.x;
#line 188 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = x_scale;
#line 188 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = round (((gdouble) _tmp4_) * _tmp5_);
#line 188 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled_rect.x = (gint) _tmp6_;
#line 189 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = *rect;
#line 189 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = _tmp7_.y;
#line 189 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = y_scale;
#line 189 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = round (((gdouble) _tmp8_) * _tmp9_);
#line 189 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled_rect.y = (gint) _tmp10_;
#line 190 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp11_ = *rect;
#line 190 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp12_ = _tmp11_.width;
#line 190 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp13_ = x_scale;
#line 190 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp14_ = round (((gdouble) _tmp12_) * _tmp13_);
#line 190 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled_rect.width = (gint) _tmp14_;
#line 191 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp15_ = *rect;
#line 191 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp16_ = _tmp15_.height;
#line 191 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp17_ = y_scale;
#line 191 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp18_ = round (((gdouble) _tmp16_) * _tmp17_);
#line 191 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled_rect.height = (gint) _tmp18_;
#line 193 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp19_ = scaled_rect;
#line 193 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp20_ = _tmp19_.width;
#line 193 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp20_ <= 0) {
#line 194 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaled_rect.width = 1;
#line 1415 "Dimensions.c"
	}
#line 196 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp21_ = scaled_rect;
#line 196 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp22_ = _tmp21_.height;
#line 196 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp22_ <= 0) {
#line 197 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaled_rect.height = 1;
#line 1425 "Dimensions.c"
	}
#line 199 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = scaled_rect;
#line 199 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1431 "Dimensions.c"
}


void dimensions_get_scaled_similar (Dimensions *self, Dimensions* original, Dimensions* scaled, Dimensions* result) {
	gdouble x_scale = 0.0;
	gdouble y_scale = 0.0;
	Dimensions _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble scale = 0.0;
	gdouble _tmp3_ = 0.0;
	gint _tmp4_ = 0;
	gdouble _tmp5_ = 0.0;
	gint _tmp6_ = 0;
	gdouble _tmp7_ = 0.0;
	Dimensions _tmp8_ = {0};
	Dimensions _tmp9_ = {0};
	Dimensions _tmp10_ = {0};
#line 203 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (original != NULL);
#line 203 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (scaled != NULL);
#line 205 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *scaled;
#line 205 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_get_scale_ratios (original, &_tmp0_, &_tmp1_, &_tmp2_);
#line 205 "/home/jens/Source/shotwell/src/Dimensions.vala"
	x_scale = _tmp1_;
#line 205 "/home/jens/Source/shotwell/src/Dimensions.vala"
	y_scale = _tmp2_;
#line 207 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = MIN (x_scale, y_scale);
#line 207 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scale = _tmp3_;
#line 209 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = (*self).width;
#line 209 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = round (((gdouble) _tmp4_) * scale);
#line 209 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = (*self).height;
#line 209 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = round (((gdouble) _tmp6_) * scale);
#line 209 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp8_, (gint) _tmp5_, (gint) _tmp7_);
#line 209 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp9_, 1, 1);
#line 209 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_floor (&_tmp8_, &_tmp9_, &_tmp10_);
#line 209 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp10_;
#line 209 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1484 "Dimensions.c"
}


void dimensions_get_scaled_by_width (Dimensions *self, gint scale, Dimensions* result) {
	gint _tmp0_ = 0;
	gdouble ratio = 0.0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gdouble _tmp5_ = 0.0;
	Dimensions _tmp6_ = {0};
	Dimensions _tmp7_ = {0};
	Dimensions _tmp8_ = {0};
#line 214 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = scale;
#line 214 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (_tmp0_ > 0, "scale > 0");
#line 216 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = scale;
#line 216 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = (*self).width;
#line 216 "/home/jens/Source/shotwell/src/Dimensions.vala"
	ratio = ((gdouble) _tmp1_) / ((gdouble) _tmp2_);
#line 218 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = scale;
#line 218 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = (*self).height;
#line 218 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = round (((gdouble) _tmp4_) * ratio);
#line 218 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp6_, _tmp3_, (gint) _tmp5_);
#line 218 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp7_, 1, 1);
#line 218 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_floor (&_tmp6_, &_tmp7_, &_tmp8_);
#line 218 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp8_;
#line 218 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1525 "Dimensions.c"
}


void dimensions_get_scaled_by_height (Dimensions *self, gint scale, Dimensions* result) {
	gint _tmp0_ = 0;
	gdouble ratio = 0.0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gdouble _tmp4_ = 0.0;
	gint _tmp5_ = 0;
	Dimensions _tmp6_ = {0};
	Dimensions _tmp7_ = {0};
	Dimensions _tmp8_ = {0};
#line 222 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = scale;
#line 222 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (_tmp0_ > 0, "scale > 0");
#line 224 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = scale;
#line 224 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = (*self).height;
#line 224 "/home/jens/Source/shotwell/src/Dimensions.vala"
	ratio = ((gdouble) _tmp1_) / ((gdouble) _tmp2_);
#line 226 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = (*self).width;
#line 226 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = round (((gdouble) _tmp3_) * ratio);
#line 226 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = scale;
#line 226 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp6_, (gint) _tmp4_, _tmp5_);
#line 226 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp7_, 1, 1);
#line 226 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_floor (&_tmp6_, &_tmp7_, &_tmp8_);
#line 226 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp8_;
#line 226 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1566 "Dimensions.c"
}


void dimensions_get_scaled_by_constraint (Dimensions *self, gint scale, ScaleConstraint constraint, Dimensions* result) {
	ScaleConstraint _tmp0_ = 0;
#line 230 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = constraint;
#line 230 "/home/jens/Source/shotwell/src/Dimensions.vala"
	switch (_tmp0_) {
#line 230 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_ORIGINAL:
#line 1578 "Dimensions.c"
		{
			gint _tmp1_ = 0;
			gint _tmp2_ = 0;
			Dimensions _tmp3_ = {0};
#line 232 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp1_ = (*self).width;
#line 232 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp2_ = (*self).height;
#line 232 "/home/jens/Source/shotwell/src/Dimensions.vala"
			dimensions_init (&_tmp3_, _tmp1_, _tmp2_);
#line 232 "/home/jens/Source/shotwell/src/Dimensions.vala"
			*result = _tmp3_;
#line 232 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return;
#line 1593 "Dimensions.c"
		}
#line 230 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_DIMENSIONS:
#line 1597 "Dimensions.c"
		{
			Dimensions _tmp4_ = {0};
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp5_ = (*self).width;
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp6_ = (*self).height;
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (_tmp5_ >= _tmp6_) {
#line 1608 "Dimensions.c"
				gint _tmp7_ = 0;
				Dimensions _tmp8_ = {0};
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp7_ = scale;
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
				dimensions_get_scaled_by_width (&(*self), _tmp7_, &_tmp8_);
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp4_ = _tmp8_;
#line 1617 "Dimensions.c"
			} else {
				gint _tmp9_ = 0;
				Dimensions _tmp10_ = {0};
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp9_ = scale;
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
				dimensions_get_scaled_by_height (&(*self), _tmp9_, &_tmp10_);
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp4_ = _tmp10_;
#line 1627 "Dimensions.c"
			}
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
			*result = _tmp4_;
#line 235 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return;
#line 1633 "Dimensions.c"
		}
#line 230 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_WIDTH:
#line 1637 "Dimensions.c"
		{
			gint _tmp11_ = 0;
			Dimensions _tmp12_ = {0};
#line 238 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp11_ = scale;
#line 238 "/home/jens/Source/shotwell/src/Dimensions.vala"
			dimensions_get_scaled_by_width (&(*self), _tmp11_, &_tmp12_);
#line 238 "/home/jens/Source/shotwell/src/Dimensions.vala"
			*result = _tmp12_;
#line 238 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return;
#line 1649 "Dimensions.c"
		}
#line 230 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_HEIGHT:
#line 1653 "Dimensions.c"
		{
			gint _tmp13_ = 0;
			Dimensions _tmp14_ = {0};
#line 241 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp13_ = scale;
#line 241 "/home/jens/Source/shotwell/src/Dimensions.vala"
			dimensions_get_scaled_by_height (&(*self), _tmp13_, &_tmp14_);
#line 241 "/home/jens/Source/shotwell/src/Dimensions.vala"
			*result = _tmp14_;
#line 241 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return;
#line 1665 "Dimensions.c"
		}
		default:
		{
			ScaleConstraint _tmp15_ = 0;
#line 244 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp15_ = constraint;
#line 244 "/home/jens/Source/shotwell/src/Dimensions.vala"
			g_error ("Dimensions.vala:244: Bad constraint: %d", (gint) _tmp15_);
#line 1674 "Dimensions.c"
		}
	}
}


Dimensions* dimensions_dup (const Dimensions* self) {
	Dimensions* dup;
#line 39 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dup = g_new0 (Dimensions, 1);
#line 39 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memcpy (dup, self, sizeof (Dimensions));
#line 39 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return dup;
#line 1688 "Dimensions.c"
}


void dimensions_free (Dimensions* self) {
#line 39 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_free (self);
#line 1695 "Dimensions.c"
}


GType dimensions_get_type (void) {
	static volatile gsize dimensions_type_id__volatile = 0;
	if (g_once_init_enter (&dimensions_type_id__volatile)) {
		GType dimensions_type_id;
		dimensions_type_id = g_boxed_type_register_static ("Dimensions", (GBoxedCopyFunc) dimensions_dup, (GBoxedFreeFunc) dimensions_free);
		g_once_init_leave (&dimensions_type_id__volatile, dimensions_type_id);
	}
	return dimensions_type_id__volatile;
}


static void scaling_init (Scaling *self, ScaleConstraint constraint, gint scale, Dimensions* viewport, gboolean scale_up) {
	ScaleConstraint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Dimensions _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
#line 257 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (viewport != NULL);
#line 257 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (self, 0, sizeof (Scaling));
#line 258 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = constraint;
#line 258 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).constraint = _tmp0_;
#line 259 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = scale;
#line 259 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).scale = _tmp1_;
#line 260 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *viewport;
#line 260 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport = _tmp2_;
#line 261 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = scale_up;
#line 261 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).scale_up = _tmp3_;
#line 1735 "Dimensions.c"
}


void scaling_for_original (Scaling* result) {
	Dimensions _tmp0_ = {0};
	Scaling _tmp1_ = {0};
#line 265 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp0_, 0, 0);
#line 265 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_init (&_tmp1_, SCALE_CONSTRAINT_ORIGINAL, SCALING_NO_SCALE, &_tmp0_, FALSE);
#line 265 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp1_;
#line 265 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1750 "Dimensions.c"
}


void scaling_for_screen (GtkWindow* window, gboolean scale_up, Scaling* result) {
	GtkWindow* _tmp0_ = NULL;
	Dimensions _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	Scaling _tmp3_ = {0};
#line 268 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (GTK_IS_WINDOW (window));
#line 269 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = window;
#line 269 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_get_screen_dimensions (_tmp0_, &_tmp1_);
#line 269 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = scale_up;
#line 269 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_for_viewport (&_tmp1_, _tmp2_, &_tmp3_);
#line 269 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp3_;
#line 269 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1773 "Dimensions.c"
}


void scaling_for_best_fit (gint pixels, gboolean scale_up, Scaling* result) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Dimensions _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	Scaling _tmp4_ = {0};
#line 273 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = pixels;
#line 273 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (_tmp0_ > 0, "pixels > 0");
#line 275 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = pixels;
#line 275 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp2_, 0, 0);
#line 275 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = scale_up;
#line 275 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_init (&_tmp4_, SCALE_CONSTRAINT_DIMENSIONS, _tmp1_, &_tmp2_, _tmp3_);
#line 275 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp4_;
#line 275 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1799 "Dimensions.c"
}


void scaling_for_viewport (Dimensions* viewport, gboolean scale_up, Scaling* result) {
	gboolean _tmp0_ = FALSE;
	Dimensions _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	Scaling _tmp3_ = {0};
#line 278 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (viewport != NULL);
#line 279 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = dimensions_has_area (viewport);
#line 279 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (_tmp0_, "viewport.has_area()");
#line 281 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = *viewport;
#line 281 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = scale_up;
#line 281 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_init (&_tmp3_, SCALE_CONSTRAINT_DIMENSIONS, SCALING_NO_SCALE, &_tmp1_, _tmp2_);
#line 281 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp3_;
#line 281 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1824 "Dimensions.c"
}


void scaling_for_widget (GtkWidget* widget, gboolean scale_up, Scaling* result) {
	Dimensions viewport = {0};
	GtkWidget* _tmp0_ = NULL;
	Dimensions _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	Dimensions _tmp3_ = {0};
	gint _tmp4_ = 0;
	Dimensions _tmp8_ = {0};
	gboolean _tmp9_ = FALSE;
	Scaling _tmp10_ = {0};
#line 284 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (GTK_IS_WIDGET (widget));
#line 285 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = widget;
#line 285 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_for_widget_allocation (_tmp0_, &_tmp1_);
#line 285 "/home/jens/Source/shotwell/src/Dimensions.vala"
	viewport = _tmp1_;
#line 295 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = viewport;
#line 295 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = _tmp3_.width;
#line 295 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp4_ <= 1) {
#line 295 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp2_ = TRUE;
#line 1854 "Dimensions.c"
	} else {
		Dimensions _tmp5_ = {0};
		gint _tmp6_ = 0;
#line 295 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = viewport;
#line 295 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = _tmp5_.height;
#line 295 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp2_ = _tmp6_ <= 1;
#line 1864 "Dimensions.c"
	}
#line 295 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp2_) {
#line 1868 "Dimensions.c"
		Scaling _tmp7_ = {0};
#line 296 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaling_for_original (&_tmp7_);
#line 296 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = _tmp7_;
#line 296 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 1876 "Dimensions.c"
	}
#line 298 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = viewport;
#line 298 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = scale_up;
#line 298 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_init (&_tmp10_, SCALE_CONSTRAINT_DIMENSIONS, SCALING_NO_SCALE, &_tmp8_, _tmp9_);
#line 298 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp10_;
#line 298 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1888 "Dimensions.c"
}


void scaling_to_fill_viewport (Dimensions* viewport, Scaling* result) {
	gboolean _tmp0_ = FALSE;
	Dimensions _tmp1_ = {0};
	gint _tmp2_ = 0;
	Dimensions _tmp6_ = {0};
	Scaling _tmp7_ = {0};
#line 301 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (viewport != NULL);
#line 304 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = *viewport;
#line 304 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = _tmp1_.width;
#line 304 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp2_ <= 1) {
#line 304 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = TRUE;
#line 1908 "Dimensions.c"
	} else {
		Dimensions _tmp3_ = {0};
		gint _tmp4_ = 0;
#line 304 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp3_ = *viewport;
#line 304 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp4_ = _tmp3_.height;
#line 304 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp4_ <= 1;
#line 1918 "Dimensions.c"
	}
#line 304 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp0_) {
#line 1922 "Dimensions.c"
		Scaling _tmp5_ = {0};
#line 305 "/home/jens/Source/shotwell/src/Dimensions.vala"
		scaling_for_original (&_tmp5_);
#line 305 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = _tmp5_;
#line 305 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 1930 "Dimensions.c"
	}
#line 307 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = *viewport;
#line 307 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_init (&_tmp7_, SCALE_CONSTRAINT_FILL_VIEWPORT, SCALING_NO_SCALE, &_tmp6_, TRUE);
#line 307 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp7_;
#line 307 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1940 "Dimensions.c"
}


void scaling_to_fill_screen (GtkWindow* window, Scaling* result) {
	GtkWindow* _tmp0_ = NULL;
	Dimensions _tmp1_ = {0};
	Scaling _tmp2_ = {0};
#line 310 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (GTK_IS_WINDOW (window));
#line 311 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = window;
#line 311 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_get_screen_dimensions (_tmp0_, &_tmp1_);
#line 311 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_to_fill_viewport (&_tmp1_, &_tmp2_);
#line 311 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp2_;
#line 311 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1960 "Dimensions.c"
}


void scaling_for_constraint (ScaleConstraint constraint, gint scale, gboolean scale_up, Scaling* result) {
	ScaleConstraint _tmp0_ = 0;
	gint _tmp1_ = 0;
	Dimensions _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	Scaling _tmp4_ = {0};
#line 315 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = constraint;
#line 315 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = scale;
#line 315 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp2_, 0, 0);
#line 315 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = scale_up;
#line 315 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaling_init (&_tmp4_, _tmp0_, _tmp1_, &_tmp2_, _tmp3_);
#line 315 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp4_;
#line 315 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 1984 "Dimensions.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 319 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return self ? g_object_ref (self) : NULL;
#line 1991 "Dimensions.c"
}


static void scaling_get_screen_dimensions (GtkWindow* window, Dimensions* result) {
	GdkScreen* screen = NULL;
	GtkWindow* _tmp0_ = NULL;
	GdkScreen* _tmp1_ = NULL;
	GdkScreen* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	Dimensions _tmp5_ = {0};
#line 318 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (GTK_IS_WINDOW (window));
#line 319 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = window;
#line 319 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = gtk_window_get_screen (_tmp0_);
#line 319 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 319 "/home/jens/Source/shotwell/src/Dimensions.vala"
	screen = _tmp2_;
#line 321 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = gdk_screen_get_width (screen);
#line 321 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = gdk_screen_get_height (screen);
#line 321 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_tmp5_, _tmp3_, _tmp4_);
#line 321 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp5_;
#line 321 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_g_object_unref0 (screen);
#line 321 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 2025 "Dimensions.c"
}


static gint scaling_scale_to_pixels (Scaling *self) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 325 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).scale;
#line 325 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_ >= 0) {
#line 2037 "Dimensions.c"
		gint _tmp2_ = 0;
#line 325 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp2_ = (*self).scale;
#line 325 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp2_;
#line 2043 "Dimensions.c"
	} else {
#line 325 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = 0;
#line 2047 "Dimensions.c"
	}
#line 325 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_;
#line 325 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 2053 "Dimensions.c"
}


gboolean scaling_is_unscaled (Scaling *self) {
	gboolean result = FALSE;
	ScaleConstraint _tmp0_ = 0;
#line 329 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).constraint;
#line 329 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_ == SCALE_CONSTRAINT_ORIGINAL;
#line 329 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 2066 "Dimensions.c"
}


gboolean scaling_is_best_fit (Scaling *self, Dimensions* original, gint* pixels) {
	gint _vala_pixels = 0;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	ScaleConstraint _tmp1_ = 0;
#line 332 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (original != NULL, FALSE);
#line 333 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_pixels = 0;
#line 335 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).scale;
#line 335 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp0_ == SCALING_NO_SCALE) {
#line 336 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 336 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (pixels) {
#line 336 "/home/jens/Source/shotwell/src/Dimensions.vala"
			*pixels = _vala_pixels;
#line 2089 "Dimensions.c"
		}
#line 336 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 2093 "Dimensions.c"
	}
#line 338 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).constraint;
#line 338 "/home/jens/Source/shotwell/src/Dimensions.vala"
	switch (_tmp1_) {
#line 338 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_ORIGINAL:
#line 338 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_FILL_VIEWPORT:
#line 2103 "Dimensions.c"
		{
#line 341 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = FALSE;
#line 341 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (pixels) {
#line 341 "/home/jens/Source/shotwell/src/Dimensions.vala"
				*pixels = _vala_pixels;
#line 2111 "Dimensions.c"
			}
#line 341 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 2115 "Dimensions.c"
		}
		default:
		{
			gint _tmp2_ = 0;
			gint _tmp3_ = 0;
#line 344 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp2_ = scaling_scale_to_pixels (&(*self));
#line 344 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_vala_pixels = _tmp2_;
#line 345 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp3_ = _vala_pixels;
#line 345 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_vala_assert (_tmp3_ > 0, "pixels > 0");
#line 347 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = TRUE;
#line 347 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (pixels) {
#line 347 "/home/jens/Source/shotwell/src/Dimensions.vala"
				*pixels = _vala_pixels;
#line 2135 "Dimensions.c"
			}
#line 347 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 2139 "Dimensions.c"
		}
	}
#line 332 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (pixels) {
#line 332 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*pixels = _vala_pixels;
#line 2146 "Dimensions.c"
	}
}


gboolean scaling_is_best_fit_dimensions (Scaling *self, Dimensions* original, Dimensions* scaled) {
	Dimensions _vala_scaled = {0};
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	ScaleConstraint _tmp1_ = 0;
#line 351 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (original != NULL, FALSE);
#line 352 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_vala_scaled, 0, 0);
#line 354 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).scale;
#line 354 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp0_ == SCALING_NO_SCALE) {
#line 355 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 355 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (scaled) {
#line 355 "/home/jens/Source/shotwell/src/Dimensions.vala"
			*scaled = _vala_scaled;
#line 2170 "Dimensions.c"
		}
#line 355 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 2174 "Dimensions.c"
	}
#line 357 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).constraint;
#line 357 "/home/jens/Source/shotwell/src/Dimensions.vala"
	switch (_tmp1_) {
#line 357 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_ORIGINAL:
#line 357 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_FILL_VIEWPORT:
#line 2184 "Dimensions.c"
		{
#line 360 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = FALSE;
#line 360 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (scaled) {
#line 360 "/home/jens/Source/shotwell/src/Dimensions.vala"
				*scaled = _vala_scaled;
#line 2192 "Dimensions.c"
			}
#line 360 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 2196 "Dimensions.c"
		}
		default:
		{
			gint pixels = 0;
			gint _tmp2_ = 0;
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
			ScaleConstraint _tmp5_ = 0;
			Dimensions _tmp6_ = {0};
#line 363 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp2_ = scaling_scale_to_pixels (&(*self));
#line 363 "/home/jens/Source/shotwell/src/Dimensions.vala"
			pixels = _tmp2_;
#line 364 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp3_ = pixels;
#line 364 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_vala_assert (_tmp3_ > 0, "pixels > 0");
#line 366 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp4_ = pixels;
#line 366 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp5_ = (*self).constraint;
#line 366 "/home/jens/Source/shotwell/src/Dimensions.vala"
			dimensions_get_scaled_by_constraint (original, _tmp4_, _tmp5_, &_tmp6_);
#line 366 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_vala_scaled = _tmp6_;
#line 368 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = TRUE;
#line 368 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (scaled) {
#line 368 "/home/jens/Source/shotwell/src/Dimensions.vala"
				*scaled = _vala_scaled;
#line 2228 "Dimensions.c"
			}
#line 368 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 2232 "Dimensions.c"
		}
	}
#line 351 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (scaled) {
#line 351 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*scaled = _vala_scaled;
#line 2239 "Dimensions.c"
	}
}


gboolean scaling_is_for_viewport (Scaling *self, Dimensions* original, Dimensions* scaled) {
	Dimensions _vala_scaled = {0};
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	ScaleConstraint _tmp1_ = 0;
#line 372 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (original != NULL, FALSE);
#line 373 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_vala_scaled, 0, 0);
#line 375 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).scale;
#line 375 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp0_ != SCALING_NO_SCALE) {
#line 376 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 376 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (scaled) {
#line 376 "/home/jens/Source/shotwell/src/Dimensions.vala"
			*scaled = _vala_scaled;
#line 2263 "Dimensions.c"
		}
#line 376 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 2267 "Dimensions.c"
	}
#line 378 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).constraint;
#line 378 "/home/jens/Source/shotwell/src/Dimensions.vala"
	switch (_tmp1_) {
#line 378 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_ORIGINAL:
#line 378 "/home/jens/Source/shotwell/src/Dimensions.vala"
		case SCALE_CONSTRAINT_FILL_VIEWPORT:
#line 2277 "Dimensions.c"
		{
#line 381 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = FALSE;
#line 381 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (scaled) {
#line 381 "/home/jens/Source/shotwell/src/Dimensions.vala"
				*scaled = _vala_scaled;
#line 2285 "Dimensions.c"
			}
#line 381 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 2289 "Dimensions.c"
		}
		default:
		{
			gboolean _tmp2_ = FALSE;
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
#line 384 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp2_ = dimensions_has_area (&(*self).viewport);
#line 384 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_vala_assert (_tmp2_, "viewport.has_area()");
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp5_ = (*self).scale_up;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (!_tmp5_) {
#line 2305 "Dimensions.c"
				Dimensions _tmp6_ = {0};
				gint _tmp7_ = 0;
				Dimensions _tmp8_ = {0};
				gint _tmp9_ = 0;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp6_ = *original;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp7_ = _tmp6_.width;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp8_ = (*self).viewport;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp9_ = _tmp8_.width;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp4_ = _tmp7_ < _tmp9_;
#line 2320 "Dimensions.c"
			} else {
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp4_ = FALSE;
#line 2324 "Dimensions.c"
			}
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (_tmp4_) {
#line 2328 "Dimensions.c"
				Dimensions _tmp10_ = {0};
				gint _tmp11_ = 0;
				Dimensions _tmp12_ = {0};
				gint _tmp13_ = 0;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp10_ = *original;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp11_ = _tmp10_.height;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp12_ = (*self).viewport;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp13_ = _tmp12_.height;
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp3_ = _tmp11_ < _tmp13_;
#line 2343 "Dimensions.c"
			} else {
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp3_ = FALSE;
#line 2347 "Dimensions.c"
			}
#line 386 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (_tmp3_) {
#line 2351 "Dimensions.c"
				Dimensions _tmp14_ = {0};
#line 387 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp14_ = *original;
#line 387 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_vala_scaled = _tmp14_;
#line 2357 "Dimensions.c"
			} else {
				Dimensions _tmp15_ = {0};
				Dimensions _tmp16_ = {0};
#line 389 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp15_ = (*self).viewport;
#line 389 "/home/jens/Source/shotwell/src/Dimensions.vala"
				dimensions_get_scaled_proportional (original, &_tmp15_, &_tmp16_);
#line 389 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_vala_scaled = _tmp16_;
#line 2367 "Dimensions.c"
			}
#line 391 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = TRUE;
#line 391 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (scaled) {
#line 391 "/home/jens/Source/shotwell/src/Dimensions.vala"
				*scaled = _vala_scaled;
#line 2375 "Dimensions.c"
			}
#line 391 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 2379 "Dimensions.c"
		}
	}
#line 372 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (scaled) {
#line 372 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*scaled = _vala_scaled;
#line 2386 "Dimensions.c"
	}
}


gboolean scaling_is_fill_viewport (Scaling *self, Dimensions* original, Dimensions* scaled) {
	Dimensions _vala_scaled = {0};
	gboolean result = FALSE;
	ScaleConstraint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	Dimensions _tmp2_ = {0};
	Dimensions _tmp3_ = {0};
#line 395 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (original != NULL, FALSE);
#line 396 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_init (&_vala_scaled, 0, 0);
#line 398 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).constraint;
#line 398 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp0_ != SCALE_CONSTRAINT_FILL_VIEWPORT) {
#line 399 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 399 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (scaled) {
#line 399 "/home/jens/Source/shotwell/src/Dimensions.vala"
			*scaled = _vala_scaled;
#line 2412 "Dimensions.c"
		}
#line 399 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 2416 "Dimensions.c"
	}
#line 401 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = dimensions_has_area (&(*self).viewport);
#line 401 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (_tmp1_, "viewport.has_area()");
#line 402 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = (*self).viewport;
#line 402 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_get_scaled_to_fill_viewport (original, &_tmp2_, &_tmp3_);
#line 402 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_scaled = _tmp3_;
#line 404 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = TRUE;
#line 404 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (scaled) {
#line 404 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*scaled = _vala_scaled;
#line 2434 "Dimensions.c"
	}
#line 404 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 2438 "Dimensions.c"
}


void scaling_get_scaled_dimensions (Scaling *self, Dimensions* original, Dimensions* result) {
	gboolean _tmp0_ = FALSE;
	Dimensions scaled = {0};
	Dimensions _tmp2_ = {0};
	Dimensions _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	Dimensions _tmp5_ = {0};
	Dimensions _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	gboolean is_viewport = FALSE;
	Dimensions _tmp8_ = {0};
	Dimensions _tmp9_ = {0};
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
#line 407 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (original != NULL);
#line 408 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = scaling_is_unscaled (&(*self));
#line 408 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp0_) {
#line 2462 "Dimensions.c"
		Dimensions _tmp1_ = {0};
#line 409 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp1_ = *original;
#line 409 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = _tmp1_;
#line 409 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 2470 "Dimensions.c"
	}
#line 412 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *original;
#line 412 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = scaling_is_fill_viewport (&(*self), &_tmp2_, &_tmp3_);
#line 412 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled = _tmp3_;
#line 412 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp4_) {
#line 413 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = scaled;
#line 413 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 2484 "Dimensions.c"
	}
#line 415 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = *original;
#line 415 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = scaling_is_best_fit_dimensions (&(*self), &_tmp5_, &_tmp6_);
#line 415 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled = _tmp6_;
#line 415 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp7_) {
#line 416 "/home/jens/Source/shotwell/src/Dimensions.vala"
		*result = scaled;
#line 416 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return;
#line 2498 "Dimensions.c"
	}
#line 418 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = *original;
#line 418 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = scaling_is_for_viewport (&(*self), &_tmp8_, &_tmp9_);
#line 418 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled = _tmp9_;
#line 418 "/home/jens/Source/shotwell/src/Dimensions.vala"
	is_viewport = _tmp10_;
#line 419 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp11_ = is_viewport;
#line 419 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (_tmp11_, "is_viewport");
#line 421 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = scaled;
#line 421 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 2516 "Dimensions.c"
}


GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self, GdkPixbuf* pixbuf, GdkInterpType interp, gboolean scale_up) {
	GdkPixbuf* result = NULL;
	gboolean _tmp0_ = FALSE;
	Dimensions pixbuf_dim = {0};
	GdkPixbuf* _tmp3_ = NULL;
	Dimensions _tmp4_ = {0};
	gint pixels = 0;
	Dimensions _tmp5_ = {0};
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	Dimensions scaled = {0};
	Dimensions _tmp13_ = {0};
	Dimensions _tmp14_ = {0};
	gboolean _tmp15_ = FALSE;
	gboolean is_viewport = FALSE;
	Dimensions _tmp20_ = {0};
	Dimensions _tmp21_ = {0};
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	GdkPixbuf* _tmp24_ = NULL;
	Dimensions _tmp25_ = {0};
	GdkInterpType _tmp26_ = 0;
	GdkPixbuf* _tmp27_ = NULL;
#line 424 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (GDK_IS_PIXBUF (pixbuf), NULL);
#line 425 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = scaling_is_unscaled (&(*self));
#line 425 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp0_) {
#line 2549 "Dimensions.c"
		GdkPixbuf* _tmp1_ = NULL;
		GdkPixbuf* _tmp2_ = NULL;
#line 426 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp1_ = pixbuf;
#line 426 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 426 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = _tmp2_;
#line 426 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 2560 "Dimensions.c"
	}
#line 428 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = pixbuf;
#line 428 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_for_pixbuf (_tmp3_, &_tmp4_);
#line 428 "/home/jens/Source/shotwell/src/Dimensions.vala"
	pixbuf_dim = _tmp4_;
#line 431 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = pixbuf_dim;
#line 431 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = scaling_is_best_fit (&(*self), &_tmp5_, &_tmp6_);
#line 431 "/home/jens/Source/shotwell/src/Dimensions.vala"
	pixels = _tmp6_;
#line 431 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp7_) {
#line 2576 "Dimensions.c"
		GdkPixbuf* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		GdkInterpType _tmp10_ = 0;
		gboolean _tmp11_ = FALSE;
		GdkPixbuf* _tmp12_ = NULL;
#line 432 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp8_ = pixbuf;
#line 432 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp9_ = pixels;
#line 432 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp10_ = interp;
#line 432 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp11_ = scale_up;
#line 432 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp12_ = scale_pixbuf (_tmp8_, _tmp9_, _tmp10_, _tmp11_);
#line 432 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = _tmp12_;
#line 432 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 2596 "Dimensions.c"
	}
#line 435 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp13_ = pixbuf_dim;
#line 435 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp15_ = scaling_is_fill_viewport (&(*self), &_tmp13_, &_tmp14_);
#line 435 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled = _tmp14_;
#line 435 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp15_) {
#line 2606 "Dimensions.c"
		GdkPixbuf* _tmp16_ = NULL;
		Dimensions _tmp17_ = {0};
		GdkInterpType _tmp18_ = 0;
		GdkPixbuf* _tmp19_ = NULL;
#line 436 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp16_ = pixbuf;
#line 436 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp17_ = scaled;
#line 436 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp18_ = interp;
#line 436 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp19_ = resize_pixbuf (_tmp16_, &_tmp17_, _tmp18_);
#line 436 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = _tmp19_;
#line 436 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 2623 "Dimensions.c"
	}
#line 438 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp20_ = pixbuf_dim;
#line 438 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp22_ = scaling_is_for_viewport (&(*self), &_tmp20_, &_tmp21_);
#line 438 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scaled = _tmp21_;
#line 438 "/home/jens/Source/shotwell/src/Dimensions.vala"
	is_viewport = _tmp22_;
#line 439 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp23_ = is_viewport;
#line 439 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_vala_assert (_tmp23_, "is_viewport");
#line 441 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp24_ = pixbuf;
#line 441 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp25_ = scaled;
#line 441 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp26_ = interp;
#line 441 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp27_ = resize_pixbuf (_tmp24_, &_tmp25_, _tmp26_);
#line 441 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp27_;
#line 441 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 2649 "Dimensions.c"
}


gchar* scaling_to_string (Scaling *self) {
	gchar* result = NULL;
	ScaleConstraint _tmp0_ = 0;
#line 445 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).constraint;
#line 445 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp0_ == SCALE_CONSTRAINT_ORIGINAL) {
#line 2660 "Dimensions.c"
		gchar* _tmp1_ = NULL;
#line 446 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp1_ = g_strdup ("scaling: UNSCALED");
#line 446 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = _tmp1_;
#line 446 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 2668 "Dimensions.c"
	} else {
		ScaleConstraint _tmp2_ = 0;
#line 447 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp2_ = (*self).constraint;
#line 447 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (_tmp2_ == SCALE_CONSTRAINT_FILL_VIEWPORT) {
#line 2675 "Dimensions.c"
			gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_ = NULL;
#line 448 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp3_ = dimensions_to_string (&(*self).viewport);
#line 448 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp4_ = _tmp3_;
#line 448 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp5_ = g_strdup_printf ("scaling: fill viewport %s", _tmp4_);
#line 448 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp6_ = _tmp5_;
#line 448 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_g_free0 (_tmp4_);
#line 448 "/home/jens/Source/shotwell/src/Dimensions.vala"
			result = _tmp6_;
#line 448 "/home/jens/Source/shotwell/src/Dimensions.vala"
			return result;
#line 2694 "Dimensions.c"
		} else {
			gint _tmp7_ = 0;
#line 449 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp7_ = (*self).scale;
#line 449 "/home/jens/Source/shotwell/src/Dimensions.vala"
			if (_tmp7_ != SCALING_NO_SCALE) {
#line 2701 "Dimensions.c"
				const gchar* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
				ScaleConstraint _tmp10_ = 0;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
#line 451 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp9_ = (*self).scale_up;
#line 451 "/home/jens/Source/shotwell/src/Dimensions.vala"
				if (_tmp9_) {
#line 451 "/home/jens/Source/shotwell/src/Dimensions.vala"
					_tmp8_ = "scaled up";
#line 2716 "Dimensions.c"
				} else {
#line 451 "/home/jens/Source/shotwell/src/Dimensions.vala"
					_tmp8_ = "not scaled up";
#line 2720 "Dimensions.c"
				}
#line 450 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp10_ = (*self).constraint;
#line 450 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp11_ = scale_constraint_to_string (_tmp10_);
#line 450 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp12_ = _tmp11_;
#line 450 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp13_ = scaling_scale_to_pixels (&(*self));
#line 450 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp14_ = g_strdup_printf ("scaling: best-fit (%s %d pixels %s)", _tmp12_, _tmp13_, _tmp8_);
#line 450 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp15_ = _tmp14_;
#line 450 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_g_free0 (_tmp12_);
#line 450 "/home/jens/Source/shotwell/src/Dimensions.vala"
				result = _tmp15_;
#line 450 "/home/jens/Source/shotwell/src/Dimensions.vala"
				return result;
#line 2740 "Dimensions.c"
			} else {
				const gchar* _tmp16_ = NULL;
				gboolean _tmp17_ = FALSE;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
#line 454 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp17_ = (*self).scale_up;
#line 454 "/home/jens/Source/shotwell/src/Dimensions.vala"
				if (_tmp17_) {
#line 454 "/home/jens/Source/shotwell/src/Dimensions.vala"
					_tmp16_ = "scaled up";
#line 2754 "Dimensions.c"
				} else {
#line 454 "/home/jens/Source/shotwell/src/Dimensions.vala"
					_tmp16_ = "not scaled up";
#line 2758 "Dimensions.c"
				}
#line 453 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp18_ = dimensions_to_string (&(*self).viewport);
#line 453 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp19_ = _tmp18_;
#line 453 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp20_ = g_strdup_printf ("scaling: viewport %s (%s)", _tmp19_, _tmp16_);
#line 453 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_tmp21_ = _tmp20_;
#line 453 "/home/jens/Source/shotwell/src/Dimensions.vala"
				_g_free0 (_tmp19_);
#line 453 "/home/jens/Source/shotwell/src/Dimensions.vala"
				result = _tmp21_;
#line 453 "/home/jens/Source/shotwell/src/Dimensions.vala"
				return result;
#line 2774 "Dimensions.c"
			}
		}
	}
}


gboolean scaling_equals (Scaling *self, Scaling* scaling) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ScaleConstraint _tmp2_ = 0;
	Scaling _tmp3_ = {0};
	ScaleConstraint _tmp4_ = 0;
#line 457 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (scaling != NULL, FALSE);
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = (*self).constraint;
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = *scaling;
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = _tmp3_.constraint;
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp2_ == _tmp4_) {
#line 2798 "Dimensions.c"
		gint _tmp5_ = 0;
		Scaling _tmp6_ = {0};
		gint _tmp7_ = 0;
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = (*self).scale;
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = *scaling;
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = _tmp6_.scale;
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp1_ = _tmp5_ == _tmp7_;
#line 2810 "Dimensions.c"
	} else {
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp1_ = FALSE;
#line 2814 "Dimensions.c"
	}
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_) {
#line 2818 "Dimensions.c"
		Scaling _tmp8_ = {0};
		Dimensions _tmp9_ = {0};
		gboolean _tmp10_ = FALSE;
#line 459 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp8_ = *scaling;
#line 459 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp9_ = _tmp8_.viewport;
#line 459 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp10_ = dimensions_equals (&(*self).viewport, &_tmp9_);
#line 459 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = _tmp10_;
#line 2830 "Dimensions.c"
	} else {
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp0_ = FALSE;
#line 2834 "Dimensions.c"
	}
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_;
#line 458 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 2840 "Dimensions.c"
}


Scaling* scaling_dup (const Scaling* self) {
	Scaling* dup;
#line 249 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dup = g_new0 (Scaling, 1);
#line 249 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memcpy (dup, self, sizeof (Scaling));
#line 249 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return dup;
#line 2852 "Dimensions.c"
}


void scaling_free (Scaling* self) {
#line 249 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_free (self);
#line 2859 "Dimensions.c"
}


GType scaling_get_type (void) {
	static volatile gsize scaling_type_id__volatile = 0;
	if (g_once_init_enter (&scaling_type_id__volatile)) {
		GType scaling_type_id;
		scaling_type_id = g_boxed_type_register_static ("Scaling", (GBoxedCopyFunc) scaling_dup, (GBoxedFreeFunc) scaling_free);
		g_once_init_leave (&scaling_type_id__volatile, scaling_type_id);
	}
	return scaling_type_id__volatile;
}


void zoom_state_init (ZoomState *self, Dimensions* content_dimensions, Dimensions* viewport_dimensions, gdouble slider_val, GdkPoint* viewport_center) {
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	gdouble _tmp2_ = 0.0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GdkPoint* _tmp5_ = NULL;
#line 472 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (content_dimensions != NULL);
#line 472 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (viewport_dimensions != NULL);
#line 472 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (self, 0, sizeof (ZoomState));
#line 474 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *content_dimensions;
#line 474 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).content_dimensions = _tmp0_;
#line 475 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = *viewport_dimensions;
#line 475 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_dimensions = _tmp1_;
#line 476 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = slider_val;
#line 476 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).interpolation_factor = _tmp2_;
#line 478 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoom_state_compute_zoom_factors (&(*self));
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = viewport_center;
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp5_ == NULL) {
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp4_ = TRUE;
#line 2907 "Dimensions.c"
	} else {
		gboolean _tmp6_ = FALSE;
		GdkPoint* _tmp7_ = NULL;
		gint _tmp8_ = 0;
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = viewport_center;
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp8_ = (*_tmp7_).x;
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (_tmp8_ == 0) {
#line 2918 "Dimensions.c"
			GdkPoint* _tmp9_ = NULL;
			gint _tmp10_ = 0;
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp9_ = viewport_center;
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp10_ = (*_tmp9_).y;
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp6_ = _tmp10_ == 0;
#line 2927 "Dimensions.c"
		} else {
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp6_ = FALSE;
#line 2931 "Dimensions.c"
		}
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp4_ = _tmp6_;
#line 2935 "Dimensions.c"
	}
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp4_) {
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp3_ = TRUE;
#line 2941 "Dimensions.c"
	} else {
		gdouble _tmp11_ = 0.0;
#line 481 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp11_ = slider_val;
#line 481 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp3_ = _tmp11_ == 0.0;
#line 2948 "Dimensions.c"
	}
#line 480 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp3_) {
#line 482 "/home/jens/Source/shotwell/src/Dimensions.vala"
		zoom_state_center_viewport (&(*self));
#line 2954 "Dimensions.c"
	} else {
		GdkPoint* _tmp12_ = NULL;
#line 484 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp12_ = viewport_center;
#line 484 "/home/jens/Source/shotwell/src/Dimensions.vala"
		(*self).viewport_center = *_tmp12_;
#line 485 "/home/jens/Source/shotwell/src/Dimensions.vala"
		zoom_state_clamp_viewport_center (&(*self));
#line 2963 "Dimensions.c"
	}
}


void zoom_state_init_rescale (ZoomState *self, ZoomState* existing, gdouble new_slider_val) {
	ZoomState _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	ZoomState _tmp2_ = {0};
	Dimensions _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
#line 489 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (existing != NULL);
#line 489 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (self, 0, sizeof (ZoomState));
#line 490 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *existing;
#line 490 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.content_dimensions;
#line 490 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).content_dimensions = _tmp1_;
#line 491 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *existing;
#line 491 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.viewport_dimensions;
#line 491 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_dimensions = _tmp3_;
#line 492 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = new_slider_val;
#line 492 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).interpolation_factor = _tmp4_;
#line 494 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoom_state_compute_zoom_factors (&(*self));
#line 496 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = new_slider_val;
#line 496 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp5_ == 0.0) {
#line 497 "/home/jens/Source/shotwell/src/Dimensions.vala"
		zoom_state_center_viewport (&(*self));
#line 3003 "Dimensions.c"
	} else {
		gdouble _tmp6_ = 0.0;
		ZoomState _tmp7_ = {0};
		GdkPoint _tmp8_ = {0};
		gint _tmp9_ = 0;
		ZoomState _tmp10_ = {0};
		gdouble _tmp11_ = 0.0;
		gdouble _tmp12_ = 0.0;
		ZoomState _tmp13_ = {0};
		GdkPoint _tmp14_ = {0};
		gint _tmp15_ = 0;
		ZoomState _tmp16_ = {0};
		gdouble _tmp17_ = 0.0;
#line 499 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = (*self).zoom_factor;
#line 499 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = *existing;
#line 499 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp8_ = _tmp7_.viewport_center;
#line 499 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp9_ = _tmp8_.x;
#line 499 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp10_ = *existing;
#line 499 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp11_ = _tmp10_.zoom_factor;
#line 499 "/home/jens/Source/shotwell/src/Dimensions.vala"
		(*self).viewport_center.x = (gint) (_tmp6_ * (_tmp9_ / _tmp11_));
#line 501 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp12_ = (*self).zoom_factor;
#line 501 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp13_ = *existing;
#line 501 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp14_ = _tmp13_.viewport_center;
#line 501 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp15_ = _tmp14_.y;
#line 501 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp16_ = *existing;
#line 501 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp17_ = _tmp16_.zoom_factor;
#line 501 "/home/jens/Source/shotwell/src/Dimensions.vala"
		(*self).viewport_center.y = (gint) (_tmp12_ * (_tmp15_ / _tmp17_));
#line 503 "/home/jens/Source/shotwell/src/Dimensions.vala"
		zoom_state_clamp_viewport_center (&(*self));
#line 3047 "Dimensions.c"
	}
}


void zoom_state_init_rescale_to_isomorphic (ZoomState *self, ZoomState* existing) {
	ZoomState _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	ZoomState _tmp2_ = {0};
	Dimensions _tmp3_ = {0};
	ZoomState _tmp4_ = {0};
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	ZoomState _tmp7_ = {0};
	gdouble _tmp8_ = 0.0;
	ZoomState _tmp9_ = {0};
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
#line 507 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (existing != NULL);
#line 507 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (self, 0, sizeof (ZoomState));
#line 508 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *existing;
#line 508 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.content_dimensions;
#line 508 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).content_dimensions = _tmp1_;
#line 509 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *existing;
#line 509 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.viewport_dimensions;
#line 509 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_dimensions = _tmp3_;
#line 510 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = *existing;
#line 510 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = _tmp4_.min_factor;
#line 510 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = log (1.0 / _tmp5_);
#line 510 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = *existing;
#line 510 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = _tmp7_.max_factor;
#line 510 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = *existing;
#line 510 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = _tmp9_.min_factor;
#line 510 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp11_ = log (_tmp8_ / _tmp10_);
#line 510 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).interpolation_factor = _tmp6_ / _tmp11_;
#line 513 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoom_state_compute_zoom_factors (&(*self));
#line 515 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp12_ = (*self).interpolation_factor;
#line 515 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp12_ == 0.0) {
#line 516 "/home/jens/Source/shotwell/src/Dimensions.vala"
		zoom_state_center_viewport (&(*self));
#line 3108 "Dimensions.c"
	} else {
		gdouble _tmp13_ = 0.0;
		ZoomState _tmp14_ = {0};
		GdkPoint _tmp15_ = {0};
		gint _tmp16_ = 0;
		ZoomState _tmp17_ = {0};
		gdouble _tmp18_ = 0.0;
		gdouble _tmp19_ = 0.0;
		ZoomState _tmp20_ = {0};
		GdkPoint _tmp21_ = {0};
		gint _tmp22_ = 0;
		ZoomState _tmp23_ = {0};
		gdouble _tmp24_ = 0.0;
#line 518 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp13_ = (*self).zoom_factor;
#line 518 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp14_ = *existing;
#line 518 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp15_ = _tmp14_.viewport_center;
#line 518 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp16_ = _tmp15_.x;
#line 518 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp17_ = *existing;
#line 518 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp18_ = _tmp17_.zoom_factor;
#line 518 "/home/jens/Source/shotwell/src/Dimensions.vala"
		(*self).viewport_center.x = (gint) (_tmp13_ * (_tmp16_ / _tmp18_));
#line 520 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp19_ = (*self).zoom_factor;
#line 520 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp20_ = *existing;
#line 520 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp21_ = _tmp20_.viewport_center;
#line 520 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp22_ = _tmp21_.y;
#line 520 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp23_ = *existing;
#line 520 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp24_ = _tmp23_.zoom_factor;
#line 520 "/home/jens/Source/shotwell/src/Dimensions.vala"
		(*self).viewport_center.y = (gint) (_tmp19_ * (_tmp22_ / _tmp24_));
#line 522 "/home/jens/Source/shotwell/src/Dimensions.vala"
		zoom_state_clamp_viewport_center (&(*self));
#line 3152 "Dimensions.c"
	}
}


void zoom_state_init_pan (ZoomState *self, ZoomState* existing, GdkPoint* new_viewport_center) {
	ZoomState _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	ZoomState _tmp2_ = {0};
	Dimensions _tmp3_ = {0};
	ZoomState _tmp4_ = {0};
	gdouble _tmp5_ = 0.0;
	GdkPoint _tmp6_ = {0};
#line 526 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (existing != NULL);
#line 526 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (new_viewport_center != NULL);
#line 526 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (self, 0, sizeof (ZoomState));
#line 527 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *existing;
#line 527 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.content_dimensions;
#line 527 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).content_dimensions = _tmp1_;
#line 528 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = *existing;
#line 528 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.viewport_dimensions;
#line 528 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_dimensions = _tmp3_;
#line 529 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = *existing;
#line 529 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = _tmp4_.interpolation_factor;
#line 529 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).interpolation_factor = _tmp5_;
#line 531 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoom_state_compute_zoom_factors (&(*self));
#line 533 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = *new_viewport_center;
#line 533 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_center = _tmp6_;
#line 535 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoom_state_clamp_viewport_center (&(*self));
#line 3197 "Dimensions.c"
}


static void zoom_state_clamp_viewport_center (ZoomState *self) {
	gint zoomed_width = 0;
	gint _tmp0_ = 0;
	gint zoomed_height = 0;
	gint _tmp1_ = 0;
	GdkPoint _tmp2_ = {0};
	gint _tmp3_ = 0;
	Dimensions _tmp4_ = {0};
	gint _tmp5_ = 0;
	Dimensions _tmp6_ = {0};
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	GdkPoint _tmp9_ = {0};
	gint _tmp10_ = 0;
	Dimensions _tmp11_ = {0};
	gint _tmp12_ = 0;
	Dimensions _tmp13_ = {0};
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
#line 539 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = zoom_state_get_zoomed_width (&(*self));
#line 539 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoomed_width = _tmp0_;
#line 540 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = zoom_state_get_zoomed_height (&(*self));
#line 540 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoomed_height = _tmp1_;
#line 542 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = (*self).viewport_center;
#line 542 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.x;
#line 542 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = (*self).viewport_dimensions;
#line 542 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = _tmp4_.width;
#line 542 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = (*self).viewport_dimensions;
#line 542 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = _tmp6_.width;
#line 542 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = CLAMP (_tmp3_, _tmp5_ / 2, (zoomed_width - (_tmp7_ / 2)) - 1);
#line 542 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_center.x = _tmp8_;
#line 544 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = (*self).viewport_center;
#line 544 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = _tmp9_.y;
#line 544 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp11_ = (*self).viewport_dimensions;
#line 544 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp12_ = _tmp11_.height;
#line 544 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp13_ = (*self).viewport_dimensions;
#line 544 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp14_ = _tmp13_.height;
#line 544 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp15_ = CLAMP (_tmp10_, _tmp12_ / 2, (zoomed_height - (_tmp14_ / 2)) - 1);
#line 544 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_center.y = _tmp15_;
#line 3260 "Dimensions.c"
}


static void zoom_state_center_viewport (ZoomState *self) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 549 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = zoom_state_get_zoomed_width (&(*self));
#line 549 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_center.x = _tmp0_ / 2;
#line 550 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = zoom_state_get_zoomed_height (&(*self));
#line 550 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).viewport_center.y = _tmp1_ / 2;
#line 3275 "Dimensions.c"
}


static void zoom_state_compute_zoom_factors (ZoomState *self) {
	gdouble viewport_to_content_x = 0.0;
	gdouble viewport_to_content_y = 0.0;
	Dimensions _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
#line 554 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).max_factor = 2.0;
#line 558 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).viewport_dimensions;
#line 558 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dimensions_get_scale_ratios (&(*self).content_dimensions, &_tmp0_, &_tmp1_, &_tmp2_);
#line 558 "/home/jens/Source/shotwell/src/Dimensions.vala"
	viewport_to_content_x = _tmp1_;
#line 558 "/home/jens/Source/shotwell/src/Dimensions.vala"
	viewport_to_content_y = _tmp2_;
#line 560 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = viewport_to_content_x;
#line 560 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = viewport_to_content_y;
#line 560 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = MIN (_tmp3_, _tmp4_);
#line 560 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).min_factor = _tmp5_;
#line 561 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = (*self).min_factor;
#line 561 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp6_ > 1.0) {
#line 562 "/home/jens/Source/shotwell/src/Dimensions.vala"
		(*self).min_factor = 1.0;
#line 3318 "Dimensions.c"
	}
#line 564 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = (*self).min_factor;
#line 564 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = (*self).max_factor;
#line 564 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = (*self).min_factor;
#line 564 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = (*self).interpolation_factor;
#line 564 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp11_ = pow (_tmp8_ / _tmp9_, _tmp10_);
#line 564 "/home/jens/Source/shotwell/src/Dimensions.vala"
	(*self).zoom_factor = _tmp7_ * _tmp11_;
#line 3332 "Dimensions.c"
}


gdouble zoom_state_get_interpolation_factor (ZoomState *self) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
#line 568 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).interpolation_factor;
#line 568 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_;
#line 568 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 3345 "Dimensions.c"
}


void zoom_state_get_viewing_rectangle_wrt_content (ZoomState *self, GdkRectangle* result) {
	gint zoomed_width = 0;
	gint _tmp0_ = 0;
	gint zoomed_height = 0;
	gint _tmp1_ = 0;
	GdkRectangle _result_ = {0};
	Dimensions _tmp2_ = {0};
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GdkRectangle _tmp12_ = {0};
	gint _tmp13_ = 0;
	Dimensions _tmp14_ = {0};
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GdkRectangle _tmp24_ = {0};
	gint _tmp25_ = 0;
	gint right = 0;
	GdkRectangle _tmp26_ = {0};
	gint _tmp27_ = 0;
	Dimensions _tmp28_ = {0};
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp33_ = 0;
	GdkRectangle _tmp34_ = {0};
	gint _tmp35_ = 0;
	gint bottom = 0;
	GdkRectangle _tmp36_ = {0};
	gint _tmp37_ = 0;
	Dimensions _tmp38_ = {0};
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	gint _tmp43_ = 0;
	GdkRectangle _tmp44_ = {0};
	gint _tmp45_ = 0;
	GdkRectangle _tmp46_ = {0};
	gint _tmp47_ = 0;
	gint _tmp48_ = 0;
	GdkRectangle _tmp49_ = {0};
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
#line 573 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = zoom_state_get_zoomed_width (&(*self));
#line 573 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoomed_width = _tmp0_;
#line 574 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = zoom_state_get_zoomed_height (&(*self));
#line 574 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoomed_height = _tmp1_;
#line 576 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (&_result_, 0, sizeof (GdkRectangle));
#line 578 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = (*self).viewport_dimensions;
#line 578 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = _tmp2_.width;
#line 578 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = zoomed_width;
#line 578 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp3_ < _tmp4_) {
#line 3409 "Dimensions.c"
		GdkPoint _tmp5_ = {0};
		gint _tmp6_ = 0;
		Dimensions _tmp7_ = {0};
		gint _tmp8_ = 0;
#line 579 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = (*self).viewport_center;
#line 579 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp6_ = _tmp5_.x;
#line 579 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp7_ = (*self).viewport_dimensions;
#line 579 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp8_ = _tmp7_.width;
#line 579 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_result_.x = _tmp6_ - (_tmp8_ / 2);
#line 3424 "Dimensions.c"
	} else {
		gint _tmp9_ = 0;
		Dimensions _tmp10_ = {0};
		gint _tmp11_ = 0;
#line 581 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp9_ = zoomed_width;
#line 581 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp10_ = (*self).viewport_dimensions;
#line 581 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp11_ = _tmp10_.width;
#line 581 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_result_.x = (_tmp9_ - _tmp11_) / 2;
#line 3437 "Dimensions.c"
	}
#line 583 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp12_ = _result_;
#line 583 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp13_ = _tmp12_.x;
#line 583 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp13_ < 0) {
#line 584 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_result_.x = 0;
#line 3447 "Dimensions.c"
	}
#line 586 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp14_ = (*self).viewport_dimensions;
#line 586 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp15_ = _tmp14_.height;
#line 586 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp16_ = zoomed_height;
#line 586 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp15_ < _tmp16_) {
#line 3457 "Dimensions.c"
		GdkPoint _tmp17_ = {0};
		gint _tmp18_ = 0;
		Dimensions _tmp19_ = {0};
		gint _tmp20_ = 0;
#line 587 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp17_ = (*self).viewport_center;
#line 587 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp18_ = _tmp17_.y;
#line 587 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp19_ = (*self).viewport_dimensions;
#line 587 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp20_ = _tmp19_.height;
#line 587 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_result_.y = _tmp18_ - (_tmp20_ / 2);
#line 3472 "Dimensions.c"
	} else {
		gint _tmp21_ = 0;
		Dimensions _tmp22_ = {0};
		gint _tmp23_ = 0;
#line 589 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp21_ = zoomed_height;
#line 589 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp22_ = (*self).viewport_dimensions;
#line 589 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp23_ = _tmp22_.height;
#line 589 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_result_.y = (_tmp21_ - _tmp23_) / 2;
#line 3485 "Dimensions.c"
	}
#line 591 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp24_ = _result_;
#line 591 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp25_ = _tmp24_.y;
#line 591 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp25_ < 0) {
#line 592 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_result_.y = 0;
#line 3495 "Dimensions.c"
	}
#line 594 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp26_ = _result_;
#line 594 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp27_ = _tmp26_.x;
#line 594 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp28_ = (*self).viewport_dimensions;
#line 594 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp29_ = _tmp28_.width;
#line 594 "/home/jens/Source/shotwell/src/Dimensions.vala"
	right = _tmp27_ + _tmp29_;
#line 595 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp30_ = right;
#line 595 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp31_ = zoomed_width;
#line 595 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp30_ > _tmp31_) {
#line 3513 "Dimensions.c"
		gint _tmp32_ = 0;
#line 596 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp32_ = zoomed_width;
#line 596 "/home/jens/Source/shotwell/src/Dimensions.vala"
		right = _tmp32_;
#line 3519 "Dimensions.c"
	}
#line 597 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp33_ = right;
#line 597 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp34_ = _result_;
#line 597 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp35_ = _tmp34_.x;
#line 597 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.width = _tmp33_ - _tmp35_;
#line 599 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp36_ = _result_;
#line 599 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp37_ = _tmp36_.y;
#line 599 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp38_ = (*self).viewport_dimensions;
#line 599 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp39_ = _tmp38_.height;
#line 599 "/home/jens/Source/shotwell/src/Dimensions.vala"
	bottom = _tmp37_ + _tmp39_;
#line 600 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp40_ = bottom;
#line 600 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp41_ = zoomed_height;
#line 600 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp40_ > _tmp41_) {
#line 3545 "Dimensions.c"
		gint _tmp42_ = 0;
#line 601 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp42_ = zoomed_height;
#line 601 "/home/jens/Source/shotwell/src/Dimensions.vala"
		bottom = _tmp42_;
#line 3551 "Dimensions.c"
	}
#line 602 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp43_ = bottom;
#line 602 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp44_ = _result_;
#line 602 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp45_ = _tmp44_.y;
#line 602 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.height = _tmp43_ - _tmp45_;
#line 604 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp46_ = _result_;
#line 604 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp47_ = _tmp46_.width;
#line 604 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp48_ = CLAMP (_tmp47_, 1, G_MAXINT);
#line 604 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.width = _tmp48_;
#line 605 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp49_ = _result_;
#line 605 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp50_ = _tmp49_.height;
#line 605 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp51_ = CLAMP (_tmp50_, 1, G_MAXINT);
#line 605 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.height = _tmp51_;
#line 607 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _result_;
#line 607 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 3581 "Dimensions.c"
}


void zoom_state_get_viewing_rectangle_wrt_screen (ZoomState *self, GdkRectangle* result) {
	GdkRectangle wrt_content = {0};
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _result_ = {0};
	Dimensions _tmp1_ = {0};
	gint _tmp2_ = 0;
	GdkRectangle _tmp3_ = {0};
	gint _tmp4_ = 0;
	GdkRectangle _tmp5_ = {0};
	gint _tmp6_ = 0;
	Dimensions _tmp7_ = {0};
	gint _tmp8_ = 0;
	GdkRectangle _tmp9_ = {0};
	gint _tmp10_ = 0;
	GdkRectangle _tmp11_ = {0};
	gint _tmp12_ = 0;
	GdkRectangle _tmp13_ = {0};
	gint _tmp14_ = 0;
	GdkRectangle _tmp15_ = {0};
	gint _tmp16_ = 0;
#line 613 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoom_state_get_viewing_rectangle_wrt_content (&(*self), &_tmp0_);
#line 613 "/home/jens/Source/shotwell/src/Dimensions.vala"
	wrt_content = _tmp0_;
#line 615 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (&_result_, 0, sizeof (GdkRectangle));
#line 616 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).viewport_dimensions;
#line 616 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = _tmp1_.width;
#line 616 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = wrt_content;
#line 616 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = _tmp3_.width;
#line 616 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.x = (_tmp2_ / 2) - (_tmp4_ / 2);
#line 617 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = _result_;
#line 617 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = _tmp5_.x;
#line 617 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp6_ < 0) {
#line 618 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_result_.x = 0;
#line 3629 "Dimensions.c"
	}
#line 619 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = (*self).viewport_dimensions;
#line 619 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = _tmp7_.height;
#line 619 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = wrt_content;
#line 619 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = _tmp9_.height;
#line 619 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.y = (_tmp8_ / 2) - (_tmp10_ / 2);
#line 620 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp11_ = _result_;
#line 620 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp12_ = _tmp11_.y;
#line 620 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp12_ < 0) {
#line 621 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_result_.y = 0;
#line 3649 "Dimensions.c"
	}
#line 622 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp13_ = wrt_content;
#line 622 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp14_ = _tmp13_.width;
#line 622 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.width = _tmp14_;
#line 623 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp15_ = wrt_content;
#line 623 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp16_ = _tmp15_.height;
#line 623 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.height = _tmp16_;
#line 625 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _result_;
#line 625 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 3667 "Dimensions.c"
}


void zoom_state_get_viewing_rectangle_projection (ZoomState *self, GdkPixbuf* for_pixbuf, GdkRectangle* result) {
	gdouble zoomed_width = 0.0;
	gint _tmp0_ = 0;
	gdouble zoomed_height = 0.0;
	gint _tmp1_ = 0;
	gdouble horiz_scale = 0.0;
	GdkPixbuf* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gdouble vert_scale = 0.0;
	GdkPixbuf* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gdouble scale = 0.0;
	GdkRectangle viewing_rectangle = {0};
	GdkRectangle _tmp8_ = {0};
	GdkRectangle _result_ = {0};
	GdkRectangle _tmp9_ = {0};
	gint _tmp10_ = 0;
	GdkRectangle _tmp11_ = {0};
	gint _tmp12_ = 0;
	GdkPixbuf* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GdkRectangle _tmp17_ = {0};
	gint _tmp18_ = 0;
	GdkRectangle _tmp19_ = {0};
	gint _tmp20_ = 0;
	GdkPixbuf* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint right = 0;
	GdkRectangle _tmp25_ = {0};
	gint _tmp26_ = 0;
	GdkRectangle _tmp27_ = {0};
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	GdkPixbuf* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gint bottom = 0;
	GdkRectangle _tmp34_ = {0};
	gint _tmp35_ = 0;
	GdkRectangle _tmp36_ = {0};
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	GdkPixbuf* _tmp39_ = NULL;
	gint _tmp40_ = 0;
	gint _tmp41_ = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	GdkRectangle _tmp44_ = {0};
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	GdkRectangle _tmp47_ = {0};
	gint _tmp48_ = 0;
#line 629 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_if_fail (GDK_IS_PIXBUF (for_pixbuf));
#line 630 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = zoom_state_get_zoomed_width (&(*self));
#line 630 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoomed_width = (gdouble) _tmp0_;
#line 631 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = zoom_state_get_zoomed_height (&(*self));
#line 631 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoomed_height = (gdouble) _tmp1_;
#line 633 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = for_pixbuf;
#line 633 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = gdk_pixbuf_get_width (_tmp2_);
#line 633 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = _tmp3_;
#line 633 "/home/jens/Source/shotwell/src/Dimensions.vala"
	horiz_scale = _tmp4_ / zoomed_width;
#line 634 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = for_pixbuf;
#line 634 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = gdk_pixbuf_get_height (_tmp5_);
#line 634 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = _tmp6_;
#line 634 "/home/jens/Source/shotwell/src/Dimensions.vala"
	vert_scale = _tmp7_ / zoomed_height;
#line 635 "/home/jens/Source/shotwell/src/Dimensions.vala"
	scale = (horiz_scale + vert_scale) / 2.0;
#line 637 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoom_state_get_viewing_rectangle_wrt_content (&(*self), &_tmp8_);
#line 637 "/home/jens/Source/shotwell/src/Dimensions.vala"
	viewing_rectangle = _tmp8_;
#line 639 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memset (&_result_, 0, sizeof (GdkRectangle));
#line 640 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = viewing_rectangle;
#line 640 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = _tmp9_.x;
#line 640 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.x = (gint) (_tmp10_ * scale);
#line 641 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp11_ = _result_;
#line 641 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp12_ = _tmp11_.x;
#line 641 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp13_ = for_pixbuf;
#line 641 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp14_ = gdk_pixbuf_get_width (_tmp13_);
#line 641 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp15_ = _tmp14_;
#line 641 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp16_ = CLAMP (_tmp12_, 0, _tmp15_);
#line 641 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.x = _tmp16_;
#line 642 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp17_ = viewing_rectangle;
#line 642 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp18_ = _tmp17_.y;
#line 642 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.y = (gint) (_tmp18_ * scale);
#line 643 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp19_ = _result_;
#line 643 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp20_ = _tmp19_.y;
#line 643 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp21_ = for_pixbuf;
#line 643 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp22_ = gdk_pixbuf_get_height (_tmp21_);
#line 643 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp23_ = _tmp22_;
#line 643 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp24_ = CLAMP (_tmp20_, 0, _tmp23_);
#line 643 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.y = _tmp24_;
#line 644 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp25_ = viewing_rectangle;
#line 644 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp26_ = _tmp25_.x;
#line 644 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp27_ = viewing_rectangle;
#line 644 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp28_ = _tmp27_.width;
#line 644 "/home/jens/Source/shotwell/src/Dimensions.vala"
	right = (gint) ((_tmp26_ + _tmp28_) * scale);
#line 645 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp29_ = right;
#line 645 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp30_ = for_pixbuf;
#line 645 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp31_ = gdk_pixbuf_get_width (_tmp30_);
#line 645 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp32_ = _tmp31_;
#line 645 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp33_ = CLAMP (_tmp29_, 0, _tmp32_);
#line 645 "/home/jens/Source/shotwell/src/Dimensions.vala"
	right = _tmp33_;
#line 646 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp34_ = viewing_rectangle;
#line 646 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp35_ = _tmp34_.y;
#line 646 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp36_ = viewing_rectangle;
#line 646 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp37_ = _tmp36_.height;
#line 646 "/home/jens/Source/shotwell/src/Dimensions.vala"
	bottom = (gint) ((_tmp35_ + _tmp37_) * scale);
#line 647 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp38_ = bottom;
#line 647 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp39_ = for_pixbuf;
#line 647 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp40_ = gdk_pixbuf_get_height (_tmp39_);
#line 647 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp41_ = _tmp40_;
#line 647 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp42_ = CLAMP (_tmp38_, 0, _tmp41_);
#line 647 "/home/jens/Source/shotwell/src/Dimensions.vala"
	bottom = _tmp42_;
#line 648 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp43_ = right;
#line 648 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp44_ = _result_;
#line 648 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp45_ = _tmp44_.x;
#line 648 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.width = _tmp43_ - _tmp45_;
#line 649 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp46_ = bottom;
#line 649 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp47_ = _result_;
#line 649 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp48_ = _tmp47_.y;
#line 649 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_result_.height = _tmp46_ - _tmp48_;
#line 651 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _result_;
#line 651 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 3868 "Dimensions.c"
}


gdouble zoom_state_get_zoom_factor (ZoomState *self) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
#line 656 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).zoom_factor;
#line 656 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_;
#line 656 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 3881 "Dimensions.c"
}


gint zoom_state_get_zoomed_width (ZoomState *self) {
	gint result = 0;
	Dimensions _tmp0_ = {0};
	gint _tmp1_ = 0;
	gdouble _tmp2_ = 0.0;
#line 660 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).content_dimensions;
#line 660 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.width;
#line 660 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = (*self).zoom_factor;
#line 660 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = (gint) (_tmp1_ * _tmp2_);
#line 660 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 3900 "Dimensions.c"
}


gint zoom_state_get_zoomed_height (ZoomState *self) {
	gint result = 0;
	Dimensions _tmp0_ = {0};
	gint _tmp1_ = 0;
	gdouble _tmp2_ = 0.0;
#line 664 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).content_dimensions;
#line 664 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.height;
#line 664 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = (*self).zoom_factor;
#line 664 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = (gint) (_tmp1_ * _tmp2_);
#line 664 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 3919 "Dimensions.c"
}


void zoom_state_get_viewport_center (ZoomState *self, GdkPoint* result) {
	GdkPoint _tmp0_ = {0};
#line 668 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).viewport_center;
#line 668 "/home/jens/Source/shotwell/src/Dimensions.vala"
	*result = _tmp0_;
#line 668 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return;
#line 3931 "Dimensions.c"
}


gchar* zoom_state_to_string (ZoomState *self) {
	gchar* result = NULL;
	gchar* named_modes = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp21_ = NULL;
	GdkRectangle viewing_rect = {0};
	GdkRectangle _tmp23_ = {0};
	Dimensions _tmp24_ = {0};
	gint _tmp25_ = 0;
	Dimensions _tmp26_ = {0};
	gint _tmp27_ = 0;
	Dimensions _tmp28_ = {0};
	gint _tmp29_ = 0;
	Dimensions _tmp30_ = {0};
	gint _tmp31_ = 0;
	gdouble _tmp32_ = 0.0;
	gdouble _tmp33_ = 0.0;
	gdouble _tmp34_ = 0.0;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	const gchar* _tmp37_ = NULL;
	GdkRectangle _tmp38_ = {0};
	gint _tmp39_ = 0;
	GdkRectangle _tmp40_ = {0};
	gint _tmp41_ = 0;
	GdkRectangle _tmp42_ = {0};
	gint _tmp43_ = 0;
	GdkRectangle _tmp44_ = {0};
	gint _tmp45_ = 0;
	GdkPoint _tmp46_ = {0};
	gint _tmp47_ = 0;
	GdkPoint _tmp48_ = {0};
	gint _tmp49_ = 0;
	gchar* _tmp50_ = NULL;
#line 672 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = g_strdup ("");
#line 672 "/home/jens/Source/shotwell/src/Dimensions.vala"
	named_modes = _tmp0_;
#line 673 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = zoom_state_is_min (&(*self));
#line 673 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp1_) {
#line 3981 "Dimensions.c"
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 674 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp3_ = named_modes;
#line 674 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (g_strcmp0 (_tmp3_, "") == 0) {
#line 674 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp2_ = "MIN";
#line 3992 "Dimensions.c"
		} else {
#line 674 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp2_ = ", MIN";
#line 3996 "Dimensions.c"
		}
#line 674 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp4_ = named_modes;
#line 674 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp5_ = g_strconcat (_tmp4_, _tmp2_, NULL);
#line 674 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_g_free0 (named_modes);
#line 674 "/home/jens/Source/shotwell/src/Dimensions.vala"
		named_modes = _tmp5_;
#line 4006 "Dimensions.c"
	}
#line 675 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = zoom_state_is_default (&(*self));
#line 675 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp6_) {
#line 4012 "Dimensions.c"
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
#line 676 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp8_ = named_modes;
#line 676 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (g_strcmp0 (_tmp8_, "") == 0) {
#line 676 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp7_ = "DEFAULT";
#line 4023 "Dimensions.c"
		} else {
#line 676 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp7_ = ", DEFAULT";
#line 4027 "Dimensions.c"
		}
#line 676 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp9_ = named_modes;
#line 676 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp10_ = g_strconcat (_tmp9_, _tmp7_, NULL);
#line 676 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_g_free0 (named_modes);
#line 676 "/home/jens/Source/shotwell/src/Dimensions.vala"
		named_modes = _tmp10_;
#line 4037 "Dimensions.c"
	}
#line 677 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp11_ = zoom_state_is_isomorphic (&(*self));
#line 677 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp11_) {
#line 4043 "Dimensions.c"
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
#line 678 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp13_ = named_modes;
#line 678 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (g_strcmp0 (_tmp13_, "") == 0) {
#line 678 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp12_ = "ISOMORPHIC";
#line 4054 "Dimensions.c"
		} else {
#line 678 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp12_ = ", ISOMORPHIC";
#line 4058 "Dimensions.c"
		}
#line 678 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp14_ = named_modes;
#line 678 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp15_ = g_strconcat (_tmp14_, _tmp12_, NULL);
#line 678 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_g_free0 (named_modes);
#line 678 "/home/jens/Source/shotwell/src/Dimensions.vala"
		named_modes = _tmp15_;
#line 4068 "Dimensions.c"
	}
#line 679 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp16_ = zoom_state_is_max (&(*self));
#line 679 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp16_) {
#line 4074 "Dimensions.c"
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
#line 680 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp18_ = named_modes;
#line 680 "/home/jens/Source/shotwell/src/Dimensions.vala"
		if (g_strcmp0 (_tmp18_, "") == 0) {
#line 680 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp17_ = "MAX";
#line 4085 "Dimensions.c"
		} else {
#line 680 "/home/jens/Source/shotwell/src/Dimensions.vala"
			_tmp17_ = ", MAX";
#line 4089 "Dimensions.c"
		}
#line 680 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp19_ = named_modes;
#line 680 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp20_ = g_strconcat (_tmp19_, _tmp17_, NULL);
#line 680 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_g_free0 (named_modes);
#line 680 "/home/jens/Source/shotwell/src/Dimensions.vala"
		named_modes = _tmp20_;
#line 4099 "Dimensions.c"
	}
#line 681 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp21_ = named_modes;
#line 681 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (g_strcmp0 (_tmp21_, "") == 0) {
#line 4105 "Dimensions.c"
		gchar* _tmp22_ = NULL;
#line 682 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_tmp22_ = g_strdup ("(none)");
#line 682 "/home/jens/Source/shotwell/src/Dimensions.vala"
		_g_free0 (named_modes);
#line 682 "/home/jens/Source/shotwell/src/Dimensions.vala"
		named_modes = _tmp22_;
#line 4113 "Dimensions.c"
	}
#line 684 "/home/jens/Source/shotwell/src/Dimensions.vala"
	zoom_state_get_viewing_rectangle_wrt_content (&(*self), &_tmp23_);
#line 684 "/home/jens/Source/shotwell/src/Dimensions.vala"
	viewing_rect = _tmp23_;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp24_ = (*self).content_dimensions;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp25_ = _tmp24_.width;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp26_ = (*self).content_dimensions;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp27_ = _tmp26_.height;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp28_ = (*self).viewport_dimensions;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp29_ = _tmp28_.width;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp30_ = (*self).viewport_dimensions;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp31_ = _tmp30_.height;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp32_ = (*self).min_factor;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp33_ = (*self).max_factor;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp34_ = (*self).zoom_factor;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp35_ = zoom_state_get_zoomed_width (&(*self));
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp36_ = zoom_state_get_zoomed_height (&(*self));
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp37_ = named_modes;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp38_ = viewing_rect;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp39_ = _tmp38_.x;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp40_ = viewing_rect;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp41_ = _tmp40_.y;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp42_ = viewing_rect;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp43_ = _tmp42_.width;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp44_ = viewing_rect;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp45_ = _tmp44_.height;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp46_ = (*self).viewport_center;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp47_ = _tmp46_.x;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp48_ = (*self).viewport_center;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp49_ = _tmp48_.y;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp50_ = g_strdup_printf ("ZoomState {\n" \
"    content dimensions = %d x %d;\n" \
"    viewport dimensions = " "%d x %d;\n" \
"    min factor = %f;\n" \
"    max factor = %f;\n" \
"    current factor = %f;" "\n" \
"    zoomed width = %d;\n" \
"    zoomed height = %d;\n" \
"    named modes = %s;" "\n    viewing rectangle = { x: %d, y: %d, width: %d, height: %d };" "\n    viewport center = (%d, %d);\n}\n", _tmp25_, _tmp27_, _tmp29_, _tmp31_, _tmp32_, _tmp33_, _tmp34_, _tmp35_, _tmp36_, _tmp37_, _tmp39_, _tmp41_, _tmp43_, _tmp45_, _tmp47_, _tmp49_);
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp50_;
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_g_free0 (named_modes);
#line 686 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 4179 "Dimensions.c"
}


gboolean zoom_state_is_min (ZoomState *self) {
	gboolean result = FALSE;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
#line 698 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).zoom_factor;
#line 698 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).min_factor;
#line 698 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_ == _tmp1_;
#line 698 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 4195 "Dimensions.c"
}


gboolean zoom_state_is_default (ZoomState *self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 702 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = zoom_state_is_min (&(*self));
#line 702 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_;
#line 702 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 4208 "Dimensions.c"
}


gboolean zoom_state_is_max (ZoomState *self) {
	gboolean result = FALSE;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
#line 706 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).zoom_factor;
#line 706 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = (*self).max_factor;
#line 706 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_ == _tmp1_;
#line 706 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 4224 "Dimensions.c"
}


gboolean zoom_state_is_isomorphic (ZoomState *self) {
	gboolean result = FALSE;
	gdouble _tmp0_ = 0.0;
#line 710 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = (*self).zoom_factor;
#line 710 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = _tmp0_ == 1.0;
#line 710 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 4237 "Dimensions.c"
}


gboolean zoom_state_equals (ZoomState *self, ZoomState* other) {
	gboolean result = FALSE;
	ZoomState _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	ZoomState _tmp3_ = {0};
	Dimensions _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gdouble _tmp6_ = 0.0;
	ZoomState _tmp7_ = {0};
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	ZoomState _tmp10_ = {0};
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	ZoomState _tmp13_ = {0};
	gdouble _tmp14_ = 0.0;
	GdkPoint _tmp15_ = {0};
	gint _tmp16_ = 0;
	ZoomState _tmp17_ = {0};
	GdkPoint _tmp18_ = {0};
	gint _tmp19_ = 0;
	GdkPoint _tmp20_ = {0};
	gint _tmp21_ = 0;
	ZoomState _tmp22_ = {0};
	GdkPoint _tmp23_ = {0};
	gint _tmp24_ = 0;
#line 713 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_return_val_if_fail (other != NULL, FALSE);
#line 714 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp0_ = *other;
#line 714 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp1_ = _tmp0_.content_dimensions;
#line 714 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp2_ = dimensions_equals (&(*self).content_dimensions, &_tmp1_);
#line 714 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (!_tmp2_) {
#line 715 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 715 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 4282 "Dimensions.c"
	}
#line 716 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp3_ = *other;
#line 716 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp4_ = _tmp3_.viewport_dimensions;
#line 716 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp5_ = dimensions_equals (&(*self).viewport_dimensions, &_tmp4_);
#line 716 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (!_tmp5_) {
#line 717 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 717 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 4296 "Dimensions.c"
	}
#line 718 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp6_ = (*self).zoom_factor;
#line 718 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp7_ = *other;
#line 718 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp8_ = _tmp7_.zoom_factor;
#line 718 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp6_ != _tmp8_) {
#line 719 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 719 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 4310 "Dimensions.c"
	}
#line 720 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp9_ = (*self).min_factor;
#line 720 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp10_ = *other;
#line 720 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp11_ = _tmp10_.min_factor;
#line 720 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp9_ != _tmp11_) {
#line 721 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 721 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 4324 "Dimensions.c"
	}
#line 722 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp12_ = (*self).max_factor;
#line 722 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp13_ = *other;
#line 722 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp14_ = _tmp13_.max_factor;
#line 722 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp12_ != _tmp14_) {
#line 723 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 723 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 4338 "Dimensions.c"
	}
#line 724 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp15_ = (*self).viewport_center;
#line 724 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp16_ = _tmp15_.x;
#line 724 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp17_ = *other;
#line 724 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp18_ = _tmp17_.viewport_center;
#line 724 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp19_ = _tmp18_.x;
#line 724 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp16_ != _tmp19_) {
#line 725 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 725 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 4356 "Dimensions.c"
	}
#line 726 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp20_ = (*self).viewport_center;
#line 726 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp21_ = _tmp20_.y;
#line 726 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp22_ = *other;
#line 726 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp23_ = _tmp22_.viewport_center;
#line 726 "/home/jens/Source/shotwell/src/Dimensions.vala"
	_tmp24_ = _tmp23_.y;
#line 726 "/home/jens/Source/shotwell/src/Dimensions.vala"
	if (_tmp21_ != _tmp24_) {
#line 727 "/home/jens/Source/shotwell/src/Dimensions.vala"
		result = FALSE;
#line 727 "/home/jens/Source/shotwell/src/Dimensions.vala"
		return result;
#line 4374 "Dimensions.c"
	}
#line 729 "/home/jens/Source/shotwell/src/Dimensions.vala"
	result = TRUE;
#line 729 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return result;
#line 4380 "Dimensions.c"
}


ZoomState* zoom_state_dup (const ZoomState* self) {
	ZoomState* dup;
#line 463 "/home/jens/Source/shotwell/src/Dimensions.vala"
	dup = g_new0 (ZoomState, 1);
#line 463 "/home/jens/Source/shotwell/src/Dimensions.vala"
	memcpy (dup, self, sizeof (ZoomState));
#line 463 "/home/jens/Source/shotwell/src/Dimensions.vala"
	return dup;
#line 4392 "Dimensions.c"
}


void zoom_state_free (ZoomState* self) {
#line 463 "/home/jens/Source/shotwell/src/Dimensions.vala"
	g_free (self);
#line 4399 "Dimensions.c"
}


GType zoom_state_get_type (void) {
	static volatile gsize zoom_state_type_id__volatile = 0;
	if (g_once_init_enter (&zoom_state_type_id__volatile)) {
		GType zoom_state_type_id;
		zoom_state_type_id = g_boxed_type_register_static ("ZoomState", (GBoxedCopyFunc) zoom_state_dup, (GBoxedFreeFunc) zoom_state_free);
		g_once_init_leave (&zoom_state_type_id__volatile, zoom_state_type_id);
	}
	return zoom_state_type_id__volatile;
}



