/* rygel-media-export-item-factory.c generated by valac 0.42.2, the Vala compiler
 * generated from rygel-media-export-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2012,2013 Intel Corporation.
 * Copyright (C) 2015 Jens Georg
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jens Georg <jensg@openismus.com>
 *         Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <gio/gio.h>

#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY (rygel_media_export_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactory))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))

typedef struct _RygelMediaExportObjectFactory RygelMediaExportObjectFactory;
typedef struct _RygelMediaExportObjectFactoryClass RygelMediaExportObjectFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM (rygel_media_export_music_item_get_type ())
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItem))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM))
#define RYGEL_MEDIA_EXPORT_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM, RygelMediaExportMusicItemClass))

typedef struct _RygelMediaExportMusicItem RygelMediaExportMusicItem;
typedef struct _RygelMediaExportMusicItemClass RygelMediaExportMusicItemClass;

#define RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT (rygel_media_export_updatable_object_get_type ())
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObject))
#define RYGEL_MEDIA_EXPORT_IS_UPDATABLE_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT))
#define RYGEL_MEDIA_EXPORT_UPDATABLE_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_MEDIA_EXPORT_TYPE_UPDATABLE_OBJECT, RygelMediaExportUpdatableObjectIface))

typedef struct _RygelMediaExportUpdatableObject RygelMediaExportUpdatableObject;
typedef struct _RygelMediaExportUpdatableObjectIface RygelMediaExportUpdatableObjectIface;
typedef struct _RygelMediaExportMusicItemPrivate RygelMediaExportMusicItemPrivate;

typedef enum  {
	RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_DESERIALIZATION,
	RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_MISMATCH
} RygelMediaExportItemFactoryItemFactoryError;
#define RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR rygel_media_export_item_factory_item_factory_error_quark ()
struct _RygelMediaExportUpdatableObjectIface {
	GTypeInterface parent_iface;
	void (*commit_custom) (RygelMediaExportUpdatableObject* self, gboolean override_guarded, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*commit_custom_finish) (RygelMediaExportUpdatableObject* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaExportMusicItem {
	RygelMusicItem parent_instance;
	RygelMediaExportMusicItemPrivate * priv;
	gint disc;
};

struct _RygelMediaExportMusicItemClass {
	RygelMusicItemClass parent_class;
};



GQuark rygel_media_export_item_factory_item_factory_error_quark (void);
gboolean rygel_media_export_item_factory_check_variant_type (GVariant* v,
                                                             const gchar* typestring,
                                                             GError** error);
RygelMediaObject* rygel_media_export_item_factory_create (RygelMediaContainer* parent,
                                                          GVariantDict* vd);
#define RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS "UPnPClass"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_ID "Id"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_TITLE "Title"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_URI "Uri"
GType rygel_media_export_object_factory_get_type (void) G_GNUC_CONST;
RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type);
RygelMediaContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self,
                                                                      const gchar* id,
                                                                      const gchar* title,
                                                                      guint child_count,
                                                                      const gchar* uri);
RygelMediaFileItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self,
                                                                RygelMediaContainer* parent,
                                                                const gchar* id,
                                                                const gchar* title,
                                                                const gchar* upnp_class);
gint64 rygel_media_export_item_factory_get_int64 (GVariantDict* vd,
                                                  const gchar* key);
gint32 rygel_media_export_item_factory_get_int32 (GVariantDict* vd,
                                                  const gchar* key);
RygelMediaObject* rygel_media_export_item_factory_create_from_variant (RygelMediaContainer* parent,
                                                                       GFile* file,
                                                                       GVariant* v,
                                                                       GError** error);
#define RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE "MimeType"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_SIZE "Size"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_MODIFIED "MTime"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DLNA_PROFILE "DLNAProfile"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DATE "Date"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_DURATION "Duration"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_BITRATE "AudioBitrate"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_CHANNELS "AudioChannels"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_RATE "AudioRate"
GType rygel_media_export_music_item_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_SERIALIZER_ARTIST "Artist"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_ALBUM "Album"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_GENRE "Genre"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_TRACK_NUMBER "TrackNumber"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VOLUME_NUMBER "VolumeNumber"
GType rygel_media_export_updatable_object_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_WIDTH "VideoWidth"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_HEIGHT "VideoHeight"
#define RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_DEPTH "VideoDepth"


GQuark
rygel_media_export_item_factory_item_factory_error_quark (void)
{
	return g_quark_from_static_string ("rygel_media_export_item_factory_item_factory_error-quark");
}


gboolean
rygel_media_export_item_factory_check_variant_type (GVariant* v,
                                                    const gchar* typestring,
                                                    GError** error)
{
	gboolean result = FALSE;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	gboolean _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (v != NULL, FALSE);
	g_return_val_if_fail (typestring != NULL, FALSE);
	_tmp0_ = g_variant_type_new (typestring);
	_tmp1_ = _tmp0_;
	_tmp2_ = !g_variant_is_of_type (v, _tmp1_);
	_g_variant_type_free0 (_tmp1_);
	if (_tmp2_) {
		gchar* msg = NULL;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
		gboolean _tmp7_ = FALSE;
		_tmp3_ = g_strdup ("Variant type mismatch, expected %s, got %s");
		msg = _tmp3_;
		_tmp4_ = msg;
		_tmp5_ = g_variant_get_type_string (v);
		_tmp6_ = g_error_new (RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR, RYGEL_MEDIA_EXPORT_ITEM_FACTORY_ITEM_FACTORY_ERROR_DESERIALIZATION, _tmp4_, _tmp5_, typestring);
		_inner_error_ = _tmp6_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (msg);
		return _tmp7_;
	}
	result = TRUE;
	return result;
}


RygelMediaObject*
rygel_media_export_item_factory_create (RygelMediaContainer* parent,
                                        GVariantDict* vd)
{
	RygelMediaObject* result = NULL;
	GVariantType* expected = NULL;
	RygelMediaObject* object = NULL;
	GVariant* upnp_class = NULL;
	const GVariantType* _tmp0_;
	GVariant* _tmp1_;
	GVariant* id = NULL;
	const GVariantType* _tmp2_;
	GVariant* _tmp3_;
	GVariant* title = NULL;
	const GVariantType* _tmp4_;
	GVariant* _tmp5_;
	GVariant* uri = NULL;
	const GVariantType* _tmp6_;
	GVariant* _tmp7_;
	RygelMediaExportObjectFactory* factory = NULL;
	RygelMediaExportObjectFactory* _tmp8_;
	GVariant* _tmp9_;
	const gchar* _tmp10_;
	RygelMediaObject* _tmp27_;
	GVariant* _tmp28_;
	const gchar* _tmp29_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (vd != NULL, NULL);
	expected = NULL;
	object = NULL;
	_tmp0_ = expected;
	_tmp1_ = g_variant_dict_lookup_value (vd, RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS, _tmp0_);
	upnp_class = _tmp1_;
	_tmp2_ = expected;
	_tmp3_ = g_variant_dict_lookup_value (vd, RYGEL_MEDIA_EXPORT_SERIALIZER_ID, _tmp2_);
	id = _tmp3_;
	_tmp4_ = expected;
	_tmp5_ = g_variant_dict_lookup_value (vd, RYGEL_MEDIA_EXPORT_SERIALIZER_TITLE, _tmp4_);
	title = _tmp5_;
	_tmp6_ = expected;
	_tmp7_ = g_variant_dict_lookup_value (vd, RYGEL_MEDIA_EXPORT_SERIALIZER_URI, _tmp6_);
	uri = _tmp7_;
	_tmp8_ = rygel_media_export_object_factory_new ();
	factory = _tmp8_;
	_tmp9_ = upnp_class;
	_tmp10_ = g_variant_get_string (_tmp9_, NULL);
	if (g_str_has_prefix (_tmp10_, RYGEL_MEDIA_CONTAINER_UPNP_CLASS)) {
		RygelMediaExportObjectFactory* _tmp11_;
		GVariant* _tmp12_;
		const gchar* _tmp13_;
		GVariant* _tmp14_;
		const gchar* _tmp15_;
		GVariant* _tmp16_;
		const gchar* _tmp17_;
		RygelMediaContainer* _tmp18_;
		_tmp11_ = factory;
		_tmp12_ = id;
		_tmp13_ = g_variant_get_string (_tmp12_, NULL);
		_tmp14_ = title;
		_tmp15_ = g_variant_get_string (_tmp14_, NULL);
		_tmp16_ = uri;
		_tmp17_ = g_variant_get_string (_tmp16_, NULL);
		_tmp18_ = rygel_media_export_object_factory_get_container (_tmp11_, _tmp13_, _tmp15_, (guint) 0, _tmp17_);
		_g_object_unref0 (object);
		object = (RygelMediaObject*) _tmp18_;
	} else {
		RygelMediaExportObjectFactory* _tmp19_;
		GVariant* _tmp20_;
		const gchar* _tmp21_;
		GVariant* _tmp22_;
		const gchar* _tmp23_;
		GVariant* _tmp24_;
		const gchar* _tmp25_;
		RygelMediaFileItem* _tmp26_;
		_tmp19_ = factory;
		_tmp20_ = id;
		_tmp21_ = g_variant_get_string (_tmp20_, NULL);
		_tmp22_ = title;
		_tmp23_ = g_variant_get_string (_tmp22_, NULL);
		_tmp24_ = upnp_class;
		_tmp25_ = g_variant_get_string (_tmp24_, NULL);
		_tmp26_ = rygel_media_export_object_factory_get_item (_tmp19_, parent, _tmp21_, _tmp23_, _tmp25_);
		_g_object_unref0 (object);
		object = (RygelMediaObject*) _tmp26_;
	}
	_tmp27_ = object;
	_tmp28_ = uri;
	_tmp29_ = g_variant_get_string (_tmp28_, NULL);
	rygel_media_object_add_uri (_tmp27_, _tmp29_);
	result = object;
	_g_object_unref0 (factory);
	_g_variant_unref0 (uri);
	_g_variant_unref0 (title);
	_g_variant_unref0 (id);
	_g_variant_unref0 (upnp_class);
	_g_variant_type_free0 (expected);
	return result;
}


gint64
rygel_media_export_item_factory_get_int64 (GVariantDict* vd,
                                           const gchar* key)
{
	gint64 result = 0LL;
	GVariant* val = NULL;
	const GVariantType* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_val_if_fail (vd != NULL, 0LL);
	g_return_val_if_fail (key != NULL, 0LL);
	_tmp0_ = G_VARIANT_TYPE_UINT64;
	_tmp1_ = g_variant_dict_lookup_value (vd, key, _tmp0_);
	val = _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		GVariant* _tmp3_;
		_tmp3_ = val;
		result = (gint64) g_variant_get_uint64 (_tmp3_);
		_g_variant_unref0 (val);
		return result;
	}
	result = (gint64) -1;
	_g_variant_unref0 (val);
	return result;
}


gint32
rygel_media_export_item_factory_get_int32 (GVariantDict* vd,
                                           const gchar* key)
{
	gint32 result = 0;
	GVariant* val = NULL;
	const GVariantType* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_val_if_fail (vd != NULL, 0);
	g_return_val_if_fail (key != NULL, 0);
	_tmp0_ = G_VARIANT_TYPE_INT32;
	_tmp1_ = g_variant_dict_lookup_value (vd, key, _tmp0_);
	val = _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		GVariant* _tmp3_;
		_tmp3_ = val;
		result = g_variant_get_int32 (_tmp3_);
		_g_variant_unref0 (val);
		return result;
	}
	result = (gint32) -1;
	_g_variant_unref0 (val);
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


RygelMediaObject*
rygel_media_export_item_factory_create_from_variant (RygelMediaContainer* parent,
                                                     GFile* file,
                                                     GVariant* v,
                                                     GError** error)
{
	RygelMediaObject* result = NULL;
	GVariantType* expected = NULL;
	GVariantDict* vd = NULL;
	GVariantDict* _tmp0_;
	GVariant* upnp_class = NULL;
	GVariantDict* _tmp1_;
	const GVariantType* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	RygelMediaObject* object = NULL;
	GVariantDict* _tmp5_;
	RygelMediaObject* _tmp6_;
	RygelMediaObject* _tmp7_;
	RygelMediaFileItem* item = NULL;
	RygelMediaObject* _tmp8_;
	RygelMediaFileItem* _tmp9_;
	GVariant* val = NULL;
	GVariantDict* _tmp10_;
	const GVariantType* _tmp11_;
	GVariant* _tmp12_;
	RygelMediaFileItem* _tmp13_;
	GVariant* _tmp14_;
	const gchar* _tmp15_;
	RygelMediaFileItem* _tmp16_;
	GVariantDict* _tmp17_;
	GVariantDict* _tmp18_;
	const GVariantType* _tmp19_;
	GVariant* _tmp20_;
	RygelMediaFileItem* _tmp21_;
	GVariant* _tmp22_;
	GVariantDict* _tmp23_;
	const GVariantType* _tmp24_;
	GVariant* _tmp25_;
	GVariant* _tmp26_;
	GVariantDict* _tmp30_;
	const GVariantType* _tmp31_;
	GVariant* _tmp32_;
	GVariant* _tmp33_;
	RygelMediaFileItem* _tmp37_;
	RygelMediaFileItem* _tmp76_;
	RygelMediaFileItem* _tmp85_;
	RygelMediaObject* _tmp86_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	expected = NULL;
	if (v == NULL) {
		result = NULL;
		_g_variant_type_free0 (expected);
		return result;
	}
	rygel_media_export_item_factory_check_variant_type (v, "a{sv}", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_variant_type_free0 (expected);
		return NULL;
	}
	_tmp0_ = g_variant_dict_new (v);
	vd = _tmp0_;
	_tmp1_ = vd;
	_tmp2_ = expected;
	_tmp3_ = g_variant_dict_lookup_value (_tmp1_, RYGEL_MEDIA_EXPORT_SERIALIZER_UPNP_CLASS, _tmp2_);
	upnp_class = _tmp3_;
	_tmp4_ = upnp_class;
	if (_tmp4_ == NULL) {
		g_debug ("rygel-media-export-item-factory.vala:115: Did not find a UPnP class fo" \
"r item, ignoring");
		result = NULL;
		_g_variant_unref0 (upnp_class);
		_g_variant_dict_unref0 (vd);
		_g_variant_type_free0 (expected);
		return result;
	}
	_tmp5_ = vd;
	_tmp6_ = rygel_media_export_item_factory_create (parent, _tmp5_);
	object = _tmp6_;
	_tmp7_ = object;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, RYGEL_TYPE_MEDIA_CONTAINER)) {
		result = object;
		_g_variant_unref0 (upnp_class);
		_g_variant_dict_unref0 (vd);
		_g_variant_type_free0 (expected);
		return result;
	}
	_tmp8_ = object;
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp8_) : NULL);
	item = _tmp9_;
	_tmp10_ = vd;
	_tmp11_ = expected;
	_tmp12_ = g_variant_dict_lookup_value (_tmp10_, RYGEL_MEDIA_EXPORT_SERIALIZER_MIME_TYPE, _tmp11_);
	val = _tmp12_;
	_tmp13_ = item;
	_tmp14_ = val;
	_tmp15_ = g_variant_get_string (_tmp14_, NULL);
	rygel_media_file_item_set_mime_type (_tmp13_, _tmp15_);
	_tmp16_ = item;
	_tmp17_ = vd;
	rygel_media_file_item_set_size (_tmp16_, rygel_media_export_item_factory_get_int64 (_tmp17_, RYGEL_MEDIA_EXPORT_SERIALIZER_SIZE));
	_tmp18_ = vd;
	_tmp19_ = expected;
	_tmp20_ = g_variant_dict_lookup_value (_tmp18_, RYGEL_MEDIA_EXPORT_SERIALIZER_MODIFIED, _tmp19_);
	_g_variant_unref0 (val);
	val = _tmp20_;
	_tmp21_ = item;
	_tmp22_ = val;
	rygel_media_object_set_modified ((RygelMediaObject*) _tmp21_, g_variant_get_uint64 (_tmp22_));
	_tmp23_ = vd;
	_tmp24_ = expected;
	_tmp25_ = g_variant_dict_lookup_value (_tmp23_, RYGEL_MEDIA_EXPORT_SERIALIZER_DLNA_PROFILE, _tmp24_);
	_g_variant_unref0 (val);
	val = _tmp25_;
	_tmp26_ = val;
	if (_tmp26_ != NULL) {
		RygelMediaFileItem* _tmp27_;
		GVariant* _tmp28_;
		const gchar* _tmp29_;
		_tmp27_ = item;
		_tmp28_ = val;
		_tmp29_ = g_variant_get_string (_tmp28_, NULL);
		rygel_media_file_item_set_dlna_profile (_tmp27_, _tmp29_);
	}
	_tmp30_ = vd;
	_tmp31_ = expected;
	_tmp32_ = g_variant_dict_lookup_value (_tmp30_, RYGEL_MEDIA_EXPORT_SERIALIZER_DATE, _tmp31_);
	_g_variant_unref0 (val);
	val = _tmp32_;
	_tmp33_ = val;
	if (_tmp33_ != NULL) {
		RygelMediaFileItem* _tmp34_;
		GVariant* _tmp35_;
		const gchar* _tmp36_;
		_tmp34_ = item;
		_tmp35_ = val;
		_tmp36_ = g_variant_get_string (_tmp35_, NULL);
		rygel_media_object_set_date ((RygelMediaObject*) _tmp34_, _tmp36_);
	}
	_tmp37_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, RYGEL_TYPE_AUDIO_ITEM)) {
		RygelAudioItem* audio_item = NULL;
		RygelMediaFileItem* _tmp38_;
		RygelAudioItem* _tmp39_;
		RygelAudioItem* _tmp40_;
		GVariantDict* _tmp41_;
		RygelAudioItem* _tmp42_;
		GVariantDict* _tmp43_;
		RygelAudioItem* _tmp44_;
		GVariantDict* _tmp45_;
		RygelAudioItem* _tmp46_;
		GVariantDict* _tmp47_;
		RygelMediaFileItem* _tmp48_;
		_tmp38_ = item;
		_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, RYGEL_TYPE_AUDIO_ITEM) ? ((RygelAudioItem*) _tmp38_) : NULL);
		audio_item = _tmp39_;
		_tmp40_ = audio_item;
		_tmp41_ = vd;
		rygel_audio_item_set_duration (_tmp40_, (glong) rygel_media_export_item_factory_get_int32 (_tmp41_, RYGEL_MEDIA_EXPORT_SERIALIZER_DURATION));
		_tmp42_ = audio_item;
		_tmp43_ = vd;
		rygel_audio_item_set_bitrate (_tmp42_, (gint) rygel_media_export_item_factory_get_int32 (_tmp43_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_BITRATE));
		_tmp44_ = audio_item;
		_tmp45_ = vd;
		rygel_audio_item_set_channels (_tmp44_, (gint) rygel_media_export_item_factory_get_int32 (_tmp45_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_CHANNELS));
		_tmp46_ = audio_item;
		_tmp47_ = vd;
		rygel_audio_item_set_sample_freq (_tmp46_, (gint) rygel_media_export_item_factory_get_int32 (_tmp47_, RYGEL_MEDIA_EXPORT_SERIALIZER_AUDIO_RATE));
		_tmp48_ = item;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM)) {
			RygelMediaExportMusicItem* music_item = NULL;
			RygelMediaFileItem* _tmp49_;
			RygelMediaExportMusicItem* _tmp50_;
			GVariantDict* _tmp51_;
			const GVariantType* _tmp52_;
			GVariant* _tmp53_;
			GVariant* _tmp54_;
			GVariantDict* _tmp58_;
			const GVariantType* _tmp59_;
			GVariant* _tmp60_;
			GVariant* _tmp61_;
			GVariantDict* _tmp65_;
			const GVariantType* _tmp66_;
			GVariant* _tmp67_;
			GVariant* _tmp68_;
			RygelMediaExportMusicItem* _tmp72_;
			GVariantDict* _tmp73_;
			RygelMediaExportMusicItem* _tmp74_;
			GVariantDict* _tmp75_;
			_tmp49_ = item;
			_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, RYGEL_MEDIA_EXPORT_TYPE_MUSIC_ITEM) ? ((RygelMediaExportMusicItem*) _tmp49_) : NULL);
			music_item = _tmp50_;
			_tmp51_ = vd;
			_tmp52_ = expected;
			_tmp53_ = g_variant_dict_lookup_value (_tmp51_, RYGEL_MEDIA_EXPORT_SERIALIZER_ARTIST, _tmp52_);
			_g_variant_unref0 (val);
			val = _tmp53_;
			_tmp54_ = val;
			if (_tmp54_ != NULL) {
				RygelMediaExportMusicItem* _tmp55_;
				GVariant* _tmp56_;
				const gchar* _tmp57_;
				_tmp55_ = music_item;
				_tmp56_ = val;
				_tmp57_ = g_variant_get_string (_tmp56_, NULL);
				rygel_media_object_set_artist ((RygelMediaObject*) _tmp55_, _tmp57_);
			}
			_tmp58_ = vd;
			_tmp59_ = expected;
			_tmp60_ = g_variant_dict_lookup_value (_tmp58_, RYGEL_MEDIA_EXPORT_SERIALIZER_ALBUM, _tmp59_);
			_g_variant_unref0 (val);
			val = _tmp60_;
			_tmp61_ = val;
			if (_tmp61_ != NULL) {
				RygelMediaExportMusicItem* _tmp62_;
				GVariant* _tmp63_;
				const gchar* _tmp64_;
				_tmp62_ = music_item;
				_tmp63_ = val;
				_tmp64_ = g_variant_get_string (_tmp63_, NULL);
				rygel_audio_item_set_album ((RygelAudioItem*) _tmp62_, _tmp64_);
			}
			_tmp65_ = vd;
			_tmp66_ = expected;
			_tmp67_ = g_variant_dict_lookup_value (_tmp65_, RYGEL_MEDIA_EXPORT_SERIALIZER_GENRE, _tmp66_);
			_g_variant_unref0 (val);
			val = _tmp67_;
			_tmp68_ = val;
			if (_tmp68_ != NULL) {
				RygelMediaExportMusicItem* _tmp69_;
				GVariant* _tmp70_;
				const gchar* _tmp71_;
				_tmp69_ = music_item;
				_tmp70_ = val;
				_tmp71_ = g_variant_get_string (_tmp70_, NULL);
				rygel_media_object_set_genre ((RygelMediaObject*) _tmp69_, _tmp71_);
			}
			_tmp72_ = music_item;
			_tmp73_ = vd;
			rygel_music_item_set_track_number ((RygelMusicItem*) _tmp72_, (gint) rygel_media_export_item_factory_get_int32 (_tmp73_, RYGEL_MEDIA_EXPORT_SERIALIZER_TRACK_NUMBER));
			_tmp74_ = music_item;
			_tmp75_ = vd;
			_tmp74_->disc = (gint) rygel_media_export_item_factory_get_int32 (_tmp75_, RYGEL_MEDIA_EXPORT_SERIALIZER_VOLUME_NUMBER);
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	_tmp76_ = item;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp76_, RYGEL_TYPE_VISUAL_ITEM)) {
		RygelVisualItem* visual_item = NULL;
		RygelMediaFileItem* _tmp77_;
		RygelVisualItem* _tmp78_;
		RygelVisualItem* _tmp79_;
		GVariantDict* _tmp80_;
		RygelVisualItem* _tmp81_;
		GVariantDict* _tmp82_;
		RygelVisualItem* _tmp83_;
		GVariantDict* _tmp84_;
		_tmp77_ = item;
		_tmp78_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp77_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp77_) : NULL);
		visual_item = _tmp78_;
		_tmp79_ = visual_item;
		_tmp80_ = vd;
		rygel_visual_item_set_width (_tmp79_, (gint) rygel_media_export_item_factory_get_int32 (_tmp80_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_WIDTH));
		_tmp81_ = visual_item;
		_tmp82_ = vd;
		rygel_visual_item_set_height (_tmp81_, (gint) rygel_media_export_item_factory_get_int32 (_tmp82_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_HEIGHT));
		_tmp83_ = visual_item;
		_tmp84_ = vd;
		rygel_visual_item_set_color_depth (_tmp83_, (gint) rygel_media_export_item_factory_get_int32 (_tmp84_, RYGEL_MEDIA_EXPORT_SERIALIZER_VIDEO_DEPTH));
		_g_object_unref0 (visual_item);
	}
	_tmp85_ = item;
	_tmp86_ = _g_object_ref0 ((RygelMediaObject*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp85_, RYGEL_TYPE_MEDIA_FILE_ITEM) ? ((RygelMediaFileItem*) _tmp85_) : NULL));
	result = _tmp86_;
	_g_variant_unref0 (val);
	_g_object_unref0 (item);
	_g_object_unref0 (object);
	_g_variant_unref0 (upnp_class);
	_g_variant_dict_unref0 (vd);
	_g_variant_type_free0 (expected);
	return result;
}



