/* rygel-http-time-seek-request.c generated by valac 0.42.2, the Vala compiler
 * generated from rygel-http-time-seek-request.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include <float.h>
#include <math.h>


#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;
typedef struct _RygelHTTPSeekRequestPrivate RygelHTTPSeekRequestPrivate;

#define RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST (rygel_http_time_seek_request_get_type ())
#define RYGEL_HTTP_TIME_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequest))
#define RYGEL_HTTP_TIME_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequestClass))
#define RYGEL_IS_HTTP_TIME_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST))
#define RYGEL_IS_HTTP_TIME_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST))
#define RYGEL_HTTP_TIME_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequestClass))

typedef struct _RygelHTTPTimeSeekRequest RygelHTTPTimeSeekRequest;
typedef struct _RygelHTTPTimeSeekRequestClass RygelHTTPTimeSeekRequestClass;
typedef struct _RygelHTTPTimeSeekRequestPrivate RygelHTTPTimeSeekRequestPrivate;
enum  {
	RYGEL_HTTP_TIME_SEEK_REQUEST_0_PROPERTY,
	RYGEL_HTTP_TIME_SEEK_REQUEST_NUM_PROPERTIES
};
static GParamSpec* rygel_http_time_seek_request_properties[RYGEL_HTTP_TIME_SEEK_REQUEST_NUM_PROPERTIES];

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;

#define RYGEL_TYPE_PLAY_SPEED (rygel_play_speed_get_type ())
#define RYGEL_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeed))
#define RYGEL_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))
#define RYGEL_IS_PLAY_SPEED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_IS_PLAY_SPEED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED))
#define RYGEL_PLAY_SPEED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED, RygelPlaySpeedClass))

typedef struct _RygelPlaySpeed RygelPlaySpeed;
typedef struct _RygelPlaySpeedClass RygelPlaySpeedClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelHTTPSeekRequest {
	GObject parent_instance;
	RygelHTTPSeekRequestPrivate * priv;
};

struct _RygelHTTPSeekRequestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPTimeSeekRequest {
	RygelHTTPSeekRequest parent_instance;
	RygelHTTPTimeSeekRequestPrivate * priv;
	gint64 start_time;
	gint64 end_time;
	gint64 range_duration;
	gint64 total_duration;
};

struct _RygelHTTPTimeSeekRequestClass {
	RygelHTTPSeekRequestClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekRequestError;
#define RYGEL_HTTP_SEEK_REQUEST_ERROR rygel_http_seek_request_error_quark ()
typedef enum  {
	RYGEL_CLIENT_HACKS_ERROR_NA
} RygelClientHacksError;
#define RYGEL_CLIENT_HACKS_ERROR rygel_client_hacks_error_quark ()

static gpointer rygel_http_time_seek_request_parent_class = NULL;

GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_http_time_seek_request_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER "TimeSeekRange.dlna.org"
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
gpointer rygel_play_speed_ref (gpointer instance);
void rygel_play_speed_unref (gpointer instance);
GParamSpec* rygel_param_spec_play_speed (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void rygel_value_set_play_speed (GValue* value,
                                 gpointer v_object);
void rygel_value_take_play_speed (GValue* value,
                                  gpointer v_object);
gpointer rygel_value_get_play_speed (const GValue* value);
GType rygel_play_speed_get_type (void) G_GNUC_CONST;
GQuark rygel_http_seek_request_error_quark (void);
RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_new (SoupMessage* message,
                                                            RygelHTTPGetHandler* handler,
                                                            RygelPlaySpeed* speed,
                                                            GError** error);
RygelHTTPTimeSeekRequest* rygel_http_time_seek_request_construct (GType object_type,
                                                                  SoupMessage* message,
                                                                  RygelHTTPGetHandler* handler,
                                                                  RygelPlaySpeed* speed,
                                                                  GError** error);
RygelHTTPSeekRequest* rygel_http_seek_request_construct (GType object_type);
gboolean rygel_play_speed_is_positive (RygelPlaySpeed* self);
gboolean rygel_play_speed_is_normal_rate (RygelPlaySpeed* self);
gint64 rygel_http_get_handler_get_resource_duration (RygelHTTPGetHandler* self);
#define RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED ((gint64) -1)
static gboolean rygel_http_time_seek_request_parse_npt_time (const gchar* range_token,
                                                      gint64* value);
gchar* rygel_http_time_seek_request_to_string (RygelHTTPTimeSeekRequest* self);
gboolean rygel_http_time_seek_request_supported (SoupMessage* message,
                                                 RygelHTTPGetHandler* handler);
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GQuark rygel_client_hacks_error_quark (void);
RygelClientHacks* rygel_client_hacks_create (SoupMessage* message,
                                             GError** error);
gboolean rygel_client_hacks_force_seek (RygelClientHacks* self);
gboolean rygel_http_get_handler_supports_time_seek (RygelHTTPGetHandler* self);
gboolean rygel_http_time_seek_request_requested (SoupMessage* message);
static gboolean rygel_http_time_seek_request_parse_npt_seconds (const gchar* range_token,
                                                         gint64* value);
static void rygel_http_time_seek_request_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
     * Create a HTTPTimeSeekRequest corresponding with a HTTPGet that contains a
     * TimeSeekRange.dlna.org header value.
     *
     * Note: This constructor will check the syntax of the request (per DLNA
     * 7.5.4.3.2.24.3) as well as perform some range validation. If the
     * provided request is associated with a handler that can provide content
     * duration, the start and end time will be checked for out-of-bounds
     * conditions. Additionally, the start and end will be checked according
     * to playspeed direction (with rate +1.0 assumed when speed is not
     * provided). When speed is provided, the range end parameter check is
     * relaxed when the rate is not +1.0 (per DLNA 7.5.4.3.2.24.4).
     *
     * @param request The HTTP GET/HEAD request
     * @param speed An associated speed request
     */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


RygelHTTPTimeSeekRequest*
rygel_http_time_seek_request_construct (GType object_type,
                                        SoupMessage* message,
                                        RygelHTTPGetHandler* handler,
                                        RygelPlaySpeed* speed,
                                        GError** error)
{
	RygelHTTPTimeSeekRequest * self = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean positive_rate = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean trick_mode = FALSE;
	gint64 _tmp2_;
	gchar* range = NULL;
	SoupMessageHeaders* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp8_;
	gchar* parsed_range = NULL;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar** range_tokens = NULL;
	const gchar* _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gint range_tokens_length1;
	gint _range_tokens_size_;
	gint64 start = 0LL;
	gchar** _tmp19_;
	gint _tmp19__length1;
	const gchar* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp24_ = FALSE;
	gint64 _tmp25_;
	gint64 end = 0LL;
	gchar** _tmp38_;
	gint _tmp38__length1;
	const gchar* _tmp39_;
	gboolean _tmp40_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	self = (RygelHTTPTimeSeekRequest*) rygel_http_seek_request_construct (object_type);
	if (speed == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = rygel_play_speed_is_positive (speed);
	}
	positive_rate = _tmp0_;
	if (speed != NULL) {
		_tmp1_ = !rygel_play_speed_is_normal_rate (speed);
	} else {
		_tmp1_ = FALSE;
	}
	trick_mode = _tmp1_;
	self->total_duration = rygel_http_get_handler_get_resource_duration (handler);
	_tmp2_ = self->total_duration;
	if (_tmp2_ <= ((gint64) 0)) {
		self->total_duration = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	}
	_tmp3_ = message->request_headers;
	_tmp4_ = soup_message_headers_get_one (_tmp3_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER);
	_tmp5_ = g_strdup (_tmp4_);
	range = _tmp5_;
	_tmp6_ = range;
	if (_tmp6_ == NULL) {
		GError* _tmp7_;
		_tmp7_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "%s not present", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER);
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = range;
	if (!g_str_has_prefix (_tmp8_, "npt=")) {
		const gchar* _tmp9_;
		GError* _tmp10_;
		_tmp9_ = range;
		_tmp10_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s value (missing npt field): '%s'", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp9_);
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp11_ = range;
	_tmp12_ = string_substring (_tmp11_, (glong) 4, (glong) -1);
	parsed_range = _tmp12_;
	_tmp13_ = parsed_range;
	if (!string_contains (_tmp13_, "-")) {
		const gchar* _tmp14_;
		GError* _tmp15_;
		_tmp14_ = range;
		_tmp15_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s request with no '-': '%s'", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp14_);
		_inner_error_ = _tmp15_;
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (parsed_range);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (parsed_range);
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp16_ = parsed_range;
	_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, "-", 2);
	range_tokens = _tmp18_;
	range_tokens_length1 = _vala_array_length (_tmp17_);
	_range_tokens_size_ = range_tokens_length1;
	start = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	_tmp19_ = range_tokens;
	_tmp19__length1 = range_tokens_length1;
	_tmp20_ = _tmp19_[0];
	_tmp21_ = rygel_http_time_seek_request_parse_npt_time (_tmp20_, &start);
	if (!_tmp21_) {
		const gchar* _tmp22_;
		GError* _tmp23_;
		_tmp22_ = range;
		_tmp23_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, "Invalid %s value (no start): '%s'", RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp22_);
		_inner_error_ = _tmp23_;
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			_g_free0 (range);
			_g_object_unref0 (self);
			return NULL;
		} else {
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (parsed_range);
			_g_free0 (range);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp25_ = self->total_duration;
	if (_tmp25_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		gint64 _tmp26_;
		gint64 _tmp27_;
		_tmp26_ = start;
		_tmp27_ = self->total_duration;
		_tmp24_ = _tmp26_ > _tmp27_;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_;
		_tmp29_ = trick_mode;
		if (_tmp29_) {
			gboolean _tmp30_;
			_tmp30_ = positive_rate;
			_tmp28_ = !_tmp30_;
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			gint64 _tmp31_;
			_tmp31_ = self->total_duration;
			self->start_time = _tmp31_;
		} else {
			gchar* msg = NULL;
			gchar* _tmp32_;
			const gchar* _tmp33_;
			gint64 _tmp34_;
			gint64 _tmp35_;
			GError* _tmp36_;
			_tmp32_ = g_strdup ("Invalid %s start time %lldns is beyond the content duration of %lldns");
			msg = _tmp32_;
			_tmp33_ = msg;
			_tmp34_ = start;
			_tmp35_ = self->total_duration;
			_tmp36_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, _tmp33_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp34_, _tmp35_);
			_inner_error_ = _tmp36_;
			if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				_g_free0 (range);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (parsed_range);
				_g_free0 (range);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_free0 (msg);
		}
	} else {
		gint64 _tmp37_;
		_tmp37_ = start;
		self->start_time = _tmp37_;
	}
	end = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	_tmp38_ = range_tokens;
	_tmp38__length1 = range_tokens_length1;
	_tmp39_ = _tmp38_[1];
	_tmp40_ = rygel_http_time_seek_request_parse_npt_time (_tmp39_, &end);
	if (_tmp40_) {
		gboolean _tmp41_;
		_tmp41_ = positive_rate;
		if (_tmp41_) {
			gboolean _tmp42_ = FALSE;
			gint64 _tmp43_;
			gint64 _tmp54_;
			gint64 _tmp55_;
			gint64 _tmp56_;
			_tmp43_ = self->total_duration;
			if (_tmp43_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
				gint64 _tmp44_;
				gint64 _tmp45_;
				_tmp44_ = end;
				_tmp45_ = self->total_duration;
				_tmp42_ = _tmp44_ > _tmp45_;
			} else {
				_tmp42_ = FALSE;
			}
			if (_tmp42_) {
				gboolean _tmp46_;
				_tmp46_ = trick_mode;
				if (_tmp46_) {
					gint64 _tmp47_;
					_tmp47_ = self->total_duration;
					self->end_time = _tmp47_;
				} else {
					gchar* msg = NULL;
					gchar* _tmp48_;
					const gchar* _tmp49_;
					gint64 _tmp50_;
					gint64 _tmp51_;
					GError* _tmp52_;
					_tmp48_ = g_strdup ("Invalid %s start time %lldns is beyond the content duration of %lldns");
					msg = _tmp48_;
					_tmp49_ = msg;
					_tmp50_ = end;
					_tmp51_ = self->total_duration;
					_tmp52_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, _tmp49_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp50_, _tmp51_);
					_inner_error_ = _tmp52_;
					if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (msg);
						range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (parsed_range);
						_g_free0 (range);
						_g_object_unref0 (self);
						return NULL;
					} else {
						_g_free0 (msg);
						range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (parsed_range);
						_g_free0 (range);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_g_free0 (msg);
				}
			} else {
				gint64 _tmp53_;
				_tmp53_ = end;
				self->end_time = _tmp53_;
			}
			_tmp54_ = self->end_time;
			_tmp55_ = self->start_time;
			self->range_duration = _tmp54_ - _tmp55_;
			_tmp56_ = self->range_duration;
			if (_tmp56_ <= ((gint64) 0)) {
				gchar* msg = NULL;
				gchar* _tmp57_;
				const gchar* _tmp58_;
				const gchar* _tmp59_;
				GError* _tmp60_;
				_tmp57_ = g_strdup ("Invalid %s value (start time after end time - forward scan): '%s'");
				msg = _tmp57_;
				_tmp58_ = msg;
				_tmp59_ = range;
				_tmp60_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp58_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp59_);
				_inner_error_ = _tmp60_;
				if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (parsed_range);
					_g_free0 (range);
					_g_object_unref0 (self);
					return NULL;
				} else {
					_g_free0 (msg);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (parsed_range);
					_g_free0 (range);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (msg);
			}
		} else {
			gint64 _tmp61_;
			gint64 _tmp62_;
			gint64 _tmp63_;
			gint64 _tmp64_;
			_tmp61_ = end;
			self->end_time = _tmp61_;
			_tmp62_ = self->start_time;
			_tmp63_ = self->end_time;
			self->range_duration = _tmp62_ - _tmp63_;
			_tmp64_ = self->range_duration;
			if (_tmp64_ <= ((gint64) 0)) {
				gchar* msg = NULL;
				gchar* _tmp65_;
				const gchar* _tmp66_;
				const gchar* _tmp67_;
				GError* _tmp68_;
				_tmp65_ = g_strdup ("Invalid %s value (start time before end time - reverse scan): '%s'");
				msg = _tmp65_;
				_tmp66_ = msg;
				_tmp67_ = range;
				_tmp68_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp66_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER, _tmp67_);
				_inner_error_ = _tmp68_;
				if (_inner_error_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (msg);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (parsed_range);
					_g_free0 (range);
					_g_object_unref0 (self);
					return NULL;
				} else {
					_g_free0 (msg);
					range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (parsed_range);
					_g_free0 (range);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_g_free0 (msg);
			}
		}
	} else {
		gint64 _tmp69_;
		self->end_time = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
		_tmp69_ = self->total_duration;
		if (_tmp69_ == RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
			self->range_duration = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
		} else {
			gboolean _tmp70_;
			_tmp70_ = positive_rate;
			if (_tmp70_) {
				gint64 _tmp71_;
				gint64 _tmp72_;
				gint64 _tmp73_;
				_tmp71_ = self->total_duration;
				self->end_time = _tmp71_ - G_TIME_SPAN_MILLISECOND;
				_tmp72_ = self->total_duration;
				_tmp73_ = self->start_time;
				self->range_duration = _tmp72_ - _tmp73_;
			} else {
				gint64 _tmp74_;
				self->end_time = (gint64) 0;
				_tmp74_ = self->start_time;
				self->range_duration = _tmp74_;
			}
		}
	}
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (parsed_range);
	_g_free0 (range);
	return self;
}


RygelHTTPTimeSeekRequest*
rygel_http_time_seek_request_new (SoupMessage* message,
                                  RygelHTTPGetHandler* handler,
                                  RygelPlaySpeed* speed,
                                  GError** error)
{
	return rygel_http_time_seek_request_construct (RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, message, handler, speed, error);
}


gchar*
rygel_http_time_seek_request_to_string (RygelHTTPTimeSeekRequest* self)
{
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gint64 _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->end_time;
	if (_tmp1_ != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		gint64 _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->end_time;
		_tmp3_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("*");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = self->start_time;
	_tmp6_ = g_strdup_printf ("HTTPTimeSeekRequest (npt=%lld-%s)", _tmp5_, _tmp0_);
	result = _tmp6_;
	_g_free0 (_tmp0_);
	return result;
}


/**
     * Return true if time-seek is supported.
     *
     * This method utilizes elements associated with the request to determine if
     * a TimeSeekRange request is supported for the given request/resource.
     */
gboolean
rygel_http_time_seek_request_supported (SoupMessage* message,
                                        RygelHTTPGetHandler* handler)
{
	gboolean result = FALSE;
	gboolean force_seek = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (message != NULL, FALSE);
	g_return_val_if_fail (handler != NULL, FALSE);
	force_seek = FALSE;
	{
		RygelClientHacks* hack = NULL;
		RygelClientHacks* _tmp0_;
		_tmp0_ = rygel_client_hacks_create (message, &_inner_error_);
		hack = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch55_g_error;
		}
		force_seek = rygel_client_hacks_force_seek (hack);
		_g_object_unref0 (hack);
	}
	goto __finally55;
	__catch55_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally55:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp1_;
	}
	_tmp3_ = force_seek;
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = rygel_http_get_handler_supports_time_seek (handler);
	}
	result = _tmp2_;
	return result;
}


/**
     * Return true of the HTTPGet contains a TimeSeekRange request.
     */
gboolean
rygel_http_time_seek_request_requested (SoupMessage* message)
{
	gboolean result = FALSE;
	gchar* header = NULL;
	SoupMessageHeaders* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = message->request_headers;
	_tmp1_ = soup_message_headers_get_one (_tmp0_, RYGEL_HTTP_TIME_SEEK_REQUEST_TIMESEEKRANGE_HEADER);
	_tmp2_ = g_strdup (_tmp1_);
	header = _tmp2_;
	result = header != NULL;
	_g_free0 (header);
	return result;
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static gdouble
double_parse (const gchar* str)
{
	gdouble result = 0.0;
	gdouble _tmp0_;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = g_ascii_strtod (str, NULL);
	result = _tmp0_;
	return result;
}


static gboolean
rygel_http_time_seek_request_parse_npt_seconds (const gchar* range_token,
                                                gint64* value)
{
	gboolean result = FALSE;
	g_return_val_if_fail (range_token != NULL, FALSE);
	if (g_ascii_isdigit (string_get (range_token, (glong) 0))) {
		*value = (gint64) (double_parse (range_token) * G_TIME_SPAN_SECOND);
	} else {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean
rygel_http_time_seek_request_parse_npt_time (const gchar* range_token,
                                             gint64* value)
{
	gboolean result = FALSE;
	gint64 seconds_sum = 0LL;
	gint time_factor = 0;
	gchar** time_tokens = NULL;
	gint time_tokens_length1 = 0;
	gint _time_tokens_size_ = 0;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gint64 _tmp18_;
	if (range_token == NULL) {
		result = FALSE;
		return result;
	}
	if (string_index_of (range_token, ":", 0) == -1) {
		gboolean _tmp0_;
		_tmp0_ = rygel_http_time_seek_request_parse_npt_seconds (range_token, value);
		result = _tmp0_;
		return result;
	}
	seconds_sum = (gint64) 0;
	time_factor = 0;
	seconds_sum = (gint64) 0;
	time_factor = 3600;
	_tmp2_ = _tmp1_ = g_strsplit (range_token, ":", 3);
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
	time_tokens = _tmp2_;
	time_tokens_length1 = _vala_array_length (_tmp1_);
	_time_tokens_size_ = time_tokens_length1;
	_tmp5_ = time_tokens;
	_tmp5__length1 = time_tokens_length1;
	_tmp6_ = _tmp5_[0];
	if (_tmp6_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		_tmp7_ = time_tokens;
		_tmp7__length1 = time_tokens_length1;
		_tmp8_ = _tmp7_[1];
		_tmp4_ = _tmp8_ == NULL;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		_tmp9_ = time_tokens;
		_tmp9__length1 = time_tokens_length1;
		_tmp10_ = _tmp9_[2];
		_tmp3_ = _tmp10_ == NULL;
	}
	if (_tmp3_) {
		result = FALSE;
		time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp11_ = time_tokens;
	_tmp11__length1 = time_tokens_length1;
	{
		gchar** time_collection = NULL;
		gint time_collection_length1 = 0;
		gint _time_collection_size_ = 0;
		gint time_it = 0;
		time_collection = _tmp11_;
		time_collection_length1 = _tmp11__length1;
		for (time_it = 0; time_it < _tmp11__length1; time_it = time_it + 1) {
			gchar* _tmp12_;
			gchar* time = NULL;
			_tmp12_ = g_strdup (time_collection[time_it]);
			time = _tmp12_;
			{
				const gchar* _tmp13_;
				gint _tmp17_;
				_tmp13_ = time;
				if (g_ascii_isdigit (string_get (_tmp13_, (glong) 0))) {
					gint64 _tmp14_;
					const gchar* _tmp15_;
					gint _tmp16_;
					_tmp14_ = seconds_sum;
					_tmp15_ = time;
					_tmp16_ = time_factor;
					seconds_sum = _tmp14_ + ((gint64) ((double_parse (_tmp15_) * G_TIME_SPAN_SECOND) * _tmp16_));
				} else {
					result = FALSE;
					_g_free0 (time);
					time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp17_ = time_factor;
				time_factor = _tmp17_ / 60;
				_g_free0 (time);
			}
		}
	}
	_tmp18_ = seconds_sum;
	*value = _tmp18_;
	result = TRUE;
	time_tokens = (_vala_array_free (time_tokens, time_tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void
rygel_http_time_seek_request_class_init (RygelHTTPTimeSeekRequestClass * klass)
{
	rygel_http_time_seek_request_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_http_time_seek_request_finalize;
}


static void
rygel_http_time_seek_request_instance_init (RygelHTTPTimeSeekRequest * self)
{
}


static void
rygel_http_time_seek_request_finalize (GObject * obj)
{
	RygelHTTPTimeSeekRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_TIME_SEEK_REQUEST, RygelHTTPTimeSeekRequest);
	G_OBJECT_CLASS (rygel_http_time_seek_request_parent_class)->finalize (obj);
}


/**
 * This class represents a DLNA TimeSeekRange request.
 *
 * A TimeSeekRange request can only have a time range ("npt=start-end").
 */
GType
rygel_http_time_seek_request_get_type (void)
{
	static volatile gsize rygel_http_time_seek_request_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_time_seek_request_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPTimeSeekRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_time_seek_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPTimeSeekRequest), 0, (GInstanceInitFunc) rygel_http_time_seek_request_instance_init, NULL };
		GType rygel_http_time_seek_request_type_id;
		rygel_http_time_seek_request_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK_REQUEST, "RygelHTTPTimeSeekRequest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_time_seek_request_type_id__volatile, rygel_http_time_seek_request_type_id);
	}
	return rygel_http_time_seek_request_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



