/* rygel-http-thumbnail-handler.c generated by valac 0.42.2, the Vala compiler
 * generated from rygel-http-thumbnail-handler.vala, do not modify */

/*
 * Copyright (C) 2008, 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;

#define RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER (rygel_http_thumbnail_handler_get_type ())
#define RYGEL_HTTP_THUMBNAIL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandler))
#define RYGEL_HTTP_THUMBNAIL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandlerClass))
#define RYGEL_IS_HTTP_THUMBNAIL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER))
#define RYGEL_IS_HTTP_THUMBNAIL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER))
#define RYGEL_HTTP_THUMBNAIL_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandlerClass))

typedef struct _RygelHTTPThumbnailHandler RygelHTTPThumbnailHandler;
typedef struct _RygelHTTPThumbnailHandlerClass RygelHTTPThumbnailHandlerClass;
typedef struct _RygelHTTPThumbnailHandlerPrivate RygelHTTPThumbnailHandlerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
enum  {
	RYGEL_HTTP_THUMBNAIL_HANDLER_0_PROPERTY,
	RYGEL_HTTP_THUMBNAIL_HANDLER_NUM_PROPERTIES
};
static GParamSpec* rygel_http_thumbnail_handler_properties[RYGEL_HTTP_THUMBNAIL_HANDLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define RYGEL_TYPE_MEDIA_RESOURCE (rygel_media_resource_get_type ())
#define RYGEL_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResource))
#define RYGEL_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))
#define RYGEL_IS_MEDIA_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_IS_MEDIA_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_RESOURCE))
#define RYGEL_MEDIA_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_RESOURCE, RygelMediaResourceClass))

typedef struct _RygelMediaResource RygelMediaResource;
typedef struct _RygelMediaResourceClass RygelMediaResourceClass;

#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK_REQUEST (rygel_http_seek_request_get_type ())
#define RYGEL_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequest))
#define RYGEL_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))
#define RYGEL_IS_HTTP_SEEK_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_IS_HTTP_SEEK_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK_REQUEST))
#define RYGEL_HTTP_SEEK_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK_REQUEST, RygelHTTPSeekRequestClass))

typedef struct _RygelHTTPSeekRequest RygelHTTPSeekRequest;
typedef struct _RygelHTTPSeekRequestClass RygelHTTPSeekRequestClass;

#define RYGEL_TYPE_PLAY_SPEED_REQUEST (rygel_play_speed_request_get_type ())
#define RYGEL_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequest))
#define RYGEL_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))
#define RYGEL_IS_PLAY_SPEED_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_IS_PLAY_SPEED_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAY_SPEED_REQUEST))
#define RYGEL_PLAY_SPEED_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAY_SPEED_REQUEST, RygelPlaySpeedRequestClass))

typedef struct _RygelPlaySpeedRequest RygelPlaySpeedRequest;
typedef struct _RygelPlaySpeedRequestClass RygelPlaySpeedRequestClass;

#define RYGEL_TYPE_HTTP_RESPONSE_ELEMENT (rygel_http_response_element_get_type ())
#define RYGEL_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElement))
#define RYGEL_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_IS_HTTP_RESPONSE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT))
#define RYGEL_HTTP_RESPONSE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, RygelHTTPResponseElementClass))

typedef struct _RygelHTTPResponseElement RygelHTTPResponseElement;
typedef struct _RygelHTTPResponseElementClass RygelHTTPResponseElementClass;

#define RYGEL_TYPE_MEDIA_ENGINE (rygel_media_engine_get_type ())
#define RYGEL_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngine))
#define RYGEL_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))
#define RYGEL_IS_MEDIA_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_IS_MEDIA_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ENGINE))
#define RYGEL_MEDIA_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ENGINE, RygelMediaEngineClass))

typedef struct _RygelMediaEngine RygelMediaEngine;
typedef struct _RygelMediaEngineClass RygelMediaEngineClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	gchar* (*get_default_transfer_mode) (RygelHTTPGetHandler* self);
	gboolean (*supports_transfer_mode) (RygelHTTPGetHandler* self, const gchar* mode);
	gint64 (*get_resource_size) (RygelHTTPGetHandler* self);
	gint64 (*get_resource_duration) (RygelHTTPGetHandler* self);
	gboolean (*supports_byte_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_time_seek) (RygelHTTPGetHandler* self);
	gboolean (*supports_playspeed) (RygelHTTPGetHandler* self);
	RygelHTTPResponse* (*render_body) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
};

struct _RygelHTTPThumbnailHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPThumbnailHandlerPrivate * priv;
};

struct _RygelHTTPThumbnailHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPThumbnailHandlerPrivate {
	RygelMediaFileItem* media_item;
	gint thumbnail_index;
	RygelThumbnail* thumbnail;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	GeeList* (*preroll) (RygelDataSource* self, RygelHTTPSeekRequest* seek, RygelPlaySpeedRequest* playspeed, GError** error);
	void (*start) (RygelDataSource* self, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};


static gint RygelHTTPThumbnailHandler_private_offset;
static gpointer rygel_http_thumbnail_handler_parent_class = NULL;

GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_request_error_quark (void);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
GType rygel_http_thumbnail_handler_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
RygelHTTPThumbnailHandler* rygel_http_thumbnail_handler_new (RygelMediaFileItem* media_item,
                                                             gint thumbnail_index,
                                                             GCancellable* cancellable,
                                                             GError** error);
RygelHTTPThumbnailHandler* rygel_http_thumbnail_handler_construct (GType object_type,
                                                                   RygelMediaFileItem* media_item,
                                                                   gint thumbnail_index,
                                                                   GCancellable* cancellable,
                                                                   GError** error);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type);
void rygel_http_get_handler_set_cancellable (RygelHTTPGetHandler* self,
                                             GCancellable* value);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
RygelThumbnail* rygel_music_item_get_album_art (RygelMusicItem* self);
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
GeeArrayList* rygel_visual_item_get_thumbnails (RygelVisualItem* self);
const gchar* rygel_media_object_get_id (RygelMediaObject* self);
static gboolean rygel_http_thumbnail_handler_real_supports_transfer_mode (RygelHTTPGetHandler* base,
                                                                   const gchar* mode);
#define RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_STREAMING "Streaming"
static void rygel_http_thumbnail_handler_real_add_response_headers (RygelHTTPGetHandler* base,
                                                             RygelHTTPGet* request,
                                                             GError** error);
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType rygel_media_resource_get_type (void) G_GNUC_CONST;
RygelMediaResource* rygel_thumbnail_get_resource (RygelThumbnail* self,
                                                  const gchar* protocol,
                                                  gint index);
gchar* rygel_http_server_get_protocol (RygelHTTPServer* self);
GUPnPProtocolInfo* rygel_media_resource_get_protocol_info (RygelMediaResource* self,
                                                           GHashTable* replacements);
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self,
                                                  RygelHTTPGet* request,
                                                  GError** error);
static RygelHTTPResponse* rygel_http_thumbnail_handler_real_render_body (RygelHTTPGetHandler* base,
                                                                  RygelHTTPGet* request,
                                                                  GError** error);
GType rygel_http_seek_request_get_type (void) G_GNUC_CONST;
GType rygel_play_speed_request_get_type (void) G_GNUC_CONST;
GType rygel_http_response_element_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_media_engine_get_type (void) G_GNUC_CONST;
RygelMediaEngine* rygel_media_engine_get_default (void);
RygelDataSource* rygel_media_engine_create_data_source_for_uri (RygelMediaEngine* self,
                                                                const gchar* uri,
                                                                GError** error);
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* request,
                                            RygelHTTPGetHandler* request_handler,
                                            RygelDataSource* src,
                                            GError** error);
RygelHTTPResponse* rygel_http_response_construct (GType object_type,
                                                  RygelHTTPGet* request,
                                                  RygelHTTPGetHandler* request_handler,
                                                  RygelDataSource* src,
                                                  GError** error);
static gint64 rygel_http_thumbnail_handler_real_get_resource_size (RygelHTTPGetHandler* base);
static gboolean rygel_http_thumbnail_handler_real_supports_byte_seek (RygelHTTPGetHandler* base);
static void rygel_http_thumbnail_handler_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static inline gpointer
rygel_http_thumbnail_handler_get_instance_private (RygelHTTPThumbnailHandler* self)
{
	return G_STRUCT_MEMBER_P (self, RygelHTTPThumbnailHandler_private_offset);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static gpointer
_rygel_icon_info_ref0 (gpointer self)
{
	return self ? rygel_icon_info_ref (self) : NULL;
}


RygelHTTPThumbnailHandler*
rygel_http_thumbnail_handler_construct (GType object_type,
                                        RygelMediaFileItem* media_item,
                                        gint thumbnail_index,
                                        GCancellable* cancellable,
                                        GError** error)
{
	RygelHTTPThumbnailHandler * self = NULL;
	RygelMediaFileItem* _tmp0_;
	RygelThumbnail* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (media_item != NULL, NULL);
	self = (RygelHTTPThumbnailHandler*) rygel_http_get_handler_construct (object_type);
	_tmp0_ = _g_object_ref0 (media_item);
	_g_object_unref0 (self->priv->media_item);
	self->priv->media_item = _tmp0_;
	self->priv->thumbnail_index = thumbnail_index;
	rygel_http_get_handler_set_cancellable ((RygelHTTPGetHandler*) self, cancellable);
	if (G_TYPE_CHECK_INSTANCE_TYPE (media_item, RYGEL_TYPE_MUSIC_ITEM)) {
		RygelMusicItem* music_item = NULL;
		RygelMusicItem* _tmp1_;
		RygelMusicItem* _tmp2_;
		RygelThumbnail* _tmp3_;
		RygelThumbnail* _tmp4_;
		RygelThumbnail* _tmp5_;
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (media_item, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) media_item) : NULL);
		music_item = _tmp1_;
		_tmp2_ = music_item;
		_tmp3_ = rygel_music_item_get_album_art (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _rygel_icon_info_ref0 (_tmp4_);
		_rygel_icon_info_unref0 (self->priv->thumbnail);
		self->priv->thumbnail = _tmp5_;
		_g_object_unref0 (music_item);
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (media_item, RYGEL_TYPE_VISUAL_ITEM)) {
			RygelVisualItem* visual_item = NULL;
			RygelVisualItem* _tmp6_;
			RygelVisualItem* _tmp7_;
			GeeArrayList* _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (media_item, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) media_item) : NULL);
			visual_item = _tmp6_;
			_tmp7_ = visual_item;
			_tmp8_ = rygel_visual_item_get_thumbnails (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			if (thumbnail_index < _tmp11_) {
				RygelVisualItem* _tmp12_;
				GeeArrayList* _tmp13_;
				GeeArrayList* _tmp14_;
				gpointer _tmp15_;
				_tmp12_ = visual_item;
				_tmp13_ = rygel_visual_item_get_thumbnails (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, thumbnail_index);
				_rygel_icon_info_unref0 (self->priv->thumbnail);
				self->priv->thumbnail = (RygelThumbnail*) _tmp15_;
			}
			_g_object_unref0 (visual_item);
		}
	}
	_tmp16_ = self->priv->thumbnail;
	if (_tmp16_ == NULL) {
		gchar* msg = NULL;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		GError* _tmp21_;
		_tmp17_ = g_strdup ("Thumbnail index %d not found for item '%s");
		msg = _tmp17_;
		_tmp18_ = msg;
		_tmp19_ = rygel_media_object_get_id ((RygelMediaObject*) media_item);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp18_, thumbnail_index, _tmp20_);
		_inner_error_ = _tmp21_;
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (msg);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_free0 (msg);
	}
	return self;
}


RygelHTTPThumbnailHandler*
rygel_http_thumbnail_handler_new (RygelMediaFileItem* media_item,
                                  gint thumbnail_index,
                                  GCancellable* cancellable,
                                  GError** error)
{
	return rygel_http_thumbnail_handler_construct (RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, media_item, thumbnail_index, cancellable, error);
}


static gboolean
rygel_http_thumbnail_handler_real_supports_transfer_mode (RygelHTTPGetHandler* base,
                                                          const gchar* mode)
{
	RygelHTTPThumbnailHandler * self;
	gboolean result = FALSE;
	self = (RygelHTTPThumbnailHandler*) base;
	g_return_val_if_fail (mode != NULL, FALSE);
	result = g_strcmp0 (mode, RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_STREAMING) != 0;
	return result;
}


static void
rygel_http_thumbnail_handler_real_add_response_headers (RygelHTTPGetHandler* base,
                                                        RygelHTTPGet* request,
                                                        GError** error)
{
	RygelHTTPThumbnailHandler * self;
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	RygelThumbnail* _tmp2_;
	const gchar* _tmp3_;
	RygelMediaResource* res = NULL;
	RygelThumbnail* _tmp4_;
	RygelHTTPServer* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_;
	RygelMediaResource* _tmp9_;
	RygelMediaResource* _tmp10_;
	gchar* protocol_info = NULL;
	GUPnPProtocolInfo* _tmp11_;
	GUPnPProtocolInfo* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** pi_fields = NULL;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint pi_fields_length1;
	gint _pi_fields_size_;
	SoupMessage* _tmp17_;
	SoupMessageHeaders* _tmp18_;
	const gchar* _tmp19_;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPThumbnailHandler*) base;
	g_return_if_fail (request != NULL);
	_tmp0_ = ((RygelHTTPRequest*) request)->msg;
	_tmp1_ = _tmp0_->response_headers;
	_tmp2_ = self->priv->thumbnail;
	_tmp3_ = ((RygelIconInfo*) _tmp2_)->mime_type;
	soup_message_headers_append (_tmp1_, "Content-Type", _tmp3_);
	_tmp4_ = self->priv->thumbnail;
	_tmp5_ = ((RygelHTTPRequest*) request)->http_server;
	_tmp6_ = rygel_http_server_get_protocol (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->thumbnail_index;
	_tmp9_ = rygel_thumbnail_get_resource (_tmp4_, _tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp7_);
	res = _tmp10_;
	_tmp11_ = rygel_media_resource_get_protocol_info (res, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = gupnp_protocol_info_to_string (_tmp12_);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp12_);
	protocol_info = _tmp14_;
	_tmp16_ = _tmp15_ = g_strsplit (protocol_info, ":", 4);
	pi_fields = _tmp16_;
	pi_fields_length1 = _vala_array_length (_tmp15_);
	_pi_fields_size_ = pi_fields_length1;
	_tmp17_ = ((RygelHTTPRequest*) request)->msg;
	_tmp18_ = _tmp17_->response_headers;
	_tmp19_ = pi_fields[3];
	soup_message_headers_append (_tmp18_, "contentFeatures.dlna.org", _tmp19_);
	RYGEL_HTTP_GET_HANDLER_CLASS (rygel_http_thumbnail_handler_parent_class)->add_response_headers (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler), request, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (protocol_info);
			_g_object_unref0 (res);
			return;
		} else {
			pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (protocol_info);
			_g_object_unref0 (res);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	pi_fields = (_vala_array_free (pi_fields, pi_fields_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (protocol_info);
	_g_object_unref0 (res);
}


static RygelHTTPResponse*
rygel_http_thumbnail_handler_real_render_body (RygelHTTPGetHandler* base,
                                               RygelHTTPGet* request,
                                               GError** error)
{
	RygelHTTPThumbnailHandler * self;
	RygelHTTPResponse* result = NULL;
	RygelDataSource* src = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPThumbnailHandler*) base;
	g_return_val_if_fail (request != NULL, NULL);
	{
		RygelMediaEngine* engine = NULL;
		RygelMediaEngine* _tmp0_;
		RygelDataSource* _tmp1_ = NULL;
		RygelMediaEngine* _tmp2_;
		RygelThumbnail* _tmp3_;
		const gchar* _tmp4_;
		RygelDataSource* _tmp5_;
		RygelDataSource* _tmp6_;
		RygelHTTPResponse* _tmp7_ = NULL;
		RygelDataSource* _tmp8_;
		RygelHTTPResponse* _tmp9_;
		RygelHTTPResponse* _tmp10_;
		_tmp0_ = rygel_media_engine_get_default ();
		engine = _tmp0_;
		_tmp2_ = engine;
		_tmp3_ = self->priv->thumbnail;
		_tmp4_ = ((RygelIconInfo*) _tmp3_)->uri;
		_tmp5_ = rygel_media_engine_create_data_source_for_uri (_tmp2_, _tmp4_, &_inner_error_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (engine);
			goto __catch43_g_error;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (src);
		src = _tmp6_;
		_tmp8_ = src;
		_tmp9_ = rygel_http_response_new (request, (RygelHTTPGetHandler*) self, _tmp8_, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			_g_object_unref0 (engine);
			goto __catch43_g_error;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp1_);
		_g_object_unref0 (engine);
		_g_object_unref0 (src);
		return result;
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError* err = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		GError* _tmp13_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = err;
		_tmp12_ = _tmp11_->message;
		_tmp13_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp12_);
		_inner_error_ = _tmp13_;
		_g_error_free0 (err);
		goto __finally43;
	}
	__finally43:
	if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (src);
		return NULL;
	} else {
		_g_object_unref0 (src);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (src);
}


static gint64
rygel_http_thumbnail_handler_real_get_resource_size (RygelHTTPGetHandler* base)
{
	RygelHTTPThumbnailHandler * self;
	gint64 result = 0LL;
	RygelThumbnail* _tmp0_;
	gint64 _tmp1_;
	self = (RygelHTTPThumbnailHandler*) base;
	_tmp0_ = self->priv->thumbnail;
	_tmp1_ = ((RygelIconInfo*) _tmp0_)->size;
	result = _tmp1_;
	return result;
}


static gboolean
rygel_http_thumbnail_handler_real_supports_byte_seek (RygelHTTPGetHandler* base)
{
	RygelHTTPThumbnailHandler * self;
	gboolean result = FALSE;
	self = (RygelHTTPThumbnailHandler*) base;
	result = TRUE;
	return result;
}


static void
rygel_http_thumbnail_handler_class_init (RygelHTTPThumbnailHandlerClass * klass)
{
	rygel_http_thumbnail_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelHTTPThumbnailHandler_private_offset);
	((RygelHTTPGetHandlerClass *) klass)->supports_transfer_mode = (gboolean (*) (RygelHTTPGetHandler *, const gchar*)) rygel_http_thumbnail_handler_real_supports_transfer_mode;
	((RygelHTTPGetHandlerClass *) klass)->add_response_headers = (void (*) (RygelHTTPGetHandler *, RygelHTTPGet*, GError**)) rygel_http_thumbnail_handler_real_add_response_headers;
	((RygelHTTPGetHandlerClass *) klass)->render_body = (RygelHTTPResponse* (*) (RygelHTTPGetHandler *, RygelHTTPGet*, GError**)) rygel_http_thumbnail_handler_real_render_body;
	((RygelHTTPGetHandlerClass *) klass)->get_resource_size = (gint64 (*) (RygelHTTPGetHandler *)) rygel_http_thumbnail_handler_real_get_resource_size;
	((RygelHTTPGetHandlerClass *) klass)->supports_byte_seek = (gboolean (*) (RygelHTTPGetHandler *)) rygel_http_thumbnail_handler_real_supports_byte_seek;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_thumbnail_handler_finalize;
}


static void
rygel_http_thumbnail_handler_instance_init (RygelHTTPThumbnailHandler * self)
{
	self->priv = rygel_http_thumbnail_handler_get_instance_private (self);
}


static void
rygel_http_thumbnail_handler_finalize (GObject * obj)
{
	RygelHTTPThumbnailHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_THUMBNAIL_HANDLER, RygelHTTPThumbnailHandler);
	_g_object_unref0 (self->priv->media_item);
	_rygel_icon_info_unref0 (self->priv->thumbnail);
	G_OBJECT_CLASS (rygel_http_thumbnail_handler_parent_class)->finalize (obj);
}


GType
rygel_http_thumbnail_handler_get_type (void)
{
	static volatile gsize rygel_http_thumbnail_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_thumbnail_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPThumbnailHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_thumbnail_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPThumbnailHandler), 0, (GInstanceInitFunc) rygel_http_thumbnail_handler_instance_init, NULL };
		GType rygel_http_thumbnail_handler_type_id;
		rygel_http_thumbnail_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPThumbnailHandler", &g_define_type_info, 0);
		RygelHTTPThumbnailHandler_private_offset = g_type_add_instance_private (rygel_http_thumbnail_handler_type_id, sizeof (RygelHTTPThumbnailHandlerPrivate));
		g_once_init_leave (&rygel_http_thumbnail_handler_type_id__volatile, rygel_http_thumbnail_handler_type_id);
	}
	return rygel_http_thumbnail_handler_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



