/* rygel-searchable-container.c generated by valac 0.18.0.2-2c22, the Vala compiler
 * generated from rygel-searchable-container.vala, do not modify */

/*
 * Copyright (C) 2008,2010 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2010 MediaNet Inh.
 * Copyright (C) 2010 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define TYPE_MEDIA_OBJECT (media_object_get_type ())
#define MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECT, MediaObject))
#define MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_OBJECT, MediaObjectClass))
#define IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECT))
#define IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_OBJECT))
#define MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_OBJECT, MediaObjectClass))

typedef struct _MediaObject MediaObject;
typedef struct _MediaObjectClass MediaObjectClass;

#define TYPE_MEDIA_CONTAINER (media_container_get_type ())
#define MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_CONTAINER, MediaContainer))
#define MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_CONTAINER, MediaContainerClass))
#define IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_CONTAINER))
#define IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_CONTAINER))
#define MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_CONTAINER, MediaContainerClass))

typedef struct _MediaContainer MediaContainer;
typedef struct _MediaContainerClass MediaContainerClass;

#define RYGEL_TYPE_SEARCHABLE_CONTAINER (rygel_searchable_container_get_type ())
#define RYGEL_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainer))
#define RYGEL_IS_SEARCHABLE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER))
#define RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_SEARCHABLE_CONTAINER, RygelSearchableContainerIface))

typedef struct _RygelSearchableContainer RygelSearchableContainer;
typedef struct _RygelSearchableContainerIface RygelSearchableContainerIface;

#define TYPE_SEARCH_EXPRESSION (search_expression_get_type ())
#define SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_EXPRESSION, SearchExpression))
#define SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_EXPRESSION, SearchExpressionClass))
#define IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_EXPRESSION))
#define IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_EXPRESSION))
#define SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_EXPRESSION, SearchExpressionClass))

typedef struct _SearchExpression SearchExpression;
typedef struct _SearchExpressionClass SearchExpressionClass;

#define TYPE_MEDIA_OBJECTS (media_objects_get_type ())
#define MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_OBJECTS, MediaObjects))
#define MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_OBJECTS, MediaObjectsClass))
#define IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_OBJECTS))
#define IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_OBJECTS))
#define MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_OBJECTS, MediaObjectsClass))

typedef struct _MediaObjects MediaObjects;
typedef struct _MediaObjectsClass MediaObjectsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MediaObjectPrivate MediaObjectPrivate;
typedef struct _MediaContainerPrivate MediaContainerPrivate;
typedef struct _RygelSearchableContainerSimpleSearchData RygelSearchableContainerSimpleSearchData;

#define TYPE_RELATIONAL_EXPRESSION (relational_expression_get_type ())
#define RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RELATIONAL_EXPRESSION, RelationalExpression))
#define RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RELATIONAL_EXPRESSION, RelationalExpressionClass))
#define IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RELATIONAL_EXPRESSION))
#define IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RELATIONAL_EXPRESSION))
#define RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RELATIONAL_EXPRESSION, RelationalExpressionClass))

typedef struct _RelationalExpression RelationalExpression;
typedef struct _RelationalExpressionClass RelationalExpressionClass;
typedef struct _SearchExpressionPrivate SearchExpressionPrivate;
typedef struct _RygelSearchableContainerFindObjectData RygelSearchableContainerFindObjectData;
typedef struct _RygelSearchableContainerSearchInChildrenData RygelSearchableContainerSearchInChildrenData;

struct _RygelSearchableContainerIface {
	GTypeInterface parent_iface;
	void (*search) (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	MediaObjects* (*search_finish) (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	GeeArrayList* (*get_search_classes) (RygelSearchableContainer* self);
	void (*set_search_classes) (RygelSearchableContainer* self, GeeArrayList* value);
};

struct _MediaObject {
	GObject parent_instance;
	MediaObjectPrivate * priv;
};

struct _MediaObjectClass {
	GObjectClass parent_class;
};

struct _MediaContainer {
	MediaObject parent_instance;
	MediaContainerPrivate * priv;
	gchar* sort_criteria;
	guint child_count;
};

struct _MediaContainerClass {
	MediaObjectClass parent_class;
};

struct _RygelSearchableContainerSimpleSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	SearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	gchar* sort_criteria;
	GCancellable* cancellable;
	MediaObjects* result;
	MediaObjects* _tmp0_;
	MediaObjects* _result_;
	guint _tmp1_;
	const gchar* _tmp2_;
	GCancellable* _tmp3_;
	MediaObjects* _tmp4_;
	MediaObjects* children;
	guint limit;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	MediaObjects* _tmp8_;
	MediaObjects* _tmp9_;
	MediaObjects* _child_list;
	MediaObjects* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _child_size;
	gint _child_index;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	MediaObjects* _tmp16_;
	gint _tmp17_;
	gpointer _tmp18_;
	MediaObject* child;
	gboolean _tmp19_;
	SearchExpression* _tmp20_;
	SearchExpression* _tmp21_;
	MediaObject* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	MediaObjects* _tmp25_;
	MediaObject* _tmp26_;
	gboolean _tmp27_;
	guint _tmp28_;
	MediaObjects* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	guint _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	guint _tmp35_;
	MediaObjects* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	guint _tmp39_;
	gboolean _tmp40_;
	guint _tmp41_;
	guint _tmp42_;
	guint _tmp43_;
	MediaObjects* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	guint _tmp47_;
	guint child_limit;
	SearchExpression* _tmp48_;
	MediaObjects* _tmp49_;
	guint _tmp50_;
	const gchar* _tmp51_;
	GCancellable* _tmp52_;
	MediaObjects* _tmp53_;
	MediaObjects* child_results;
	MediaObjects* _tmp54_;
	MediaObjects* _tmp55_;
	guint _tmp56_;
	MediaObjects* _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	guint _tmp60_;
	MediaObjects* _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	MediaObjects* _tmp64_;
	gboolean _tmp65_;
	MediaObjects* _tmp66_;
	gint _tmp67_;
	gint _tmp68_;
	gboolean _tmp69_;
	guint _tmp70_;
	guint _tmp71_;
	gboolean _tmp72_;
	gboolean _tmp73_;
	guint stop;
	gboolean _tmp74_;
	guint _tmp75_;
	guint _tmp76_;
	guint _tmp77_;
	MediaObjects* _tmp78_;
	gint _tmp79_;
	gint _tmp80_;
	gboolean _tmp81_;
	guint _tmp82_;
	guint _tmp83_;
	MediaObjects* _tmp84_;
	gint _tmp85_;
	gint _tmp86_;
	MediaObjects* _tmp87_;
	guint _tmp88_;
	guint _tmp89_;
	GeeList* _tmp90_;
	GError * _inner_error_;
};

struct _SearchExpression {
	GObject parent_instance;
	SearchExpressionPrivate * priv;
	gchar* operand1;
	gchar* operand2;
	gchar* op;
};

struct _SearchExpressionClass {
	GObjectClass parent_class;
};

struct _RygelSearchableContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	gchar* id;
	GCancellable* cancellable;
	MediaObject* result;
	RelationalExpression* _tmp0_;
	RelationalExpression* expression;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	guint total_matches;
	GCancellable* _tmp5_;
	guint _tmp6_;
	MediaObjects* _tmp7_;
	MediaObjects* results;
	gint _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	GError * _inner_error_;
};

struct _RygelSearchableContainerSearchInChildrenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelSearchableContainer* self;
	SearchExpression* expression;
	MediaObjects* children;
	guint limit;
	gchar* sort_criteria;
	GCancellable* cancellable;
	MediaObjects* result;
	MediaObjects* _tmp0_;
	MediaObjects* _result_;
	MediaObjects* _tmp1_;
	MediaObjects* _tmp2_;
	MediaObjects* _child_list;
	MediaObjects* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _child_size;
	gint _child_index;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	MediaObjects* _tmp9_;
	gint _tmp10_;
	gpointer _tmp11_;
	MediaObject* child;
	MediaObject* _tmp12_;
	MediaObject* _tmp13_;
	RygelSearchableContainer* _tmp14_;
	RygelSearchableContainer* container;
	guint tmp;
	RygelSearchableContainer* _tmp15_;
	SearchExpression* _tmp16_;
	guint _tmp17_;
	const gchar* _tmp18_;
	GCancellable* _tmp19_;
	guint _tmp20_;
	MediaObjects* _tmp21_;
	MediaObjects* child_result;
	MediaObjects* _tmp22_;
	MediaObjects* _tmp23_;
	gboolean _tmp24_;
	guint _tmp25_;
	MediaObjects* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	guint _tmp29_;
	gboolean _tmp30_;
	GError * _inner_error_;
};



GType media_object_get_type (void) G_GNUC_CONST;
GType media_container_get_type (void) G_GNUC_CONST;
GType search_expression_get_type (void) G_GNUC_CONST;
GType media_objects_get_type (void) G_GNUC_CONST;
GType rygel_searchable_container_get_type (void) G_GNUC_CONST;
void rygel_searchable_container_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_searchable_container_simple_search_data_free (gpointer _data);
void rygel_searchable_container_simple_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_);
MediaObjects* media_objects_new (void);
MediaObjects* media_objects_construct (GType object_type);
void media_container_get_children (MediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObjects* media_container_get_children_finish (MediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_searchable_container_simple_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean search_expression_satisfied_by (SearchExpression* self, MediaObject* object);
static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self, SearchExpression* expression, MediaObjects* children, guint limit, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static MediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_searchable_container_find_object_data_free (gpointer _data);
void rygel_searchable_container_find_object (RygelSearchableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
MediaObject* rygel_searchable_container_find_object_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error);
static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_);
RelationalExpression* relational_expression_new (void);
RelationalExpression* relational_expression_construct (GType object_type);
GType relational_expression_get_type (void) G_GNUC_CONST;
#define SEARCH_CRITERIA_OP_EQ "="
static void rygel_searchable_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void rygel_searchable_container_search_in_children_data_free (gpointer _data);
static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_);
static void rygel_searchable_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container);
GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self);
void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value);


void rygel_searchable_container_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search (self, expression, offset, max_count, sort_criteria, cancellable, _callback_, _user_data_);
#line 384 "rygel-searchable-container.c"
}


MediaObjects* rygel_searchable_container_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->search_finish (self, _res_, total_matches, error);
#line 391 "rygel-searchable-container.c"
}


static void rygel_searchable_container_simple_search_data_free (gpointer _data) {
	RygelSearchableContainerSimpleSearchData* _data_;
	_data_ = _data;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->expression);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerSimpleSearchData, _data_);
#line 410 "rygel-searchable-container.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return self ? g_object_ref (self) : NULL;
#line 417 "rygel-searchable-container.c"
}


void rygel_searchable_container_simple_search (RygelSearchableContainer* self, SearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerSimpleSearchData* _data_;
	RygelSearchableContainer* _tmp0_;
	SearchExpression* _tmp1_;
	SearchExpression* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerSimpleSearchData);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, rygel_searchable_container_simple_search);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_simple_search_data_free);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp1_ = expression;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->expression);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->expression = _tmp2_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp3_ = offset;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->offset = _tmp3_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp4_ = max_count;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->max_count = _tmp4_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp5_ = sort_criteria;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->sort_criteria = _tmp6_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp7_ = cancellable;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->cancellable = _tmp8_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_simple_search_co (_data_);
#line 476 "rygel-searchable-container.c"
}


MediaObjects* rygel_searchable_container_simple_search_finish (RygelSearchableContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error) {
	MediaObjects* result;
	RygelSearchableContainerSimpleSearchData* _data_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return NULL;
#line 487 "rygel-searchable-container.c"
	}
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (total_matches) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		*total_matches = _data_->total_matches;
#line 495 "rygel-searchable-container.c"
	}
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	result = _data_->result;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return result;
#line 503 "rygel-searchable-container.c"
}


/**
     * Utility method that retrieves all children and recursively searches for
     * all media objects that satisfy the given search expression in this
     * container.
     *
     * @param expression the search expression or `null` for wildcard
     * @param offset zero-based index of the first object to return
     * @param max_count maximum number of objects to return
     * @param total_matches sets it to the actual number of objects that satisfy
     *                      the given search expression. If it is not possible
     *                      to compute this value (in a timely mannger), it is
     *                      set to '0'.
     * @param cancellable optional cancellable for this operation
     *
     * @return A list of media objects.
     */
static void rygel_searchable_container_simple_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerSimpleSearchData* _data_;
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_simple_search_co (_data_);
#line 533 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_simple_search_co (RygelSearchableContainerSimpleSearchData* _data_) {
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 0:
#line 542 "rygel-searchable-container.c"
		goto _state_0;
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 1:
#line 546 "rygel-searchable-container.c"
		goto _state_1;
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 2:
#line 550 "rygel-searchable-container.c"
		goto _state_2;
		default:
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 555 "rygel-searchable-container.c"
	}
	_state_0:
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp0_ = media_objects_new ();
#line 87 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_result_ = _data_->_tmp0_;
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp1_ = ((MediaContainer*) _data_->self)->child_count;
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp2_ = _data_->sort_criteria;
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp3_ = _data_->cancellable;
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_state_ = 1;
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	media_container_get_children ((MediaContainer*) _data_->self, (guint) 0, _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, rygel_searchable_container_simple_search_ready, _data_);
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 574 "rygel-searchable-container.c"
	_state_1:
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp4_ = NULL;
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp4_ = media_container_get_children_finish ((MediaContainer*) _data_->self, _data_->_res_, &_data_->_inner_error_);
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->children = _data_->_tmp4_;
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_error_free (_data_->_inner_error_);
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_result_);
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 594 "rygel-searchable-container.c"
		} else {
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 598 "rygel-searchable-container.c"
		}
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 89 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 604 "rygel-searchable-container.c"
	}
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp5_ = _data_->max_count;
#line 97 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp5_ > ((guint) 0)) {
#line 98 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp6_ = _data_->offset;
#line 98 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp7_ = _data_->max_count;
#line 98 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->limit = _data_->_tmp6_ + _data_->_tmp7_;
#line 616 "rygel-searchable-container.c"
	} else {
#line 100 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->limit = (guint) 0;
#line 620 "rygel-searchable-container.c"
	}
	{
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp8_ = _data_->children;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_list = _data_->_tmp9_;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp10_ = _data_->_child_list;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp11_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp10_);
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp12_ = _data_->_tmp11_;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_size = _data_->_tmp12_;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_index = -1;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		while (TRUE) {
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp13_ = _data_->_child_index;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_child_index = _data_->_tmp13_ + 1;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp14_ = _data_->_child_index;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp15_ = _data_->_child_size;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (!(_data_->_tmp14_ < _data_->_tmp15_)) {
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				break;
#line 653 "rygel-searchable-container.c"
			}
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp16_ = _data_->_child_list;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp17_ = _data_->_child_index;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp18_ = NULL;
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp16_, _data_->_tmp17_);
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->child = (MediaObject*) _data_->_tmp18_;
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp20_ = _data_->expression;
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp20_ == NULL) {
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp19_ = TRUE;
#line 671 "rygel-searchable-container.c"
			} else {
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp21_ = _data_->expression;
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp22_ = _data_->child;
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp23_ = FALSE;
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp23_ = search_expression_satisfied_by (_data_->_tmp21_, _data_->_tmp22_);
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp19_ = _data_->_tmp23_;
#line 683 "rygel-searchable-container.c"
			}
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp24_ = _data_->_tmp19_;
#line 105 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp24_) {
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp25_ = _data_->_result_;
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp26_ = _data_->child;
#line 106 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp25_, _data_->_tmp26_);
#line 695 "rygel-searchable-container.c"
			}
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp28_ = _data_->limit;
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp28_ > ((guint) 0)) {
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp29_ = _data_->_result_;
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp30_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp29_);
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp31_ = _data_->_tmp30_;
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp32_ = _data_->limit;
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp27_ = ((guint) _data_->_tmp31_) >= _data_->_tmp32_;
#line 711 "rygel-searchable-container.c"
			} else {
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp27_ = FALSE;
#line 715 "rygel-searchable-container.c"
			}
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp33_ = _data_->_tmp27_;
#line 109 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp33_) {
#line 110 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child);
#line 110 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				break;
#line 725 "rygel-searchable-container.c"
			}
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->child);
#line 729 "rygel-searchable-container.c"
		}
#line 104 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_child_list);
#line 733 "rygel-searchable-container.c"
	}
#line 114 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp35_ = _data_->limit;
#line 114 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp35_ == ((guint) 0)) {
#line 114 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp34_ = TRUE;
#line 741 "rygel-searchable-container.c"
	} else {
#line 114 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp36_ = _data_->_result_;
#line 114 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp37_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp36_);
#line 114 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp38_ = _data_->_tmp37_;
#line 114 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp39_ = _data_->limit;
#line 114 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp34_ = ((guint) _data_->_tmp38_) < _data_->_tmp39_;
#line 753 "rygel-searchable-container.c"
	}
#line 114 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp40_ = _data_->_tmp34_;
#line 114 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp40_) {
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp42_ = _data_->limit;
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_tmp42_ == ((guint) 0)) {
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp41_ = (guint) 0;
#line 765 "rygel-searchable-container.c"
		} else {
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp43_ = _data_->limit;
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp44_ = _data_->_result_;
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp45_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp44_);
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp46_ = _data_->_tmp45_;
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp41_ = _data_->_tmp43_ - _data_->_tmp46_;
#line 777 "rygel-searchable-container.c"
		}
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp47_ = _data_->_tmp41_;
#line 116 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->child_limit = _data_->_tmp47_;
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp48_ = _data_->expression;
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp49_ = _data_->children;
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp50_ = _data_->child_limit;
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp51_ = _data_->sort_criteria;
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp52_ = _data_->cancellable;
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_state_ = 2;
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		rygel_searchable_container_search_in_children (_data_->self, _data_->_tmp48_, _data_->_tmp49_, _data_->_tmp50_, _data_->_tmp51_, _data_->_tmp52_, rygel_searchable_container_simple_search_ready, _data_);
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 799 "rygel-searchable-container.c"
		_state_2:
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp53_ = NULL;
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp53_ = rygel_searchable_container_search_in_children_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->child_results = _data_->_tmp53_;
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_inner_error_ != NULL) {
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_error_free (_data_->_inner_error_);
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->children);
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->_result_);
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_state_ == 0) {
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 821 "rygel-searchable-container.c"
			} else {
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				g_simple_async_result_complete (_data_->_async_result);
#line 825 "rygel-searchable-container.c"
			}
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_object_unref (_data_->_async_result);
#line 117 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			return FALSE;
#line 831 "rygel-searchable-container.c"
		}
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp54_ = _data_->_result_;
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp55_ = _data_->child_results;
#line 122 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		gee_abstract_collection_add_all ((GeeAbstractCollection*) _data_->_tmp54_, (GeeCollection*) _data_->_tmp55_);
#line 114 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->child_results);
#line 841 "rygel-searchable-container.c"
	}
#line 127 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp56_ = _data_->max_count;
#line 127 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp56_ > ((guint) 0)) {
#line 128 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->total_matches = (guint) 0;
#line 849 "rygel-searchable-container.c"
	} else {
#line 130 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp57_ = _data_->_result_;
#line 130 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp58_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp57_);
#line 130 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp59_ = _data_->_tmp58_;
#line 130 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->total_matches = (guint) _data_->_tmp59_;
#line 859 "rygel-searchable-container.c"
	}
#line 133 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp60_ = _data_->offset;
#line 133 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp61_ = _data_->_result_;
#line 133 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp62_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp61_);
#line 133 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp63_ = _data_->_tmp62_;
#line 133 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp60_ >= ((guint) _data_->_tmp63_)) {
#line 134 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp64_ = media_objects_new ();
#line 134 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->result = _data_->_tmp64_;
#line 134 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->children);
#line 134 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_result_);
#line 134 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 134 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 883 "rygel-searchable-container.c"
		} else {
#line 134 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 887 "rygel-searchable-container.c"
		}
#line 134 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 134 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 893 "rygel-searchable-container.c"
	}
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp66_ = _data_->_result_;
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp67_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp66_);
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp68_ = _data_->_tmp67_;
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp68_ > 0) {
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp70_ = _data_->max_count;
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_tmp70_ > ((guint) 0)) {
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp69_ = TRUE;
#line 909 "rygel-searchable-container.c"
		} else {
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp71_ = _data_->offset;
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp69_ = _data_->_tmp71_ > ((guint) 0);
#line 915 "rygel-searchable-container.c"
		}
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp72_ = _data_->_tmp69_;
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp65_ = _data_->_tmp72_;
#line 921 "rygel-searchable-container.c"
	} else {
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp65_ = FALSE;
#line 925 "rygel-searchable-container.c"
	}
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp73_ = _data_->_tmp65_;
#line 138 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp73_) {
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp75_ = _data_->max_count;
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_tmp75_ != ((guint) 0)) {
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp76_ = _data_->offset;
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp77_ = _data_->max_count;
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp78_ = _data_->_result_;
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp79_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp78_);
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp80_ = _data_->_tmp79_;
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp74_ = (_data_->_tmp76_ + _data_->_tmp77_) <= ((guint) _data_->_tmp80_);
#line 947 "rygel-searchable-container.c"
		} else {
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp74_ = FALSE;
#line 951 "rygel-searchable-container.c"
		}
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp81_ = _data_->_tmp74_;
#line 141 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_tmp81_) {
#line 142 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp82_ = _data_->offset;
#line 142 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp83_ = _data_->max_count;
#line 142 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->stop = _data_->_tmp82_ + _data_->_tmp83_;
#line 963 "rygel-searchable-container.c"
		} else {
#line 144 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp84_ = _data_->_result_;
#line 144 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp85_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp84_);
#line 144 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp86_ = _data_->_tmp85_;
#line 144 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->stop = (guint) _data_->_tmp86_;
#line 973 "rygel-searchable-container.c"
		}
#line 147 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp87_ = _data_->_result_;
#line 147 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp88_ = _data_->offset;
#line 147 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp89_ = _data_->stop;
#line 147 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp90_ = NULL;
#line 147 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp90_ = gee_abstract_list_slice ((GeeAbstractList*) _data_->_tmp87_, (gint) _data_->_tmp88_, (gint) _data_->_tmp89_);
#line 147 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->result = G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp90_, TYPE_MEDIA_OBJECTS) ? ((MediaObjects*) _data_->_tmp90_) : NULL;
#line 147 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->children);
#line 147 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_result_);
#line 147 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 147 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 995 "rygel-searchable-container.c"
		} else {
#line 147 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 999 "rygel-searchable-container.c"
		}
#line 147 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 147 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 1005 "rygel-searchable-container.c"
	}
#line 150 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->result = _data_->_result_;
#line 150 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 150 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 150 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1015 "rygel-searchable-container.c"
	} else {
#line 150 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1019 "rygel-searchable-container.c"
	}
#line 150 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 150 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->_result_);
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1033 "rygel-searchable-container.c"
	} else {
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1037 "rygel-searchable-container.c"
	}
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 80 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 1043 "rygel-searchable-container.c"
}


static void rygel_searchable_container_find_object_data_free (gpointer _data) {
	RygelSearchableContainerFindObjectData* _data_;
	_data_ = _data;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (_data_->id);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerFindObjectData, _data_);
#line 1060 "rygel-searchable-container.c"
}


void rygel_searchable_container_find_object (RygelSearchableContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerFindObjectData* _data_;
	RygelSearchableContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerFindObjectData);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, rygel_searchable_container_find_object);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_find_object_data_free);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp1_ = id;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (_data_->id);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->id = _tmp2_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp3_ = cancellable;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->cancellable = _tmp4_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_find_object_co (_data_);
#line 1099 "rygel-searchable-container.c"
}


MediaObject* rygel_searchable_container_find_object_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error) {
	MediaObject* result;
	RygelSearchableContainerFindObjectData* _data_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return NULL;
#line 1110 "rygel-searchable-container.c"
	}
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	result = _data_->result;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return result;
#line 1120 "rygel-searchable-container.c"
}


/**
     * Recursively searches for media object with the given id in this
     * container.
     *
     * @param id ID of the media object to search for
     * @param cancellable optional cancellable for this operation
     * @param callback function to call when result is ready
     *
     * @return the found media object.
     */
static void rygel_searchable_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerFindObjectData* _data_;
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_find_object_co (_data_);
#line 1144 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_find_object_co (RygelSearchableContainerFindObjectData* _data_) {
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 0:
#line 1153 "rygel-searchable-container.c"
		goto _state_0;
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 1:
#line 1157 "rygel-searchable-container.c"
		goto _state_1;
		default:
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 1162 "rygel-searchable-container.c"
	}
	_state_0:
#line 166 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp0_ = relational_expression_new ();
#line 166 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->expression = _data_->_tmp0_;
#line 167 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp1_ = g_strdup (SEARCH_CRITERIA_OP_EQ);
#line 167 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (((SearchExpression*) _data_->expression)->op);
#line 167 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	((SearchExpression*) _data_->expression)->op = _data_->_tmp1_;
#line 168 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp2_ = g_strdup ("@id");
#line 168 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (((SearchExpression*) _data_->expression)->operand1);
#line 168 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	((SearchExpression*) _data_->expression)->operand1 = _data_->_tmp2_;
#line 169 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp3_ = _data_->id;
#line 169 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp4_ = g_strdup (_data_->_tmp3_);
#line 169 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (((SearchExpression*) _data_->expression)->operand2);
#line 169 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	((SearchExpression*) _data_->expression)->operand2 = _data_->_tmp4_;
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp5_ = _data_->cancellable;
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp6_ = 0U;
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_state_ = 1;
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_search (_data_->self, (SearchExpression*) _data_->expression, (guint) 0, (guint) 1, "", _data_->_tmp5_, rygel_searchable_container_find_object_ready, _data_);
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 1199 "rygel-searchable-container.c"
	_state_1:
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp7_ = NULL;
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp7_ = rygel_searchable_container_search_finish (_data_->self, _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->total_matches = _data_->_tmp6_;
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->results = _data_->_tmp7_;
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_inner_error_ != NULL) {
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_error_free (_data_->_inner_error_);
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->expression);
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1221 "rygel-searchable-container.c"
		} else {
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1225 "rygel-searchable-container.c"
		}
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 172 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 1231 "rygel-searchable-container.c"
	}
#line 178 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->results);
#line 178 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 178 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_tmp9_ > 0) {
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp10_ = NULL;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _data_->results, 0);
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->result = (MediaObject*) _data_->_tmp10_;
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->results);
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->expression);
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1253 "rygel-searchable-container.c"
		} else {
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1257 "rygel-searchable-container.c"
		}
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 179 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 1263 "rygel-searchable-container.c"
	} else {
#line 181 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->result = NULL;
#line 181 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->results);
#line 181 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->expression);
#line 181 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		if (_data_->_state_ == 0) {
#line 181 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1275 "rygel-searchable-container.c"
		} else {
#line 181 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 1279 "rygel-searchable-container.c"
		}
#line 181 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_unref (_data_->_async_result);
#line 181 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return FALSE;
#line 1285 "rygel-searchable-container.c"
	}
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->results);
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->expression);
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1295 "rygel-searchable-container.c"
	} else {
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1299 "rygel-searchable-container.c"
	}
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 163 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 1305 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children_data_free (gpointer _data) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	_data_ = _data;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->expression);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->result);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->self);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_slice_free (RygelSearchableContainerSearchInChildrenData, _data_);
#line 1326 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children (RygelSearchableContainer* self, SearchExpression* expression, MediaObjects* children, guint limit, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelSearchableContainerSearchInChildrenData* _data_;
	RygelSearchableContainer* _tmp0_;
	SearchExpression* _tmp1_;
	SearchExpression* _tmp2_;
	MediaObjects* _tmp3_;
	MediaObjects* _tmp4_;
	guint _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GCancellable* _tmp8_;
	GCancellable* _tmp9_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_slice_new0 (RygelSearchableContainerSearchInChildrenData);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, rygel_searchable_container_search_in_children);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_searchable_container_search_in_children_data_free);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->self = _tmp0_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp1_ = expression;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->expression);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->expression = _tmp2_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp3_ = children;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->children);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->children = _tmp4_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp5_ = limit;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->limit = _tmp5_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp6_ = sort_criteria;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_free0 (_data_->sort_criteria);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->sort_criteria = _tmp7_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp8_ = cancellable;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->cancellable);
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->cancellable = _tmp9_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_search_in_children_co (_data_);
#line 1390 "rygel-searchable-container.c"
}


static MediaObjects* rygel_searchable_container_search_in_children_finish (RygelSearchableContainer* self, GAsyncResult* _res_, GError** error) {
	MediaObjects* result;
	RygelSearchableContainerSearchInChildrenData* _data_;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		return NULL;
#line 1401 "rygel-searchable-container.c"
	}
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	result = _data_->result;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->result = NULL;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return result;
#line 1411 "rygel-searchable-container.c"
}


static void rygel_searchable_container_search_in_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelSearchableContainerSearchInChildrenData* _data_;
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_ = _user_data_;
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_source_object_ = source_object;
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_res_ = _res_;
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	rygel_searchable_container_search_in_children_co (_data_);
#line 1425 "rygel-searchable-container.c"
}


static gboolean rygel_searchable_container_search_in_children_co (RygelSearchableContainerSearchInChildrenData* _data_) {
#line 185 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	switch (_data_->_state_) {
#line 185 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 0:
#line 1434 "rygel-searchable-container.c"
		goto _state_0;
#line 185 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		case 1:
#line 1438 "rygel-searchable-container.c"
		goto _state_1;
		default:
#line 185 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_assert_not_reached ();
#line 1443 "rygel-searchable-container.c"
	}
	_state_0:
#line 192 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_tmp0_ = media_objects_new ();
#line 192 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->_result_ = _data_->_tmp0_;
#line 1450 "rygel-searchable-container.c"
	{
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp1_ = _data_->children;
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_list = _data_->_tmp2_;
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp3_ = _data_->_child_list;
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp3_);
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_size = _data_->_tmp5_;
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_data_->_child_index = -1;
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		while (TRUE) {
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp6_ = _data_->_child_index;
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_child_index = _data_->_tmp6_ + 1;
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp7_ = _data_->_child_index;
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp8_ = _data_->_child_size;
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (!(_data_->_tmp7_ < _data_->_tmp8_)) {
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				break;
#line 1482 "rygel-searchable-container.c"
			}
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp9_ = _data_->_child_list;
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp10_ = _data_->_child_index;
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp11_ = NULL;
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp9_, _data_->_tmp10_);
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->child = (MediaObject*) _data_->_tmp11_;
#line 195 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp12_ = _data_->child;
#line 195 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp12_, RYGEL_TYPE_SEARCHABLE_CONTAINER)) {
#line 196 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp13_ = _data_->child;
#line 196 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp13_, RYGEL_TYPE_SEARCHABLE_CONTAINER) ? ((RygelSearchableContainer*) _data_->_tmp13_) : NULL);
#line 196 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->container = _data_->_tmp14_;
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp15_ = _data_->container;
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp16_ = _data_->expression;
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp17_ = _data_->limit;
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp18_ = _data_->sort_criteria;
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp19_ = _data_->cancellable;
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp20_ = 0U;
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_state_ = 1;
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				rygel_searchable_container_search (_data_->_tmp15_, _data_->_tmp16_, (guint) 0, _data_->_tmp17_, _data_->_tmp18_, _data_->_tmp19_, rygel_searchable_container_search_in_children_ready, _data_);
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				return FALSE;
#line 1522 "rygel-searchable-container.c"
				_state_1:
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp21_ = NULL;
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp21_ = rygel_searchable_container_search_finish (_data_->_tmp15_, _data_->_res_, &_data_->_tmp20_, &_data_->_inner_error_);
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->tmp = _data_->_tmp20_;
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->child_result = _data_->_tmp21_;
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				if (_data_->_inner_error_ != NULL) {
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					g_error_free (_data_->_inner_error_);
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->container);
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->child);
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->_child_list);
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					_g_object_unref0 (_data_->_result_);
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					if (_data_->_state_ == 0) {
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
						g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1550 "rygel-searchable-container.c"
					} else {
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
						g_simple_async_result_complete (_data_->_async_result);
#line 1554 "rygel-searchable-container.c"
					}
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					g_object_unref (_data_->_async_result);
#line 199 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
					return FALSE;
#line 1560 "rygel-searchable-container.c"
				}
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp22_ = _data_->_result_;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp23_ = _data_->child_result;
#line 206 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				gee_abstract_collection_add_all ((GeeAbstractCollection*) _data_->_tmp22_, (GeeCollection*) _data_->_tmp23_);
#line 195 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child_result);
#line 195 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->container);
#line 1572 "rygel-searchable-container.c"
			}
#line 209 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp25_ = _data_->limit;
#line 209 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp25_ > ((guint) 0)) {
#line 209 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp26_ = _data_->_result_;
#line 209 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp27_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp26_);
#line 209 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp28_ = _data_->_tmp27_;
#line 209 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp29_ = _data_->limit;
#line 209 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp24_ = ((guint) _data_->_tmp28_) >= _data_->_tmp29_;
#line 1588 "rygel-searchable-container.c"
			} else {
#line 209 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_data_->_tmp24_ = FALSE;
#line 1592 "rygel-searchable-container.c"
			}
#line 209 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_data_->_tmp30_ = _data_->_tmp24_;
#line 209 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (_data_->_tmp30_) {
#line 210 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				_g_object_unref0 (_data_->child);
#line 210 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				break;
#line 1602 "rygel-searchable-container.c"
			}
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_g_object_unref0 (_data_->child);
#line 1606 "rygel-searchable-container.c"
		}
#line 194 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_data_->_child_list);
#line 1610 "rygel-searchable-container.c"
	}
#line 214 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_data_->result = _data_->_result_;
#line 214 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 214 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1618 "rygel-searchable-container.c"
	} else {
#line 214 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1622 "rygel-searchable-container.c"
	}
#line 214 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 214 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 185 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	_g_object_unref0 (_data_->_result_);
#line 185 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (_data_->_state_ == 0) {
#line 185 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1634 "rygel-searchable-container.c"
	} else {
#line 185 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1638 "rygel-searchable-container.c"
	}
#line 185 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_object_unref (_data_->_async_result);
#line 185 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return FALSE;
#line 1644 "rygel-searchable-container.c"
}


void rygel_searchable_container_serialize_search_parameters (RygelSearchableContainer* self, GUPnPDIDLLiteContainer* didl_container) {
#line 217 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_return_if_fail (didl_container != NULL);
#line 1651 "rygel-searchable-container.c"
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _search_class_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _search_class_size;
		gint _search_class_index;
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp0_ = rygel_searchable_container_get_search_classes (self);
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp1_ = _tmp0_;
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_search_class_list = _tmp2_;
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp3_ = _search_class_list;
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_tmp5_ = _tmp4_;
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_search_class_size = _tmp5_;
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_search_class_index = -1;
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		while (TRUE) {
#line 1682 "rygel-searchable-container.c"
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			gchar* search_class;
			GUPnPDIDLLiteContainer* _tmp12_;
			const gchar* _tmp13_;
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp6_ = _search_class_index;
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_search_class_index = _tmp6_ + 1;
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp7_ = _search_class_index;
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp8_ = _search_class_size;
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
				break;
#line 1704 "rygel-searchable-container.c"
			}
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp9_ = _search_class_list;
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp10_ = _search_class_index;
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			search_class = (gchar*) _tmp11_;
#line 220 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp12_ = didl_container;
#line 220 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_tmp13_ = search_class;
#line 220 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			gupnp_didl_lite_container_add_search_class (_tmp12_, _tmp13_);
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
			_g_free0 (search_class);
#line 1722 "rygel-searchable-container.c"
		}
#line 219 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		_g_object_unref0 (_search_class_list);
#line 1726 "rygel-searchable-container.c"
	}
}


GeeArrayList* rygel_searchable_container_get_search_classes (RygelSearchableContainer* self) {
#line 42 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	return RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->get_search_classes (self);
#line 1736 "rygel-searchable-container.c"
}


void rygel_searchable_container_set_search_classes (RygelSearchableContainer* self, GeeArrayList* value) {
#line 42 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	RYGEL_SEARCHABLE_CONTAINER_GET_INTERFACE (self)->set_search_classes (self, value);
#line 1745 "rygel-searchable-container.c"
}


static void rygel_searchable_container_base_init (RygelSearchableContainerIface * iface) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	static gboolean initialized = FALSE;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
	if (!initialized) {
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		initialized = TRUE;
#line 41 "/home/jens/Source/rygel/tests/rygel-searchable-container.vala"
		g_object_interface_install_property (iface, g_param_spec_object ("search-classes", "search-classes", "search-classes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 1758 "rygel-searchable-container.c"
	}
}


/**
 * The base class for searchable containers.
 *
 * Classes that implement this interface can, for instance:
 *
 *  # Allow backends to implement a UPnP Search call using native searching (such as SQL or SPARQL queries).
 *  # Provide the naïve default implementation of search, from this base class, which does a recursive tree walk.
 *
 * The search_classes property lists what information this container may be searched
 * for. It is mapped to upnp:searchClass (with includeDerived assumed to be false),
 */
GType rygel_searchable_container_get_type (void) {
	static volatile gsize rygel_searchable_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_searchable_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSearchableContainerIface), (GBaseInitFunc) rygel_searchable_container_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType rygel_searchable_container_type_id;
		rygel_searchable_container_type_id = g_type_register_static (G_TYPE_INTERFACE, "RygelSearchableContainer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (rygel_searchable_container_type_id, TYPE_MEDIA_CONTAINER);
		g_once_init_leave (&rygel_searchable_container_type_id__volatile, rygel_searchable_container_type_id);
	}
	return rygel_searchable_container_type_id__volatile;
}



