/* rygel-http-item-uri.c generated by valac 0.18.0.2-2c22, the Vala compiler
 * generated from rygel-http-item-uri.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Authors: Jens Georg <mail@jensge.org>
 *          Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                                <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libsoup/soup.h>
#include <glib/gi18n-lib.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>


#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPItemURIPrivate RygelHTTPItemURIPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_VISUAL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemClass))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_IS_VISUAL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemClass))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemClass RygelVisualItemClass;
typedef struct _RygelVisualItemPrivate RygelVisualItemPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;
#define _rygel_thumbnail_unref0(var) ((var == NULL) ? NULL : (var = (rygel_thumbnail_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;
typedef struct _RygelMusicItemPrivate RygelMusicItemPrivate;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelVideoItemPrivate RygelVideoItemPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

struct _RygelHTTPItemURI {
	GObject parent_instance;
	RygelHTTPItemURIPrivate * priv;
	gchar* item_id;
	gint thumbnail_index;
	gint subtitle_index;
	gchar* transcode_target;
	RygelHTTPServer* http_server;
};

struct _RygelHTTPItemURIClass {
	GObjectClass parent_class;
};

struct _RygelHTTPItemURIPrivate {
	gchar* real_extension;
};

struct _RygelMediaItem {
	GObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* id;
	GeeArrayList* uris;
	gchar* mime_type;
};

struct _RygelMediaItemClass {
	GObjectClass parent_class;
};

struct _RygelVisualItem {
	RygelMediaItem parent_instance;
	RygelVisualItemPrivate * priv;
	GeeArrayList* thumbnails;
};

struct _RygelVisualItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelThumbnail {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelThumbnailPrivate * priv;
	gchar* file_extension;
};

struct _RygelThumbnailClass {
	GTypeClass parent_class;
	void (*finalize) (RygelThumbnail *self);
};

struct _RygelMusicItem {
	RygelMediaItem parent_instance;
	RygelMusicItemPrivate * priv;
	RygelThumbnail* album_art;
};

struct _RygelMusicItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVideoItem {
	RygelVisualItem parent_instance;
	RygelVideoItemPrivate * priv;
	GeeArrayList* subtitles;
};

struct _RygelVideoItemClass {
	RygelVisualItemClass parent_class;
};

struct _RygelSubtitle {
	GObject parent_instance;
	RygelSubtitlePrivate * priv;
	gchar* caption_type;
};

struct _RygelSubtitleClass {
	GObjectClass parent_class;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPServer {
	GObject parent_instance;
	RygelHTTPServerPrivate * priv;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	GObjectClass parent_class;
};


static gpointer rygel_http_item_uri_parent_class = NULL;
extern GeeHashMap* rygel_http_item_uri_mime_to_ext;
GeeHashMap* rygel_http_item_uri_mime_to_ext = NULL;

GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_ITEM_URI_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIPrivate))
enum  {
	RYGEL_HTTP_ITEM_URI_DUMMY_PROPERTY,
	RYGEL_HTTP_ITEM_URI_EXTENSION
};
GType rygel_media_item_get_type (void) G_GNUC_CONST;
RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target);
void rygel_http_item_uri_set_extension (RygelHTTPItemURI* self, const gchar* value);
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
gpointer rygel_thumbnail_ref (gpointer instance);
void rygel_thumbnail_unref (gpointer instance);
GParamSpec* rygel_param_spec_thumbnail (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_thumbnail (GValue* value, gpointer v_object);
void rygel_value_take_thumbnail (GValue* value, gpointer v_object);
gpointer rygel_value_get_thumbnail (const GValue* value);
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
GType rygel_subtitle_get_type (void) G_GNUC_CONST;
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
RygelTranscoder* rygel_http_server_get_transcoder (RygelHTTPServer* self, const gchar* target, GError** error);
const gchar* rygel_transcoder_get_extension (RygelTranscoder* self);
gchar* rygel_http_item_uri_get_extension (RygelHTTPItemURI* self);
static gchar* rygel_http_item_uri_ext_from_mime_type (RygelHTTPItemURI* self, const gchar* mime_type);
GQuark rygel_http_request_error_quark (void);
RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error);
const gchar* rygel_http_server_get_path_root (RygelHTTPServer* self);
gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path);
static void rygel_http_item_uri_finalize (GObject* obj);
static void _vala_rygel_http_item_uri_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_http_item_uri_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return self ? g_object_ref (self) : NULL;
#line 292 "rygel-http-item-uri.c"
}


static gpointer _rygel_thumbnail_ref0 (gpointer self) {
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return self ? rygel_thumbnail_ref (self) : NULL;
#line 299 "rygel-http-item-uri.c"
}


static gint string_last_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
#line 894 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 894 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 895 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = start_index;
#line 895 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = needle;
#line 895 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp2_ = g_strrstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
#line 895 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 897 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = _result_;
#line 897 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp3_ != NULL) {
#line 326 "rygel-http-item-uri.c"
		gchar* _tmp4_;
#line 898 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = _result_;
#line 898 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = (gint) (_tmp4_ - ((gchar*) self));
#line 898 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 334 "rygel-http-item-uri.c"
	} else {
#line 900 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = -1;
#line 900 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 340 "rygel-http-item-uri.c"
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
#line 1143 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1143 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1143 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1143 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1144 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1144 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 364 "rygel-http-item-uri.c"
		glong _tmp4_;
#line 1145 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1145 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1145 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 372 "rygel-http-item-uri.c"
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
#line 1147 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1147 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1147 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1147 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 384 "rygel-http-item-uri.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
#line 1154 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 409 "rygel-http-item-uri.c"
		glong _tmp2_;
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 415 "rygel-http-item-uri.c"
	} else {
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 419 "rygel-http-item-uri.c"
	}
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = _tmp0_;
#line 1156 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp3_) {
#line 425 "rygel-http-item-uri.c"
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
#line 1158 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = offset;
#line 1158 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp5_ = len;
#line 1158 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
#line 1158 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		string_length = _tmp6_;
#line 437 "rygel-http-item-uri.c"
	} else {
		gint _tmp7_;
		gint _tmp8_;
#line 1160 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp7_ = strlen (self);
#line 1160 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1160 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp8_;
#line 447 "rygel-http-item-uri.c"
	}
#line 1163 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp9_ = offset;
#line 1163 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp9_ < ((glong) 0)) {
#line 453 "rygel-http-item-uri.c"
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
#line 1164 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp10_ = string_length;
#line 1164 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1164 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		offset = _tmp10_ + _tmp11_;
#line 1165 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1165 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
#line 467 "rygel-http-item-uri.c"
	} else {
		glong _tmp13_;
		glong _tmp14_;
#line 1167 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp13_ = offset;
#line 1167 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp14_ = string_length;
#line 1167 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
#line 477 "rygel-http-item-uri.c"
	}
#line 1169 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp15_ = len;
#line 1169 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_tmp15_ < ((glong) 0)) {
#line 483 "rygel-http-item-uri.c"
		glong _tmp16_;
		glong _tmp17_;
#line 1170 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp16_ = string_length;
#line 1170 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp17_ = offset;
#line 1170 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		len = _tmp16_ - _tmp17_;
#line 492 "rygel-http-item-uri.c"
	}
#line 1172 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp18_ = offset;
#line 1172 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp19_ = len;
#line 1172 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp20_ = string_length;
#line 1172 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp21_ = offset;
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp22_ = len;
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	result = _tmp23_;
#line 1173 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	return result;
#line 512 "rygel-http-item-uri.c"
}


RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
	RygelHTTPItemURI * self = NULL;
	RygelMediaItem* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	RygelHTTPServer* _tmp7_;
	gint _tmp8_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gboolean _tmp53_;
	GError * _inner_error_ = NULL;
#line 49 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 49 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = item;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp1_ = _tmp0_->id;
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->item_id);
#line 54 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->item_id = _tmp2_;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp3_ = thumbnail_index;
#line 55 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->thumbnail_index = _tmp3_;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp4_ = subtitle_index;
#line 56 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->subtitle_index = _tmp4_;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp5_ = transcode_target;
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->transcode_target);
#line 57 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->transcode_target = _tmp6_;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp7_ = http_server;
#line 58 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->http_server = _tmp7_;
#line 59 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_extension (self, "");
#line 61 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp8_ = thumbnail_index;
#line 61 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp8_ > (-1)) {
#line 574 "rygel-http-item-uri.c"
		RygelMediaItem* _tmp9_;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp9_ = item;
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, RYGEL_TYPE_VISUAL_ITEM)) {
#line 580 "rygel-http-item-uri.c"
			RygelMediaItem* _tmp10_;
			GeeArrayList* _tmp11_;
			GeeArrayList* _tmp12_;
			GeeArrayList* thumbnails;
			GeeArrayList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp10_ = item;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp11_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, RYGEL_TYPE_VISUAL_ITEM) ? ((RygelVisualItem*) _tmp10_) : NULL)->thumbnails;
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp12_ = _g_object_ref0 (_tmp11_);
#line 63 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			thumbnails = _tmp12_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp13_ = thumbnails;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp13_);
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp15_ = _tmp14_;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp16_ = thumbnail_index;
#line 65 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			if (_tmp15_ > _tmp16_) {
#line 607 "rygel-http-item-uri.c"
				GeeArrayList* _tmp17_;
				gint _tmp18_;
				gpointer _tmp19_ = NULL;
				RygelThumbnail* _tmp20_;
				const gchar* _tmp21_;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp17_ = thumbnails;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp18_ = thumbnail_index;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, _tmp18_);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp20_ = (RygelThumbnail*) _tmp19_;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp21_ = _tmp20_->file_extension;
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				rygel_http_item_uri_set_extension (self, _tmp21_);
#line 66 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_rygel_thumbnail_unref0 (_tmp20_);
#line 627 "rygel-http-item-uri.c"
			}
#line 62 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_object_unref0 (thumbnails);
#line 631 "rygel-http-item-uri.c"
		} else {
			RygelMediaItem* _tmp22_;
#line 68 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp22_ = item;
#line 68 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, RYGEL_TYPE_MUSIC_ITEM)) {
#line 638 "rygel-http-item-uri.c"
				RygelMediaItem* _tmp23_;
				RygelThumbnail* _tmp24_;
				RygelThumbnail* _tmp25_;
				RygelThumbnail* album_art;
				RygelThumbnail* _tmp26_;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp23_ = item;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp24_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, RYGEL_TYPE_MUSIC_ITEM) ? ((RygelMusicItem*) _tmp23_) : NULL)->album_art;
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp25_ = _rygel_thumbnail_ref0 (_tmp24_);
#line 69 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				album_art = _tmp25_;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp26_ = album_art;
#line 71 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (_tmp26_ != NULL) {
#line 656 "rygel-http-item-uri.c"
					RygelThumbnail* _tmp27_;
					const gchar* _tmp28_;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp27_ = album_art;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp28_ = _tmp27_->file_extension;
#line 72 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					rygel_http_item_uri_set_extension (self, _tmp28_);
#line 665 "rygel-http-item-uri.c"
				}
#line 68 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_rygel_thumbnail_unref0 (album_art);
#line 669 "rygel-http-item-uri.c"
			}
		}
	} else {
		gint _tmp29_;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp29_ = subtitle_index;
#line 75 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		if (_tmp29_ > (-1)) {
#line 678 "rygel-http-item-uri.c"
			RygelMediaItem* _tmp30_;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp30_ = item;
#line 76 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, RYGEL_TYPE_VIDEO_ITEM)) {
#line 684 "rygel-http-item-uri.c"
				RygelMediaItem* _tmp31_;
				GeeArrayList* _tmp32_;
				GeeArrayList* _tmp33_;
				GeeArrayList* subtitles;
				GeeArrayList* _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp31_ = item;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp32_ = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, RYGEL_TYPE_VIDEO_ITEM) ? ((RygelVideoItem*) _tmp31_) : NULL)->subtitles;
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp33_ = _g_object_ref0 (_tmp32_);
#line 77 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				subtitles = _tmp33_;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp34_ = subtitles;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp35_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp34_);
#line 79 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp36_ = _tmp35_;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp37_ = subtitle_index;
#line 79 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (_tmp36_ > _tmp37_) {
#line 711 "rygel-http-item-uri.c"
					GeeArrayList* _tmp38_;
					gint _tmp39_;
					gpointer _tmp40_ = NULL;
					RygelSubtitle* _tmp41_;
					const gchar* _tmp42_;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp38_ = subtitles;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp39_ = subtitle_index;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp38_, _tmp39_);
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp41_ = (RygelSubtitle*) _tmp40_;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp42_ = _tmp41_->caption_type;
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					rygel_http_item_uri_set_extension (self, _tmp42_);
#line 80 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_object_unref0 (_tmp41_);
#line 731 "rygel-http-item-uri.c"
				}
#line 76 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_g_object_unref0 (subtitles);
#line 735 "rygel-http-item-uri.c"
			}
		} else {
			const gchar* _tmp43_;
#line 83 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp43_ = transcode_target;
#line 83 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			if (_tmp43_ != NULL) {
#line 743 "rygel-http-item-uri.c"
				{
					RygelHTTPServer* _tmp44_;
					const gchar* _tmp45_;
					RygelTranscoder* _tmp46_ = NULL;
					RygelTranscoder* tc;
					RygelTranscoder* _tmp47_;
					const gchar* _tmp48_;
					const gchar* _tmp49_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp44_ = self->http_server;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp45_ = transcode_target;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp46_ = rygel_http_server_get_transcoder (_tmp44_, _tmp45_, &_inner_error_);
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					tc = _tmp46_;
#line 85 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					if (_inner_error_ != NULL) {
#line 762 "rygel-http-item-uri.c"
						goto __catch3_g_error;
					}
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp47_ = tc;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp48_ = rygel_transcoder_get_extension (_tmp47_);
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp49_ = _tmp48_;
#line 87 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					rygel_http_item_uri_set_extension (self, _tmp49_);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_object_unref0 (tc);
#line 775 "rygel-http-item-uri.c"
				}
				goto __finally3;
				__catch3_g_error:
				{
					GError* _error_ = NULL;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_error_ = _inner_error_;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_inner_error_ = NULL;
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_error_free0 (_error_);
#line 787 "rygel-http-item-uri.c"
				}
				__finally3:
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (_inner_error_ != NULL) {
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					g_clear_error (&_inner_error_);
#line 84 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					return NULL;
#line 798 "rygel-http-item-uri.c"
				}
			}
		}
	}
#line 91 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp50_ = rygel_http_item_uri_get_extension (self);
#line 91 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp51_ = _tmp50_;
#line 91 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp52_ = _tmp51_;
#line 91 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp53_ = g_strcmp0 (_tmp52_, "") == 0;
#line 91 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (_tmp52_);
#line 91 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp53_) {
#line 815 "rygel-http-item-uri.c"
		gchar* _tmp54_;
		gchar* uri_extension;
		const gchar* _tmp75_;
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp54_ = g_strdup ("");
#line 92 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		uri_extension = _tmp54_;
#line 823 "rygel-http-item-uri.c"
		{
			RygelMediaItem* _tmp55_;
			GeeArrayList* _tmp56_;
			GeeArrayList* _tmp57_;
			GeeArrayList* _uri_string_list;
			GeeArrayList* _tmp58_;
			gint _tmp59_;
			gint _tmp60_;
			gint _uri_string_size;
			gint _uri_string_index;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp55_ = item;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp56_ = _tmp55_->uris;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp57_ = _g_object_ref0 (_tmp56_);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_uri_string_list = _tmp57_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp58_ = _uri_string_list;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp59_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp58_);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp60_ = _tmp59_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_uri_string_size = _tmp60_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_uri_string_index = -1;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			while (TRUE) {
#line 854 "rygel-http-item-uri.c"
				gint _tmp61_;
				gint _tmp62_;
				gint _tmp63_;
				GeeArrayList* _tmp64_;
				gint _tmp65_;
				gpointer _tmp66_ = NULL;
				gchar* uri_string;
				const gchar* _tmp67_;
				gchar* _tmp68_ = NULL;
				gchar* basename;
				const gchar* _tmp69_;
				gint _tmp70_ = 0;
				gint dot_index;
				gint _tmp71_;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp61_ = _uri_string_index;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_uri_string_index = _tmp61_ + 1;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp62_ = _uri_string_index;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp63_ = _uri_string_size;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (!(_tmp62_ < _tmp63_)) {
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					break;
#line 881 "rygel-http-item-uri.c"
				}
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp64_ = _uri_string_list;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp65_ = _uri_string_index;
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp66_ = gee_abstract_list_get ((GeeAbstractList*) _tmp64_, _tmp65_);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				uri_string = (gchar*) _tmp66_;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp67_ = uri_string;
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp68_ = g_path_get_basename (_tmp67_);
#line 95 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				basename = _tmp68_;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp69_ = basename;
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp70_ = string_last_index_of (_tmp69_, ".", 0);
#line 96 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				dot_index = _tmp70_;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp71_ = dot_index;
#line 98 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (_tmp71_ > (-1)) {
#line 907 "rygel-http-item-uri.c"
					const gchar* _tmp72_;
					gint _tmp73_;
					gchar* _tmp74_ = NULL;
#line 99 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp72_ = basename;
#line 99 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp73_ = dot_index;
#line 99 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp74_ = string_substring (_tmp72_, (glong) (_tmp73_ + 1), (glong) (-1));
#line 99 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_free0 (uri_extension);
#line 99 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					uri_extension = _tmp74_;
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_free0 (basename);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_free0 (uri_string);
#line 101 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					break;
#line 927 "rygel-http-item-uri.c"
				}
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_g_free0 (basename);
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_g_free0 (uri_string);
#line 933 "rygel-http-item-uri.c"
			}
#line 94 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_object_unref0 (_uri_string_list);
#line 937 "rygel-http-item-uri.c"
		}
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp75_ = uri_extension;
#line 105 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		if (g_strcmp0 (_tmp75_, "") == 0) {
#line 943 "rygel-http-item-uri.c"
			RygelMediaItem* _tmp76_;
			const gchar* _tmp77_;
			gchar* _tmp78_ = NULL;
			gchar* _tmp79_;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp76_ = item;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp77_ = _tmp76_->mime_type;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp78_ = rygel_http_item_uri_ext_from_mime_type (self, _tmp77_);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp79_ = _tmp78_;
#line 106 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			rygel_http_item_uri_set_extension (self, _tmp79_);
#line 106 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (_tmp79_);
#line 960 "rygel-http-item-uri.c"
		} else {
			const gchar* _tmp80_;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp80_ = uri_extension;
#line 108 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			rygel_http_item_uri_set_extension (self, _tmp80_);
#line 967 "rygel-http-item-uri.c"
		}
#line 91 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_g_free0 (uri_extension);
#line 971 "rygel-http-item-uri.c"
	}
#line 49 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return self;
#line 975 "rygel-http-item-uri.c"
}


RygelHTTPItemURI* rygel_http_item_uri_new (RygelMediaItem* item, RygelHTTPServer* http_server, gint thumbnail_index, gint subtitle_index, const gchar* transcode_target) {
#line 49 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return rygel_http_item_uri_construct (RYGEL_TYPE_HTTP_ITEM_URI, item, http_server, thumbnail_index, subtitle_index, transcode_target);
#line 982 "rygel-http-item-uri.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1228 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1228 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1228 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 995 "rygel-http-item-uri.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1025 "rygel-http-item-uri.c"
				goto __catch4_g_regex_error;
			}
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1230 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			return NULL;
#line 1034 "rygel-http-item-uri.c"
		}
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp5_ = regex;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp6_ = replacement;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 1050 "rygel-http-item-uri.c"
				goto __catch4_g_regex_error;
			}
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
			return NULL;
#line 1061 "rygel-http-item-uri.c"
		}
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		result = _tmp8_;
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1231 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return result;
#line 1069 "rygel-http-item-uri.c"
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1233 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 1083 "rygel-http-item-uri.c"
	}
	__finally4:
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1229 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		return NULL;
#line 1094 "rygel-http-item-uri.c"
	}
}


RygelHTTPItemURI* rygel_http_item_uri_construct_from_string (GType object_type, const gchar* uri, RygelHTTPServer* http_server, GError** error) {
	RygelHTTPItemURI * self = NULL;
	RygelHTTPServer* _tmp0_;
	const gchar* _tmp1_;
	RygelHTTPServer* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* request_uri;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_ = NULL;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	gboolean _tmp9_ = FALSE;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gboolean _tmp12_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** _tmp17_;
	gint _tmp17__length1;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* last_part;
	const gchar* _tmp20_;
	gint _tmp21_ = 0;
	gint dot_index;
	gint _tmp22_;
	const gchar* _tmp70_;
	GError * _inner_error_ = NULL;
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (http_server != NULL, NULL);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
#line 117 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->thumbnail_index = -1;
#line 118 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->subtitle_index = -1;
#line 119 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->transcode_target);
#line 119 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->transcode_target = NULL;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = http_server;
#line 120 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->http_server = _tmp0_;
#line 121 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	rygel_http_item_uri_set_extension (self, "");
#line 123 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp1_ = uri;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp2_ = http_server;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp3_ = rygel_http_server_get_path_root (_tmp2_);
#line 123 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp4_ = _tmp3_;
#line 123 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp5_ = string_replace (_tmp1_, _tmp4_, "");
#line 123 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	request_uri = _tmp5_;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp6_ = request_uri;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "/", 0);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	parts = _tmp8_;
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	parts_length1 = _vala_array_length (_tmp7_);
#line 124 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_parts_size_ = parts_length1;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp10_ = parts;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp10__length1 = parts_length1;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp10__length1 < 2) {
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp9_ = TRUE;
#line 1181 "rygel-http-item-uri.c"
	} else {
		gchar** _tmp11_;
		gint _tmp11__length1;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp11_ = parts;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp11__length1 = parts_length1;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp9_ = (_tmp11__length1 % 2) == 0;
#line 1191 "rygel-http-item-uri.c"
	}
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp12_ = _tmp9_;
#line 126 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp12_) {
#line 1197 "rygel-http-item-uri.c"
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_;
		GError* _tmp15_;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp13_ = _ ("Invalid URI '%s'");
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp14_ = request_uri;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp15_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _tmp13_, _tmp14_);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_inner_error_ = _tmp15_;
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_propagate_error (error, _inner_error_);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (request_uri);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_object_unref0 (self);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			return NULL;
#line 1221 "rygel-http-item-uri.c"
		} else {
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (request_uri);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_clear_error (&_inner_error_);
#line 127 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			return NULL;
#line 1233 "rygel-http-item-uri.c"
		}
	}
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp16_ = parts;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp16__length1 = parts_length1;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp17_ = parts;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp17__length1 = parts_length1;
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp18_ = _tmp16_[_tmp17__length1 - 1];
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp19_ = g_strdup (_tmp18_);
#line 131 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	last_part = _tmp19_;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp20_ = last_part;
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp21_ = string_last_index_of (_tmp20_, ".", 0);
#line 132 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	dot_index = _tmp21_;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp22_ = dot_index;
#line 134 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp22_ > (-1)) {
#line 1260 "rygel-http-item-uri.c"
		const gchar* _tmp23_;
		gint _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		gchar** _tmp27_;
		gint _tmp27__length1;
		gchar** _tmp28_;
		gint _tmp28__length1;
		const gchar* _tmp29_;
		gint _tmp30_;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp23_ = last_part;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp24_ = dot_index;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp25_ = string_substring (_tmp23_, (glong) (_tmp24_ + 1), (glong) (-1));
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp26_ = _tmp25_;
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		rygel_http_item_uri_set_extension (self, _tmp26_);
#line 135 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_g_free0 (_tmp26_);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp27_ = parts;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp27__length1 = parts_length1;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp28_ = parts;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp28__length1 = parts_length1;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp29_ = last_part;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp30_ = dot_index;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp31_ = string_substring (_tmp29_, (glong) 0, (glong) _tmp30_);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_g_free0 (_tmp27_[_tmp28__length1 - 1]);
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp27_[_tmp28__length1 - 1] = _tmp31_;
#line 136 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp32_ = _tmp27_[_tmp28__length1 - 1];
#line 1305 "rygel-http-item-uri.c"
	}
	{
		gint i;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		i = 1;
#line 1311 "rygel-http-item-uri.c"
		{
			gboolean _tmp33_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp33_ = TRUE;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			while (TRUE) {
#line 1318 "rygel-http-item-uri.c"
				gboolean _tmp34_;
				gint _tmp36_;
				gchar** _tmp37_;
				gint _tmp37__length1;
				gchar** _tmp38_;
				gint _tmp38__length1;
				gint _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				GQuark _tmp43_ = 0U;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				static GQuark _tmp42_label0 = 0;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				static GQuark _tmp42_label1 = 0;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				static GQuark _tmp42_label2 = 0;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				static GQuark _tmp42_label3 = 0;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp34_ = _tmp33_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (!_tmp34_) {
#line 1341 "rygel-http-item-uri.c"
					gint _tmp35_;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp35_ = i;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					i = _tmp35_ + 2;
#line 1347 "rygel-http-item-uri.c"
				}
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp33_ = FALSE;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp36_ = i;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp37_ = parts;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp37__length1 = parts_length1;
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (!(_tmp36_ < (_tmp37__length1 - 1))) {
#line 139 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					break;
#line 1361 "rygel-http-item-uri.c"
				}
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp38_ = parts;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp38__length1 = parts_length1;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp39_ = i;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp40_ = _tmp38_[_tmp39_];
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp41_ = _tmp40_;
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp43_ = (NULL == _tmp41_) ? 0 : g_quark_from_string (_tmp41_);
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				if (_tmp43_ == ((0 != _tmp42_label0) ? _tmp42_label0 : (_tmp42_label0 = g_quark_from_static_string ("i")))) {
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					switch (0) {
#line 1379 "rygel-http-item-uri.c"
						default:
						{
							gchar** _tmp44_;
							gint _tmp44__length1;
							gint _tmp45_;
							const gchar* _tmp46_;
							gchar* _tmp47_ = NULL;
							gchar* _tmp48_;
							size_t _tmp49_;
							guchar* _tmp50_ = NULL;
							guchar* _tmp51_;
							gint _tmp51__length1;
							guchar* data;
							gint data_length1;
							gint _data_size_;
							GString* _tmp52_;
							GString* builder;
							GString* _tmp53_;
							guchar* _tmp54_;
							gint _tmp54__length1;
							GString* _tmp55_;
							const gchar* _tmp56_;
							gchar* _tmp57_;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp44_ = parts;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp44__length1 = parts_length1;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp45_ = i;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp46_ = _tmp44_[_tmp45_ + 1];
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp47_ = soup_uri_decode (_tmp46_);
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp48_ = _tmp47_;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp50_ = g_base64_decode (_tmp48_, &_tmp49_);
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp51_ = _tmp50_;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp51__length1 = _tmp49_;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_g_free0 (_tmp48_);
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							data = _tmp51_;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							data_length1 = _tmp51__length1;
#line 142 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_data_size_ = data_length1;
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp52_ = g_string_new ("");
#line 143 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							builder = _tmp52_;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp53_ = builder;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp54_ = data;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp54__length1 = data_length1;
#line 144 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							g_string_append (_tmp53_, (const gchar*) _tmp54_);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp55_ = builder;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp56_ = _tmp55_->str;
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp57_ = g_strdup (_tmp56_);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_g_free0 (self->item_id);
#line 145 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							self->item_id = _tmp57_;
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_g_string_free0 (builder);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							data = (g_free (data), NULL);
#line 147 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							break;
#line 1457 "rygel-http-item-uri.c"
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label1) ? _tmp42_label1 : (_tmp42_label1 = g_quark_from_static_string ("tr")))) {
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					switch (0) {
#line 1463 "rygel-http-item-uri.c"
						default:
						{
							gchar** _tmp58_;
							gint _tmp58__length1;
							gint _tmp59_;
							const gchar* _tmp60_;
							gchar* _tmp61_ = NULL;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp58_ = parts;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp58__length1 = parts_length1;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp59_ = i;
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp60_ = _tmp58_[_tmp59_ + 1];
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp61_ = soup_uri_decode (_tmp60_);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_g_free0 (self->transcode_target);
#line 149 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							self->transcode_target = _tmp61_;
#line 151 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							break;
#line 1487 "rygel-http-item-uri.c"
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label2) ? _tmp42_label2 : (_tmp42_label2 = g_quark_from_static_string ("th")))) {
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					switch (0) {
#line 1493 "rygel-http-item-uri.c"
						default:
						{
							gchar** _tmp62_;
							gint _tmp62__length1;
							gint _tmp63_;
							const gchar* _tmp64_;
							gint _tmp65_ = 0;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp62_ = parts;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp62__length1 = parts_length1;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp63_ = i;
#line 153 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp64_ = _tmp62_[_tmp63_ + 1];
#line 153 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp65_ = atoi (_tmp64_);
#line 153 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							self->thumbnail_index = _tmp65_;
#line 155 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							break;
#line 1515 "rygel-http-item-uri.c"
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label3) ? _tmp42_label3 : (_tmp42_label3 = g_quark_from_static_string ("sub")))) {
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					switch (0) {
#line 1521 "rygel-http-item-uri.c"
						default:
						{
							gchar** _tmp66_;
							gint _tmp66__length1;
							gint _tmp67_;
							const gchar* _tmp68_;
							gint _tmp69_ = 0;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp66_ = parts;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp66__length1 = parts_length1;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp67_ = i;
#line 157 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp68_ = _tmp66_[_tmp67_ + 1];
#line 157 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							_tmp69_ = atoi (_tmp68_);
#line 157 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							self->subtitle_index = _tmp69_;
#line 159 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							break;
#line 1543 "rygel-http-item-uri.c"
						}
					}
				} else {
#line 140 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					switch (0) {
#line 1549 "rygel-http-item-uri.c"
						default:
						{
#line 161 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
							break;
#line 1554 "rygel-http-item-uri.c"
						}
					}
				}
			}
		}
	}
#line 165 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp70_ = self->item_id;
#line 165 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp70_ == NULL) {
#line 1565 "rygel-http-item-uri.c"
		const gchar* _tmp71_ = NULL;
		GError* _tmp72_;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp71_ = _ ("Not Found");
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp72_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp71_);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_inner_error_ = _tmp72_;
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_propagate_error (error, _inner_error_);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (last_part);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (request_uri);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_object_unref0 (self);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			return NULL;
#line 1588 "rygel-http-item-uri.c"
		} else {
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (last_part);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (request_uri);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			g_clear_error (&_inner_error_);
#line 166 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			return NULL;
#line 1602 "rygel-http-item-uri.c"
		}
	}
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (last_part);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (request_uri);
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return self;
#line 1613 "rygel-http-item-uri.c"
}


RygelHTTPItemURI* rygel_http_item_uri_new_from_string (const gchar* uri, RygelHTTPServer* http_server, GError** error) {
#line 113 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return rygel_http_item_uri_construct_from_string (RYGEL_TYPE_HTTP_ITEM_URI, uri, http_server, error);
#line 1620 "rygel-http-item-uri.c"
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	gint _tmp7__length1;
#line 1253 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_result_ = _tmp2_;
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_result__length1 = _tmp1_ + 1;
#line 1254 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	__result__size_ = _result__length1;
#line 1255 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp3_ = _result__length1;
#line 1255 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_result__length1 = _tmp3_ - 1;
#line 1256 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp4_ = _result_;
#line 1256 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp4__length1 = _result__length1;
#line 1256 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp5_ = strlen (self);
#line 1256 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp6_ = _tmp5_;
#line 1256 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	memcpy (_tmp4_, self, (gsize) _tmp6_);
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp7_ = _result_;
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	_tmp7__length1 = _result__length1;
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
		*result_length1 = _tmp7__length1;
#line 1675 "rygel-http-item-uri.c"
	}
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1257 "/opt/gnome2/share/vala-0.18/vapi/glib-2.0.vapi"
	return result;
#line 1681 "rygel-http-item-uri.c"
}


gchar* rygel_http_item_uri_to_string (RygelHTTPItemURI* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gchar* data;
	gint data_length1;
	gint _data_size_;
	gchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* escaped;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* path;
	const gchar* _tmp10_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_ = NULL;
#line 170 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 174 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = self->item_id;
#line 174 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
#line 174 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	data = _tmp2_;
#line 174 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	data_length1 = _tmp1_;
#line 174 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_data_size_ = data_length1;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp3_ = data;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp3__length1 = data_length1;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp4_ = g_base64_encode ((guchar*) _tmp3_, (_tmp3__length1 * sizeof (gchar)) / sizeof (guchar));
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp5_ = _tmp4_;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp6_ = g_uri_escape_string (_tmp5_, "", TRUE);
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp7_ = _tmp6_;
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (_tmp5_);
#line 175 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	escaped = _tmp7_;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp8_ = escaped;
#line 178 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp9_ = g_strconcat ("/i/", _tmp8_, NULL);
#line 178 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	path = _tmp9_;
#line 180 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp10_ = self->transcode_target;
#line 180 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp10_ != NULL) {
#line 1749 "rygel-http-item-uri.c"
		const gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp11_ = self->transcode_target;
#line 181 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp12_ = g_uri_escape_string (_tmp11_, "", TRUE);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_g_free0 (escaped);
#line 181 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		escaped = _tmp12_;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp13_ = path;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp14_ = escaped;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp15_ = g_strconcat ("/tr/", _tmp14_, NULL);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp16_ = _tmp15_;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_g_free0 (path);
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		path = _tmp17_;
#line 182 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_g_free0 (_tmp16_);
#line 1781 "rygel-http-item-uri.c"
	} else {
		gint _tmp18_;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp18_ = self->thumbnail_index;
#line 183 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		if (_tmp18_ >= 0) {
#line 1788 "rygel-http-item-uri.c"
			const gchar* _tmp19_;
			gint _tmp20_;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp19_ = path;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp20_ = self->thumbnail_index;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp21_ = g_strdup_printf ("%i", _tmp20_);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp22_ = _tmp21_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp23_ = g_strconcat ("/th/", _tmp22_, NULL);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp24_ = _tmp23_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp25_ = g_strconcat (_tmp19_, _tmp24_, NULL);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (path);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			path = _tmp25_;
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (_tmp24_);
#line 184 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_g_free0 (_tmp22_);
#line 1818 "rygel-http-item-uri.c"
		} else {
			gint _tmp26_;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			_tmp26_ = self->subtitle_index;
#line 185 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			if (_tmp26_ >= 0) {
#line 1825 "rygel-http-item-uri.c"
				const gchar* _tmp27_;
				gint _tmp28_;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp27_ = path;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp28_ = self->subtitle_index;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp29_ = g_strdup_printf ("%i", _tmp28_);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp30_ = _tmp29_;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp31_ = g_strconcat ("/sub/", _tmp30_, NULL);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp32_ = _tmp31_;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp33_ = g_strconcat (_tmp27_, _tmp32_, NULL);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_g_free0 (path);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				path = _tmp33_;
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_g_free0 (_tmp32_);
#line 186 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_g_free0 (_tmp30_);
#line 1855 "rygel-http-item-uri.c"
			}
		}
	}
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp34_ = path;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp35_ = rygel_http_item_uri_get_extension (self);
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp36_ = _tmp35_;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp37_ = _tmp36_;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp38_ = g_strconcat (_tmp34_, _tmp37_, NULL);
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (path);
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	path = _tmp38_;
#line 188 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (_tmp37_);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp39_ = path;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp40_ = rygel_http_item_uri_create_uri_for_path (self, _tmp39_);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	result = _tmp40_;
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (path);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (escaped);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	data = (g_free (data), NULL);
#line 189 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return result;
#line 1889 "rygel-http-item-uri.c"
}


static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self, const gchar* path) {
	gchar* result = NULL;
	RygelHTTPServer* _tmp0_;
	GUPnPContext* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	RygelHTTPServer* _tmp4_;
	GUPnPContext* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	RygelHTTPServer* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
#line 192 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 192 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = self->http_server;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp1_ = _tmp0_->context;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp2_ = gssdp_client_get_host_ip ((GSSDPClient*) _tmp1_);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp3_ = _tmp2_;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp4_ = self->http_server;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp5_ = _tmp4_->context;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp6_ = gupnp_context_get_port (_tmp5_);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp7_ = _tmp6_;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp8_ = self->http_server;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp9_ = rygel_http_server_get_path_root (_tmp8_);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp10_ = _tmp9_;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp11_ = path;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp12_ = g_strdup_printf ("http://%s:%u%s%s", _tmp3_, _tmp7_, _tmp10_, _tmp11_);
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	result = _tmp12_;
#line 193 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return result;
#line 1942 "rygel-http-item-uri.c"
}


static gchar* rygel_http_item_uri_ext_from_mime_type (RygelHTTPItemURI* self, const gchar* mime_type) {
	gchar* result = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp28_;
	const gchar* _tmp29_;
	gboolean _tmp30_ = FALSE;
	gchar* _tmp34_;
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 199 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (mime_type != NULL, NULL);
#line 200 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = rygel_http_item_uri_mime_to_ext;
#line 200 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp0_ == NULL) {
#line 1961 "rygel-http-item-uri.c"
		GeeHashMap* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_ = NULL;
		gchar** videos;
		gint videos_length1;
		gint _videos_size_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		GeeHashMap* _tmp13_;
		GeeHashMap* _tmp14_;
		GeeHashMap* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar** _tmp18_ = NULL;
		gchar** images;
		gint images_length1;
		gint _images_size_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		GeeHashMap* _tmp26_;
		GeeHashMap* _tmp27_;
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_g_object_unref0 (rygel_http_item_uri_mime_to_ext);
#line 201 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		rygel_http_item_uri_mime_to_ext = _tmp1_;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp2_ = g_strdup ("mpeg");
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp3_ = g_strdup ("webm");
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp4_ = g_strdup ("ogg");
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp5_ = g_new0 (gchar*, 3 + 1);
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp5_[0] = _tmp2_;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp5_[1] = _tmp3_;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp5_[2] = _tmp4_;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		videos = _tmp5_;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		videos_length1 = 3;
#line 203 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_videos_size_ = videos_length1;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp6_ = videos;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp6__length1 = videos_length1;
#line 2015 "rygel-http-item-uri.c"
		{
			gchar** video_collection = NULL;
			gint video_collection_length1 = 0;
			gint _video_collection_size_ = 0;
			gint video_it = 0;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			video_collection = _tmp6_;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			video_collection_length1 = _tmp6__length1;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			for (video_it = 0; video_it < _tmp6__length1; video_it = video_it + 1) {
#line 2027 "rygel-http-item-uri.c"
				gchar* _tmp7_;
				gchar* video = NULL;
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp7_ = g_strdup (video_collection[video_it]);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				video = _tmp7_;
#line 2034 "rygel-http-item-uri.c"
				{
					GeeHashMap* _tmp8_;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					const gchar* _tmp12_;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp8_ = rygel_http_item_uri_mime_to_ext;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp9_ = video;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp10_ = g_strconcat ("video/", _tmp9_, NULL);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp11_ = _tmp10_;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp12_ = video;
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp11_, _tmp12_);
#line 206 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_free0 (_tmp11_);
#line 205 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_free0 (video);
#line 2057 "rygel-http-item-uri.c"
				}
			}
		}
#line 208 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp13_ = rygel_http_item_uri_mime_to_ext;
#line 208 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, "video/x-matroska", "mkv");
#line 211 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp14_ = rygel_http_item_uri_mime_to_ext;
#line 211 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, "audio/x-wav", "wav");
#line 212 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp15_ = rygel_http_item_uri_mime_to_ext;
#line 212 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, "audio/x-matroska", "mka");
#line 215 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp16_ = g_strdup ("jpeg");
#line 215 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp17_ = g_strdup ("png");
#line 215 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp18_ = g_new0 (gchar*, 2 + 1);
#line 215 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp18_[0] = _tmp16_;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp18_[1] = _tmp17_;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		images = _tmp18_;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		images_length1 = 2;
#line 215 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_images_size_ = images_length1;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp19_ = images;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp19__length1 = images_length1;
#line 2093 "rygel-http-item-uri.c"
		{
			gchar** image_collection = NULL;
			gint image_collection_length1 = 0;
			gint _image_collection_size_ = 0;
			gint image_it = 0;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			image_collection = _tmp19_;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			image_collection_length1 = _tmp19__length1;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
			for (image_it = 0; image_it < _tmp19__length1; image_it = image_it + 1) {
#line 2105 "rygel-http-item-uri.c"
				gchar* _tmp20_;
				gchar* image = NULL;
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				_tmp20_ = g_strdup (image_collection[image_it]);
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
				image = _tmp20_;
#line 2112 "rygel-http-item-uri.c"
				{
					GeeHashMap* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					const gchar* _tmp25_;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp21_ = rygel_http_item_uri_mime_to_ext;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp22_ = image;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp23_ = g_strconcat ("image/", _tmp22_, NULL);
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp24_ = _tmp23_;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_tmp25_ = image;
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, _tmp24_, _tmp25_);
#line 218 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_free0 (_tmp24_);
#line 217 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
					_g_free0 (image);
#line 2135 "rygel-http-item-uri.c"
				}
			}
		}
#line 222 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp26_ = rygel_http_item_uri_mime_to_ext;
#line 222 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, "text/srt", "srt");
#line 225 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp27_ = rygel_http_item_uri_mime_to_ext;
#line 225 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, "application/ogg", "ogg");
#line 200 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		images = (_vala_array_free (images, images_length1, (GDestroyNotify) g_free), NULL);
#line 200 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		videos = (_vala_array_free (videos, videos_length1, (GDestroyNotify) g_free), NULL);
#line 2151 "rygel-http-item-uri.c"
	}
#line 228 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp28_ = rygel_http_item_uri_mime_to_ext;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp29_ = mime_type;
#line 228 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp30_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp28_, _tmp29_);
#line 228 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (_tmp30_) {
#line 2161 "rygel-http-item-uri.c"
		GeeHashMap* _tmp31_;
		const gchar* _tmp32_;
		gpointer _tmp33_ = NULL;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp31_ = rygel_http_item_uri_mime_to_ext;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp32_ = mime_type;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp33_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp31_, _tmp32_);
#line 229 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		result = (gchar*) _tmp33_;
#line 229 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		return result;
#line 2175 "rygel-http-item-uri.c"
	}
#line 232 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp34_ = g_strdup ("");
#line 232 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	result = _tmp34_;
#line 232 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return result;
#line 2183 "rygel-http-item-uri.c"
}


gchar* rygel_http_item_uri_get_extension (RygelHTTPItemURI* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp3_;
#line 36 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = self->priv->real_extension;
#line 37 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	if (g_strcmp0 (_tmp0_, "") != 0) {
#line 2197 "rygel-http-item-uri.c"
		const gchar* _tmp1_;
		gchar* _tmp2_;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp1_ = self->priv->real_extension;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		_tmp2_ = g_strconcat (".", _tmp1_, NULL);
#line 38 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		result = _tmp2_;
#line 38 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		return result;
#line 2208 "rygel-http-item-uri.c"
	}
#line 40 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp3_ = g_strdup ("");
#line 40 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	result = _tmp3_;
#line 40 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	return result;
#line 2216 "rygel-http-item-uri.c"
}


void rygel_http_item_uri_set_extension (RygelHTTPItemURI* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_return_if_fail (self != NULL);
#line 43 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp0_ = value;
#line 43 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 43 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->priv->real_extension);
#line 43 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->priv->real_extension = _tmp1_;
#line 42 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_object_notify ((GObject *) self, "extension");
#line 2235 "rygel-http-item-uri.c"
}


static void rygel_http_item_uri_class_init (RygelHTTPItemURIClass * klass) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	rygel_http_item_uri_parent_class = g_type_class_peek_parent (klass);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_type_class_add_private (klass, sizeof (RygelHTTPItemURIPrivate));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_item_uri_get_property;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_item_uri_set_property;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_uri_finalize;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_EXTENSION, g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2252 "rygel-http-item-uri.c"
}


static void rygel_http_item_uri_instance_init (RygelHTTPItemURI * self) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self->priv = RYGEL_HTTP_ITEM_URI_GET_PRIVATE (self);
#line 2259 "rygel-http-item-uri.c"
}


static void rygel_http_item_uri_finalize (GObject* obj) {
	RygelHTTPItemURI * self;
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
#line 29 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->item_id);
#line 32 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->transcode_target);
#line 34 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	_g_free0 (self->priv->real_extension);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	G_OBJECT_CLASS (rygel_http_item_uri_parent_class)->finalize (obj);
#line 2275 "rygel-http-item-uri.c"
}


GType rygel_http_item_uri_get_type (void) {
	static volatile gsize rygel_http_item_uri_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_item_uri_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemURIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_uri_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemURI), 0, (GInstanceInitFunc) rygel_http_item_uri_instance_init, NULL };
		GType rygel_http_item_uri_type_id;
		rygel_http_item_uri_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemURI", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_item_uri_type_id__volatile, rygel_http_item_uri_type_id);
	}
	return rygel_http_item_uri_type_id__volatile;
}


static void _vala_rygel_http_item_uri_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPItemURI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	switch (property_id) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_EXTENSION:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		g_value_take_string (value, rygel_http_item_uri_get_extension (self));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 2302 "rygel-http-item-uri.c"
		default:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 2308 "rygel-http-item-uri.c"
	}
}


static void _vala_rygel_http_item_uri_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPItemURI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
	switch (property_id) {
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		case RYGEL_HTTP_ITEM_URI_EXTENSION:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		rygel_http_item_uri_set_extension (self, g_value_get_string (value));
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 2324 "rygel-http-item-uri.c"
		default:
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 28 "/home/jens/Source/rygel/tests/rygel-http-item-uri.vala"
		break;
#line 2330 "rygel-http-item-uri.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



