/* rygel-media-export-root-container.c generated by valac 0.18.0.2-2c22, the Vala compiler
 * generated from rygel-media-export-root-container.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-server.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>
#include <rygel-core.h>


#define RYGEL_MEDIA_EXPORT_TYPE_FOLDER_DEFINITION (rygel_media_export_folder_definition_get_type ())
typedef struct _RygelMediaExportFolderDefinition RygelMediaExportFolderDefinition;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;
typedef struct _RygelMediaExportDBContainerPrivate RygelMediaExportDBContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER (rygel_media_export_root_container_get_type ())
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainer))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_ROOT_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER))
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerClass))

typedef struct _RygelMediaExportRootContainer RygelMediaExportRootContainer;
typedef struct _RygelMediaExportRootContainerClass RygelMediaExportRootContainerClass;
typedef struct _RygelMediaExportRootContainerPrivate RygelMediaExportRootContainerPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE (rygel_media_export_dbus_service_get_type ())
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE, RygelMediaExportDBusService))
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE, RygelMediaExportDBusServiceClass))
#define RYGEL_MEDIA_EXPORT_IS_DBUS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE))
#define RYGEL_MEDIA_EXPORT_IS_DBUS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE))
#define RYGEL_MEDIA_EXPORT_DBUS_SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DBUS_SERVICE, RygelMediaExportDBusServiceClass))

typedef struct _RygelMediaExportDBusService RygelMediaExportDBusService;
typedef struct _RygelMediaExportDBusServiceClass RygelMediaExportDBusServiceClass;

#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTER (rygel_media_export_harvester_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvester))
#define RYGEL_MEDIA_EXPORT_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER))
#define RYGEL_MEDIA_EXPORT_HARVESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTER, RygelMediaExportHarvesterClass))

typedef struct _RygelMediaExportHarvester RygelMediaExportHarvester;
typedef struct _RygelMediaExportHarvesterClass RygelMediaExportHarvesterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY (rygel_media_export_query_container_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactory))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER_FACTORY, RygelMediaExportQueryContainerFactoryClass))

typedef struct _RygelMediaExportQueryContainerFactory RygelMediaExportQueryContainerFactory;
typedef struct _RygelMediaExportQueryContainerFactoryClass RygelMediaExportQueryContainerFactoryClass;

#define RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER (rygel_media_export_query_container_get_type ())
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainer))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_QUERY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_QUERY_CONTAINER, RygelMediaExportQueryContainerClass))

typedef struct _RygelMediaExportQueryContainer RygelMediaExportQueryContainer;
typedef struct _RygelMediaExportQueryContainerClass RygelMediaExportQueryContainerClass;
typedef struct _RygelMediaExportRootContainerFindObjectData RygelMediaExportRootContainerFindObjectData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
typedef struct _RygelMediaExportRootContainerSearchData RygelMediaExportRootContainerSearchData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _RygelMediaExportFolderDefinition {
	gchar* title;
	gchar* definition;
};

struct _RygelMediaExportDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaExportDBContainerPrivate * priv;
	RygelMediaExportMediaCache* media_db;
};

struct _RygelMediaExportDBContainerClass {
	RygelMediaContainerClass parent_class;
	void (*search) (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*search_finish) (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
};

struct _RygelMediaExportRootContainer {
	RygelMediaExportDBContainer parent_instance;
	RygelMediaExportRootContainerPrivate * priv;
};

struct _RygelMediaExportRootContainerClass {
	RygelMediaExportDBContainerClass parent_class;
};

struct _RygelMediaExportRootContainerPrivate {
	RygelMediaExportDBusService* service;
	RygelMediaExportHarvester* harvester;
	GCancellable* cancellable;
	RygelMediaContainer* filesystem_container;
	gulong harvester_signal_id;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _RygelMediaExportRootContainerFindObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportRootContainer* self;
	gchar* id;
	GCancellable* cancellable;
	RygelMediaObject* result;
	const gchar* _tmp0_;
	GCancellable* _tmp1_;
	RygelMediaObject* _tmp2_;
	RygelMediaObject* object;
	gboolean _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	RygelMediaExportQueryContainerFactory* _tmp7_;
	RygelMediaExportQueryContainerFactory* factory;
	RygelMediaExportQueryContainerFactory* _tmp8_;
	RygelMediaExportMediaCache* _tmp9_;
	const gchar* _tmp10_;
	RygelMediaExportQueryContainer* _tmp11_;
	RygelMediaExportQueryContainer* container;
	RygelMediaExportQueryContainer* _tmp12_;
	RygelMediaExportQueryContainer* _tmp13_;
	GError * _inner_error_;
};

struct _RygelMediaExportRootContainerSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportRootContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	gchar* sort_criteria;
	GCancellable* cancellable;
	RygelMediaObjects* result;
	RygelSearchExpression* _tmp0_;
	RygelSearchExpression* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	const gchar* _tmp4_;
	GCancellable* _tmp5_;
	guint _tmp6_;
	RygelMediaObjects* _tmp7_;
	RygelMediaObjects* _tmp8_;
	RygelMediaObjects* list;
	RygelMediaContainer* query_container;
	gchar* upnp_class;
	RygelSearchExpression* _tmp9_;
	RygelSearchExpression* _tmp10_;
	RygelRelationalExpression* _tmp11_;
	RygelRelationalExpression* relational_expression;
	RygelRelationalExpression* _tmp12_;
	RygelMediaExportQueryContainer* _tmp13_;
	RygelRelationalExpression* _tmp14_;
	gconstpointer _tmp15_;
	gchar* _tmp16_;
	RygelSearchExpression* _tmp17_;
	RygelMediaContainer* _tmp18_;
	gboolean _tmp19_;
	RygelMediaContainer* _tmp20_;
	RygelMediaContainer* _tmp21_;
	guint _tmp22_;
	guint _tmp23_;
	const gchar* _tmp24_;
	GCancellable* _tmp25_;
	RygelMediaObjects* _tmp26_;
	RygelMediaObjects* _tmp27_;
	RygelMediaContainer* _tmp28_;
	gint _tmp29_;
	const gchar* _tmp30_;
	RygelMediaObjects* _tmp31_;
	RygelMediaObjects* _tmp32_;
	RygelMediaObjects* _object_list;
	RygelMediaObjects* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gint _object_size;
	gint _object_index;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	RygelMediaObjects* _tmp39_;
	gint _tmp40_;
	gpointer _tmp41_;
	RygelMediaObject* object;
	RygelMediaObject* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	RygelSearchExpression* _tmp45_;
	guint _tmp46_;
	guint _tmp47_;
	const gchar* _tmp48_;
	GCancellable* _tmp49_;
	guint _tmp50_;
	RygelMediaObjects* _tmp51_;
	RygelMediaObjects* _tmp52_;
	GError * _inner_error_;
};


static gpointer rygel_media_export_root_container_parent_class = NULL;
static RygelMediaContainer* rygel_media_export_root_container_instance;
static RygelMediaContainer* rygel_media_export_root_container_instance = NULL;
static GError* rygel_media_export_root_container_creation_error;
static GError* rygel_media_export_root_container_creation_error = NULL;

GType rygel_media_export_folder_definition_get_type (void) G_GNUC_CONST;
RygelMediaExportFolderDefinition* rygel_media_export_folder_definition_dup (const RygelMediaExportFolderDefinition* self);
void rygel_media_export_folder_definition_free (RygelMediaExportFolderDefinition* self);
void rygel_media_export_folder_definition_copy (const RygelMediaExportFolderDefinition* self, RygelMediaExportFolderDefinition* dest);
void rygel_media_export_folder_definition_destroy (RygelMediaExportFolderDefinition* self);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_root_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dbus_service_get_type (void) G_GNUC_CONST;
guint rygel_media_export_dbus_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType rygel_media_export_harvester_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainerPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_DUMMY_PROPERTY
};
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME "Files & Folders"
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID "Filesystem"
#define RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "virtual-container:"
#define RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_SEARCH_CONTAINER_PREFIX RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX "upnp:class," RYGEL_MUSIC_ITEM_UPNP_CLASS ","
RygelMediaContainer* rygel_media_export_root_container_get_instance (GError** error);
static RygelMediaExportRootContainer* rygel_media_export_root_container_new (GError** error);
static RygelMediaExportRootContainer* rygel_media_export_root_container_construct (GType object_type, GError** error);
RygelNullContainer* rygel_null_container_new (void);
RygelNullContainer* rygel_null_container_construct (GType object_type);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
RygelMediaContainer* rygel_media_export_root_container_get_filesystem_container (RygelMediaExportRootContainer* self);
void rygel_media_export_root_container_shutdown (RygelMediaExportRootContainer* self);
void rygel_media_export_root_container_add_uri (RygelMediaExportRootContainer* self, const gchar* uri);
void rygel_media_export_harvester_schedule (RygelMediaExportHarvester* self, GFile* file, RygelMediaContainer* parent, const gchar* flag);
void rygel_media_export_root_container_remove_uri (RygelMediaExportRootContainer* self, const gchar* uri);
gchar* rygel_media_export_media_cache_get_id (GFile* file);
void rygel_media_export_harvester_cancel (RygelMediaExportHarvester* self, GFile* file);
GQuark rygel_media_export_database_error_quark (void);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error);
gchar** rygel_media_export_root_container_get_dynamic_uris (RygelMediaExportRootContainer* self, int* result_length1);
GeeList* rygel_media_export_media_cache_get_flagged_uris (RygelMediaExportMediaCache* self, const gchar* flag, GError** error);
static void rygel_media_export_root_container_real_find_object_data_free (gpointer _data);
static void rygel_media_export_root_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_root_container_real_find_object_co (RygelMediaExportRootContainerFindObjectData* _data_);
static void rygel_media_export_root_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_media_export_query_container_factory_get_type (void) G_GNUC_CONST;
RygelMediaExportQueryContainerFactory* rygel_media_export_query_container_factory_get_default (void);
GType rygel_media_export_query_container_get_type (void) G_GNUC_CONST;
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_id (RygelMediaExportQueryContainerFactory* self, RygelMediaExportMediaCache* cache, const gchar* id, const gchar* name);
static void rygel_media_export_root_container_real_search_data_free (gpointer _data);
static void rygel_media_export_root_container_real_search (RygelMediaExportDBContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_root_container_real_search_co (RygelMediaExportRootContainerSearchData* _data_);
void rygel_media_export_db_container_search (RygelMediaExportDBContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_export_db_container_search_finish (RygelMediaExportDBContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
static void rygel_media_export_root_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static RygelMediaExportQueryContainer* rygel_media_export_root_container_search_to_virtual_container (RygelMediaExportRootContainer* self, RygelRelationalExpression* expression);
static gboolean rygel_media_export_root_container_is_search_in_virtual_container (RygelMediaExportRootContainer* self, RygelSearchExpression* expression, RygelMediaContainer** container);
static GeeArrayList* rygel_media_export_root_container_get_shared_uris (RygelMediaExportRootContainer* self);
RygelMediaExportQueryContainer* rygel_media_export_query_container_factory_create_from_description (RygelMediaExportQueryContainerFactory* self, RygelMediaExportMediaCache* cache, const gchar* definition, const gchar* name);
gchar* rygel_media_export_query_container_factory_get_virtual_container_definition (RygelMediaExportQueryContainerFactory* self, const gchar* hash);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
RygelMediaExportDBContainer* rygel_media_export_db_container_new (RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
RygelMediaExportDBContainer* rygel_media_export_db_container_construct (GType object_type, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title);
RygelMediaExportDBusService* rygel_media_export_dbus_service_new (RygelMediaExportRootContainer* root_container, GError** error);
RygelMediaExportDBusService* rygel_media_export_dbus_service_construct (GType object_type, RygelMediaExportRootContainer* root_container, GError** error);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
RygelMediaExportHarvester* rygel_media_export_harvester_new (GCancellable* cancellable, GeeArrayList* locations);
RygelMediaExportHarvester* rygel_media_export_harvester_construct (GType object_type, GCancellable* cancellable, GeeArrayList* locations);
static void rygel_media_export_root_container_on_initial_harvesting_done (RygelMediaExportRootContainer* self);
static void _rygel_media_export_root_container_on_initial_harvesting_done_rygel_media_export_harvester_done (RygelMediaExportHarvester* _sender, gpointer self);
GeeArrayList* rygel_media_export_harvester_get_locations (RygelMediaExportHarvester* self);
void rygel_media_export_media_cache_debug_statistics (RygelMediaExportMediaCache* self);
static void rygel_media_export_root_container_add_default_virtual_folders (RygelMediaExportRootContainer* self);
static void __lambda6_ (RygelMediaExportRootContainer* self);
static void ___lambda6__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self);
static void rygel_media_export_root_container_add_virtual_containers_for_class (RygelMediaExportRootContainer* self, const gchar* parent, const gchar* item_class, RygelMediaExportFolderDefinition* definitions, int definitions_length1, GError** error);
static void rygel_media_export_root_container_add_folder_definition (RygelMediaExportRootContainer* self, RygelMediaContainer* container, const gchar* item_class, RygelMediaExportFolderDefinition* definition, GError** error);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
static void rygel_media_export_root_container_finalize (GObject* obj);

const RygelMediaExportFolderDefinition VIRTUAL_FOLDERS_DEFAULT[2] = {{"Year", "dc:date,?"}, {"All", ""}};
const RygelMediaExportFolderDefinition VIRTUAL_FOLDERS_MUSIC[3] = {{"Artist", "upnp:artist,?,upnp:album,?"}, {"Album", "upnp:album,?"}, {"Genre", "dc:genre,?"}};

void rygel_media_export_folder_definition_copy (const RygelMediaExportFolderDefinition* self, RygelMediaExportFolderDefinition* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).title;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).title);
	(*dest).title = _tmp1_;
	_tmp2_ = (*self).definition;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).definition);
	(*dest).definition = _tmp3_;
}


void rygel_media_export_folder_definition_destroy (RygelMediaExportFolderDefinition* self) {
	_g_free0 ((*self).title);
	_g_free0 ((*self).definition);
}


RygelMediaExportFolderDefinition* rygel_media_export_folder_definition_dup (const RygelMediaExportFolderDefinition* self) {
	RygelMediaExportFolderDefinition* dup;
	dup = g_new0 (RygelMediaExportFolderDefinition, 1);
	rygel_media_export_folder_definition_copy (self, dup);
	return dup;
}


void rygel_media_export_folder_definition_free (RygelMediaExportFolderDefinition* self) {
	rygel_media_export_folder_definition_destroy (self);
	g_free (self);
}


GType rygel_media_export_folder_definition_get_type (void) {
	static volatile gsize rygel_media_export_folder_definition_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_folder_definition_type_id__volatile)) {
		GType rygel_media_export_folder_definition_type_id;
		rygel_media_export_folder_definition_type_id = g_boxed_type_register_static ("RygelMediaExportFolderDefinition", (GBoxedCopyFunc) rygel_media_export_folder_definition_dup, (GBoxedFreeFunc) rygel_media_export_folder_definition_free);
		g_once_init_leave (&rygel_media_export_folder_definition_type_id__volatile, rygel_media_export_folder_definition_type_id);
	}
	return rygel_media_export_folder_definition_type_id__volatile;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaContainer* rygel_media_export_root_container_get_instance (GError** error) {
	RygelMediaContainer* result = NULL;
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp9_;
	RygelMediaContainer* _tmp10_;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_media_export_root_container_instance;
	if (_tmp0_ == NULL) {
		{
			RygelMediaExportRootContainer* _tmp1_;
			RygelMediaExportRootContainer* _tmp2_;
			_tmp1_ = rygel_media_export_root_container_new (&_inner_error_);
			_tmp2_ = _tmp1_;
			if (_inner_error_ != NULL) {
				goto __catch26_g_error;
			}
			_g_object_unref0 (rygel_media_export_root_container_instance);
			rygel_media_export_root_container_instance = (RygelMediaContainer*) _tmp2_;
		}
		goto __finally26;
		__catch26_g_error:
		{
			GError* _error_ = NULL;
			RygelNullContainer* _tmp3_;
			GError* _tmp4_;
			GError* _tmp5_;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp3_ = rygel_null_container_new ();
			_g_object_unref0 (rygel_media_export_root_container_instance);
			rygel_media_export_root_container_instance = (RygelMediaContainer*) _tmp3_;
			_tmp4_ = _error_;
			_tmp5_ = _g_error_copy0 (_tmp4_);
			_g_error_free0 (rygel_media_export_root_container_creation_error);
			rygel_media_export_root_container_creation_error = _tmp5_;
			_g_error_free0 (_error_);
		}
		__finally26:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
	} else {
		GError* _tmp6_;
		_tmp6_ = rygel_media_export_root_container_creation_error;
		if (_tmp6_ != NULL) {
			GError* _tmp7_;
			GError* _tmp8_;
			_tmp7_ = rygel_media_export_root_container_creation_error;
			_tmp8_ = _g_error_copy0 (_tmp7_);
			_inner_error_ = _tmp8_;
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
	}
	_tmp9_ = rygel_media_export_root_container_instance;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	result = _tmp10_;
	return result;
}


RygelMediaContainer* rygel_media_export_root_container_get_filesystem_container (RygelMediaExportRootContainer* self) {
	RygelMediaContainer* result = NULL;
	RygelMediaContainer* _tmp0_;
	RygelMediaContainer* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->filesystem_container;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


void rygel_media_export_root_container_shutdown (RygelMediaExportRootContainer* self) {
	GCancellable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
}


void rygel_media_export_root_container_add_uri (RygelMediaExportRootContainer* self, const gchar* uri) {
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	RygelMediaExportHarvester* _tmp2_;
	RygelMediaContainer* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = uri;
	_tmp1_ = g_file_new_for_commandline_arg (_tmp0_);
	file = _tmp1_;
	_tmp2_ = self->priv->harvester;
	_tmp3_ = self->priv->filesystem_container;
	rygel_media_export_harvester_schedule (_tmp2_, file, _tmp3_, "DBUS");
	_g_object_unref0 (file);
}


void rygel_media_export_root_container_remove_uri (RygelMediaExportRootContainer* self, const gchar* uri) {
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	GFile* file;
	gchar* _tmp2_ = NULL;
	gchar* id;
	RygelMediaExportHarvester* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = uri;
	_tmp1_ = g_file_new_for_commandline_arg (_tmp0_);
	file = _tmp1_;
	_tmp2_ = rygel_media_export_media_cache_get_id (file);
	id = _tmp2_;
	_tmp3_ = self->priv->harvester;
	rygel_media_export_harvester_cancel (_tmp3_, file);
	{
		RygelMediaExportMediaCache* _tmp4_;
		_tmp4_ = ((RygelMediaExportDBContainer*) self)->media_db;
		rygel_media_export_media_cache_remove_by_id (_tmp4_, id, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch27_g_error;
		}
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = _ ("Failed to remove URI: %s");
		_tmp6_ = _error_;
		_tmp7_ = _tmp6_->message;
		g_warning (_tmp5_, _tmp7_);
		_g_error_free0 (_error_);
	}
	__finally27:
	if (_inner_error_ != NULL) {
		_g_free0 (id);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (id);
	_g_object_unref0 (file);
}


gchar** rygel_media_export_root_container_get_dynamic_uris (RygelMediaExportRootContainer* self, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		RygelMediaExportMediaCache* _tmp0_;
		GeeList* _tmp1_ = NULL;
		GeeList* uris;
		gint _tmp2_ = 0;
		gpointer* _tmp3_ = NULL;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp0_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp1_ = rygel_media_export_media_cache_get_flagged_uris (_tmp0_, "DBUS", &_inner_error_);
		uris = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch28_g_error;
		}
		_tmp3_ = gee_collection_to_array ((GeeCollection*) uris, &_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = _tmp2_;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		_g_object_unref0 (uris);
		return result;
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally28:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp5_ = g_new0 (gchar*, 0 + 1);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}


static void rygel_media_export_root_container_real_find_object_data_free (gpointer _data) {
	RygelMediaExportRootContainerFindObjectData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportRootContainerFindObjectData, _data_);
}


static void rygel_media_export_root_container_real_find_object (RygelMediaContainer* base, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportRootContainer * self;
	RygelMediaExportRootContainerFindObjectData* _data_;
	RygelMediaExportRootContainer* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	self = (RygelMediaExportRootContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportRootContainerFindObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_root_container_real_find_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_root_container_real_find_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = id;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->id);
	_data_->id = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	rygel_media_export_root_container_real_find_object_co (_data_);
}


static RygelMediaObject* rygel_media_export_root_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelMediaExportRootContainerFindObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_export_root_container_find_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportRootContainerFindObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_root_container_real_find_object_co (_data_);
}


static gboolean rygel_media_export_root_container_real_find_object_co (RygelMediaExportRootContainerFindObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->id;
	_data_->_tmp1_ = _data_->cancellable;
	_data_->_state_ = 1;
	RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object ((RygelMediaContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer), _data_->_tmp0_, _data_->_tmp1_, rygel_media_export_root_container_find_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = RYGEL_MEDIA_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->find_object_finish ((RygelMediaContainer*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer), _data_->_res_, &_data_->_inner_error_);
	_data_->object = _data_->_tmp2_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->object == NULL) {
		_data_->_tmp4_ = _data_->id;
		_data_->_tmp5_ = FALSE;
		_data_->_tmp5_ = g_str_has_prefix (_data_->_tmp4_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX);
		_data_->_tmp3_ = _data_->_tmp5_;
	} else {
		_data_->_tmp3_ = FALSE;
	}
	_data_->_tmp6_ = _data_->_tmp3_;
	if (_data_->_tmp6_) {
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = rygel_media_export_query_container_factory_get_default ();
		_data_->factory = _data_->_tmp7_;
		_data_->_tmp8_ = _data_->factory;
		_data_->_tmp9_ = ((RygelMediaExportDBContainer*) _data_->self)->media_db;
		_data_->_tmp10_ = _data_->id;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = rygel_media_export_query_container_factory_create_from_id (_data_->_tmp8_, _data_->_tmp9_, _data_->_tmp10_, "");
		_data_->container = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->container;
		if (_data_->_tmp12_ != NULL) {
			_data_->_tmp13_ = _data_->container;
			((RygelMediaObject*) _data_->_tmp13_)->parent = (RygelMediaContainer*) _data_->self;
		}
		_data_->result = (RygelMediaObject*) _data_->container;
		_g_object_unref0 (_data_->factory);
		_g_object_unref0 (_data_->object);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->object;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->object);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_media_export_root_container_real_search_data_free (gpointer _data) {
	RygelMediaExportRootContainerSearchData* _data_;
	_data_ = _data;
	_rygel_search_expression_unref0 (_data_->expression);
	_g_free0 (_data_->sort_criteria);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaExportRootContainerSearchData, _data_);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_media_export_root_container_real_search (RygelMediaExportDBContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportRootContainer * self;
	RygelMediaExportRootContainerSearchData* _data_;
	RygelMediaExportRootContainer* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelSearchExpression* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
	self = (RygelMediaExportRootContainer*) base;
	_data_ = g_slice_new0 (RygelMediaExportRootContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_root_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_root_container_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = expression;
	_tmp2_ = _rygel_search_expression_ref0 (_tmp1_);
	_rygel_search_expression_unref0 (_data_->expression);
	_data_->expression = _tmp2_;
	_tmp3_ = offset;
	_data_->offset = _tmp3_;
	_tmp4_ = max_count;
	_data_->max_count = _tmp4_;
	_tmp5_ = sort_criteria;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data_->sort_criteria);
	_data_->sort_criteria = _tmp6_;
	_tmp7_ = cancellable;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp8_;
	rygel_media_export_root_container_real_search_co (_data_);
}


static RygelMediaObjects* rygel_media_export_root_container_real_search_finish (RygelMediaExportDBContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	RygelMediaObjects* result;
	RygelMediaExportRootContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (total_matches) {
		*total_matches = _data_->total_matches;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_export_root_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportRootContainerSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_export_root_container_real_search_co (_data_);
}


static gboolean rygel_media_export_root_container_real_search_co (RygelMediaExportRootContainerSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->expression;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = _data_->expression;
		_data_->_tmp2_ = _data_->offset;
		_data_->_tmp3_ = _data_->max_count;
		_data_->_tmp4_ = _data_->sort_criteria;
		_data_->_tmp5_ = _data_->cancellable;
		_data_->_tmp6_ = 0U;
		_data_->_state_ = 1;
		RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer), _data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, _data_->_tmp5_, rygel_media_export_root_container_search_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer), _data_->_res_, &_data_->_tmp6_, &_data_->_inner_error_);
		_data_->total_matches = _data_->_tmp6_;
		_data_->_tmp8_ = _data_->_tmp7_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->result = _data_->_tmp8_;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->query_container = NULL;
	_data_->upnp_class = NULL;
	_data_->_tmp9_ = _data_->expression;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp9_, RYGEL_TYPE_RELATIONAL_EXPRESSION)) {
		_data_->_tmp10_ = _data_->expression;
		_data_->_tmp11_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp10_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) _data_->_tmp10_) : NULL);
		_data_->relational_expression = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->relational_expression;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = rygel_media_export_root_container_search_to_virtual_container (_data_->self, _data_->_tmp12_);
		_g_object_unref0 (_data_->query_container);
		_data_->query_container = (RygelMediaContainer*) _data_->_tmp13_;
		_data_->_tmp14_ = _data_->relational_expression;
		_data_->_tmp15_ = ((RygelSearchExpression*) _data_->_tmp14_)->operand2;
		_data_->_tmp16_ = g_strdup ((const gchar*) _data_->_tmp15_);
		_g_free0 (_data_->upnp_class);
		_data_->upnp_class = _data_->_tmp16_;
		_rygel_search_expression_unref0 (_data_->relational_expression);
	} else {
		_data_->_tmp17_ = _data_->expression;
		_data_->_tmp18_ = NULL;
		_data_->_tmp19_ = FALSE;
		_data_->_tmp19_ = rygel_media_export_root_container_is_search_in_virtual_container (_data_->self, _data_->_tmp17_, &_data_->_tmp18_);
		_g_object_unref0 (_data_->query_container);
		_data_->query_container = _data_->_tmp18_;
		if (_data_->_tmp19_) {
		}
	}
	_data_->_tmp20_ = _data_->query_container;
	if (_data_->_tmp20_ != NULL) {
		_data_->_tmp21_ = _data_->query_container;
		_data_->_tmp22_ = _data_->offset;
		_data_->_tmp23_ = _data_->max_count;
		_data_->_tmp24_ = _data_->sort_criteria;
		_data_->_tmp25_ = _data_->cancellable;
		_data_->_state_ = 2;
		rygel_media_container_get_children (_data_->_tmp21_, _data_->_tmp22_, _data_->_tmp23_, _data_->_tmp24_, _data_->_tmp25_, rygel_media_export_root_container_search_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = rygel_media_container_get_children_finish (_data_->_tmp21_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp27_ = _data_->_tmp26_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->upnp_class);
			_g_object_unref0 (_data_->query_container);
			_g_object_unref0 (_data_->list);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->list);
		_data_->list = _data_->_tmp27_;
		_data_->_tmp28_ = _data_->query_container;
		_data_->_tmp29_ = _data_->_tmp28_->child_count;
		_data_->total_matches = (guint) _data_->_tmp29_;
		_data_->_tmp30_ = _data_->upnp_class;
		if (_data_->_tmp30_ != NULL) {
			{
				_data_->_tmp31_ = _data_->list;
				_data_->_tmp32_ = _g_object_ref0 (_data_->_tmp31_);
				_data_->_object_list = _data_->_tmp32_;
				_data_->_tmp33_ = _data_->_object_list;
				_data_->_tmp34_ = gee_abstract_collection_get_size ((GeeCollection*) _data_->_tmp33_);
				_data_->_tmp35_ = _data_->_tmp34_;
				_data_->_object_size = _data_->_tmp35_;
				_data_->_object_index = -1;
				while (TRUE) {
					_data_->_tmp36_ = _data_->_object_index;
					_data_->_object_index = _data_->_tmp36_ + 1;
					_data_->_tmp37_ = _data_->_object_index;
					_data_->_tmp38_ = _data_->_object_size;
					if (!(_data_->_tmp37_ < _data_->_tmp38_)) {
						break;
					}
					_data_->_tmp39_ = _data_->_object_list;
					_data_->_tmp40_ = _data_->_object_index;
					_data_->_tmp41_ = NULL;
					_data_->_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp39_, _data_->_tmp40_);
					_data_->object = (RygelMediaObject*) _data_->_tmp41_;
					_data_->_tmp42_ = _data_->object;
					_data_->_tmp43_ = _data_->upnp_class;
					_data_->_tmp44_ = g_strdup (_data_->_tmp43_);
					_g_free0 (_data_->_tmp42_->upnp_class);
					_data_->_tmp42_->upnp_class = _data_->_tmp44_;
					_g_object_unref0 (_data_->object);
				}
				_g_object_unref0 (_data_->_object_list);
			}
		}
		_data_->result = _data_->list;
		_g_free0 (_data_->upnp_class);
		_g_object_unref0 (_data_->query_container);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp45_ = _data_->expression;
		_data_->_tmp46_ = _data_->offset;
		_data_->_tmp47_ = _data_->max_count;
		_data_->_tmp48_ = _data_->sort_criteria;
		_data_->_tmp49_ = _data_->cancellable;
		_data_->_tmp50_ = 0U;
		_data_->_state_ = 3;
		RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer), _data_->_tmp45_, _data_->_tmp46_, _data_->_tmp47_, _data_->_tmp48_, _data_->_tmp49_, rygel_media_export_root_container_search_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp51_ = NULL;
		_data_->_tmp51_ = RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (rygel_media_export_root_container_parent_class)->search_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer), _data_->_res_, &_data_->_tmp50_, &_data_->_inner_error_);
		_data_->total_matches = _data_->_tmp50_;
		_data_->_tmp52_ = _data_->_tmp51_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->upnp_class);
			_g_object_unref0 (_data_->query_container);
			_g_object_unref0 (_data_->list);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->result = _data_->_tmp52_;
		_g_free0 (_data_->upnp_class);
		_g_object_unref0 (_data_->query_container);
		_g_object_unref0 (_data_->list);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->upnp_class);
	_g_object_unref0 (_data_->query_container);
	_g_object_unref0 (_data_->list);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch31_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch31_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally31;
	__catch31_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally31:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static GeeArrayList* rygel_media_export_root_container_get_shared_uris (RygelMediaExportRootContainer* self) {
	GeeArrayList* result = NULL;
	GeeArrayList* uris = NULL;
	GeeArrayList* actual_uris = NULL;
	RygelMetaConfig* _tmp0_ = NULL;
	RygelMetaConfig* config;
	GeeArrayList* _tmp9_;
	const gchar* _tmp10_ = NULL;
	GFile* _tmp11_ = NULL;
	GFile* home_dir;
	const gchar* _tmp12_ = NULL;
	const gchar* pictures_dir;
	const gchar* _tmp13_ = NULL;
	const gchar* videos_dir;
	const gchar* _tmp14_ = NULL;
	const gchar* music_dir;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = rygel_meta_config_get_default ();
	config = _tmp0_;
	{
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* _tmp2_;
		_tmp1_ = rygel_configuration_get_string_list ((RygelConfiguration*) config, "MediaExport", "uris", &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch29_g_error;
		}
		_g_object_unref0 (uris);
		uris = _tmp2_;
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* _error_ = NULL;
		GeeArrayList* _tmp3_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
		_g_object_unref0 (uris);
		uris = _tmp3_;
		_g_error_free0 (_error_);
	}
	__finally29:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		_g_object_unref0 (actual_uris);
		_g_object_unref0 (uris);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		RygelMediaExportMediaCache* _tmp4_;
		GeeList* _tmp5_ = NULL;
		GeeList* _tmp6_;
		GeeArrayList* _tmp7_;
		GeeList* _tmp8_;
		_tmp4_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp5_ = rygel_media_export_media_cache_get_flagged_uris (_tmp4_, "DBUS", &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch30_g_error;
		}
		_tmp7_ = uris;
		_tmp8_ = _tmp6_;
		gee_abstract_collection_add_all ((GeeAbstractCollection*) _tmp7_, (GeeCollection*) _tmp8_);
		_g_object_unref0 (_tmp8_);
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally30:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (config);
		_g_object_unref0 (actual_uris);
		_g_object_unref0 (uris);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp9_ = gee_array_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_g_object_unref0 (actual_uris);
	actual_uris = _tmp9_;
	_tmp10_ = g_get_home_dir ();
	_tmp11_ = g_file_new_for_path (_tmp10_);
	home_dir = _tmp11_;
	_tmp12_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
	pictures_dir = _tmp12_;
	_tmp13_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
	videos_dir = _tmp13_;
	_tmp14_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
	music_dir = _tmp14_;
	{
		GeeArrayList* _tmp15_;
		GeeArrayList* _tmp16_;
		GeeArrayList* _uri_list;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _uri_size;
		gint _uri_index;
		_tmp15_ = uris;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		_uri_list = _tmp16_;
		_tmp17_ = _uri_list;
		_tmp18_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_uri_size = _tmp19_;
		_uri_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			GeeArrayList* _tmp23_;
			gint _tmp24_;
			gpointer _tmp25_ = NULL;
			gchar* uri;
			const gchar* _tmp26_;
			GFile* _tmp27_ = NULL;
			GFile* file;
			GFile* _tmp28_;
			GFile* _tmp29_;
			gboolean _tmp30_ = FALSE;
			GeeArrayList* _tmp52_;
			GFile* _tmp53_;
			_tmp20_ = _uri_index;
			_uri_index = _tmp20_ + 1;
			_tmp21_ = _uri_index;
			_tmp22_ = _uri_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _uri_list;
			_tmp24_ = _uri_index;
			_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _tmp24_);
			uri = (gchar*) _tmp25_;
			_tmp26_ = uri;
			_tmp27_ = g_file_new_for_commandline_arg (_tmp26_);
			file = _tmp27_;
			_tmp28_ = file;
			_tmp29_ = home_dir;
			_tmp30_ = G_LIKELY (_tmp28_ != _tmp29_);
			if (_tmp30_) {
				const gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* actual_uri;
				const gchar* _tmp33_;
				gboolean _tmp34_ = FALSE;
				const gchar* _tmp38_;
				gboolean _tmp39_ = FALSE;
				const gchar* _tmp43_;
				gboolean _tmp44_ = FALSE;
				const gchar* _tmp48_;
				GFile* _tmp49_ = NULL;
				GFile* _tmp50_;
				GFile* _tmp51_;
				_tmp31_ = uri;
				_tmp32_ = g_strdup (_tmp31_);
				actual_uri = _tmp32_;
				_tmp33_ = pictures_dir;
				_tmp34_ = G_LIKELY (_tmp33_ != NULL);
				if (_tmp34_) {
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_ = NULL;
					_tmp35_ = actual_uri;
					_tmp36_ = pictures_dir;
					_tmp37_ = string_replace (_tmp35_, "@PICTURES@", _tmp36_);
					_g_free0 (actual_uri);
					actual_uri = _tmp37_;
				}
				_tmp38_ = videos_dir;
				_tmp39_ = G_LIKELY (_tmp38_ != NULL);
				if (_tmp39_) {
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					gchar* _tmp42_ = NULL;
					_tmp40_ = actual_uri;
					_tmp41_ = videos_dir;
					_tmp42_ = string_replace (_tmp40_, "@VIDEOS@", _tmp41_);
					_g_free0 (actual_uri);
					actual_uri = _tmp42_;
				}
				_tmp43_ = music_dir;
				_tmp44_ = G_LIKELY (_tmp43_ != NULL);
				if (_tmp44_) {
					const gchar* _tmp45_;
					const gchar* _tmp46_;
					gchar* _tmp47_ = NULL;
					_tmp45_ = actual_uri;
					_tmp46_ = music_dir;
					_tmp47_ = string_replace (_tmp45_, "@MUSIC@", _tmp46_);
					_g_free0 (actual_uri);
					actual_uri = _tmp47_;
				}
				_tmp48_ = actual_uri;
				_tmp49_ = g_file_new_for_commandline_arg (_tmp48_);
				_g_object_unref0 (file);
				file = _tmp49_;
				_tmp50_ = file;
				_tmp51_ = home_dir;
				if (_tmp50_ == _tmp51_) {
					_g_free0 (actual_uri);
					_g_object_unref0 (file);
					_g_free0 (uri);
					continue;
				}
				_g_free0 (actual_uri);
			}
			_tmp52_ = actual_uris;
			_tmp53_ = file;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp52_, _tmp53_);
			_g_object_unref0 (file);
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_list);
	}
	result = actual_uris;
	_g_object_unref0 (home_dir);
	_g_object_unref0 (config);
	_g_object_unref0 (uris);
	return result;
}


static RygelMediaExportQueryContainer* rygel_media_export_root_container_search_to_virtual_container (RygelMediaExportRootContainer* self, RygelRelationalExpression* expression) {
	RygelMediaExportQueryContainer* result = NULL;
	gboolean _tmp0_ = FALSE;
	RygelRelationalExpression* _tmp1_;
	gconstpointer _tmp2_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expression != NULL, NULL);
	_tmp1_ = expression;
	_tmp2_ = ((RygelSearchExpression*) _tmp1_)->operand1;
	if (g_strcmp0 ((const gchar*) _tmp2_, "upnp:class") == 0) {
		RygelRelationalExpression* _tmp3_;
		gconstpointer _tmp4_;
		_tmp3_ = expression;
		_tmp4_ = ((RygelSearchExpression*) _tmp3_)->op;
		_tmp0_ = ((GUPnPSearchCriteriaOp) ((gintptr) _tmp4_)) == GUPNP_SEARCH_CRITERIA_OP_EQ;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		gchar* _tmp6_;
		gchar* id;
		RygelRelationalExpression* _tmp7_;
		gconstpointer _tmp8_;
		const gchar* _tmp9_;
		GQuark _tmp11_ = 0U;
		static GQuark _tmp10_label0 = 0;
		static GQuark _tmp10_label1 = 0;
		static GQuark _tmp10_label2 = 0;
		RygelMediaExportQueryContainerFactory* _tmp18_ = NULL;
		RygelMediaExportQueryContainerFactory* factory;
		RygelMediaExportQueryContainerFactory* _tmp19_;
		RygelMediaExportMediaCache* _tmp20_;
		const gchar* _tmp21_;
		RygelMediaExportQueryContainer* _tmp22_ = NULL;
		_tmp6_ = g_strdup (RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_SEARCH_CONTAINER_PREFIX);
		id = _tmp6_;
		_tmp7_ = expression;
		_tmp8_ = ((RygelSearchExpression*) _tmp7_)->operand2;
		_tmp9_ = (const gchar*) _tmp8_;
		_tmp11_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
		if (_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string ("object.container.album.musicAlbum")))) {
			switch (0) {
				default:
				{
					const gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp12_ = id;
					_tmp13_ = g_strconcat (_tmp12_, "upnp:album,?", NULL);
					_g_free0 (id);
					id = _tmp13_;
					break;
				}
			}
		} else if (_tmp11_ == ((0 != _tmp10_label1) ? _tmp10_label1 : (_tmp10_label1 = g_quark_from_static_string ("object.container.person.musicArtist")))) {
			switch (0) {
				default:
				{
					const gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp14_ = id;
					_tmp15_ = g_strconcat (_tmp14_, "dc:creator,?,upnp:album,?", NULL);
					_g_free0 (id);
					id = _tmp15_;
					break;
				}
			}
		} else if (_tmp11_ == ((0 != _tmp10_label2) ? _tmp10_label2 : (_tmp10_label2 = g_quark_from_static_string ("object.container.genre.musicGenre")))) {
			switch (0) {
				default:
				{
					const gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp16_ = id;
					_tmp17_ = g_strconcat (_tmp16_, "dc:genre,?", NULL);
					_g_free0 (id);
					id = _tmp17_;
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					result = NULL;
					_g_free0 (id);
					return result;
				}
			}
		}
		_tmp18_ = rygel_media_export_query_container_factory_get_default ();
		factory = _tmp18_;
		_tmp19_ = factory;
		_tmp20_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp21_ = id;
		_tmp22_ = rygel_media_export_query_container_factory_create_from_description (_tmp19_, _tmp20_, _tmp21_, "");
		result = _tmp22_;
		_g_object_unref0 (factory);
		_g_free0 (id);
		return result;
	}
	result = NULL;
	return result;
}


/**
     * Check if a passed search expression is a simple search in a virtual
     * container.
     *
     * @param expression the expression to check
     * @param new_id contains the id of the virtual container constructed from
     *               the search
     * @param upnp_class contains the class of the container the search was
     *                   looking in
     * @return true if it was a search in virtual container, false otherwise.
     * @note This works single level only. Enough to satisfy Xbox music
     *       browsing, but may need refinement
     */
static gboolean rygel_media_export_root_container_is_search_in_virtual_container (RygelMediaExportRootContainer* self, RygelSearchExpression* expression, RygelMediaContainer** container) {
	RygelMediaContainer* _vala_container = NULL;
	gboolean result = FALSE;
	RygelRelationalExpression* virtual_expression;
	RygelMediaExportQueryContainer* query_container = NULL;
	RygelSearchExpression* _tmp0_;
	RygelSearchExpression* _tmp1_;
	RygelLogicalExpression* _tmp2_;
	RygelLogicalExpression* logical_expression;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	RygelLogicalExpression* _tmp5_;
	gconstpointer _tmp6_;
	gboolean _tmp9_;
	gboolean _tmp12_;
	RygelLogicalExpression* _tmp13_;
	gconstpointer _tmp14_;
	RygelRelationalExpression* _tmp15_;
	RygelRelationalExpression* left_expression;
	RygelLogicalExpression* _tmp16_;
	gconstpointer _tmp17_;
	RygelRelationalExpression* _tmp18_;
	RygelRelationalExpression* right_expression;
	RygelRelationalExpression* _tmp19_;
	RygelMediaExportQueryContainer* _tmp20_ = NULL;
	RygelMediaExportQueryContainer* _tmp21_;
	RygelMediaExportQueryContainerFactory* _tmp29_ = NULL;
	RygelMediaExportQueryContainerFactory* factory;
	RygelMediaExportQueryContainerFactory* _tmp30_;
	RygelMediaExportQueryContainer* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_ = NULL;
	gchar* plaintext_id;
	const gchar* _tmp34_;
	gchar* _tmp35_ = NULL;
	gchar* last_argument;
	RygelRelationalExpression* _tmp36_;
	gconstpointer _tmp37_;
	gchar* _tmp38_ = NULL;
	gchar* escaped_detail;
	RygelRelationalExpression* _tmp39_;
	gconstpointer _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_ = NULL;
	gchar* new_id;
	RygelMediaExportQueryContainerFactory* _tmp44_;
	RygelMediaExportMediaCache* _tmp45_;
	const gchar* _tmp46_;
	RygelMediaExportQueryContainer* _tmp47_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (expression != NULL, FALSE);
	virtual_expression = NULL;
	_g_object_unref0 (_vala_container);
	_vala_container = NULL;
	_tmp0_ = expression;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, RYGEL_TYPE_LOGICAL_EXPRESSION)) {
		result = FALSE;
		_g_object_unref0 (query_container);
		_rygel_search_expression_unref0 (virtual_expression);
		if (container) {
			*container = _vala_container;
		} else {
			_g_object_unref0 (_vala_container);
		}
		return result;
	}
	_tmp1_ = expression;
	_tmp2_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, RYGEL_TYPE_LOGICAL_EXPRESSION) ? ((RygelLogicalExpression*) _tmp1_) : NULL);
	logical_expression = _tmp2_;
	_tmp5_ = logical_expression;
	_tmp6_ = ((RygelSearchExpression*) _tmp5_)->operand1;
	if (G_TYPE_CHECK_INSTANCE_TYPE ((RygelSearchExpression*) _tmp6_, RYGEL_TYPE_RELATIONAL_EXPRESSION)) {
		RygelLogicalExpression* _tmp7_;
		gconstpointer _tmp8_;
		_tmp7_ = logical_expression;
		_tmp8_ = ((RygelSearchExpression*) _tmp7_)->operand2;
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE ((RygelSearchExpression*) _tmp8_, RYGEL_TYPE_RELATIONAL_EXPRESSION);
	} else {
		_tmp4_ = FALSE;
	}
	_tmp9_ = _tmp4_;
	if (_tmp9_) {
		RygelLogicalExpression* _tmp10_;
		gconstpointer _tmp11_;
		_tmp10_ = logical_expression;
		_tmp11_ = ((RygelSearchExpression*) _tmp10_)->op;
		_tmp3_ = ((RygelLogicalOperator) ((gintptr) _tmp11_)) == RYGEL_LOGICAL_OPERATOR_AND;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp12_ = _tmp3_;
	if (!_tmp12_) {
		result = FALSE;
		_rygel_search_expression_unref0 (logical_expression);
		_g_object_unref0 (query_container);
		_rygel_search_expression_unref0 (virtual_expression);
		if (container) {
			*container = _vala_container;
		} else {
			_g_object_unref0 (_vala_container);
		}
		return result;
	}
	_tmp13_ = logical_expression;
	_tmp14_ = ((RygelSearchExpression*) _tmp13_)->operand1;
	_tmp15_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE ((RygelSearchExpression*) _tmp14_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) ((RygelSearchExpression*) _tmp14_)) : NULL);
	left_expression = _tmp15_;
	_tmp16_ = logical_expression;
	_tmp17_ = ((RygelSearchExpression*) _tmp16_)->operand2;
	_tmp18_ = _rygel_search_expression_ref0 (G_TYPE_CHECK_INSTANCE_TYPE ((RygelSearchExpression*) _tmp17_, RYGEL_TYPE_RELATIONAL_EXPRESSION) ? ((RygelRelationalExpression*) ((RygelSearchExpression*) _tmp17_)) : NULL);
	right_expression = _tmp18_;
	_tmp19_ = left_expression;
	_tmp20_ = rygel_media_export_root_container_search_to_virtual_container (self, _tmp19_);
	_g_object_unref0 (query_container);
	query_container = _tmp20_;
	_tmp21_ = query_container;
	if (_tmp21_ == NULL) {
		RygelRelationalExpression* _tmp22_;
		RygelMediaExportQueryContainer* _tmp23_ = NULL;
		RygelMediaExportQueryContainer* _tmp24_;
		_tmp22_ = right_expression;
		_tmp23_ = rygel_media_export_root_container_search_to_virtual_container (self, _tmp22_);
		_g_object_unref0 (query_container);
		query_container = _tmp23_;
		_tmp24_ = query_container;
		if (_tmp24_ != NULL) {
			RygelRelationalExpression* _tmp25_;
			RygelRelationalExpression* _tmp26_;
			_tmp25_ = left_expression;
			_tmp26_ = _rygel_search_expression_ref0 (_tmp25_);
			_rygel_search_expression_unref0 (virtual_expression);
			virtual_expression = _tmp26_;
		} else {
			result = FALSE;
			_rygel_search_expression_unref0 (right_expression);
			_rygel_search_expression_unref0 (left_expression);
			_rygel_search_expression_unref0 (logical_expression);
			_g_object_unref0 (query_container);
			_rygel_search_expression_unref0 (virtual_expression);
			if (container) {
				*container = _vala_container;
			} else {
				_g_object_unref0 (_vala_container);
			}
			return result;
		}
	} else {
		RygelRelationalExpression* _tmp27_;
		RygelRelationalExpression* _tmp28_;
		_tmp27_ = right_expression;
		_tmp28_ = _rygel_search_expression_ref0 (_tmp27_);
		_rygel_search_expression_unref0 (virtual_expression);
		virtual_expression = _tmp28_;
	}
	_tmp29_ = rygel_media_export_query_container_factory_get_default ();
	factory = _tmp29_;
	_tmp30_ = factory;
	_tmp31_ = query_container;
	_tmp32_ = ((RygelMediaObject*) _tmp31_)->id;
	_tmp33_ = rygel_media_export_query_container_factory_get_virtual_container_definition (_tmp30_, _tmp32_);
	plaintext_id = _tmp33_;
	_tmp34_ = plaintext_id;
	_tmp35_ = string_replace (_tmp34_, RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, "");
	last_argument = _tmp35_;
	_tmp36_ = virtual_expression;
	_tmp37_ = ((RygelSearchExpression*) _tmp36_)->operand2;
	_tmp38_ = g_uri_escape_string ((const gchar*) _tmp37_, "", TRUE);
	escaped_detail = _tmp38_;
	_tmp39_ = virtual_expression;
	_tmp40_ = ((RygelSearchExpression*) _tmp39_)->operand1;
	_tmp41_ = escaped_detail;
	_tmp42_ = last_argument;
	_tmp43_ = g_strdup_printf ("%s%s,%s,%s", RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, (const gchar*) _tmp40_, _tmp41_, _tmp42_);
	new_id = _tmp43_;
	_tmp44_ = factory;
	_tmp45_ = ((RygelMediaExportDBContainer*) self)->media_db;
	_tmp46_ = new_id;
	_tmp47_ = rygel_media_export_query_container_factory_create_from_description (_tmp44_, _tmp45_, _tmp46_, "");
	_g_object_unref0 (_vala_container);
	_vala_container = (RygelMediaContainer*) _tmp47_;
	result = TRUE;
	_g_free0 (new_id);
	_g_free0 (escaped_detail);
	_g_free0 (last_argument);
	_g_free0 (plaintext_id);
	_g_object_unref0 (factory);
	_rygel_search_expression_unref0 (right_expression);
	_rygel_search_expression_unref0 (left_expression);
	_rygel_search_expression_unref0 (logical_expression);
	_g_object_unref0 (query_container);
	_rygel_search_expression_unref0 (virtual_expression);
	if (container) {
		*container = _vala_container;
	} else {
		_g_object_unref0 (_vala_container);
	}
	return result;
}


/**
     * Create a new root container.
     */
static void _rygel_media_export_root_container_on_initial_harvesting_done_rygel_media_export_harvester_done (RygelMediaExportHarvester* _sender, gpointer self) {
	rygel_media_export_root_container_on_initial_harvesting_done (self);
}


static RygelMediaExportRootContainer* rygel_media_export_root_container_construct (GType object_type, GError** error) {
	RygelMediaExportRootContainer * self = NULL;
	RygelMediaExportMediaCache* _tmp0_ = NULL;
	RygelMediaExportMediaCache* db;
	const gchar* _tmp1_ = NULL;
	GCancellable* _tmp2_;
	GeeArrayList* ids = NULL;
	GCancellable* _tmp19_;
	GeeArrayList* _tmp20_ = NULL;
	GeeArrayList* _tmp21_;
	RygelMediaExportHarvester* _tmp22_;
	RygelMediaExportHarvester* _tmp23_;
	gulong _tmp24_ = 0UL;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_media_export_media_cache_get_default (&_inner_error_);
	db = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp1_ = _ ("@REALNAME@'s media");
	self = (RygelMediaExportRootContainer*) rygel_media_export_db_container_construct (object_type, db, "0", _tmp1_);
	_tmp2_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp2_;
	{
		RygelMediaExportDBusService* _tmp3_;
		RygelMediaExportDBusService* _tmp4_;
		_tmp3_ = rygel_media_export_dbus_service_new (self, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			goto __catch32_g_error;
		}
		_g_object_unref0 (self->priv->service);
		self->priv->service = _tmp4_;
	}
	goto __finally32;
	__catch32_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = _ ("Failed to create MediaExport D-Bus service: %s");
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_warning (_tmp5_, _tmp7_);
		_g_error_free0 (err);
	}
	__finally32:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (db);
		_g_object_unref0 (self);
		return NULL;
	}
	{
		RygelMediaExportMediaCache* _tmp8_;
		_tmp8_ = ((RygelMediaExportDBContainer*) self)->media_db;
		rygel_media_export_media_cache_save_container (_tmp8_, (RygelMediaContainer*) self, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch33_g_error;
		}
	}
	goto __finally33;
	__catch33_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally33:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (db);
		_g_object_unref0 (self);
		return NULL;
	}
	{
		RygelMediaExportMediaCache* _tmp9_;
		const gchar* _tmp10_ = NULL;
		RygelMediaExportDBContainer* _tmp11_;
		RygelMediaContainer* _tmp12_;
		RygelMediaExportMediaCache* _tmp13_;
		RygelMediaContainer* _tmp14_;
		_tmp9_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp10_ = _ (RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_NAME);
		_tmp11_ = rygel_media_export_db_container_new (_tmp9_, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, _tmp10_);
		_g_object_unref0 (self->priv->filesystem_container);
		self->priv->filesystem_container = (RygelMediaContainer*) _tmp11_;
		_tmp12_ = self->priv->filesystem_container;
		((RygelMediaObject*) _tmp12_)->parent = (RygelMediaContainer*) self;
		_tmp13_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp14_ = self->priv->filesystem_container;
		rygel_media_export_media_cache_save_container (_tmp13_, _tmp14_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch34_g_error;
		}
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally34:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (db);
		_g_object_unref0 (self);
		return NULL;
	}
	{
		RygelMediaExportMediaCache* _tmp15_;
		GeeArrayList* _tmp16_ = NULL;
		GeeArrayList* _tmp17_;
		_tmp15_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp16_ = rygel_media_export_media_cache_get_child_ids (_tmp15_, RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_FILESYSTEM_FOLDER_ID, &_inner_error_);
		_tmp17_ = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch35_rygel_media_export_database_error;
			}
			_g_object_unref0 (ids);
			_g_object_unref0 (db);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_object_unref0 (ids);
		ids = _tmp17_;
	}
	goto __finally35;
	__catch35_rygel_media_export_database_error:
	{
		GError* e = NULL;
		GeeArrayList* _tmp18_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
		_g_object_unref0 (ids);
		ids = _tmp18_;
		_g_error_free0 (e);
	}
	__finally35:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (ids);
		_g_object_unref0 (db);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp19_ = self->priv->cancellable;
	_tmp20_ = rygel_media_export_root_container_get_shared_uris (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = rygel_media_export_harvester_new (_tmp19_, _tmp21_);
	_g_object_unref0 (self->priv->harvester);
	self->priv->harvester = _tmp22_;
	_g_object_unref0 (_tmp21_);
	_tmp23_ = self->priv->harvester;
	_tmp24_ = g_signal_connect_object (_tmp23_, "done", (GCallback) _rygel_media_export_root_container_on_initial_harvesting_done_rygel_media_export_harvester_done, self, 0);
	self->priv->harvester_signal_id = _tmp24_;
	{
		RygelMediaExportHarvester* _tmp25_;
		GeeArrayList* _tmp26_;
		GeeArrayList* _tmp27_;
		GeeArrayList* _tmp28_;
		GeeArrayList* _file_list;
		GeeArrayList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _file_size;
		gint _file_index;
		_tmp25_ = self->priv->harvester;
		_tmp26_ = rygel_media_export_harvester_get_locations (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _g_object_ref0 (_tmp27_);
		_file_list = _tmp28_;
		_tmp29_ = _file_list;
		_tmp30_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_file_size = _tmp31_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			GeeArrayList* _tmp35_;
			gint _tmp36_;
			gpointer _tmp37_ = NULL;
			GFile* file;
			GeeArrayList* _tmp38_;
			GFile* _tmp39_;
			gchar* _tmp40_ = NULL;
			gchar* _tmp41_;
			RygelMediaExportHarvester* _tmp42_;
			GFile* _tmp43_;
			RygelMediaContainer* _tmp44_;
			_tmp32_ = _file_index;
			_file_index = _tmp32_ + 1;
			_tmp33_ = _file_index;
			_tmp34_ = _file_size;
			if (!(_tmp33_ < _tmp34_)) {
				break;
			}
			_tmp35_ = _file_list;
			_tmp36_ = _file_index;
			_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, _tmp36_);
			file = (GFile*) _tmp37_;
			_tmp38_ = ids;
			_tmp39_ = file;
			_tmp40_ = rygel_media_export_media_cache_get_id (_tmp39_);
			_tmp41_ = _tmp40_;
			gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp38_, _tmp41_);
			_g_free0 (_tmp41_);
			_tmp42_ = self->priv->harvester;
			_tmp43_ = file;
			_tmp44_ = self->priv->filesystem_container;
			rygel_media_export_harvester_schedule (_tmp42_, _tmp43_, _tmp44_, NULL);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_list);
	}
	{
		GeeArrayList* _tmp45_;
		GeeArrayList* _tmp46_;
		GeeArrayList* _id_list;
		GeeArrayList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _id_size;
		gint _id_index;
		_tmp45_ = ids;
		_tmp46_ = _g_object_ref0 (_tmp45_);
		_id_list = _tmp46_;
		_tmp47_ = _id_list;
		_tmp48_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_id_size = _tmp49_;
		_id_index = -1;
		while (TRUE) {
			gint _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			GeeArrayList* _tmp53_;
			gint _tmp54_;
			gpointer _tmp55_ = NULL;
			gchar* id;
			const gchar* _tmp56_;
			_tmp50_ = _id_index;
			_id_index = _tmp50_ + 1;
			_tmp51_ = _id_index;
			_tmp52_ = _id_size;
			if (!(_tmp51_ < _tmp52_)) {
				break;
			}
			_tmp53_ = _id_list;
			_tmp54_ = _id_index;
			_tmp55_ = gee_abstract_list_get ((GeeAbstractList*) _tmp53_, _tmp54_);
			id = (gchar*) _tmp55_;
			_tmp56_ = id;
			g_debug ("rygel-media-export-root-container.vala:397: ID %s no longer in config;" \
" deleting...", _tmp56_);
			{
				RygelMediaExportMediaCache* _tmp57_;
				const gchar* _tmp58_;
				_tmp57_ = ((RygelMediaExportDBContainer*) self)->media_db;
				_tmp58_ = id;
				rygel_media_export_media_cache_remove_by_id (_tmp57_, _tmp58_, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
						goto __catch36_rygel_media_export_database_error;
					}
					_g_free0 (id);
					_g_object_unref0 (_id_list);
					_g_object_unref0 (ids);
					_g_object_unref0 (db);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			goto __finally36;
			__catch36_rygel_media_export_database_error:
			{
				GError* _error_ = NULL;
				const gchar* _tmp59_ = NULL;
				GError* _tmp60_;
				const gchar* _tmp61_;
				_error_ = _inner_error_;
				_inner_error_ = NULL;
				_tmp59_ = _ ("Failed to remove entry: %s");
				_tmp60_ = _error_;
				_tmp61_ = _tmp60_->message;
				g_warning (_tmp59_, _tmp61_);
				_g_error_free0 (_error_);
			}
			__finally36:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (id);
				_g_object_unref0 (_id_list);
				_g_object_unref0 (ids);
				_g_object_unref0 (db);
				_g_object_unref0 (self);
				return NULL;
			}
			_g_free0 (id);
		}
		_g_object_unref0 (_id_list);
	}
	rygel_media_container_updated ((RygelMediaContainer*) self, (RygelMediaObject*) self, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
	_g_object_unref0 (ids);
	_g_object_unref0 (db);
	return self;
}


static RygelMediaExportRootContainer* rygel_media_export_root_container_new (GError** error) {
	return rygel_media_export_root_container_construct (RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, error);
}


static void __lambda6_ (RygelMediaExportRootContainer* self) {
	rygel_media_export_root_container_add_default_virtual_folders (self);
	rygel_media_container_updated ((RygelMediaContainer*) self, (RygelMediaObject*) self, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
}


static void ___lambda6__rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, RygelMediaObject* object, RygelObjectEventType event_type, gboolean sub_tree_update, gpointer self) {
	__lambda6_ (self);
}


static void rygel_media_export_root_container_on_initial_harvesting_done (RygelMediaExportRootContainer* self) {
	RygelMediaExportHarvester* _tmp0_;
	gulong _tmp1_;
	RygelMediaExportMediaCache* _tmp2_;
	RygelMediaContainer* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->harvester;
	_tmp1_ = self->priv->harvester_signal_id;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _tmp1_);
	_tmp2_ = ((RygelMediaExportDBContainer*) self)->media_db;
	rygel_media_export_media_cache_debug_statistics (_tmp2_);
	rygel_media_export_root_container_add_default_virtual_folders (self);
	rygel_media_container_updated ((RygelMediaContainer*) self, (RygelMediaObject*) self, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
	_tmp3_ = self->priv->filesystem_container;
	g_signal_connect_object (_tmp3_, "container-updated", (GCallback) ___lambda6__rygel_media_container_container_updated, self, 0);
}


static void rygel_media_export_root_container_add_default_virtual_folders (RygelMediaExportRootContainer* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		const gchar* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp0_ = _ ("Music");
		rygel_media_export_root_container_add_virtual_containers_for_class (self, _tmp0_, RYGEL_MUSIC_ITEM_UPNP_CLASS, VIRTUAL_FOLDERS_MUSIC, G_N_ELEMENTS (VIRTUAL_FOLDERS_MUSIC), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch37_g_error;
		}
		_tmp1_ = _ ("Pictures");
		rygel_media_export_root_container_add_virtual_containers_for_class (self, _tmp1_, RYGEL_PHOTO_ITEM_UPNP_CLASS, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch37_g_error;
		}
		_tmp2_ = _ ("Videos");
		rygel_media_export_root_container_add_virtual_containers_for_class (self, _tmp2_, RYGEL_VIDEO_ITEM_UPNP_CLASS, NULL, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch37_g_error;
		}
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally37:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static void rygel_media_export_root_container_add_folder_definition (RygelMediaExportRootContainer* self, RygelMediaContainer* container, const gchar* item_class, RygelMediaExportFolderDefinition* definition, GError** error) {
	const gchar* _tmp0_;
	RygelMediaExportFolderDefinition _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* id;
	const gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	RygelMediaExportQueryContainerFactory* _tmp8_ = NULL;
	RygelMediaExportQueryContainerFactory* factory;
	RygelMediaExportQueryContainerFactory* _tmp9_;
	RygelMediaExportMediaCache* _tmp10_;
	const gchar* _tmp11_;
	RygelMediaExportFolderDefinition _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_ = NULL;
	RygelMediaExportQueryContainer* _tmp15_ = NULL;
	RygelMediaExportQueryContainer* query_container;
	RygelMediaExportQueryContainer* _tmp16_;
	gint _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (item_class != NULL);
	g_return_if_fail (definition != NULL);
	_tmp0_ = item_class;
	_tmp1_ = *definition;
	_tmp2_ = _tmp1_.definition;
	_tmp3_ = g_strdup_printf ("%supnp:class,%s,%s", RYGEL_MEDIA_EXPORT_QUERY_CONTAINER_PREFIX, _tmp0_, _tmp2_);
	id = _tmp3_;
	_tmp4_ = id;
	_tmp5_ = g_str_has_suffix (_tmp4_, ",");
	if (_tmp5_) {
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		_tmp6_ = id;
		_tmp7_ = string_slice (_tmp6_, (glong) 0, (glong) (-1));
		_g_free0 (id);
		id = _tmp7_;
	}
	_tmp8_ = rygel_media_export_query_container_factory_get_default ();
	factory = _tmp8_;
	_tmp9_ = factory;
	_tmp10_ = ((RygelMediaExportDBContainer*) self)->media_db;
	_tmp11_ = id;
	_tmp12_ = *definition;
	_tmp13_ = _tmp12_.title;
	_tmp14_ = _ (_tmp13_);
	_tmp15_ = rygel_media_export_query_container_factory_create_from_description (_tmp9_, _tmp10_, _tmp11_, _tmp14_);
	query_container = _tmp15_;
	_tmp16_ = query_container;
	_tmp17_ = ((RygelMediaContainer*) _tmp16_)->child_count;
	if (_tmp17_ > 0) {
		RygelMediaExportQueryContainer* _tmp18_;
		RygelMediaContainer* _tmp19_;
		RygelMediaExportMediaCache* _tmp20_;
		RygelMediaExportQueryContainer* _tmp21_;
		_tmp18_ = query_container;
		_tmp19_ = container;
		((RygelMediaObject*) _tmp18_)->parent = _tmp19_;
		_tmp20_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp21_ = query_container;
		rygel_media_export_media_cache_save_container (_tmp20_, (RygelMediaContainer*) _tmp21_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (query_container);
			_g_object_unref0 (factory);
			_g_free0 (id);
			return;
		}
	} else {
		RygelMediaExportMediaCache* _tmp22_;
		const gchar* _tmp23_;
		_tmp22_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp23_ = id;
		rygel_media_export_media_cache_remove_by_id (_tmp22_, _tmp23_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (query_container);
			_g_object_unref0 (factory);
			_g_free0 (id);
			return;
		}
	}
	_g_object_unref0 (query_container);
	_g_object_unref0 (factory);
	_g_free0 (id);
}


static void rygel_media_export_root_container_add_virtual_containers_for_class (RygelMediaExportRootContainer* self, const gchar* parent, const gchar* item_class, RygelMediaExportFolderDefinition* definitions, int definitions_length1, GError** error) {
	RygelNullContainer* _tmp0_;
	RygelNullContainer* container;
	RygelNullContainer* _tmp1_;
	RygelNullContainer* _tmp2_;
	const gchar* _tmp3_;
	RygelNullContainer* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	RygelMediaExportMediaCache* _tmp7_;
	RygelNullContainer* _tmp8_;
	RygelMediaExportFolderDefinition* _tmp12_;
	gint _tmp12__length1;
	RygelMediaExportMediaCache* _tmp18_;
	RygelNullContainer* _tmp19_;
	const gchar* _tmp20_;
	gint _tmp21_ = 0;
	gint _tmp22_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent != NULL);
	g_return_if_fail (item_class != NULL);
	_tmp0_ = rygel_null_container_new ();
	container = _tmp0_;
	_tmp1_ = container;
	((RygelMediaObject*) _tmp1_)->parent = (RygelMediaContainer*) self;
	_tmp2_ = container;
	_tmp3_ = parent;
	rygel_media_object_set_title ((RygelMediaObject*) _tmp2_, _tmp3_);
	_tmp4_ = container;
	_tmp5_ = item_class;
	_tmp6_ = g_strconcat ("virtual-parent:", _tmp5_, NULL);
	_g_free0 (((RygelMediaObject*) _tmp4_)->id);
	((RygelMediaObject*) _tmp4_)->id = _tmp6_;
	_tmp7_ = ((RygelMediaExportDBContainer*) self)->media_db;
	_tmp8_ = container;
	rygel_media_export_media_cache_save_container (_tmp7_, (RygelMediaContainer*) _tmp8_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (container);
		return;
	}
	{
		RygelMediaExportFolderDefinition* definition_collection = NULL;
		gint definition_collection_length1 = 0;
		gint _definition_collection_size_ = 0;
		gint definition_it = 0;
		definition_collection = VIRTUAL_FOLDERS_DEFAULT;
		definition_collection_length1 = G_N_ELEMENTS (VIRTUAL_FOLDERS_DEFAULT);
		for (definition_it = 0; definition_it < G_N_ELEMENTS (VIRTUAL_FOLDERS_DEFAULT); definition_it = definition_it + 1) {
			RygelMediaExportFolderDefinition definition = {0};
			definition = definition_collection[definition_it];
			{
				RygelNullContainer* _tmp9_;
				const gchar* _tmp10_;
				RygelMediaExportFolderDefinition _tmp11_;
				_tmp9_ = container;
				_tmp10_ = item_class;
				_tmp11_ = definition;
				rygel_media_export_root_container_add_folder_definition (self, (RygelMediaContainer*) _tmp9_, _tmp10_, &_tmp11_, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (container);
					return;
				}
			}
		}
	}
	_tmp12_ = definitions;
	_tmp12__length1 = definitions_length1;
	if (_tmp12_ != NULL) {
		RygelMediaExportFolderDefinition* _tmp13_;
		gint _tmp13__length1;
		_tmp13_ = definitions;
		_tmp13__length1 = definitions_length1;
		{
			RygelMediaExportFolderDefinition* definition_collection = NULL;
			gint definition_collection_length1 = 0;
			gint _definition_collection_size_ = 0;
			gint definition_it = 0;
			definition_collection = _tmp13_;
			definition_collection_length1 = _tmp13__length1;
			for (definition_it = 0; definition_it < _tmp13__length1; definition_it = definition_it + 1) {
				RygelMediaExportFolderDefinition _tmp14_ = {0};
				RygelMediaExportFolderDefinition definition = {0};
				rygel_media_export_folder_definition_copy (&definition_collection[definition_it], &_tmp14_);
				definition = _tmp14_;
				{
					RygelNullContainer* _tmp15_;
					const gchar* _tmp16_;
					RygelMediaExportFolderDefinition _tmp17_;
					_tmp15_ = container;
					_tmp16_ = item_class;
					_tmp17_ = definition;
					rygel_media_export_root_container_add_folder_definition (self, (RygelMediaContainer*) _tmp15_, _tmp16_, &_tmp17_, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						rygel_media_export_folder_definition_destroy (&definition);
						_g_object_unref0 (container);
						return;
					}
					rygel_media_export_folder_definition_destroy (&definition);
				}
			}
		}
	}
	_tmp18_ = ((RygelMediaExportDBContainer*) self)->media_db;
	_tmp19_ = container;
	_tmp20_ = ((RygelMediaObject*) _tmp19_)->id;
	_tmp21_ = rygel_media_export_media_cache_get_child_count (_tmp18_, _tmp20_, &_inner_error_);
	_tmp22_ = _tmp21_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (container);
		return;
	}
	if (_tmp22_ == 0) {
		RygelMediaExportMediaCache* _tmp23_;
		RygelNullContainer* _tmp24_;
		const gchar* _tmp25_;
		_tmp23_ = ((RygelMediaExportDBContainer*) self)->media_db;
		_tmp24_ = container;
		_tmp25_ = ((RygelMediaObject*) _tmp24_)->id;
		rygel_media_export_media_cache_remove_by_id (_tmp23_, _tmp25_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (container);
			return;
		}
	} else {
		RygelNullContainer* _tmp26_;
		_tmp26_ = container;
		rygel_media_container_updated ((RygelMediaContainer*) _tmp26_, (RygelMediaObject*) self, RYGEL_OBJECT_EVENT_TYPE_MODIFIED, FALSE);
	}
	_g_object_unref0 (container);
}


static void rygel_media_export_root_container_class_init (RygelMediaExportRootContainerClass * klass) {
	rygel_media_export_root_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportRootContainerPrivate));
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_media_export_root_container_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_media_export_root_container_real_find_object_finish;
	RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (klass)->search = rygel_media_export_root_container_real_search;
	RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS (klass)->search_finish = rygel_media_export_root_container_real_search_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_root_container_finalize;
}


static void rygel_media_export_root_container_instance_init (RygelMediaExportRootContainer * self) {
	self->priv = RYGEL_MEDIA_EXPORT_ROOT_CONTAINER_GET_PRIVATE (self);
}


static void rygel_media_export_root_container_finalize (GObject* obj) {
	RygelMediaExportRootContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_MEDIA_EXPORT_TYPE_ROOT_CONTAINER, RygelMediaExportRootContainer);
	_g_object_unref0 (self->priv->service);
	_g_object_unref0 (self->priv->harvester);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->filesystem_container);
	G_OBJECT_CLASS (rygel_media_export_root_container_parent_class)->finalize (obj);
}


/**
 * Represents the root container.
 */
GType rygel_media_export_root_container_get_type (void) {
	static volatile gsize rygel_media_export_root_container_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_root_container_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportRootContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_root_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportRootContainer), 0, (GInstanceInitFunc) rygel_media_export_root_container_instance_init, NULL };
		GType rygel_media_export_root_container_type_id;
		rygel_media_export_root_container_type_id = g_type_register_static (RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, "RygelMediaExportRootContainer", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_root_container_type_id__volatile, rygel_media_export_root_container_type_id);
	}
	return rygel_media_export_root_container_type_id__volatile;
}



