/* rygel-item-updater.c generated by valac 0.18.0.2-2c22, the Vala compiler
 * generated from rygel-item-updater.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Krzesimir Nowak <krnowak@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel-core.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_ITEM_UPDATER (rygel_item_updater_get_type ())
#define RYGEL_ITEM_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater))
#define RYGEL_ITEM_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterClass))
#define RYGEL_IS_ITEM_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_UPDATER))
#define RYGEL_IS_ITEM_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_UPDATER))
#define RYGEL_ITEM_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterClass))

typedef struct _RygelItemUpdater RygelItemUpdater;
typedef struct _RygelItemUpdaterClass RygelItemUpdaterClass;
typedef struct _RygelItemUpdaterPrivate RygelItemUpdaterPrivate;

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GUPnPServiceAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_GUPnPServiceAction_free (var), NULL)))
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelItemUpdaterRunData RygelItemUpdaterRunData;
typedef struct _RygelItemUpdaterUpdateObjectData RygelItemUpdaterUpdateObjectData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelItemUpdaterFetchObjectData RygelItemUpdaterFetchObjectData;

struct _RygelItemUpdater {
	GObject parent_instance;
	RygelItemUpdaterPrivate * priv;
};

struct _RygelItemUpdaterClass {
	GObjectClass parent_class;
};

struct _RygelItemUpdaterPrivate {
	gchar* object_id;
	gchar* current_tag_value;
	gchar* new_tag_value;
	RygelContentDirectory* content_dir;
	GUPnPServiceAction* action;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE = 702,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE = 703,
	RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG = 704,
	RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG = 705,
	RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH = 706,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_OUTDATED_OBJECT_METADATA = 728,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelItemUpdaterRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemUpdater* self;
	GUPnPServiceAction* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _tmp3_;
	GUPnPServiceAction* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GError* _error_;
	GError* _tmp7_;
	GUPnPServiceAction* _tmp8_;
	GError* _tmp9_;
	gint _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GUPnPServiceAction* _tmp13_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GError * _inner_error_;
};

struct _RygelItemUpdaterUpdateObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemUpdater* self;
	RygelMediaObject* _tmp0_;
	RygelMediaObject* media_object;
	const gchar* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeLinkedList* current_list;
	const gchar* _tmp3_;
	GeeLinkedList* _tmp4_;
	GeeLinkedList* new_list;
	RygelMediaObject* _tmp5_;
	GeeLinkedList* _tmp6_;
	GeeLinkedList* _tmp7_;
	RygelContentDirectory* _tmp8_;
	RygelHTTPServer* _tmp9_;
	GUPnPDIDLLiteFragmentResult _tmp10_;
	GUPnPDIDLLiteFragmentResult _result_;
	GUPnPDIDLLiteFragmentResult _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GError* _tmp14_;
	GError* _tmp15_;
	GError* _tmp16_;
	GError* _tmp17_;
	GError * _inner_error_;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	guint object_update_id;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	void (*apply_didl_lite) (RygelMediaObject* self, GUPnPDIDLLiteObject* didl_object);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelItemUpdaterFetchObjectData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelItemUpdater* self;
	RygelMediaObject* result;
	RygelContentDirectory* _tmp0_;
	RygelMediaContainer* _tmp1_;
	const gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	RygelMediaObject* _tmp5_;
	RygelMediaObject* media_object;
	RygelMediaObject* _tmp6_;
	const gchar* _tmp7_;
	GError* _tmp8_;
	RygelMediaObject* _tmp9_;
	GUPnPOCMFlags _tmp10_;
	GUPnPOCMFlags _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* msg;
	const gchar* _tmp14_;
	RygelMediaObject* _tmp15_;
	const gchar* _tmp16_;
	GError* _tmp17_;
	RygelMediaObject* _tmp18_;
	RygelMediaContainer* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _vala1_msg;
	const gchar* _tmp24_;
	RygelMediaObject* _tmp25_;
	const gchar* _tmp26_;
	RygelMediaObject* _tmp27_;
	RygelMediaContainer* _tmp28_;
	const gchar* _tmp29_;
	GError* _tmp30_;
	GError * _inner_error_;
};


static gpointer rygel_item_updater_parent_class = NULL;
static RygelStateMachineIface* rygel_item_updater_rygel_state_machine_parent_iface = NULL;

GType rygel_item_updater_get_type (void) G_GNUC_CONST;
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
#define RYGEL_ITEM_UPDATER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdaterPrivate))
enum  {
	RYGEL_ITEM_UPDATER_DUMMY_PROPERTY,
	RYGEL_ITEM_UPDATER_CANCELLABLE
};
static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self);
RygelItemUpdater* rygel_item_updater_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemUpdater* rygel_item_updater_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
static void rygel_item_updater_real_run_data_free (gpointer _data);
static void rygel_item_updater_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_item_updater_real_run_co (RygelItemUpdaterRunData* _data_);
GQuark rygel_content_directory_error_quark (void);
static void rygel_item_updater_update_object (RygelItemUpdater* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_item_updater_update_object_finish (RygelItemUpdater* self, GAsyncResult* _res_, GError** error);
static void rygel_item_updater_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static GeeLinkedList* rygel_item_updater_csv_split (const gchar* tag_values);
static void rygel_item_updater_update_object_data_free (gpointer _data);
static gboolean rygel_item_updater_update_object_co (RygelItemUpdaterUpdateObjectData* _data_);
static void rygel_item_updater_fetch_object (RygelItemUpdater* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static RygelMediaObject* rygel_item_updater_fetch_object_finish (RygelItemUpdater* self, GAsyncResult* _res_, GError** error);
static void rygel_item_updater_update_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void rygel_media_object_apply_fragments (RygelMediaObject* self, GeeLinkedList* current_fragments, GeeLinkedList* new_fragments, RygelHTTPServer* http_server, GAsyncReadyCallback _callback_, gpointer _user_data_);
GUPnPDIDLLiteFragmentResult rygel_media_object_apply_fragments_finish (RygelMediaObject* self, GAsyncResult* _res_);
static void rygel_item_updater_fetch_object_data_free (gpointer _data);
static gboolean rygel_item_updater_fetch_object_co (RygelItemUpdaterFetchObjectData* _data_);
void rygel_media_container_find_object (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObject* rygel_media_container_find_object_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_item_updater_fetch_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GUPnPOCMFlags rygel_media_object_get_ocm_flags (RygelMediaObject* self);
gboolean rygel_media_object_get_restricted (RygelMediaObject* self);
static void rygel_item_updater_finalize (GObject* obj);
static void _vala_rygel_item_updater_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_item_updater_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _vala_GUPnPServiceAction_free (GUPnPServiceAction* self) {
	g_boxed_free (gupnp_service_action_get_type (), self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelItemUpdater* rygel_item_updater_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	RygelItemUpdater * self = NULL;
	RygelContentDirectory* _tmp0_;
	RygelContentDirectory* _tmp1_;
	RygelContentDirectory* _tmp2_;
	GCancellable* _tmp3_;
	GUPnPServiceAction* _tmp4_;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (action != NULL, NULL);
	self = (RygelItemUpdater*) g_object_new (object_type, NULL);
	_tmp0_ = content_dir;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->content_dir);
	self->priv->content_dir = _tmp1_;
	_tmp2_ = content_dir;
	_tmp3_ = _tmp2_->cancellable;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp3_);
	_tmp4_ = action;
	action = NULL;
	__vala_GUPnPServiceAction_free0 (self->priv->action);
	self->priv->action = _tmp4_;
	__vala_GUPnPServiceAction_free0 (action);
	return self;
}


RygelItemUpdater* rygel_item_updater_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action) {
	return rygel_item_updater_construct (RYGEL_TYPE_ITEM_UPDATER, content_dir, action);
}


static void rygel_item_updater_real_run_data_free (gpointer _data) {
	RygelItemUpdaterRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemUpdaterRunData, _data_);
}


static void rygel_item_updater_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemUpdater * self;
	RygelItemUpdaterRunData* _data_;
	RygelItemUpdater* _tmp0_;
	self = (RygelItemUpdater*) base;
	_data_ = g_slice_new0 (RygelItemUpdaterRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_updater_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_updater_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_item_updater_real_run_co (_data_);
}


static void rygel_item_updater_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelItemUpdaterRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_item_updater_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemUpdaterRunData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_updater_real_run_co (_data_);
}


static gboolean rygel_item_updater_real_run_co (RygelItemUpdaterRunData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->action;
		gupnp_service_action_get (_data_->_tmp0_, "ObjectID", G_TYPE_STRING, &_data_->self->priv->object_id, "CurrentTagValue", G_TYPE_STRING, &_data_->self->priv->current_tag_value, "NewTagValue", G_TYPE_STRING, &_data_->self->priv->new_tag_value, NULL);
		_data_->_tmp1_ = _data_->self->priv->object_id;
		if (_data_->_tmp1_ == NULL) {
			_data_->_tmp2_ = NULL;
			_data_->_tmp2_ = _ ("No such object");
			_data_->_tmp3_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp2_);
			_data_->_inner_error_ = _data_->_tmp3_;
			goto __catch48_g_error;
		}
		_data_->_state_ = 1;
		rygel_item_updater_update_object (_data_->self, rygel_item_updater_run_ready, _data_);
		return FALSE;
		_state_1:
		rygel_item_updater_update_object_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch48_g_error;
		}
		_data_->_tmp4_ = _data_->self->priv->action;
		gupnp_service_action_return (_data_->_tmp4_);
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _ ("Successfully updated object '%s'");
		_data_->_tmp6_ = _data_->self->priv->object_id;
		g_debug (_data_->_tmp5_, _data_->_tmp6_);
	}
	goto __finally48;
	__catch48_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp7_ = _data_->_error_;
		if (_data_->_tmp7_->domain == RYGEL_CONTENT_DIRECTORY_ERROR) {
			_data_->_tmp8_ = _data_->self->priv->action;
			_data_->_tmp9_ = _data_->_error_;
			_data_->_tmp10_ = _data_->_tmp9_->code;
			_data_->_tmp11_ = _data_->_error_;
			_data_->_tmp12_ = _data_->_tmp11_->message;
			gupnp_service_action_return_error (_data_->_tmp8_, (guint) _data_->_tmp10_, _data_->_tmp12_);
		} else {
			_data_->_tmp13_ = _data_->self->priv->action;
			_data_->_tmp14_ = _data_->_error_;
			_data_->_tmp15_ = _data_->_tmp14_->message;
			gupnp_service_action_return_error (_data_->_tmp13_, (guint) 701, _data_->_tmp15_);
		}
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _ ("Failed to update object '%s': %s");
		_data_->_tmp17_ = _data_->self->priv->object_id;
		_data_->_tmp18_ = _data_->_error_;
		_data_->_tmp19_ = _data_->_tmp18_->message;
		g_warning (_data_->_tmp16_, _data_->_tmp17_, _data_->_tmp19_);
		_g_error_free0 (_data_->_error_);
	}
	__finally48:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static GeeLinkedList* rygel_item_updater_csv_split (const gchar* tag_values) {
	GeeLinkedList* result = NULL;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* list;
	gboolean escape;
	gint token_start;
	gint token_length;
	gint _tmp1_ = 0;
	const gchar* _tmp2_;
	gint _tmp6_;
	gint len;
	gboolean _tmp26_ = FALSE;
	gint _tmp27_;
	gboolean _tmp31_;
	_tmp0_ = gee_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	list = _tmp0_;
	escape = FALSE;
	token_start = 0;
	token_length = 0;
	_tmp2_ = tag_values;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = tag_values;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = 0;
	}
	_tmp6_ = _tmp1_;
	len = _tmp6_;
	{
		gint iter;
		iter = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gint _tmp10_;
				gint _tmp11_;
				const gchar* _tmp12_;
				gint _tmp13_;
				gchar _tmp14_ = '\0';
				gchar c;
				gboolean _tmp15_;
				gint _tmp25_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = iter;
					iter = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = iter;
				_tmp11_ = len;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = tag_values;
				_tmp13_ = iter;
				_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
				c = _tmp14_;
				_tmp15_ = escape;
				if (_tmp15_) {
					escape = FALSE;
				} else {
					gchar _tmp16_;
					_tmp16_ = c;
					switch (_tmp16_) {
						case '\\':
						{
							escape = TRUE;
							break;
						}
						case ',':
						{
							GeeLinkedList* _tmp17_;
							const gchar* _tmp18_;
							gint _tmp19_;
							gint _tmp20_;
							gchar* _tmp21_ = NULL;
							gchar* _tmp22_;
							gint _tmp23_;
							gint _tmp24_;
							_tmp17_ = list;
							_tmp18_ = tag_values;
							_tmp19_ = token_start;
							_tmp20_ = token_length;
							_tmp21_ = string_substring (_tmp18_, (glong) _tmp19_, (glong) _tmp20_);
							_tmp22_ = _tmp21_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp22_);
							_g_free0 (_tmp22_);
							_tmp23_ = token_start;
							_tmp24_ = token_length;
							token_start = _tmp23_ + (_tmp24_ + 1);
							token_length = 0;
							break;
						}
						default:
						break;
					}
				}
				_tmp25_ = token_length;
				token_length = _tmp25_ + 1;
			}
		}
	}
	_tmp27_ = len;
	if (_tmp27_ > 0) {
		GeeLinkedList* _tmp28_;
		gboolean _tmp29_;
		gboolean _tmp30_;
		_tmp28_ = list;
		_tmp29_ = gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp26_ = _tmp30_;
	} else {
		_tmp26_ = FALSE;
	}
	_tmp31_ = _tmp26_;
	if (_tmp31_) {
		GeeLinkedList* _tmp32_;
		const gchar* _tmp33_;
		_tmp32_ = list;
		_tmp33_ = tag_values;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp33_);
	}
	result = list;
	return result;
}


static void rygel_item_updater_update_object_data_free (gpointer _data) {
	RygelItemUpdaterUpdateObjectData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemUpdaterUpdateObjectData, _data_);
}


static void rygel_item_updater_update_object (RygelItemUpdater* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemUpdaterUpdateObjectData* _data_;
	RygelItemUpdater* _tmp0_;
	_data_ = g_slice_new0 (RygelItemUpdaterUpdateObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_updater_update_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_updater_update_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_item_updater_update_object_co (_data_);
}


static void rygel_item_updater_update_object_finish (RygelItemUpdater* self, GAsyncResult* _res_, GError** error) {
	RygelItemUpdaterUpdateObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_item_updater_update_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemUpdaterUpdateObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_updater_update_object_co (_data_);
}


static gboolean rygel_item_updater_update_object_co (RygelItemUpdaterUpdateObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	rygel_item_updater_fetch_object (_data_->self, rygel_item_updater_update_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = rygel_item_updater_fetch_object_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->media_object = _data_->_tmp0_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->current_tag_value;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = rygel_item_updater_csv_split (_data_->_tmp1_);
	_data_->current_list = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->priv->new_tag_value;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = rygel_item_updater_csv_split (_data_->_tmp3_);
	_data_->new_list = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->media_object;
	_data_->_tmp6_ = _data_->current_list;
	_data_->_tmp7_ = _data_->new_list;
	_data_->_tmp8_ = _data_->self->priv->content_dir;
	_data_->_tmp9_ = _data_->_tmp8_->http_server;
	_data_->_state_ = 2;
	rygel_media_object_apply_fragments (_data_->_tmp5_, _data_->_tmp6_, _data_->_tmp7_, _data_->_tmp9_, rygel_item_updater_update_object_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp10_ = 0;
	_data_->_tmp10_ = rygel_media_object_apply_fragments_finish (_data_->_tmp5_, _data_->_res_);
	_data_->_result_ = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->_result_;
	switch (_data_->_tmp11_) {
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_OK:
		{
			break;
		}
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_CURRENT_BAD_XML:
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_CURRENT_INVALID:
		{
			_data_->_tmp12_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_CURRENT_TAG_VALUE, "Bad current tag value.");
			_data_->_inner_error_ = _data_->_tmp12_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_NEW_BAD_XML:
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_NEW_INVALID:
		{
			_data_->_tmp13_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_NEW_TAG_VALUE, "Bad current tag value.");
			_data_->_inner_error_ = _data_->_tmp13_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_REQUIRED_TAG:
		{
			_data_->_tmp14_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_REQUIRED_TAG, "Tried to delete required tag.");
			_data_->_inner_error_ = _data_->_tmp14_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_READONLY_TAG:
		{
			_data_->_tmp15_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_READ_ONLY_TAG, "Tried to change read-only property.");
			_data_->_inner_error_ = _data_->_tmp15_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		case GUPNP_DIDL_LITE_FRAGMENT_RESULT_MISMATCH:
		{
			_data_->_tmp16_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_PARAMETER_MISMATCH, "Parameter count mismatch.");
			_data_->_inner_error_ = _data_->_tmp16_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		default:
		{
			_data_->_tmp17_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, "Unknown error.");
			_data_->_inner_error_ = _data_->_tmp17_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->new_list);
			_g_object_unref0 (_data_->current_list);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->new_list);
	_g_object_unref0 (_data_->current_list);
	_g_object_unref0 (_data_->media_object);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_item_updater_fetch_object_data_free (gpointer _data) {
	RygelItemUpdaterFetchObjectData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelItemUpdaterFetchObjectData, _data_);
}


static void rygel_item_updater_fetch_object (RygelItemUpdater* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelItemUpdaterFetchObjectData* _data_;
	RygelItemUpdater* _tmp0_;
	_data_ = g_slice_new0 (RygelItemUpdaterFetchObjectData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_item_updater_fetch_object);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_item_updater_fetch_object_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_item_updater_fetch_object_co (_data_);
}


static RygelMediaObject* rygel_item_updater_fetch_object_finish (RygelItemUpdater* self, GAsyncResult* _res_, GError** error) {
	RygelMediaObject* result;
	RygelItemUpdaterFetchObjectData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_item_updater_fetch_object_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelItemUpdaterFetchObjectData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_item_updater_fetch_object_co (_data_);
}


static gboolean rygel_item_updater_fetch_object_co (RygelItemUpdaterFetchObjectData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->content_dir;
	_data_->_tmp1_ = _data_->_tmp0_->root_container;
	_data_->_tmp2_ = _data_->self->priv->object_id;
	_data_->_tmp3_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_state_ = 1;
	rygel_media_container_find_object (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp4_, rygel_item_updater_fetch_object_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = rygel_media_container_find_object_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
	_data_->media_object = _data_->_tmp5_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->media_object;
	if (_data_->_tmp6_ == NULL) {
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _ ("No such object");
		_data_->_tmp8_ = g_error_new_literal (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT, _data_->_tmp7_);
		_data_->_inner_error_ = _data_->_tmp8_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->media_object);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp9_ = _data_->media_object;
		_data_->_tmp10_ = rygel_media_object_get_ocm_flags (_data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		if (!((_data_->_tmp11_ & GUPNP_OCM_FLAGS_CHANGE_METADATA) == GUPNP_OCM_FLAGS_CHANGE_METADATA)) {
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = _ ("Metadata modification of object %s not allowed");
			_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
			_data_->msg = _data_->_tmp13_;
			_data_->_tmp14_ = _data_->msg;
			_data_->_tmp15_ = _data_->media_object;
			_data_->_tmp16_ = _data_->_tmp15_->id;
			_data_->_tmp17_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT, _data_->_tmp14_, _data_->_tmp16_);
			_data_->_inner_error_ = _data_->_tmp17_;
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->msg);
			_g_object_unref0 (_data_->media_object);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->_tmp18_ = _data_->media_object;
			_data_->_tmp19_ = _data_->_tmp18_->parent;
			_data_->_tmp20_ = rygel_media_object_get_restricted ((RygelMediaObject*) _data_->_tmp19_);
			_data_->_tmp21_ = _data_->_tmp20_;
			if (_data_->_tmp21_) {
				_data_->_tmp22_ = NULL;
				_data_->_tmp22_ = _ ("Metadata modification of object %s being a child " "of restricted object %s not allowed");
				_data_->_tmp23_ = g_strdup (_data_->_tmp22_);
				_data_->_vala1_msg = _data_->_tmp23_;
				_data_->_tmp24_ = _data_->_vala1_msg;
				_data_->_tmp25_ = _data_->media_object;
				_data_->_tmp26_ = _data_->_tmp25_->id;
				_data_->_tmp27_ = _data_->media_object;
				_data_->_tmp28_ = _data_->_tmp27_->parent;
				_data_->_tmp29_ = ((RygelMediaObject*) _data_->_tmp28_)->id;
				_data_->_tmp30_ = g_error_new (RYGEL_CONTENT_DIRECTORY_ERROR, RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT, _data_->_tmp24_, _data_->_tmp26_, _data_->_tmp29_);
				_data_->_inner_error_ = _data_->_tmp30_;
				g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
				g_error_free (_data_->_inner_error_);
				_g_free0 (_data_->_vala1_msg);
				_g_object_unref0 (_data_->media_object);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->result = _data_->media_object;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->media_object);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static GCancellable* rygel_item_updater_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelItemUpdater* self;
	GCancellable* _tmp0_;
	self = (RygelItemUpdater*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}


static void rygel_item_updater_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelItemUpdater* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	self = (RygelItemUpdater*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_cancellable);
	self->priv->_cancellable = _tmp1_;
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_item_updater_class_init (RygelItemUpdaterClass * klass) {
	rygel_item_updater_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelItemUpdaterPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_item_updater_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_item_updater_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_item_updater_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_ITEM_UPDATER_CANCELLABLE, g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void rygel_item_updater_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_item_updater_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*)(RygelStateMachine*)) rygel_item_updater_real_run;
	iface->run_finish = rygel_item_updater_real_run_finish;
	iface->get_cancellable = rygel_item_updater_real_get_cancellable;
	iface->set_cancellable = rygel_item_updater_real_set_cancellable;
}


static void rygel_item_updater_instance_init (RygelItemUpdater * self) {
	self->priv = RYGEL_ITEM_UPDATER_GET_PRIVATE (self);
}


static void rygel_item_updater_finalize (GObject* obj) {
	RygelItemUpdater * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater);
	_g_free0 (self->priv->object_id);
	_g_free0 (self->priv->current_tag_value);
	_g_free0 (self->priv->new_tag_value);
	_g_object_unref0 (self->priv->content_dir);
	__vala_GUPnPServiceAction_free0 (self->priv->action);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_item_updater_parent_class)->finalize (obj);
}


/**
 * UpdateObject action implementation.
 */
GType rygel_item_updater_get_type (void) {
	static volatile gsize rygel_item_updater_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_item_updater_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelItemUpdaterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_item_updater_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelItemUpdater), 0, (GInstanceInitFunc) rygel_item_updater_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_item_updater_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_item_updater_type_id;
		rygel_item_updater_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelItemUpdater", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_item_updater_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_item_updater_type_id__volatile, rygel_item_updater_type_id);
	}
	return rygel_item_updater_type_id__volatile;
}


static void _vala_rygel_item_updater_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelItemUpdater * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater);
	switch (property_id) {
		case RYGEL_ITEM_UPDATER_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_rygel_item_updater_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelItemUpdater * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_ITEM_UPDATER, RygelItemUpdater);
	switch (property_id) {
		case RYGEL_ITEM_UPDATER_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



