/* rygel-plugin-loader.c generated by valac 0.13.3, the Vala compiler
 * generated from rygel-plugin-loader.vala, do not modify */

/*
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp/gupnp.h>
#include <gmodule.h>
#include <config.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_PLUGIN_LOADER (rygel_plugin_loader_get_type ())
#define RYGEL_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoader))
#define RYGEL_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))
#define RYGEL_IS_PLUGIN_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_IS_PLUGIN_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN_LOADER))
#define RYGEL_PLUGIN_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderClass))

typedef struct _RygelPluginLoader RygelPluginLoader;
typedef struct _RygelPluginLoaderClass RygelPluginLoaderClass;
typedef struct _RygelPluginLoaderPrivate RygelPluginLoaderPrivate;

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;

#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelPluginPrivate RygelPluginPrivate;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelPluginLoaderLoadModulesFromDirData RygelPluginLoaderLoadModulesFromDirData;
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))

struct _RygelPluginLoader {
	GObject parent_instance;
	RygelPluginLoaderPrivate * priv;
};

struct _RygelPluginLoaderClass {
	GObjectClass parent_class;
};

struct _RygelPluginLoaderPrivate {
	GeeHashMap* plugin_hash;
};

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	gchar* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_upload) (RygelConfiguration* self, GError** error);
	gboolean (*get_allow_deletion) (RygelConfiguration* self, GError** error);
	gchar* (*get_log_levels) (RygelConfiguration* self, GError** error);
	gchar* (*get_plugin_path) (RygelConfiguration* self, GError** error);
	gchar* (*get_video_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_music_upload_folder) (RygelConfiguration* self, GError** error);
	gchar* (*get_picture_upload_folder) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_title) (RygelConfiguration* self, const gchar* section, GError** error);
	gchar* (*get_string) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const gchar* section, const gchar* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const gchar* section, const gchar* key, GError** error);
};

struct _RygelPlugin {
	GUPnPResourceFactory parent_instance;
	RygelPluginPrivate * priv;
	gchar* name;
	gchar* title;
	gchar* description;
	gchar* desc_path;
	GeeArrayList* resource_infos;
	GeeArrayList* icon_infos;
	GeeArrayList* default_icons;
};

struct _RygelPluginClass {
	GUPnPResourceFactoryClass parent_class;
};

struct _RygelPluginLoaderLoadModulesFromDirData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelPluginLoader* self;
	GFile* dir;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* attributes;
	GList* infos;
	GFileEnumerator* enumerator;
	GFile* _tmp4_;
	const gchar* _tmp5_;
	GFileEnumerator* _tmp6_;
	GFileEnumerator* _tmp7_;
	GFileEnumerator* _tmp8_;
	gint _tmp9_;
	GList* _tmp10_;
	GList* _tmp11_;
	GError* _error_;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GList* _tmp18_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp19_;
	GFileInfo* info;
	GFileInfo* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* file_name;
	GFile* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* file_path;
	const gchar* _tmp29_;
	GFile* _tmp30_;
	GFile* file;
	GFileInfo* _tmp31_;
	GFileType _tmp32_;
	GFileType file_type;
	GFileInfo* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* content_type;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* mime;
	GFileType _tmp38_;
	GFile* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	GFile* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	GError * _inner_error_;
};

typedef void (*RygelPluginLoaderModuleInitFunc) (RygelPluginLoader* loader, void* user_data);

static gpointer rygel_plugin_loader_parent_class = NULL;

GType rygel_plugin_loader_get_type (void) G_GNUC_CONST;
GType rygel_plugin_get_type (void) G_GNUC_CONST;
#define RYGEL_PLUGIN_LOADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_PLUGIN_LOADER, RygelPluginLoaderPrivate))
enum  {
	RYGEL_PLUGIN_LOADER_DUMMY_PROPERTY
};
RygelPluginLoader* rygel_plugin_loader_new (void);
RygelPluginLoader* rygel_plugin_loader_construct (GType object_type);
void rygel_plugin_loader_load_plugins (RygelPluginLoader* self);
GType rygel_meta_config_get_type (void) G_GNUC_CONST;
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_configuration_get_type (void) G_GNUC_CONST;
gchar* rygel_configuration_get_plugin_path (RygelConfiguration* self, GError** error);
static gboolean rygel_plugin_loader_is_dir (GFile* file);
static void rygel_plugin_loader_load_modules_from_dir (RygelPluginLoader* self, GFile* dir, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_plugin_loader_load_modules_from_dir_finish (RygelPluginLoader* self, GAsyncResult* _res_);
gboolean rygel_plugin_loader_plugin_disabled (RygelPluginLoader* self, const gchar* name);
gboolean rygel_configuration_get_enabled (RygelConfiguration* self, const gchar* section, GError** error);
void rygel_plugin_loader_add_plugin (RygelPluginLoader* self, RygelPlugin* plugin);
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
RygelPlugin* rygel_plugin_loader_get_plugin_by_name (RygelPluginLoader* self, const gchar* name);
GeeCollection* rygel_plugin_loader_list_plugins (RygelPluginLoader* self);
static void rygel_plugin_loader_load_modules_from_dir_data_free (gpointer _data);
static gboolean rygel_plugin_loader_load_modules_from_dir_co (RygelPluginLoaderLoadModulesFromDirData* _data_);
static void rygel_plugin_loader_load_modules_from_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_plugin_loader_load_module_from_file (RygelPluginLoader* self, const gchar* file_path);
static void rygel_plugin_loader_finalize (GObject* obj);


RygelPluginLoader* rygel_plugin_loader_construct (GType object_type) {
	RygelPluginLoader * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeHashMap* _tmp2_;
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	self = (RygelPluginLoader*) g_object_new (object_type, NULL);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp0_ = g_str_hash;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp1_ = g_str_equal;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_TYPE_PLUGIN, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp0_, _tmp1_, NULL);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_g_object_unref0 (self->priv->plugin_hash);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	self->priv->plugin_hash = _tmp2_;
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	return self;
#line 296 "rygel-plugin-loader.c"
}


RygelPluginLoader* rygel_plugin_loader_new (void) {
#line 43 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	return rygel_plugin_loader_construct (RYGEL_TYPE_PLUGIN_LOADER);
#line 303 "rygel-plugin-loader.c"
}


void rygel_plugin_loader_load_plugins (RygelPluginLoader* self) {
	gboolean _tmp0_ = FALSE;
	gchar* path = NULL;
	const gchar* _tmp5_;
	GFile* _tmp6_ = NULL;
	GFile* dir;
	gboolean _tmp7_ = FALSE;
	GFile* _tmp8_;
	gboolean _tmp11_;
	GFile* _tmp12_;
	GError * _inner_error_ = NULL;
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_return_if_fail (self != NULL);
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp0_ = g_module_supported ();
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_assert (_tmp0_);
#line 324 "rygel-plugin-loader.c"
	{
		RygelMetaConfig* _tmp1_ = NULL;
		RygelMetaConfig* config;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp1_ = rygel_meta_config_get_default ();
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		config = _tmp1_;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp2_ = rygel_configuration_get_plugin_path ((RygelConfiguration*) config, &_inner_error_);
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp3_ = _tmp2_;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		if (_inner_error_ != NULL) {
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
			_g_object_unref0 (config);
#line 342 "rygel-plugin-loader.c"
			goto __catch42_g_error;
		}
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_free0 (path);
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		path = _tmp3_;
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_object_unref0 (config);
#line 351 "rygel-plugin-loader.c"
	}
	goto __finally42;
	__catch42_g_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp4_;
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_error_ = _inner_error_;
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_inner_error_ = NULL;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp4_ = g_strdup (PLUGIN_DIR);
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_free0 (path);
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		path = _tmp4_;
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_error_free0 (_error_);
#line 370 "rygel-plugin-loader.c"
	}
	__finally42:
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	if (_inner_error_ != NULL) {
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_free0 (path);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_clear_error (&_inner_error_);
#line 52 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		return;
#line 383 "rygel-plugin-loader.c"
	}
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp5_ = path;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp6_ = g_file_new_for_path (_tmp5_);
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	dir = _tmp6_;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp8_ = dir;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	if (_tmp8_ != NULL) {
#line 395 "rygel-plugin-loader.c"
		GFile* _tmp9_;
		gboolean _tmp10_ = FALSE;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp9_ = dir;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp10_ = rygel_plugin_loader_is_dir (_tmp9_);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp7_ = _tmp10_;
#line 404 "rygel-plugin-loader.c"
	} else {
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp7_ = FALSE;
#line 408 "rygel-plugin-loader.c"
	}
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp11_ = _tmp7_;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_assert (_tmp11_);
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp12_ = dir;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	rygel_plugin_loader_load_modules_from_dir (self, _tmp12_, NULL, NULL);
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_g_object_unref0 (dir);
#line 48 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_g_free0 (path);
#line 422 "rygel-plugin-loader.c"
}


/**
     * Checks if a plugin is disabled by user
     *
     * @param name the name of plugin to check for.
     *
     * return true if plugin is disabled, false if not.
     */
gboolean rygel_plugin_loader_plugin_disabled (RygelPluginLoader* self, const gchar* name) {
	gboolean result = FALSE;
	gboolean enabled;
	gboolean _tmp4_;
	GError * _inner_error_ = NULL;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	enabled = TRUE;
#line 444 "rygel-plugin-loader.c"
	{
		RygelMetaConfig* _tmp0_ = NULL;
		RygelMetaConfig* config;
		const gchar* _tmp1_;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp0_ = rygel_meta_config_get_default ();
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		config = _tmp0_;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp1_ = name;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp2_ = rygel_configuration_get_enabled ((RygelConfiguration*) config, _tmp1_, &_inner_error_);
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp3_ = _tmp2_;
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		if (_inner_error_ != NULL) {
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
			_g_object_unref0 (config);
#line 465 "rygel-plugin-loader.c"
			goto __catch43_g_error;
		}
#line 76 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		enabled = _tmp3_;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_object_unref0 (config);
#line 472 "rygel-plugin-loader.c"
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError* err = NULL;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		err = _inner_error_;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_inner_error_ = NULL;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_error_free0 (err);
#line 484 "rygel-plugin-loader.c"
	}
	__finally43:
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	if (_inner_error_ != NULL) {
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_clear_error (&_inner_error_);
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		return FALSE;
#line 495 "rygel-plugin-loader.c"
	}
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp4_ = enabled;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	result = !_tmp4_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	return result;
#line 503 "rygel-plugin-loader.c"
}


void rygel_plugin_loader_add_plugin (RygelPluginLoader* self, RygelPlugin* plugin) {
	const gchar* _tmp0_ = NULL;
	RygelPlugin* _tmp1_;
	const gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	RygelPlugin* _tmp4_;
	const gchar* _tmp5_;
	RygelPlugin* _tmp6_;
	RygelPlugin* _tmp7_;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_return_if_fail (self != NULL);
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_return_if_fail (plugin != NULL);
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp0_ = _ ("New plugin '%s' available");
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp1_ = plugin;
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp2_ = _tmp1_->name;
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_message (_tmp0_, _tmp2_);
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp3_ = self->priv->plugin_hash;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp4_ = plugin;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp5_ = _tmp4_->name;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp6_ = plugin;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, _tmp5_, _tmp6_);
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp7_ = plugin;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_signal_emit_by_name (self, "plugin-available", _tmp7_);
#line 542 "rygel-plugin-loader.c"
}


RygelPlugin* rygel_plugin_loader_get_plugin_by_name (RygelPluginLoader* self, const gchar* name) {
	RygelPlugin* result = NULL;
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp0_ = self->priv->plugin_hash;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp1_ = name;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	result = (RygelPlugin*) _tmp2_;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	return result;
#line 565 "rygel-plugin-loader.c"
}


GeeCollection* rygel_plugin_loader_list_plugins (RygelPluginLoader* self) {
	GeeCollection* result = NULL;
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp0_ = self->priv->plugin_hash;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp1_ = gee_map_get_values ((GeeMap*) _tmp0_);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp2_ = _tmp1_;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	result = _tmp2_;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	return result;
#line 586 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_load_modules_from_dir_data_free (gpointer _data) {
	RygelPluginLoaderLoadModulesFromDirData* _data_;
	_data_ = _data;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_g_object_unref0 (_data_->dir);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_g_object_unref0 (_data_->self);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_slice_free (RygelPluginLoaderLoadModulesFromDirData, _data_);
#line 599 "rygel-plugin-loader.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	return self ? g_object_ref (self) : NULL;
#line 606 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_load_modules_from_dir (RygelPluginLoader* self, GFile* dir, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelPluginLoaderLoadModulesFromDirData* _data_;
	RygelPluginLoader* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_ = g_slice_new0 (RygelPluginLoaderLoadModulesFromDirData);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_plugin_loader_load_modules_from_dir);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_plugin_loader_load_modules_from_dir_data_free);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_->self = _tmp0_;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp1_ = dir;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_->dir = _tmp2_;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	rygel_plugin_loader_load_modules_from_dir_co (_data_);
#line 633 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_load_modules_from_dir_finish (RygelPluginLoader* self, GAsyncResult* _res_) {
	RygelPluginLoaderLoadModulesFromDirData* _data_;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 641 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_load_modules_from_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelPluginLoaderLoadModulesFromDirData* _data_;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_ = _user_data_;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_->_source_object_ = source_object;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_->_res_ = _res_;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	rygel_plugin_loader_load_modules_from_dir_co (_data_);
#line 655 "rygel-plugin-loader.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 662 "rygel-plugin-loader.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_list_free (self);
#line 671 "rygel-plugin-loader.c"
}


static gboolean rygel_plugin_loader_load_modules_from_dir_co (RygelPluginLoaderLoadModulesFromDirData* _data_) {
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	switch (_data_->_state_) {
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		case 0:
#line 680 "rygel-plugin-loader.c"
		goto _state_0;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		case 1:
#line 684 "rygel-plugin-loader.c"
		goto _state_1;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		case 2:
#line 688 "rygel-plugin-loader.c"
		goto _state_2;
		default:
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_assert_not_reached ();
#line 693 "rygel-plugin-loader.c"
	}
	_state_0:
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_->_tmp0_ = _data_->dir;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_->_tmp1_ = NULL;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_->_tmp1_ = g_file_get_path (_data_->_tmp0_);
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_->_tmp2_ = _data_->_tmp1_;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_debug ("rygel-plugin-loader.vala:97: Searching for modules in folder '%s'.", _data_->_tmp2_);
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_g_free0 (_data_->_tmp2_);
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_->_tmp3_ = g_strdup (G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE);
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_->attributes = _data_->_tmp3_;
#line 712 "rygel-plugin-loader.c"
	{
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp4_ = _data_->dir;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp5_ = _data_->attributes;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_state_ = 1;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_file_enumerate_children_async (_data_->_tmp4_, _data_->_tmp5_, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, rygel_plugin_loader_load_modules_from_dir_ready, _data_);
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		return FALSE;
#line 724 "rygel-plugin-loader.c"
		_state_1:
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp6_ = NULL;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp6_ = g_file_enumerate_children_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp7_ = _data_->_tmp6_;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		if (_data_->_inner_error_ != NULL) {
#line 734 "rygel-plugin-loader.c"
			goto __catch44_g_error;
		}
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_object_unref0 (_data_->enumerator);
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->enumerator = _data_->_tmp7_;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp8_ = _data_->enumerator;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp9_ = G_MAXINT;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_state_ = 2;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_file_enumerator_next_files_async (_data_->_tmp8_, _data_->_tmp9_, G_PRIORITY_DEFAULT, NULL, rygel_plugin_loader_load_modules_from_dir_ready, _data_);
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		return FALSE;
#line 751 "rygel-plugin-loader.c"
		_state_2:
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp10_ = NULL;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp10_ = g_file_enumerator_next_files_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error_);
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp11_ = _data_->_tmp10_;
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		if (_data_->_inner_error_ != NULL) {
#line 761 "rygel-plugin-loader.c"
			goto __catch44_g_error;
		}
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		__g_list_free__g_object_unref0_0 (_data_->infos);
#line 113 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->infos = _data_->_tmp11_;
#line 768 "rygel-plugin-loader.c"
	}
	goto __finally44;
	__catch44_g_error:
	{
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_inner_error_ = NULL;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp12_ = NULL;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp12_ = _ ("Error listing contents of folder '%s': %s");
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp13_ = _data_->dir;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp14_ = NULL;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp14_ = g_file_get_path (_data_->_tmp13_);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp15_ = _data_->_tmp14_;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp16_ = _data_->_error_;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->_tmp17_ = _data_->_tmp16_->message;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_critical (_data_->_tmp12_, _data_->_tmp15_, _data_->_tmp17_);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_free0 (_data_->_tmp15_);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_error_free0 (_data_->_error_);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_object_unref0 (_data_->enumerator);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		__g_list_free__g_object_unref0_0 (_data_->infos);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_free0 (_data_->attributes);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		if (_data_->_state_ == 0) {
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 809 "rygel-plugin-loader.c"
		} else {
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 813 "rygel-plugin-loader.c"
		}
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_object_unref (_data_->_async_result);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		return FALSE;
#line 819 "rygel-plugin-loader.c"
	}
	__finally44:
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	if (_data_->_inner_error_ != NULL) {
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_object_unref0 (_data_->enumerator);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		__g_list_free__g_object_unref0_0 (_data_->infos);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_free0 (_data_->attributes);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_clear_error (&_data_->_inner_error_);
#line 106 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		return FALSE;
#line 836 "rygel-plugin-loader.c"
	}
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_->_tmp18_ = _data_->infos;
#line 840 "rygel-plugin-loader.c"
	{
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->info_collection = _data_->_tmp18_;
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_data_->info_it = NULL;
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
			_data_->_tmp19_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
			_data_->info = _data_->_tmp19_;
#line 852 "rygel-plugin-loader.c"
			{
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp20_ = _data_->info;
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp21_ = NULL;
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp21_ = g_file_info_get_name (_data_->_tmp20_);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp22_ = g_strdup (_data_->_tmp21_);
#line 125 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->file_name = _data_->_tmp22_;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp23_ = _data_->dir;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp24_ = NULL;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp24_ = g_file_get_path (_data_->_tmp23_);
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp25_ = _data_->_tmp24_;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp26_ = _data_->file_name;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp27_ = NULL;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp27_ = g_build_filename (_data_->_tmp25_, _data_->_tmp26_, NULL);
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp28_ = _data_->_tmp27_;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_g_free0 (_data_->_tmp25_);
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->file_path = _data_->_tmp28_;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp29_ = _data_->file_path;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp30_ = NULL;
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp30_ = g_file_new_for_path (_data_->_tmp29_);
#line 128 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->file = _data_->_tmp30_;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp31_ = _data_->info;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp32_ = 0;
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp32_ = g_file_info_get_file_type (_data_->_tmp31_);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->file_type = _data_->_tmp32_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp33_ = _data_->info;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp34_ = NULL;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp34_ = g_file_info_get_content_type (_data_->_tmp33_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp35_ = g_strdup (_data_->_tmp34_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->content_type = _data_->_tmp35_;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp36_ = _data_->content_type;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp37_ = NULL;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp37_ = g_content_type_get_mime_type (_data_->_tmp36_);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->mime = _data_->_tmp37_;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_data_->_tmp38_ = _data_->file_type;
#line 133 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				if (_data_->_tmp38_ == G_FILE_TYPE_DIRECTORY) {
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
					_data_->_tmp39_ = _data_->file;
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
					rygel_plugin_loader_load_modules_from_dir (_data_->self, _data_->_tmp39_, NULL, NULL);
#line 926 "rygel-plugin-loader.c"
				} else {
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
					_data_->_tmp40_ = _data_->mime;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
					if (g_strcmp0 (_data_->_tmp40_, "application/x-sharedlib") == 0) {
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
						_data_->_tmp41_ = _data_->file_path;
#line 138 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
						rygel_plugin_loader_load_module_from_file (_data_->self, _data_->_tmp41_);
#line 936 "rygel-plugin-loader.c"
					}
				}
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_g_free0 (_data_->mime);
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_g_free0 (_data_->content_type);
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_g_object_unref0 (_data_->file);
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_g_free0 (_data_->file_path);
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_g_free0 (_data_->file_name);
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
				_g_object_unref0 (_data_->info);
#line 951 "rygel-plugin-loader.c"
			}
		}
	}
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_->_tmp42_ = _data_->dir;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_->_tmp43_ = NULL;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_->_tmp43_ = g_file_get_path (_data_->_tmp42_);
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_data_->_tmp44_ = _data_->_tmp43_;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_debug ("rygel-plugin-loader.vala:142: Finished searching for modules in folder" \
" '%s'", _data_->_tmp44_);
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_g_free0 (_data_->_tmp44_);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_g_object_unref0 (_data_->enumerator);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	__g_list_free__g_object_unref0_0 (_data_->infos);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_g_free0 (_data_->attributes);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	if (_data_->_state_ == 0) {
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 977 "rygel-plugin-loader.c"
	} else {
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 981 "rygel-plugin-loader.c"
	}
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_object_unref (_data_->_async_result);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	return FALSE;
#line 987 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_load_module_from_file (RygelPluginLoader* self, const gchar* file_path) {
	const gchar* _tmp0_;
	GModule* _tmp1_ = NULL;
	GModule* module;
	GModule* _tmp2_;
	void* function = NULL;
	GModule* _tmp6_;
	void* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	void* _tmp12_;
	RygelPluginLoaderModuleInitFunc module_init;
	void* module_init_target;
	RygelPluginLoaderModuleInitFunc _tmp13_;
	void* _tmp13__target;
	GModule* _tmp14_;
	RygelPluginLoaderModuleInitFunc _tmp15_;
	void* _tmp15__target;
	GModule* _tmp16_;
	const gchar* _tmp17_ = NULL;
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_return_if_fail (self != NULL);
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_return_if_fail (file_path != NULL);
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp0_ = file_path;
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp1_ = g_module_open (_tmp0_, G_MODULE_BIND_LOCAL);
#line 147 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	module = _tmp1_;
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp2_ = module;
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	if (_tmp2_ == NULL) {
#line 1024 "rygel-plugin-loader.c"
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp3_ = _ ("Failed to load module from path '%s': %s");
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp4_ = file_path;
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp5_ = g_module_error ();
#line 149 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_warning (_tmp3_, _tmp4_, _tmp5_);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_module_close0 (module);
#line 153 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		return;
#line 1040 "rygel-plugin-loader.c"
	}
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp6_ = module;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp8_ = g_module_symbol (_tmp6_, "module_init", &_tmp7_);
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	function = _tmp7_;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	if (!_tmp8_) {
#line 1050 "rygel-plugin-loader.c"
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp9_ = _ ("Failed to find entry point function '%s' in '%s': %s");
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp10_ = file_path;
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp11_ = g_module_error ();
#line 159 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_warning (_tmp9_, "module_init", _tmp10_, _tmp11_);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_module_close0 (module);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		return;
#line 1066 "rygel-plugin-loader.c"
	}
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp12_ = function;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	module_init = (RygelPluginLoaderModuleInitFunc) _tmp12_;
#line 167 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	module_init_target = NULL;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp13_ = module_init;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp13__target = module_init_target;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_assert (_tmp13_ != NULL);
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp14_ = module;
#line 171 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_module_make_resident (_tmp14_);
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp15_ = module_init;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp15__target = module_init_target;
#line 173 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp15_ (self, _tmp15__target);
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp16_ = module;
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp17_ = g_module_name (_tmp16_);
#line 175 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_debug ("rygel-plugin-loader.vala:175: Loaded module source: '%s'", _tmp17_);
#line 146 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_g_module_close0 (module);
#line 1098 "rygel-plugin-loader.c"
}


static gboolean rygel_plugin_loader_is_dir (GFile* file) {
	gboolean result = FALSE;
	GFileInfo* file_info = NULL;
	GFileInfo* _tmp7_;
	GFileType _tmp8_ = 0;
	GError * _inner_error_ = NULL;
#line 178 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 1110 "rygel-plugin-loader.c"
	{
		GFile* _tmp0_;
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* _tmp2_;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp0_ = file;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp1_ = g_file_query_info (_tmp0_, G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp2_ = _tmp1_;
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		if (_inner_error_ != NULL) {
#line 1123 "rygel-plugin-loader.c"
			goto __catch45_g_error;
		}
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_object_unref0 (file_info);
#line 182 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		file_info = _tmp2_;
#line 1130 "rygel-plugin-loader.c"
	}
	goto __finally45;
	__catch45_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp3_ = NULL;
		GFile* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_error_ = _inner_error_;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_inner_error_ = NULL;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp3_ = _ ("Failed to query content type for '%s'");
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp4_ = file;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp5_ = g_file_get_path (_tmp4_);
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_tmp6_ = _tmp5_;
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_critical (_tmp3_, _tmp6_);
#line 186 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_free0 (_tmp6_);
#line 189 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		result = FALSE;
#line 189 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_error_free0 (_error_);
#line 189 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_object_unref0 (file_info);
#line 189 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		return result;
#line 1164 "rygel-plugin-loader.c"
	}
	__finally45:
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	if (_inner_error_ != NULL) {
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		_g_object_unref0 (file_info);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		g_clear_error (&_inner_error_);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
		return FALSE;
#line 1177 "rygel-plugin-loader.c"
	}
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp7_ = file_info;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_tmp8_ = g_file_info_get_file_type (_tmp7_);
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	result = _tmp8_ == G_FILE_TYPE_DIRECTORY;
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_g_object_unref0 (file_info);
#line 192 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	return result;
#line 1189 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_class_init (RygelPluginLoaderClass * klass) {
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	rygel_plugin_loader_parent_class = g_type_class_peek_parent (klass);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_type_class_add_private (klass, sizeof (RygelPluginLoaderPrivate));
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_plugin_loader_finalize;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	g_signal_new ("plugin_available", RYGEL_TYPE_PLUGIN_LOADER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, RYGEL_TYPE_PLUGIN);
#line 1202 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_instance_init (RygelPluginLoader * self) {
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	self->priv = RYGEL_PLUGIN_LOADER_GET_PRIVATE (self);
#line 1209 "rygel-plugin-loader.c"
}


static void rygel_plugin_loader_finalize (GObject* obj) {
	RygelPluginLoader * self;
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	self = RYGEL_PLUGIN_LOADER (obj);
#line 38 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	_g_object_unref0 (self->priv->plugin_hash);
#line 35 "/home/jens/Source/rygel/src/rygel/rygel-plugin-loader.vala"
	G_OBJECT_CLASS (rygel_plugin_loader_parent_class)->finalize (obj);
#line 1221 "rygel-plugin-loader.c"
}


/**
 * Responsible for plugin loading. Probes for shared library files in a specific
 * directry and tries to grab a function with a specific name and signature,
 * calls it. The loaded module can then add plugins to Rygel by calling the
 * add_plugin method. NOTE: The module SHOULD make sure that plugin is not
 * disabled by user using plugin_disabled method before creating the plugin
 * instance and resources related to that instance.
 */
GType rygel_plugin_loader_get_type (void) {
	static volatile gsize rygel_plugin_loader_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_plugin_loader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPluginLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_plugin_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPluginLoader), 0, (GInstanceInitFunc) rygel_plugin_loader_instance_init, NULL };
		GType rygel_plugin_loader_type_id;
		rygel_plugin_loader_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPluginLoader", &g_define_type_info, 0);
		g_once_init_leave (&rygel_plugin_loader_type_id__volatile, rygel_plugin_loader_type_id);
	}
	return rygel_plugin_loader_type_id__volatile;
}



