/* rygel-mp2ts-transcoder.c generated by valac 0.13.3, the Vala compiler
 * generated from rygel-mp2ts-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_TYPE_MP2_TS_PROFILE (rygel_mp2_ts_profile_get_type ())

#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_MP2_TS_TRANSCODER (rygel_mp2_ts_transcoder_get_type ())
#define RYGEL_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoder))
#define RYGEL_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))
#define RYGEL_IS_MP2_TS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_IS_MP2_TS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER))
#define RYGEL_MP2_TS_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderClass))

typedef struct _RygelMP2TSTranscoder RygelMP2TSTranscoder;
typedef struct _RygelMP2TSTranscoderClass RygelMP2TSTranscoderClass;
typedef struct _RygelMP2TSTranscoderPrivate RygelMP2TSTranscoderPrivate;

#define RYGEL_TYPE_MP2_TS_TRANSCODER_BIN (rygel_mp2_ts_transcoder_bin_get_type ())
#define RYGEL_MP2_TS_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER_BIN, RygelMP2TSTranscoderBin))
#define RYGEL_MP2_TS_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER_BIN, RygelMP2TSTranscoderBinClass))
#define RYGEL_IS_MP2_TS_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER_BIN))
#define RYGEL_IS_MP2_TS_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MP2_TS_TRANSCODER_BIN))
#define RYGEL_MP2_TS_TRANSCODER_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MP2_TS_TRANSCODER_BIN, RygelMP2TSTranscoderBinClass))

typedef struct _RygelMP2TSTranscoderBin RygelMP2TSTranscoderBin;
typedef struct _RygelMP2TSTranscoderBinClass RygelMP2TSTranscoderBinClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_VIDEO_ITEM (rygel_video_item_get_type ())
#define RYGEL_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem))
#define RYGEL_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))
#define RYGEL_IS_VIDEO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_IS_VIDEO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_VIDEO_ITEM))
#define RYGEL_VIDEO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_VIDEO_ITEM, RygelVideoItemClass))

typedef struct _RygelVideoItem RygelVideoItem;
typedef struct _RygelVideoItemClass RygelVideoItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define RYGEL_TYPE_VISUAL_ITEM (rygel_visual_item_get_type ())
#define RYGEL_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem))
#define RYGEL_IS_VISUAL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_VISUAL_ITEM))
#define RYGEL_VISUAL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_VISUAL_ITEM, RygelVisualItemIface))

typedef struct _RygelVisualItem RygelVisualItem;
typedef struct _RygelVisualItemIface RygelVisualItemIface;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))

typedef enum  {
	RYGEL_MP2_TS_PROFILE_SD = 0,
	RYGEL_MP2_TS_PROFILE_HD
} RygelMP2TSProfile;

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
	GstElement* (*create_source) (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error);
	GUPnPDIDLLiteResource* (*add_resource) (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
	guint (*get_distance) (RygelTranscoder* self, RygelMediaItem* item);
};

struct _RygelMP2TSTranscoder {
	RygelTranscoder parent_instance;
	RygelMP2TSTranscoderPrivate * priv;
};

struct _RygelMP2TSTranscoderClass {
	RygelTranscoderClass parent_class;
};

struct _RygelMP2TSTranscoderPrivate {
	RygelMP2TSProfile profile;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

struct _RygelVisualItemIface {
	GTypeInterface parent_iface;
	gint (*get_width) (RygelVisualItem* self);
	void (*set_width) (RygelVisualItem* self, gint value);
	gint (*get_height) (RygelVisualItem* self);
	void (*set_height) (RygelVisualItem* self, gint value);
	gint (*get_pixel_width) (RygelVisualItem* self);
	void (*set_pixel_width) (RygelVisualItem* self, gint value);
	gint (*get_pixel_height) (RygelVisualItem* self);
	void (*set_pixel_height) (RygelVisualItem* self, gint value);
	gint (*get_color_depth) (RygelVisualItem* self);
	void (*set_color_depth) (RygelVisualItem* self, gint value);
	GeeArrayList* (*get_thumbnails) (RygelVisualItem* self);
	void (*set_thumbnails) (RygelVisualItem* self, GeeArrayList* value);
};


static gpointer rygel_mp2_ts_transcoder_parent_class = NULL;

GType rygel_mp2_ts_profile_get_type (void) G_GNUC_CONST;
GType rygel_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_mp2_ts_transcoder_get_type (void) G_GNUC_CONST;
#define RYGEL_MP2_TS_TRANSCODER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MP2_TS_TRANSCODER, RygelMP2TSTranscoderPrivate))
enum  {
	RYGEL_MP2_TS_TRANSCODER_DUMMY_PROPERTY
};
#define RYGEL_MP2_TS_TRANSCODER_VIDEO_BITRATE 3000
#define RYGEL_MP2_TS_TRANSCODER_BITRATE 3000000
#define RYGEL_MP2_TS_TRANSCODER_VIDEO_ENCODER "ffenc_mpeg2video"
#define RYGEL_MP2_TS_TRANSCODER_COLORSPACE_CONVERT "ffmpegcolorspace"
#define RYGEL_MP2_TS_TRANSCODER_VIDEO_RATE "videorate"
#define RYGEL_MP2_TS_TRANSCODER_VIDEO_SCALE "videoscale"
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_new (RygelMP2TSProfile profile);
RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_construct (GType object_type, RygelMP2TSProfile profile);
#define RYGEL_VIDEO_ITEM_UPNP_CLASS "object.item.videoItem"
RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* upnp_class);
static GstElement* rygel_mp2_ts_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error);
RygelMP2TSTranscoderBin* rygel_mp2_ts_transcoder_bin_new (RygelMediaItem* item, GstElement* src, RygelMP2TSTranscoder* transcoder, GError** error);
RygelMP2TSTranscoderBin* rygel_mp2_ts_transcoder_bin_construct (GType object_type, RygelMediaItem* item, GstElement* src, RygelMP2TSTranscoder* transcoder, GError** error);
GType rygel_mp2_ts_transcoder_bin_get_type (void) G_GNUC_CONST;
static GUPnPDIDLLiteResource* rygel_mp2_ts_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
#define RYGEL_MP3_TRANSCODER_BITRATE 256
static guint rygel_mp2_ts_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_video_item_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
GType rygel_visual_item_get_type (void) G_GNUC_CONST;
gint rygel_visual_item_get_width (RygelVisualItem* self);
gint rygel_visual_item_get_height (RygelVisualItem* self);
GstElement* rygel_mp2_ts_transcoder_create_encoder (RygelMP2TSTranscoder* self, RygelMediaItem* item, const gchar* src_pad_name, const gchar* sink_pad_name, GError** error);
GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error);
static inline void _dynamic_set_bitrate0 (GstElement* obj, gint value);
gint rygel_visual_item_get_pixel_width (RygelVisualItem* self);
gint rygel_visual_item_get_pixel_height (RygelVisualItem* self);
static void rygel_mp2_ts_transcoder_finalize (GObject* obj);

static const gint RYGEL_MP2_TS_TRANSCODER_WIDTH[2] = {720, 1280};
static const gint RYGEL_MP2_TS_TRANSCODER_HEIGHT[2] = {576, 720};
static const gint RYGEL_MP2_TS_TRANSCODER_FRAME_RATE[2] = {25, 30};
static const gchar* RYGEL_MP2_TS_TRANSCODER_PROFILES[2] = {"MPEG_TS_SD_EU_ISO", "MPEG_TS_HD_NA_ISO"};

GType rygel_mp2_ts_profile_get_type (void) {
	static volatile gsize rygel_mp2_ts_profile_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mp2_ts_profile_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_MP2_TS_PROFILE_SD, "RYGEL_MP2_TS_PROFILE_SD", "sd"}, {RYGEL_MP2_TS_PROFILE_HD, "RYGEL_MP2_TS_PROFILE_HD", "hd"}, {0, NULL, NULL}};
		GType rygel_mp2_ts_profile_type_id;
		rygel_mp2_ts_profile_type_id = g_enum_register_static ("RygelMP2TSProfile", values);
		g_once_init_leave (&rygel_mp2_ts_profile_type_id__volatile, rygel_mp2_ts_profile_type_id);
	}
	return rygel_mp2_ts_profile_type_id__volatile;
}


RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_construct (GType object_type, RygelMP2TSProfile profile) {
	RygelMP2TSTranscoder * self = NULL;
	RygelMP2TSProfile _tmp0_;
	const gchar* _tmp1_;
	RygelMP2TSProfile _tmp2_;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp0_ = profile;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp1_ = RYGEL_MP2_TS_TRANSCODER_PROFILES[_tmp0_];
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	self = (RygelMP2TSTranscoder*) rygel_transcoder_construct (object_type, "video/mpeg", _tmp1_, RYGEL_VIDEO_ITEM_UPNP_CLASS);
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp2_ = profile;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	self->priv->profile = _tmp2_;
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	return self;
#line 360 "rygel-mp2ts-transcoder.c"
}


RygelMP2TSTranscoder* rygel_mp2_ts_transcoder_new (RygelMP2TSProfile profile) {
#line 53 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	return rygel_mp2_ts_transcoder_construct (RYGEL_TYPE_MP2_TS_TRANSCODER, profile);
#line 367 "rygel-mp2ts-transcoder.c"
}


static GstElement* rygel_mp2_ts_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error) {
	RygelMP2TSTranscoder * self;
	GstElement* result = NULL;
	RygelMediaItem* _tmp0_;
	GstElement* _tmp1_;
	RygelMP2TSTranscoderBin* _tmp2_;
	RygelMP2TSTranscoderBin* _tmp3_;
	GError * _inner_error_ = NULL;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	self = (RygelMP2TSTranscoder*) base;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp0_ = item;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp1_ = src;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp2_ = rygel_mp2_ts_transcoder_bin_new (_tmp0_, _tmp1_, self, &_inner_error_);
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	gst_object_ref_sink (_tmp2_);
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp3_ = _tmp2_;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		return NULL;
#line 401 "rygel-mp2ts-transcoder.c"
	}
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	gst_object_ref_sink (_tmp3_);
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	result = (GstElement*) _tmp3_;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	return result;
#line 409 "rygel-mp2ts-transcoder.c"
}


static GUPnPDIDLLiteResource* rygel_mp2_ts_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
	RygelMP2TSTranscoder * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteItem* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelTranscodeManager* _tmp2_;
	GUPnPDIDLLiteResource* _tmp3_ = NULL;
	GUPnPDIDLLiteResource* resource;
	RygelMP2TSProfile _tmp4_;
	gint _tmp5_;
	RygelMP2TSProfile _tmp6_;
	gint _tmp7_;
	GError * _inner_error_ = NULL;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	self = (RygelMP2TSTranscoder*) base;
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	g_return_val_if_fail (didl_item != NULL, NULL);
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 65 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	g_return_val_if_fail (manager != NULL, NULL);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp0_ = didl_item;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp1_ = item;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp2_ = manager;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp3_ = RYGEL_TRANSCODER_CLASS (rygel_mp2_ts_transcoder_parent_class)->add_resource (RYGEL_TRANSCODER (self), _tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	resource = _tmp3_;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		return NULL;
#line 450 "rygel-mp2ts-transcoder.c"
	}
#line 70 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	if (resource == NULL) {
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		result = NULL;
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_g_object_unref0 (resource);
#line 71 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		return result;
#line 460 "rygel-mp2ts-transcoder.c"
	}
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp4_ = self->priv->profile;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp5_ = RYGEL_MP2_TS_TRANSCODER_WIDTH[_tmp4_];
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	gupnp_didl_lite_resource_set_width (resource, _tmp5_);
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp6_ = self->priv->profile;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp7_ = RYGEL_MP2_TS_TRANSCODER_HEIGHT[_tmp6_];
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	gupnp_didl_lite_resource_set_height (resource, _tmp7_);
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	gupnp_didl_lite_resource_set_bitrate (resource, ((RYGEL_MP2_TS_TRANSCODER_VIDEO_BITRATE + RYGEL_MP3_TRANSCODER_BITRATE) * 1000) / 8);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	result = resource;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	return result;
#line 480 "rygel-mp2ts-transcoder.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	return self ? g_object_ref (self) : NULL;
#line 487 "rygel-mp2ts-transcoder.c"
}


static guint rygel_mp2_ts_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item) {
	RygelMP2TSTranscoder * self;
	guint result = 0U;
	RygelMediaItem* _tmp0_;
	RygelMediaItem* _tmp2_;
	RygelVideoItem* _tmp3_;
	RygelVideoItem* video_item;
	guint _tmp4_;
	guint distance;
	RygelVideoItem* _tmp5_;
	gint _tmp6_;
	RygelVideoItem* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	RygelVideoItem* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	self = (RygelMP2TSTranscoder*) base;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	g_return_val_if_fail (item != NULL, 0U);
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp0_ = item;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	if (!RYGEL_IS_VIDEO_ITEM (_tmp0_)) {
#line 516 "rygel-mp2ts-transcoder.c"
		guint _tmp1_;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp1_ = G_MAXUINT;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		result = _tmp1_;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		return result;
#line 524 "rygel-mp2ts-transcoder.c"
	}
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp2_ = item;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp3_ = _g_object_ref0 (RYGEL_IS_VIDEO_ITEM (_tmp2_) ? ((RygelVideoItem*) _tmp2_) : NULL);
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	video_item = _tmp3_;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp4_ = 0;
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	distance = _tmp4_;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp5_ = video_item;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp6_ = ((RygelAudioItem*) _tmp5_)->bitrate;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	if (_tmp6_ > 0) {
#line 542 "rygel-mp2ts-transcoder.c"
		guint _tmp7_;
		RygelVideoItem* _tmp8_;
		gint _tmp9_;
		gint _tmp10_ = 0;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp7_ = distance;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp8_ = video_item;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp9_ = ((RygelAudioItem*) _tmp8_)->bitrate;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp10_ = abs (_tmp9_ - RYGEL_MP2_TS_TRANSCODER_BITRATE);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		distance = _tmp7_ + _tmp10_;
#line 557 "rygel-mp2ts-transcoder.c"
	}
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp11_ = video_item;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp12_ = rygel_visual_item_get_width ((RygelVisualItem*) _tmp11_);
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp13_ = _tmp12_;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	if (_tmp13_ > 0) {
#line 567 "rygel-mp2ts-transcoder.c"
		guint _tmp14_;
		RygelVideoItem* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		RygelMP2TSProfile _tmp18_;
		gint _tmp19_;
		gint _tmp20_ = 0;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp14_ = distance;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp15_ = video_item;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp16_ = rygel_visual_item_get_width ((RygelVisualItem*) _tmp15_);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp17_ = _tmp16_;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp18_ = self->priv->profile;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp19_ = RYGEL_MP2_TS_TRANSCODER_WIDTH[_tmp18_];
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp20_ = abs (_tmp17_ - _tmp19_);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		distance = _tmp14_ + _tmp20_;
#line 591 "rygel-mp2ts-transcoder.c"
	}
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp21_ = video_item;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp22_ = rygel_visual_item_get_height ((RygelVisualItem*) _tmp21_);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp23_ = _tmp22_;
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	if (_tmp23_ > 0) {
#line 601 "rygel-mp2ts-transcoder.c"
		guint _tmp24_;
		RygelVideoItem* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		RygelMP2TSProfile _tmp28_;
		gint _tmp29_;
		gint _tmp30_ = 0;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp24_ = distance;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp25_ = video_item;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp26_ = rygel_visual_item_get_height ((RygelVisualItem*) _tmp25_);
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp27_ = _tmp26_;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp28_ = self->priv->profile;
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp29_ = RYGEL_MP2_TS_TRANSCODER_HEIGHT[_tmp28_];
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp30_ = abs (_tmp27_ - _tmp29_);
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		distance = _tmp24_ + _tmp30_;
#line 625 "rygel-mp2ts-transcoder.c"
	}
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	result = distance;
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_g_object_unref0 (video_item);
#line 100 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	return result;
#line 633 "rygel-mp2ts-transcoder.c"
}


static inline void _dynamic_set_bitrate0 (GstElement* obj, gint value) {
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	g_object_set (obj, "bitrate", value, NULL);
#line 640 "rygel-mp2ts-transcoder.c"
}


static gpointer _gst_object_ref0 (gpointer self) {
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	return self ? gst_object_ref (self) : NULL;
#line 647 "rygel-mp2ts-transcoder.c"
}


GstElement* rygel_mp2_ts_transcoder_create_encoder (RygelMP2TSTranscoder* self, RygelMediaItem* item, const gchar* src_pad_name, const gchar* sink_pad_name, GError** error) {
	GstElement* result = NULL;
	GstElement* _tmp0_ = NULL;
	GstElement* videorate;
	GstElement* _tmp1_ = NULL;
	GstElement* videoscale;
	GstElement* _tmp2_ = NULL;
	GstElement* convert;
	GstElement* _tmp3_ = NULL;
	GstElement* encoder;
	GstElement* _tmp4_;
	GstBin* _tmp5_;
	GstBin* bin;
	GstBin* _tmp6_;
	GstElement* _tmp7_;
	GstElement* _tmp8_;
	GstElement* _tmp9_;
	GstElement* _tmp10_;
	GstElement* _tmp11_;
	GstElement* _tmp12_;
	GstElement* _tmp13_;
	GstElement* _tmp14_;
	GstElement* _tmp15_;
	GstElement* _tmp16_;
	GstElement* _tmp17_;
	gint pixel_w = 0;
	gint pixel_h = 0;
	RygelMediaItem* _tmp18_;
	RygelVideoItem* _tmp19_;
	RygelVideoItem* video_item;
	gboolean _tmp20_ = FALSE;
	RygelVideoItem* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gboolean _tmp27_;
	RygelMP2TSProfile _tmp44_;
	gint _tmp45_;
	RygelMP2TSProfile _tmp46_;
	gint _tmp47_;
	RygelMP2TSProfile _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	GstCaps* _tmp52_;
	GstCaps* caps;
	GstElement* _tmp53_;
	GstElement* _tmp54_;
	GstCaps* _tmp55_;
	GstElement* _tmp56_;
	GstPad* _tmp57_ = NULL;
	GstPad* pad;
	const gchar* _tmp58_;
	GstPad* _tmp59_;
	GstGhostPad* _tmp60_;
	GstGhostPad* ghost;
	GstBin* _tmp61_;
	GstGhostPad* _tmp62_;
	GstPad* _tmp63_;
	GstElement* _tmp64_;
	GstPad* _tmp65_ = NULL;
	const gchar* _tmp66_;
	GstPad* _tmp67_;
	GstGhostPad* _tmp68_;
	GstBin* _tmp69_;
	GstGhostPad* _tmp70_;
	GstPad* _tmp71_;
	GError * _inner_error_ = NULL;
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 103 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp0_ = rygel_gst_utils_create_element (RYGEL_MP2_TS_TRANSCODER_VIDEO_RATE, RYGEL_MP2_TS_TRANSCODER_VIDEO_RATE, &_inner_error_);
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	videorate = _tmp0_;
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		return NULL;
#line 732 "rygel-mp2ts-transcoder.c"
	}
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp1_ = rygel_gst_utils_create_element (RYGEL_MP2_TS_TRANSCODER_VIDEO_SCALE, RYGEL_MP2_TS_TRANSCODER_VIDEO_SCALE, &_inner_error_);
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	videoscale = _tmp1_;
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_gst_object_unref0 (videorate);
#line 108 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		return NULL;
#line 746 "rygel-mp2ts-transcoder.c"
	}
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp2_ = rygel_gst_utils_create_element (RYGEL_MP2_TS_TRANSCODER_COLORSPACE_CONVERT, RYGEL_MP2_TS_TRANSCODER_COLORSPACE_CONVERT, &_inner_error_);
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	convert = _tmp2_;
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_gst_object_unref0 (videoscale);
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_gst_object_unref0 (videorate);
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		return NULL;
#line 762 "rygel-mp2ts-transcoder.c"
	}
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp3_ = rygel_gst_utils_create_element (RYGEL_MP2_TS_TRANSCODER_VIDEO_ENCODER, RYGEL_MP2_TS_TRANSCODER_VIDEO_ENCODER, &_inner_error_);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	encoder = _tmp3_;
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_gst_object_unref0 (convert);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_gst_object_unref0 (videoscale);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_gst_object_unref0 (videorate);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		return NULL;
#line 780 "rygel-mp2ts-transcoder.c"
	}
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp4_ = encoder;
#line 114 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_dynamic_set_bitrate0 (_tmp4_, ((gint) RYGEL_MP2_TS_TRANSCODER_VIDEO_BITRATE) * 1000);
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp5_ = (GstBin*) gst_bin_new ("video-encoder-bin");
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	gst_object_ref_sink (_tmp5_);
#line 116 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	bin = _tmp5_;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp6_ = bin;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp7_ = videorate;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp8_ = _gst_object_ref0 (_tmp7_);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp9_ = videoscale;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp10_ = _gst_object_ref0 (_tmp9_);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp11_ = convert;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp12_ = _gst_object_ref0 (_tmp11_);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp13_ = encoder;
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp14_ = _gst_object_ref0 (_tmp13_);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	gst_bin_add_many (_tmp6_, _tmp8_, _tmp10_, _tmp12_, _tmp14_, NULL);
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp15_ = convert;
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp16_ = videoscale;
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp17_ = videorate;
#line 119 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	gst_element_link_many (_tmp15_, _tmp16_, _tmp17_, NULL);
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp18_ = item;
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp19_ = _g_object_ref0 (RYGEL_IS_VIDEO_ITEM (_tmp18_) ? ((RygelVideoItem*) _tmp18_) : NULL);
#line 124 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	video_item = _tmp19_;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp21_ = video_item;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp22_ = rygel_visual_item_get_pixel_width ((RygelVisualItem*) _tmp21_);
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp23_ = _tmp22_;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	if (_tmp23_ > 0) {
#line 834 "rygel-mp2ts-transcoder.c"
		RygelVideoItem* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp24_ = video_item;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp25_ = rygel_visual_item_get_pixel_height ((RygelVisualItem*) _tmp24_);
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp26_ = _tmp25_;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp20_ = _tmp26_ > 0;
#line 846 "rygel-mp2ts-transcoder.c"
	} else {
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp20_ = FALSE;
#line 850 "rygel-mp2ts-transcoder.c"
	}
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp27_ = _tmp20_;
#line 126 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	if (_tmp27_) {
#line 856 "rygel-mp2ts-transcoder.c"
		RygelVideoItem* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		RygelMP2TSProfile _tmp31_;
		gint _tmp32_;
		RygelVideoItem* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		RygelVideoItem* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		RygelMP2TSProfile _tmp39_;
		gint _tmp40_;
		RygelVideoItem* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp28_ = video_item;
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp29_ = rygel_visual_item_get_width ((RygelVisualItem*) _tmp28_);
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp30_ = _tmp29_;
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp31_ = self->priv->profile;
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp32_ = RYGEL_MP2_TS_TRANSCODER_HEIGHT[_tmp31_];
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp33_ = video_item;
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp34_ = rygel_visual_item_get_pixel_width ((RygelVisualItem*) _tmp33_);
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp35_ = _tmp34_;
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		pixel_w = (_tmp30_ * _tmp32_) * _tmp35_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp36_ = video_item;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp37_ = rygel_visual_item_get_height ((RygelVisualItem*) _tmp36_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp38_ = _tmp37_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp39_ = self->priv->profile;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp40_ = RYGEL_MP2_TS_TRANSCODER_WIDTH[_tmp39_];
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp41_ = video_item;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp42_ = rygel_visual_item_get_pixel_height ((RygelVisualItem*) _tmp41_);
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		_tmp43_ = _tmp42_;
#line 130 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		pixel_h = (_tmp38_ * _tmp40_) * _tmp43_;
#line 909 "rygel-mp2ts-transcoder.c"
	} else {
#line 135 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		pixel_w = 1;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
		pixel_h = 1;
#line 915 "rygel-mp2ts-transcoder.c"
	}
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp44_ = self->priv->profile;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp45_ = RYGEL_MP2_TS_TRANSCODER_WIDTH[_tmp44_];
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp46_ = self->priv->profile;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp47_ = RYGEL_MP2_TS_TRANSCODER_HEIGHT[_tmp46_];
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp48_ = self->priv->profile;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp49_ = RYGEL_MP2_TS_TRANSCODER_FRAME_RATE[_tmp48_];
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp50_ = pixel_w;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp51_ = pixel_h;
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp52_ = gst_caps_new_simple ("video/x-raw-yuv", "width", G_TYPE_INT, _tmp45_, "height", G_TYPE_INT, _tmp47_, "framerate", GST_TYPE_FRACTION, _tmp49_, 1, "pixel-aspect-ratio", GST_TYPE_FRACTION, _tmp50_, _tmp51_, NULL);
#line 139 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	caps = _tmp52_;
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp53_ = videorate;
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp54_ = encoder;
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp55_ = caps;
#line 154 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	gst_element_link_filtered (_tmp53_, _tmp54_, _tmp55_);
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp56_ = convert;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp57_ = gst_element_get_static_pad (_tmp56_, "sink");
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	pad = _tmp57_;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp58_ = sink_pad_name;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp59_ = pad;
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp60_ = (GstGhostPad*) gst_ghost_pad_new (_tmp58_, _tmp59_);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	gst_object_ref_sink (_tmp60_);
#line 157 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	ghost = _tmp60_;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp61_ = bin;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp62_ = ghost;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp63_ = _gst_object_ref0 ((GstPad*) _tmp62_);
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	gst_element_add_pad ((GstElement*) _tmp61_, _tmp63_);
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp64_ = encoder;
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp65_ = gst_element_get_static_pad (_tmp64_, "src");
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_gst_object_unref0 (pad);
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	pad = _tmp65_;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp66_ = src_pad_name;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp67_ = pad;
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp68_ = (GstGhostPad*) gst_ghost_pad_new (_tmp66_, _tmp67_);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	gst_object_ref_sink (_tmp68_);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_gst_object_unref0 (ghost);
#line 161 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	ghost = _tmp68_;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp69_ = bin;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp70_ = ghost;
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_tmp71_ = _gst_object_ref0 ((GstPad*) _tmp70_);
#line 162 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	gst_element_add_pad ((GstElement*) _tmp69_, _tmp71_);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	result = (GstElement*) bin;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_gst_object_unref0 (ghost);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_gst_object_unref0 (pad);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_gst_caps_unref0 (caps);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_g_object_unref0 (video_item);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_gst_object_unref0 (encoder);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_gst_object_unref0 (convert);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_gst_object_unref0 (videoscale);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	_gst_object_unref0 (videorate);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	return result;
#line 1017 "rygel-mp2ts-transcoder.c"
}


static void rygel_mp2_ts_transcoder_class_init (RygelMP2TSTranscoderClass * klass) {
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	rygel_mp2_ts_transcoder_parent_class = g_type_class_peek_parent (klass);
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	g_type_class_add_private (klass, sizeof (RygelMP2TSTranscoderPrivate));
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->create_source = rygel_mp2_ts_transcoder_real_create_source;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->add_resource = rygel_mp2_ts_transcoder_real_add_resource;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->get_distance = rygel_mp2_ts_transcoder_real_get_distance;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_mp2_ts_transcoder_finalize;
#line 1034 "rygel-mp2ts-transcoder.c"
}


static void rygel_mp2_ts_transcoder_instance_init (RygelMP2TSTranscoder * self) {
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	self->priv = RYGEL_MP2_TS_TRANSCODER_GET_PRIVATE (self);
#line 1041 "rygel-mp2ts-transcoder.c"
}


static void rygel_mp2_ts_transcoder_finalize (GObject* obj) {
	RygelMP2TSTranscoder * self;
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	self = RYGEL_MP2_TS_TRANSCODER (obj);
#line 36 "/home/jens/Source/rygel/src/rygel/rygel-mp2ts-transcoder.vala"
	G_OBJECT_CLASS (rygel_mp2_ts_transcoder_parent_class)->finalize (obj);
#line 1051 "rygel-mp2ts-transcoder.c"
}


/**
 * Transcoder for mpeg transport stream containing mpeg 2 video and mp2 audio.
 * This element uses MP2TSTrancoderBin for actual transcoding.
 */
GType rygel_mp2_ts_transcoder_get_type (void) {
	static volatile gsize rygel_mp2_ts_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_mp2_ts_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMP2TSTranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_mp2_ts_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMP2TSTranscoder), 0, (GInstanceInitFunc) rygel_mp2_ts_transcoder_instance_init, NULL };
		GType rygel_mp2_ts_transcoder_type_id;
		rygel_mp2_ts_transcoder_type_id = g_type_register_static (RYGEL_TYPE_TRANSCODER, "RygelMP2TSTranscoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_mp2_ts_transcoder_type_id__volatile, rygel_mp2_ts_transcoder_type_id);
	}
	return rygel_mp2_ts_transcoder_type_id__volatile;
}



