/* rygel-media-export-harvesting-task.c generated by valac 0.13.3, the Vala compiler
 * generated from rygel-media-export-harvesting-task.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <rygel.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-dlna/gupnp-dlna-information.h>
#include <glib/gi18n-lib.h>


#define RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK (rygel_media_export_harvesting_task_get_type ())
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTask))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_IS_HARVESTING_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK))
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskClass))

typedef struct _RygelMediaExportHarvestingTask RygelMediaExportHarvestingTask;
typedef struct _RygelMediaExportHarvestingTaskClass RygelMediaExportHarvestingTaskClass;
typedef struct _RygelMediaExportHarvestingTaskPrivate RygelMediaExportHarvestingTaskPrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR (rygel_media_export_metadata_extractor_get_type ())
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractor))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_IS_METADATA_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR))
#define RYGEL_MEDIA_EXPORT_METADATA_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_METADATA_EXTRACTOR, RygelMediaExportMetadataExtractorClass))

typedef struct _RygelMediaExportMetadataExtractor RygelMediaExportMetadataExtractor;
typedef struct _RygelMediaExportMetadataExtractorClass RygelMediaExportMetadataExtractorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;

#define RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR (rygel_media_export_recursive_file_monitor_get_type ())
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitor))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_IS_RECURSIVE_FILE_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR))
#define RYGEL_MEDIA_EXPORT_RECURSIVE_FILE_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_RECURSIVE_FILE_MONITOR, RygelMediaExportRecursiveFileMonitorClass))

typedef struct _RygelMediaExportRecursiveFileMonitor RygelMediaExportRecursiveFileMonitor;
typedef struct _RygelMediaExportRecursiveFileMonitorClass RygelMediaExportRecursiveFileMonitorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskRunData RygelMediaExportHarvestingTaskRunData;

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER (rygel_media_export_dummy_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainer))
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DUMMY_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DUMMY_CONTAINER, RygelMediaExportDummyContainerClass))

typedef struct _RygelMediaExportDummyContainer RygelMediaExportDummyContainer;
typedef struct _RygelMediaExportDummyContainerClass RygelMediaExportDummyContainerClass;
typedef struct _RygelNullContainerPrivate RygelNullContainerPrivate;
typedef struct _RygelMediaExportDummyContainerPrivate RygelMediaExportDummyContainerPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _RygelMediaExportHarvestingTaskEnumerateDirectoryData RygelMediaExportHarvestingTaskEnumerateDirectoryData;

struct _RygelMediaExportHarvestingTask {
	GObject parent_instance;
	RygelMediaExportHarvestingTaskPrivate * priv;
	GFile* origin;
};

struct _RygelMediaExportHarvestingTaskClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportHarvestingTaskPrivate {
	RygelMediaExportMetadataExtractor* extractor;
	RygelMediaExportMediaCache* cache;
	GQueue* containers;
	GeeQueue* files;
	RygelMediaExportRecursiveFileMonitor* monitor;
	GRegex* file_filter;
	gchar* flag;
	RygelMediaContainer* parent;
	GCancellable* _cancellable;
};

struct _RygelMediaExportHarvestingTaskRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportHarvestingTask* self;
	GFile* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GFileInfo* _tmp3_;
	GFileInfo* info;
	GFile* _tmp4_;
	RygelMediaContainer* _tmp5_;
	gboolean _tmp6_;
	GFileType _tmp7_;
	GQueue* _tmp8_;
	RygelMediaContainer* _tmp9_;
	RygelMediaContainer* _tmp10_;
	GError* _error_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _tmp16_;
	const gchar* _tmp17_;
	GFile* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
struct _RygelNullContainer {
	RygelMediaContainer parent_instance;
	RygelNullContainerPrivate * priv;
};

struct _RygelNullContainerClass {
	RygelMediaContainerClass parent_class;
};

struct _RygelMediaExportDummyContainer {
	RygelNullContainer parent_instance;
	RygelMediaExportDummyContainerPrivate * priv;
	GFile* file;
	GeeList* children;
};

struct _RygelMediaExportDummyContainerClass {
	RygelNullContainerClass parent_class;
};

struct _RygelMediaExportHarvestingTaskEnumerateDirectoryData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaExportHarvestingTask* self;
	GQueue* _tmp0_;
	gconstpointer _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* directory;
	GFile* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	GFileEnumerator* _tmp7_;
	GFileEnumerator* enumerator;
	GList* list;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GList* _tmp10_;
	gboolean _tmp11_;
	GFileEnumerator* _tmp12_;
	GCancellable* _tmp13_;
	GCancellable* _tmp14_;
	GList* _tmp15_;
	GList* _tmp16_;
	GFileEnumerator* _tmp17_;
	GCancellable* _tmp18_;
	GCancellable* _tmp19_;
	GError* err;
	const gchar* _tmp20_;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GError * _inner_error_;
};


static gpointer rygel_media_export_harvesting_task_parent_class = NULL;
static RygelStateMachineIface* rygel_media_export_harvesting_task_rygel_state_machine_parent_iface = NULL;

GType rygel_media_export_harvesting_task_get_type (void) G_GNUC_CONST;
GType rygel_media_export_metadata_extractor_get_type (void) G_GNUC_CONST;
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_recursive_file_monitor_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, RygelMediaExportHarvestingTaskPrivate))
enum  {
	RYGEL_MEDIA_EXPORT_HARVESTING_TASK_DUMMY_PROPERTY,
	RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE
};
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_BATCH_SIZE 256
#define RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_STANDARD_SIZE
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const gchar* flag);
RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const gchar* flag);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
static void rygel_media_export_harvesting_task_on_extracted_cb (RygelMediaExportHarvestingTask* self, GFile* file, GUPnPDLNAInformation* dlna, const gchar* mime, guint64 size, guint64 mtime);
static void _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done (RygelMediaExportMetadataExtractor* _sender, GFile* file, GUPnPDLNAInformation* info, const gchar* mime, guint64 size, guint64 mtime, gpointer self);
static void rygel_media_export_harvesting_task_on_extractor_error_cb (RygelMediaExportHarvestingTask* self, GFile* file, GError* _error_);
static void _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error (RygelMediaExportMetadataExtractor* _sender, GFile* file, GError* err, gpointer self);
void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvesting_task_real_run_data_free (gpointer _data);
static void rygel_media_export_harvesting_task_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean rygel_media_export_harvesting_task_real_run_co (RygelMediaExportHarvestingTaskRunData* _data_);
static void rygel_media_export_harvesting_task_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean rygel_media_export_harvesting_task_process_file (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info, RygelMediaContainer* parent);
static gboolean rygel_media_export_harvesting_task_on_idle (RygelMediaExportHarvestingTask* self);
static gboolean _rygel_media_export_harvesting_task_on_idle_gsource_func (gpointer self);
static gboolean rygel_media_export_harvesting_task_push_if_changed_or_unknown (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info);
GQuark rygel_media_export_database_error_quark (void);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error);
void rygel_media_export_recursive_file_monitor_add (RygelMediaExportRecursiveFileMonitor* self, GFile* file, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_media_export_recursive_file_monitor_add_finish (RygelMediaExportRecursiveFileMonitor* self, GAsyncResult* _res_);
RygelMediaExportDummyContainer* rygel_media_export_dummy_container_new (GFile* file, RygelMediaContainer* parent);
RygelMediaExportDummyContainer* rygel_media_export_dummy_container_construct (GType object_type, GFile* file, RygelMediaContainer* parent);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
GType rygel_media_export_dummy_container_get_type (void) G_GNUC_CONST;
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
static gboolean rygel_media_export_harvesting_task_process_children (RygelMediaExportHarvestingTask* self, GList* list);
void rygel_media_export_dummy_container_seen (RygelMediaExportDummyContainer* self, GFile* file);
static void rygel_media_export_harvesting_task_enumerate_directory_data_free (gpointer _data);
static void rygel_media_export_harvesting_task_enumerate_directory (RygelMediaExportHarvestingTask* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_export_harvesting_task_enumerate_directory_finish (RygelMediaExportHarvestingTask* self, GAsyncResult* _res_);
static gboolean rygel_media_export_harvesting_task_enumerate_directory_co (RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_);
static void rygel_media_export_harvesting_task_enumerate_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void rygel_media_export_harvesting_task_cleanup_database (RygelMediaExportHarvestingTask* self);
static void rygel_media_export_harvesting_task_do_update (RygelMediaExportHarvestingTask* self);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error);
void rygel_media_export_metadata_extractor_extract (RygelMediaExportMetadataExtractor* self, GFile* file);
void rygel_media_export_media_cache_flag_object (RygelMediaExportMediaCache* self, GFile* file, const gchar* flag, GError** error);
RygelMediaItem* rygel_media_export_item_factory_create_simple (RygelMediaContainer* parent, GFile* file, const gchar* mime, guint64 size, guint64 mtime);
RygelMediaItem* rygel_media_export_item_factory_create_from_info (RygelMediaContainer* parent, GFile* file, GUPnPDLNAInformation* dlna_info, const gchar* mime, guint64 size, guint64 mtime);
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
static void rygel_media_export_harvesting_task_finalize (GObject* obj);
static void _vala_rygel_media_export_harvesting_task_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_media_export_harvesting_task_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	return self ? g_object_ref (self) : NULL;
#line 288 "rygel-media-export-harvesting-task.c"
}


static void _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done (RygelMediaExportMetadataExtractor* _sender, GFile* file, GUPnPDLNAInformation* info, const gchar* mime, guint64 size, guint64 mtime, gpointer self) {
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	rygel_media_export_harvesting_task_on_extracted_cb (self, file, info, mime, size, mtime);
#line 295 "rygel-media-export-harvesting-task.c"
}


static void _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error (RygelMediaExportMetadataExtractor* _sender, GFile* file, GError* err, gpointer self) {
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	rygel_media_export_harvesting_task_on_extractor_error_cb (self, file, err);
#line 302 "rygel-media-export-harvesting-task.c"
}


static gpointer _g_regex_ref0 (gpointer self) {
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	return self ? g_regex_ref (self) : NULL;
#line 309 "rygel-media-export-harvesting-task.c"
}


RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_construct (GType object_type, RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const gchar* flag) {
	RygelMediaExportHarvestingTask * self = NULL;
	RygelMediaExportMetadataExtractor* _tmp0_;
	RygelMediaExportMetadataExtractor* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	RygelMediaContainer* _tmp4_;
	RygelMediaContainer* _tmp5_;
	RygelMediaExportMetadataExtractor* _tmp8_;
	RygelMediaExportMetadataExtractor* _tmp9_;
	GeeLinkedList* _tmp10_;
	GQueue* _tmp11_;
	RygelMediaExportRecursiveFileMonitor* _tmp12_;
	RygelMediaExportRecursiveFileMonitor* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GRegex* _tmp16_;
	GRegex* _tmp17_;
	GError * _inner_error_ = NULL;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (extractor != NULL, NULL);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (monitor != NULL, NULL);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (parent != NULL, NULL);
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	self = (RygelMediaExportHarvestingTask*) g_object_new (object_type, NULL);
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp0_ = extractor;
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (self->priv->extractor);
#line 52 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	self->priv->extractor = _tmp1_;
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp2_ = file;
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (self->origin);
#line 53 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	self->origin = _tmp3_;
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp4_ = parent;
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (self->priv->parent);
#line 54 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	self->priv->parent = _tmp5_;
#line 366 "rygel-media-export-harvesting-task.c"
	{
		RygelMediaExportMediaCache* _tmp6_ = NULL;
		RygelMediaExportMediaCache* _tmp7_;
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp6_ = rygel_media_export_media_cache_get_default (&_inner_error_);
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp7_ = _tmp6_;
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		if (_inner_error_ != NULL) {
#line 376 "rygel-media-export-harvesting-task.c"
			goto __catch47_g_error;
		}
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_object_unref0 (self->priv->cache);
#line 57 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		self->priv->cache = _tmp7_;
#line 383 "rygel-media-export-harvesting-task.c"
	}
	goto __finally47;
	__catch47_g_error:
	{
		GError* _error_ = NULL;
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_error_ = _inner_error_;
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_inner_error_ = NULL;
#line 62 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_assert_not_reached ();
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_error_free0 (_error_);
#line 397 "rygel-media-export-harvesting-task.c"
	}
	__finally47:
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_inner_error_ != NULL) {
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_clear_error (&_inner_error_);
#line 56 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		return NULL;
#line 408 "rygel-media-export-harvesting-task.c"
	}
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp8_ = self->priv->extractor;
#line 65 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_signal_connect_object (_tmp8_, "extraction-done", (GCallback) _rygel_media_export_harvesting_task_on_extracted_cb_rygel_media_export_metadata_extractor_extraction_done, self, 0);
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp9_ = self->priv->extractor;
#line 66 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_signal_connect_object (_tmp9_, "error", (GCallback) _rygel_media_export_harvesting_task_on_extractor_error_cb_rygel_media_export_metadata_extractor_error, self, 0);
#line 68 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp10_ = gee_linked_list_new (G_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 68 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (self->priv->files);
#line 68 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	self->priv->files = (GeeQueue*) _tmp10_;
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp11_ = g_queue_new ();
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_queue_free0 (self->priv->containers);
#line 69 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	self->priv->containers = _tmp11_;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp12_ = monitor;
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp13_ = _g_object_ref0 (_tmp12_);
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (self->priv->monitor);
#line 70 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	self->priv->monitor = _tmp13_;
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp14_ = flag;
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp15_ = g_strdup (_tmp14_);
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_free0 (self->priv->flag);
#line 71 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	self->priv->flag = _tmp15_;
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp16_ = file_filter;
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp17_ = _g_regex_ref0 (_tmp16_);
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_regex_unref0 (self->priv->file_filter);
#line 72 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	self->priv->file_filter = _tmp17_;
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	return self;
#line 456 "rygel-media-export-harvesting-task.c"
}


RygelMediaExportHarvestingTask* rygel_media_export_harvesting_task_new (RygelMediaExportMetadataExtractor* extractor, RygelMediaExportRecursiveFileMonitor* monitor, GRegex* file_filter, GFile* file, RygelMediaContainer* parent, const gchar* flag) {
#line 46 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	return rygel_media_export_harvesting_task_construct (RYGEL_MEDIA_EXPORT_TYPE_HARVESTING_TASK, extractor, monitor, file_filter, file, parent, flag);
#line 463 "rygel-media-export-harvesting-task.c"
}


void rygel_media_export_harvesting_task_cancel (RygelMediaExportHarvestingTask* self) {
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
#line 75 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp0_ = g_cancellable_new ();
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp1_ = _tmp0_;
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp1_);
#line 78 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (_tmp1_);
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp2_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp3_ = _tmp2_;
#line 79 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_cancellable_cancel (_tmp3_);
#line 488 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_real_run_data_free (gpointer _data) {
	RygelMediaExportHarvestingTaskRunData* _data_;
	_data_ = _data;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (_data_->self);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_slice_free (RygelMediaExportHarvestingTaskRunData, _data_);
#line 499 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportHarvestingTask * self;
	RygelMediaExportHarvestingTaskRunData* _data_;
	RygelMediaExportHarvestingTask* _tmp0_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	self = (RygelMediaExportHarvestingTask*) base;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_ = g_slice_new0 (RygelMediaExportHarvestingTaskRunData);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_harvesting_task_real_run);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_harvesting_task_real_run_data_free);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_->self = _tmp0_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	rygel_media_export_harvesting_task_real_run_co (_data_);
#line 521 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelMediaExportHarvestingTaskRunData* _data_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 529 "rygel-media-export-harvesting-task.c"
}


/**
     * Extract all metainformation from a given file.
     *
     * What action will be taken depends on the arguments
     * * file is a simple file. Then only information of this
     *   file will be extracted
     * * file is a directory and recursive is false. The children
     *   of the directory (if not directories themselves) will be
     *   enqueued for extraction
     * * file is a directory and recursive is true. ++ All ++ children
     *   of the directory will be enqueued for extraction, even directories
     *
     * No matter how many children are contained within file's hierarchy,
     * only one event is sent when all the children are done.
     */
static void rygel_media_export_harvesting_task_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskRunData* _data_;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_ = _user_data_;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_->_source_object_ = source_object;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_->_res_ = _res_;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	rygel_media_export_harvesting_task_real_run_co (_data_);
#line 558 "rygel-media-export-harvesting-task.c"
}


static gboolean _rygel_media_export_harvesting_task_on_idle_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_media_export_harvesting_task_on_idle (self);
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	return result;
#line 567 "rygel-media-export-harvesting-task.c"
}


static gboolean rygel_media_export_harvesting_task_real_run_co (RygelMediaExportHarvestingTaskRunData* _data_) {
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	switch (_data_->_state_) {
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		case 0:
#line 576 "rygel-media-export-harvesting-task.c"
		goto _state_0;
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		case 1:
#line 580 "rygel-media-export-harvesting-task.c"
		goto _state_1;
		default:
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_assert_not_reached ();
#line 585 "rygel-media-export-harvesting-task.c"
	}
	_state_0:
	{
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp0_ = _data_->self->origin;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp1_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp2_ = _data_->_tmp1_;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_state_ = 1;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_file_query_info_async (_data_->_tmp0_, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp2_, rygel_media_export_harvesting_task_run_ready, _data_);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		return FALSE;
#line 601 "rygel-media-export-harvesting-task.c"
		_state_1:
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp3_ = NULL;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp3_ = g_file_query_info_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->info = _data_->_tmp3_;
#line 99 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		if (_data_->_inner_error_ != NULL) {
#line 611 "rygel-media-export-harvesting-task.c"
			goto __catch48_g_error;
		}
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp4_ = _data_->self->origin;
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp5_ = _data_->self->priv->parent;
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp6_ = FALSE;
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp6_ = rygel_media_export_harvesting_task_process_file (_data_->self, _data_->_tmp4_, _data_->info, _data_->_tmp5_);
#line 105 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		if (_data_->_tmp6_) {
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_data_->_tmp7_ = 0;
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_data_->_tmp7_ = g_file_info_get_file_type (_data_->info);
#line 106 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			if (_data_->_tmp7_ != G_FILE_TYPE_DIRECTORY) {
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_data_->_tmp8_ = _data_->self->priv->containers;
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_data_->_tmp9_ = _data_->self->priv->parent;
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
#line 107 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				g_queue_push_tail (_data_->_tmp8_, _data_->_tmp10_);
#line 638 "rygel-media-export-harvesting-task.c"
			}
#line 109 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_media_export_harvesting_task_on_idle_gsource_func, g_object_ref (_data_->self), g_object_unref);
#line 642 "rygel-media-export-harvesting-task.c"
		} else {
#line 111 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 646 "rygel-media-export-harvesting-task.c"
		}
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_object_unref0 (_data_->info);
#line 650 "rygel-media-export-harvesting-task.c"
	}
	goto __finally48;
	__catch48_g_error:
	{
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_inner_error_ = NULL;
#line 114 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp11_ = _data_->_error_;
#line 114 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		if (!g_error_matches (_data_->_tmp11_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_data_->_tmp12_ = NULL;
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_data_->_tmp12_ = _ ("Failed to harvest file %s: %s");
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_data_->_tmp13_ = _data_->self->origin;
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_data_->_tmp14_ = NULL;
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_data_->_tmp14_ = g_file_get_uri (_data_->_tmp13_);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_data_->_tmp15_ = _data_->_tmp14_;
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_data_->_tmp16_ = _data_->_error_;
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_data_->_tmp17_ = _data_->_tmp16_->message;
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			g_warning (_data_->_tmp12_, _data_->_tmp15_, _data_->_tmp17_);
#line 115 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_g_free0 (_data_->_tmp15_);
#line 683 "rygel-media-export-harvesting-task.c"
		} else {
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_data_->_tmp18_ = _data_->self->origin;
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_data_->_tmp19_ = NULL;
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_data_->_tmp19_ = g_file_get_uri (_data_->_tmp18_);
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_data_->_tmp20_ = _data_->_tmp19_;
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			g_debug ("rygel-media-export-harvesting-task.vala:119: Harvesting of uri %s was " \
"cancelled", _data_->_tmp20_);
#line 119 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_g_free0 (_data_->_tmp20_);
#line 697 "rygel-media-export-harvesting-task.c"
		}
#line 122 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_signal_emit_by_name ((RygelStateMachine*) _data_->self, "completed");
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_error_free0 (_data_->_error_);
#line 703 "rygel-media-export-harvesting-task.c"
	}
	__finally48:
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_data_->_inner_error_ != NULL) {
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_clear_error (&_data_->_inner_error_);
#line 98 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		return FALSE;
#line 714 "rygel-media-export-harvesting-task.c"
	}
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_data_->_state_ == 0) {
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 720 "rygel-media-export-harvesting-task.c"
	} else {
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 724 "rygel-media-export-harvesting-task.c"
	}
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_object_unref (_data_->_async_result);
#line 97 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	return FALSE;
#line 730 "rygel-media-export-harvesting-task.c"
}


/**
     * Add a file to the meta-data extraction queue.
     *
     * The file will only be added to the queue if one of the following
     * conditions is met:
     *   - The file is not in the cache
     *   - The current mtime of the file is larger than the cached
     *   - The size has changed
     * @param file to check
     * @param info FileInfo of the file to check
     * @return true, if the file has been queued, false otherwise.
     */
static gboolean rygel_media_export_harvesting_task_push_if_changed_or_unknown (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info) {
	gboolean result = FALSE;
	gint64 timestamp = 0LL;
	gint64 size = 0LL;
	GError * _inner_error_ = NULL;
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 138 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (info != NULL, FALSE);
#line 757 "rygel-media-export-harvesting-task.c"
	{
		RygelMediaExportMediaCache* _tmp0_;
		GFile* _tmp1_;
		gint64 _tmp2_ = 0LL;
		gint64 _tmp3_ = 0LL;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp0_ = self->priv->cache;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp1_ = file;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp4_ = rygel_media_export_media_cache_exists (_tmp0_, _tmp1_, &_tmp2_, &_tmp3_, &_inner_error_);
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		timestamp = _tmp2_;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		size = _tmp3_;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp5_ = _tmp4_;
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		if (_inner_error_ != NULL) {
#line 779 "rygel-media-export-harvesting-task.c"
			goto __catch49_g_error;
		}
#line 143 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		if (_tmp5_) {
#line 784 "rygel-media-export-harvesting-task.c"
			GFileInfo* _tmp6_;
			guint64 _tmp7_ = 0ULL;
			gint64 mtime;
			gboolean _tmp8_ = FALSE;
			gint64 _tmp9_;
			gint64 _tmp10_;
			gboolean _tmp14_;
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp6_ = info;
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp7_ = g_file_info_get_attribute_uint64 (_tmp6_, G_FILE_ATTRIBUTE_TIME_MODIFIED);
#line 144 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			mtime = (gint64) _tmp7_;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp9_ = mtime;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp10_ = timestamp;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			if (_tmp9_ > _tmp10_) {
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp8_ = TRUE;
#line 806 "rygel-media-export-harvesting-task.c"
			} else {
				GFileInfo* _tmp11_;
				gint64 _tmp12_ = 0LL;
				gint64 _tmp13_;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp11_ = info;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp12_ = g_file_info_get_size (_tmp11_);
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp13_ = size;
#line 148 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp8_ = _tmp12_ != _tmp13_;
#line 819 "rygel-media-export-harvesting-task.c"
			}
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp14_ = _tmp8_;
#line 147 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			if (_tmp14_) {
#line 825 "rygel-media-export-harvesting-task.c"
				GeeQueue* _tmp15_;
				GFile* _tmp16_;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp15_ = self->priv->files;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp16_ = file;
#line 149 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				gee_queue_offer (_tmp15_, _tmp16_);
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				result = TRUE;
#line 151 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				return result;
#line 838 "rygel-media-export-harvesting-task.c"
			}
		} else {
			GeeQueue* _tmp17_;
			GFile* _tmp18_;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp17_ = self->priv->files;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp18_ = file;
#line 154 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			gee_queue_offer (_tmp17_, _tmp18_);
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			result = TRUE;
#line 156 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			return result;
#line 853 "rygel-media-export-harvesting-task.c"
		}
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp19_ = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_error_ = _inner_error_;
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_inner_error_ = NULL;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp19_ = _ ("Failed to query database: %s");
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp20_ = _error_;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp21_ = _tmp20_->message;
#line 159 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_warning (_tmp19_, _tmp21_);
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_error_free0 (_error_);
#line 877 "rygel-media-export-harvesting-task.c"
	}
	__finally49:
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_inner_error_ != NULL) {
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_clear_error (&_inner_error_);
#line 142 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		return FALSE;
#line 888 "rygel-media-export-harvesting-task.c"
	}
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	result = FALSE;
#line 162 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	return result;
#line 894 "rygel-media-export-harvesting-task.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
#line 1118 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1119 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1119 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1119 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1119 "/opt/gnome2/share/vala-0.14/vapi/glib-2.0.vapi"
	return result;
#line 912 "rygel-media-export-harvesting-task.c"
}


static gboolean rygel_media_export_harvesting_task_process_file (RygelMediaExportHarvestingTask* self, GFile* file, GFileInfo* info, RygelMediaContainer* parent) {
	gboolean result = FALSE;
	GFileInfo* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar _tmp2_ = '\0';
	GFileInfo* _tmp3_;
	GFileType _tmp4_ = 0;
	GError * _inner_error_ = NULL;
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (info != NULL, FALSE);
#line 165 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (parent != NULL, FALSE);
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp0_ = info;
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp1_ = g_file_info_get_name (_tmp0_);
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp2_ = string_get (_tmp1_, (glong) 0);
#line 168 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_tmp2_ == '.') {
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		result = FALSE;
#line 169 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		return result;
#line 944 "rygel-media-export-harvesting-task.c"
	}
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp3_ = info;
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp4_ = g_file_info_get_file_type (_tmp3_);
#line 172 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_tmp4_ == G_FILE_TYPE_DIRECTORY) {
#line 952 "rygel-media-export-harvesting-task.c"
		RygelMediaExportRecursiveFileMonitor* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		RygelMediaContainer* _tmp8_;
		RygelMediaExportDummyContainer* _tmp9_;
		RygelMediaExportDummyContainer* container;
		GQueue* _tmp10_;
		RygelMediaExportDummyContainer* _tmp11_;
		RygelMediaContainer* _tmp12_;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp5_ = self->priv->monitor;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp6_ = file;
#line 174 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		rygel_media_export_recursive_file_monitor_add (_tmp5_, _tmp6_, NULL, NULL);
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp7_ = file;
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp8_ = parent;
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp9_ = rygel_media_export_dummy_container_new (_tmp7_, _tmp8_);
#line 176 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		container = _tmp9_;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp10_ = self->priv->containers;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp11_ = container;
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp12_ = _g_object_ref0 ((RygelMediaContainer*) _tmp11_);
#line 177 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_queue_push_tail (_tmp10_, _tmp12_);
#line 984 "rygel-media-export-harvesting-task.c"
		{
			RygelMediaExportMediaCache* _tmp13_;
			RygelMediaExportDummyContainer* _tmp14_;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp13_ = self->priv->cache;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp14_ = container;
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			rygel_media_export_media_cache_save_container (_tmp13_, (RygelMediaContainer*) _tmp14_, &_inner_error_);
#line 179 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			if (_inner_error_ != NULL) {
#line 996 "rygel-media-export-harvesting-task.c"
				goto __catch50_g_error;
			}
		}
		goto __finally50;
		__catch50_g_error:
		{
			GError* err = NULL;
			const gchar* _tmp15_ = NULL;
			GError* _tmp16_;
			const gchar* _tmp17_;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			err = _inner_error_;
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_inner_error_ = NULL;
#line 181 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp15_ = _ ("Failed to update database: %s");
#line 181 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp16_ = err;
#line 181 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp17_ = _tmp16_->message;
#line 181 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			g_warning (_tmp15_, _tmp17_);
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			result = FALSE;
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_g_error_free0 (err);
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_g_object_unref0 (container);
#line 183 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			return result;
#line 1027 "rygel-media-export-harvesting-task.c"
		}
		__finally50:
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		if (_inner_error_ != NULL) {
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_g_object_unref0 (container);
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			g_clear_error (&_inner_error_);
#line 178 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			return FALSE;
#line 1040 "rygel-media-export-harvesting-task.c"
		}
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		result = TRUE;
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_object_unref0 (container);
#line 186 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		return result;
#line 1048 "rygel-media-export-harvesting-task.c"
	} else {
		gboolean _tmp18_ = FALSE;
		GRegex* _tmp19_;
		gboolean _tmp25_;
		GFile* _tmp26_;
		GFileInfo* _tmp27_;
		gboolean _tmp28_ = FALSE;
#line 190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp19_ = self->priv->file_filter;
#line 190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		if (_tmp19_ != NULL) {
#line 1060 "rygel-media-export-harvesting-task.c"
			GRegex* _tmp20_;
			GFile* _tmp21_;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			gboolean _tmp24_ = FALSE;
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp20_ = self->priv->file_filter;
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp21_ = file;
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp22_ = g_file_get_uri (_tmp21_);
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp23_ = _tmp22_;
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp24_ = g_regex_match (_tmp20_, _tmp23_, 0, NULL);
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp18_ = !_tmp24_;
#line 191 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_g_free0 (_tmp23_);
#line 1080 "rygel-media-export-harvesting-task.c"
		} else {
#line 190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp18_ = FALSE;
#line 1084 "rygel-media-export-harvesting-task.c"
		}
#line 190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp25_ = _tmp18_;
#line 190 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		if (_tmp25_) {
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			result = FALSE;
#line 192 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			return result;
#line 1094 "rygel-media-export-harvesting-task.c"
		}
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp26_ = file;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp27_ = info;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp28_ = rygel_media_export_harvesting_task_push_if_changed_or_unknown (self, _tmp26_, _tmp27_);
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		result = _tmp28_;
#line 195 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		return result;
#line 1106 "rygel-media-export-harvesting-task.c"
	}
}


static gboolean rygel_media_export_harvesting_task_process_children (RygelMediaExportHarvestingTask* self, GList* list) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_;
	gboolean _tmp5_;
	GQueue* _tmp6_;
	gconstpointer _tmp7_ = NULL;
	RygelMediaExportDummyContainer* _tmp8_;
	RygelMediaExportDummyContainer* container;
	GList* _tmp9_;
#line 199 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp1_ = list;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_tmp1_ == NULL) {
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp0_ = TRUE;
#line 1129 "rygel-media-export-harvesting-task.c"
	} else {
		GCancellable* _tmp2_;
		GCancellable* _tmp3_;
		gboolean _tmp4_ = FALSE;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp2_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp3_ = _tmp2_;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp4_ = g_cancellable_is_cancelled (_tmp3_);
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp0_ = _tmp4_;
#line 1142 "rygel-media-export-harvesting-task.c"
	}
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp5_ = _tmp0_;
#line 200 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_tmp5_) {
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		result = FALSE;
#line 201 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		return result;
#line 1152 "rygel-media-export-harvesting-task.c"
	}
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp6_ = self->priv->containers;
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp7_ = g_queue_peek_head (_tmp6_);
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp8_ = _g_object_ref0 (RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER ((RygelMediaContainer*) _tmp7_) ? ((RygelMediaExportDummyContainer*) ((RygelMediaContainer*) _tmp7_)) : NULL);
#line 204 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	container = _tmp8_;
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp9_ = list;
#line 1164 "rygel-media-export-harvesting-task.c"
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		info_collection = _tmp9_;
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
#line 1172 "rygel-media-export-harvesting-task.c"
			GFileInfo* _tmp10_;
			GFileInfo* info = NULL;
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp10_ = _g_object_ref0 ((GFileInfo*) info_it->data);
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			info = _tmp10_;
#line 1179 "rygel-media-export-harvesting-task.c"
			{
				RygelMediaExportDummyContainer* _tmp11_;
				GFile* _tmp12_;
				GFileInfo* _tmp13_;
				const gchar* _tmp14_ = NULL;
				GFile* _tmp15_ = NULL;
				GFile* file;
				RygelMediaExportDummyContainer* _tmp16_;
				GFile* _tmp17_;
				GFile* _tmp18_;
				GFileInfo* _tmp19_;
				RygelMediaExportDummyContainer* _tmp20_;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp11_ = container;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp12_ = _tmp11_->file;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp13_ = info;
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp14_ = g_file_info_get_name (_tmp13_);
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp15_ = g_file_get_child (_tmp12_, _tmp14_);
#line 207 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				file = _tmp15_;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp16_ = container;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp17_ = file;
#line 209 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				rygel_media_export_dummy_container_seen (_tmp16_, _tmp17_);
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp18_ = file;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp19_ = info;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp20_ = container;
#line 210 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				rygel_media_export_harvesting_task_process_file (self, _tmp18_, _tmp19_, (RygelMediaContainer*) _tmp20_);
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_g_object_unref0 (file);
#line 206 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_g_object_unref0 (info);
#line 1222 "rygel-media-export-harvesting-task.c"
			}
		}
	}
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	result = TRUE;
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (container);
#line 213 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	return result;
#line 1232 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_enumerate_directory_data_free (gpointer _data) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	_data_ = _data;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (_data_->self);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_slice_free (RygelMediaExportHarvestingTaskEnumerateDirectoryData, _data_);
#line 1243 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_enumerate_directory (RygelMediaExportHarvestingTask* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
	RygelMediaExportHarvestingTask* _tmp0_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_ = g_slice_new0 (RygelMediaExportHarvestingTaskEnumerateDirectoryData);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_export_harvesting_task_enumerate_directory);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_export_harvesting_task_enumerate_directory_data_free);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_->self = _tmp0_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	rygel_media_export_harvesting_task_enumerate_directory_co (_data_);
#line 1262 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_enumerate_directory_finish (RygelMediaExportHarvestingTask* self, GAsyncResult* _res_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 1270 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_enumerate_directory_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_;
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_ = _user_data_;
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_->_source_object_ = source_object;
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_->_res_ = _res_;
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	rygel_media_export_harvesting_task_enumerate_directory_co (_data_);
#line 1284 "rygel-media-export-harvesting-task.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1291 "rygel-media-export-harvesting-task.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_list_free (self);
#line 1300 "rygel-media-export-harvesting-task.c"
}


static gboolean rygel_media_export_harvesting_task_enumerate_directory_co (RygelMediaExportHarvestingTaskEnumerateDirectoryData* _data_) {
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	switch (_data_->_state_) {
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		case 0:
#line 1309 "rygel-media-export-harvesting-task.c"
		goto _state_0;
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		case 1:
#line 1313 "rygel-media-export-harvesting-task.c"
		goto _state_1;
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		case 2:
#line 1317 "rygel-media-export-harvesting-task.c"
		goto _state_2;
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		case 3:
#line 1321 "rygel-media-export-harvesting-task.c"
		goto _state_3;
		default:
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_assert_not_reached ();
#line 1326 "rygel-media-export-harvesting-task.c"
	}
	_state_0:
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_->_tmp0_ = _data_->self->priv->containers;
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_->_tmp1_ = NULL;
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_->_tmp1_ = g_queue_peek_head (_data_->_tmp0_);
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_->_tmp2_ = (RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER ((RygelMediaContainer*) _data_->_tmp1_) ? ((RygelMediaExportDummyContainer*) ((RygelMediaContainer*) _data_->_tmp1_)) : NULL)->file;
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
#line 217 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_data_->directory = _data_->_tmp3_;
#line 1341 "rygel-media-export-harvesting-task.c"
	{
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp4_ = _data_->directory;
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp5_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp6_ = _data_->_tmp5_;
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_state_ = 1;
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_file_enumerate_children_async (_data_->_tmp4_, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_HARVESTER_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, _data_->_tmp6_, rygel_media_export_harvesting_task_enumerate_directory_ready, _data_);
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		return FALSE;
#line 1355 "rygel-media-export-harvesting-task.c"
		_state_1:
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp7_ = NULL;
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp7_ = g_file_enumerate_children_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->enumerator = _data_->_tmp7_;
#line 219 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		if (_data_->_inner_error_ != NULL) {
#line 1365 "rygel-media-export-harvesting-task.c"
			goto __catch51_g_error;
		}
#line 225 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->list = NULL;
#line 1370 "rygel-media-export-harvesting-task.c"
		{
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_data_->_tmp8_ = TRUE;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			while (TRUE) {
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_data_->_tmp9_ = _data_->_tmp8_;
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				if (!_data_->_tmp9_) {
#line 230 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					_data_->_tmp10_ = _data_->list;
#line 230 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					_data_->_tmp11_ = FALSE;
#line 230 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					_data_->_tmp11_ = rygel_media_export_harvesting_task_process_children (_data_->self, _data_->_tmp10_);
#line 230 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					if (!_data_->_tmp11_) {
#line 230 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
						break;
#line 1390 "rygel-media-export-harvesting-task.c"
					}
				}
#line 226 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_data_->_tmp8_ = FALSE;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_data_->_tmp12_ = _data_->enumerator;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_data_->_tmp13_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_data_->_tmp14_ = _data_->_tmp13_;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_data_->_state_ = 2;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				g_file_enumerator_next_files_async (_data_->_tmp12_, RYGEL_MEDIA_EXPORT_HARVESTING_TASK_BATCH_SIZE, G_PRIORITY_DEFAULT, _data_->_tmp14_, rygel_media_export_harvesting_task_enumerate_directory_ready, _data_);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				return FALSE;
#line 1407 "rygel-media-export-harvesting-task.c"
				_state_2:
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_data_->_tmp15_ = NULL;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_data_->_tmp15_ = g_file_enumerator_next_files_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error_);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_data_->_tmp16_ = _data_->_tmp15_;
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				if (_data_->_inner_error_ != NULL) {
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					__g_list_free__g_object_unref0_0 (_data_->list);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					_g_object_unref0 (_data_->enumerator);
#line 1421 "rygel-media-export-harvesting-task.c"
					goto __catch51_g_error;
				}
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				__g_list_free__g_object_unref0_0 (_data_->list);
#line 227 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_data_->list = _data_->_tmp16_;
#line 1428 "rygel-media-export-harvesting-task.c"
			}
		}
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp17_ = _data_->enumerator;
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp18_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp19_ = _data_->_tmp18_;
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_state_ = 3;
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_file_enumerator_close_async (_data_->_tmp17_, G_PRIORITY_DEFAULT, _data_->_tmp19_, rygel_media_export_harvesting_task_enumerate_directory_ready, _data_);
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		return FALSE;
#line 1443 "rygel-media-export-harvesting-task.c"
		_state_3:
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_file_enumerator_close_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error_);
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		if (_data_->_inner_error_ != NULL) {
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			__g_list_free__g_object_unref0_0 (_data_->list);
#line 232 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_g_object_unref0 (_data_->enumerator);
#line 1453 "rygel-media-export-harvesting-task.c"
			goto __catch51_g_error;
		}
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		__g_list_free__g_object_unref0_0 (_data_->list);
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_object_unref0 (_data_->enumerator);
#line 1460 "rygel-media-export-harvesting-task.c"
	}
	goto __finally51;
	__catch51_g_error:
	{
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->err = _data_->_inner_error_;
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_inner_error_ = NULL;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp20_ = NULL;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp20_ = _ ("failed to enumerate folder: %s");
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp21_ = _data_->err;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_data_->_tmp22_ = _data_->_tmp21_->message;
#line 234 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_warning (_data_->_tmp20_, _data_->_tmp22_);
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_error_free0 (_data_->err);
#line 1481 "rygel-media-export-harvesting-task.c"
	}
	__finally51:
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_data_->_inner_error_ != NULL) {
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_object_unref0 (_data_->directory);
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_clear_error (&_data_->_inner_error_);
#line 218 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		return FALSE;
#line 1494 "rygel-media-export-harvesting-task.c"
	}
#line 237 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	rygel_media_export_harvesting_task_cleanup_database (_data_->self);
#line 238 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	rygel_media_export_harvesting_task_do_update (_data_->self);
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (_data_->directory);
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_data_->_state_ == 0) {
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 1506 "rygel-media-export-harvesting-task.c"
	} else {
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 1510 "rygel-media-export-harvesting-task.c"
	}
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_object_unref (_data_->_async_result);
#line 216 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	return FALSE;
#line 1516 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_cleanup_database (RygelMediaExportHarvestingTask* self) {
	GQueue* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	RygelMediaExportDummyContainer* _tmp2_;
	RygelMediaExportDummyContainer* container;
	GError * _inner_error_ = NULL;
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_if_fail (self != NULL);
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp0_ = self->priv->containers;
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp1_ = g_queue_peek_head (_tmp0_);
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp2_ = _g_object_ref0 (RYGEL_MEDIA_EXPORT_IS_DUMMY_CONTAINER ((RygelMediaContainer*) _tmp1_) ? ((RygelMediaExportDummyContainer*) ((RygelMediaContainer*) _tmp1_)) : NULL);
#line 242 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	container = _tmp2_;
#line 1536 "rygel-media-export-harvesting-task.c"
	{
		{
			RygelMediaExportDummyContainer* _tmp3_;
			GeeList* _tmp4_;
			GeeList* _tmp5_;
			GeeList* _child_list;
			GeeList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _child_size;
			gint _child_index;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp3_ = container;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp4_ = _tmp3_->children;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp5_ = _g_object_ref0 (_tmp4_);
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_child_list = _tmp5_;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp6_ = _child_list;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp8_ = _tmp7_;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_child_size = _tmp8_;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_child_index = -1;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			while (TRUE) {
#line 1568 "rygel-media-export-harvesting-task.c"
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				GeeList* _tmp12_;
				gint _tmp13_;
				gpointer _tmp14_ = NULL;
				gchar* child;
				RygelMediaExportMediaCache* _tmp15_;
				const gchar* _tmp16_;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp9_ = _child_index;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_child_index = _tmp9_ + 1;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp10_ = _child_index;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp11_ = _child_size;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				if (!(_tmp10_ < _tmp11_)) {
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					break;
#line 1590 "rygel-media-export-harvesting-task.c"
				}
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp12_ = _child_list;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp13_ = _child_index;
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp14_ = gee_list_get (_tmp12_, _tmp13_);
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				child = (gchar*) _tmp14_;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp15_ = self->priv->cache;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp16_ = child;
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				rygel_media_export_media_cache_remove_by_id (_tmp15_, _tmp16_, &_inner_error_);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				if (_inner_error_ != NULL) {
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					_g_free0 (child);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					_g_object_unref0 (_child_list);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
#line 1614 "rygel-media-export-harvesting-task.c"
						goto __catch52_rygel_media_export_database_error;
					}
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					_g_free0 (child);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					_g_object_unref0 (_child_list);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					_g_object_unref0 (container);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					g_clear_error (&_inner_error_);
#line 247 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					return;
#line 1629 "rygel-media-export-harvesting-task.c"
				}
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_g_free0 (child);
#line 1633 "rygel-media-export-harvesting-task.c"
			}
#line 246 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_g_object_unref0 (_child_list);
#line 1637 "rygel-media-export-harvesting-task.c"
		}
	}
	goto __finally52;
	__catch52_rygel_media_export_database_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp17_ = NULL;
		RygelMediaExportDummyContainer* _tmp18_;
		const gchar* _tmp19_;
		GError* _tmp20_;
		const gchar* _tmp21_;
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_error_ = _inner_error_;
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_inner_error_ = NULL;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp17_ = _ ("Failed to get children of container %s: %s");
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp18_ = container;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp19_ = ((RygelMediaObject*) _tmp18_)->id;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp20_ = _error_;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp21_ = _tmp20_->message;
#line 250 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_warning (_tmp17_, _tmp19_, _tmp21_);
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_error_free0 (_error_);
#line 1667 "rygel-media-export-harvesting-task.c"
	}
	__finally52:
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_inner_error_ != NULL) {
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_object_unref0 (container);
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_clear_error (&_inner_error_);
#line 245 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		return;
#line 1680 "rygel-media-export-harvesting-task.c"
	}
#line 241 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (container);
#line 1684 "rygel-media-export-harvesting-task.c"
}


static gboolean rygel_media_export_harvesting_task_on_idle (RygelMediaExportHarvestingTask* self) {
	gboolean result = FALSE;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeQueue* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GError * _inner_error_ = NULL;
#line 256 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 257 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 257 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp1_ = _tmp0_;
#line 257 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp2_ = g_cancellable_is_cancelled (_tmp1_);
#line 257 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_tmp2_) {
#line 258 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		result = FALSE;
#line 260 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		return result;
#line 1713 "rygel-media-export-harvesting-task.c"
	}
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp3_ = self->priv->files;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp5_ = _tmp4_;
#line 263 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_tmp5_ > 0) {
#line 1723 "rygel-media-export-harvesting-task.c"
		GeeQueue* _tmp6_;
		gpointer _tmp7_ = NULL;
		GFile* _tmp8_;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		RygelMediaExportMetadataExtractor* _tmp11_;
		GeeQueue* _tmp12_;
		gpointer _tmp13_ = NULL;
		GFile* _tmp14_;
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp6_ = self->priv->files;
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp7_ = gee_queue_peek (_tmp6_);
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp8_ = (GFile*) _tmp7_;
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp9_ = g_file_get_uri (_tmp8_);
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp10_ = _tmp9_;
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_debug ("rygel-media-export-harvesting-task.vala:264: Scheduling file %s for me" \
"ta-data extraction…", _tmp10_);
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_free0 (_tmp10_);
#line 264 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_object_unref0 (_tmp8_);
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp11_ = self->priv->extractor;
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp12_ = self->priv->files;
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp13_ = gee_queue_peek (_tmp12_);
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp14_ = (GFile*) _tmp13_;
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		rygel_media_export_metadata_extractor_extract (_tmp11_, _tmp14_);
#line 266 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_object_unref0 (_tmp14_);
#line 1761 "rygel-media-export-harvesting-task.c"
	} else {
		GQueue* _tmp15_;
		guint _tmp16_ = 0U;
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp15_ = self->priv->containers;
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp16_ = g_queue_get_length (_tmp15_);
#line 267 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		if (_tmp16_ > ((guint) 0)) {
#line 268 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			rygel_media_export_harvesting_task_enumerate_directory (self, NULL, NULL);
#line 1773 "rygel-media-export-harvesting-task.c"
		} else {
			const gchar* _tmp17_;
			RygelMediaContainer* _tmp21_;
#line 271 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp17_ = self->priv->flag;
#line 271 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			if (_tmp17_ != NULL) {
#line 1781 "rygel-media-export-harvesting-task.c"
				{
					RygelMediaExportMediaCache* _tmp18_;
					GFile* _tmp19_;
					const gchar* _tmp20_;
#line 273 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					_tmp18_ = self->priv->cache;
#line 273 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					_tmp19_ = self->origin;
#line 273 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					_tmp20_ = self->priv->flag;
#line 273 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					rygel_media_export_media_cache_flag_object (_tmp18_, _tmp19_, _tmp20_, &_inner_error_);
#line 273 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					if (_inner_error_ != NULL) {
#line 1796 "rygel-media-export-harvesting-task.c"
						goto __catch53_g_error;
					}
				}
				goto __finally53;
				__catch53_g_error:
				{
					GError* _error_ = NULL;
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					_error_ = _inner_error_;
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					_inner_error_ = NULL;
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					_g_error_free0 (_error_);
#line 1810 "rygel-media-export-harvesting-task.c"
				}
				__finally53:
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				if (_inner_error_ != NULL) {
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					g_clear_error (&_inner_error_);
#line 272 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					return FALSE;
#line 1821 "rygel-media-export-harvesting-task.c"
				}
			}
#line 277 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp21_ = self->priv->parent;
#line 277 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			rygel_media_container_updated (_tmp21_);
#line 279 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 1830 "rygel-media-export-harvesting-task.c"
		}
	}
#line 282 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	result = FALSE;
#line 282 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	return result;
#line 1837 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_on_extracted_cb (RygelMediaExportHarvestingTask* self, GFile* file, GUPnPDLNAInformation* dlna, const gchar* mime, guint64 size, guint64 mtime) {
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeQueue* _tmp3_;
	gpointer _tmp4_ = NULL;
	GFile* entry;
	gboolean _tmp5_ = FALSE;
	GFile* _tmp6_;
	gboolean _tmp9_;
	RygelMediaItem* item = NULL;
	GUPnPDLNAInformation* _tmp10_;
	RygelMediaItem* _tmp26_;
	GeeQueue* _tmp32_;
	gpointer _tmp33_ = NULL;
	GFile* _tmp34_;
	GError * _inner_error_ = NULL;
#line 285 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_if_fail (self != NULL);
#line 285 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_if_fail (file != NULL);
#line 285 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_if_fail (mime != NULL);
#line 290 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
#line 290 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp1_ = _tmp0_;
#line 290 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp2_ = g_cancellable_is_cancelled (_tmp1_);
#line 290 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_tmp2_) {
#line 291 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 1874 "rygel-media-export-harvesting-task.c"
	}
#line 294 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp3_ = self->priv->files;
#line 294 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp4_ = gee_queue_peek (_tmp3_);
#line 294 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	entry = (GFile*) _tmp4_;
#line 295 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp6_ = entry;
#line 295 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_tmp6_ == NULL) {
#line 295 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp5_ = TRUE;
#line 1888 "rygel-media-export-harvesting-task.c"
	} else {
		GFile* _tmp7_;
		GFile* _tmp8_;
#line 295 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp7_ = file;
#line 295 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp8_ = entry;
#line 295 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp5_ = _tmp7_ != _tmp8_;
#line 1898 "rygel-media-export-harvesting-task.c"
	}
#line 295 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp9_ = _tmp5_;
#line 295 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_tmp9_) {
#line 298 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_object_unref0 (entry);
#line 298 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		return;
#line 1908 "rygel-media-export-harvesting-task.c"
	}
#line 302 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp10_ = dlna;
#line 302 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_tmp10_ == NULL) {
#line 1914 "rygel-media-export-harvesting-task.c"
		GQueue* _tmp11_;
		gconstpointer _tmp12_ = NULL;
		GFile* _tmp13_;
		const gchar* _tmp14_;
		guint64 _tmp15_;
		guint64 _tmp16_;
		RygelMediaItem* _tmp17_ = NULL;
#line 303 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp11_ = self->priv->containers;
#line 303 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp12_ = g_queue_peek_head (_tmp11_);
#line 303 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp13_ = file;
#line 303 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp14_ = mime;
#line 303 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp15_ = size;
#line 303 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp16_ = mtime;
#line 303 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp17_ = rygel_media_export_item_factory_create_simple ((RygelMediaContainer*) _tmp12_, _tmp13_, _tmp14_, _tmp15_, _tmp16_);
#line 303 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_object_unref0 (item);
#line 303 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		item = _tmp17_;
#line 1940 "rygel-media-export-harvesting-task.c"
	} else {
		GQueue* _tmp18_;
		gconstpointer _tmp19_ = NULL;
		GFile* _tmp20_;
		GUPnPDLNAInformation* _tmp21_;
		const gchar* _tmp22_;
		guint64 _tmp23_;
		guint64 _tmp24_;
		RygelMediaItem* _tmp25_ = NULL;
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp18_ = self->priv->containers;
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp19_ = g_queue_peek_head (_tmp18_);
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp20_ = file;
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp21_ = dlna;
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp22_ = mime;
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp23_ = size;
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp24_ = mtime;
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp25_ = rygel_media_export_item_factory_create_from_info ((RygelMediaContainer*) _tmp19_, _tmp20_, _tmp21_, _tmp22_, _tmp23_, _tmp24_);
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_object_unref0 (item);
#line 309 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		item = _tmp25_;
#line 1970 "rygel-media-export-harvesting-task.c"
	}
#line 317 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp26_ = item;
#line 317 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_tmp26_ != NULL) {
#line 1976 "rygel-media-export-harvesting-task.c"
		RygelMediaItem* _tmp27_;
		GQueue* _tmp28_;
		gconstpointer _tmp29_ = NULL;
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp27_ = item;
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp28_ = self->priv->containers;
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp29_ = g_queue_peek_head (_tmp28_);
#line 318 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		rygel_media_object_set_parent_ref ((RygelMediaObject*) _tmp27_, (RygelMediaContainer*) _tmp29_);
#line 1988 "rygel-media-export-harvesting-task.c"
		{
			RygelMediaExportMediaCache* _tmp30_;
			RygelMediaItem* _tmp31_;
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp30_ = self->priv->cache;
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp31_ = item;
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			rygel_media_export_media_cache_save_item (_tmp30_, _tmp31_, &_inner_error_);
#line 320 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			if (_inner_error_ != NULL) {
#line 2000 "rygel-media-export-harvesting-task.c"
				goto __catch54_g_error;
			}
		}
		goto __finally54;
		__catch54_g_error:
		{
			GError* _error_ = NULL;
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_error_ = _inner_error_;
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_inner_error_ = NULL;
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_g_error_free0 (_error_);
#line 2014 "rygel-media-export-harvesting-task.c"
		}
		__finally54:
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		if (_inner_error_ != NULL) {
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_g_object_unref0 (item);
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_g_object_unref0 (entry);
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			g_clear_error (&_inner_error_);
#line 319 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			return;
#line 2029 "rygel-media-export-harvesting-task.c"
		}
	}
#line 326 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp32_ = self->priv->files;
#line 326 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp33_ = gee_queue_poll (_tmp32_);
#line 326 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp34_ = (GFile*) _tmp33_;
#line 326 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (_tmp34_);
#line 327 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	rygel_media_export_harvesting_task_do_update (self);
#line 285 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (item);
#line 285 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (entry);
#line 2046 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_on_extractor_error_cb (RygelMediaExportHarvestingTask* self, GFile* file, GError* _error_) {
	GeeQueue* _tmp0_;
	gpointer _tmp1_ = NULL;
	GFile* entry;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_;
	gboolean _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	GeeQueue* _tmp12_;
	gpointer _tmp13_ = NULL;
	GFile* _tmp14_;
#line 330 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_if_fail (self != NULL);
#line 330 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_if_fail (file != NULL);
#line 331 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp0_ = self->priv->files;
#line 331 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp1_ = gee_queue_peek (_tmp0_);
#line 331 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	entry = (GFile*) _tmp1_;
#line 332 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp3_ = entry;
#line 332 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_tmp3_ == NULL) {
#line 332 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp2_ = TRUE;
#line 2081 "rygel-media-export-harvesting-task.c"
	} else {
		GFile* _tmp4_;
		GFile* _tmp5_;
#line 332 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp4_ = file;
#line 332 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp5_ = entry;
#line 332 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp2_ = _tmp4_ != _tmp5_;
#line 2091 "rygel-media-export-harvesting-task.c"
	}
#line 332 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp6_ = _tmp2_;
#line 332 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_tmp6_) {
#line 335 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_object_unref0 (entry);
#line 335 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		return;
#line 2101 "rygel-media-export-harvesting-task.c"
	}
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp7_ = file;
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp8_ = g_file_get_uri (_tmp7_);
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp9_ = _tmp8_;
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp10_ = _error_;
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp11_ = _tmp10_->message;
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_debug ("rygel-media-export-harvesting-task.vala:342: Skipping %s; extraction c" \
"ompletely failed: %s", _tmp9_, _tmp11_);
#line 342 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_free0 (_tmp9_);
#line 346 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp12_ = self->priv->files;
#line 346 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp13_ = gee_queue_poll (_tmp12_);
#line 346 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp14_ = (GFile*) _tmp13_;
#line 346 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (_tmp14_);
#line 347 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	rygel_media_export_harvesting_task_do_update (self);
#line 330 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (entry);
#line 2129 "rygel-media-export-harvesting-task.c"
}


/**
     * If all files of a container were processed, notify the container
     * about this and set the updating signal.
     * Reschedule the iteration and extraction
     */
static void rygel_media_export_harvesting_task_do_update (RygelMediaExportHarvestingTask* self) {
	gboolean _tmp0_ = FALSE;
	GeeQueue* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
#line 355 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_return_if_fail (self != NULL);
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp1_ = self->priv->files;
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp3_ = _tmp2_;
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_tmp3_ == 0) {
#line 2155 "rygel-media-export-harvesting-task.c"
		GQueue* _tmp4_;
		guint _tmp5_ = 0U;
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp4_ = self->priv->containers;
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp5_ = g_queue_get_length (_tmp4_);
#line 357 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp0_ = _tmp5_ != ((guint) 0);
#line 2164 "rygel-media-export-harvesting-task.c"
	} else {
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp0_ = FALSE;
#line 2168 "rygel-media-export-harvesting-task.c"
	}
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp6_ = _tmp0_;
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	if (_tmp6_) {
#line 2174 "rygel-media-export-harvesting-task.c"
		GQueue* _tmp7_;
		gconstpointer _tmp8_ = NULL;
		RygelMediaContainer* _tmp9_;
		RygelMediaContainer* container;
		GQueue* _tmp21_;
		gpointer _tmp22_ = NULL;
		RygelMediaContainer* _tmp23_;
#line 358 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp7_ = self->priv->containers;
#line 358 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp8_ = g_queue_peek_head (_tmp7_);
#line 358 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp9_ = _g_object_ref0 ((RygelMediaContainer*) _tmp8_);
#line 358 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		container = _tmp9_;
#line 2190 "rygel-media-export-harvesting-task.c"
		{
			RygelMediaExportMediaCache* _tmp10_ = NULL;
			RygelMediaExportMediaCache* cache;
			RygelMediaExportMediaCache* _tmp11_;
			RygelMediaContainer* _tmp12_;
			const gchar* _tmp13_;
			gint _tmp14_ = 0;
			gint _tmp15_;
#line 360 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp10_ = rygel_media_export_media_cache_get_default (&_inner_error_);
#line 360 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			cache = _tmp10_;
#line 360 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			if (_inner_error_ != NULL) {
#line 2205 "rygel-media-export-harvesting-task.c"
				goto __catch55_g_error;
			}
#line 361 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp11_ = cache;
#line 361 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp12_ = container;
#line 361 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp13_ = ((RygelMediaObject*) _tmp12_)->id;
#line 361 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp14_ = rygel_media_export_media_cache_get_child_count (_tmp11_, _tmp13_, &_inner_error_);
#line 361 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_tmp15_ = _tmp14_;
#line 361 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			if (_inner_error_ != NULL) {
#line 361 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_g_object_unref0 (cache);
#line 2222 "rygel-media-export-harvesting-task.c"
				goto __catch55_g_error;
			}
#line 361 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			if (_tmp15_ > 0) {
#line 2227 "rygel-media-export-harvesting-task.c"
				GQueue* _tmp16_;
				gconstpointer _tmp17_ = NULL;
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp16_ = self->priv->containers;
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp17_ = g_queue_peek_head (_tmp16_);
#line 362 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				rygel_media_container_updated ((RygelMediaContainer*) _tmp17_);
#line 2236 "rygel-media-export-harvesting-task.c"
			} else {
				RygelMediaExportMediaCache* _tmp18_;
				RygelMediaContainer* _tmp19_;
				const gchar* _tmp20_;
#line 364 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp18_ = cache;
#line 364 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp19_ = container;
#line 364 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				_tmp20_ = ((RygelMediaObject*) _tmp19_)->id;
#line 364 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				rygel_media_export_media_cache_remove_by_id (_tmp18_, _tmp20_, &_inner_error_);
#line 364 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
				if (_inner_error_ != NULL) {
#line 364 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
					_g_object_unref0 (cache);
#line 2253 "rygel-media-export-harvesting-task.c"
					goto __catch55_g_error;
				}
			}
#line 359 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_g_object_unref0 (cache);
#line 2259 "rygel-media-export-harvesting-task.c"
		}
		goto __finally55;
		__catch55_g_error:
		{
			GError* _error_ = NULL;
#line 359 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_error_ = _inner_error_;
#line 359 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_inner_error_ = NULL;
#line 359 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_g_error_free0 (_error_);
#line 2271 "rygel-media-export-harvesting-task.c"
		}
		__finally55:
#line 359 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		if (_inner_error_ != NULL) {
#line 359 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			_g_object_unref0 (container);
#line 359 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 359 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			g_clear_error (&_inner_error_);
#line 359 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
			return;
#line 2284 "rygel-media-export-harvesting-task.c"
		}
#line 367 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp21_ = self->priv->containers;
#line 367 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp22_ = g_queue_pop_head (_tmp21_);
#line 367 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_tmp23_ = (RygelMediaContainer*) _tmp22_;
#line 367 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_object_unref0 (_tmp23_);
#line 356 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		_g_object_unref0 (container);
#line 2296 "rygel-media-export-harvesting-task.c"
	}
#line 370 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _rygel_media_export_harvesting_task_on_idle_gsource_func, g_object_ref (self), g_object_unref);
#line 2300 "rygel-media-export-harvesting-task.c"
}


static GCancellable* rygel_media_export_harvesting_task_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelMediaExportHarvestingTask* self;
	GCancellable* _tmp0_;
#line 37 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	self = (RygelMediaExportHarvestingTask*) base;
#line 37 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp0_ = self->priv->_cancellable;
#line 37 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	result = _tmp0_;
#line 37 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	return result;
#line 2316 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelMediaExportHarvestingTask* self;
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
#line 37 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	self = (RygelMediaExportHarvestingTask*) base;
#line 37 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp0_ = value;
#line 37 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 37 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 37 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	self->priv->_cancellable = _tmp1_;
#line 37 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_object_notify ((GObject *) self, "cancellable");
#line 2336 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_class_init (RygelMediaExportHarvestingTaskClass * klass) {
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	rygel_media_export_harvesting_task_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_type_class_add_private (klass, sizeof (RygelMediaExportHarvestingTaskPrivate));
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_media_export_harvesting_task_get_property;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_media_export_harvesting_task_set_property;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_harvesting_task_finalize;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE, "cancellable");
#line 2353 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	rygel_media_export_harvesting_task_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	iface->run = (void (*)(RygelStateMachine*)) rygel_media_export_harvesting_task_real_run;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	iface->run_finish = rygel_media_export_harvesting_task_real_run_finish;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	iface->get_cancellable = rygel_media_export_harvesting_task_real_get_cancellable;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	iface->set_cancellable = rygel_media_export_harvesting_task_real_set_cancellable;
#line 2368 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_instance_init (RygelMediaExportHarvestingTask * self) {
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	self->priv = RYGEL_MEDIA_EXPORT_HARVESTING_TASK_GET_PRIVATE (self);
#line 2375 "rygel-media-export-harvesting-task.c"
}


static void rygel_media_export_harvesting_task_finalize (GObject* obj) {
	RygelMediaExportHarvestingTask * self;
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	self = RYGEL_MEDIA_EXPORT_HARVESTING_TASK (obj);
#line 26 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (self->origin);
#line 27 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (self->priv->extractor);
#line 28 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (self->priv->cache);
#line 29 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_queue_free0 (self->priv->containers);
#line 30 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (self->priv->files);
#line 31 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (self->priv->monitor);
#line 32 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_regex_unref0 (self->priv->file_filter);
#line 33 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_free0 (self->priv->flag);
#line 34 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (self->priv->parent);
#line 37 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	_g_object_unref0 (self->priv->_cancellable);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	G_OBJECT_CLASS (rygel_media_export_harvesting_task_parent_class)->finalize (obj);
#line 2405 "rygel-media-export-harvesting-task.c"
}


GType rygel_media_export_harvesting_task_get_type (void) {
	static volatile gsize rygel_media_export_harvesting_task_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_harvesting_task_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportHarvestingTaskClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_harvesting_task_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportHarvestingTask), 0, (GInstanceInitFunc) rygel_media_export_harvesting_task_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_media_export_harvesting_task_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_media_export_harvesting_task_type_id;
		rygel_media_export_harvesting_task_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportHarvestingTask", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_media_export_harvesting_task_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
		g_once_init_leave (&rygel_media_export_harvesting_task_type_id__volatile, rygel_media_export_harvesting_task_type_id);
	}
	return rygel_media_export_harvesting_task_type_id__volatile;
}


static void _vala_rygel_media_export_harvesting_task_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvestingTask * self;
	self = RYGEL_MEDIA_EXPORT_HARVESTING_TASK (object);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	switch (property_id) {
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		case RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE:
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		break;
#line 2434 "rygel-media-export-harvesting-task.c"
		default:
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		break;
#line 2440 "rygel-media-export-harvesting-task.c"
	}
}


static void _vala_rygel_media_export_harvesting_task_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelMediaExportHarvestingTask * self;
	self = RYGEL_MEDIA_EXPORT_HARVESTING_TASK (object);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
	switch (property_id) {
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		case RYGEL_MEDIA_EXPORT_HARVESTING_TASK_CANCELLABLE:
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		break;
#line 2456 "rygel-media-export-harvesting-task.c"
		default:
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "/home/jens/Source/rygel/src/plugins/media-export/rygel-media-export-harvesting-task.vala"
		break;
#line 2462 "rygel-media-export-harvesting-task.c"
	}
}



