/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;

import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;

/**
 * Used to store strings of glyphs with geometry and visible attribute
 * information. 
 */
public class GlyphString extends Boxed 
{
    
    /**
     * Construct a new GlyphString.
     *
     */
    public GlyphString() {
        super(pango_glyph_string_new());
    }
    
    /**
     * Construct a new GlyphString that is a copy of the
     * provided GlyphString.
     * @param glyphString
     */
    public GlyphString(GlyphString glyphString) {
        super(pango_glyph_string_copy(glyphString.getHandle()));
    }
    
    /**
     * Resizes the GlyphString to the given length.
     * @param newLength
     */
    public void setSize(int newLength) {
        pango_glyph_string_set_size(getHandle(), newLength);
    }
    
    protected void finalize() throws Throwable {
        super.finalize();
        pango_glyph_string_free(getHandle());
    }
    
    native static final protected Handle pango_glyph_string_new ();
    native static final protected void pango_glyph_string_set_size (Handle string, int newLen);
    native static final protected int pango_glyph_string_get_type ();
    native static final protected Handle pango_glyph_string_copy (Handle string);
    native static final protected void pango_glyph_string_free (Handle string);
    native static final protected void pango_glyph_string_extents (Handle glyphs, Handle font, Handle inkRect, Handle logicalRect);
    native static final protected void pango_glyph_string_extents_range (Handle glyphs, int start, int 
        end, Handle font, Handle inkRect, Handle logicalRect);
    native static final protected void pango_glyph_string_get_logical_widths (Handle glyphs, String 
        text, int length, int embeddingLevel, int [] logicalWidths);

}

