/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gtk;

import org.gnu.glib.Handle;

/**
 */
public class FileChooserButton extends HBox {
    
    /**
     * Create a new FileChooserButton
     * @param title the title of the browse dialog
     * @param action the open mode for the dialog
     */
    public FileChooserButton(String title, FileChooserAction action) {
        super(gtk_file_chooser_button_new(title, action.getValue()));
    }
    
    /**
     * Create a new FileChooserButton specifying the backend
     * @param title the title of the browse dialog
     * @param action the open mode for the dialog
     * @param backend the name of the FileSystem backend to use
     */
    public FileChooserButton(String title, FileChooserAction action, String backend) {
        super(gtk_file_chooser_button_new_with_backend(title, action.getValue(), backend));
    }
    
    /**
     * Create a new FileChooserButton which uses the specified dialog
     * as its' file picking window.
     * @param dialog
     */
    public FileChooserButton(FileChooserDialog dialog) {
        super(gtk_file_chooser_button_new_with_dialog(dialog.getHandle()));
    }
    
    /**
     * Returns the title of the browse dialog.
     */
    public String getTitle() {
        return gtk_file_chooser_button_get_title(getHandle());
    }
    
    /**
     * Modifies the title of the browse dialog.
     */
    public void setTitle(String title) {
        gtk_file_chooser_button_set_title(getHandle(), title);
    }
    
    /**
     * Retrieves the width in characters of the button widget's entry
     * and/or label.
     */
    public int getWidthChars() {
        return gtk_file_chooser_button_get_width_chars(getHandle());
    }
    
    /**
     * Sets the width in characters that the button's label will use.
     */
    public void setWidthChars(int numChars) {
        gtk_file_chooser_button_set_width_chars(getHandle(), numChars);
    }


    native static final protected int gtk_file_chooser_button_get_type ();
	native static final protected Handle gtk_file_chooser_button_new(String title, int action);
	native static final protected Handle gtk_file_chooser_button_new_with_backend(String title, int action, String backend);
	native static final protected Handle gtk_file_chooser_button_new_with_dialog(Handle dialog);
	native static final protected String gtk_file_chooser_button_get_title(Handle button);
	native static final protected void gtk_file_chooser_button_set_title(Handle button, String title);
	native static final protected int gtk_file_chooser_button_get_width_chars(Handle button);
	native static final protected void gtk_file_chooser_button_set_width_chars(Handle button, int numChars);

}
