/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;


public class Dimension{

	private int height;
	private int width;
	
	/**
	 *	Creates a new <code>Dimension</code> object with the specified width and height.
	 *
	 *	@param width the new object's width.
	 *	@param height the new object's height.
	 */
	public Dimension(int width, int height){
		if(width<0 || height<0)
			throw new IllegalArgumentException("Negative values not aloud");
		this.height=height;
		this.width=width;
	}

	/**
	 * @return the height of the <code>dimension</code> object.
	 */
	public int getHeight(){
		return height;
	}
	
	/**
	 * @return the width of the <code>dimension</code> object.
	 */
	public int getWidth(){
		return width;
	}
}
	
	
