/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.pango;
import org.gnu.glib.Flags;

/**
 * The bits in a PangoFontMask correspond to fields in a PangoFontDescription
 * that have been set.
 */
public class FontMask extends Flags 
{
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    static final private int _FAMILY = 1 << 0;
    static final public org.gnu.pango.FontMask FAMILY = new org.gnu.pango.FontMask (_FAMILY);
    static final private int _STYLE = 1 << 1;
    static final public org.gnu.pango.FontMask STYLE = new org.gnu.pango.FontMask (_STYLE);
    static final private int _VARIANT = 1 << 2;
    static final public org.gnu.pango.FontMask VARIANT = new org.gnu.pango.FontMask (_VARIANT);
    static final private int _WEIGHT = 1 << 3;
    static final public org.gnu.pango.FontMask WEIGHT = new org.gnu.pango.FontMask (_WEIGHT);
    static final private int _STRETCH = 1 << 4;
    static final public org.gnu.pango.FontMask STRETCH = new org.gnu.pango.FontMask (_STRETCH);
    static final private int _SIZE = 1 << 5;
    static final public org.gnu.pango.FontMask SIZE = new org.gnu.pango.FontMask (_SIZE);
    static final private org.gnu.pango.FontMask[] theInterned = new org.gnu.pango.FontMask[] 
    {
        new org.gnu.pango.FontMask (0), FAMILY, STYLE, new org.gnu.pango.FontMask (3), VARIANT, new 
        org.gnu.pango.FontMask (5), new org.gnu.pango.FontMask (6), new org.gnu.pango.FontMask (7), 
        WEIGHT, new org.gnu.pango.FontMask (9), new org.gnu.pango.FontMask (10), new 
        org.gnu.pango.FontMask (11), new org.gnu.pango.FontMask (12), new org.gnu.pango.FontMask (
            13), new org.gnu.pango.FontMask (14), new org.gnu.pango.FontMask (15), STRETCH, new 
        org.gnu.pango.FontMask (17), new org.gnu.pango.FontMask (18), new org.gnu.pango.FontMask (
            19), new org.gnu.pango.FontMask (20), new org.gnu.pango.FontMask (21), new 
        org.gnu.pango.FontMask (22), new org.gnu.pango.FontMask (23), new org.gnu.pango.FontMask (
            24), new org.gnu.pango.FontMask (25), new org.gnu.pango.FontMask (26), new 
        org.gnu.pango.FontMask (27), new org.gnu.pango.FontMask (28), new org.gnu.pango.FontMask (
            29), new org.gnu.pango.FontMask (30), new org.gnu.pango.FontMask (31), SIZE 
    }

;
    static private java.util.Hashtable theInternedExtras;
    static final private org.gnu.pango.FontMask theSacrificialOne = new org.gnu.pango.FontMask (0);
    static public org.gnu.pango.FontMask intern (int value) 
    {
        if (value < theInterned.length) 
        {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) 
        {
            theInternedExtras = new java.util.Hashtable();
        }
        org.gnu.pango.FontMask already = (org.gnu.pango.FontMask) theInternedExtras.get (
            theSacrificialOne);
        if (already == null) 
        {
            already = new org.gnu.pango.FontMask(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private FontMask (int value) 
    {
        value_ = value;
    }

    public org.gnu.pango.FontMask or (org.gnu.pango.FontMask other) 
    {
        return intern(value_ | other.value_);
    }

    public org.gnu.pango.FontMask and (org.gnu.pango.FontMask other) 
    {
        return intern(value_ & other.value_);
    }

    public org.gnu.pango.FontMask xor (org.gnu.pango.FontMask other) 
    {
        return intern(value_ ^ other.value_);
    }

    public boolean test (org.gnu.pango.FontMask other) 
    {
        return (value_ & other.value_) == other.value_;
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

