/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;
import org.gnu.glib.Boxed;
import org.gnu.glib.Handle;
/**
 *
 */
public class EventKey extends Boxed 
{
	public EventKey(Handle handle) {
		this.handle = handle;
	}
	
	public int getKeyVal() {
		return EventKey.getKeyval(handle);
	}
	
	public String getString() {
		return EventKey.getString(handle);
	}
	
	public int getGroup() {
		return EventKey.getGroup(handle);
	}
	
	public int getLength() {
		return EventKey.getLength(handle);
	}
	
	public int getState() {
		return EventKey.getState(handle);
	}
	
    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getType (Handle obj);
    native static final protected Handle getWindow (Handle obj);
    native static final protected boolean getSendEvent (Handle obj);
    native static final protected int getTime (Handle obj);
    native static final protected int getState (Handle obj);
    native static final protected int getKeyval (Handle obj);
    native static final protected int getLength (Handle obj);
    native static final protected String getString (Handle obj);
    native static final protected int getHardwareKeycode (Handle obj);
    native static final protected int getGroup (Handle obj);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

