/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.Type;

/**
 * MessageDialog presents a dialog with an image representing the type of 
 * message (Error, Question, etc.) alongside some message text. It's simply 
 * a convenience widget; you could construct the equivalent of 
 * MessageDialog from {@link Dialog} without too much effort, but 
 * MessageDialog saves typing.
 *
 * <p>The easiest way to do a modal message dialog is to use {@link #run()}.
 */
public class MessageDialog extends Dialog 
{
	
	/**
	 * Construct a new MessageDialog.
	 * 
	 * @param parent The parent Window of this MessageDialog.
	 * @param flags Provides initialization information for the Dialog.
	 * @param type The type of message to display.  @see MessageType
	 * @param buttons What type of buttons should be on this dialog.
	 * @param message The message to display.
	 * @param hasMarkup Does the message String contain markup?
	 */
	public MessageDialog(Window parent, DialogFlags flags, MessageType type, 
						ButtonsType buttons, String message, boolean hasMarkup) {
		super(init(parent, flags, type, buttons, message, hasMarkup));
	}
	

	private static int init(Window parent, DialogFlags flags, MessageType type, 
			ButtonsType buttons, String message, boolean hasMarkup) {
		if (hasMarkup)
			return gtk_message_dialog_new_with_markup(parent.getHandle(),
					flags.getValue(),
					type.getValue(),
					buttons.getValue(),
					message);
		else
			return gtk_message_dialog_new(parent.getHandle(),
													  flags.getValue(),
													  type.getValue(),
													  buttons.getValue(),
													  message);
	}
	
	/**
	 * Construct a MessageDialog using a handle to a native resource.
	 */
	public MessageDialog(int handle) {
	    super(handle);
	}

	public void setMarkup(String markup) {
		gtk_message_dialog_set_markup(getHandle(), markup);
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_message_dialog_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int gtk_message_dialog_get_type ();
    native static final protected int gtk_message_dialog_new (int parent, int flags, int type, int buttons, String message);
    native static final protected int gtk_message_dialog_new_with_markup(int parent, int flags, int type, int buttons, String message);
    native static final protected void gtk_message_dialog_set_markup(int mdialog, String str);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

