/*
 * Java-Gnome Bindings Library
 * 
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 * 
 * The Java-Gnome bindings library is free software distributed under the terms
 * of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

import org.gnu.glib.GObject;

/**
 */
public class FileFilter extends GObject {
	
	/**
	 *  Creates a new FileFilter with no rules added to it.  Such a filter 
	 * doesn't accept any files, so is not particularly useful until you 
	 * add rules with addMimeType() or addPattern().
 	 */
	public FileFilter() {
		if (-1 == handle) {
			handle = gtk_file_filter_new();
		}
	}
	
	/**
	 * Create a new FileFilter from a point to a native object.
	 */
	FileFilter(int hndl) {
		handle = hndl;
	}
	
	/**
	 * Sets the human readable name for the filter.  This is the string
	 * that will be displayed in the file selector user interface if there is
	 * a selectable list of filters.
	 * @param name The name of the filter.
	 */
	public void setName(String name) {
		gtk_file_filter_set_name(handle, name);
	}
	
	/**
	 * Returns the human readable name of the file filter.
	 */
	public String getName() {
		return gtk_file_filter_get_name(handle);
	}
	
	/**
	 * Adds a rule allowing a given mime type to filter.
	 */
	public void addMimeType(String mimeType) {
		gtk_file_filter_add_mime_type(handle, mimeType);
	}
	
	/**
	 * Adds a rule allowing a shell style glob to a filter.
	 */
	public void addPattern(String pattern) {
		gtk_file_filter_add_pattern(handle, pattern);
	}
	
	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gtk_file_filter_get_type ();
	native static final protected int gtk_file_filter_new();
	native static final protected void gtk_file_filter_set_name(int filter, String name);
	native static final protected String gtk_file_filter_get_name(int filter);
	native static final protected void gtk_file_filter_add_mime_type(int filter, String mimeType);
	native static final protected void gtk_file_filter_add_pattern(int filter, String pattern);
	native static final protected int gtk_file_filter_get_needed(int filter);
	native static final protected boolean gtk_file_filter_filter(int filter, int filterInfo);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
