/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;

/**
 */
public class RadioToolButton extends ToggleToolButton {
	
	public RadioToolButton(RadioToolButton[] group) {
		if (null == group)
			handle = gtk_radio_tool_button_new(null);
		else {
			int[] hndls = new int[group.length];
			for (int i = 0; i < group.length; i++) {
				hndls[i] = group[i].getHandle();
			}
			handle = gtk_radio_tool_button_new(hndls);
		}
		initializeEventHandlers();
	}

	public RadioToolButton(RadioToolButton[] group, String stockId) {
		if (null == group)
			handle = gtk_radio_tool_button_new_from_stock(null, stockId);
		else {
			int[] hndls = new int[group.length];
			for (int i = 0; i < group.length; i++) {
				hndls[i] = group[i].getHandle();
			}
			handle = gtk_radio_tool_button_new_from_stock(hndls, stockId);
		}
		initializeEventHandlers();
	}
	
	public RadioToolButton(RadioToolButton button) {
		handle = gtk_radio_tool_button_new_from_widget(button.getHandle());
		initializeEventHandlers();
	}
	
	public RadioToolButton(RadioToolButton button, String stockId) {
		handle = gtk_radio_tool_button_new_with_stock_from_widget(button.getHandle(), stockId);
		initializeEventHandlers();
	}
	
	private RadioToolButton(int hndl) {
		this.handle = hndl;
	}
	
	public RadioToolButton[] getGroup() {
		int[] hndls = gtk_radio_tool_button_get_group(handle);
		if (null == hndls)
			return null;
		RadioToolButton[] group = new RadioToolButton[hndls.length];
		for (int i = 0; i < hndls.length; i++) {
			group[i] = new RadioToolButton(hndls[i]);
		}
		return group;
	}
	
	public void setGroup(RadioToolButton[] group) {
		if (null == group)
			gtk_radio_tool_button_set_group(handle, null);
		else {
			int[] hndls = new int[group.length];
			for (int i = 0; i < group.length; i++) {
				hndls[i] = group[i].getHandle();
			}
			gtk_radio_tool_button_set_group(handle, hndls);
		}
	}
	
	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gtk_radio_tool_button_get_type();
	native static final protected int gtk_radio_tool_button_new(int[] group);
	native static final protected int gtk_radio_tool_button_new_from_stock(int[] group, String stockId);
	native static final protected int gtk_radio_tool_button_new_from_widget(int widget);
	native static final protected int gtk_radio_tool_button_new_with_stock_from_widget(int widget, String stockId);
	native static final protected int[] gtk_radio_tool_button_get_group(int button);
	native static final protected void gtk_radio_tool_button_set_group(int button, int[] group);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
	
}
