/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;

import org.gnu.glib.GObject;

/**
 */
public class Display extends GObject {

	public Display() {
		if (-1 == handle) 
			handle = gdk_display_get_default();
	}
	
	public Display(int hndl) {
		handle = hndl;
	}
	
	public static Display open(String name) {
		int hndl = gdk_display_open(name);
		return new Display(hndl);
	}
	
	public String getName() {
		return gdk_display_get_name(handle);
	}
	
	public int getNumScreens() {
		return gdk_display_get_n_screens(handle);
	}
	
	public Screen getScreen(int screenNumber) {
		return new Screen(gdk_display_get_screen(handle, screenNumber));
	}
	
	public Screen getDefaultScreen() {
		return new Screen(gdk_display_get_default_screen(handle));
	}
	
	public void ungrabPointer() {
		gdk_display_pointer_ungrab(handle, 0);
	}
	
	public void ungrabKeyboard() {
		gdk_display_keyboard_ungrab(handle, 0);
	}
	
	public boolean pointerIsGrabbed() {
		return gdk_display_pointer_is_grabbed(handle);
	}
	
	public void beep() {
		gdk_display_beep(handle);
	}
	
	public void sync() {
		gdk_display_sync(handle);
	}
	
	public void flush() {
		gdk_display_flush(handle);
	}
	
	public void close() {
		gdk_display_close(handle);
	}
	
	public Device[] listDevice() {
		int[] hndls = gdk_display_list_devices(handle);
		if (null == hndls)
			return null;
		Device[] devices = new Device[hndls.length];
		for (int i = 0; i < hndls.length; i++)
			devices[i] = new Device(hndls[i]);
		return devices;
	}

	public Device getCorePointer() {
		return new Device(gdk_display_get_core_pointer(handle));
	}
	
	public Window getWindowAtPointer() {
		return new Window(gdk_display_get_window_at_pointer(handle, 0, 0));
	}

	public boolean supportsCursorAlpha() {
		return gdk_display_supports_cursor_alpha(handle);
	}
	
	public boolean supportsCursorColor() {
		return gdk_display_supports_cursor_color(handle);
	}

	public int getDefaultCursorSize() {
		return gdk_display_get_default_cursor_size(handle);
	}
	
	/****************************************
	 * BEGINNING OF JNI CODE
	 ****************************************/
	native static final protected int gdk_display_get_type();
	native static final protected int gdk_display_open(String displayName);
	native static final protected String gdk_display_get_name(int display);
	native static final protected int gdk_display_get_n_screens(int display);
	native static final protected int gdk_display_get_screen(int display, int screenNum);
	native static final protected int gdk_display_get_default_screen(int display);
	native static final protected void gdk_display_pointer_ungrab(int display, int time);
	native static final protected void gdk_display_keyboard_ungrab(int display, int time);
	native static final protected boolean gdk_display_pointer_is_grabbed(int display);
	native static final protected void gdk_display_beep(int display);
	native static final protected void gdk_display_sync(int display);
	native static final protected void gdk_display_flush(int display);
	native static final protected void gdk_display_close(int display);
	native static final protected int[] gdk_display_list_devices(int display);
	native static final protected int gdk_display_get_event(int display);
	native static final protected int gdk_display_peek_event(int display);
	native static final protected void gdk_display_put_event(int display, int event);
	native static final protected int gdk_display_get_default();
	native static final protected int gdk_display_get_core_pointer(int display);
	native static final protected void gdk_display_get_pointer(int display, int[] screen, int[] x, int[] y, int[] modType);
	native static final protected int gdk_display_get_window_at_pointer(int display, int x, int y);
	native static final protected boolean gdk_display_supports_cursor_alpha(int display);
	native static final protected boolean gdk_display_supports_cursor_color(int display);
	native static final protected int gdk_display_get_default_cursor_size(int display);
	native static final protected void gdk_display_get_maximum_cursor_size(int display, int[] width, int[] height);
	/****************************************
	 * END OF JNI CODE
	 ****************************************/
}
